﻿// <summary>ソースコード：ツール削除画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Reflection;
using System.Collections;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSToolDeleteViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ツール削除画面クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public partial class HSToolDeleteViewerForm : Form //HySDotNetForm//Form
    {
        ///// <summary>ログ出力用クラス名称</summary>
        //static private readonly string CLASS_NAME = "HSToolDeleteViewerForm";
        /// <summary>環境情報管理クラス</summary>
        private HySEnvInf m_csEnvInf;

        /// <summary>
        /// メッセージボックスタイトル『CommoMP』
        /// </summary>
        private static readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_COMMON_MP");
        /// <summary>「削除設定済みの情報が既に有ります。設定内容を変更致しますか?」</summary>
        private static readonly string MSG_EXIST_DELETE_DATA =  Properties.HSToolDeleteViewerResources.MSG_WARNING_EXIST_DELETE_DATA;
        /// <summary>「選択したツールはCommonMP終了後削除されます。CommonMPを再起動してください。」</summary>
        private static readonly string MSG_INFO_DELETE_TOOL_AFTERREBOOT = Properties.HSToolDeleteViewerResources.MSG_INFO_DELETE_TOOL_AFTERREBOOT;

        /// <summary> プロセス起動ホームディレクトリ </summary>
        private HySString m_csHomeDirectory = null;

        private HySString ADDINTOOL_PATH = new HySString("\\SystemData\\AddinTools");

        /// <summary> 処理対象ファクトリー種別 </summary>
        private Hashtable m_csToolData = new Hashtable();

        /// <summary> XMLタグ　tools </summary>
        static public readonly string xml_TOOLS = "tools";
        /// <summary> XMLタグ　tool </summary>
        static public readonly string xml_TOOL = "tool";
        /// <summary> XMLタグ　dll </summary>
        static public readonly string xml_DLL = "dll";
        /// <summary> XMLタグ　name </summary>
        static public readonly string xml_NAME = "name";
        /// <summary> XMLタグ　package </summary>
        static public readonly string xml_PACKAGE = "package";
        /// <summary> XMLタグ　filepath </summary>
        static public readonly string xml_FILEPATH = "filepath";


        /// <summary> 削除管理コード　ファイル[F] </summary>
        static private readonly string TOOL_KIND_FILE = "[F]";


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DIConfEditorForm csDotNetForm = new DIConfEditorForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HSToolDeleteViewerForm()
        {
            InitializeComponent();

            toolTip1.SetToolTip(Delete_Button, MSG_INFO_DELETE_TOOL_AFTERREBOOT);

            m_csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            m_csEnvInf.InitializeNoLog();
            HSToolDeleteViewerProgram.StartLOG();

            //ホームディレクトリ
            m_csHomeDirectory = HySEnvInf.GetHomeDirectory();
        }

        /// <summary><para>method outline:</para>
        /// <para>インストールツール情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ReadImportToolInfo()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>インポート結果ファイルより、ツール情報を取得する</para>
        /// </remarks>
        private void ReadImportToolInfo()
        {
            int iToolNo = 0;
            // インポートツール情報ディレクトリ
            string sPath = m_csHomeDirectory.ToString() + ADDINTOOL_PATH.ToString();
            // ファイルフィルター
            string csFilter = "*.xml";

            DirectoryInfo csAddinToolDir = new DirectoryInfo(sPath);

            if (csAddinToolDir != null)//＋マークによるノード展開でデフォルトのA:\アクセス回避
            {
                if (csAddinToolDir.Exists)
                {// インストールツール管理ディレクトリ有り

                    try
                    {
                        foreach (FileInfo csFileInfo in csAddinToolDir.GetFiles(csFilter))
                        {// 全てのファイルを取得
                            HSToolInfoData csInfoData = ReadToolFileInfo(csFileInfo.DirectoryName + "\\" + csFileInfo.Name);
                            if (csInfoData != null)
                            {
                                // インポートツール情報追加
                                m_csToolData.Add(iToolNo, csInfoData);
                                Tool_List.Items.Add(csInfoData.GetToolName().ToString());
                                iToolNo++;
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        HSToolDeleteViewerProgram.ErrorLOG("HSToolDeleteViewerForm.ReadImportToolInfo", "インストールツール情報ファイル解析異常発生:" + Environment.NewLine + ex.ToString());
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール情報読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HSToolInfoData csData = ReadImportToolInfo( sFileName )</para>
        /// </example>
        /// <param name="sFileName">ファイル名称</param>
        /// <returns>ツール情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>インポート結果ファイルより、ツール情報を取得する</para>
        /// </remarks>
        private  HSToolInfoData ReadToolFileInfo(string sFileName)
        {
            HSToolInfoData csInfodate = null;

            try
            {// 
                HySXmlReader csXmlRFile = new HySXmlReader(sFileName);

                HySXmlNode csRootNode = csXmlRFile.GetRootNode();
                HySXmlNodeList csNodeList = csRootNode.GetChildNodeList();
                long lNodeListCount = csNodeList.GetCount();
                for (long lLoop = 0; lLoop < lNodeListCount; lLoop++)
                {// データ件数分処理

                    HySXmlNode csNode = csNodeList.GetNode(lLoop);

                    String csDllName = csNode.GetAttribute(xml_DLL);    // DLL名称
                    String csToolName = csNode.GetAttribute(xml_NAME);  // ツール名称
                    String csPackage = csNode.GetAttribute(xml_PACKAGE);// パッケージ展開元ファイル名

                    if (csDllName != null) 
                    {// DLL名称取得不可時は設定なし
                        if (csInfodate == null)
                        {// データ有り時にデータクラスを生成
                            csInfodate = new HSToolInfoData();
                        }

                        csInfodate.SetDllName(csDllName);
                        csInfodate.SetToolName(csToolName);
                        csInfodate.SetPackageName(csPackage);

                        HySXmlNodeList csChildNodeList = csNode.GetChildNodeList();
                        long lChildNodeListCount = csChildNodeList.GetCount();
                        for (long lCLoop = 0; lCLoop < lChildNodeListCount; lCLoop++)
                        {// データ件数分処理
                            HySXmlNode csChildNode = csChildNodeList.GetNode(lCLoop);
                            csInfodate.AddFileNameList(csChildNode.GetAttribute(xml_NAME));
                        }
                    }
                }

            }
            catch (Exception ex)
            {// 異常
                HSToolDeleteViewerProgram.ErrorLOG("HSToolDeleteViewerForm.ReadToolFileInfo", "インストールツール情報ファイル解析異常発生:" + Environment.NewLine + ex.ToString());
                return null;
            }


            return csInfodate;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>削除ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Delete_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Delete_Button_Click(object sender, EventArgs e)
        {
            List<HySString> csFileList = new List<HySString>();
            for (int iLoop = 0; iLoop < Tool_List.Items.Count; iLoop++)
            {
                //選択プロジェクト
                if (Tool_List.GetItemChecked(iLoop) == true)
                {
                    HSToolInfoData csInfoData = (HSToolInfoData)m_csToolData[iLoop];
                    if (csInfoData != null)
                    {// ファイル名積込み
                        List<HySString> csDataList = csInfoData.GetFileNameList();
                        csFileList.AddRange(csDataList);
                        HySString csDllNameWk = csInfoData.GetDllName();
                        csDllNameWk.Replace(".dll", ".xml");
                        HySString csDllName = new HySString(TOOL_KIND_FILE) + m_csHomeDirectory + ADDINTOOL_PATH + "\\" + csDllNameWk;
                        csFileList.Add(csDllName);
                    }
                }
            }

            if (csFileList.Count > 0)
            {// 情報あり
                HySString csSeveFile = m_csHomeDirectory + "\\temp\\ToolDeleteInfo.txt";
                HySFile csFile = new HySFile(csSeveFile);
                if (csFile.Exist() == true)
                {// 既に削除情報あり
                    if (MessageBox.Show(MSG_EXIST_DELETE_DATA, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Information) == DialogResult.Cancel)
                    {// キャンセルされたら、保存なし
                        return;
                    }
                }

                if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.READ_WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {// ファイルオープン成功
                    for (int iLoop = 0; iLoop < csFileList.Count; iLoop++)
                    {// ファイル数分出力
                        csFile.WriteText(csFileList[iLoop]);
                    }
                    csFile.Close();

                    // 削除対象DLL名称の設定後、再起動を促すメッセージ表示
                    MessageBox.Show(MSG_INFO_DELETE_TOOL_AFTERREBOOT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                }
                else
                {// ファイルオープン異常
                    HSToolDeleteViewerProgram.ErrorLOG("HSToolDeleteViewerForm.Delete_Button_Click", "削除情報作成に失敗しました。");
                }

                // 終了
                Close();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0006, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>終了ボタン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Close_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Button_Click(object sender, EventArgs e)
        {
            // 終了
            Close();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HSToolDeleteViewerForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //HySEnvInf.Terminate();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが表示される場合に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HSToolDeleteViewerForm_Load(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HSToolDeleteViewerForm_Load(object sender, EventArgs e)
        {
            // インポートツール情報を取得
            ReadImportToolInfo();
        }

    }
}
