﻿// <summary>ソースコード：ツール削除画面クラス(エントリ ポイント)</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSToolDeleteViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ツール削除画面プロセス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public class HSToolDeleteViewerProgram
    {

        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
        /// </remarks>
        [STAThread]
        static void Main(string[] args)
        {
            int iRtn = 0;

            // 二重起動チェックを行う。
            if (System.Diagnostics.Process.GetProcessesByName(
                System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length <= 1)
            {   // 起動されていない場合のみ起動する。
                // 地域情報をTheadにセット
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new HSToolDeleteViewerForm());
            }

            System.Environment.Exit(iRtn);
        }

        /// <summary><para>method outline:</para>
        /// <para>エラーログ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>startLOG()</para>
        /// </example>
        /// <param name="csClassNameAndMethodName">クラス及びメソッド名</param>
        /// <param name="csMsg">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void ErrorLOG(string csClassNameAndMethodName, string csMsg)
        {
            DateTime csDatatime = DateTime.Now;
            string sLogName = HySEnvInf.GetHomeDirectory().ToString() + "\\log\\HSToolDeleteViewer.log";

            HySFile csErrFile = new HySFile(sLogName);
            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            csErrFile.WriteText(csDatatime.ToString() + " <" + csClassNameAndMethodName + ">  " + csMsg);
            csErrFile.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>スタートログ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>startLOG()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void StartLOG()
        {
            string sLogName = HySEnvInf.GetHomeDirectory().ToString() + "\\log\\HSToolDeleteViewer.log";

            HySFile csErrFile = new HySFile(sLogName);
            csErrFile.Delete();

            csErrFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
            csErrFile.WriteText(DateTime.Now.ToString() + " << ツール削除画面起動 >>");
            csErrFile.Close();
        }
    }
}
