﻿// <summary>ソースコード：ツールのインポート画面クラス</summary>
// <author>CommonMP</author>using System;

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSToolImportViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ツールのインポート画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public partial class HSToolImportViewerForm : Form//HySDotNetForm
    {
        /// <summary>環境情報管理クラス</summary>
        private HySEnvInf m_csEnvInf;
        
//        /// <summary>クラス名文字列</summary>
//        static private readonly string CLASS_NAME = "HSToolImportViewerForm";

        /// <summary>アーカイブ選択画面タイトル</summary>
        static private readonly string ARCHIVE_DLG_TITLE =
            Properties.HSToolImportViewerResources.ResourceManager.GetString("FILE_DLG_TITLE_SELECT_ARCHIVE");
        /// <summary>アーカイブ選択画面フィルター</summary>
        static private readonly string ACRHIVE_DLG_FILTER =
            Properties.HSToolImportViewerResources.ResourceManager.GetString("FILE_DLG_FILTER_ARCHIVE");

        /// <summary>通常メッセージタイトル </summary>
        static private readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_COMMON_MP");
        /// <summary>メッセージ「パッケージ入力情報ファイル作成完了」</summary>
        static private readonly string MSG_COMPLETE_CREATE_TOOL_INFO_FILE = Properties.HSToolImportViewerResources.ResourceManager.GetString("MSG_INFO_RESTARTUP");

        /// <summary>メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_TOOL_INSTALL = Properties.HSToolImportViewerResources.ResourceManager.GetString("MSG_ERROR_INSTALL");

        /// <summary>上書き確認メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_TOOL_OVERWRITE = Properties.HSToolImportViewerResources.ResourceManager.GetString("MSG_ERR_TOOL_OVERWRITE");
        /// <summary>上書き確認メッセージ「ファイル名の重複通知」 </summary>
        static private readonly string MSG_STOP_TOOL_OVERWRITE = Properties.HSToolImportViewerResources.ResourceManager.GetString("MSG_STOP_TOOL_OVERWRITE");

        /// <summary>ツール上書きチェック処理関連戻り値：正常（重複無し）</summary>
        public static readonly long NO_DUPLICATE = 0;

        /// <summary>ツール上書きチェック処理関連戻り値：正常（同一名称有り）</summary>
        public static readonly long DUPLICATE_FILENAME = 1;

        /// <summary>ツール上書きチェック処理関連戻り値：異常</summary>
        public static readonly long FAILED = -1;

        /// <summary>アーカイブ内情報</summary>
        List<HySStringRoot> m_csEntryList = null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HSToolImportViewerForm form = new HSToolImportViewerForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HSToolImportViewerForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HSToolImportViewerForm()
        {
            InitializeComponent();
            Install_Button.Enabled = false;

            m_csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            m_csEnvInf.InitializeNoLog();
            HSToolImportViewerProgram.StartLOG();
        }

        /// <summary><para>method outline</para>
        /// <para>「ファイル選択」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FileSelect_Button.Click += new System.EventHandler(this.SelectFile);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFile(object sender, EventArgs e)
        {
            // アーカイブ選択画面設定
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Title = ARCHIVE_DLG_TITLE;
            openFileDialog.Filter = ACRHIVE_DLG_FILTER;
            openFileDialog.InitialDirectory = CreateSelectFolderFullPath();
            openFileDialog.RestoreDirectory = true;

            // アーカイブ選択画面表示
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                ArchiveFileFullPath_TextBox.Text = openFileDialog.FileName;
                Install_Button.Enabled = true;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「インストール」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.InstallButton.Click += new System.EventHandler(this.Install);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Install(object sender, EventArgs e)
        {
            long lRtn = NO_DUPLICATE;
            // 上書きチェック処理
            lRtn = this.CheckOverWrite();
            if (lRtn == FAILED)
            {// チェック異常発生
                DialogResult result = MessageBox.Show(MSG_ERR_TOOL_OVERWRITE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Stop, MessageBoxDefaultButton.Button1);
                if (result == DialogResult.OK)
                {// 終了
                    this.Close();
                    return;
                }
            }
            else if (lRtn == DUPLICATE_FILENAME)
            {// 重複ファイル有り
                DialogResult result = MessageBox.Show(MSG_STOP_TOOL_OVERWRITE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                if (result == DialogResult.OK)
                {// 終了
                    this.Close();
                    return;
                }
            }

            // パッケージ展開（インストール）処理
            HSToolImporter csInporter = new HSToolImporter();
            if (csInporter.Import(new HySString(HySFileUtility.FormatPath(ArchiveFileFullPath_TextBox.Text))) == 0)
            {// 正常完了
                DialogResult result = MessageBox.Show(MSG_COMPLETE_CREATE_TOOL_INFO_FILE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
            }
            else
            {// 異常終了
                DialogResult result = MessageBox.Show(MSG_ERR_TOOL_INSTALL, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
            }

            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>「キャンセル」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>選択フォルダパス作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string selectFolderPath = CreateSelectFolderFullPath()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>選択フォルダパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string CreateSelectFolderFullPath()
        {
            HySString homeDir = HySEnvInf.GetHomeDirectory();
            DirectoryInfo dirinfo = Directory.GetParent(homeDir.ToString());
            return dirinfo.ToString();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0004, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>上書きチェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckOverWrite()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// NO_DUPLICATE:重複無し
        /// DUPLICATE_LIBNAME:同一名称有り
        /// DUPLICATE_STDLIBNAME:標準ライブラリと重複有り
        /// FAILED:異常
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long CheckOverWrite()
        {
            long lRtn = NO_DUPLICATE;
            HySString csArchiveFileFullPath = new HySString(ArchiveFileFullPath_TextBox.Text);

            // Zip内情報取得
            try
            {
                HySExpander zipExpander = new HySDotNetZipExpander(csArchiveFileFullPath);
                // エントリ名取得
                m_csEntryList = zipExpander.GetAllEntryName();

                // インストール対象ファイル
//                List<HySStringRoot> csTrgetEntryList = HSToolImporter.CreateTargetEntry(m_csEntryList);
                List<HySStringRoot> csTrgetEntryList = m_csEntryList;

                HySFile csFile = null;
                // ファイル名称の重複チェック
                for (int iLp = 0; iLp < csTrgetEntryList.Count; iLp++)
                {
                    HySString entry = (HySString)csTrgetEntryList[iLp];
                    bool binResult = entry.ToString().StartsWith("bin\\");
                    bool toolIconResult = entry.ToString().StartsWith("ToolIcon\\");
                    bool toolManualResult = entry.ToString().StartsWith("ToolManual\\");
                    bool toolProjectResult = entry.ToString().StartsWith("VsToolProject\\");

                    if (binResult == true ||
                        toolIconResult == true ||
                        toolManualResult == true ||
                        toolProjectResult == true
                        )
                    {
                        if (toolProjectResult == true)
                        {
                            int iCase = entry.IndexOf("\\");
                            if (iCase > 1)
                            {
                                HySString csPathStr = new HySString();
                                entry.Substring(iCase + 1, ref csPathStr);
                                entry = new HySString("..\\Source\\HYSSOP\\AddInSysTools\\") + csPathStr;
                            }
                        }

                        csFile = new HySFile(HySEnvInf.GetHomeDirectory().ToString() + "\\" + entry.ToString());
                        if (csFile.Exist() == true)
                        {
                            // 同一名称有り
                            lRtn = DUPLICATE_FILENAME;
                            break;
                        }
                        csFile = null;
                    }
                }
            }
            catch
            {// 異常発生
                lRtn = FAILED;
            }

            return lRtn;
        }

    }
}