﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSAddinDispExcel
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアジョブクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HsAddinExcelDriveJob : HySDotNetAddInBaseJob
    {
        ///// <summary>起動されたプロセスのハンドル（例）</summary>
        //System.Diagnostics.Process m_hProcess = null;

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須メソッド</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;

            if (lCallBackNo == HysAddinExcelDriveJobDefine.SAMPLE_EXCEL_START_UP)
            {   // EXCEL起動
                string sCSVFileName = "";
                if (this.SelectCSVFile(ref sCSVFileName) == 1)
                {
                    lRtn = this.ExcelStartUp(sCSVFileName);
                }
            }
            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            //if (System.Diagnostics.Process.GetProcessesByName("HcAddInSampleApplication").Length > 0)
            //{   // 起動中のプロセスが存在する時
            //    m_hProcess.Kill(); // 強制終了
            //}
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// Terminate() による処理が終了していない場合等　false を返す。
        /// 特別な処理を必要としないならば、本メソッドは実装しなくても良い
        /// </para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            return true;
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ToDo　コールバックに対応する処理が必要な場合に処理を追加する
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★


        /// <summary><para>method outline:</para>
        /// <para>エクセル起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ExcelStartUp( sFileName ) </para>
        /// </example>
        /// <param name="sFileName">ファイル名称</param>
        /// <returns>long:0</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long ExcelStartUp(string sFileName)
        {
            HySFile csFile = new HySFile(sFileName);
            if (csFile.Exist() == true)
            {
                Process.Start(sFileName);
            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SelectCSVFile(sFileName) </para>
        /// </example>
        /// <param name="sFileName">ファイル名称</param>
        /// <returns>0 : ファイル入力無し　、1 : ファイル入力有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long SelectCSVFile(ref string sFileName)
        {
            long lRtn = 0;
            OpenFileDialog csReadFileDlg = new OpenFileDialog();

            csReadFileDlg.FileName = ".csv";
            csReadFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() + "\\";
            csReadFileDlg.Filter = Properties.HysAddinExcelDriveResource.FILE_DLG_FILTER_CSV;//"CSV(*.csv)|*.csv";
            csReadFileDlg.Title = Properties.HysAddinExcelDriveResource.FILE_DLG_TITLE_CSV;// "ＣＳＶファイル取得";
            csReadFileDlg.RestoreDirectory = true;
            if (csReadFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                sFileName = csReadFileDlg.FileName;
                lRtn = 1;
            }
            return lRtn;
        }
    }
}
