﻿// <summary>ソースコード：>ＨＹＳＳＯＰヘルプナビゲートの表示クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Resources;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>ヘルプナビゲートの表示クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class HySShowHelpNavigator : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>ナビゲート定義キー取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sKey = GetNavigatorKey(MsgCode) </para>
        /// </example>
        /// <param name="MsgCode">メッセージ定義名</param>
        /// <returns>string ナビゲート定義キー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public string GetNavigatorKey(HySString MsgCode)
        {
            string sKey = null;

            try
            {
                sKey = Properties.HySHelpKeyResources.ResourceManager.GetString(MsgCode.ToString());
            }
            catch
            {
                return null;
            }
            return sKey;
        }

        /// <summary><para>method outline:</para>
        /// <para>ヘルプナビゲートの表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowHelpNavigator(MsgCode,csParent) </para>
        /// </example>
        /// <param name="MsgCode">メッセージ定義名</param>
        /// <param name="csParent">メインフレームＭＤＩ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void ShowHelpNavigator(HySString MsgCode, Control csParent)
        {
            string skey = GetNavigatorKey(MsgCode); //ナビゲート定義キー取得
            if (skey != null && skey.Length > 0)
            {  // ナビゲート定義キーが有る場合
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("OPERATION_MANUAL_FILENAME"));
                HelpNavigator csNavi = HelpNavigator.KeywordIndex;
                //Help.ShowHelp(csParent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString(), csNavi, skey);
                // 画面コントロールを指定した場合、自分（this）だと、ヘルプが最上位になるので常に新しいコントロールとする。
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString(), csNavi, skey);
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString(), csNavi, skey);
            }
        }

        // =====================================
        // start of クラス内 定数定義
        // =====================================
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－共通）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0001 = new HySString("NAV_MSG_PROJECT_0001");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－新規作成）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0002 = new HySString("NAV_MSG_PROJECT_0002");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－登録）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0003 = new HySString("NAV_MSG_PROJECT_0003");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－検索画面）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0004 = new HySString("NAV_MSG_PROJECT_0004");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－検索結果一覧画面）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0005 = new HySString("NAV_MSG_PROJECT_0005");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－パラメータ設定画面）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0006 = new HySString("NAV_MSG_PROJECT_0006");
// Ver1.1 追加 >>>        
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－新規作成(ファイル形式用)）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0007 = new HySString("NAV_MSG_PROJECT_0007");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－保存）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0008 = new HySString("NAV_MSG_PROJECT_0008");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－ポータブルデータ作成）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0009 = new HySString("NAV_MSG_PROJECT_0009");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－ポータブルデータ取込）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0010 = new HySString("NAV_MSG_PROJECT_0010");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－データフォルダー格納先設定）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0011 = new HySString("NAV_MSG_PROJECT_0011");
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－ファイル名指定）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0012 = new HySString("NAV_MSG_PROJECT_0012");
// Ver1.1 追加 <<<
// Ver1.5 追加 >>>
        /// <summary>ナビゲート定義名一覧（プロジェクト管理－プロジェクトプロパティ）</summary>
        static public readonly HySString NAV_MSG_PROJECT_0013 = new HySString("NAV_MSG_PROJECT_0013");
// Ver1.5 追加 <<<
        /// <summary>ナビゲート定義名一覧（ライブラリィ管理－共通）</summary>
        static public readonly HySString NAV_MSG_LIBRARY_0001 = new HySString("NAV_MSG_LIBRARY_0001");
        /// <summary>ナビゲート定義名一覧（ライブラリィ管理－ライブラリ入力）</summary>
        static public readonly HySString NAV_MSG_LIBRARY_0002 = new HySString("NAV_MSG_LIBRARY_0002");
        /// <summary>ナビゲート定義名一覧（ライブラリィ管理－ライブラリ出力）</summary>
        static public readonly HySString NAV_MSG_LIBRARY_0003 = new HySString("NAV_MSG_LIBRARY_0003");
        /// <summary>ナビゲート定義名一覧（モデル管理－共通）</summary>
        static public readonly HySString NAV_MSG_MODEL_0001 = new HySString("NAV_MSG_MODEL_0001");
        /// <summary>ナビゲート定義名一覧（モデル管理－パラメータ設定画面（グループ））</summary>
        static public readonly HySString NAV_MSG_MODEL_0002 = new HySString("NAV_MSG_MODEL_0002");
        /// <summary>ナビゲート定義名一覧（モデル管理－セル型モデルプロパティ詳細設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0003 = new HySString("NAV_MSG_MODEL_0003");
        /// <summary>ナビゲート定義名一覧（モデル管理－パラメータ設定画面（セル型モデル））</summary>
        static public readonly HySString NAV_MSG_MODEL_0004 = new HySString("NAV_MSG_MODEL_0004");
        /// <summary>ナビゲート定義名一覧（モデル管理－伝送情報内セル識別設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0005 = new HySString("NAV_MSG_MODEL_0005");
        /// <summary>ナビゲート定義名一覧（モデル管理－カスタマイズ画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0006 = new HySString("NAV_MSG_MODEL_0006");
        /// <summary>ナビゲート定義名一覧（モデル管理－モデル管理ガイドマップ画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0007 = new HySString("NAV_MSG_MODEL_0007");
        /// <summary>ナビゲート定義名一覧（モデル管理－パラメータ設定画面（汎用））</summary>
        static public readonly HySString NAV_MSG_MODEL_0008 = new HySString("NAV_MSG_MODEL_0008");
        /// <summary>ナビゲート定義名一覧（モデル管理－モデル管理ツリー画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0009 = new HySString("NAV_MSG_MODEL_0009");
        /// <summary>ナビゲート定義名一覧（モデル管理－セル型伝送情報結線画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0010 = new HySString("NAV_MSG_MODEL_0010");
        /// <summary>ナビゲート定義名一覧（モデル管理－パラメータ設定画面（セル型伝送情報））</summary>
        static public readonly HySString NAV_MSG_MODEL_0011 = new HySString("NAV_MSG_MODEL_0011");
        /// <summary>ナビゲート定義名一覧（モデル管理－GIS伝送データプロパティ画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0012 = new HySString("NAV_MSG_MODEL_0012");
        /// <summary>ナビゲート定義名一覧（モデル管理－伝送データプロパティ画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0013 = new HySString("NAV_MSG_MODEL_0013");
        /// <summary>ナビゲート定義名一覧（モデル管理－時系列任意入力計算結果モニター画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0014 = new HySString("NAV_MSG_MODEL_0014");
        /// <summary>ナビゲート定義名一覧（モデル管理－時系列任意入力計算結果モニター画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_MODEL_0015 = new HySString("NAV_MSG_MODEL_0015");
        /// <summary>ナビゲート定義名一覧（モデル管理－時系列ハイドロ／ハイエト計算結果モニター画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0016 = new HySString("NAV_MSG_MODEL_0016");
        /// <summary>ナビゲート定義名一覧（モデル管理－時系列ハイドロ／ハイエト計算結果モニター画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_MODEL_0017 = new HySString("NAV_MSG_MODEL_0017");
        /// <summary>ナビゲート定義名一覧（モデル管理－1次元配列縦断データ入力計算結果モニター画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0018 = new HySString("NAV_MSG_MODEL_0018");
        /// <summary>ナビゲート定義名一覧（モデル管理－1次元配列縦断データ入力計算結果モニター画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_MODEL_0019 = new HySString("NAV_MSG_MODEL_0019");
        /// <summary>ナビゲート定義名一覧（モデル管理－データマージモデルプロパティ詳細設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0020 = new HySString("NAV_MSG_MODEL_0020");
        /// <summary>ナビゲート定義名一覧（モデル管理－データマージモデル出力情報編集画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0021 = new HySString("NAV_MSG_MODEL_0021");
        /// <summary>ナビゲート定義名一覧（モデル管理－CSV時系列ファイル入力要素プロパティ詳細設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0022 = new HySString("NAV_MSG_MODEL_0022");
        /// <summary>ナビゲート定義名一覧（モデル管理－CSV時系列ファイル出力要素プロパティ詳細設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0023 = new HySString("NAV_MSG_MODEL_0023");
        /// <summary>ナビゲート定義名一覧（モデル管理－ＧＩＳ２次元メッシュ時系列ファイル出力プロパティ詳細設定）</summary>
        static public readonly HySString NAV_MSG_MODEL_0024 = new HySString("NAV_MSG_MODEL_0024");
// Ver1.4 追加 >>>        
        /// <summary>ナビゲート定義名一覧（モデル管理－CSV時系列ファイルマージ出力要素プロパティ詳細設定画面）</summary>
        static public readonly HySString NAV_MSG_MODEL_0025 = new HySString("NAV_MSG_MODEL_0025");
// Ver1.4 追加 <<<
        /// <summary>ナビゲート定義名一覧（評価画面－検索条件設定画面－汎用）</summary>
        static public readonly HySString NAV_MSG_REPORT_0001 = new HySString("NAV_MSG_REPORT_0001");
        /// <summary>ナビゲート定義名一覧（評価画面－検索条件設定画面－ＧＩＳ）</summary>
        static public readonly HySString NAV_MSG_REPORT_0002 = new HySString("NAV_MSG_REPORT_0002");
        /// <summary>ナビゲート定義名一覧（評価画面－検索結果選択画面－汎用）</summary>
        static public readonly HySString NAV_MSG_REPORT_0003 = new HySString("NAV_MSG_REPORT_0003");
        /// <summary>ナビゲート定義名一覧（評価画面－検索結果選択画面－ＧＩＳ）</summary>
        static public readonly HySString NAV_MSG_REPORT_0004 = new HySString("NAV_MSG_REPORT_0004");
        /// <summary>ナビゲート定義名一覧（評価画面－カスタマイズ画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0005 = new HySString("NAV_MSG_REPORT_0005");
        /// <summary>ナビゲート定義名一覧（汎用評価画面－基本画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0006 = new HySString("NAV_MSG_REPORT_0006");
        /// <summary>ナビゲート定義名一覧（汎用評価画面－基本画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_REPORT_0007 = new HySString("NAV_MSG_REPORT_0007");
        /// <summary>ナビゲート定義名一覧（特定評価画面－ハイドロ／ハイエトグラフ画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0008 = new HySString("NAV_MSG_REPORT_0008");
        /// <summary>ナビゲート定義名一覧（特定評価画面－ハイドロ／ハイエトグラフ画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_REPORT_0009 = new HySString("NAV_MSG_REPORT_0009");
        /// <summary>ナビゲート定義名一覧（特定評価画面－一次元縦断データ画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0010 = new HySString("NAV_MSG_REPORT_0010");
        /// <summary>ナビゲート定義名一覧（特定評価画面－一次元縦断データ画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_REPORT_0011 = new HySString("NAV_MSG_REPORT_0011");
        /// <summary>ナビゲート定義名一覧（特定評価画面－Ｈ－Ｑ曲線図画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0012 = new HySString("NAV_MSG_REPORT_0012");
        /// <summary>ナビゲート定義名一覧（特定評価画面－Ｈ－Ｑ曲線図画面－テーブル）</summary>
        static public readonly HySString NAV_MSG_REPORT_0013 = new HySString("NAV_MSG_REPORT_0013");
        /// <summary>ナビゲート定義名一覧（特定評価画面－ハイドロ／ハイエトグラフ画面－検索条件設定画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0014 = new HySString("NAV_MSG_REPORT_0014");
        /// <summary>ナビゲート定義名一覧（特定評価画面－ハイドロ／ハイエトグラフ画面－検索結果選択画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0015 = new HySString("NAV_MSG_REPORT_0015");
        /// <summary>ナビゲート定義名一覧（特定評価画面－ハイドロ／ハイエトグラフ画面－1次元配列セル選択画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0016 = new HySString("NAV_MSG_REPORT_0016");
        /// <summary>ナビゲート定義名一覧（特定評価画面－一次元縦断データ画面－簡易高速アニメーション画面）</summary>
        static public readonly HySString NAV_MSG_REPORT_0017 = new HySString("NAV_MSG_REPORT_0017");
        /// <summary>ナビゲート定義名一覧（定期河川縦横断データ管理－データ取得画面）</summary>
        static public readonly HySString NAV_MSG_RSD_0001 = new HySString("NAV_MSG_RSD_0001");
        /// <summary>ナビゲート定義名一覧（定期河川縦横断データ管理－データ再取得画面）</summary>
        static public readonly HySString NAV_MSG_RSD_0002 = new HySString("NAV_MSG_RSD_0002");
        /// <summary>ナビゲート定義名一覧（定期河川縦横断データ管理－データ検索画面）</summary>
        static public readonly HySString NAV_MSG_RSD_0003 = new HySString("NAV_MSG_RSD_0003");
        /// <summary>ナビゲート定義名一覧（定期河川縦横断データ管理－データ検索結果画面）</summary>
        static public readonly HySString NAV_MSG_RSD_0004 = new HySString("NAV_MSG_RSD_0004");
        /// <summary>ナビゲート定義名一覧（統一河川システム接続）</summary>
        static public readonly HySString NAV_MSG_JPRIVER_0001 = new HySString("NAV_MSG_JPRIVER_0001");
        /// <summary>ナビゲート定義名一覧（統一河川システム接続－期間指定削除画面）</summary>
        static public readonly HySString NAV_MSG_JPRIVER_0002 = new HySString("NAV_MSG_JPRIVER_0002");
        /// <summary>ナビゲート定義名一覧（統一河川システム接続－年月日指定削除画面）</summary>
        static public readonly HySString NAV_MSG_JPRIVER_0003 = new HySString("NAV_MSG_JPRIVER_0003");
        /// <summary>ナビゲート定義名一覧（モデルジェネレータ－モデルデータ生成制御画面）</summary>
        static public readonly HySString NAV_MSG_MODELGEN_0001 = new HySString("NAV_MSG_MODELGEN_0001");
        /// <summary>ナビゲート定義名一覧（モデルジェネレータ－固定長データ入力画面）</summary>
        static public readonly HySString NAV_MSG_MODELGEN_0002 = new HySString("NAV_MSG_MODELGEN_0002");
        /// <summary>ナビゲート定義名一覧（モデルジェネレータ－可変長データ入力画面）</summary>
        static public readonly HySString NAV_MSG_MODELGEN_0003 = new HySString("NAV_MSG_MODELGEN_0003");
        /// <summary>ナビゲート定義名一覧（モデルジェネレータ－モデル用データファイル設定画面）</summary>
        static public readonly HySString NAV_MSG_MODELGEN_0004 = new HySString("NAV_MSG_MODELGEN_0004");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－河川・流域データ取得画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0001 = new HySString("NAV_MSG_RWD_0001");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－ファイル一覧画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0002 = new HySString("NAV_MSG_RWD_0002");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－ID選択画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0003 = new HySString("NAV_MSG_RWD_0003");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－CommonMP標準形式ファイル出力画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0004 = new HySString("NAV_MSG_RWD_0004");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－河道データセット番号選択画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0005 = new HySString("NAV_MSG_RWD_0005");
        /// <summary>ナビゲート定義名一覧（河川流域ＤＢ接続－モデル番号選択画面）</summary>
        static public readonly HySString NAV_MSG_RWD_0006 = new HySString("NAV_MSG_RWD_0006");
        /// <summary>ナビゲート定義名一覧（ツール管理(アセンブリ設定)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0001 = new HySString("NAV_MSG_TOOL_0001");
        /// <summary>ナビゲート定義名一覧（ツール管理(メニュー設定)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0002 = new HySString("NAV_MSG_TOOL_0002");
        /// <summary>ナビゲート定義名一覧（メニューの追加と編集画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0003 = new HySString("NAV_MSG_TOOL_0003");
// Ver1.3 追加 >>>        
        /// <summary>ナビゲート定義名一覧（ツール管理(ツールのインストール)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0004 = new HySString("NAV_MSG_TOOL_0004");
        /// <summary>ナビゲート定義名一覧（ツール管理(ツールのパッケージ化)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0005 = new HySString("NAV_MSG_TOOL_0005");
        /// <summary>ナビゲート定義名一覧（ツール管理(ツールの削除)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0006 = new HySString("NAV_MSG_TOOL_0006");
        /// <summary>ナビゲート定義名一覧（ツール管理(ランチャー)画面）</summary>
        static public readonly HySString NAV_MSG_TOOL_0007 = new HySString("NAV_MSG_TOOL_0007");
        // Ver1.3 追加 <<<
    }
}
