﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ユーザー組み込み用ビューア内制御基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2010/10/10][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetAddInBaseJob : HySDotNetViewerJob
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetViewerJob csViewerJob = new McDotNetViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetAddInBaseJob()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
        }


        /// <summary><para>method outline:</para>
        /// <para>スクリーン生成ファクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreenFactory スクリーンファクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySScreenFactory GetScreenFactory()
        {
            return this.m_csScreenFactory;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必要ならば派生側でオーバーライドする</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            //Do Nothing;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            //Do Nothing;
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreen( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreen(HySScreen csScreen)
        {
            csScreen.SetViewerJob(this);
            base.SetScreen(csScreen);
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールの起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void StartTool()
        {
            // Do Nothing;
            // 派生側にて実装のこと
        }

    }
}
