﻿// <summary>ソースコード：スクリーン基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ユーザーアドイン用スクリーン基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/10][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetAddInBaseScreen : HySDotNetScreen
    {
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> なし </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリークを防ぐため</para>
        /// </remarks>
        ~HySDotNetAddInBaseScreen()
        {
            if (m_csHysFormObj != null)
            {
            // 下記処理を入れると、終了時に異常終了する
            //    if (m_csHysFormObj is HySDotNetAddInBaseForm)
            //    {
            //        ((HySDotNetAddInBaseForm)m_csHysFormObj).MdiParent = null;
            //    }
            }
            m_csHysFormObj = null;  // メモリーリークを防ぐため、自変数はnullクリアしておく
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            if ( (m_csHysFormObj is HySDotNetAddInBaseForm) &&
                 (m_csDotNetVeiewer is HySDotNetViewer) )
            {
                ((HySDotNetAddInBaseForm)m_csHysFormObj).MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            // Do Nothing
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            /* Do Nothing
            HySEventObject csEvObj = csEvent as HySEventObject;
            if (csEvObj != null)
            {
                long lEvNo = csEvObj.GetEventNo();
                long lSubEvNo = csEvObj.GetSubEventNo();
            }
            */
            return bRtn;
        }
        
        /*
        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            return true;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csHysFormObj is HySDotNetAddInBaseForm)
            {
                ((HySDotNetAddInBaseForm)m_csHysFormObj).Show();
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            try
            {
                if (m_csHysFormObj is HySDotNetAddInBaseForm)
                {
                    ((HySDotNetAddInBaseForm)m_csHysFormObj).Close();
                }
                if (m_csVJob is HySDotNetAddInBaseJob)
                {
                    ((HySDotNetAddInBaseJob)m_csVJob).DeleteScreen(this);
                }
            }
            catch( Exception ex )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySDotNetAddInBaseScreen", "CloseScreen", 
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, "HySDotNetAddInBaseScreen", "CloseScreen", "Catch Exception " + ex.Message);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            if (m_csHysFormObj is HySDotNetAddInBaseForm)
            {
                ((HySDotNetAddInBaseForm)m_csHysFormObj).Hide();
            }
        } 

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            if (m_csHysFormObj is HySDotNetAddInBaseForm)
            {
                ((HySDotNetAddInBaseForm)m_csHysFormObj).WindowState = FormWindowState.Normal;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            if (m_csHysFormObj is HySDotNetAddInBaseForm)
            {
                ((HySDotNetAddInBaseForm)m_csHysFormObj).Activate();
            }
        }
    }
}
