﻿// <summary>ソースコード：評価用表示関連画面フォームファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>評価用表示関連画面フォームファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispViewFormFactory : HySFactoryMono, HySViewFormFactory
    {
        /// <summary> 業務種別識別子  </summary>
        protected HySKind m_csSimKind = HySDefine.COMMON_DISP_BUSIPROCEDURE;

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Init(HySFactoryMng csFactoryMng)
        {
            base.Init(csFactoryMng);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKind = csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }


        /// <summary><para>method outline:</para>
        /// <para>画面フォームクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewForm csViewFrom = CreateViewForm( csSimKind,csID,csFormKind ) </para>
        /// </example>
        /// <param name="csSimKind">業務種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csFormKind">画面種別</param>
        /// <returns>HySViewForm 画面フォームクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 同じ画面識別子を使う場合は「最初に親となるキーの判定」を実施してから各配下画面識別子の判定を行うこと。</para>
        /// </remarks>
        virtual public HySViewForm CreateViewForm(HySKind csSimKind, HySIdentifier csID, HySKind csFormKind)
        {
            HySViewForm csRtnForm = null;

            string sFormGrKind = csFormKind.ToString(); // 画面識別子を文字変換
            if (csSimKind.Equals(m_csSimKind) == true)
            {  // 業務種別識別子の場合
                if (sFormGrKind.Contains(HySDefine.DISP_FORM_MONITER.ToString()) == true)
                {  // 計算結果モニタ表示グループの場合
                    if (sFormGrKind.Equals(HySDefine.DISP_FORM_MONITER.ToString()) == true)
                    {  // 基準フォームの場合
                        csRtnForm = new HySDotNetMoniterBaseForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_SERIAL.ToString()) == true)
                    {  // ポイント時系列汎用計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.LINE_GRAPH_D1_CELL_SERIAL.ToString()) == true)
                    {  // １次元配列時系列汎用計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL.ToString()) == true)
                    {  // ポイント時系列ハイエト（雨量）計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterHydroHyetoForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.HYETO_GRAPH_SINGLE_CELL_SERIAL.ToString()) == true)
                    {  // ポイント時系列ハイドロ（流量）計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterHydroHyetoForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.HYETO_GRAPH_D1_CELL_SERIAL.ToString()) == true)
                    {  // １次元配列時系列ハイドロ（流量）計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterHydroHyetoForm();
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.RIVERBED_SHAPE_SINGLE_CELL_SERIAL.ToString()) == true)
                    {  // ポイント時系列縦断データ計算結果モニタ表示の場合
                    }
                    else if (sFormGrKind.Equals(HySMoniterScreen.RIVERBED_SHAPE_D1_CELL_SERIAL.ToString()) == true)
                    {  // １次元配列時系列縦断データ計算結果モニタ表示の場合
                        csRtnForm = new HySDotNetMoniterRiverbedForm();
                    }
                }
                else if (sFormGrKind.Contains(HySDefine.DISP_FORM_SEARCH_CONDITION.ToString()) == true)
                {  // 検索条件設定グループ表示の場合
                    if (sFormGrKind.Equals(HySSearchConditionScreen.LINE_GRAPH_REPORT.ToString()) == true)
                    {  // 基本画面の場合
                        csRtnForm = new HySDotNetSearchConditionForm();
                    }
                    if (sFormGrKind.Equals(HySSearchConditionScreen.HYDRO_HYETO_GRAPH_REPORT.ToString()) == true)
                    {  // ハイドロ／ハイエトグラフの場合
                        csRtnForm = new HySDotNetSearchConditionHydroHyetoForm();
                    }
                    if (sFormGrKind.Equals(HySSearchConditionScreen.RIVERBED_SHAPE_REPORT.ToString()) == true)
                    {  // １次元配列縦断データ表示の場合
                        csRtnForm = new HySDotNetSearchConditionForm();
                    }
                    if (sFormGrKind.Equals(HySSearchConditionScreen.HQ_GRAPH_REPORT.ToString()) == true)
                    {  // Ｈ－Ｑ曲線図の場合
                        csRtnForm = new HySDotNetSearchConditionForm();
                    }
                    if (sFormGrKind.Equals(HySSearchConditionScreen.EXCEL_REPORT.ToString()) == true)
                    {  // Ｅｘｃｅｌの場合
                        csRtnForm = new HySDotNetSearchConditionForm();
                    }
                    if (sFormGrKind.Equals(HySSearchConditionScreen.GIS2D_MESH_REPORT.ToString()) == true)
                    {  // 地図上２次元メッシュ表示の場合
                        csRtnForm = new HySDotNetSearchConditionGISForm();
                    }
                }
                else if (sFormGrKind.Contains(HySDefine.DISP_FORM_RESULT_SELECTION.ToString()) == true)
                {  // 検索結果選択グループ表示の場合
                    if (sFormGrKind.Equals(HySResultSelectionScreen.LINE_GRAPH_REPORT.ToString()) == true)
                    {  // 基本画面の場合
                        csRtnForm = new HySDotNetResultSelectionForm();
                    }
                    if (sFormGrKind.Equals(HySResultSelectionScreen.HYDRO_HYETO_GRAPH_REPORT.ToString()) == true)
                    {  // ハイドロ／ハイエトグラフの場合
                        csRtnForm = new HySDotNetResultSelectionHydroHyetoForm();
                    }
                    if (sFormGrKind.Equals(HySResultSelectionScreen.RIVERBED_SHAPE_REPORT.ToString()) == true)
                    {  // １次元配列縦断データ表示の場合
                        csRtnForm = new HySDotNetResultSelectionForm();
                    }
                    if (sFormGrKind.Equals(HySResultSelectionScreen.HQ_GRAPH_REPORT.ToString()) == true)
                    {  // Ｈ－Ｑ曲線図の場合
                        csRtnForm = new HySDotNetResultSelectionForm();
                    }
                    if (sFormGrKind.Equals(HySResultSelectionScreen.EXCEL_REPORT.ToString()) == true)
                    {  // Ｅｘｃｅｌの場合
                        csRtnForm = new HySDotNetResultSelectionForm();
                    }
                    if (sFormGrKind.Equals(HySResultSelectionScreen.GIS2D_MESH_REPORT.ToString()) == true)
                    {  // 地図上２次元メッシュ表示の場合
                        csRtnForm = new HySDotNetResultSelectionGISForm();
                    }
                }
                else if (sFormGrKind.Contains(HySDefine.DISP_FORM_GRAPH_CUSTOMIZ.ToString()) == true)
                {  // グラフカスタマイズ表示グループの場合
                    if (sFormGrKind.Equals(HySGraphCustomizScreen.LINE_GRAPH_REPORT.ToString()) == true)
                    {  // 基本画面の場合
                        //csRtnForm = new HySDotNetReportCustomizForm();
                    }
                    if (sFormGrKind.Equals(HySGraphCustomizScreen.HYDRO_HYETO_GRAPH_REPORT.ToString()) == true)
                    {  // ハイドロ／ハイエトグラフの場合
                        //csRtnForm = new HySDotNetReportCustomizForm();
                    }
                    if (sFormGrKind.Equals(HySGraphCustomizScreen.RIVERBED_SHAPE_REPORT.ToString()) == true)
                    {  // １次元配列縦断データ表示の場合
                        //csRtnForm = new HySDotNetReportCustomizForm();
                    }
                    if (sFormGrKind.Equals(HySGraphCustomizScreen.HQ_GRAPH_REPORT.ToString()) == true)
                    {  // Ｈ－Ｑ曲線図の場合
                        //csRtnForm = new HySDotNetReportCustomizForm();
                    }
                }
                else if (sFormGrKind.Equals(HySDefine.DISP_FORM_LINE_GRAPH.ToString()) == true)
                {  // 基本画面の場合
                    //csRtnForm = new HySDotNetGenLineGraphForm();
                }
                else if (sFormGrKind.Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.ToString()) == true)
                {  // ハイドロ／ハイエトグラフの場合
                    //csRtnForm = new HySDotNetHydroHyetoForm();
                }
                else if (sFormGrKind.Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()) == true)
                {  // １次元配列縦断データ表示の場合
                    //csRtnForm = new HySDotNetRiverbedForm();
                }
                else if (sFormGrKind.Equals(HySDefine.DISP_FORM_HQ_GRAPH.ToString()) == true)
                {  // Ｈ－Ｑ曲線図の場合
                    //csRtnForm = new HySDotNetHQForm();
                }
                else if (sFormGrKind.Equals(HySDotNetViewerDefine.GIS_RESULT_CTL_SCREEN.ToString()) == true)
                {
                    csRtnForm = new HySGISResultDispCtlForm();
                }
            }
            return csRtnForm;
        }
    }
}
