﻿// <summary>ドットネットビューア生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>評価用表示関連スクリーンクラス生成ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispViewScreenFactory : HySDispScreenFactory
    {
              
        /// <summary><para>method outline:</para>
        /// <para>評価用表示関連スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimKind">業務種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>HySScreen スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySScreen CreateScreen(HySKind csSimKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csRtnScreen = base.CreateScreen(csSimKind, csID, csScreenKind);
            if (csRtnScreen == null)
            {
                if (csSimKind.Equals(m_csSimKind) == true)
                {  // 業務種別識別子の場合
                    if (HySDotNetViewerDefine.GIS_RESULT_CTL_SCREEN.Equals(csScreenKind) == true)
                    { // SAMPLE_SCREEN を作成する必要があるならば、
                        csRtnScreen = new HySGISResultDispCtlScreen();
                    }
                    else
                    {
                    }
                }
            }
            return csRtnScreen;
        }
    }
}
