﻿// <summary>評価用表示関連ビューア生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>評価用表示関連ビューア内処理ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispViewerJobFactory : HySFactoryMono ,HySViewerJobFactory
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySViewerJobFactory csFactory = new HySDispViewerJobFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispViewerJobFactory 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispViewerJobFactory()
        {
            SetFactoryID(HySDefine.FACTORY_ID_DISP_BUSI_VIEWRJOB);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetSimKind()
        {
            return HySDefine.COMMON_DISP_BUSIPROCEDURE;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualSimKind(HySKind csSimKindID)
        {
            return HySDefine.COMMON_DISP_BUSIPROCEDURE.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューアジョブクラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>HySViewerJob ビューアクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySViewerJob CreateViewerJob(HySIdentifier csID)
        {
            HySViewerJob csJob = new HySDispViewerJob();
            csJob.SetSimKind(this.GetSimKind());

            return csJob;
        }
    }
}
