﻿// <summary>ソースコード：ＧＩＳ専用検索結果選択画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Collections;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSDBA;

using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ専用検索結果選択画面表示フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetResultSelectionGISForm : HySReportSearchFormBase
    {
        //定数定義
        /// <summary>画面幅調整値</summary>
        static private readonly int FORM_WIDTH_DEFAULT = 360;
        /// <summary>画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_ADJUSTED_VALUE = 428;
        /// <summary>画面配置デスクトップ座標X</summary>
        static private readonly int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 310;
		/// <summary>演算データ検索中メッセージ『演算結果検索中です。』</summary>
		 static public readonly string RESULT_DATA_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.RESULT_DATA_BEING_PROCESSED_MSG;
		/// <summary>ＧＩＳデータ検索中メッセージ『ＫＭＬ保存処理中です。』</summary>
		static public readonly string GIS_DATA_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.GIS_DATA_BEING_PROCESSED_MSG;
		/// <summary>永久保存処理中メッセージ『永久保存処理中です。』</summary>
		static public readonly string PERMANENT_PRESERVATION_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.PERMANENT_PRESERVATION_BEING_PROCESSED_MSG;
		///<summary>検索結果の選択メッセージ『検索結果を選択してください。』</summary>
		static public readonly string SELECTION_GUIDANCE_MSG1 = HysMessage.GetString("HYS_MSG_WARNING_SELECT_RESULT");
		/// <summary>検索結果の選択メッセージ『データ種別が外部データ以外の検索結果を選択してください。』</summary>
		static public readonly string SELECTION_GUIDANCE_MSG2 = HysMessage.GetString("HYS_MSG_WARNING_SELECT_OTHER_RESULT");
		/// <summary>検索結果の選択メッセージ『永久保存欄のチェックボックスを選択／解除してください。』 </summary>
		static public readonly string SELECTION_GUIDANCE_MSG3 = HysMessage.GetString("HYS_MSG_WARNING_CHANGE_CHECKBOX");
		///<summary>メッセージボックスタイトル『演算結果表示機能』</summary>
		static public readonly string OPERATION_ERROR_MSG = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");
        /// <summary>名称入力画面タイトル</summary>
        static public readonly string FILE_DLG_TITLE = Properties.HysDotNetViewerResources.FILE_DLG_TITLE_SAVE; //"名前を付けて保存"
		/// <summary>処理中フォームタイトル『演算結果表示機能』</summary>
		static public readonly string PROCESSING_FORM_TITLE = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewFormBaseIF csResultSelectionForm = new HySDotNetResultSelectionGISForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetResultSelectionGISForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetResultSelectionGISForm()
        {
            InitializeComponent();
            m_csIDList = new ArrayList();
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetResultSelectionGISForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetResultSelectionGISForm_Load(object sender, EventArgs e)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>表示データ編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TableListDsp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableListDsp()
        {
            int iLp, iLp1;

            HySString csTrue = new HySString("true");
            ResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            ResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            ResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            ResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            ResultDataGridView.RowCount = 0;

            if (m_csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                long lCnt = m_csStockDataList.GetCount();
                ResultDataGridView.RowCount = (int)lCnt; // 一覧表行数設定
                for (iLp = 0; iLp < (int)lCnt; iLp++)
                {  // リスト数分繰り返す
                    bool bExternalflg = false;
                    long lP = (long)iLp;
                    m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                    if (m_csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        String csID = m_csStockData.GetID().GetString().ToString();
                        this.ResultDataGridView["DataID", iLp].Value = csID; // ユニークデータ識別子設定
                        HySObjectKind csSimKind = m_csStockData.GetSimKind();
                        if (csSimKind is HySObjectKind)
                        {  // シミュレーター種別が有る場合
                            this.ResultDataGridView["SimulatorType", iLp].Value = csSimKind.GetString().ToString();  // シミュレーター種別
                        }
                        HySID csSimID = m_csStockData.GetSimID();
                        if (csSimID is HySID)
                        {  // シミュレーターＩＤが有る場合
                            this.ResultDataGridView["ProjectID", iLp].Value = csSimID.GetString().ToString();    // シミュレーターＩＤ
                        }
                        HySID csPointID = m_csStockData.GetPointID();
                        if (csPointID is HySID)
                        {  // データ地点ＩＤが有る場合
                            this.ResultDataGridView["DataPointID", iLp].Value = csPointID.GetString().ToString();  // データ地点ＩＤ
                        }
                        HySObjectKind csDataKind = m_csStockData.GetDataKind();
                        if (csDataKind is HySObjectKind)
                        {  // データの種別が有る場合
                            bool bFlag = false;
                            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                            {  // 表示業務管理データが有る場合
                                for (iLp1 = 0; iLp1 < HySDataKindDefine.m_GISDataKindList.GetLength(0); iLp1++)
                                {  // データ種別数分繰り返す
                                    if (csDataKind.Equals(HySDataKindDefine.m_GISDataKindList[iLp1]) == true)
                                    {  // データ種別が一致の場合
                                        this.ResultDataGridView["DataKind", iLp].Value = HySDataKindDefine.m_DataKindNameList[iLp1].ToString();
                                        bFlag = true;
                                        break;
                                    }
                                }
                            }
                            if (bFlag == false)
                            {  // 外部データの種別検索の場合
                                for (iLp1 = 0; iLp1 < HySDispDefine.SEARCHDATA_TYPE.GetLength(0); iLp1++)
                                {  // データ種別数分繰り返す
                                    if (csDataKind.Equals(HySDispDefine.SEARCHDATA_TYPE[iLp1, 0]) == true)
                                    {  // データ種別が一致の場合
                                        switch (iLp1)
                                        {
                                            case 0: // 演算結果データ
                                                break;
                                            case 1: // 外部データ
                                                this.ResultDataGridView["DataKind", iLp].Value = HySDispDefine.SEARCHDATA_TYPE[iLp1, 1].ToString();
                                                bExternalflg = true;
                                                break;
                                            default: // その他
                                                break;
                                        }
                                    }
                                }
                            }
                        }
                        // その他の検索キー取得
                        long lKeyNum = 0;
                        HySDataHashTable csKeyInfo = m_csStockData.GetKeyInfo(ref lKeyNum);
                        if (lKeyNum > 0)
                        {  // その他検索キーがある場合
                            if (csKeyInfo[HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE] != null)
                            {  // 演算実施日が有る場合
                                this.ResultDataGridView["SpecificationPeriod", iLp].Value =
                                    HySCalendar.GetString((HySTime)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_EXEC_DATE], HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                            {  // ロットＩＤが有る場合
                                this.ResultDataGridView["LotID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME] != null)
                            {  // プロジェクト名が有る場合
                                this.ResultDataGridView["ProjectName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID] != null)
                            {  // 要素ＩＤが有る場合
                                this.ResultDataGridView["ElementID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO] != null)
                            {  // 演算結果連番が有る場合
                                this.ResultDataGridView["SerialNumber", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT] != null)
                            {  // 件名が有る場合
                                this.ResultDataGridView["Subject", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION] != null)
                            {  // ケース名が有る場合
                                this.ResultDataGridView["CaseName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET] != null)
                            {  // 対象が有る場合
                                this.ResultDataGridView["Object", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE] != null)
                            {  // モデルが有る場合
                                this.ResultDataGridView["ModelName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE] != null)
                            {  // 種別が有る場合
                                this.ResultDataGridView["Type", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["Manager", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["DataType", iLp].Value = ((HySKind)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE]).ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["DataDim1", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1]).m_lValue.ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["DataDim2", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2]).m_lValue.ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["DataDim3", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3]).m_lValue.ToString();
                            }
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME] != null)
                            {  // 管理者が有る場合
                                this.ResultDataGridView["ElementName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME]).ToString();
                            }
                        }

                        HySString csSaveName = m_csStockData.GetSaveName();
                        if (csSaveName is HySString)
                        {  // 名称が有る場合
                            this.ResultDataGridView["SaveName", iLp].Value = csSaveName.ToString();             // 名称
                        }
                        HySTime csRegisertTime = m_csStockData.GetRegisertTime();
                        if (csRegisertTime is HySTime)
                        {  // データ登録日時が有る場合
                            this.ResultDataGridView["RegisertTime", iLp].Value =
                                //HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString(); // データ登録日時
                            if (this.ResultDataGridView["SpecificationPeriod", iLp].Value == null ||
                                this.ResultDataGridView["SpecificationPeriod", iLp].Value.ToString() == "")
                            {
                                this.ResultDataGridView["SpecificationPeriod", iLp].Value =
                                    //HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                    HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString(); // データ登録日時
                            }
                        }
                        HySString csRemarks = m_csStockData.GetRemark();
                        if (csRemarks is HySString)
                        {  // 備考が有る場合
                            this.ResultDataGridView["Remarks", iLp].Value = csRemarks.ToString();              // 備考
                        }
                        if (bExternalflg == false)
                        {  // データ種別が外部データ以外の場合
                            HySStockData.PeservedPeriod csPreservedPeriod = m_csStockData.GetPeservedPeriod();
                            if (csPreservedPeriod == HySStockData.PeservedPeriod.Temporary)
                            {  // 保存期限区分が一時保存の場合
                                this.ResultDataGridView["PermanentRepositoryFlag", iLp].Value = false;
                            }
                            else
                            {  // 保存期限区分が永久保存の場合
                                this.ResultDataGridView["PermanentRepositoryFlag", iLp].Value = true;
                            }
                        }
                        else
                        {  // データ種別が外部データの場合
                            this.ResultDataGridView["PermanentRepositoryFlag", iLp].ReadOnly = true;
                        }
                        if (m_csIDList is ArrayList)
                        {  // 選択データ識別キーリストが有る場合
                            if (((HySString)m_csIDList[iLp]).Equal(csTrue) == true)
                            {  // 選択状態の場合
                                this.ResultDataGridView["DisplayCheckFlag", iLp].Value = true;     // 選択状態設定
                            }
                            else
                            {  // 未選択状態の場合
                                this.ResultDataGridView["DisplayCheckFlag", iLp].Value = false;    // 未選択状態設定
                            }
                            this.ResultDataGridView["OrgPosition", iLp].Value = iLp.ToString(); // 検索一覧元ポジション設定
                        }
                    }
                }
            }

            for (iLp = 0; iLp < ResultDataGridView.RowCount; iLp++)
            {  // 行数分繰り返す
                if (ResultDataGridView.Rows[iLp].Visible == true)
                {  // 可視行の場合
                    if (ResultDataGridView["PermanentRepositoryFlag", iLp].Value != null)
                    {  // 保存期間が有効な場合
                        int iRowNum = iLp;
                        bool bVflg = true;
                        string sLotID = (string)ResultDataGridView["LotID", iLp].Value;
                        for (iLp1 = iLp + 1; iLp1 < ResultDataGridView.RowCount; iLp1++)
                        {  // 行数分繰り返す
                            if (ResultDataGridView.Rows[iLp1].Visible == true)
                            {  // 可視行の場合
                                if (ResultDataGridView["LotID", iLp1].Value != null)
                                {  // ロットＩＤが有効な場合
                                    if (((string)ResultDataGridView["LotID", iLp1].Value).Equals(sLotID) == true)
                                    {  // 同じロットＩＤの場合
                                        if ((bool)ResultDataGridView["DisplayCheckFlag", iLp1].Value == true)
                                        {  // 選択行の場合
                                            if (bVflg == false)
                                            {  // 既に設定済み
                                                ResultDataGridView.Rows[iLp1].Visible = false;
                                            }
                                            else
                                            {  // 設定未済み
                                                ResultDataGridView.Rows[iLp1].Visible = true;
                                                bVflg = false;
                                            }
                                        }
                                        else
                                        {  // 選択行以外の場合
                                            ResultDataGridView.Rows[iLp1].Visible = false;
                                        }
                                    }
                                }
                            }
                        }
                        ResultDataGridView.Rows[iLp].Visible = bVflg;
                    }
                }
            }

            ResultDataGridView.CurrentCell = null;
            ResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            ResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }

        /// <summary><para>method outline:</para>
        /// <para>データ種別選択用の複写データ編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClonTableListEdit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ClonTableListEdit()
        {
            int iLp, iLp1;

            ClonResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            ClonResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            ClonResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            ClonResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            ClonResultDataGridView.RowCount = ResultDataGridView.RowCount;
            for (iLp = 0; iLp < ResultDataGridView.RowCount; iLp++)
            {
                for (iLp1 = 0; iLp1 < ResultDataGridView.ColumnCount; iLp1++)
                {
                    ClonResultDataGridView[iLp1, iLp].Value = ResultDataGridView[iLp1, iLp].Value;
                }
                ClonResultDataGridView.Rows[iLp].Visible = false;
            }
            for (iLp = 0; iLp < ClonResultDataGridView.RowCount; iLp++)
            {
                if ((bool)ClonResultDataGridView["ClonDisplayCheckFlag", iLp].Value == true)
                {  // 選択行の場合
                    if (ClonResultDataGridView["ClonLotID", iLp].Value != null)
                    {  // ロットＩＤが有効な場合
                        ClonResultDataGridView.Rows[iLp].Visible = true;
                        string sLotID = (string)ClonResultDataGridView["ClonLotID", iLp].Value;
                        for (iLp1 = 0; iLp1 < ClonResultDataGridView.RowCount; iLp1++)
                        {  // 行数分繰り返す
                            if (ClonResultDataGridView["ClonLotID", iLp1].Value != null)
                            {  // ロットＩＤが有効な場合
                                if (((string)ClonResultDataGridView["ClonLotID", iLp1].Value).Equals(sLotID) == true)
                                {  // 同じロットＩＤの場合
                                    ClonResultDataGridView.Rows[iLp1].Visible = true;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            ClonResultDataGridView.CurrentCell = null;
            ClonResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            ClonResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }

        /// <summary><para>method outline:</para>
        /// <para>データ種別選択用のデータ選択反映表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResultDataKindListDsp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ResultDataKindListDsp()
        {
            int iLp;

            ResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            ResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            ResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            ResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            for (iLp = 0; iLp < ClonResultDataGridView.RowCount; iLp++)
            {  // 行数分繰り返す
                string sDataID = (string)ClonResultDataGridView["ClonDataID", iLp].Value;
                for (int iLp1 = 0; iLp1 < ResultDataGridView.RowCount; iLp1++)
                {
                    if (((string)ResultDataGridView["DataID", iLp1].Value).Equals(sDataID) == true)
                    {  // 同じデータ識別子の場合
                        ResultDataGridView["DisplayCheckFlag", iLp1].Value = ClonResultDataGridView["ClonDisplayCheckFlag", iLp].Value;
                        ResultDataGridView.Rows[iLp1].Visible = true;
                        break;
                    }
                }
            }
            for (iLp = 0; iLp < ResultDataGridView.RowCount; iLp++)
            {  // 行数分繰り返す
                if (ResultDataGridView.Rows[iLp].Visible == true)
                {  // 可視行の場合
                    if (ResultDataGridView["PermanentRepositoryFlag", iLp].Value != null)
                    {  // 保存期間が有効な場合
                        int iRowNum = iLp;
                        bool bVflg = true;
                        string sLotID = (string)ResultDataGridView["LotID", iLp].Value;
                        for (int iLp1 = iLp + 1; iLp1 < ResultDataGridView.RowCount; iLp1++)
                        {  // 行数分繰り返す
                            if (ResultDataGridView.Rows[iLp1].Visible == true)
                            {  // 可視行の場合
                                if (ResultDataGridView["LotID", iLp1].Value != null)
                                {  // ロットＩＤが有効な場合
                                    if (((string)ResultDataGridView["LotID", iLp1].Value).Equals(sLotID) == true)
                                    {  // 同じロットＩＤの場合
                                        if ((bool)ResultDataGridView["DisplayCheckFlag", iLp1].Value == true)
                                        {  // 選択行の場合
                                            if (bVflg == false)
                                            {  // 既に設定済み
                                                ResultDataGridView.Rows[iLp1].Visible = false;
                                            }
                                            else
                                            {  // 設定未済み
                                                ResultDataGridView.Rows[iLp1].Visible = true;
                                                bVflg = false;
                                            }
                                        }
                                        else
                                        {  // 選択行以外の場合
                                            ResultDataGridView.Rows[iLp1].Visible = false;
                                        }
                                    }
                                }
                            }
                        }
                        ResultDataGridView.Rows[iLp].Visible = bVflg;
                    }
                }
            }
            ResultDataGridView.CurrentCell = null;
            ResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            ResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }

        /// <summary><para>method outline:</para>
        /// <para>データ種別選択用の複写データ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClonTableListDsp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ClonTableListDsp()
        {
            ClonResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            ClonResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            ClonResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            ClonResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            for (int iLp = 0; iLp < ResultDataGridView.RowCount; iLp++)
            {  // 行数分繰り返す
                string sDataID = (string)ResultDataGridView["DataID", iLp].Value;
                for (int iLp1 = 0; iLp1 < ClonResultDataGridView.RowCount; iLp1++)
                {
                    if (((string)ClonResultDataGridView["ClonDataID", iLp1].Value).Equals(sDataID) == true)
                    {  // 同じデータ識別子の場合
                        ClonResultDataGridView["ClonDisplayCheckFlag", iLp1].Value = ResultDataGridView["DisplayCheckFlag", iLp].Value;
                        ClonResultDataGridView.Rows[iLp1].Visible = false;
                        if ((bool)ClonResultDataGridView["ClonDisplayCheckFlag", iLp1].Value == true)
                        {  // 選択行の場合
                            if (this.ResultDataGridView["LotID", iLp].Value != null)
                            {  // ロットＩＤが有効な場合
                                ClonResultDataGridView.Rows[iLp1].Visible = true;
                            }
                        }
                    }
                }
            }
            ClonResultDataGridView.CurrentCell = null;
            ClonResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            ClonResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Renew()
        {
            // ボタン非活性化
            this.SearchSelectButton.Enabled = false;
            this.CloseButton.Enabled = false;
            this.KMLButton.Enabled = false;
            this.PermanentButton.Enabled = false;

            this.TableListDsp(); // テーブルリスト編集
            this.ClonTableListEdit(); // テーブルリスト編集

            // ボタン活性化
            this.SearchSelectButton.Enabled = true;
            this.CloseButton.Enabled = true;
            this.KMLButton.Enabled = true;
            this.PermanentButton.Enabled = true;
        }


        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // 初期配置情報初期化
            iWidth_Default = FORM_WIDTH_DEFAULT;
            iHeight_Adjusted = FORM_HEIGHT_ADJUSTED_VALUE;
            iLocattion_X = DESKTOP_LOCATION_X;
            iLocattion_Y = DESKTOP_LOCATION_Y;
            base.Initialize();   // 初期化
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            HySString csFalse = new HySString("false");
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer;
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    ArrangementCorrection(m_csContainer, this); // 描画位置補正
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                    if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        m_csIDList = m_csDBPCtlInfo.GetIDList() as ArrayList;
                        if (m_csIDList is ArrayList)
                        {  // 選択リストが有効な場合
                            for (int iLp = 0; iLp < m_csIDList.Count; iLp++)
                            {
                                m_csIDList[iLp] = csFalse; // 未選択設定
                            }
                        }
                    }
                    m_csStockDataList = m_csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS) as HySStockDataList;
                }
                ((HySScreenBase)m_csScreen).RenewScreen();
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示の場合
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 画面表示更新指示の場合
                    if (m_csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                        if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            m_csIDList = m_csDBPCtlInfo.GetIDList() as ArrayList;
                        }
                        m_csStockDataList = m_csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS) as HySStockDataList;
                    }
                    ((HySScreenBase)m_csScreen).RenewScreen(); // 表示更新
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_BUSY)
                {  // 検索中通知の場合はボタン非活性化
                    this.SearchSelectButton.Enabled = false;
                    this.CloseButton.Enabled = false;
                    this.KMLButton.Enabled = false;
                    this.PermanentButton.Enabled = false;
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_COMPLET)
                {  // 検索完了通知の場合はボタン活性化
                    this.DeleteBeingProcessingMesseage();
                    this.SearchSelectButton.Enabled = true;
                    this.CloseButton.Enabled = true;
                    this.KMLButton.Enabled = true;
                    this.PermanentButton.Enabled = true;
                }
                else
                {  // 画面表示更新指示以外の場合
                    base.EventCallback(csEvent);
                }
            }
            else
            {  // 画面一般指示以外の場合
                base.EventCallback(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Arrangement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Arrangement()
        {
            // 画面サイズにあわせて表示サイズ決定
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);
            this.Width = iWidth_Default;
            this.Height = rect.Height - iHeight_Adjusted;
            this.StartPosition = FormStartPosition.Manual;
            this.SetDesktopLocation(iLocattion_X, iLocattion_Y);
            this.WindowState = FormWindowState.Normal;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>再表示要求処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReDispButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReDispButton_Click(object sender, EventArgs e)
        {
            bool bOnFlg = false;
            if (m_csIDList is ArrayList)
            {  // 選択データ識別キーリストが有る場合
                for (int iLp = 0; iLp < this.ResultDataGridView.RowCount; iLp++)
                {  // 行数分繰り返す
                    HySString csDt = new HySString("false");
                    if ((bool)this.ResultDataGridView["DisplayCheckFlag", iLp].Value == true)
                    {  // 選択状態の場合
                        csDt = new HySString("true");
                        bOnFlg = true;
                    }
                    int iPosition = int.Parse((string)this.ResultDataGridView["OrgPosition", iLp].Value);
                    m_csIDList[iPosition] = csDt;
                }
            }
            if (bOnFlg == true)
            {  // 演算結果選択が有る場合
                this.PutEvent(HySEventObject.CMND_DISPLY_COMMON, HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST);
				this.CreateBeingProcessingMesseage(PROCESSING_FORM_TITLE, RESULT_DATA_BEING_PROCESSED_MSG);
            }
            else
            {  // 演算結果選択が無い場合
				MessageBox.Show(SELECTION_GUIDANCE_MSG1, OPERATION_ERROR_MSG, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            m_csScreen.CloseScreen();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックボックス選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ResultDataGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ResultDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0 && e.ColumnIndex == 0)
            {  // 表示選択またはＫＭＬ出力選択の場合
                if (this.ResultDataGridView["DisplayCheckFlag", e.RowIndex].Value != null)
                {  // 選択状態が有効な場合
                    bool bFlg = ((bool)this.ResultDataGridView["DisplayCheckFlag", e.RowIndex].Value == true) ? false : true;
                    this.ResultDataGridView.BeginEdit(false);
                    for (int iLp = 0; iLp < this.ResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        if (this.ResultDataGridView["DisplayCheckFlag", iLp].Value != null)
                        {  // 選択状態の場合
                            this.ResultDataGridView["DisplayCheckFlag", iLp].Value = false;
                        }
                    }
                    if (bFlg == true)
                    {  // 選択の場合
                        this.ResultDataGridView["DisplayCheckFlag", e.RowIndex].Value = bFlg;
                        if (this.ResultDataGridView["PermanentRepositoryFlag", e.RowIndex].Value != null)
                        {  // 保存期間が有効な場合
                            string sLotID = (string)this.ResultDataGridView["LotID", e.RowIndex].Value;
                            for (int iLp = 0; iLp < this.ResultDataGridView.RowCount; iLp++)
                            {  // 行数分繰り返す
                                if (this.ResultDataGridView["LotID", iLp].Value != null)
                                {  // 同じロットＩＤの場合
                                    if (((string)this.ResultDataGridView["LotID", iLp].Value).Equals(sLotID) == true)
                                    {  // 同じロットＩＤの場合
                                        if (e.RowIndex != iLp)
                                        {  // 今回操作行以外の場合
                                            this.ResultDataGridView["DisplayCheckFlag", iLp].Value = bFlg;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    this.ResultDataGridView.EndEdit();
                }
                ClonTableListDsp(); // データ種別の表示更新
            }
            else if (e.RowIndex >= 0 && e.ColumnIndex == 12)
            {  // 保存期間の場合
                if (this.ResultDataGridView["PermanentRepositoryFlag", e.RowIndex].Value != null)
                {  // 保存期間が有効な場合
                    bool bFlg = ((bool)this.ResultDataGridView["PermanentRepositoryFlag", e.RowIndex].Value == true) ? false : true;
                    string sLotID = (string)this.ResultDataGridView["LotID", e.RowIndex].Value;
                    this.ResultDataGridView.BeginEdit(false);
                    for (int iLp = 0; iLp < this.ResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        if (this.ResultDataGridView["LotID", iLp].Value != null)
                        {  // 同じロットＩＤの場合
                            if (((string)this.ResultDataGridView["LotID", iLp].Value).Equals(sLotID) == true)
                            {  // 同じロットＩＤの場合
                                if (e.RowIndex != iLp)
                                {  // 今回操作行以外の場合
                                    this.ResultDataGridView["PermanentRepositoryFlag", iLp].Value = bFlg;
                                }
                            }
                        }
                    }
                    this.ResultDataGridView.EndEdit();
                }
            }
            else
            {  // その他
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックボックス選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClonResultDataGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ClonResultDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0 && e.ColumnIndex == 0)
            {  // 表示選択の場合
                if (this.ClonResultDataGridView["ClonDisplayCheckFlag", e.RowIndex].Value != null)
                {  // 選択状態が有効な場合
                    bool bFlg = ((bool)this.ClonResultDataGridView["ClonDisplayCheckFlag", e.RowIndex].Value == true) ? false : true;
                    this.ClonResultDataGridView.BeginEdit(false);
                    this.ClonResultDataGridView["ClonDisplayCheckFlag", e.RowIndex].Value = bFlg;
                    this.ClonResultDataGridView.EndEdit();
                }
                bool bChkFlg = false;
                for (int iLp = 0; iLp < ClonResultDataGridView.RowCount; iLp++)
                {  // 行数分繰り返す
                    if ((bool)ClonResultDataGridView["ClonDisplayCheckFlag", iLp].Value == true)
                    {  // 選択行の場合
                        bChkFlg = true;
                        break;
                    }
                }
                if (bChkFlg == false)
                {  // 選択行が無い場合
                    for (int iLp = 0; iLp < ClonResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        ClonResultDataGridView.Rows[iLp].Visible = false;
                    }
                }
                ResultDataKindListDsp(); // データ種別の表示更新
            }
            else
            {  // その他
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＫＭＬ保存処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>KMLButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void KMLButton_Click(object sender, EventArgs e)
        {
            bool bOnFlg = false;
            if (m_csIDList is ArrayList)
            {  // 選択データ識別キーリストが有る場合
                for (int iLp = 0; iLp < this.ResultDataGridView.RowCount; iLp++)
                {  // 行数分繰り返す
                    if (this.ResultDataGridView["DisplayCheckFlag", iLp].Value != null)
                    {  // 選択状態が有効な場合
                        if ((bool)this.ResultDataGridView["DisplayCheckFlag", iLp].Value == true)
                        {  // 選択状態の場合
                            if (this.ResultDataGridView["DataKind", iLp].Value.ToString() != HySDispDefine.SEARCHDATA_TYPE[1, 1].ToString())
                            {  // 外部データ以外の場合
                                bOnFlg = true;
                                if (m_csIDList is ArrayList)
                                {  // 選択データ識別キーリストが有る場合
                                    for (int iLp1 = 0; iLp1 < this.ResultDataGridView.RowCount; iLp1++)
                                    {  // 行数分繰り返す
                                        HySString csDt = new HySString("false");
                                        if ((bool)this.ResultDataGridView["DisplayCheckFlag", iLp1].Value == true)
                                        {  // 選択状態の場合
                                            csDt = new HySString("true");
                                        }
                                        int iPosition = int.Parse((string)this.ResultDataGridView["OrgPosition", iLp1].Value);
                                        m_csIDList[iPosition] = csDt;
                                    }
                                }
                                SaveFileDialog csSaveFileDlg = new SaveFileDialog();
                                csSaveFileDlg.FileName = ".kml";
                                csSaveFileDlg.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString() + "\\temp\\";
                                csSaveFileDlg.Filter = "KML(*.kml)|*.kml";
                                csSaveFileDlg.Title = FILE_DLG_TITLE;
                                csSaveFileDlg.RestoreDirectory = true;
                                if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
                                {  // ファイル名入力が完了の場合
                                    if (csSaveFileDlg.FileName.Length > 0)
                                    {  // 名称入力が有る場合
                                        HySString csKMLName = new HySString(csSaveFileDlg.FileName);
                                        HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                                        csEventObj.SetToSimKind(m_csScreen.GetSimKind());
                                        csEventObj.SetSuppID((HySID)m_csScreen.GetID());
                                        csEventObj.SetData(this.GetViewKind());
                                        csEventObj.SetSubEventNo(HySDispDefine.NOTICE_KML_OUTPUT_REQUEST);
                                        csEventObj.SetSubData(csKMLName);
                                        m_csScreen.PutEvent(csEventObj);
										this.CreateBeingProcessingMesseage(PROCESSING_FORM_TITLE, GIS_DATA_BEING_PROCESSED_MSG);
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
            if (bOnFlg == false)
            {  // 入力が無い場合はメッセージを出力する
				MessageBox.Show(SELECTION_GUIDANCE_MSG2, OPERATION_ERROR_MSG, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>永久保存処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PermanentButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PermanentButton_Click(object sender, EventArgs e)
        {
            bool ChkFlg = false;

            if (m_csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                long lCnt = ResultDataGridView.RowCount;
                for (int iLp = 0; iLp < lCnt; iLp++)
                {  // リスト数分繰り返す
                    long lP = long.Parse((string)ResultDataGridView["OrgPosition", iLp].Value);
                    m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                    if (m_csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        if (this.ResultDataGridView["PermanentRepositoryFlag", iLp].Value != null)
                        {  // 保存期間が有効な場合
                            if ((bool)this.ResultDataGridView["PermanentRepositoryFlag", iLp].Value == true)
                            {  // 永久保存状態の場合
                                if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Eternity)
                                {  // 保存期間変更有りの場合
                                    m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Eternity);
                                    ChkFlg = true;
                                }
                            }
                            else
                            {  // 一時保存状態の場合
                                if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Temporary)
                                {  // 保存期間変更有りの場合
                                    m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
                                    ChkFlg = true;
                                }
                            }
                        }
                    }
                }
            }
            if (ChkFlg == true)
            {  // 永久保存リストが有る場合
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetToSimKind(m_csScreen.GetSimKind());
                csEventObj.SetSuppID((HySID)m_csScreen.GetID());
                csEventObj.SetData(this.GetViewKind());
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST);
                m_csScreen.PutEvent(csEventObj);
				this.CreateBeingProcessingMesseage(PROCESSING_FORM_TITLE, PERMANENT_PRESERVATION_BEING_PROCESSED_MSG);
            }
            else
            {   // 永久保存リストが無い場合
				MessageBox.Show(SELECTION_GUIDANCE_MSG3, OPERATION_ERROR_MSG, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);

            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_REPORT_0004,
                        ((HySDotNetViewer)((HySResultSelectionScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetResultSelectionGISForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetResultSelectionGISForm_Activated(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }
    }
}