﻿// <summary>ソースコード：ハイドロ／ハイエトグラフ検索結果選択画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Collections;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSDBA;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ハイドロ／ハイエトグラフ検索結果選択画面クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetResultSelectionHydroHyetoForm : HySReportSearchFormBase
    {
        //定数定義
        /// <summary>画面幅調整値</summary>
        static private readonly int FORM_WIDTH_DEFAULT = 360;
        /// <summary>画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_ADJUSTED_VALUE = 421;
        /// <summary>画面配置デスクトップ座標X</summary>
        static private readonly int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 539;
        /// <summary>演算データ検索中メッセージ『演算結果検索中です。』</summary>
		static public readonly string RESULT_DATA_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.RESULT_DATA_BEING_PROCESSED_MSG;
		/// <summary>永久保存処理中メッセージ『永久保存中です。』</summary>
		static public readonly string PERMANENT_PRESERVATION_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.PERMANENT_PRESERVATION_BEING_PROCESSED_MSG;
		/// <summary>メッセージ『検索結果を選択してください。』</summary>
        static public readonly string SELECTION_GUIDANCE_MSG1 = HysMessage.GetString("HYS_MSG_WARNING_SELECT_RESULT");
        /// <summary>メッセージ『データ種別が外部データ以外の検索結果を選択してください。』</summary>
        static public readonly string SELECTION_GUIDANCE_MSG2 = HysMessage.GetString("HYS_MSG_WARNING_SELECT_OTHER_RESULT");
        /// <summary>メッセージ『永久保存欄のチェックボックスを選択/解除してください。』</summary>
        static public readonly string SELECTION_GUIDANCE_MSG3 = HysMessage.GetString("HYS_MSG_WARNING_CHANGE_CHECKBOX");
        /// <summary>エラー区分</summary>
        static public readonly string OPERATION_ERROR_MSG = "操作エラー";
        /// <summary> メッセージタイトル『演算結果表示機能』 </summary>
        static public readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");
        /// <summary>名称入力画面タイトル</summary>
        static public readonly string FILE_DLG_TITLE = Properties.HysDotNetViewerResources.FILE_DLG_TITLE_SAVE; //"名前を付けて保存"
        /// <summary>処理中フォームタイトル『演算結果表示機能』</summary>
        static public readonly string PROCESSING_FORM_TITLE = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewFormBaseIF csResultSelectionForm = new HySDotNetResultSelectionHydroHyetoForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetResultSelectionHydroHyetoForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetResultSelectionHydroHyetoForm()
        {
            InitializeComponent();
            m_csIDList = new ArrayList();
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetResultSelectionHydroHyetoForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetResultSelectionHydroHyetoForm_Load(object sender, EventArgs e)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>表示データ編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RainFallTableListDsp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RainFallTableListDsp()
        {
            int iLp = 0;
            int iLp1 = 0;

            HySString csTrue = new HySString("true");
            RainFallResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            RainFallResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            RainFallResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            RainFallResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            RainFallResultDataGridView.RowCount = 0;

            if (m_csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                long lCnt = m_csStockDataList.GetCount();
                for (long lP = 0; lP < lCnt; lP++)
                {  // リスト数分繰り返す
                    bool bExternalflg = false;
                    m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                    if (m_csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        HySObjectKind csDataKind = m_csStockData.GetDataKind();
                        if (csDataKind is HySObjectKind)
                        {  // データの種別が有る場合
                            bool bFlag = false;
                            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                            {  // 表示業務管理データが有る場合
                                if (csDataKind.Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true)
                                {  // データ種別が一致の場合
                                    this.RainFallResultDataGridView.Rows.Add(1); // 行追加
                                    iLp = this.RainFallResultDataGridView.Rows.Count - 1;
                                    this.RainFallResultDataGridView["RainFallDataKind", iLp].Value = HySDataKindDefine.NAME_SCALOR_RAIN_FALL.ToString();
                                    bFlag = true;
                                }
                            }
                            if (bFlag == false)
                            {  // 外部データの種別検索の場合
                                for (iLp1 = 0; iLp1 < HySDispDefine.SEARCHDATA_TYPE.GetLength(0); iLp1++)
                                {  // データ種別数分繰り返す
                                    if (csDataKind.Equals(HySDispDefine.SEARCHDATA_TYPE[iLp1, 0]) == true)
                                    {  // データ種別が一致の場合
                                        switch (iLp1)
                                        {
                                            case 0: // 演算結果データ
                                                break;
                                            case 1: // 外部データ
                                                HySString csKeyCondition = m_csDBPCtlInfo.GetIDConditionList().GetObject(new HySString(m_csStockData.GetID().ToString())) as HySString;
                                                if (csKeyCondition is HySString)
                                                {  // データ検索条件が有効な場合
                                                    string[] sInWk;
                                                    sInWk = csKeyCondition.ToString().Split(',');
                                                    if (sInWk[2].Length > 0)
                                                    {  // データ種別が有る場合
                                                        if (sInWk[2].Equals(HySDataKindDefine.SCALOR_RAIN_FALL.ToString()) == true)
                                                        {  // データ種別が一致の場合
                                                            this.RainFallResultDataGridView.Rows.Add(1); // 行追加
                                                            iLp = this.RainFallResultDataGridView.Rows.Count - 1;
                                                            this.RainFallResultDataGridView["RainFallDataKind", iLp].Value = HySDispDefine.SEARCHDATA_TYPE[iLp1, 1].ToString();
                                                            bExternalflg = true;
                                                        }
                                                    }
                                                }
                                                break;
                                            default: // その他
                                                break;
                                        }
                                    }
                                }
                            }
                            if (bFlag == true || bExternalflg == true)
                            {  // リストデータが有る場合
                                String csID = m_csStockData.GetID().GetString().ToString();
                                this.RainFallResultDataGridView["RainFallDataID", iLp].Value = csID; // ユニークデータ識別子設定
                                HySObjectKind csSimKind = m_csStockData.GetSimKind();
                                if (csSimKind is HySObjectKind)
                                {  // シミュレーター種別が有る場合
                                    this.RainFallResultDataGridView["RainFallSimulatorType", iLp].Value = csSimKind.GetString().ToString();  // シミュレーター種別
                                }
                                HySID csSimID = m_csStockData.GetSimID();
                                if (csSimID is HySID)
                                {  // シミュレーターＩＤが有る場合
                                    this.RainFallResultDataGridView["RainFallProjectID", iLp].Value = csSimID.GetString().ToString();    // シミュレーターＩＤ
                                }
                                HySID csPointID = m_csStockData.GetPointID();
                                if (csPointID is HySID)
                                {  // データ地点ＩＤが有る場合
                                    this.RainFallResultDataGridView["RainFallDataPointID", iLp].Value = csPointID.GetString().ToString();  // データ地点ＩＤ
                                }
                                // その他の検索キー取得
                                long lKeyNum = 0;
                                HySDataHashTable csKeyInfo = m_csStockData.GetKeyInfo(ref lKeyNum);
                                if (lKeyNum > 0)
                                {  // その他検索キーがある場合
                                    if (csKeyInfo[HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE] != null)
                                    {  // 演算実施日が有る場合
                                        this.RainFallResultDataGridView["RainFallSpecificationPeriod", iLp].Value =
                                            HySCalendar.GetString((HySTime)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_EXEC_DATE], HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                    {  // ロットＩＤが有る場合
                                        this.RainFallResultDataGridView["RainFallLotID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME] != null)
                                    {  // プロジェクト名が有る場合
                                        this.RainFallResultDataGridView["RainFallProjectName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID] != null)
                                    {  // 要素ＩＤが有る場合
                                        this.RainFallResultDataGridView["RainFallElementID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO] != null)
                                    {  // 演算結果連番が有る場合
                                        this.RainFallResultDataGridView["RainFallSerialNumber", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT] != null)
                                    {  // 件名が有る場合
                                        this.RainFallResultDataGridView["RainFallSubject", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION] != null)
                                    {  // ケース名が有る場合
                                        this.RainFallResultDataGridView["RainFallCaseName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET] != null)
                                    {  // 対象が有る場合
                                        this.RainFallResultDataGridView["RainFallObject", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE] != null)
                                    {  // モデルが有る場合
                                        this.RainFallResultDataGridView["RainFallModelName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE] != null)
                                    {  // 種別が有る場合
                                        this.RainFallResultDataGridView["RainFallType", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallManager", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallDataType", iLp].Value = ((HySKind)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallDataDim1", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1]).m_lValue.ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallDataDim2", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2]).m_lValue.ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallDataDim3", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3]).m_lValue.ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME] != null)
                                    {  // 管理者が有る場合
                                        this.RainFallResultDataGridView["RainFallElementName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME]).ToString();
                                    }
                                }

                                HySString csSaveName = m_csStockData.GetSaveName();
                                if (csSaveName is HySString)
                                {  // 名称が有る場合
                                    this.RainFallResultDataGridView["RainFallSaveName", iLp].Value = csSaveName.ToString();             // 名称
                                }
                                HySTime csRegisertTime = m_csStockData.GetRegisertTime();
                                if (csRegisertTime is HySTime)
                                {  // データ登録日時が有る場合
                                    this.RainFallResultDataGridView["RainFallRegisertTime", iLp].Value =
                                        HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                    if (this.RainFallResultDataGridView["RainFallSpecificationPeriod", iLp].Value == null ||
                                        this.RainFallResultDataGridView["RainFallSpecificationPeriod", iLp].Value.ToString() == "")
                                    {
                                        this.RainFallResultDataGridView["RainFallSpecificationPeriod", iLp].Value =
                                            HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                    }
                                }
                                HySString csRemarks = m_csStockData.GetRemark();
                                if (csRemarks is HySString)
                                {  // 備考が有る場合
                                    this.RainFallResultDataGridView["RainFallRemarks", iLp].Value = csRemarks.ToString();              // 備考
                                }
                                if (bExternalflg == false)
                                {  // データ種別が外部データ以外の場合
                                    HySStockData.PeservedPeriod csPreservedPeriod = m_csStockData.GetPeservedPeriod();
                                    if (csPreservedPeriod == HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期限区分が一時保存の場合
                                        this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].Value = false;
                                    }
                                    else
                                    {  // 保存期限区分が永久保存の場合
                                        this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].Value = true;
                                    }
                                }
                                else
                                {  // データ種別が外部データの場合
                                    this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].ReadOnly = true;
                                }
                                if (m_csIDList is ArrayList)
                                {  // 選択データ識別キーリストが有る場合
                                    if (((HySString)m_csIDList[(int)lP]).Equal(csTrue) == true)
                                    {  // 選択状態の場合
                                        this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value = true;     // 選択状態設定
                                    }
                                    else
                                    {  // 未選択状態の場合
                                        this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value = false;    // 未選択状態設定
                                    }
                                    this.RainFallResultDataGridView["RainFallOrgPosition", iLp].Value = lP.ToString(); // 検索一覧元ポジション設定
                                }
                            }
                        }
                    }
                }
            }

            RainFallResultDataGridView.CurrentCell = null;
            RainFallResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            RainFallResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }
        /// <summary><para>method outline:</para>
        /// <para>表示データ編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> WaterFlowTableListDsp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WaterFlowTableListDsp()
        {
            int iLp = 0;
            int iLp1 = 0;

            HySString csTrue = new HySString("true");
            WaterFlowResultDataGridView.SuspendLayout();               // 一覧表動作一時中断（サスペンド）
            WaterFlowResultDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
            WaterFlowResultDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
            WaterFlowResultDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
            WaterFlowResultDataGridView.RowCount = 0;

            if (m_csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                long lCnt = m_csStockDataList.GetCount();
                for (long lP = 0; lP < lCnt; lP++)
                {  // リスト数分繰り返す
                    bool bExternalflg = false;
                    m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                    if (m_csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        HySObjectKind csDataKind = m_csStockData.GetDataKind();
                        if (csDataKind is HySObjectKind)
                        {  // データの種別が有る場合
                            bool bFlag = false;
                            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                            {  // 表示業務管理データが有る場合
                                if (csDataKind.Equals(HySDataKindDefine.QUANTITY_OF_WATER_FLOW) == true)
                                {  // データ種別が一致の場合
                                    this.WaterFlowResultDataGridView.Rows.Add(1); // 行追加
                                    iLp = WaterFlowResultDataGridView.RowCount - 1;
                                    this.WaterFlowResultDataGridView["WaterFlowDataKind", iLp].Value = HySDataKindDefine.NAME_QUANTITY_OF_WATER_FLOW.ToString();
                                    bFlag = true;
                                }
                            }
                            if (bFlag == false)
                            {  // 外部データの種別検索の場合
                                for (iLp1 = 0; iLp1 < HySDispDefine.SEARCHDATA_TYPE.GetLength(0); iLp1++)
                                {  // データ種別数分繰り返す
                                    if (csDataKind.Equals(HySDispDefine.SEARCHDATA_TYPE[iLp1, 0]) == true)
                                    {  // データ種別が一致の場合
                                        switch (iLp1)
                                        {
                                            case 0: // 演算結果データ
                                                break;
                                            case 1: // 外部データ
                                                HySString csKeyCondition = m_csDBPCtlInfo.GetIDConditionList().GetObject(new HySString(m_csStockData.GetID().ToString())) as HySString;
                                                if (csKeyCondition is HySString)
                                                {  // データ検索条件が有効な場合
                                                    string[] sInWk;
                                                    sInWk = csKeyCondition.ToString().Split(',');
                                                    if (sInWk[2].Length > 0)
                                                    {  // データ種別が有る場合
                                                        if (sInWk[2].Equals(HySDataKindDefine.QUANTITY_OF_WATER_FLOW.ToString()) == true)
                                                        {  // データ種別が一致の場合
                                                            this.WaterFlowResultDataGridView.Rows.Add(1); // 行追加
                                                            iLp = WaterFlowResultDataGridView.RowCount - 1;
                                                            this.WaterFlowResultDataGridView["WaterFlowDataKind", iLp].Value = HySDispDefine.SEARCHDATA_TYPE[iLp1, 1].ToString();
                                                            bExternalflg = true;
                                                        }
                                                    }
                                                }
                                                break;
                                            default: // その他
                                                break;
                                        }
                                    }
                                }
                            }
                            if (bFlag == true || bExternalflg == true)
                            {  // リストデータが有る場合
                                String csID = m_csStockData.GetID().GetString().ToString();
                                this.WaterFlowResultDataGridView["WaterFlowDataID", iLp].Value = csID; // ユニークデータ識別子設定
                                HySObjectKind csSimKind = m_csStockData.GetSimKind();
                                if (csSimKind is HySObjectKind)
                                {  // シミュレーター種別が有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowSimulatorType", iLp].Value = csSimKind.GetString().ToString();  // シミュレーター種別
                                }
                                HySID csSimID = m_csStockData.GetSimID();
                                if (csSimID is HySID)
                                {  // シミュレーターＩＤが有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowProjectID", iLp].Value = csSimID.GetString().ToString();    // シミュレーターＩＤ
                                }
                                HySID csPointID = m_csStockData.GetPointID();
                                if (csPointID is HySID)
                                {  // データ地点ＩＤが有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowDataPointID", iLp].Value = csPointID.GetString().ToString();  // データ地点ＩＤ
                                }
                                // その他の検索キー取得
                                long lKeyNum = 0;
                                HySDataHashTable csKeyInfo = m_csStockData.GetKeyInfo(ref lKeyNum);
                                if (lKeyNum > 0)
                                {  // その他検索キーがある場合
                                    if (csKeyInfo[HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE] != null)
                                    {  // 演算実施日が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowSpecificationPeriod", iLp].Value =
                                            HySCalendar.GetString((HySTime)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_EXEC_DATE], HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                    {  // ロットＩＤが有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowLotID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME] != null)
                                    {  // プロジェクト名が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowProjectName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.PROJECT_NAME]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID] != null)
                                    {  // 要素ＩＤが有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowElementID", iLp].Value = ((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_ID]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO] != null)
                                    {  // 演算結果連番が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowSerialNumber", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT] != null)
                                    {  // 件名が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowSubject", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SUBJECT]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION] != null)
                                    {  // ケース名が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowCaseName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_SITUATION]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET] != null)
                                    {  // 対象が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowObject", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TARGET]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE] != null)
                                    {  // モデルが有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowModelName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE] != null)
                                    {  // 種別が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowType", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MODEL_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowManager", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.MANAGER_NAME]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowDataType", iLp].Value = ((HySKind)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE]).ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowDataDim1", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1]).m_lValue.ToString();
                                        if (((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1]).m_lValue > 1)
                                        {  // 次元１が1次元配列の場合
                                            HySString sCsID = new HySString((string)this.WaterFlowResultDataGridView["WaterFlowDataID", iLp].Value);
                                            HySLong csCellNum = m_csDBPCtlInfo.GetIDCellConditionList().GetObject(sCsID) as HySLong;
                                            if (csCellNum == null)
                                            {  // 既存セル番号が無い場合
                                                csCellNum = new HySLong(1);
                                                m_csDBPCtlInfo.GetIDCellConditionList().AddObject(sCsID, csCellNum);
                                            }
                                        }
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowDataDim2", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2]).m_lValue.ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowDataDim3", iLp].Value = ((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3]).m_lValue.ToString();
                                    }
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME] != null)
                                    {  // 管理者が有る場合
                                        this.WaterFlowResultDataGridView["WaterFlowElementName", iLp].Value = ((HySString)csKeyInfo[HySCalResultDataQueryFieldNames.ELEMENT_NAME]).ToString();
                                    }
                                }

                                HySString csSaveName = m_csStockData.GetSaveName();
                                if (csSaveName is HySString)
                                {  // 名称が有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowSaveName", iLp].Value = csSaveName.ToString();             // 名称
                                }
                                HySTime csRegisertTime = m_csStockData.GetRegisertTime();
                                if (csRegisertTime is HySTime)
                                {  // データ登録日時が有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowRegisertTime", iLp].Value =
                                        HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                    if (this.WaterFlowResultDataGridView["WaterFlowSpecificationPeriod", iLp].Value == null ||
                                        this.WaterFlowResultDataGridView["WaterFlowSpecificationPeriod", iLp].Value.ToString() == "")
                                    {
                                        this.WaterFlowResultDataGridView["WaterFlowSpecificationPeriod", iLp].Value =
                                            HySCalendar.GetString(csRegisertTime, HySCalendar.FORMAT.lSW_YEAR).ToString(); // データ登録日時
                                    }
                                }
                                HySString csRemarks = m_csStockData.GetRemark();
                                if (csRemarks is HySString)
                                {  // 備考が有る場合
                                    this.WaterFlowResultDataGridView["WaterFlowRemarks", iLp].Value = csRemarks.ToString();              // 備考
                                }
                                if (bExternalflg == false)
                                {  // データ種別が外部データ以外の場合
                                    HySStockData.PeservedPeriod csPreservedPeriod = m_csStockData.GetPeservedPeriod();
                                    if (csPreservedPeriod == HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期限区分が一時保存の場合
                                        this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value = false;
                                    }
                                    else
                                    {  // 保存期限区分が永久保存の場合
                                        this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value = true;
                                    }
                                }
                                else
                                {  // データ種別が外部データの場合
                                    this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].ReadOnly = true;
                                }
                                if (m_csIDList is ArrayList)
                                {  // 選択データ識別キーリストが有る場合
                                    if (((HySString)m_csIDList[(int)lP]).Equal(csTrue) == true)
                                    {  // 選択状態の場合
                                        this.WaterFlowResultDataGridView["WaterFlowDisplayCheckFlag", iLp].Value = true;     // 選択状態設定
                                    }
                                    else
                                    {  // 未選択状態の場合
                                        this.WaterFlowResultDataGridView["WaterFlowDisplayCheckFlag", iLp].Value = false;    // 未選択状態設定
                                    }
                                    this.WaterFlowResultDataGridView["WaterFlowOrgPosition", iLp].Value = lP.ToString(); // 検索一覧元ポジション設定
                                }
                            }
                        }
                    }
                }
            }

            WaterFlowResultDataGridView.CurrentCell = null;
            WaterFlowResultDataGridView.ScrollBars = ScrollBars.Both; // スクロールバー有効
            WaterFlowResultDataGridView.ResumeLayout(true); // 一覧表動作一時停止解除（リジューム）
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Renew()
        {
            // ボタン非活性化
            this.SearchSelectButton.Enabled = false;
            this.CloseButton.Enabled = false;
            this.RainFallPermanentButton.Enabled = false;
            this.WaterFlowPermanentButton.Enabled = false;

            this.RainFallTableListDsp();      // テーブルリスト編集
            this.WaterFlowTableListDsp();     // テーブルリスト編集
            this.csIDCellConditionListInit(); // 選択データ表示セル条件管理リスト初期化

            // ボタン活性化
            this.SearchSelectButton.Enabled = true;
            this.CloseButton.Enabled = true;
            this.RainFallPermanentButton.Enabled = true;
            this.WaterFlowPermanentButton.Enabled = true;
        }


        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // 初期配置情報初期化
            iWidth_Default = FORM_WIDTH_DEFAULT;
            iHeight_Adjusted = FORM_HEIGHT_ADJUSTED_VALUE;
            iLocattion_X = DESKTOP_LOCATION_X;
            iLocattion_Y = DESKTOP_LOCATION_Y;
            base.Initialize();   // 初期化
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            HySString csFalse = new HySString("false");
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer;
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    ArrangementCorrection(m_csContainer, this); // 描画位置補正
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                    if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        m_csIDList = m_csDBPCtlInfo.GetIDList() as ArrayList;
                    }
                    m_csStockDataList = m_csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS) as HySStockDataList;
                }
                ((HySScreenBase)m_csScreen).RenewScreen();
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示の場合
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 画面表示更新指示の場合
                    if (m_csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                        if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            m_csIDList = m_csDBPCtlInfo.GetIDList() as ArrayList;
                        }
                        m_csStockDataList = m_csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS) as HySStockDataList;
                    }
                    ((HySScreenBase)m_csScreen).RenewScreen(); // 表示更新
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_BUSY)
                {  // 検索中通知の場合はボタン非活性化
                    this.SearchSelectButton.Enabled = false;
                    this.CloseButton.Enabled = false;
                    this.RainFallPermanentButton.Enabled = false;
                    this.WaterFlowPermanentButton.Enabled = false;
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_COMPLET)
                {  // 検索完了通知の場合はボタン活性化
                    this.DeleteBeingProcessingMesseage();
                    this.SearchSelectButton.Enabled = true;
                    this.CloseButton.Enabled = true;
                    this.RainFallPermanentButton.Enabled = true;
                    this.WaterFlowPermanentButton.Enabled = true;
                }
                else
                {  // 画面表示更新指示以外の場合
                    base.EventCallback(csEvent);
                }
            }
            else
            {  // 画面一般指示以外の場合
                base.EventCallback(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Arrangement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Arrangement()
        {
            // 画面サイズにあわせて表示サイズ決定
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);
            this.Width = iWidth_Default;
            this.Height = iHeight_Adjusted;
            iLocattion_Y = rect.Height - DESKTOP_LOCATION_Y;
            this.StartPosition = FormStartPosition.Manual;
            this.SetDesktopLocation(iLocattion_X, iLocattion_Y);
            this.WindowState = FormWindowState.Normal;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>全て解除処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllResetButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllResetButton_Click(object sender, EventArgs e)
        {
            for (int iP = 0; iP < this.WaterFlowResultDataGridView.RowCount; iP++)
            {  // 行数分繰り返す
                this.WaterFlowResultDataGridView["WaterFlowDisplayCheckFlag", iP].Value = false; // チェックボックスを解除する
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>再表示要求処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReDispButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReDispButton_Click(object sender, EventArgs e)
        {
            bool bOnFlg = false;
            if (m_csIDList is ArrayList)
            {  // 選択データ識別キーリストが有る場合
                for (int iLp = 0; iLp < this.RainFallResultDataGridView.RowCount; iLp++)
                {  // 行数分繰り返す
                    HySString csDt = new HySString("false");
                    if ((bool)this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value == true)
                    {  // 選択状態の場合
                        csDt = new HySString("true");
                        bOnFlg = true;
                    }
                    int iPosition = int.Parse((string)this.RainFallResultDataGridView["RainFallOrgPosition", iLp].Value);
                    m_csIDList[iPosition] = csDt;
                }
                for (int iLp = 0; iLp < this.WaterFlowResultDataGridView.RowCount; iLp++)
                {  // 行数分繰り返す
                    HySString csDt = new HySString("false");
                    if ((bool)this.WaterFlowResultDataGridView["WaterFlowDisplayCheckFlag", iLp].Value == true)
                    {  // 選択状態の場合
                        csDt = new HySString("true");
                        bOnFlg = true;
                    }
                    int iPosition = int.Parse((string)this.WaterFlowResultDataGridView["WaterFlowOrgPosition", iLp].Value);
                    m_csIDList[iPosition] = csDt;
                }
            }
            if (bOnFlg == true)
            {  // 演算結果選択が有る場合
                this.PutEvent(HySEventObject.CMND_DISPLY_COMMON, HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST);
                this.CreateBeingProcessingMesseage(this.Text.ToString(), RESULT_DATA_BEING_PROCESSED_MSG);
            }
            else
            {  // 演算結果選択が無い場合
				MessageBox.Show(SELECTION_GUIDANCE_MSG1, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            m_csScreen.CloseScreen();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>雨量一覧チェックボックス選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RainFallResultDataGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RainFallResultDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0 && e.ColumnIndex == 0)
            {  // 表示選択の場合
                if (this.RainFallResultDataGridView["RainFallDisplayCheckFlag", e.RowIndex].Value != null)
                {  // 選択状態が有効な場合
                    if ((bool)this.RainFallResultDataGridView["RainFallDisplayCheckFlag", e.RowIndex].Value == false)
                    {  // 新たに他の演算結果を選択の場合
                        this.RainFallResultDataGridView.BeginEdit(false);
                        for (int iLp = 0; iLp < this.RainFallResultDataGridView.RowCount; iLp++)
                        {  // 行数分繰り返す
                            if (this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value != null)
                            {  // 選択状態の場合
                                if ((bool)this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value == true)
                                {  // 選択状態の場合
                                    this.RainFallResultDataGridView["RainFallDisplayCheckFlag", iLp].Value = false;
                                }
                            }
                        }
                        this.RainFallResultDataGridView.EndEdit();
                    }
                }
            }
            else if (e.RowIndex >= 0 && e.ColumnIndex == 12)
            {  // 保存期間の場合
                if (this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", e.RowIndex].Value != null)
                {  // 保存期間が有効な場合
                    bool bFlg = ((bool)this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", e.RowIndex].Value == true) ? false : true;
                    this.RainFallResultDataGridView.BeginEdit(false);
                    this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", e.RowIndex].Value = bFlg;
                    this.RainFallResultDataGridView.EndEdit();
                    string sLotID = (string)this.RainFallResultDataGridView["RainFallLotID", e.RowIndex].Value;
                    // 流量側にある同一ロットを操作
                    for (int iLp = 0; iLp < this.WaterFlowResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        if (this.WaterFlowResultDataGridView["WaterFlowLotID", iLp].Value != null)
                        {  // 同じロットＩＤの場合
                            if (((string)this.WaterFlowResultDataGridView["WaterFlowLotID", iLp].Value).Equals(sLotID) == true)
                            {  // 同じロットＩＤの場合
                                this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value = bFlg;
                            }
                        }
                    }
                }
            }
            else
            {  // その他
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>流量一覧チェックボックス選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WaterFlowResultDataGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WaterFlowResultDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0 && e.ColumnIndex == 12)
            {  // 保存期間の場合
                if (this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", e.RowIndex].Value != null)
                {  // 保存期間が有効な場合
                    bool bFlg = ((bool)this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", e.RowIndex].Value == true) ? false : true;
                    string sLotID = (string)this.WaterFlowResultDataGridView["WaterFlowLotID", e.RowIndex].Value;
                    this.WaterFlowResultDataGridView.BeginEdit(false);
                    for (int iLp = 0; iLp < this.WaterFlowResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        if (this.WaterFlowResultDataGridView["WaterFlowLotID", iLp].Value != null)
                        {  // 同じロットＩＤの場合
                            if (((string)this.WaterFlowResultDataGridView["WaterFlowLotID", iLp].Value).Equals(sLotID) == true)
                            {  // 同じロットＩＤの場合
                                if (e.RowIndex != iLp)
                                {  // 今回操作行以外の場合
                                    this.WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value = bFlg;
                                }
                            }
                        }
                    }
                    this.WaterFlowResultDataGridView.EndEdit();
                    // 雨量側にある同一ロットを操作
                    for (int iLp = 0; iLp < this.RainFallResultDataGridView.RowCount; iLp++)
                    {  // 行数分繰り返す
                        if (this.RainFallResultDataGridView["RainFallLotID", iLp].Value != null)
                        {  // 同じロットＩＤの場合
                            if (((string)this.RainFallResultDataGridView["RainFallLotID", iLp].Value).Equals(sLotID) == true)
                            {  // 同じロットＩＤの場合
                                this.RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].Value = bFlg;
                            }
                        }
                    }
                }
            }
            else
            {  // その他
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>流量一覧ダブルクリック選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WaterFlowResultDataGridView_CellContentDoubleClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WaterFlowResultDataGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            HySLong csCellNum = null;

            if (e.RowIndex >= 0 && e.ColumnIndex != 0 && e.ColumnIndex != 12)
            {  // 表示選択の場合
                if (this.WaterFlowResultDataGridView["WaterFlowDataDim1", e.RowIndex].Value != null)
                {  // 次元１が有効な場合
                    long lDim1 = long.Parse(this.WaterFlowResultDataGridView["WaterFlowDataDim1", e.RowIndex].Value.ToString());
                    if (lDim1 > 1)
                    {  // 次元１が1次元配列の場合
                        if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            HySString csID = new HySString((string)this.WaterFlowResultDataGridView["WaterFlowDataID", e.RowIndex].Value);
                            csCellNum = m_csDBPCtlInfo.GetIDCellConditionList().GetObject(csID) as HySLong;
                            if (csCellNum == null)
                            {  // 既存セル番号が無い場合
                                csCellNum = new HySLong(1);
                            }
                            Form csCellSelectform = new HySDotNetResultCellSelectForm(lDim1, csCellNum);
                            csCellSelectform.ControlBox = !csCellSelectform.ControlBox;
                            csCellSelectform.StartPosition = FormStartPosition.Manual;
                            csCellSelectform.SetDesktopLocation(this.Location.X + 10, this.Location.Y);
                            csCellSelectform.ShowDialog();
                            m_csDBPCtlInfo.GetIDCellConditionList().AddObject(csID, csCellNum);
                        }
                    }
                }
            }
            else if (e.RowIndex >= 0 && e.ColumnIndex == 12)
            {  // 保存期間の場合
                WaterFlowResultDataGridView_CellContentClick(sender, e);
            }
            else
            {  // その他
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>雨量データ永久保存処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RainFallPermanentButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RainFallPermanentButton_Click(object sender, EventArgs e)
        {
            this.PermanentButton();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>流量データ永久保存処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WaterFlowPermanentButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WaterFlowPermanentButton_Click(object sender, EventArgs e)
        {
            this.PermanentButton();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ永久保存処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PermanentButton()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PermanentButton()
        {
            bool ChkFlg = false;
            long lP = 0;
            int iLp;

            if (m_csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                for (iLp = 0; iLp < RainFallResultDataGridView.RowCount; iLp++)
                {  // リスト数分繰り返す
                    if (RainFallResultDataGridView["RainFallOrgPosition", iLp].Value != null)
                    {  // 元ポジションが有る場合
                        lP = long.Parse((string)RainFallResultDataGridView["RainFallOrgPosition", iLp].Value);
                        m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                        if (m_csStockData is HySStockData)
                        {  // データ保存クラスの場合
                            if (RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].Value != null)
                            {  // 保存期間が有効な場合
                                if ((bool)RainFallResultDataGridView["RainFallPermanentRepositoryFlag", iLp].Value == true)
                                {  // 永久保存状態の場合
                                    if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Eternity)
                                    {  // 保存期間変更有りの場合
                                        m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Eternity);
                                        ChkFlg = true;
                                    }
                                }
                                else
                                {  // 一時保存状態の場合
                                    if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期間変更有りの場合
                                        m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
                                        ChkFlg = true;
                                    }
                                }
                            }
                        }
                    }
                }
                for (iLp = 0; iLp < WaterFlowResultDataGridView.RowCount; iLp++)
                {  // リスト数分繰り返す
                    if (WaterFlowResultDataGridView["WaterFlowOrgPosition", iLp].Value != null)
                    {  // 元ポジションが有る場合
                        lP = long.Parse((string)WaterFlowResultDataGridView["WaterFlowOrgPosition", iLp].Value);
                        m_csStockData = m_csStockDataList.GetData(lP) as HySStockData;
                        if (m_csStockData is HySStockData)
                        {  // データ保存クラスの場合
                            if (WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value != null)
                            {  // 保存期間が有効な場合
                                if ((bool)WaterFlowResultDataGridView["WaterFlowPermanentRepositoryFlag", iLp].Value == true)
                                {  // 永久保存状態の場合
                                    if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Eternity)
                                    {  // 保存期間変更有りの場合
                                        m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Eternity);
                                        ChkFlg = true;
                                    }
                                }
                                else
                                {  // 一時保存状態の場合
                                    if (m_csStockData.GetPeservedPeriod() != HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期間変更有りの場合
                                        m_csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
                                        ChkFlg = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (ChkFlg == true)
            {  // 永久保存リストが有る場合
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetToSimKind(m_csScreen.GetSimKind());
                csEventObj.SetSuppID((HySID)m_csScreen.GetID());
                csEventObj.SetData(this.GetViewKind());
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST);
                m_csScreen.PutEvent(csEventObj);
                this.CreateBeingProcessingMesseage(this.Text.ToString(), PERMANENT_PRESERVATION_BEING_PROCESSED_MSG);
            }
            else
            {   // 永久保存リストが無い場合
				MessageBox.Show(SELECTION_GUIDANCE_MSG3, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_REPORT_0015,
                        ((HySDotNetViewer)((HySResultSelectionScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary><para>method outline</para>
        /// <para>選択データ表示セル条件管理リスト初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csIDCellConditionListInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void csIDCellConditionListInit()
        {
            // セル選択テーブル初期化
            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示業務管理データが有る場合
                if (m_csDBPCtlInfo.GetIDCellConditionList().GetCount() > 0)
                { // セル選択データがある場合
                    HySDataLinkedList csKeys = m_csDBPCtlInfo.GetIDCellConditionList().GetKeyList();
                    for (long lP = 0; lP < csKeys.GetCount(); lP++)
                    {
                        HySString csCompKey = csKeys.GetData(lP) as HySString;
                        bool bChkFlg = false;
                        for (int iLp = 0; iLp < this.WaterFlowResultDataGridView.RowCount; iLp++)
                        {
                            HySString csID = new HySString((string)this.WaterFlowResultDataGridView["WaterFlowDataID", iLp].Value);
                            if (csCompKey.Equal(csID) == true)
                            {
                                bChkFlg = true;
                                break;
                            }
                        }
                        if (bChkFlg == false)
                        {  // 既存ＩＤではない場合
                            m_csDBPCtlInfo.GetIDCellConditionList().DeleteData(csCompKey);
                        }
                    }
                    csKeys = null;
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetResultSelectionHydroHyetoForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetResultSelectionHydroHyetoForm_Activated(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }
    }
}
