﻿// <summary>ソースコード：ＧＩＳ専用検索条件設置画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Collections;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ専用検索条件設置画面表示フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetSearchConditionGISForm : HySReportSearchFormBase
    {
        //
        //画面関連定数定義
        //
        /// <summary>画面幅調整値</summary>
        static private readonly int FORM_WIDTH_DEFAULT = 360;
        /// <summary>画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_DEFAULT = 310;
        /// <summary>画面配置デスクトップ座標X</summary>
        static private readonly int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 0;

        /// <summary>DataGridViewのコンボボックスクラス</summary>
        private DataGridViewComboBoxEditingControl csDataGridViewComboBox = null;
        /// <summary>DataGridView内のテキストボックス(ショートカットキーイベント処理に用いる)</summary>
        private TextBox m_csTextBox = null;
        //
        // ＸＭＬ関連定数定義
        //
        /// <summary>抽出条件</summary>
        protected HySDataLinkedList m_csQueryCondition = null;
        /// <summary>抽出条件（画面専用）</summary>
        protected HySDataLinkedList m_csQueryConditionBuf = null;
        /// <summary>検索条件ファイルパス</summary>
        static public readonly string SEARCHCONDITIONFILEPASS = "\\temp\\GISSearchCondition.xml";
        /// <summary>検索条件タグキー</summary>
        static public readonly string SEARCHCONDITIONKEY = "SearchCondition";
        /// <summary>前提条件タグキー</summary>
        static public readonly string PRECONDITIONKEY = "Precondition";
        /// <summary>前提条件タグ</summary>
        string[] m_sPreconditionKeys = { "MaxNum", "DataType" };
        /// <summary>抽出項目タグキー</summary>
        static public readonly string QUERYCONDITIONKEY = "QueryCondition";
        /// <summary>抽出条件タグ</summary>
        string[] m_sKeys = { "SearchType" ,
                             "ProjectName", "DataKind", "SpecificationPeriod", "BeginningPeriod", "EndPeriod",
                             "Subject"    , "CaseName", "Object", "ModelName", "Type"           , "Manager"
                           };
        /// <summary>抽出条件無効タグ</summary>
        string m_sNonKey = "Non";
        /// <summary>期間（開始）列位置</summary>
        long m_lBeginningPeriod = 3;
        /// <summary>期間（終了）列位置</summary>
        long m_lEndPeriod = 4;
		/// <summary>演算データ検索中メッセージ『演算結果検索中です。』</summary>
		static public readonly string RESULT_DATA_BEING_PROCESSED_MSG = Properties.HysDotNetViewerResources.RESULT_DATA_BEING_PROCESSED_MSG;
		/// <summary>メッセージ『期間の指定が正しくありません』</summary>
		static public readonly string SELECTION_GUIDANCE_MSG1 = HysMessage.GetString("HYS_MSG_WARNING_PERIOD_DATE");
		/// <summary>メッセージ『同一条件の入力があります。入力内容を見直してください。』</summary>
		static public readonly string SELECTION_GUIDANCE_MSG2 = HysMessage.GetString("HYS_MSG_WARNING_CHANGE_CONDITION");
		///<summary>メッセージタイトル『演算結果表示機能』</summary>
		static public readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");
        /// <summary>ファイル入力フィルター</summary>
        static public readonly string FILE_DLG_FILTER = Properties.HysDotNetViewerResources.FILE_DLG_FILTER_CSV;    //"ＣＳＶ ファイル (*.csv)|*.csv"
        /// <summary>検索対象タイトル</summary>
        static public readonly string TRANINFO_TYPE_TITLE = Properties.HysDotNetViewerResources.FORM_TITLE_TRANINFO_TYPE;   //"検索対象："
		/// <summary>処理中フォームタイトル『演算結果表示機能』</summary>
		static public readonly string PROCESSING_FORM_TITLE = HysMessage.GetString("HYS_MSG_TITLE_OPERATION_RESULT");
        /// <summary>データ種別</summary>
        string m_sDataKind = "ALL";

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewFormBaseIF csSearchConditionForm = new HySDotNetSearchConditionGISForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetSearchConditionGISForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetSearchConditionGISForm()
        {
            // 初期化処理
            InitializeComponent();
            this.DataGridView_Calc_Result.Rows.Clear();
            this.DataGridView_External.Rows.Clear();
            // 期間指定ComboBoxに項目を追加
            DataGridViewComboBoxColumn csCol = (DataGridViewComboBoxColumn)this.DataGridView_Calc_Result.Columns["SpecificationPeriod"];
            for (int iLp = 0; iLp < HySDispDefine.PERIODDATA_TYPE.GetLength(0); iLp++)
            {  // データ種別件数分繰り返す
                csCol.Items.Add(HySDispDefine.PERIODDATA_TYPE[iLp, 1].ToString());
            }
            // 最大検索数設定
            this.MaxNumberNumericUpDown.Maximum = (int)HySDispDefine.SERACH_MAX_NUMBER;
            this.MaxNumberNumericUpDown.Value = (int)(HySDispDefine.SERACH_MAX_NUMBER / 2);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>検索条件復帰</para>
        /// </summary>
        /// <example>SetDataGRidView(csDataGridView,sInWk)<para>usage:</para>
        /// <para></para>
        /// </example>
        /// <param name="csDataGridView">データグリッドビュー</param>
        /// <param name="sInWk">展開検索条件</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataGRidView( DataGridView csDataGridView, string[] sInWk)
        {
            int iLp = 0;
            int iLp1 = 0;
            int iCnt = 0; ;
            bool bSetFlg = false;

            for (iLp = 1; iLp < sInWk.Length; iLp++)
            {  // 展開検索条件数分繰り返す
                if (sInWk[iLp].Equals(m_sNonKey) == false && sInWk[iLp].Length > 0)
                {  // 無効値以外の場合
                    if (bSetFlg == false)
                    {  // 設定初回の場合
                        if (csDataGridView.RowCount <= 0)
                        {  // 空行の場合
                            csDataGridView.Rows.Add(1);
                        }
                        else
                        {  // 空行以外の場合
                            csDataGridView.RowCount = 1;
                        }
                        iCnt = 0;
                        bSetFlg = true;
                    }
                    switch (iLp)
                    {
                        case 2: // データ種別
                            break;
                        case 3: // 指定期間
                            for (iLp1 = 0; iLp1 < HySDispDefine.PERIODDATA_TYPE.GetLength(0); iLp1++)
                            {  // データ種別件数分繰り返す
                                if (HySDispDefine.PERIODDATA_TYPE[iLp1, 0].ToString().Equals(sInWk[iLp]) == true)
                                {
                                    csDataGridView[iLp - 1, iCnt].Value = HySDispDefine.PERIODDATA_TYPE[iLp1, 1].ToString();
                                    if (iLp1 != 0)
                                    {  // 期間指定の場合
                                        csDataGridView[(int)m_lBeginningPeriod, iCnt].ReadOnly = false; // 期間（開始）
                                        csDataGridView[(int)m_lEndPeriod, iCnt].ReadOnly       = false; // 期間（終了）
                                    }
                                    break;
                                }
                            }
                            break;
                        default: // その他
                            csDataGridView[iLp - 1, iCnt].Value = sInWk[iLp];
                            break;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetSearchConditionGISForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetSearchConditionGISForm_Load(object sender, EventArgs e)
        {
            this.DataGridView_Calc_Result.RowCount = 1;
            this.DataGridView_External.RowCount = 1;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // 初期配置情報初期化
            iHeight_Default = FORM_HEIGHT_DEFAULT;
            iWidth_Default = FORM_WIDTH_DEFAULT;
            iLocattion_X = DESKTOP_LOCATION_X;
            iLocattion_Y = DESKTOP_LOCATION_Y;
            base.Initialize(); // 初期化
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            int iLp = 0;
            int iLp1 = 0;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csHySEvent.GetToSimKind();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer;
                // 検索条件設定値をデータコンテナに格納
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    ArrangementCorrection(m_csContainer,this); // 描画位置補正
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                    // データ種別ComboBoxに項目を追加
                    DataGridViewComboBoxColumn csCol = (DataGridViewComboBoxColumn)this.DataGridView_Calc_Result.Columns["Datakind"];
                    csCol.Items.Add(m_sDataKind);
                    // 検索対象伝送情報型を表示
                    this.TranInfoTypeComboBox.Items.Clear();
                    for (iLp = 0; iLp < HySDispDefine.SEARCH_TRANINFO_TYPE.GetLength(0); iLp++)
                    {  // 行数分繰り返す
                        if (m_csDBPCtlInfo.GetParentsScreenKind().Equals(HySDispDefine.SEARCH_TRANINFO_TYPE[iLp, 0, 0]) == true)
                        {  // 親画面種別が一致した場合
                            for (iLp1 = 0; iLp1 < HySDispDefine.SEARCH_TRANINFO_TYPE.GetLength(1); iLp1++)
                            {  // 行数分繰り返す
                                if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp, iLp1, 1] is HySKind)
                                {  // 伝送情報名は有効な場合
                                    this.TranInfoTypeComboBox.Items.Add(HySDispDefine.SEARCH_TRANINFO_TYPE[iLp, iLp1, 1].ToString());
                                }
                            }
                            break;
                        }
                    }
                    if (this.TranInfoTypeComboBox.Items.Count == 0)
                    {  // 検索データタイプが無い場合
                        this.TranInfoTypeComboBox.Items.Add(""); // 空行追加
                    }
                    this.TranInfoTypeComboBox.SelectedIndex = 0;
                    this.SearchTabControl.TabPages.RemoveAt(1);  // 外部データタブを削除
                    // 既存検索条件取得
                    m_csQueryCondition = new HySDataLinkedList();
                    m_csQueryConditionBuf = new HySDataLinkedList();
                    this.GetFileSerachCondition();
                    // 抽出条件をリストに設定
                    if (m_csQueryCondition.GetCount() > 0)
                    { // 抽出条件が有る場合
                        for (iLp = 0; iLp < m_csQueryCondition.GetCount(); iLp++)
                        {  // 行数分繰り返す
                            HySString csKeyCondition = (HySString)m_csQueryCondition.GetData((long)iLp);
                            string[] sInWk;
                            sInWk = csKeyCondition.ToString().Split(',');
                            for (iLp1 = 0; iLp1 < HySDispDefine.SEARCHDATA_TYPE.GetLength(0); iLp1++)
                            {  // 検索種別件数分繰り返す
                                if (sInWk[0].Equals(HySDispDefine.SEARCHDATA_TYPE[iLp1, 0].ToString()) == true)
                                { // 検索種別が一致した場合
                                    switch (iLp1)
                                    {
                                        case 0: // 演算結果データ
                                            SetDataGRidView(this.DataGridView_Calc_Result, sInWk);
                                            break;
                                        case 1: // 外部データ
                                            SetDataGRidView(this.DataGridView_External, sInWk);
                                            break;
                                        default: // その他
                                            break;
                                    }
                                }
                            }
                        }
                    }
                    this.DataGridView_Calc_Result.RowCount = 1;
                    this.DataGridView_External.RowCount = 1;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示（表示更新、検索）の場合
                if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_BUSY)
                {  // 検索中通知の場合
                    this.SearchSelectButton.Enabled = false;
                    this.CloseButton.Enabled = false;
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_DB_REQUEST_COMPLET)
                {  // 検索完了通知の場合はボタン活性化
                    this.Focus();
                    this.DeleteBeingProcessingMesseage();
                    this.SearchSelectButton.Enabled = true;
                    this.CloseButton.Enabled = true;
                }
                else
                {  // その他イベントの場合
                    base.EventCallback(csEvent);
                }
            }
            else
            {  // その他イベントの場合
                base.EventCallback(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Arrangement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Arrangement()
        {
            // 画面サイズにあわせて表示サイズ決定
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);
            this.Width = iWidth_Default;
            this.Height = iHeight_Default;
            this.StartPosition = FormStartPosition.Manual;
            this.SetDesktopLocation(iLocattion_X, iLocattion_Y);
            this.WindowState = FormWindowState.Normal;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>検索開始処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SearchStartButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SearchStartButton_Click(object sender, EventArgs e)
        {
            // 入力値妥当性判定
            if (CheckDataGridView(this.DataGridView_Calc_Result) == true)
            {  // 演算結果データ検索条件が正常な場合
                if (CheckDataGridView(this.DataGridView_External) == true)
                {  // 外部データ検索条件が正常な場合
                    m_csQueryCondition.Clear(); // 抽出条件初期化
                    m_csQueryConditionBuf.Clear(); // ＸＭＬ用抽出条件初期化
                    SetQueryCondition(HySDispDefine.SEARCHDATA_TYPE[0, 0], this.DataGridView_Calc_Result); // 演算結果データ条件退避
                    SetQueryCondition(HySDispDefine.SEARCHDATA_TYPE[1, 0], this.DataGridView_External);    // 外部データ条件退避
                    // 検索条件設定値をデータコンテナに格納
                    if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        m_csDBPCtlInfo.SetQueryCondition(m_csQueryCondition);
                    }
                    // ボタン非活性化
                    this.SearchSelectButton.Enabled = false;
                    this.CloseButton.Enabled = false;
                    // 検索実施イベント通知
                    this.PutEvent(HySEventObject.CMND_DISPLY_COMMON, HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST);
                    // 検索条件登録
                    this.SetFileSerachCondition();
					this.CreateBeingProcessingMesseage(PROCESSING_FORM_TITLE, RESULT_DATA_BEING_PROCESSED_MSG);
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力値妥当性判定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = CheckDataGridView(csDataGridView)</para>
        /// </example>
        /// <param name="csDataGridView">データグリッドビュー</param>
        /// <returns>bool 判定結果(=true:正常 =false:異常)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckDataGridView(DataGridView csDataGridView)
        {
            int iLp, iLp1, iLp2;
            bool bFlg = false;

            // 入力値妥当性判定
            for (iLp = 0; iLp < csDataGridView.Rows.Count; iLp++)
            {  // 行数分繰り返す
                bFlg = false;
                for (iLp1 = 0; iLp1 < csDataGridView.Columns.Count; iLp1++)
                {  // 列数分繰り返す
                    if (csDataGridView[iLp1, iLp].Value != null && csDataGridView[iLp1, iLp].Value.ToString() != "")
                    {  //有効項目が有る場合
                        bFlg = true;
                        break;
                    }
                }
                if (bFlg == false)
                {  // 有効項目が無い場合
                    continue;
                }
                // 検索期間入力パターンチェック
                if (csDataGridView[(int)m_lBeginningPeriod, iLp].Value != null &&
                    csDataGridView[(int)m_lBeginningPeriod, iLp].Value.ToString() != "")
                {  // 検索期間(終了)が有る場合
                    if (csDataGridView[(int)m_lEndPeriod, iLp].Value != null &&
                        csDataGridView[(int)m_lEndPeriod, iLp].Value.ToString() != "")
                    {  // 未入力項目が有る場合
                        if (DateTime.Parse(csDataGridView[(int)m_lBeginningPeriod, iLp].Value.ToString()) >
                            DateTime.Parse(csDataGridView[(int)m_lEndPeriod, iLp].Value.ToString()))
                        {  // 期間が不当な場合
							MessageBox.Show(SELECTION_GUIDANCE_MSG1, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                            return false;
                        }
                    }
                }
            }
            // 二重チェック
            for (iLp = 0; iLp < csDataGridView.Rows.Count; iLp++)
            {  // 行数分繰り返す
                bFlg = false;
                for (iLp1 = 0; iLp1 < csDataGridView.Columns.Count; iLp1++)
                {  // 列数分繰り返す
                    if (csDataGridView[iLp1, iLp].Value != null && csDataGridView[iLp1, iLp].Value.ToString() != "")
                    {  //有効項目が有る場合
                        bFlg = true;
                        break;
                    }
                }
                if (bFlg == false)
                {  // 有効項目が無い場合
                    continue;
                }
                for (iLp1 = iLp + 1; iLp1 < csDataGridView.Rows.Count; iLp1++)
                {  // 行数分繰り返す
                    for (iLp2 = 1; iLp2 < csDataGridView.Columns.Count; iLp2++)
                    {  // 列数分繰り返す
                        if (csDataGridView[iLp2, iLp1].Value != null && csDataGridView[iLp2, iLp1].Value.ToString() != "")
                        {  //有効項目が有る場合
                            bFlg = true;
                            break;
                        }
                    }
                    if (bFlg == false)
                    {  // 有効項目が無い場合
                        continue;
                    }
                    bFlg = false;
                    for (iLp2 = 0; iLp2 < csDataGridView.Columns.Count; iLp2++)
                    {  // 列数分繰り返す
                        string sWk1 = (csDataGridView[iLp2, iLp].Value == null) ? "" : csDataGridView[iLp2, iLp].Value.ToString();
                        string sWk2 = (csDataGridView[iLp2, iLp1].Value == null) ? "" : csDataGridView[iLp2, iLp1].Value.ToString();
                        if (sWk1.Equals(sWk2) == false)
                        {  // 不一致項目が有る場合
                            bFlg = true;
                            break;
                        }
                    }
                    if (bFlg == false)
                    {  // 二重入力が有る場合
						MessageBox.Show(SELECTION_GUIDANCE_MSG2, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        return false;
                    }
                }
            }
            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>EditingControlShowingイベントハンドラ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_EditingControlShowing(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_EditingControlShowing(object sender, DataGridViewEditingControlShowingEventArgs e)
        {
            if (e.Control is DataGridViewComboBoxEditingControl)
            {  // コントロールがコンボボックスコントロールの場合
                if (((DataGridView)sender).CurrentCell.OwningColumn.Name == "SpecificationPeriod")
                {  // 期間の指定の場合
                    this.csDataGridViewComboBox = (DataGridViewComboBoxEditingControl)e.Control; // コントロールボックス設定
                    this.csDataGridViewComboBox.SelectedIndexChanged +=
                        new EventHandler(csDataGridViewComboBox_SelectedIndexChanged); // イベントハンドラ追加
                }
                m_csTextBox = null;
            }
            else if (e.Control is DataGridViewTextBoxEditingControl)
            {
                // コントロールがテキストボックスコントロールの場合
                //編集中のテキストボックスコントロールを取得
                m_csTextBox = (TextBox)e.Control;
            }

        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>CellEnterイベントハンドラ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_CellEnter(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (((DataGridView)sender).Columns[e.ColumnIndex] is DataGridViewComboBoxColumn)
            {  // DataGridViewComboBoxの場合
                SendKeys.Send("{F4}");
            }
            else
            {  // DataGridViewComboBox以外の場合
                if (((DataGridView)sender).Columns[e.ColumnIndex].ReadOnly == false)
                {  // カラムが有効な場合
                    SendKeys.Send("{F2}");
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>RowsAddedイベントハンドラ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_RowsAdded(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_RowsAdded(object sender, DataGridViewRowsAddedEventArgs e)
        {
            //セルの既定値を指定する
            ((DataGridView)sender)["BeginningPeriod", e.RowIndex].ReadOnly = true;
            ((DataGridView)sender)["EndPeriod", e.RowIndex].ReadOnly = true;
            ((DataGridView)sender)["DataKind", e.RowIndex].ReadOnly = true;
            ((DataGridView)sender)["DataKind", e.RowIndex].Value = m_sDataKind;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>CellEndEditイベントハンドラ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_CellEndEdit(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            if (this.csDataGridViewComboBox != null)
            {  // SelectedIndexChangedイベントハンドラの場合
                this.csDataGridViewComboBox.SelectedIndexChanged -=
                    new EventHandler(csDataGridViewComboBox_SelectedIndexChanged);
                this.csDataGridViewComboBox = null; // イベント削除
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>SelectedIndexChangedイベントハンドラ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>csDataGridViewComboBox_SelectedIndexChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void csDataGridViewComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int iIndex = (((DataGridViewComboBoxEditingControl)sender).SelectedIndex >= 0)?
                          ((DataGridViewComboBoxEditingControl)sender).SelectedIndex: 0; // 選択値取得
            switch (iIndex)
            {
                case 0: // 未選択
                case 1: // 当日指定
                    if (this.DataGridView_Calc_Result.CurrentRow.Index >= 0)
                    {  // 行が有効な場合
                        if (this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == false ||
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == false)
                        {  // 入力モード変更の場合
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = true;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = true;
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = null;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = null;
                        }
                    }
                    break;
                case 2: // 期間指定
                    if (this.DataGridView_Calc_Result.CurrentRow.Index >= 0)
                    {  // 行が有効な場合
                        if (this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == true ||
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == true)
                        {  // 入力モード変更の場合
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = false;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = false;
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = DateTime.Now.ToShortDateString();
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = DateTime.Now.ToShortDateString();
                        }
                    }
                    break;
                case 3: // 指定日以降
                    if (this.DataGridView_Calc_Result.CurrentRow.Index >= 0)
                    {  // 行が有効な場合
                        if (this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == true ||
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == false)
                        {  // 入力モード変更の場合
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = false;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = true;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = null;
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = DateTime.Now.ToShortDateString();
                        }
                    }
                    break;
                case 4: // 指定日以前
                    if (this.DataGridView_Calc_Result.CurrentRow.Index >= 0)
                    {  // 行が有効な場合
                        if (this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == false ||
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly == true)
                        {  // 入力モード変更の場合
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = true;
                            this.DataGridView_Calc_Result["BeginningPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = null;
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].ReadOnly = false;
                            //this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = DateTime.Now.ToString("yyyy/MM/dd");
                            this.DataGridView_Calc_Result["EndPeriod", this.DataGridView_Calc_Result.CurrentRow.Index].Value = DateTime.Now.ToShortDateString();
                        }
                    }
                    break;
                default: // その他
                    break;
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>DataGridViewの削除(Sift+DEL)処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_DeleteRequest(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_DeleteRequest(object sender, EventArgs e)
        {
            //DataGridViewで選択されているすべての行を削除する
            DataGridView csSender = (this.SearchTabControl.SelectedIndex == 0) ? this.DataGridView_Calc_Result : this.DataGridView_External;
            foreach (DataGridViewRow csRow in csSender.SelectedRows)
            {
                if (!csRow.IsNewRow)
                {  // 選択行の場合
                    csSender.Rows.Remove(csRow);
                    if (csSender.Rows.Count == 0)
                    {  // ヘッダ行だけの場合
                        csSender.Rows.Add(1);
                    }
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>DataGridViewのセルクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataGridView_CellClick(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            int iRowIndex = e.RowIndex;    // 行取得
            int iColIndex = e.ColumnIndex; // 列取得
            if (iRowIndex >= 0 && iColIndex >= 0)
            {  // ヘッダ行以外の場合
                OpenFileDialog csOpenFileDlg = new OpenFileDialog();
                csOpenFileDlg.FileName = "";
                csOpenFileDlg.Filter = FILE_DLG_FILTER;
                csOpenFileDlg.RestoreDirectory = true;
                if (csOpenFileDlg.ShowDialog(this) == DialogResult.OK)
                {
                    ((DataGridView)sender).CurrentCell = ((DataGridView)sender)[iColIndex, iRowIndex];
                    ((DataGridView)sender).BeginEdit(true);
                    ((DataGridView)sender).EditingControl.Text = csOpenFileDlg.FileName;
                    ((DataGridView)sender).EndEdit();
                }
            }
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>検索条件をデータコンテナに設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetQueryCondition(csKey,csDataGridView)</para>
        /// </example>
        /// <param name="csKey">検索種別</param>
        /// <param name="csDataGridView">データグリッドビュー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetQueryCondition(HySKind csKey, DataGridView csDataGridView)
        {
            HySString csKeyCondition = null;
            HySDataLinkedList csQueryConditionLocal = new HySDataLinkedList();
            int iLp, iLp1, iLp2;
            string sWk = "";
            bool bFlg = false;

            for (iLp = 0; iLp < csDataGridView.Rows.Count; iLp++)
            {  // 行数分繰り返す
                bFlg = false;
                for (iLp1 = 0; iLp1 < csDataGridView.Columns.Count; iLp1++)
                {  // 列数分繰り返す
                    if (csDataGridView[iLp1, iLp].Value != null && csDataGridView[iLp1, iLp].Value.ToString() != "")
                    {  //有効項目が有る場合
                        bFlg = true;
                        break;
                    }
                }
                if (bFlg == false)
                {  // 有効項目が無い場合
                    if (HySDispDefine.SEARCHDATA_TYPE[1, 0].Equals(csKey) == false &&
                        iLp == (csDataGridView.Rows.Count - 1))
                    {  // 外部データ以外で最終行の場合
                        if (m_csQueryConditionBuf.GetCount() != 0)
                        {  // 既に検索条件が有る場合
                            continue;
                        }
                    }
                    else
                    {  // 最終行以外の場合
                        continue;
                    }
                }
                csKeyCondition = new HySString(csKey.ToString() + ",");
                for (iLp1 = 0; iLp1 < csDataGridView.Columns.Count; iLp1++)
                {  // 列数分繰り返す
                    if (csDataGridView[iLp1, iLp].Value != null)
                    {  // データが有効な場合
                        sWk = csDataGridView[iLp1, iLp].Value.ToString();
                        switch (iLp1)
                        {
                            case 1: // データ種別
                                break;
                            case 2: // 指定期間
                                for (iLp2 = 0; iLp2 < HySDispDefine.PERIODDATA_TYPE.GetLength(0); iLp2++)
                                {  // データ種別件数分繰り返す
                                    if (HySDispDefine.PERIODDATA_TYPE[iLp2, 1].ToString().Equals(sWk) == true)
                                    {
                                        if (iLp2 != 0)
                                        {  // 期間指定の場合
                                            if ((csDataGridView[(int)m_lBeginningPeriod, iLp].Value != null &&
                                                 csDataGridView[(int)m_lBeginningPeriod, iLp].Value.ToString() != "") ||
                                                (csDataGridView[(int)m_lEndPeriod, iLp].Value != null &&
                                                 csDataGridView[(int)m_lEndPeriod, iLp].Value.ToString() != ""))
                                            {  // 開始または終了日付の指定が有る場合
                                                csKeyCondition += new HySString(HySDispDefine.PERIODDATA_TYPE[iLp2, 0].ToString());
                                            }
                                        }
                                        else
                                        {  // 当日指定の場合
                                            csKeyCondition += new HySString(HySDispDefine.PERIODDATA_TYPE[iLp2, 0].ToString());
                                        }
                                        break;
                                    }
                                }
                                break;
                            case 3: // 期間（開始）
                            case 4: // 期間（終了）
                                if (sWk.Length > 0)
                                {  // 日付指定が有る場合
                                    try
                                    {
                                        csKeyCondition += new HySString(DateTime.Parse(sWk).ToShortDateString());
                                    }
                                    catch
                                    {
                                    }
                                }
                                break;
                            default: // その他
                                csKeyCondition += new HySString(sWk);
                                break;
                        }
                    }
                    if ((iLp1 + 1) != csDataGridView.Columns.Count)
                    {  // 最終項目以外の場合
                        csKeyCondition += new HySString(",");
                    }
                }
                csQueryConditionLocal.AddLast(csKeyCondition); // リスト再設定用のデータ登録
                m_csQueryConditionBuf.AddLast(csKeyCondition); // ＸＭＬ設定用のデータ登録
                // 検索条件項目の１３番目（空要素ＩＤ）＋１４番目（検索最大件数）を追加
                csKeyCondition += ",," + MaxNumberNumericUpDown.Value.ToString();
                // 検索条件項目の１５番目（検索対象データ型）関連情報を追加
                for (iLp1 = 0; iLp1 < HySDispDefine.SEARCH_TRANINFO_TYPE.GetLength(0); iLp1++)
                {  // 行数分繰り返す
                    if (m_csDBPCtlInfo.GetParentsScreenKind().Equals(HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, 0, 0]) == true)
                    {  // 親画面種別が一致した場合
                        for (iLp2 = 0; iLp2 < HySDispDefine.SEARCH_TRANINFO_TYPE.GetLength(1); iLp2++)
                        {  // 行数分繰り返す
                            if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 1] is HySKind)
                            {  // 伝送情報名は有効な場合
                                string sComkey = this.TranInfoTypeComboBox.Items[this.TranInfoTypeComboBox.SelectedIndex].ToString();
                                if (sComkey.Equals(HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 1].ToString()) == true)
                                {  // データタイプ名称が一致の場合
                                    csKeyCondition += ",";
                                    if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 2] is HySObjectKind)
                                    {  // 検索データタイプが有効な場合
                                        csKeyCondition += HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 2].ToString();
                                    }
                                    csKeyCondition += ",";
                                    if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 3] is HySObjectKind)
                                    {  // データ次元１が有効な場合
                                        csKeyCondition += HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 3].ToString();
                                    }
                                    csKeyCondition += ",";
                                    if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 4] is HySObjectKind)
                                    {  // データ次元２が有効な場合
                                        csKeyCondition += HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 4].ToString();
                                    }
                                    csKeyCondition += ",";
                                    if (HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 5] is HySObjectKind)
                                    {  // データ次元３が有効な場合
                                        csKeyCondition += HySDispDefine.SEARCH_TRANINFO_TYPE[iLp1, iLp2, 5].ToString();
                                    }
                                    break;
                                }
                            }
                        }
                        break;
                    }
                }
                m_csQueryCondition.AddLast(csKeyCondition); // 検索条件データ登録
            }
            // 抽出条件をリストに再設定
            csDataGridView.Rows.Clear();
            csDataGridView.RowCount = 1;
            for (iLp = 0; iLp < csQueryConditionLocal.GetCount(); iLp++)
            {  // 行数分繰り返す
                csKeyCondition = (HySString)csQueryConditionLocal.GetData((long)iLp);
                string[] sInWk;
                sInWk = csKeyCondition.ToString().Split(',');
                SetDataGRidView(csDataGridView, sInWk);
                csKeyCondition = null;
            }
            csQueryConditionLocal = null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            m_csScreen.CloseScreen();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>検索条件ファイル取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetFileSerachCondition( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetFileSerachCondition()
        {
            // XMLファイル取得
            HySString csFilePass = new HySString(HySEnvInf.GetHomeDirectory().ToString() + SEARCHCONDITIONFILEPASS);
            HySXmlReader csXmlReader = new HySXmlReader(csFilePass);
            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
            if (csXmlRootNode is HySXmlNode)
            {  // XMLファイルが有る場合
                int iLp2, iLp3;
                HySXmlNode csXmlChildNode;
                HySXmlNode csXmlGrandChildNode;
                HySXmlNodeList csXmlChildNodeList = csXmlRootNode.GetChildNodeList();
                HySXmlNodeList csXmlGrandChildNodeList;
                HySString csKeyCondition = null;
                string[] sWkInfo = { "", "", "", "", "", "", "", "", "", "", "", "" };
                for (int iLp1 = 0; iLp1 < csXmlChildNodeList.GetCount(); iLp1++)
                {  // 子ノード分繰り返す
                    csXmlChildNode = csXmlChildNodeList.GetNode(iLp1); // 子ノード取得
                    if (csXmlChildNode is HySXmlNode)
                    {  // 子ノードが有効の場合
                        if (csXmlChildNode.GetName().Equals(QUERYCONDITIONKEY) == true)
                        {  // 抽出条件が有る場合
                            csXmlGrandChildNodeList = csXmlChildNode.GetChildNodeList();
                            for (iLp2 = 0; iLp2 < csXmlGrandChildNodeList.GetCount(); iLp2++)
                            {  // 抽出条件数分繰り返す
                                csXmlGrandChildNode = csXmlGrandChildNodeList.GetNode(iLp2);
                                // ＸＭＬファイルの手動変更対応の為、タグ毎取得
                                for (iLp3 = 0; iLp3 < m_sKeys.Length; iLp3++)
                                {  // 抽出条件タグ数分繰り返す
                                    if (csXmlGrandChildNode.GetName().Equals(m_sKeys[iLp3]) == true)
                                    {  // タグが一致した場合
                                        sWkInfo[iLp3] = csXmlGrandChildNode.GetInnerText();
                                        sWkInfo[iLp3].Trim();
                                        break;
                                    }
                                }
                            }
                            // 取得タグの結合編集
                            csKeyCondition = new HySString();
                            for (iLp2 = 0; iLp2 < sWkInfo.Length; iLp2++)
                            {  // 抽出条件分繰り返す
                                csKeyCondition += new HySString(sWkInfo[iLp2]);
                                if ((iLp2 + 1) != sWkInfo.Length)
                                {  // 最終項目以外の場合
                                    csKeyCondition += new HySString(","); // 区切り挿入
                                }
                                sWkInfo[iLp2] = "";
                            }
                            m_csQueryCondition.AddLast(csKeyCondition); // 抽出条件設定
                            csKeyCondition = null;
                        }
                        else if (csXmlChildNode.GetName().Equals(PRECONDITIONKEY) == true)
                        {  // 共通条件条件が有る場合
                            csXmlGrandChildNodeList = csXmlChildNode.GetChildNodeList();
                            for (iLp2 = 0; iLp2 < csXmlGrandChildNodeList.GetCount(); iLp2++)
                            {  // 抽出条件数分繰り返す
                                csXmlGrandChildNode = csXmlGrandChildNodeList.GetNode(iLp2);
                                // ＸＭＬファイルの手動変更対応の為、タグ毎取得
                                for (iLp3 = 0; iLp3 < m_sPreconditionKeys.Length; iLp3++)
                                {  // 抽出条件タグ数分繰り返す
                                    if (csXmlGrandChildNode.GetName().Equals(m_sPreconditionKeys[iLp3]) == true)
                                    {  // タグが一致した場合
                                        string sComKey = csXmlGrandChildNode.GetInnerText();
                                        sComKey.Trim();
                                        switch (iLp3)
                                        {
                                            case 0: // Max検索数
                                                this.MaxNumberNumericUpDown.Value = decimal.Parse(sComKey);
                                                break;
                                            case 1: // データタイプ
                                                // 検索対象伝送情報型を表示
                                                if (this.TranInfoTypeComboBox.Items.Count > 1)
                                                {  // データタイプが複数有る場合
                                                    for (int iLp = 0; iLp < this.TranInfoTypeComboBox.Items.Count; iLp++)
                                                    {  // 行数分繰り返す
                                                        if (sComKey.Equals(this.TranInfoTypeComboBox.Items[iLp].ToString()) == true)
                                                        {  // 項目が一致した場合
                                                            this.TranInfoTypeComboBox.SelectedIndex = iLp;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            default: // その他
                                                break;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            csXmlReader = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>検索条件ファイル出力</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetFileSerachCondition( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetFileSerachCondition()
        {
            int iLp;
            HySXmlNode csNode;

            // XMLファイル作成
            HySString csFilePass = new HySString(HySEnvInf.GetHomeDirectory().ToString() + SEARCHCONDITIONFILEPASS);
            HySXmlWriter csXmlWriter = new HySXmlWriter(csFilePass);
            HySXmlNode csRootNode = csXmlWriter.CreateRoot(SEARCHCONDITIONKEY);

            // 前提条件設定
            HySXmlNode csPreconditionNode = HySXmlNode.CreateElement(PRECONDITIONKEY, csXmlWriter);
            csRootNode.AppendChild(csPreconditionNode);
            for (iLp = 0; iLp < m_sPreconditionKeys.GetLength(0); iLp++)
            {
                string sItem = "";
                switch (iLp)
                {
                    case 0: // Max検索数
                        sItem = this.MaxNumberNumericUpDown.Value.ToString();
                        break;
                    case 1: // データタイプ
                        sItem = this.TranInfoTypeComboBox.Items[this.TranInfoTypeComboBox.SelectedIndex].ToString();
                        break;
                    default: // その他
                        break;
                }
                csNode = HySXmlNode.CreateElement(m_sPreconditionKeys[iLp], csXmlWriter);
                if (sItem.Length <= 0)
                {  // 空白文字の補正
                    sItem = m_sNonKey;
                }
                csNode.SetInnerText(sItem);
                csPreconditionNode.AppendChild(csNode);
            }

            // 抽出条件設定
            for (iLp = 0; iLp < m_csQueryConditionBuf.GetCount(); iLp++)
            {
                //抽出条件ノード
                HySXmlNode csParentNode = HySXmlNode.CreateElement(QUERYCONDITIONKEY, csXmlWriter);
                csRootNode.AppendChild(csParentNode);
                // 抽出条件編集
                HySString csDt = (HySString)m_csQueryConditionBuf.GetData((long)iLp);
                string[] sInWk;
                sInWk = csDt.ToString().Split(',');
                for (int iLp2 = 0; iLp2 < sInWk.Length; iLp2++)
                {
                    csNode = HySXmlNode.CreateElement(m_sKeys[iLp2], csXmlWriter);
                    if (sInWk[iLp2].Length <= 0)
                    {  // 空白文字の補正
                        sInWk[iLp2] = m_sNonKey;
                    }
                    csNode.SetInnerText(sInWk[iLp2]);
                    csParentNode.AppendChild(csNode);
                }
            }
            csXmlWriter.Save(); // XML格納
            csXmlWriter = null;
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_REPORT_0002,
                        ((HySDotNetViewer)((HySSearchConditionScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetSearchConditionGISForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetSearchConditionGISForm_Activated(object sender, EventArgs e)
        {
            base.HySReportSearchFormBase_Activated(sender, e);
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent()
        {
            // Undo処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    if (m_csTextBox.CanUndo == true)
                    {
                        m_csTextBox.Undo();
                    }
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    if (csTextbox.CanUndo == true)
                    {
                        csTextbox.Undo();
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent()
        {
            // Cut処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    m_csTextBox.Cut();
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    csTextbox.Cut();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent()
        {
            // Copy処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    m_csTextBox.Copy();
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    csTextbox.Copy();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent()
        {
            // Paste処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    m_csTextBox.Paste();
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    csTextbox.Paste();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent()
        {
            // Del処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    if (m_csTextBox.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        m_csTextBox.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    m_csTextBox.SelectedText = string.Empty;
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    if (csTextbox.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        csTextbox.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    csTextbox.SelectedText = string.Empty;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent()
        {
            // AllSelect処理
            if (this.DataGridView_Calc_Result.EditingControl != null)
            {
                if (m_csTextBox != null)
                {
                    m_csTextBox.SelectAll();
                }
            }
            else if (this.ActiveControl.Name == "MaxNumberNumericUpDown")
            {
                // NumericUpDownのControlsコレクションの2番目の要素がテキストボックス部分なので取得する
                TextBox csTextbox = (TextBox)this.MaxNumberNumericUpDown.GetNextControl(this.MaxNumberNumericUpDown, false);
                if (csTextbox != null)
                {
                    csTextbox.SelectAll();
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>非アクティブイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetSearchConditionGISForm_Deactivate(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetSearchConditionGISForm_Deactivate(object sender, EventArgs e)
        {
            base.HySReportSearchFormBase_Deactivate(sender, e);
        }

        /// <summary><para>method outline</para>
        /// <para>DataGridView行削除時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataGridView_Calc_Result_UserDeletedRow(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataGridView_Calc_Result_UserDeletedRow(object sender, DataGridViewRowEventArgs e)
        {
            // Shift+Delキー押下による行削除防止
            DataGridView csSender = (this.SearchTabControl.SelectedIndex == 0) ? this.DataGridView_Calc_Result : this.DataGridView_External;
            if (csSender.Rows.Count == 0)
            {  // ヘッダ行だけの場合
                csSender.Rows.Add(1);
            }
        }
    }
}
