﻿// <summary>ソースコード：>河道縦断面グラフレポート編集</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>河道縦断面グラフレポート編集</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySReporRiverbedData : HySDataRoot, HySVersionManagement
    {
        /// <summary>河道縦断面データ</summary>
        HySRiverbedData m_csRiverbedData = null;

        /// <summary>河道列データ</summary>
        HySGraphLineLaneKilo m_csGraphLineLaneKilo = null;

        /// <summary>データテーブル</summary>
        DataTable m_csDataTable = null;

        /// <summary>データテーブルキー情報</summary>
        Hashtable m_csDataKeys = null;

        /// <summary>データテーブル列管理情報</summary>
        DataTable m_csColTable = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReporRiverbedData csReportData = new HySReporRiverbedData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySReporRiverbedData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySReporRiverbedData()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReporRiverbedData csReportData = new HySReporRiverbedData(csDataTable,csDataKeys,csColTable)</para>
        /// </example>
        /// <param name="csDataTable">データテーブルのインスタンス</param>
        /// <param name="csDataKeys">データテーブルキー情報のインスタンス</param>
        /// <param name="csColTable">データテーブル列管理情報のインスタンス</param>
        /// <returns>HySReporRiverbedData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySReporRiverbedData(DataTable csDataTable, Hashtable csDataKeys, DataTable csColTable)
        {
            m_csDataTable = csDataTable;
            m_csDataKeys = csDataKeys;
            m_csColTable = csColTable;

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>登録データ追加展開</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTableAdd(csStockData,csCustomizInfo)</para>
        /// </example>
        /// <param name="csStockData">登録データ本体</param>
        /// <param name="csCustomizInfo">グラフカスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DataTableAdd(HySDataRoot csStockData, HySRptCustomizInfo csCustomizInfo)
        {
            int iRow = 0;
            double dXMax = 0;
            double dXMin = 0;
            double dYMax = 0;
            double dYMin = 0;
            double[] dBase = null;
            double[] dData = null;
            long lDataCnt = 0;
            int iColumn = 0;
            int iLp = 0;
            DataRow csColRow = null;
            DataRow csRows = null;
            String csTimeKey = "";
            HySID csRiverID = null;
            int iCnt = 0;
            long lIndex = 0; // フィールド順位（固定）
            string sXScaleName = "";
            string sYScaleName = "";
            string sItemTitle1 = "";
            string sItemTitle2 = "";

            m_csRiverbedData = csStockData as HySRiverbedData;
            if (m_csRiverbedData is HySRiverbedData)
            {  // データが河道縦断面データグラフデータの場合
                //
                // 河床標高値用勾配図作成
                lDataCnt = m_csRiverbedData.GetAltitudeDataNum(); // データ件数取得
                if (lDataCnt > 0)
                {  // データが有る場合
                    csCustomizInfo.GetScaleCommonData((int)lIndex, ref sItemTitle1, ref sXScaleName
                                                                 , ref sItemTitle2, ref sYScaleName);
                    if (m_csDataTable.Columns.Count <= 0)
                    {  // 初回設定の場合
                        m_csDataTable.Columns.Add("TimeData", typeof(double));  // 列追加
                        // 列管理情報初期設定
                        dXMax = HySReportDefine.DOUBLE_MIN;
                        dXMin = HySReportDefine.DOUBLE_MAX;
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        csColRow = m_csColTable.NewRow(); // 先頭基準行生成
                        csColRow["DataKind"] = "ALL";     // データ種別
                        csColRow["Max"] = dXMax;          // データ種別
                        csColRow["Min"] = dXMin;          // データ種別
                        csColRow["ChartName"] = sXScaleName;// Ｘ軸
                        csColRow["ItemName"] = sItemTitle1; // 列名
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);  // 先頭基準行追加
                        csColRow = m_csColTable.NewRow(); // データ列管理行生成
                        csColRow["DataKind"] = HySDispDefine.CSKIND_RIVERBEDSERIALE.ToString(); // データ種別
                        csColRow["Max"] = dYMax;          // データ種別
                        csColRow["Min"] = dYMin;          // データ種別
                        csColRow["ChartName"] = sYScaleName; // Ｙ軸
                        csRiverID = m_csRiverbedData.GetRiverID();
                        iCnt = 0;
                        for (iLp = 0; iLp < m_csColTable.Rows.Count; iLp++)
                        {
                            if (m_csColTable.Rows[iLp]["ItemName"].ToString().Contains(sItemTitle2) == true)
                            {  // フィールド列既存の場合
                                iCnt++;
                                m_csColTable.Rows[iLp]["ItemName"] = sItemTitle2 + iCnt.ToString(); // 列名
                            }
                        }
                        if (iCnt != 0)
                        {  // 同列グループが有る場合
                            csColRow["ItemName"] = sItemTitle2 + ((int)(iCnt + 1)).ToString(); // 列名
                        }
                        else
                        {  // 同列グループが無い場合
                            csColRow["ItemName"] = sItemTitle2; // 列名
                        }
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);  // 行追加
                    }
                    else
                    {  // 継続設定の場合
                        dXMax = (double)m_csColTable.Rows[0]["Max"];
                        dXMin = (double)m_csColTable.Rows[0]["Min"];
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        csColRow = m_csColTable.NewRow();    // データ列管理行生成
                        csColRow["DataKind"] = HySDispDefine.CSKIND_RIVERBEDSERIALE.ToString(); // データ種別
                        csColRow["Max"] = dYMax;             // データ種別
                        csColRow["Min"] = dYMin;             // データ種別
                        csColRow["ChartName"] = sYScaleName; // Ｙ軸
                        csRiverID = m_csRiverbedData.GetRiverID();
                        iCnt = 0;
                        for (iLp = 0; iLp < m_csColTable.Rows.Count; iLp++)
                        {
                            if (m_csColTable.Rows[iLp]["ItemName"].ToString().Contains(sItemTitle2) == true)
                            {  // フィールド列既存の場合
                                iCnt++;
                                m_csColTable.Rows[iLp]["ItemName"] = sItemTitle2 + iCnt.ToString(); // 列名
                            }
                        }
                        if (iCnt != 0)
                        {  // 同列グループが有る場合
                            csColRow["ItemName"] = sItemTitle2 + ((int)(iCnt + 1)).ToString(); // 列名
                        }
                        else
                        {  // 同列グループが無い場合
                            csColRow["ItemName"] = sItemTitle2; // 列名
                        }
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);              // 行追加
                    }
                    iColumn = m_csDataTable.Columns.Count;            // データ列数取得
                    m_csDataTable.Columns.Add("Data" + iColumn.ToString(), typeof(double)); // データ列追加
                    dBase = m_csRiverbedData.GetAltKiloDataDim();     // 河口からの距離データ配列取得
                    dData = m_csRiverbedData.GetAltitudeDataDim();    // 標高データ配列取得
                    for (iLp = 0; iLp < lDataCnt; iLp++)
                    {  // データ件数分繰り返す
                        csTimeKey = dBase[iLp].ToString();            // ハッシュキー生成
                        iRow = 0;
                        if (m_csDataKeys[csTimeKey] is int)
                        {  // 該当ハッシュキーの行が有る場合
                            iRow = (int)m_csDataKeys[csTimeKey]; // 行番号取得
                        }
                        if (iRow > 0)
                        {  // 既存時系行が有る場合
                            m_csDataTable.Rows[iRow - 1]["Data" + iColumn.ToString()] = dData[iLp]; // データ追加
                        }
                        else
                        {  // 既存時系列行が無い場合
                            csRows = m_csDataTable.NewRow(); // 行生成
                            csRows["TimeData"] = dBase[iLp]; // 時刻設定
                            csRows["Data" + iColumn.ToString()] = dData[iLp]; // データ設定
                            m_csDataTable.Rows.Add(csRows);  // 行追加
                            iRow = m_csDataTable.Rows.Count;
                            m_csDataKeys[csTimeKey] = iRow;  // 挿入位置記憶
                        }
                        // データ値の最大／最小を更新
                        if (dXMin > dBase[iLp])
                        {  // Ｘ軸最小値更新の場合
                            dXMin = dBase[iLp];
                        }
                        if (dXMax < dBase[iLp])
                        {  // Ｘ軸最大値更新の場合
                            dXMax = dBase[iLp];
                        }
                        if (dYMin > dData[iLp])
                        {  // Ｙ軸最小値更新の場合
                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                            {  // 欠側値以外の場合
                                dYMin = dData[iLp];
                            }
                        }
                        if (dYMax < dData[iLp])
                        {  // Ｙ軸最大値更新の場合
                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                            {  // 欠側値以外の場合
                                dYMax = dData[iLp];
                            }
                        }
                    }
                    // データ値の最大／最小を再設定
                    m_csColTable.Rows[0]["Max"] = dXMax;
                    m_csColTable.Rows[0]["Min"] = (dXMin > 0)? 0: dXMin;
                    m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Max"] = dYMax;
                    m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Min"] = dYMin;
                    //
                    // 河道データ列から勾配図作成
                    long lDataNum = m_csRiverbedData.GetGraphNum();
                    if (lDataNum > 0)
                    {  // 登録データがある場合
                        HySID[] csID = (HySID[])m_csRiverbedData.GetGraphIDList(); // 登録グラフＩＤ一覧取得
                        for (long lP = 0; lP < lDataNum; lP++)
                        {  // 登録データ件数分繰り返す
                            m_csGraphLineLaneKilo = (HySGraphLineLaneKilo)m_csRiverbedData.GetGraph(csID[(int)lP]); // 河道縦断グラフ取得
                            if (m_csGraphLineLaneKilo is HySGraphLineLaneKilo)
                            {  // データが有る場合
                                HySObjectKind csDataKind = m_csGraphLineLaneKilo.GetDataMeaning();
                                if (csDataKind is HySObjectKind)
                                {  // データの種別が有る場合
                                    if (csDataKind.Equals(HySDispDefine.CSKIND_RIVERBEDSERIALE) == true)
                                    {  // 河道縦断面グラフデータの場合
                                        dXMax = (double)m_csColTable.Rows[0]["Max"];
                                        dXMin = (double)m_csColTable.Rows[0]["Min"];
                                        dYMax = HySReportDefine.DOUBLE_MIN;
                                        dYMin = HySReportDefine.DOUBLE_MAX;
                                        csColRow = m_csColTable.NewRow();     // データ列管理行生成
                                        csColRow["DataKind"] = HySDispDefine.CSKIND_RIVERBEDSERIALE.ToString(); // データ種別
                                        csColRow["Max"] = dYMax; // データ種別
                                        csColRow["Min"] = dYMin; // データ種別
                                        csColRow["ChartName"] = sYScaleName; // Ｙ軸
                                        csRiverID = m_csRiverbedData.GetRiverID();
                                        iCnt = 0;
                                        for (iLp = 0; iLp < m_csColTable.Rows.Count; iLp++)
                                        {
                                            if (m_csColTable.Rows[iLp]["ItemName"].ToString().Contains(sItemTitle2) == true)
                                            {  // フィールド列既存の場合
                                                iCnt++;
                                                m_csColTable.Rows[iLp]["ItemName"] = sItemTitle2 + iCnt.ToString(); // 列名
                                            }
                                        }
                                        if (iCnt != 0)
                                        {  // 同列グループが有る場合
                                            csColRow["ItemName"] = sItemTitle2 + ((int)(iCnt + 1)).ToString(); // 列名
                                        }
                                        else
                                        {  // 同列グループが無い場合
                                            csColRow["ItemName"] = sItemTitle2; // 列名
                                        }
                                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                                        m_csColTable.Rows.Add(csColRow); // 行追加
                                        iColumn = m_csDataTable.Columns.Count; // データ列数取得
                                        m_csDataTable.Columns.Add("Data" + iColumn.ToString(), typeof(double)); // データ列追加
                                        lDataCnt = m_csGraphLineLaneKilo.GetDataNum(); // データ件数取得
                                        dBase = m_csGraphLineLaneKilo.GetBaseDim();
                                        dData = m_csGraphLineLaneKilo.GetDataDim();
                                        for (iLp = 0; iLp < lDataCnt; iLp++)
                                        {  // データ件数分繰り返す
                                            csTimeKey = dBase[iLp].ToString(); // ハッシュキー生成
                                            iRow = 0;
                                            if (m_csDataKeys[csTimeKey] is int)
                                            {  // 該当ハッシュキーの行が有る場合
                                                iRow = (int)m_csDataKeys[csTimeKey]; // 行番号取得
                                            }
                                            if (iRow > 0)
                                            {  // 既存時系行が有る場合
                                                m_csDataTable.Rows[iRow - 1]["Data" + iColumn.ToString()] = dData[iLp]; // データ追加
                                            }
                                            else
                                            {  // 既存時系列行が無い場合
                                                csRows = m_csDataTable.NewRow(); // 行生成
                                                csRows["TimeData"] = dBase[iLp]; // 時刻設定
                                                csRows["Data" + iColumn.ToString()] = dData[iLp]; // データ設定
                                                m_csDataTable.Rows.Add(csRows);  // 行追加
                                                iRow = m_csDataTable.Rows.Count;
                                                m_csDataKeys[csTimeKey] = iRow;  // 挿入位置記憶
                                            }
                                            // データ値の最大／最小を更新
                                            if (dXMin > dBase[iLp])
                                            {  // Ｘ軸最小値更新の場合
                                                dXMin = dBase[iLp];
                                            }
                                            if (dXMax < dBase[iLp])
                                            {  // Ｘ軸最大値更新の場合
                                                dXMax = dBase[iLp];
                                            }
                                            if (dYMin > dData[iLp])
                                            {  // Ｙ軸最小値更新の場合
                                                if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                {  // 欠側値以外の場合
                                                    dYMin = dData[iLp];
                                                }
                                            }
                                            if (dYMax < dData[iLp])
                                            {  // Ｙ軸最大値更新の場合
                                                if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                {  // 欠側値以外の場合
                                                    dYMax = dData[iLp];
                                                }
                                            }
                                        }
                                        // データ値の最大／最小を再設定
                                        m_csColTable.Rows[0]["Max"] = dXMax;
                                        m_csColTable.Rows[0]["Min"] = (dXMin > 0) ? 0 : dXMin;
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Max"] = dYMax;
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Min"] = dYMin;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
