﻿// <summary>ソースコード：ＨＹＳＳＯＰレポート定義情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>レポート定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public static class HySReportDefine
    {
        // =====================================
        // start of クラス内 定数定義
        // =====================================

        // レポート定義ファイル関連
        /// <summary>折れ線グラフ定義レポートパス</summary>
        //static public readonly string LINE_RDLC_PASS = "\\SystemData\\format\\GraphLineBase.rdlc";
        static public readonly string LINE_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "GraphLineBase.rdlc";
        /// <summary>棒グラフ定義レポートパス</summary>
        //static public readonly string COLUMN_RDLC_PASS = "\\SystemData\\format\\GraphColumnBase.rdlc";
        static public readonly string COLUMN_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "GraphColumnBase.rdlc";
        /// <summary>面グラフ定義レポートパス</summary>
        //static public readonly string AREA_RDLC_PASS = "\\SystemData\\format\\GraphAreaBase.rdlc";
        static public readonly string AREA_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "GraphAreaBase.rdlc";
        /// <summary>撒布図定義レポートパス</summary>
        //static public readonly string SCATTER_RDLC_PASS = "\\SystemData\\format\\GraphScatterBase.rdlc";
        static public readonly string SCATTER_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "GraphScatterBase.rdlc";
        /// <summary>下敷き画面－グラフ定義レポートパス</summary>
        //static public readonly string GRAPHREPORT_BASE_RDLC_PASS = "\\SystemData\\format\\GraphReportBase.rdlc";
        static public readonly string GRAPHREPORT_BASE_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "GraphReportBase.rdlc";
        /// <summary>下敷き画面－テーブル定義レポートパス</summary>
        //static public readonly string TABLEREPORT_RDLC_PASS = "\\SystemData\\format\\TableListReportBase.rdlc";
        static public readonly string TABLEREPORT_RDLC_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "TableListReportBase.rdlc";
        /// <summary>下敷き画面－ハイエト／ハイドログラフ定義レポートパス</summary>
        //static public readonly string HYDROGRAPHREPORT_BASE_PASS = "\\SystemData\\format\\HydroGraphReportBase.rdlc";
        static public readonly string HYDROGRAPHREPORT_BASE_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "HydroGraphReportBase.rdlc";
        /// <summary>下敷き画面－河川水位縦断図定義レポートパス</summary>
        //static public readonly string RIVERBEDREPORT_BASE_PASS = "\\SystemData\\format\\RiverbedReportBase.rdlc";
        static public readonly string RIVERBEDREPORT_BASE_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "RiverbedReportBase.rdlc";
        /// <summary>下敷き画面－Ｈ－Ｑ定義レポートパス</summary>
        //static public readonly string HQREPORT_BASE_PASS = "\\SystemData\\format\\HQReportBase.rdlc";
        static public readonly string HQREPORT_BASE_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "HQReportBase.rdlc";

        // グラフ描画軸関連
        /// <summary>Ｘ軸汎用描画方向（下側）</summary>
        static public readonly string VALUEUNDER_LABEL= "Value_UnderLabel";
        /// <summary>Ｘ軸汎用描画方向（上側）</summary>
        static public readonly string VALUETOP_LABEL = "Value_TopLabel";
        /// <summary>Ｙ軸汎用描画方向（左側）</summary>
        static public readonly string VALUELEFT_LABEL = "Value_LeftLabel";
        /// <summary>Ｙ軸汎用描画方向（右側）</summary>
        static public readonly string VALUERIGHT_LABEL = "Value_RightLabel";
        /// <summary>Ｘ軸時系列描画方向（下側）</summary>
        static public readonly string TIMEUNDER_LABEL = "Time_UnderLabel";
        /// <summary>Ｘ軸時系列描画方向（上側）</summary>
        static public readonly string TIMETOP_LABEL = "Time_TopLabel";
        /// <summary>Ｙ軸時系列描画方向（左側）</summary>
        static public readonly string TIMELEFT_LABEL = "Time_LeftLabel";
        /// <summary>Ｙ軸時系列描画方向（右側）</summary>
        static public readonly string TIMERIGHT_LABEL = "Time_RightLabel";

        // グラフ描画系列関連
        /// <summary>時間タイトル</summary>
        static public readonly string GRAPH_TIME = Properties.HysDotNetViewerResources.GRAPH_TIME;  //"時間"
        /// <summary>水位タイトル</summary>
        static public readonly string GRAPH_WATER_LEVEL = Properties.HysDotNetViewerResources.GRAPH_WATER_LEVEL;    //"水位"
        /// <summary>流量タイトル</summary>
        static public readonly string GRAPH_FLOWING_QUANTITY = Properties.HysDotNetViewerResources.GRAPH_FLOWING_QUANTITY;  //"流量"
        /// <summary>雨量タイトル</summary>
        static public readonly string GRAPH_RAINFALL = Properties.HysDotNetViewerResources.GRAPH_RAINFALL;  //"雨量"
        /// <summary>距離タイトル</summary>
        static public readonly string GRAPH_DISTANCE = Properties.HysDotNetViewerResources.GRAPH_DISTANCE;  //"縦断距離"
        /// <summary>河床高タイトル</summary>
        static public readonly string GRAPH_RIVERBED_AMOUNT = Properties.HysDotNetViewerResources.GRAPH_RIVERBED_AMOUNT;    //"河床高";
        /// <summary>基準水面高タイトル</summary>
        static public readonly string GRAPH_STANDARD_WATER_AMOUNT = Properties.HysDotNetViewerResources.GRAPH_STANDARD_WATER_AMOUNT;    //"基準水位"
        /// <summary>水面高タイトル</summary>
        static public readonly string GRAPH_WATER_AMOUNT = Properties.HysDotNetViewerResources.GRAPH_WATER_AMOUNT;  //"水位"
        /// <summary>標高タイトル</summary>
        static public readonly string GRAPH_ALTITUDE = Properties.HysDotNetViewerResources.GRAPH_ALTITUDE;  //"標高"
        /// <summary>汎用タイトル</summary>
        static public readonly string GRAPH_DATA = "";

        /// <summary>データＸ軸基準種別定義</summary>
        public enum XSCALE_KIND
        {
            /// <summary>時系列データ</summary>
            TIME_SERIES_DATA = 1,
            /// <summary>一般線データ</summary>
            COMMON_LINE_DATA
        }

        // 設定保存ＸＭＬタグ関連
        /// <summary>Ｘ軸（下）</summary>
        static public readonly string TAG_UNDERLABEL = "UnderLabel";
        /// <summary>Ｘ軸（上）</summary>
        static public readonly string TAG_TOPLABEL = "TopLabel";
        /// <summary>Ｙ軸（左）</summary>
        static public readonly string TAG_LEFTLABEL = "LeftLabel";
        /// <summary>Ｙ軸（右）</summary>
        static public readonly string TAG_RIGHTLABEL = "RightLabel";
        /// <summary>凡例表示位置-上段左側</summary>
        static public readonly string TAG_LEGEND_TOPLEFT = "TopLeft";
        /// <summary>凡例表示位置-上段中央</summary>
        static public readonly string TAG_LEGEND_TOPCENTER = "TopCenter";
        /// <summary>凡例表示位置-上段右側</summary>
        static public readonly string TAG_LEGEND_TOPRIGHT = "TopRight";
        /// <summary>凡例表示位置-下段左側</summary>
        static public readonly string TAG_LEGEND_BOTTOMLEFT = "BottomLeft";
        /// <summary>凡例表示位置-下段中央</summary>
        static public readonly string TAG_LEGEND_BOTTOMCENTER = "BottomCenter";
        /// <summary>凡例表示位置-下段右側</summary>
        static public readonly string TAG_LEGEND_BOTTOMRIGHT = "BottomRight";
        /// <summary>凡例表示位置-左端上段</summary>
        static public readonly string TAG_LEGEND_LEFTTOP = "LeftTop";
        /// <summary>凡例表示位置-左端中央</summary>
        static public readonly string TAG_LEGEND_LEFTCENTER = "LeftCenter";
        /// <summary>凡例表示位置-左端下段</summary>
        static public readonly string TAG_LEGEND_LEFTBOTTOM = "LeftBottom";
        /// <summary>凡例表示位置-右端上段</summary>
        static public readonly string TAG_LEGEND_RIGHTTOP = "RightTop";
        /// <summary>凡例表示位置-右端中央</summary>
        static public readonly string TAG_LEGEND_RIGHTCENTER = "RightCenter";
        /// <summary>凡例表示位置-右端下段</summary>
        static public readonly string TAG_LEGEND_RIGHTBOTTOM = "RightBottom";
        /// <summary>軸種別-時系列</summary>
        static public readonly string TAG_KIND_TIMESERIES = "TimeSeries";
        /// <summary>軸種別-値</summary>
        static public readonly string TAG_KIND_VALUE = "Value";
        /// <summary>線種-折れ線グラフ</summary>
        static public readonly string TAG_TYPE_LINE = "Line";
        /// <summary>線種-面グラフ</summary>
        static public readonly string TAG_TYPE_AREA = "Area";
        /// <summary>線種-縦棒グラフ</summary>
        static public readonly string TAG_TYPE_COLUMN = "Column";
        /// <summary>線種-撒布図グラフ</summary>
        static public readonly string TAG_TYPE_SCATTERE = "Scatter";
        /// <summary>線種-Sub種別（スムージング）</summary>
        static public readonly string TAG_SUBTYPE_SMOOTH = "Smooth";
        /// <summary>線種-Sub種別（塗潰し）</summary>
        static public readonly string TAG_SUBTYPE_PLAIN = "Plain";
        /// <summary>指定-自動</summary>
        static public readonly string TAG_AUTO = "Auto";
        /// <summary>指定-手動</summary>
        static public readonly string TAG_MANUAL = "Manual";
        /// <summary>指定-有効</summary>
        static public readonly string TAG_TRUE = "true";
        /// <summary>指定-無効</summary>
        static public readonly string TAG_FALSE = "false";
        /// <summary>系列－時系列</summary>
        static public readonly string TAG_DATATIME = "Fields!DataTimeDate.Value";
        /// <summary>系列－値列</summary>
        static public readonly string TAG_DATADOULE = "Fields!DataDouble.Value";
        /// <summary>順方向基準ポジション</summary>
        static public readonly string TAG_TOP188 = "1.88";
        /// <summary>異種方向基準ポジション（上→下）</summary>
        static public readonly string TAG_TOP178 = "1.78";
        /// <summary>異種方向基準ポジション（下→上）</summary>
        static public readonly string TAG_TOP198 = "1.98";

        // 規定値・閾値関連
        /// <summary>河川データ欠側値</summary>
        static public readonly double MISSING_VALUE = -1.0E38; //- 9999.0;
        /// <summary>実数Max閾値</summary>
        static public readonly double DOUBLE_MAX = +1.0E32;
        /// <summary>実数Min閾値</summary>
        static public readonly double DOUBLE_MIN = -1.0E32;

        // CommonMP共通表示フォーマット種別識別
        /// <summary>1次元縦断データ画面（アニメーション用）</summary>
        static public readonly HySKind DISP_ANIMATION_FORM_RIVERBED_SHAPE = new HySObjectKind("DispAnimationFormRiverbedShape");

        // =====================================
        // end of クラス内 定数定義
        // =====================================
    }
}
