﻿// <summary>ソースコード：>時系列グラフレポート編集</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>時系列グラフレポート編集</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySReportLineTimeSeries : HySDataRoot, HySVersionManagement
    {
        /// <summary>時系列グラフデータ</summary>
        HySGraphLineTimeSeries m_csGraphLineTimeSeries = null;

        /// <summary>データテーブル</summary>
        DataTable m_csDataTable = null;

        /// <summary>データテーブルキー情報</summary>
        Hashtable m_csDataKeys = null;

        /// <summary>データテーブル列管理情報</summary>
        DataTable m_csColTable = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReportLineTimeSeries csReportData = new HySReportLineTimeSeries()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySReportLineTimeSeries  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySReportLineTimeSeries()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReportLineTimeSeries csReportData = new HySReportLineTimeSeries(csDataTable,csDataKeys,csColTable)</para>
        /// </example>
        /// <param name="csDataTable">データテーブルのインスタンス</param>
        /// <param name="csDataKeys">データテーブルキー情報のインスタンス</param>
        /// <param name="csColTable">データテーブル列管理情報のインスタンス</param>
        /// <returns>HySReportLineTimeSeries  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySReportLineTimeSeries(DataTable csDataTable, Hashtable csDataKeys, DataTable csColTable)
        {
            m_csDataTable = csDataTable;
            m_csDataKeys = csDataKeys;
            m_csColTable = csColTable;

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>登録データ追加展開</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTableAdd(csStockData,csCustomizInfo)</para>
        /// </example>
        /// <param name="csStockData">登録データ本体</param>
        /// <param name="csCustomizInfo">グラフカスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DataTableAdd(HySDataRoot csStockData, HySRptCustomizInfo csCustomizInfo)
        {
            int iRow = 0;
            double dXMax = 0;
            double dXMin = 0;
            double dYMax = 0;
            double dYMin = 0;
            long lIndex = 0; // フィールド順位（固定）
            string sXScaleName = "";
            string sYScaleName = "";
            string sItemTitle1 = "";
            string sItemTitle2 = "";
            string sItemTitleWk = "";

            m_csGraphLineTimeSeries = csStockData as HySGraphLineTimeSeries;
            if (m_csGraphLineTimeSeries is HySGraphLineTimeSeries)
            {  // データが有る場合
                HySObjectKind csDataKind = m_csGraphLineTimeSeries.GetDataMeaning();
                if (csDataKind is HySObjectKind)
                {  // データの種別が有る場合
                    csCustomizInfo.GetScaleCommonData((int)lIndex, ref sItemTitle1 , ref sXScaleName
                                                                 , ref sItemTitleWk, ref sYScaleName);
                    if (sItemTitleWk.Length <= 0)
                    {  // 系列名の指定が無い場合
                        for (int iLp = 0; iLp < HySDataKindDefine.m_DataKindList.GetLength(0); iLp++)
                        {  // データ種別数分繰り返す
                            if (m_csGraphLineTimeSeries.GetDataMeaning().Equals(HySDataKindDefine.m_DataKindList[iLp]) == true)
                            {  // データ種別が一致の場合
                                sItemTitleWk = HySDataKindDefine.m_DataKindNameList[iLp].ToString(); // データ種別
                                break;
                            }
                        }
                    }
                    sItemTitle2 = sItemTitleWk; // 系列名設定
                    // 系列名補正
                    int iCnt = 1;
                    for (int iLp1 = 0; iLp1 < m_csColTable.Rows.Count; iLp1++)
                    {
                        if (m_csColTable.Rows[iLp1]["ItemName"].ToString().Contains(sItemTitleWk) == true)
                        {  // フィールド列既存の場合
                            m_csColTable.Rows[iLp1]["ItemName"] = sItemTitleWk + iCnt.ToString();
                            iCnt++;
                            sItemTitle2 = sItemTitleWk + iCnt.ToString();
                        }
                    }
                    if (m_csDataTable.Columns.Count <= 0)
                    {  // 初回設定の場合
                        dXMax = HySReportDefine.DOUBLE_MIN;
                        dXMin = HySReportDefine.DOUBLE_MAX;
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        m_csDataTable.Columns.Add("TimeData", typeof(double));  // 時刻列追加
                        // 列管理情報初期設定
                        DataRow csColRow = m_csColTable.NewRow(); // 先頭基準行生成
                        csColRow["DataKind"] = "ALL";     // データ種別
                        csColRow["Max"] = dXMax;          // データ種別
                        csColRow["Min"] = dXMin;          // データ種別
                        csColRow["ChartName"] = sXScaleName; // Ｘ軸
                        csColRow["ItemName"] = sItemTitle1;  // 列名
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);     // 先頭基準行追加
                        csColRow = m_csColTable.NewRow();    // データ列管理行生成
                        csColRow["DataKind"] = csDataKind.ToString(); // データ種別
                        csColRow["Max"] = dYMax;             // データ種別
                        csColRow["Min"] = dYMin;             // データ種別
                        csColRow["ChartName"] = sYScaleName; // Ｙ軸
                        csColRow["ItemName"] = sItemTitle2;  // 列名
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);     // 行追加
                    }
                    else
                    {  // 継続設定の場合
                        dXMax = (double)m_csColTable.Rows[0]["Max"];
                        dXMin = (double)m_csColTable.Rows[0]["Min"];
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        DataRow csColRow = m_csColTable.NewRow();     // データ列管理行生成
                        csColRow["DataKind"] = csDataKind.ToString(); // データ種別
                        csColRow["Max"] = dYMax;             // データ種別
                        csColRow["Min"] = dYMin;             // データ種別
                        csColRow["ChartName"] = sYScaleName; // Ｙ軸
                        csColRow["ItemName"] = sItemTitle2;  // 列名
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);     // 行追加
                    }
                    int iColumn = m_csDataTable.Columns.Count;        // データ列数取得
                    m_csDataTable.Columns.Add("Data" + iColumn.ToString(), typeof(double)); // データ列追加
                    long lDataCnt = m_csGraphLineTimeSeries.GetCount(); // データ件数取得
                    m_csGraphLineTimeSeries.SetCursorFirst();         // カーソル先頭
                    double dDt = new double();
                    for (int iLp = 0; iLp < lDataCnt; iLp++)
                    {  // データ件数分繰り返す
                        HySTime csTime = m_csGraphLineTimeSeries.GetCursorTime(); // 時刻取得
                        dDt = m_csGraphLineTimeSeries.GetCursorData();            // データ取得
                        String csTimeKey = csTime.GetTime().ToString();           // ハッシュキー生成
                        iRow = 0;
                        if (m_csDataKeys[csTimeKey] is int)
                        {  // 該当ハッシュキーの行が有る場合
                            iRow = (int)m_csDataKeys[csTimeKey]; // 行番号取得
                        }
                        if (iRow > 0)
                        {  // 既存時系行が有る場合
                            m_csDataTable.Rows[iRow - 1]["Data" + iColumn.ToString()] = dDt; // データ追加
                        }
                        else
                        {  // 既存時系列行が無い場合
                            DataRow csRows = m_csDataTable.NewRow();   // 行生成
                            csRows["TimeData"] = csTime.GetTime();     // 時刻設定
                            csRows["Data" + iColumn.ToString()] = dDt; // データ設定
                            m_csDataTable.Rows.Add(csRows);            // 行追加
                            iRow = m_csDataTable.Rows.Count;
                            m_csDataKeys[csTimeKey] = iRow;            // 挿入位置記憶
                        }
                        // データ値の最大／最小を更新
                        if (dXMin > csTime.GetTime())
                        {  // Ｘ軸最小値更新の場合
                            dXMin = csTime.GetTime();
                        }
                        if (dXMax < csTime.GetTime())
                        {  // Ｘ軸最大値更新の場合
                            dXMax = csTime.GetTime();
                        }
                        if (double.IsNaN(dDt) == false && double.IsInfinity(dDt) == false)
                        {  // 実数値として有効な場合
                            if (dYMin > dDt)
                            {  // Ｙ軸最小値更新の場合
                                if (dDt != HySReportDefine.MISSING_VALUE)
                                {  // 欠側値以外の場合
                                    dYMin = dDt;
                                }
                            }
                            if (dYMax < dDt)
                            {  // Ｙ軸最大値更新の場合
                                if (dDt != HySReportDefine.MISSING_VALUE)
                                {  // 欠側値以外の場合
                                    dYMax = dDt;
                                }
                            }
                        }
                        m_csGraphLineTimeSeries.MoveCursorNext(); // 次へ
                    }
                    // データ値の最大／最小を再設定
                    m_csColTable.Rows[0]["Max"] = dXMax;
                    m_csColTable.Rows[0]["Min"] = dXMin;
                    m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Max"] = dYMax;
                    m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Min"] = dYMin;

                }
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
