﻿// <summary>ソースコード：>河道縦断面時系列グラフレポート編集</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>河道縦断面時系列グラフレポート編集</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySReporRiverbedSerialData : HySDataRoot, HySVersionManagement
    {
        /// <summary>河道縦断面時系列データ</summary>
        HySRiverbedSerialData m_csRiverbedSerialData = null;

        /// <summary>河道列データ</summary>
        HySGraphLineLaneKilo m_csGraphLineLaneKilo = null;

        /// <summary>データテーブル</summary>
        DataTable m_csDataTable = null;

        /// <summary>データテーブルキー情報</summary>
        Hashtable m_csDataKeys = null;

        /// <summary>データテーブル列管理情報</summary>
        DataTable m_csColTable = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReporRiverbedSerialData csReportData = new HySReporRiverbedSerialData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySReporRiverbedSerialData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySReporRiverbedSerialData()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySReporRiverbedSerialData csReportData = new HySReporRiverbedSerialData(csDataTable,csDataKeys,csColTable)</para>
        /// </example>
        /// <param name="csDataTable">データテーブルのインスタンス</param>
        /// <param name="csDataKeys">データテーブルキー情報のインスタンス</param>
        /// <param name="csColTable">データテーブル列管理情報のインスタンス</param>
        /// <returns>HySReporRiverbedSerialData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySReporRiverbedSerialData(DataTable csDataTable, Hashtable csDataKeys, DataTable csColTable)
        {
            m_csDataTable = csDataTable;
            m_csDataKeys = csDataKeys;
            m_csColTable = csColTable;

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>登録データ追加展開</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTableAdd(csStockData, ref csBTime, csCustomizInfo)</para>
        /// </example>
        /// <param name="csStockData">登録データ本体</param>
        /// <param name="csBTime">前回検索時刻</param>
        /// <param name="csCustomizInfo">グラフカスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DataTableAdd(HySDataRoot csStockData, ref HySTime csBTime, HySRptCustomizInfo csCustomizInfo)
        {
            int iRow = 0;
            double dXMax = 0;
            double dXMin = 0;
            double dYMax = 0;
            double dYMin = 0;
            double[] dBase = null;
            double[] dData = null;
            long lDataCnt = 0;
            int iColumn = 0;
            int iLp = 0;
            DataRow csColRow = null;
            DataRow csRows = null;
            String csTimeKey = "";
            long lIndex = 0; // フィールド順位（固定）
            string sXScaleName = "";
            string sYScaleName = "";
            string sItemTitle1 = "";
            string sItemTitle2 = "";
            string sItemTitleWk = "";
            double dAllYMax = 0;
            double dAllYMin = 0;

            // 保存データ取得
            m_csRiverbedSerialData = csStockData as HySRiverbedSerialData;
            if (m_csRiverbedSerialData is HySRiverbedSerialData)
            {  // 保存データが河道縦断面時系列データの場合
                //
                // 河口からの距離データから勾配図作成
                lDataCnt = m_csRiverbedSerialData.GetAltitudeDataNum(); // データ件数取得
                if (lDataCnt > 0)
                {  // データが有る場合
                    csCustomizInfo.GetScaleCommonData((int)lIndex, ref sItemTitle1, ref sXScaleName
                                                                 , ref sItemTitle2, ref sYScaleName);
                    if (m_csDataTable.Columns.Count <= 0)
                    {  // 初回設定の場合
                        dXMax = HySReportDefine.DOUBLE_MIN;
                        dXMin = HySReportDefine.DOUBLE_MAX;
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        dAllYMax = HySReportDefine.DOUBLE_MIN;
                        dAllYMin = HySReportDefine.DOUBLE_MAX;
                        m_csDataTable.Columns.Add("TimeData", typeof(double));  // 列追加
                        // 列管理情報初期設定
                        csColRow = m_csColTable.NewRow(); // 先頭基準行生成
                        csColRow["DataKind"] = "ALL";     // データ種別
                        csColRow["Max"] = dXMax;          // データ種別
                        csColRow["Min"] = dXMin;          // データ種別
                        csColRow["ChartName"] = sXScaleName;// Ｘ軸
                        csColRow["ItemName"] = sItemTitle1; // 列名
                        csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                        m_csColTable.Rows.Add(csColRow);  // 先頭基準行追加
                    }
                    else
                    {  // 継続設定の場合
                        dXMax = (double)m_csColTable.Rows[0]["Max"];
                        dXMin = (double)m_csColTable.Rows[0]["Min"];
                        dYMax = HySReportDefine.DOUBLE_MIN;
                        dYMin = HySReportDefine.DOUBLE_MAX;
                        dAllYMax = HySReportDefine.DOUBLE_MIN;
                        dAllYMin = HySReportDefine.DOUBLE_MAX;
                    }
                    dBase = m_csRiverbedSerialData.GetAltKiloDataDim();
                    dData = m_csRiverbedSerialData.GetAltitudeDataDim();
                    for (iLp = 0; iLp < lDataCnt; iLp++)
                    {  // データ件数分繰り返す
                        csTimeKey = dBase[iLp].ToString();            // ハッシュキー生成
                        iRow = 0;
                        if (m_csDataKeys[csTimeKey] is int)
                        {  // 該当ハッシュキーの行が有る場合
                            iRow = (int)m_csDataKeys[csTimeKey]; // 行番号取得
                        }
                        else
                        {  // 既存時系列行が無い場合
                            csRows = m_csDataTable.NewRow(); // 行生成
                            csRows["TimeData"] = dBase[iLp]; // 時刻設定
                            m_csDataTable.Rows.Add(csRows);  // 行追加
                            iRow = m_csDataTable.Rows.Count;
                            m_csDataKeys[csTimeKey] = iRow;  // 挿入位置記憶
                        }
                        // データ値の最大／最小を更新
                        if (dXMin > dBase[iLp])
                        {  // Ｘ軸最小値更新の場合
                            dXMin = dBase[iLp];
                        }
                        if (dXMax < dBase[iLp])
                        {  // Ｘ軸最大値更新の場合
                            dXMax = dBase[iLp];
                        }
                        if (dYMin > dData[iLp])
                        {  // Ｙ軸最小値更新の場合
                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                            {  // 欠側値以外の場合
                                dYMin = dData[iLp];
                            }
                        }
                        if (dYMax < dData[iLp])
                        {  // Ｙ軸最大値更新の場合
                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                            {  // 欠側値以外の場合
                                dYMax = dData[iLp];
                            }
                        }
                    }
                    m_csColTable.Rows[0]["Max"] = dXMax;
                    m_csColTable.Rows[0]["Min"] = (dXMin <= 0) ? 1 : dXMin;
                    //
                    // 河道データ列から時系列の勾配図作成
                    long lNum = 0;
                    //if (csBTime.GetTime() > 0)
                    if (csBTime.GetTime() > HySTime.DEFAULT_TIME.GetTime() )
                    {  // 時刻データが有効な場合
                        lNum = m_csRiverbedSerialData.SetCursorPlus(csBTime);
                        if (lNum <= 0)
                        {  // 登録データが無い場合最新データを取得する
                            if (m_csRiverbedSerialData.GetCount() > 0)
                            {  // 最新時系列データが有る場合
                                m_csRiverbedSerialData.SetCursorLast();
                                lNum = 1;
                            }
                        }
                        else
                        {  // 登録データが有る場合
                            lNum = 1;
                        }
                    }
                    else
                    {  // 時刻データが無効（初回）な場合
                        if (m_csRiverbedSerialData.GetCount() > 0)
                        {  // 最新時系列データが有る場合
                            lNum = m_csRiverbedSerialData.GetCount();
                            if (lNum > 0)
                            {  // 登録データがある場合最新データを取得する
                                for (long lP = 0; lP < lNum; lP++)
                                {  // 登録データ件数分繰り返す
                                    m_csGraphLineLaneKilo = (HySGraphLineLaneKilo)m_csRiverbedSerialData.GetData(lP);
                                    if (m_csGraphLineLaneKilo is HySGraphLineLaneKilo)
                                    {  // 河道縦断面時系列データの取得ができた場合
                                        HySObjectKind csDataKind = m_csGraphLineLaneKilo.GetDataMeaning();
                                        if (csDataKind is HySObjectKind)
                                        {  // データの種別が有る場合
                                            long lKDatcnt = m_csGraphLineLaneKilo.GetDataNum();
                                            dData = m_csGraphLineLaneKilo.GetDataDim();
                                            for (iLp = 0; iLp < lKDatcnt; iLp++)
                                            {  // データ件数分繰り返す
                                                if (double.IsNaN(dData[iLp]) == false && double.IsInfinity(dData[iLp]) == false)
                                                {  // 実数値として有効な場合
                                                    if (dData[iLp] != HySReportDefine.DOUBLE_MIN)
                                                    {  // データが有効な場合
                                                        // データ値の最大／最小を更新
                                                        if (dAllYMin > dData[iLp])
                                                        {  // Ｙ軸最小値更新の場合
                                                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                            {  // 欠側値以外の場合
                                                                dAllYMin = dData[iLp];
                                                            }
                                                        }
                                                        if (dAllYMax < dData[iLp])
                                                        {  // Ｙ軸最大値更新の場合
                                                            if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                            {  // 欠側値以外の場合
                                                                dAllYMax = dData[iLp];
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            m_csRiverbedSerialData.SetCursorLast();
                            lNum = 1;
                        }
                    }
                    if (lNum > 0)
                    {  // 登録データがある場合最新データを取得する
                        for (long lP = 0; lP < lNum; lP++)
                        {  // 登録データ件数分繰り返す
                            m_csGraphLineLaneKilo = (HySGraphLineLaneKilo)m_csRiverbedSerialData.GetCursorData();
                            if (m_csGraphLineLaneKilo is HySGraphLineLaneKilo)
                            {  // 河道縦断面時系列データの取得ができた場合
                                csBTime.SetTime(m_csGraphLineLaneKilo.GetLastTime().GetTime()); // 時刻更新
                                if (sItemTitle2.Length <= 0)
                                {  // 系列名指定が無い場合
                                    //sItemTitleWk = HySCalendar.GetString(csBTime, HySCalendar.FORMAT.lSW_YEAR).ToString();
                                    sItemTitleWk = HySCalendar.GetString(csBTime, HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                                }
                                else
                                {
                                    sItemTitleWk = sItemTitle2;
                                }
                                HySObjectKind csDataKind = m_csGraphLineLaneKilo.GetDataMeaning();
                                if (csDataKind is HySObjectKind)
                                {  // データの種別が有る場合
                                    dYMax = HySReportDefine.DOUBLE_MIN;
                                    dYMin = HySReportDefine.DOUBLE_MAX;
                                    csColRow = m_csColTable.NewRow();     // データ列管理行生成
                                    csColRow["DataKind"] = HySDispDefine.CSKIND_RIVERBEDSERIALE.ToString(); // データ種別
                                    csColRow["Max"] = dYMax; // データ種別
                                    csColRow["Min"] = dYMin; // データ種別
                                    csColRow["ChartName"] = sYScaleName; // Ｙ軸
                                    int iCnt = 0;
                                    for (iLp = 0; iLp < m_csColTable.Rows.Count; iLp++)
                                    {
                                        if (m_csColTable.Rows[iLp]["ItemName"].ToString().Contains(sItemTitleWk) == true)
                                        {  // フィールド列既存の場合
                                            iCnt++;
                                            m_csColTable.Rows[iLp]["ItemName"] = sItemTitleWk + "(" + iCnt.ToString() + ")"; // 列名
                                        }
                                    }
                                    if (iCnt != 0)
                                    {  // 同列グループが有る場合
                                        csColRow["ItemName"] = sItemTitleWk + "(" + ((int)(iCnt + 1)).ToString() + ")"; // 列名
                                    }
                                    else
                                    {  // 同列グループが無い場合
                                        csColRow["ItemName"] = sItemTitleWk; // 列名
                                    }
                                    csColRow["FieldNo"] = lIndex.ToString(); // フィールド順位
                                    m_csColTable.Rows.Add(csColRow); // 行追加
                                    iColumn = m_csDataTable.Columns.Count; // データ列数取得
                                    m_csDataTable.Columns.Add("Data" + iColumn.ToString(), typeof(double)); // データ列追加
                                    long lKDatcnt = m_csGraphLineLaneKilo.GetDataNum();
                                    dData = m_csGraphLineLaneKilo.GetDataDim();
                                    for (iLp = 0; iLp < lKDatcnt; iLp++)
                                    {  // データ件数分繰り返す
                                        if (dData[iLp] != HySReportDefine.DOUBLE_MIN)
                                        {  // データが有効な場合
                                            csTimeKey = dBase[iLp].ToString(); // ハッシュキー生成
                                            iRow = (int)m_csDataKeys[csTimeKey]; // 行番号取得
                                            m_csDataTable.Rows[iRow - 1]["Data" + iColumn.ToString()] = dData[iLp]; // データ追加
                                            // データ値の最大／最小を更新
                                            if (double.IsNaN(dData[iLp]) == false && double.IsInfinity(dData[iLp]) == false)
                                            {  // 実数値として有効な場合
                                                if (dYMin > dData[iLp])
                                                {  // Ｙ軸最小値更新の場合
                                                    if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                    {  // 欠側値以外の場合
                                                        dYMin = dData[iLp];
                                                    }
                                                }
                                                if (dYMax < dData[iLp])
                                                {  // Ｙ軸最大値更新の場合
                                                    if (dData[iLp] != HySReportDefine.MISSING_VALUE)
                                                    {  // 欠側値以外の場合
                                                        dYMax = dData[iLp];
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    // データ値の最大／最小を再設定
                                    if (dAllYMax != HySReportDefine.DOUBLE_MIN)
                                    {  // 全体最大最小値が有る場合
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Max"] = dAllYMax;
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Min"] = dAllYMin;
                                    }
                                    else
                                    {  // 全体最大最小値が無い場合
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Max"] = dYMax;
                                        m_csColTable.Rows[m_csColTable.Rows.Count - 1]["Min"] = dYMin;
                                    }
                                }
                            }
                            m_csRiverbedSerialData.MoveCursorNext(); // 次へ
                        }
                    }
                }
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
