﻿// <summary>ソースコード：ＲｅｐｏｒｔＶｉｅｗ表示フォームベースクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Drawing;
using System.Data;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>検索・検索結果選択表示フォームベースクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySReportSearchFormBase : Form, HySViewFormBaseIF
    {
        /// <summary>スクリーン</summary>
        protected HySScreen m_csScreen = null;

        //配置情報
        /// <summary>画面幅規定値</summary>
        protected int iWidth_Default = 0;
        /// <summary>画面高さ規定値</summary>
        protected int iHeight_Default = 0;
        /// <summary>画面高さ調整値</summary>
        protected int iHeight_Adjusted = 0;
        /// <summary>画面幅調整値</summary>
        protected int iWidth_Adjusted = 0;
        /// <summary>画面配置デスクトップ座標X</summary>
        protected int iLocattion_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        protected int iLocattion_Y = 0;

        /// <summary>データコンテナ</summary>
        protected HySContainer m_csContainer = null;

        /// <summary>データ保存クラスリスト</summary>
        protected HySStockDataList m_csStockDataList = null;

        /// <summary>データ保存クラス</summary>
        protected HySStockData m_csStockData = null;

        /// <summary>表示業務管理データ</summary>
        protected HySDispBusiProcedureCtlInfo m_csDBPCtlInfo = null;

        /// <summary>選択データ識別キー管理リスト</summary>
        protected ArrayList m_csIDList = null;

        /// <summary>選択データ識別キー管理リスト</summary>
        protected Form m_csMsgForm = null;

        /// <summary>フォント定義</summary>
        static public readonly string FONTTYPE = "ＭＳ ゴシック";

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>対となるスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetScreen(HySScreen csScreen)
        {
            m_csScreen = csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 画面種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetViewKind()
        {
            return ((HySScreenBase)m_csScreen).GetViewKind();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">画面種別</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean EqualViewKind(HySKind csViewKindID)
        {
            return ((HySScreenBase)m_csScreen).EqualViewKind(csViewKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Show( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new void Show()
        {
            base.Show();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Renew()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Close( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new void Close()
        {
            // 表示ビューアへの画面終了報告
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_CLOSE_SCREEN);
            csEventObj.SetToSimKind(m_csScreen.GetSimKind());
            csEventObj.SetSuppID((HySID)m_csScreen.GetID());
            csEventObj.SetData(this.GetViewKind());
            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
            m_csScreen.PutEvent(csEventObj);
            // 画面を閉じる
            base.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Initialize()
        {
            // ビュー取得
            HySViewer csViewer = ((HySScreenBase)m_csScreen).GetViewer();
            if (csViewer != null)
            {  // ビュー有効な場合
                this.MdiParent = ((HySDotNetViewer)csViewer).GetMainForm(); // 画面MDI設定
                this.Arrangement(); // 画面サイズにあわせて表示サイズ決定
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Terminate()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void InitiateScreen()
        {
            this.Arrangement(); // 画面サイズにあわせて表示サイズ決定
            this.PutEvent(HySEventObject.CMND_DISPLY_COMMON,HySDispDefine.NOTICE_SCREEN_NORMAL);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( lEventNo, lSubEventNo ) </para>
        /// </example>
        /// <param name="lEventNo">送るイベント番号</param>
        /// <param name="lSubEventNo">送るサブイベント番号</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public Boolean PutEvent(long lEventNo, long lSubEventNo)
        {
            bool bRtn = false;
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, lEventNo);
            csEventObj.SetToSimKind(m_csScreen.GetSimKind());
            csEventObj.SetSuppID((HySID)m_csScreen.GetID());
            csEventObj.SetData(this.GetViewKind());
            csEventObj.SetSubEventNo(lSubEventNo);
            m_csScreen.PutEvent(csEventObj);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csHySEvent.GetToSimKind();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示（表示更新、検索）の場合
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 再表示要求の場合
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                {  // 画面終了指示の場合
                    m_csScreen.CloseScreen();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_HIDE)
                {  // 隠す指示の場合
                    this.Hide();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_ACTIVE)
                {  //アクティブ指示の場合
                    this.Focus();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_MINIMIZED)
                {  // 最小化指示の場合
                    this.WindowState = FormWindowState.Minimized;
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_NORMAL)
                {  // ノーマライズ指示の場合
                    this.WindowState = FormWindowState.Normal;
                    this.Show();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_ACTIVE_EVENT)
                {  // アクティブイベントの場合
                    if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        HySID csFugID = m_csDBPCtlInfo.GetPeculiarDataList(m_csDBPCtlInfo.GetParentsScreenKind()) as HySID;
                        if (csFugID is HySID)
                        {  // 演算シミュレータ識別子が有る場合
                            if (csFugID.Equals(csID) == true)
                            {  // フォームの可視化
                                base.Show();
                            }
                            else
                            {  // フォームの不可視化
                                base.Hide();
                            }
                        }
                    }
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_MODEL_CLOSE)
                {  // モデル画面クローズイベントの場合
                    if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        HySID csFugID = m_csDBPCtlInfo.GetPeculiarDataList(m_csDBPCtlInfo.GetParentsScreenKind()) as HySID;
                        if (csFugID is HySID)
                        {  // 演算シミュレータ識別子が有る場合
                            if (csFugID.Equals(csID) == true)
                            {  // フォームの可視化
                                m_csScreen.CloseScreen(); // フォームのクローズ
                            }
                        }
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK)
            {  // 画面表示指示正常完了報告の場合
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
            {  // 画面表示指示異常完了報告の場合
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Arrangement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Arrangement()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置補正</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ArrangementCorrection(csContainer,csForm) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csForm">描画フォーム</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ArrangementCorrection(HySContainer csContainer, Form csForm)
        {
            int iLp;

            // 表示座標設定
            HySString csSeqNo = m_csContainer.GetData(HySDispDefine.CONTAINER_NUMBER_KEYS) as HySString;
            long lSeqNo = long.Parse(csSeqNo.ToString());
            if (lSeqNo > 0)
            {  // 座標補正が必要な場合
                iLocattion_X += (int)((lSeqNo - 1) * 5);
                iLocattion_Y += (int)((lSeqNo - 1) * 5);
                csForm.SetDesktopLocation(iLocattion_X, iLocattion_Y);
            }
            // 画面名称設定
            for (iLp = 0; iLp < HySDispDefine.PARENTS_SCREEN_NAME.GetLength(0); iLp++)
            {  // 行数分繰り返す
                if (this.EqualViewKind(HySDispDefine.PARENTS_SCREEN_NAME[iLp, 0]) == true)
                {  // 親画面種別が一致した場合
                    csForm.Text = HySDispDefine.PARENTS_SCREEN_NAME[iLp, 1].ToString();
                    break;
                }
            }
            // 画面グループ名設定
            HySDispBusiProcedureCtlInfo csDBPCtlInfo = csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
            if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示業務管理データが有る場合
                for (iLp = 0; iLp < HySDispDefine.PARENTS_SCREEN_NAME.GetLength(0); iLp++)
                {  // 行数分繰り返す
                    if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDispDefine.PARENTS_SCREEN_NAME[iLp, 0]) == true)
                    {  // 親画面種別が一致した場合
                        csForm.Text = csForm.Text + "-" + HySDispDefine.PARENTS_SCREEN_NAME[iLp, 1].ToString() + "-Group" + lSeqNo.ToString("00");
                        break;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>処理中メッセージ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateBeingProcessingMesseage(sTitle,sMsg) </para>
        /// </example>
        /// <param name="sTitle">画面タイトル</param>
        /// <param name="sMsg">表示メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateBeingProcessingMesseage(string sTitle, string sMsg)
        {
            // ガイダンス用フォーム生成
            m_csMsgForm = new Form();
            m_csMsgForm.FormBorderStyle = FormBorderStyle.FixedSingle;
            m_csMsgForm.ControlBox = !m_csMsgForm.ControlBox;
            m_csMsgForm.Size = new Size(300, 100);
            m_csMsgForm.Font = new Font(FONTTYPE, 9);
            m_csMsgForm.Text = sTitle;
            Label csLabel = new Label();
            csLabel.Size = new Size(150, 50);
            csLabel.Location = new Point(30, 20);
            csLabel.Font = new Font(FONTTYPE, 9);
            csLabel.Text = sMsg;
            m_csMsgForm.Controls.Add(csLabel);
            // 待ちの強制解除用サブメニュー追加
            ContextMenuStrip csCntmenu = new ContextMenuStrip();
            ToolStripMenuItem csNewcontitem = new ToolStripMenuItem();
            csNewcontitem.Text = "&Cancel";
            csNewcontitem.Click += delegate
            {
                if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                {  // 表示業務管理データが有る場合
                    HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                    csEventObj.SetSuppID((HySID)m_csScreen.GetID());
                    csEventObj.SetData(m_csDBPCtlInfo.GetParentsScreenKind());
                    csEventObj.SetSubEventNo(HySDispDefine.NOTICE_DB_REQUEST_COMPLET);
                    m_csScreen.PutEvent(csEventObj);                   
                    
                    // 子画面に通知する
                    long lCnt = m_csDBPCtlInfo.GetChildCount();
                    for (int iLp = 1; iLp <= (int)lCnt; iLp++)
                    {  // 登録済みの子画面数分繰り返す
                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                        csEventObj.SetSuppID((HySID)m_csScreen.GetID());
                        csEventObj.SetData(m_csDBPCtlInfo.GetChildScreenKind(iLp));
                        csEventObj.SetSubEventNo(HySDispDefine.NOTICE_DB_REQUEST_COMPLET);
                        m_csScreen.PutEvent(csEventObj);
                    }
                }
            };
            csCntmenu.Items.Add(csNewcontitem);
            m_csMsgForm.ContextMenuStrip = csCntmenu;
            // タスクバー表示抑止設定
            m_csMsgForm.ShowInTaskbar = false;
            m_csMsgForm.ShowDialog();
        }
        /// <summary><para>method outline:</para>
        /// <para>処理中メッセージ破棄</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteBeingProcessingMesseage() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DeleteBeingProcessingMesseage()
        {
            if (m_csMsgForm != null)
            {  // 画面表示中の場合
                m_csMsgForm.Close();
                m_csMsgForm.Dispose();
                m_csMsgForm = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent()
        {

        }



        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySReportSearchFormBase_Activated( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void HySReportSearchFormBase_Activated(object sender, EventArgs e)
        {
            ((HySScreenBase)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySReportSearchFormBase_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void HySReportSearchFormBase_Deactivate(object sender, EventArgs e)
        {
            ((HySScreenBase)m_csScreen).NoticeDeActive();
        }

    }
}
