﻿// <summary>ソースコード：>ＨＹＳＳＯＰレポート表示カスタマイズデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Xml;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>レポート表示カスタマイズデータクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySRptCustomizInfo : HySDataRoot, HySVersionManagement
    {
        // 基本設定項目
        /// <summary>グラフ背景色</summary>
        public string m_sGraphBackGroundColor = "";
        /// <summary>凡例表示指定</summary>
        public bool m_bGraphLegendChkFlg = false;
        /// <summary>凡例表示位置</summary>
        public string m_sGraphLegendPosition = "";
        /// <summary>軸管理情報</summary>
        protected Hashtable m_csRptAxisInfo = null;
        /// <summary>フィールド管理情報</summary>
        protected Hashtable m_csRptFieldInfo = null;

        // ＴＡＧ関連
        /// <summary>ルートタグ</summary>
        static readonly string TAG_CUSTOMITEM = "CustomItem";
        /// <summary>共通設定タグ</summary>
        static readonly string TAG_COMMON = "Common";
        /// <summary>項目タグ</summary>
        static readonly string TAG_ITEM = "Item";
        /// <summary>背景色タグ</summary>
        static readonly string TAG_BACKGROUNDCOLOR = "BackgroundColor";
        /// <summary>凡例タグ</summary>
        static readonly string TAG_LEGEND = "Legend";
        /// <summary>位置タグ</summary>
        static readonly string TAG_POSITION = "Position";
        /// <summary>軸タグ</summary>
        static readonly string TAG_AXIS = "Axis";
        /// <summary>名称タグ</summary>
        static readonly string TAG_NAME = "Name";
        /// <summary>可視タグ</summary>
        static readonly string TAG_VISIBLE = "Visible";
        /// <summary>コメントタグ</summary>
        static readonly string TAG_CAPTION = "Caption";
        /// <summary>種別タグ</summary>
        static readonly string TAG_KIND = "Kind";
        /// <summary>最小値タグ</summary>
        static readonly string TAG_MIN = "Min";
        /// <summary>最大値タグ</summary>
        static readonly string TAG_MAX = "Max";
        /// <summary>間隔タグ</summary>
        static readonly string TAG_MAJORINTERVAL = "MajorInterval";
        /// <summary>反転タグ</summary>
        static readonly string TAG_REVERSE = "Reverse";
        /// <summary>フィールドタグ</summary>
        static readonly string TAG_FIELD = "Field";
        /// <summary>基準軸（Ｘ）タグ</summary>
        static readonly string TAG_XAXIS = "XAxis";
        /// <summary>基準軸（Ｙ）タグ</summary>
        static readonly string TAG_YAXIS = "YAxis";
        /// <summary>線種タグ</summary>
        static readonly string TAG_TYPE = "Type";

        /// <summary>検索条件（軸識別子）</summary>
        static readonly string[] m_sKeys = { HySReportDefine.TAG_UNDERLABEL
                                           , HySReportDefine.TAG_TOPLABEL
                                           , HySReportDefine.TAG_LEFTLABEL
                                           , HySReportDefine.TAG_RIGHTLABEL
                                           };

        // カスタマイズ保存ファイル関連
        /// <summary>評価画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_GRAPH_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispFormLineGraphCustomizing.xml";
        /// <summary>基本画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_LINE_GRAPH_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispFormLineGraphCustomizing.xml";
        /// <summary>ハイエト・ハイドログラフ表示画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_HYDRO_HYETO_GRAPH_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispFormHydroHyetoGraphCustomizing.xml";
        /// <summary>ＨＱグラフ表示画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_HQ_GRAPH_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispFormHQGraphCustomizing.xml";
        /// <summary>1次元縦断データグラフ画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_RIVERBED_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispFormRiverbedGraphCustomizing.xml";
        /// <summary>1次元縦断データグラフ（アニメーション用）画面カスタマイズ保存ＸＭＬパス</summary>
        static readonly string DISP_FORM_RIVERBED_ANIMATION_CUSTOMIZ_PASS = "\\SystemData\\format\\" + HySEnvInf.GetCultureDirectory().ToString() + "DispRiverbedGraphAnimationCustomizing.xml";

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySRptCustomizInfo csData = new HySRptCustomizInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySRptCustomizInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySRptCustomizInfo()
        {
            m_csRptAxisInfo = new Hashtable();
            m_csRptFieldInfo = new Hashtable();
            m_sGraphBackGroundColor = HySReportDefine.TAG_AUTO;
            m_sGraphLegendPosition = HySReportDefine.TAG_LEGEND_RIGHTTOP;

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>軸カスタマイズ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetAxisCustomiz(csKey,csRptAxisInfo)</para>
        /// </example>
        /// <param name="csKey">軸識別子</param>
        /// <param name="csRptAxisInfo">軸カスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetAxisCustomiz(HySString csKey, HySRptAxisInfo csRptAxisInfo)
        {
            m_csRptAxisInfo[csKey.ToString()] = csRptAxisInfo;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>軸カスタマイズ情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySRptAxisInfo csRptAxisInfo = GetAxisCustomiz(csKey)</para>
        /// </example>
        /// <param name="csKey">軸識別子</param>
        /// <returns>HySRptAxisInfo 軸カスタマイズ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySRptAxisInfo GetAxisCustomiz(HySString csKey)
        {
            return (HySRptAxisInfo)m_csRptAxisInfo[csKey.ToString()];
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フィールドカスタマイズ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetFieldCustomiz(csKey,csRptFieldInfo)</para>
        /// </example>
        /// <param name="csKey">フィールド識別子</param>
        /// <param name="csRptFieldInfo">フィールドカスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFieldCustomiz(HySString csKey, HySRptFieldInfo csRptFieldInfo)
        {
            m_csRptFieldInfo[csKey.ToString()] = csRptFieldInfo;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>フィールドカスタマイズ情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySRptFieldInfo csRptFieldInfo = GetFieldCustomiz(csKey)</para>
        /// </example>
        /// <param name="csKey">フィールド識別子</param>
        /// <returns>HySRptFieldInfo フィールドカスタマイズ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySRptFieldInfo GetFieldCustomiz(HySString csKey)
        {
            return (HySRptFieldInfo)m_csRptFieldInfo[csKey.ToString()];
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>フィールドカスタマイズ情報キーリスト取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetFieldCustomizList(ref csList)</para>
        /// </example>
        /// <param name="csList">フィールドカスタマイズ情報キーリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetFieldCustomizList(ref ArrayList csList )
        {
            foreach (string sName in m_csRptFieldInfo.Keys)
            {  // ハッシュテーブル件数繰り返す
                csList.Add(sName);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>フィールドカスタマイズ情報初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearFieldCustomiz()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ClearFieldCustomiz()
        {
            m_csRptFieldInfo.Clear();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＸＭＬファイルフルパス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>string sFilePass = GetCustomizFilePass(csKey)</para>
        /// </example>
        /// <param name="csKey">画面識別子</param>
        /// <returns>string ＸＭＬファイルフルパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string GetCustomizFilePass(HySKind csKey)
        {
            if (HySDefine.DISP_FORM_LINE_GRAPH.Equals(csKey) == true)
            {  // 基本画面の場合
                return DISP_FORM_LINE_GRAPH_CUSTOMIZ_PASS;
            }
            else if(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.Equals(csKey) == true)
            {  // ハイドロ・ハイエトグラフの場合
                return DISP_FORM_HYDRO_HYETO_GRAPH_CUSTOMIZ_PASS;
            }
            else if(HySDefine.DISP_FORM_RIVERBED_SHAPE.Equals(csKey) == true)
            {  // １次元縦断データグラフの場合
                return DISP_FORM_RIVERBED_CUSTOMIZ_PASS;
            }
            else if (HySReportDefine.DISP_ANIMATION_FORM_RIVERBED_SHAPE.Equals(csKey) == true)
            {  // １次元縦断データグラフ（アニメーション）の場合
                return DISP_FORM_RIVERBED_ANIMATION_CUSTOMIZ_PASS;
            }
            else if (HySDefine.DISP_FORM_HQ_GRAPH.Equals(csKey) == true)
            {  // ＨＱグラフの場合
                return DISP_FORM_HQ_GRAPH_CUSTOMIZ_PASS;
            }
            return DISP_FORM_GRAPH_CUSTOMIZ_PASS; // Default
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフカスタマイズ設定ファイル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetReportCustomiz(csKey)</para>
        /// </example>
        /// <param name="csKey">画面識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetReportCustomiz(HySKind csKey)
        {
            int iLp = 0;

            // XMLファイル作成
            HySString csFilePass = new HySString(HySEnvInf.GetHomeDirectory().ToString() + this.GetCustomizFilePass(csKey));
            HySXmlWriter csXmlWriter = new HySXmlWriter(csFilePass);
            HySXmlNode csRootNode = csXmlWriter.CreateRoot(TAG_CUSTOMITEM);

            // 基本カスタマイズ情報設定
            HySXmlNode csParentNode = HySXmlNode.CreateElement(TAG_COMMON, csXmlWriter);
            csRootNode.AppendChild(csParentNode);
            HySXmlNode csNode = HySXmlNode.CreateElement(TAG_ITEM, csXmlWriter);
            csNode.SetAttribute(TAG_BACKGROUNDCOLOR, m_sGraphBackGroundColor);
            if (m_bGraphLegendChkFlg == true)
            {  // 凡例表示有りの場合
                csNode.SetAttribute(TAG_LEGEND, HySReportDefine.TAG_TRUE);
                csNode.SetAttribute(TAG_POSITION, m_sGraphLegendPosition);
            }
            else
            {  // 凡例表示無しの場合
                csNode.SetAttribute(TAG_LEGEND, HySReportDefine.TAG_FALSE);
                csNode.SetAttribute(TAG_POSITION, "");
            }
            csParentNode.AppendChild(csNode);

            // 軸カスタマイズ情報設定
            csParentNode = HySXmlNode.CreateElement(TAG_AXIS, csXmlWriter);
            csRootNode.AppendChild(csParentNode);
            for (iLp = 0; iLp < m_sKeys.Length; iLp++)
            {  // 軸数分繰り返す
                HySRptAxisInfo csRptAxisInfo = this.GetAxisCustomiz(new HySString(m_sKeys[iLp]));
                if (csRptAxisInfo is HySRptAxisInfo)
                {  // 軸情報が有る場合
                    csNode = HySXmlNode.CreateElement(TAG_ITEM, csXmlWriter);
                    csNode.SetAttribute(TAG_NAME, m_sKeys[iLp]);
                    if (csRptAxisInfo.m_bAxisChkFlg == true)
                    {  // 軸が有効な場合
                        csNode.SetAttribute(TAG_VISIBLE, HySReportDefine.TAG_TRUE);
                        if (csRptAxisInfo.m_csAxisMode == HySReportDefine.XSCALE_KIND.TIME_SERIES_DATA)
                        {  // 時系列の場合
                            csNode.SetAttribute(TAG_KIND, HySReportDefine.TAG_KIND_TIMESERIES);
                        }
                        else
                        {  // 値の場合
                            csNode.SetAttribute(TAG_KIND, HySReportDefine.TAG_KIND_VALUE);
                        }
                        if (csRptAxisInfo.m_bAxisRenge == true)
                        {  // 表示範囲が有効な場合
                            csNode.SetAttribute(TAG_MIN, csRptAxisInfo.m_csAxisRenge_Start);
                            csNode.SetAttribute(TAG_MAX, csRptAxisInfo.m_csAxisRenge_End);
                        }
                        else
                        {  // 表示範囲が無効な場合
                            csNode.SetAttribute(TAG_MIN, "");
                            csNode.SetAttribute(TAG_MAX, "");
                        }
                        if (csRptAxisInfo.m_bReverse == true)
                        {  // 反転が有効な場合
                            csNode.SetAttribute(TAG_REVERSE, HySReportDefine.TAG_TRUE);
                        }
                        else
                        {  // 反転が無効な場合
                            csNode.SetAttribute(TAG_REVERSE, HySReportDefine.TAG_FALSE);
                        }
                        if (csRptAxisInfo.m_csAxisMode == HySReportDefine.XSCALE_KIND.TIME_SERIES_DATA)
                        {  // 時系列の場合は間隔は初期値とする
                            csNode.SetAttribute(TAG_MAJORINTERVAL, "");
                        }
                        else
                        {  // 値の場合は間隔を設定する
                            csNode.SetAttribute(TAG_MAJORINTERVAL, csRptAxisInfo.m_dInterval.ToString());
                        }
                        csNode.SetAttribute(TAG_CAPTION, csRptAxisInfo.m_sCaption);
                    }
                    else
                    {  // 軸が無効な場合
                        csNode.SetAttribute(TAG_VISIBLE, HySReportDefine.TAG_FALSE);
                        csNode.SetAttribute(TAG_KIND, "");
                        csNode.SetAttribute(TAG_MIN, "");
                        csNode.SetAttribute(TAG_MAX, "");
                        csNode.SetAttribute(TAG_REVERSE, HySReportDefine.TAG_FALSE);
                        csNode.SetAttribute(TAG_MAJORINTERVAL, "");
                        csNode.SetAttribute(TAG_CAPTION, "");
                    }
                    csParentNode.AppendChild(csNode);
                }
            }

            // フィールドカスタマイズ情報設定
            csParentNode = HySXmlNode.CreateElement(TAG_FIELD, csXmlWriter);
            csRootNode.AppendChild(csParentNode);
            for (iLp = 0; iLp < m_csRptFieldInfo.Count; iLp++)
            {  // フィールド件数分繰り返す
                HySRptFieldInfo csRptFieldInfo = this.GetFieldCustomiz(new HySString(iLp.ToString()));
                if (csRptFieldInfo is HySRptFieldInfo)
                {  // フィールドデータが有効な場合
                    csNode = HySXmlNode.CreateElement(TAG_ITEM, csXmlWriter);
                    csNode.SetAttribute(TAG_NAME, csRptFieldInfo.m_csFieldName);
                    csNode.SetAttribute(TAG_XAXIS, csRptFieldInfo.m_sXAxis);
                    csNode.SetAttribute(TAG_YAXIS, csRptFieldInfo.m_sYAxis);
                    csNode.SetAttribute(TAG_TYPE, csRptFieldInfo.m_sType);
                    csNode.SetAttribute(TAG_BACKGROUNDCOLOR, csRptFieldInfo.m_sBackgroundColor);
                    csNode.SetAttribute(TAG_CAPTION, csRptFieldInfo.m_sLegendName);
                    csParentNode.AppendChild(csNode);
                }
            }

            // ＸＭＬ格納
            csXmlWriter.Save();
            csXmlWriter = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフカスタマイズ設定ファイル取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetReportCustomiz(csKey)</para>
        /// </example>
        /// <param name="csKey">画面識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetReportCustomiz(HySKind csKey)
        {
            HySRptAxisInfo csRptAxisInfo = null;
            HySRptFieldInfo csRptFieldInfo = null;

            // 初期化
            m_sGraphBackGroundColor = "";
            m_bGraphLegendChkFlg = false;
            m_sGraphLegendPosition = "";
            m_csRptAxisInfo.Clear();
            for (int iLp = 0; iLp < m_sKeys.Length; iLp++)
            {  // 軸数分繰り返す
                csRptAxisInfo = new HySRptAxisInfo();
                this.SetAxisCustomiz(new HySString(m_sKeys[iLp]), csRptAxisInfo);
            }
            m_csRptFieldInfo.Clear();

            // ＸＭＬ定義取得
            HySString csFilePass = new HySString(HySEnvInf.GetHomeDirectory().ToString() + this.GetCustomizFilePass(csKey));
            HySXmlReader csXmlReader = new HySXmlReader(csFilePass);
            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
            if (csXmlRootNode is HySXmlNode)
            {  // XMLファイルが有る場合
                int iLp1, iLp2;
                HySXmlNode csXmlChildNode;
                HySXmlNode csXmlGrandChildNode;
                HySXmlNodeList csXmlChildNodeList = csXmlRootNode.GetChildNodeList();
                HySXmlNodeList csXmlGrandChildNodeList;
                string csKeyData = null;
                string csData = null;
                for (iLp1 = 0; iLp1 < csXmlChildNodeList.GetCount(); iLp1++)
                {  // 子ノード分繰り返す
                    csXmlChildNode = csXmlChildNodeList.GetNode(iLp1); // 子ノード取得
                    if (csXmlChildNode is HySXmlNode)
                    {  // 子ノードが有効の場合
                        if (csXmlChildNode.GetName().Equals(TAG_COMMON))
                        {  // ノードが基本設定の場合
                            csXmlGrandChildNodeList = csXmlChildNode.GetChildNodeList();
                            for (iLp2 = 0; iLp2 < csXmlGrandChildNodeList.GetCount(); iLp2++)
                            {  // 基本設定ノード分繰り返す
                                csXmlGrandChildNode = csXmlGrandChildNodeList.GetNode(iLp2);
                                // 基本設定子ノード取得
                                if (csXmlGrandChildNode.GetName().Equals(TAG_ITEM))
                                {  // 項目タグの場合
                                    // 背景色を取得
                                    m_sGraphBackGroundColor = csXmlGrandChildNode.GetAttribute(TAG_BACKGROUNDCOLOR);
                                    // 凡例表示有無を取得
                                    csKeyData = csXmlGrandChildNode.GetAttribute(TAG_LEGEND);
                                    if (csKeyData.Equals(HySReportDefine.TAG_TRUE) == true)
                                    {  // 凡例表示有りの場合
                                        m_bGraphLegendChkFlg = true;
                                        m_sGraphLegendPosition = csXmlGrandChildNode.GetAttribute(TAG_POSITION);
                                    }
                                    else
                                    {  // 凡例表示無しの場合
                                        m_bGraphLegendChkFlg = false;
                                        m_sGraphLegendPosition = "";
                                    }
                                }
                            }
                        }
                        if (csXmlChildNode.GetName().Equals(TAG_AXIS))
                        {  // ノードがスケール設定の場合
                            csXmlGrandChildNodeList = csXmlChildNode.GetChildNodeList();
                            for (iLp2 = 0; iLp2 < csXmlGrandChildNodeList.GetCount(); iLp2++)
                            {  // スケール設定ノード分繰り返す
                                csXmlGrandChildNode = csXmlGrandChildNodeList.GetNode(iLp2);
                                // スケール設定子ノード取得
                                if (csXmlGrandChildNode.GetName().Equals(TAG_ITEM))
                                {  // 項目タグの場合
                                    csKeyData = csXmlGrandChildNode.GetAttribute(TAG_NAME); // 軸名称取得
                                    if (csKeyData.Equals(HySReportDefine.TAG_UNDERLABEL) == true ||
                                        csKeyData.Equals(HySReportDefine.TAG_TOPLABEL)   == true ||
                                        csKeyData.Equals(HySReportDefine.TAG_LEFTLABEL)  == true ||
                                        csKeyData.Equals(HySReportDefine.TAG_RIGHTLABEL) == true)
                                    {  // 軸名称が有効な場合
                                        csRptAxisInfo = this.GetAxisCustomiz(new HySString(csKeyData));
                                        csData = csXmlGrandChildNode.GetAttribute(TAG_VISIBLE); // 軸有効フラグ取得
                                        if (csData.Equals(HySReportDefine.TAG_TRUE) == true)
                                        {  // 軸設定が有効な場合
                                            csRptAxisInfo.m_bAxisChkFlg = true; // 軸有効設定
                                            csData = csXmlGrandChildNode.GetAttribute(TAG_KIND);
                                            if (csData.Equals(HySReportDefine.TAG_KIND_TIMESERIES) == true)
                                            {  // 時系列の場合
                                                csRptAxisInfo.m_csAxisMode = HySReportDefine.XSCALE_KIND.TIME_SERIES_DATA;
                                            }
                                            else
                                            {  // 値の場合
                                                csRptAxisInfo.m_csAxisMode = HySReportDefine.XSCALE_KIND.COMMON_LINE_DATA;
                                            }
                                            csRptAxisInfo.m_csAxisRenge_Start = csXmlGrandChildNode.GetAttribute(TAG_MIN); // 表示範囲設定
                                            csRptAxisInfo.m_csAxisRenge_End = csXmlGrandChildNode.GetAttribute(TAG_MAX);   // 表示範囲設定
                                            if (csRptAxisInfo.m_csAxisRenge_Start.Length > 0)
                                            {  // 表示範囲が有効な場合
                                                csRptAxisInfo.m_bAxisRenge = true; // 表示範囲設定
                                            }
                                            else
                                            {  // 表示範囲が無効な場合
                                                csRptAxisInfo.m_bAxisRenge = false;     // 表示範囲設定
                                                csRptAxisInfo.m_csAxisRenge_Start = ""; // 表示範囲設定
                                                csRptAxisInfo.m_csAxisRenge_End = "";   // 表示範囲設定
                                            }
                                            csData = csXmlGrandChildNode.GetAttribute(TAG_REVERSE);
                                            if (csData.Equals(HySReportDefine.TAG_TRUE) == true)
                                            {  // 表示方向反転有りの場合
                                                csRptAxisInfo.m_bReverse = true;
                                            }
                                            else
                                            {  // 表示方向反転無しの場合
                                                csRptAxisInfo.m_bReverse = false;
                                            }
                                            csData = csXmlGrandChildNode.GetAttribute(TAG_MAJORINTERVAL);
                                            try
                                            {
                                                if (csData.Length > 0)
                                                {  // 間隔設定有りの場合
                                                    csRptAxisInfo.m_dInterval = double.Parse(csData);
                                                }
                                            }
                                            catch
                                            {  // 変換異常の場合
                                                csRptAxisInfo.m_dInterval = 0.0;
                                            }
                                            csRptAxisInfo.m_sCaption = csXmlGrandChildNode.GetAttribute(TAG_CAPTION); // 軸ラベル設定
                                        }
                                        else
                                        {  // 軸設定が無効な場合
                                            csRptAxisInfo.m_bAxisChkFlg = false;    // 軸有効設定
                                            csRptAxisInfo.m_csAxisMode = HySReportDefine.XSCALE_KIND.COMMON_LINE_DATA; // データ種別設定
                                            csRptAxisInfo.m_csAxisRenge_Start = ""; // 表示範囲設定
                                            csRptAxisInfo.m_csAxisRenge_End = "";   // 表示範囲設定
                                            csRptAxisInfo.m_bAxisRenge = false;     // 表示範囲設定
                                            csRptAxisInfo.m_bReverse = false;       // 表示方向設定
                                            csRptAxisInfo.m_dInterval = 0.0;        // 間隔設定
                                            csRptAxisInfo.m_sCaption = "";          // 軸ラベル設定
                                        }
                                    }
                                }
                            }
                        }
                        if (csXmlChildNode.GetName().Equals(TAG_FIELD))
                        {  // ノードがフィールド設定の場合
                            csXmlGrandChildNodeList = csXmlChildNode.GetChildNodeList();
                            for (iLp2 = 0; iLp2 < csXmlGrandChildNodeList.GetCount(); iLp2++)
                            {  // フィールド設定ノード分繰り返す
                                csXmlGrandChildNode = csXmlGrandChildNodeList.GetNode(iLp2);
                                // フィールド設定子ノード取得
                                if (csXmlGrandChildNode.GetName().Equals(TAG_ITEM))
                                {  // 項目タグの場合
                                    csRptFieldInfo = new HySRptFieldInfo();
                                    csRptFieldInfo.m_csFieldName = csXmlGrandChildNode.GetAttribute(TAG_NAME); // フィールド名称取得
                                    if (csRptFieldInfo.m_csFieldName.Length > 0)
                                    {  // フィールド名が有効な場合
                                        csRptFieldInfo.m_sXAxis = csXmlGrandChildNode.GetAttribute(TAG_XAXIS);
                                        csRptFieldInfo.m_sYAxis = csXmlGrandChildNode.GetAttribute(TAG_YAXIS);
                                        csRptFieldInfo.m_sType = csXmlGrandChildNode.GetAttribute(TAG_TYPE);
                                        csRptFieldInfo.m_sBackgroundColor = csXmlGrandChildNode.GetAttribute(TAG_BACKGROUNDCOLOR);
                                        csRptFieldInfo.m_sLegendName = csXmlGrandChildNode.GetAttribute(TAG_CAPTION);
                                        this.SetFieldCustomiz(new HySString((iLp2).ToString()), csRptFieldInfo); // フィールド登録
                                    }
                                }
                            }
                        }
                    }
                }
            }
            csXmlReader = null;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>軸基本情報取得処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetScaleCommonData(iFieldno,ref sXItemTitle,ref sXScaleName, ref sYItemTitle, ref sYScaleName)</para>
        /// </example>
        /// <param name="iFieldNo">フィールド順位</param>
        /// <param name="sXItemTitle">Ｘ軸タイトル</param>
        /// <param name="sXScaleName">Ｘ軸種別</param>
        /// <param name="sYItemTitle">系列名</param>
        /// <param name="sYScaleName">Ｙ軸種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetScaleCommonData(int iFieldNo, ref string sXItemTitle, ref string sXScaleName,
                                                     ref string sYItemTitle, ref string sYScaleName)
        {
            // データ別軸設定編集
            HySRptFieldInfo csRptFieldInfo = this.GetFieldCustomiz(new HySString(iFieldNo.ToString()));
            if (csRptFieldInfo is HySRptFieldInfo)
            {  // データフィールド有効の場合
                HySRptAxisInfo csRptAxisInfo = this.GetAxisCustomiz(new HySString(csRptFieldInfo.m_sXAxis));
                if (csRptAxisInfo is HySRptAxisInfo)
                {  // Ｘ軸情報が有効な場合
                    sXItemTitle = (csRptAxisInfo.m_sCaption.Length > 0) ? csRptAxisInfo.m_sCaption : HySReportDefine.GRAPH_TIME;
                    if (csRptAxisInfo.m_bAxisChkFlg == true)
                    {  // 軸使用の場合
                        if (csRptAxisInfo.m_csAxisMode == HySReportDefine.XSCALE_KIND.TIME_SERIES_DATA)
                        {  // 時系列の場合
                            if (csRptFieldInfo.m_sXAxis.Equals(HySReportDefine.TAG_TOPLABEL) == true)
                            {  // Ｘ軸（下）の場合
                                sXScaleName = HySReportDefine.TIMETOP_LABEL;   // Ｘ軸上側
                            }
                            else
                            {  // Ｘ軸（上）の場合
                                sXScaleName = HySReportDefine.TIMEUNDER_LABEL; // Ｘ軸下側
                            }
                        }
                        else
                        {  // 値の場合
                            if (csRptFieldInfo.m_sXAxis.Equals(HySReportDefine.TAG_TOPLABEL) == true)
                            {  // Ｘ軸（下）の場合
                                sXScaleName = HySReportDefine.VALUETOP_LABEL; // Ｘ軸上側
                            }
                            else
                            {  // Ｘ軸（上）の場合
                                sXScaleName = HySReportDefine.VALUEUNDER_LABEL; // Ｘ軸下側
                            }
                        }
                    }
                }
                csRptAxisInfo = this.GetAxisCustomiz(new HySString(csRptFieldInfo.m_sYAxis));
                if (csRptAxisInfo is HySRptAxisInfo)
                {  // Ｙ軸情報が有効な場合
                    sYItemTitle = (csRptFieldInfo.m_sLegendName.Length > 0) ? csRptFieldInfo.m_sLegendName : HySReportDefine.GRAPH_DATA;
                    if (csRptAxisInfo.m_bAxisChkFlg == true)
                    {  // 軸使用の場合
                        if (csRptAxisInfo.m_csAxisMode == HySReportDefine.XSCALE_KIND.TIME_SERIES_DATA)
                        {  // 時系列の場合
                            if (csRptFieldInfo.m_sYAxis.Equals(HySReportDefine.TAG_LEFTLABEL) == true)
                            {  // Ｙ軸（左）の場合
                                sYScaleName = HySReportDefine.TIMELEFT_LABEL; // Ｘ軸上側
                            }
                            else
                            {  // Ｙ軸（右）の場合
                                sYScaleName = HySReportDefine.TIMERIGHT_LABEL; // Ｘ軸下側
                            }
                        }
                        else
                        {  // 値の場合
                            if (csRptFieldInfo.m_sYAxis.Equals(HySReportDefine.TAG_LEFTLABEL) == true)
                            {  // Ｙ軸（左）の場合
                                sYScaleName = HySReportDefine.VALUELEFT_LABEL; // Ｘ軸上側
                            }
                            else
                            {  // Ｙ軸（右）の場合
                                sYScaleName = HySReportDefine.VALUERIGHT_LABEL; // Ｘ軸下側
                            }
                        }
                    }
                }
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
