﻿// <summary>ソースコード：グラフ表示モジュール　メイン画面フォーム</summary>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Drawing.Printing;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　メイン画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/04][新規作成]</para>
    /// </remarks>
    [Serializable]
    public partial class HySDotNetLineGraphForm : HySDotNetForm // : Form
    {
        /// <summary>制御するクリーン</summary>
        protected HySDotNetLineGraphScreen m_csGraphViewScreen = null;

        /// <summary>期間開始</summary>
        public DateTime m_DtStart;
        /// <summary>期間終了</summary>
        public DateTime m_DtEnd;
        /// <summary>X軸の点数</summary>
        private int m_X_Num = 0;

        /// <summary>
        /// 右軸（棒グラフ）データ
        /// </summary>
        public HySEvViewRainfallItems[] m_RainfallItems = null;
        /// <summary>グラフY軸の最大値</summary>
        private float m_RainfallMaxY = 10.0F;	// グラフY軸の最大値
        /// <summary>グラフY軸の最小値</summary>
        private float m_RainfallMinY = 10.0F;	// グラフY軸の最小値
        //private float m_RainfallMaxX = 23F;		// グラフX軸の最大値
        /// <summary>グラフY軸のセパレート値</summary>
        private float m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

        /// <summary>
        /// 左軸データ
        /// </summary>
        public HySEvViewWaterLevelItems[] m_WaterLevelItems = null;
        /// <summary>グラフY軸の最大値</summary>
        private float m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
        /// <summary>グラフY軸の最大値</summary>
        private float m_WaterLevelMinY = -5.0F;	// グラフY軸の最大値
        //private float m_WaterLevelMaxX = 23F;		// グラフX軸の最大値
        /// <summary>グラフY軸のセパレート値</summary>
        private float m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値


        /// <summary>
        /// 右軸（折れ線グラフ）データ
        /// </summary>
        public HySEvViewFlowMeterItems[] m_FlowMeterItems = null;
        /// <summary>グラフY軸の最大値</summary>
        private float m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
        /// <summary>グラフY軸の最大値</summary>
        private float m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値


        /// <summary>X軸範囲自動フラグ</summary>
        private bool m_IsAutoFit = true;    //[2010.06.03]

// start of 印刷機能追加
        //印刷用・領域取得関数のインポート
        [System.Runtime.InteropServices.DllImport(@"C:\WINDOWS\system32\gdi32.dll")]
        private static extern int BitBlt(IntPtr hDestDC, int x, int y, int nWidth, int nHeight,
                                         IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        /// <summary>印刷用ビットマップ</summary>
        private Bitmap m_bit_img = null;//印刷用ビットマップ

        /// <summary>印刷用プリントドキュメント</summary>
        private System.Drawing.Printing.PrintDocument m_pd = null;
// end of 印刷機能追加


        /// <summary>ファイル選択最大可能数</summary>
        const int MAXFILENUM = 8;
        /// <summary>データ選択最大可能数</summary>
        const int MAXDATANUM = 16;


        /// <summary>左軸読み込みファイル数</summary>
        private int m_LeftAxisReadDataNum = 0;//左軸
        /// <summary>右軸（折れ線）読み込みファイル数</summary>
        private int m_RightAxisLineReadDataNum = 0;//右軸（線）
        /// <summary>右軸（棒）読み込みファイル数</summary>
        private int m_RightAxisBarReadDataNum = 0;//右軸（棒）



        /// <summary>左軸データグリッドビューアクセス</summary>
        private HySEvViewDataGridViewAccess m_csLeftAxisAccess = null;
        /// <summary>右軸（折れ線）データグリッドビューアクセス</summary>
        private HySEvViewDataGridViewAccess m_csRightAxisLineAccess = null;
        /// <summary>右軸（棒）データグリッドビューアクセス</summary>
        private HySEvViewDataGridViewAccess m_csRightAxisBarAccess = null;

        /// <summary>左軸コラムチェックインデックス</summary>
        private int[] m_iLAIndexColumn = new int[MAXDATANUM] ;
        /// <summary>左軸ロウチェックインデックス</summary>
        private int[] m_iLAIndexRow = new int[MAXDATANUM];
        /// <summary>右軸（折れ線）コラムチェックインデックス</summary>
        private int[] m_iRALineIndexColumn = new int[MAXDATANUM];
        /// <summary>右軸（折れ線）ロウチェックインデックス</summary>
        private int[] m_iRALineIndexRow = new int[MAXDATANUM];
        /// <summary>右軸（棒）コラムチェックインデックス</summary>
        private int m_iRABarIndexColumn = -1;
        /// <summary>右軸（棒）ロウチェックインデックス</summary>
        private int m_iRABarIndexRow = -1;

        /// <summary>左軸ファイルネーム</summary>
        private string[] m_sLAFileName = new string[MAXFILENUM];
        /// <summary>右軸（折れ線）ファイルネーム</summary>
        private string[] m_sRALineFileName = new string[MAXFILENUM];
        /// <summary>右軸（棒）ファイルネーム</summary>
        private string[] m_sRABarFileName = new string[MAXFILENUM];


        /// <summary>左軸データ選択数</summary>
        private int m_iLACheckNum = 0;
        /// <summary>左軸ファイルデータ</summary>
        private HySCSVFileDim1Data[] m_csLeftAxisFileData = new HySCSVFileDim1Data[MAXFILENUM];
        /// <summary>左軸ファイルヘッダデータ</summary>
        private HySCSVFileDim1Data[] m_csLeftAxisFileHeader = new HySCSVFileDim1Data[MAXFILENUM];
        /// <summary>右軸（折れ線）データ選択数</summary>
        private int m_iRALineCheckNum = 0;
        /// <summary>右軸（折れ線）ファイルデータ</summary>
        private HySCSVFileDim1Data[] m_csRightAxisLineFileData = new HySCSVFileDim1Data[MAXFILENUM];
        /// <summary>右軸（折れ線）ファイルヘッダデータ</summary>
        private HySCSVFileDim1Data[] m_csRightAxisLineFileHeader = new HySCSVFileDim1Data[MAXFILENUM];
        /// <summary>右軸（棒）データ選択数</summary>
        private int m_iRABarCheckNum = 0;
        /// <summary>右軸（棒）ファイルデータ</summary>
        private HySCSVFileDim1Data[] m_csRightAxisBarFileData = new HySCSVFileDim1Data[MAXFILENUM];
        /// <summary>右軸（棒）ファイルヘッダデータ</summary>
        private HySCSVFileDim1Data[] m_csRightAxisBarFileHeader = new HySCSVFileDim1Data[MAXFILENUM];


        /// <summary>左軸ファイルのレコード数</summary>
        private int[] m_iLAFileRecordNum = new int[MAXFILENUM];
        /// <summary>右軸（折れ線）ファイルのレコード数</summary>
        private int[] m_iRALineFileRecordNum = new int[MAXFILENUM];
        /// <summary>右軸（棒）ファイルのレコード数</summary>
        private int[] m_iRABarFileRecordNum = new int[MAXFILENUM];

        /// <summary>各グラフ値</summary>
        private HySEvViewDefine m_csDefine = null;
        /// <summary> 読み込み最大レコード数 </summary>
        private const int m_iMaxRecord = 90000;
        /// <summary>メッセージタイトル(印刷プレビュー) </summary>
        static private readonly string MSGBOX_TITLE_PRINTPREVIEW = HysMessage.GetString("HYS_MSG_TITLE_PRINTPREVIEW");

        #region 内部メソッド


        #region 右軸（棒）実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readRainfallCSVFile(ref h_items);</para>
        /// </example>
        /// <param name="h_items">HySEvViewRainfallItems：表示時間</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readRainfallCSVFile(
            ref HySEvViewRainfallItems h_items
            )
        {
            try
            {

                //Boolean a_IsFound = false;
                //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                // *** 2011.04.05 速度改善改修↓ ***
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                // *** 2011.04.05 速度改善改修↑ ***

                HySDataLinkedList csDataList = m_csRightAxisBarFileData[m_iRABarIndexRow].GetDataList();
                csDataList.SetCursorFirst();//カーソルの位置を最初に//0のところはインデックスをもってくる
                DateTime cs_DT = new DateTime(1970, 1, 1, 0, 0, 0);

                


                for (int i_Cnt = 0; i_Cnt < (int)m_iRABarFileRecordNum[m_iRABarIndexRow]; i_Cnt++)
                {
                    //i_Cnt行目のデータを取得
                    HySCSVFileDim1Data.CSVDim1Recorde csRecode = (HySCSVFileDim1Data.CSVDim1Recorde)csDataList.GetCursorData();
                    //i_Cnt行目の時間を取得
                    HySTime csHySTime = csRecode.GetTime();


                    if(i_Cnt == 0){
                        m_RainfallMaxY = Convert.ToSingle(csRecode.GetData()[m_iRABarIndexColumn]);
                        m_RainfallMinY = Convert.ToSingle(csRecode.GetData()[m_iRABarIndexColumn]);
                    }

                    //時間をDateTime型に
                    DateTime cs_DTChange = cs_DT.AddSeconds(csHySTime.GetTime());

                    // *** 2011.04.05 速度改善改修↓ ***
                    float fValue = Convert.ToSingle(csRecode.GetData()[m_iRABarIndexColumn]);

                    if (cs_DTChange > m_DtEnd)
                    {
                        break;      //期間終了を超えたら読込み終了
                    }
                    if (cs_DTChange < m_DtStart)
                    {
                        csDataList.MoveCursorNext();//カーソルの位置を次に
                        continue;   //期間開始に達していない場合は読み飛ばし
                    }

                    string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                    while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                    {   //格納する時刻インデックスまで進める
                        iDataIdx++;
                    }
                    if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                    {   //時刻が一致するなら格納
                        h_items[iDataIdx].Rainfall = fValue;

                        //最小・最大値セット
                        if (fValue != HySEvViewDefine.g_InvalidValue)
                        {   //欠測値以外なら最小・最大値セット
                            if (iTargetCnt == 0)
                            {   //最初の対象となるデータの場合、最小・最大値を初期化
                                m_RainfallMinY = fValue;
                                m_RainfallMaxY = fValue;
                            }
                            m_RainfallMinY = Math.Min(m_RainfallMinY, fValue);
                            m_RainfallMaxY = Math.Max(m_RainfallMaxY, fValue);

                            iTargetCnt++;
                        }
                    }
                    // *** 2011.04.05 速度改善改修↑ ***

                    //for (int a_iCnt = 0; a_iCnt < m_X_Num; a_iCnt++)
                    //{
                    //    //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                    //    if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                    //    {
                    //        if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(cs_DTChange.ToString()).ToString("yyyy/MM/dd HH:mm")) == true)//ファイルの時間と比べて判断
                    //        {
                    //            if (a_IsFound == false)
                    //            {
                    //                //m_RainfallMaxY = HySEvViewDefine.g_InvalidValue;
                    //                a_IsFound = true;
                    //            }

                    //            h_items[a_iCnt].Rainfall = Convert.ToSingle(csRecode.GetData()[m_iRABarIndexColumn]);//a_split[1].Trim());//ここでデータを入れる

                    //            //[2010.06.01]bug-fixed.↓
                    //            if (h_items[a_iCnt].Rainfall != HySEvViewDefine.g_InvalidValue)
                    //            {
                    //                if (h_items[a_iCnt].Rainfall > m_RainfallMaxY)
                    //                {
                    //                    m_RainfallMaxY = h_items[a_iCnt].Rainfall;
                    //                }
                    //                if (h_items[a_iCnt].Rainfall < m_RainfallMinY)
                    //                {
                    //                    m_RainfallMinY = h_items[a_iCnt].Rainfall;
                    //                }
                    //            }
                    //            //[2010.06.01]bug-fixed.↑

                    //            break;
                    //        }
                    //    }
                    //}
                    csDataList.MoveCursorNext();//カーソルの位置を次に
                }

                if (m_WaterLevelMaxY == 0.0F)
                {
                    //m_WaterLevelMaxY = 5.0F;
                }

                m_RainfallMaxY = Convert.ToSingle(Math.Ceiling(m_RainfallMaxY));

                float a_fTmp = Math.Abs(m_RainfallMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_RainfallMinY < 0)
                {
                    //m_RainfallMinY = -a_fTmp;
                }


                //[2010.06.02]↓
                //[2010.06.02]↑
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 左軸実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>左軸実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readWaterLevelCSVFile(h_idx, ref h_items);</para>
        /// </example>
        /// <param name="h_idx">int：表示順番</param>
        /// <param name="h_items">HySEvViewWaterLevelItems：表示時間</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readWaterLevelCSVFile(
            int h_idx,  //[2010.05.07]
            ref HySEvViewWaterLevelItems h_items//時間をもっている
            )
        {
            try
            {
                //Boolean a_IsFound = false;
                //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                // *** 2011.04.05 速度改善改修↓ ***
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                // *** 2011.04.05 速度改善改修↑ ***


                HySDataLinkedList csDataList = m_csLeftAxisFileData[m_iLAIndexRow[h_idx]].GetDataList();
                csDataList.SetCursorFirst();//カーソルの位置を最初に//0のところはインデックスをもってくる
                DateTime cs_DT = new DateTime(1970, 1, 1, 0, 0, 0);

                //ファイルの行数分
                for (int i_Cnt = 0; i_Cnt < (int)m_iLAFileRecordNum[m_iLAIndexRow[h_idx]]; i_Cnt++)
                {
                    //i_Cnt行目のデータを取得
                    HySCSVFileDim1Data.CSVDim1Recorde csRecode = (HySCSVFileDim1Data.CSVDim1Recorde)csDataList.GetCursorData();
                    //i_Cnt行目の時間を取得
                    HySTime csHySTime = csRecode.GetTime();

                    //時間をDateTime型に
                    DateTime cs_DTChange = cs_DT.AddSeconds(csHySTime.GetTime());

                    // *** 2011.04.05 速度改善改修↓ ***
                    float fValue = Convert.ToSingle(csRecode.GetData()[m_iLAIndexColumn[h_idx]]);

                    if (cs_DTChange > m_DtEnd)
                    {
                        break;      //期間終了を超えたら読込み終了
                    }
                    if (cs_DTChange < m_DtStart)
                    {
                        csDataList.MoveCursorNext();//カーソルの位置を次に
                        continue;   //期間開始に達していない場合は読み飛ばし
                    }

                    string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                    while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                    {   //格納する時刻インデックスまで進める
                        iDataIdx++;
                    }
                    if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                    {   //時刻が一致するなら格納
                        h_items[iDataIdx].WaterLevel = fValue;

                        //最小・最大値セット
                        if (fValue != HySEvViewDefine.g_InvalidValue)
                        {   //欠測値以外なら最小・最大値セット
                            if (h_idx == 0 && iTargetCnt == 0)
                            {   //最初の対象となるデータの場合、最小・最大値を初期化
                                m_WaterLevelMinY = fValue;
                                m_WaterLevelMaxY = fValue;
                            }
                            m_WaterLevelMinY = Math.Min(m_WaterLevelMinY, fValue);
                            m_WaterLevelMaxY = Math.Max(m_WaterLevelMaxY, fValue);

                            iTargetCnt++;
                        }
                    }
                    // *** 2011.04.05 速度改善改修↑ ***

                    //for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    //{
                    //    //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                    //    if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                    //    {
                    //        if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(cs_DTChange.ToString()).ToString("yyyy/MM/dd HH:mm")) == true)//ファイルの時間と比べて判断
                    //        {
                    //            if (a_IsFound == false)
                    //            {
                    //                if (h_idx == 0) //[2010.05.07]
                    //                {
                    //                    m_WaterLevelMaxY = 0;   // HySEvViewDefine.g_InvalidValue;
                    //                    m_WaterLevelMinY = 0;   // HySEvViewDefine.g_InvalidValue;
                    //                }
                    //                a_IsFound = true;
                    //            }

                    //            h_items[a_iCnt].WaterLevel = Convert.ToSingle(csRecode.GetData()[m_iLAIndexColumn[h_idx]]);//a_split[1].Trim());//ここでデータを入れる

                    //            //[2010.06.01]bug-fixed.↓
                    //            if (h_items[a_iCnt].WaterLevel != HySEvViewDefine.g_InvalidValue)
                    //            {
                    //                if (h_items[a_iCnt].WaterLevel > m_WaterLevelMaxY)
                    //                {
                    //                    m_WaterLevelMaxY = h_items[a_iCnt].WaterLevel;
                    //                }
                    //                if (h_items[a_iCnt].WaterLevel < m_WaterLevelMinY)
                    //                {
                    //                    m_WaterLevelMinY = h_items[a_iCnt].WaterLevel;
                    //                }
                    //            }
                    //            //[2010.06.01]bug-fixed.↑

                    //            break;
                    //        }
                    //    }
                    //}
                    csDataList.MoveCursorNext();//カーソルの位置を次に
                }


                if (m_WaterLevelMaxY == 0.0F)
                {
                    m_WaterLevelMaxY = 5.0F;
                }

                m_WaterLevelMaxY = Convert.ToSingle(Math.Ceiling(m_WaterLevelMaxY));

                float a_fTmp = Math.Abs(m_WaterLevelMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_WaterLevelMinY < 0)
                {
                    m_WaterLevelMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 右軸（折れ線）実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>右軸（折れ線）実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readFlowMeterCSVFile(h_idx, ref h_items);</para>
        /// </example>
        /// <param name="h_idx">int：表示順番</param>
        /// <param name="h_items">HySEvViewFlowMeterItems：表示時間</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readFlowMeterCSVFile(
            int h_idx,  //[2010.05.07]
            ref HySEvViewFlowMeterItems h_items
            )
        {
            try
            {
                //Boolean a_IsFound = false;
                //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                // *** 2011.04.05 速度改善改修↓ ***
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                // *** 2011.04.05 速度改善改修↑ ***

                HySDataLinkedList csDataList = m_csRightAxisLineFileData[m_iRALineIndexRow[h_idx]].GetDataList();
                csDataList.SetCursorFirst();//カーソルの位置を最初に//0のところはインデックスをもってくる
                DateTime cs_DT = new DateTime(1970, 1, 1, 0, 0, 0);

                //ファイルの行数分
                for (int i_Cnt = 0; i_Cnt < (int)m_iRALineFileRecordNum[m_iRALineIndexRow[h_idx]]; i_Cnt++)
                {
                    //i_Cnt行目のデータを取得
                    HySCSVFileDim1Data.CSVDim1Recorde csRecode = (HySCSVFileDim1Data.CSVDim1Recorde)csDataList.GetCursorData();
                    //i_Cnt行目の時間を取得
                    HySTime csHySTime = csRecode.GetTime();


                    //時間をDateTime型に
                    DateTime cs_DTChange = cs_DT.AddSeconds(csHySTime.GetTime());

                    // *** 2011.04.05 速度改善改修↓ ***
                    float fValue = Convert.ToSingle(csRecode.GetData()[m_iRALineIndexColumn[h_idx]]);

                    if (cs_DTChange > m_DtEnd)
                    {
                        break;      //期間終了を超えたら読込み終了
                    }
                    if (cs_DTChange < m_DtStart)
                    {
                        csDataList.MoveCursorNext();//カーソルの位置を次に
                        continue;   //期間開始に達していない場合は読み飛ばし
                    }

                    string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                    while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                    {   //格納する時刻インデックスまで進める
                        iDataIdx++;
                    }
                    if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                    {   //時刻が一致するなら格納
                        h_items[iDataIdx].FlowMeter = fValue;

                        //最小・最大値セット
                        if (fValue != HySEvViewDefine.g_InvalidValue)
                        {   //欠測値以外なら最小・最大値セット
                            if (h_idx == 0 && iTargetCnt == 0)
                            {   //最初の対象となるデータの場合、最小・最大値を初期化
                                m_FlowMeterMinY = fValue;
                                m_FlowMeterMaxY = fValue;
                            }
                            m_FlowMeterMinY = Math.Min(m_FlowMeterMinY, fValue);
                            m_FlowMeterMaxY = Math.Max(m_FlowMeterMaxY, fValue);

                            iTargetCnt++;
                        }
                    }
                    // *** 2011.04.05 速度改善改修↑ ***

                    //for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    //{
                    //    if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                    //    {
                    //        if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(cs_DTChange.ToString()).ToString("yyyy/MM/dd HH:mm")) == true)//ファイルの時間と比べて判断
                    //        {
                    //            if (a_IsFound == false)
                    //            {
                    //                if (h_idx == 0) //[2010.05.07]
                    //                {
                    //                    m_FlowMeterMaxY = 0;   // HySEvViewDefine.g_InvalidValue;
                    //                    m_FlowMeterMinY = 0;   // HySEvViewDefine.g_InvalidValue;
                    //                }
                    //                a_IsFound = true;
                    //            }

                    //            h_items[a_iCnt].FlowMeter = Convert.ToSingle(csRecode.GetData()[m_iRALineIndexColumn[h_idx]]);//a_split[1].Trim());//ここでデータを入れる

                    //            //[2010.06.01]bug-fixed.↓
                    //            if (h_items[a_iCnt].FlowMeter != HySEvViewDefine.g_InvalidValue)
                    //            {
                    //                if (h_items[a_iCnt].FlowMeter > m_FlowMeterMaxY)
                    //                {
                    //                    m_FlowMeterMaxY = h_items[a_iCnt].FlowMeter;
                    //                }
                    //                if (h_items[a_iCnt].FlowMeter < m_FlowMeterMinY)
                    //                {
                    //                    m_FlowMeterMinY = h_items[a_iCnt].FlowMeter;
                    //                }
                    //            }
                    //            //[2010.06.01]bug-fixed.↑

                    //            break;
                    //        }
                    //    }
                    //}
                    csDataList.MoveCursorNext();//カーソルの位置を次に
                }

                if (m_FlowMeterMaxY == 0.0F)
                {
                    m_FlowMeterMaxY = 50.0F;
                }

                m_FlowMeterMaxY = Convert.ToSingle(Math.Ceiling(m_FlowMeterMaxY));

                float a_fTmp = Math.Abs(m_FlowMeterMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_FlowMeterMinY < 0)
                {
                    m_FlowMeterMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 右軸（棒）描画
        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）描画設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawRainfall();</para>
        /// </example>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawRainfall()
        {
            try
            {
                m_RainfallMaxY = 9.0F;	// グラフY軸の最大値
                m_RainfallMinY = 0.0F;	// グラフY軸の最小値
                m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

                m_RainfallItems = null;

                int a_idx = 0;
                m_RainfallItems = new HySEvViewRainfallItems[m_iRABarCheckNum];

                for (int i_LCnt = 0; i_LCnt < m_iRABarCheckNum; i_LCnt++)
                {
                    m_RainfallItems[a_idx] = new HySEvViewRainfallItems();
                    m_RainfallItems[a_idx].FileName = m_sRABarFileName[m_iRABarIndexRow];

                    //凡例リストから色を取得
                    m_RainfallItems[a_idx].LineColor = legendList1.GetLegend("RB" + m_iRABarIndexColumn.ToString(), m_sRABarFileName[m_iRABarIndexRow]);


                    //雨量は水位よりも１個分少なくなる
                    //[2010.03.07]
                    for (int a_iCnt = 1; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        HySEvViewRainfallItem a_item = new HySEvViewRainfallItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                        }
                        a_item.TimeOrDay = a_iCnt - 1;  //雨量は水位よりも１個分少なくなる。
                        a_item.Rainfall = HySEvViewDefine.g_InvalidValue2; //[2010.06.02]
                        m_RainfallItems[a_idx].Add(a_item);	// Listに追加
                    }
                    _readRainfallCSVFile(
                        ref m_RainfallItems[a_idx]
                        );
                    a_idx++;
                }


                if (m_csDefine.g_FlowMeter_MaxY == HySEvViewDefine.g_InvalidValue)
                {
                    if (m_RainfallMaxY == HySEvViewDefine.g_InvalidValue)
                    {
                        m_RainfallMaxY = 9.0F;
                    }
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_RainfallMaxY = m_csDefine.g_FlowMeter_MaxY;
                    }
                }
                //Y軸最小値
                if (m_csDefine.g_FlowMeter_MinY == HySEvViewDefine.g_InvalidValue)
                {
                    //m_RainfallMinY = 0.0F;
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_RainfallMinY = m_csDefine.g_FlowMeter_MinY;
                    }
                }

                /////////////////////////////////////////////////////////////////////////////

                HySEvViewRainfall a_gw = new HySEvViewRainfall();

                //a_gw.m_sep_bottom = 10;
                a_gw.m_sep_left = 30;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 10;



                a_gw.ImageWidth = this.picRainfall.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picRainfall.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = HySEvViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_RainfallMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_RainfallMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_RainfallSepY;	// グラフY軸のセパレート値
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;   //[2010.03.07]



                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示

                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線
                a_gw.GraphLineY = false;
                a_gw.GraphHasMeasureY = false;   // Y軸の目盛表示

                a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }
                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode);	//[2010.03.07] グラフの初期化

                //if (m_RainfallItems != null)
                //{
                 //   for (int a_iCnt = 0; a_iCnt < m_RainfallItems.Length; a_iCnt++)
                 //   {
                        //a_gw.SetRainfallItems(m_RainfallItems[a_iCnt]);	// X,Y値のプロット
                 //   }
                //}
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 両軸描画
        /// <summary><para>method outline:</para>
        /// <para>左軸・右軸描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawWaterLevel();</para>
        /// </example>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawWaterLevel()
        {
            try
            {
                m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
                m_WaterLevelMinY = -4.0F;	// グラフY軸の最大値
                m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値
                m_FlowMeterMaxY = 9.0F;	// グラフY軸の最大値
                m_FlowMeterMinY = 0.0F;	// グラフY軸の最小値
                bool bWMax = true;//falseは手動　trueは自動
                bool bWMin = true;
                bool bFMax = true;
                bool bFMin = true;

                // 左軸
                m_WaterLevelItems = null;

                int a_idx = 0;
                m_WaterLevelItems = new HySEvViewWaterLevelItems[m_iLACheckNum];//ここをグリッドビューのチェック分にする

                for(int i_LCnt = 0;i_LCnt < m_iLACheckNum;i_LCnt++)
                {
                    m_WaterLevelItems[a_idx] = new HySEvViewWaterLevelItems();
                    string s_FileName = m_sLAFileName[m_iLAIndexRow[i_LCnt]];//m_csLeftAxisFileData[m_iLAIndexRow[i_LCnt]].GetFileName().ToString();// Path.GetFileName(m_csLeftAxisFileData[m_iIndexRow[i_LCnt]].GetFileName().ToString());
                    m_WaterLevelItems[a_idx].FileName = s_FileName;//a_sVal;//チェックボックスのファイル名が入る

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;//線と点のブーリアン
                    string s_DgvCurrentIndex = m_iLAIndexColumn[i_LCnt].ToString();
                    m_WaterLevelItems[a_idx].LineColor = legendList1.GetLegend(("LA" + s_DgvCurrentIndex), s_FileName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_WaterLevelItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_WaterLevelItems[a_idx].LineSize = fLineSize;
                    m_WaterLevelItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)
                    {
                        m_WaterLevelItems[a_idx].PlotKind = enumPlotKind.Line;
                    }
                    if (bDrawPoint)
                    {
                        m_WaterLevelItems[a_idx].PlotForm = enumPlotForm.FillCircle;
                    }

                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)//←すでに時間が決まっている　m_X_Numで判断　再描画のところで決定
                    {
                        HySEvViewWaterLevelItem a_item = new HySEvViewWaterLevelItem();//時間分まわす
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                        }
                        a_item.TimeOrDay = a_iCnt;
                        a_item.WaterLevel = HySEvViewDefine.g_InvalidValue2; //[2010.06.02]
                        m_WaterLevelItems[a_idx].Add(a_item);	// Listに追加
                    }
                    _readWaterLevelCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_WaterLevelItems[a_idx]
                        );
                    a_idx++;
                }

                //[2010.03.07]
                //Y軸最大値
                if (m_csDefine.g_WaterLevel_MaxY == HySEvViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMaxY == HySEvViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMaxY = 5.0F;
                    }
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_WaterLevelMaxY = m_csDefine.g_WaterLevel_MaxY;
                        bWMax = false;
                    }
                }
                //Y軸最小値
                if (m_csDefine.g_WaterLevel_MinY == HySEvViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMinY == HySEvViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMinY = -5.0F;
                    }
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_WaterLevelMinY = m_csDefine.g_WaterLevel_MinY;
                        bWMin = false;
                    }
                }
                double a_dLen = Math.Ceiling(m_WaterLevelMaxY - m_WaterLevelMinY);
                int a_iLen = 0;
                if (a_dLen > 10)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_WaterLevelSepY = a_iLen;

                if ((Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY) != 0)
                {
                    m_WaterLevelMaxY += (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY));
                }
                if ((Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY) != 0)
                {
                    //m_WaterLevelMinY -= (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY));
                }

                ////////////////////////////////////////
                //最大値補正
                if (m_WaterLevelMaxY <= m_WaterLevelMinY)
                {
                    if (bWMax == true && bWMin == false)
                    {
                        m_WaterLevelMaxY = m_WaterLevelMinY + 1;
                    }
                    else if (bWMax == false && bWMin == true)
                    {
                        m_WaterLevelMinY = m_WaterLevelMaxY - 1;
                    }
                }
                ////////////////////////////////////////


                // 右軸（折れ線）
                m_FlowMeterItems = null;

                a_idx = 0;


                m_FlowMeterItems = new HySEvViewFlowMeterItems[m_iRALineCheckNum];//ここをグリッドビューのチェック分にする

                for (int i_LCnt = 0; i_LCnt < m_iRALineCheckNum; i_LCnt++)
                {
                    m_FlowMeterItems[a_idx] = new HySEvViewFlowMeterItems();
                    string s_FileName = m_sRALineFileName[m_iRALineIndexRow[i_LCnt]];
                    m_FlowMeterItems[a_idx].FileName = s_FileName;//a_sVal;//チェックボックスのファイル名が入る

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;//線と点のブーリアン
                    string s_DgvCurrentIndex = m_iRALineIndexColumn[i_LCnt].ToString();
                    m_FlowMeterItems[a_idx].LineColor = legendList1.GetLegend(("RL"+s_DgvCurrentIndex), s_FileName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_FlowMeterItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_FlowMeterItems[a_idx].LineSize = fLineSize;
                    m_FlowMeterItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)
                    {
                        m_FlowMeterItems[a_idx].PlotKind = enumPlotKind.Line;
                    }
                    if (bDrawPoint)
                    {
                        m_FlowMeterItems[a_idx].PlotForm = enumPlotForm.FillCircle;
                    }


                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)//←すでに時間が決まっている　m_X_Numで判断　再描画のところで決定
                    {
                        HySEvViewFlowMeterItem a_item = new HySEvViewFlowMeterItem();//時間分まわす
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                        }
                        a_item.TimeOrDay = a_iCnt;
                        a_item.FlowMeter = HySEvViewDefine.g_InvalidValue2; //[2010.06.02]
                        m_FlowMeterItems[a_idx].Add(a_item);	// Listに追加
                    }
                    _readFlowMeterCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_FlowMeterItems[a_idx]
                        );
                    a_idx++;
                }


                HySEvViewWaterLevel a_gw = new HySEvViewWaterLevel();

                //a_gw.m_sep_bottom = 0;
                a_gw.m_sep_left = 30;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 10;


                a_gw.ImageWidth = this.picWaterLevel.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picWaterLevel.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）

                a_gw.InvalidValue = HySEvViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_WaterLevelMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_WaterLevelMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_WaterLevelSepY;	// グラフY軸のセパレート値
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;       //[2010.03.07]

                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転
                a_gw.StartTime = m_DtStart; //[2010.03.07]

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示

                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示

                a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }

                //[2010.03.07]
                //Y軸最大値
                if (m_csDefine.g_FlowMeter_MaxY == HySEvViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMaxY == HySEvViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMaxY = 5.0F;
                    }
                     */ 
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_FlowMeterMaxY = m_csDefine.g_FlowMeter_MaxY;
                        bFMax = false;
                    }
                }
                //Y軸最小値
                if (m_csDefine.g_FlowMeter_MinY == HySEvViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMinY == HySEvViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMinY = -5.0F;
                    }
                     */ 
                }
                else
                {
                    if (m_csDefine.g_bAutoBounds == false)
                    {
                        m_FlowMeterMinY = m_csDefine.g_FlowMeter_MinY;
                        bFMin = false;
                    }
                }

                //右軸比較
                if (m_RainfallMaxY < m_FlowMeterMaxY)
                {
                    m_RainfallMaxY = m_FlowMeterMaxY;
                }
                else
                {
                    m_FlowMeterMaxY = m_RainfallMaxY;
                }

                if (m_RainfallMinY > m_FlowMeterMinY)
                {
                    m_RainfallMinY = m_FlowMeterMinY;
                }
                else
                {
                    m_FlowMeterMinY = m_RainfallMinY;
                }

                ////////////////////////////////////////
                //最大値補正
                if (m_FlowMeterMaxY <= m_FlowMeterMinY)
                {
                    if (bFMax == true && bFMin == false)
                    {
                        m_FlowMeterMaxY = m_FlowMeterMinY + 1;
                        m_RainfallMaxY = m_FlowMeterMaxY;
                    }
                    else if (bFMax == false && bFMin == true)
                    {
                        m_FlowMeterMinY = m_FlowMeterMaxY - 1;
                        m_RainfallMinY = m_FlowMeterMinY;
                    }
                }
                ////////////////////////////////////////

                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode, ref m_FlowMeterMinY, ref m_FlowMeterMaxY);	//[2010.03.07] グラフの初期化
                
                //float a_fTmp = picRainfall.Height - (a_gw.m_sep_top + a_gw.m_sep_bottom);
                //float f_sep = a_fTmp / (m_WaterLevelMaxY - m_WaterLevelMinY);
                int a_iTmp = (int)((m_WaterLevelMaxY - m_WaterLevelMinY) / m_WaterLevelSepY);
                if (a_iTmp * m_WaterLevelSepY > m_WaterLevelMaxY - m_WaterLevelMinY)
                {
                    a_iTmp++;
                }
                a_gw.GraphSepY = ((m_WaterLevelMaxY - m_WaterLevelMinY) / a_iTmp);
                
                a_gw.DrawGraphBackGround();	// グラフの初期化



                ///////////////////////////////////////////////////////////////////////////////////
                double b_dLen = Math.Ceiling(m_RainfallMaxY - m_RainfallMinY);
                int b_iLen = 0;
                if (b_dLen > 10)
                {
                    b_iLen = Convert.ToInt32(Math.Floor(b_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((b_iLen % 2) != 0)
                    {
                        b_iLen += (b_iLen % 2);
                    }
                }
                else
                {
                    b_iLen = 1;
                }
                m_RainfallSepY = b_iLen;

                if ((Math.Abs(m_RainfallMaxY) % m_RainfallSepY) != 0)
                {
                    m_RainfallMaxY += (m_RainfallSepY - (Math.Abs(m_RainfallMaxY) % m_RainfallSepY));
                }
                if ((Math.Abs(m_RainfallMinY) % m_RainfallSepY) != 0)
                {
                    //m_RainfallMinY -= (m_RainfallSepY - (Math.Abs(m_RainfallMinY) % m_RainfallSepY));
                }
                HySEvViewRainfall b_gw = new HySEvViewRainfall();

                //a_gw.m_sep_bottom = 10;
                b_gw.m_sep_left = 30;   //[2010.03.07]
                b_gw.m_sep_right = 50;  //[2010.03.07]
                b_gw.m_sep_top = 10;

                b_gw.ImageWidth = this.picRainfall.Width;	// 出力グラフ画像の横サイズ（pixel）
                b_gw.ImageHeight = this.picRainfall.Height;	// 出力グラフ画像の縦サイズ（pixel）
                b_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                b_gw.InvalidValue = HySEvViewDefine.g_InvalidValue;	// 欠測値
                b_gw.GraphMaxY = m_RainfallMaxY;	// グラフY軸の最大値
                b_gw.GraphMinY = m_RainfallMinY;	// グラフY軸の最小値
                b_gw.GraphSepY = m_RainfallSepY;	// グラフY軸のセパレート値
                b_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                b_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                b_gw.GraphSepX = 1;   //[2010.03.07]

                b_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                b_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                b_gw.GraphYReverse = false;	// Y軸の反転

                b_gw.GraphHasMeasureX = false;   // X軸の目盛表示

                b_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                b_gw.GraphMeasureXKind = false; // X軸の目盛線
                b_gw.GraphLineY = false;
                b_gw.GraphHasMeasureY = false;   // Y軸の目盛表示

                b_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式
                b_gw.GraphMeasureYKind = false; // Y軸の目盛線

                int b_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    b_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    b_mode = 1;
                }
                b_gw.InitGraph(m_DtStart, m_DtEnd, b_mode);	//[2010.03.07] グラフの初期化

                if (m_RainfallItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_RainfallItems.Length; a_iCnt++)
                    {
                        b_gw.SetRainfallItems(m_RainfallItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                b_gw.DrawGraphBackGround();	// グラフの初期化

                this.picRainfall.Image = b_gw.m_bm;

                ////////////////////////////////////////////////////////////////////////////////////////////


                //水位の描画
                if (m_WaterLevelItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_WaterLevelItems.Length; a_iCnt++)
                    {
                        a_gw.SetWaterLevelItems(m_WaterLevelItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                //流量の描画
                if (m_FlowMeterItems != null)
                {
                    //a_gw.GraphMaxY = m_FlowMeterMaxY;	// グラフY軸の最大値
                    //a_gw.GraphMinY = m_FlowMeterMinY;	// グラフY軸の最小値
                    //a_gw.InitializeSeparate();

                    for (int a_iCnt = 0; a_iCnt < m_FlowMeterItems.Length; a_iCnt++)
                    {
                        a_gw.SetFlowMeterItems(m_FlowMeterItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                this.picWaterLevel.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 再描画
        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_redraw(h_hour_st, h_minute_st, h_hour_ed, h_minute_ed);</para>
        /// </example>
        /// <param name="h_hour_st">int：開始時間（○時）</param>
        /// <param name="h_minute_st">int：開始時間（○分）</param>
        /// <param name="h_hour_ed">int：終了時間（○時）</param>
        /// <param name="h_minute_ed">int：終了時間（○分）</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _redraw(
            int h_hour_st,
            int h_minute_st,
            int h_hour_ed,
            int h_minute_ed
            )
        {
            Cursor a_preCursor = Cursor.Current;

            //選択時間のチェック
            int iCheck = Selected_Time_Check();
            if (iCheck == -1)
            {
                //MessageBox.Show("選択した表示時間が間違っています", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OUTSIDE_INDICATION_TIME"), HysMessage.GetString("HYS_MSG_TITLE_ERR"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                m_DtStart = new DateTime(
                    dtpStart.Value.Year,
                    dtpStart.Value.Month,
                    dtpStart.Value.Day,
                    h_hour_st,  //Convert.ToInt32(cmbHourStart.SelectedValue),
                    h_minute_st,  //Convert.ToInt32(cmbMinuteStart.SelectedValue),
                    0
                    );
                m_DtEnd = new DateTime(
                    dtpEnd.Value.Year,
                    dtpEnd.Value.Month,
                    dtpEnd.Value.Day,
                    h_hour_ed, //Convert.ToInt32(cmbHourEnd.SelectedValue),
                    h_minute_ed,  //Convert.ToInt32(cmbMinuteEnd.SelectedValue),
                    0
                    );

                TimeSpan a_ts = m_DtEnd - m_DtStart;

                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalMinutes));
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalHours));
                }


                _drawRainfall();
                _drawWaterLevel();
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion


        #region 開始・終了時刻再設定

        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampAll();</para>
        /// </example>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampAll()
        {
            String a_sStart = "";
            String a_sEnd = "";

            String a_sTmp = "";
            String a_sTmp1 = "";
            String a_sTmp2 = "";
            String a_sTmp3 = "";
            
            //左軸開始・終了時刻取得（チェック数分）
            for (int i_Cnt = 0; i_Cnt < m_iLACheckNum  ; i_Cnt++)
            {
                string s_Name = "LeftAxis";
                _getTimeStampParts(ref a_sStart, ref a_sEnd, i_Cnt, s_Name);
            }

            //右軸（折れ線）開始・終了時刻取得（チェック数分）
            for (int i_Cnt = 0; i_Cnt < m_iRALineCheckNum; i_Cnt++)
            {
                string s_Name = "RightAxisLine";
                _getTimeStampParts(ref a_sStart, ref a_sEnd, i_Cnt, s_Name);
            }

            //右軸（棒）開始・終了時刻取得
            for (int i_Cnt = 0; i_Cnt < m_iRABarCheckNum; i_Cnt++)
            {
                string s_Name = "RightAxisBar";
                _getTimeStampParts(ref a_sStart, ref a_sEnd, i_Cnt, s_Name);
            }


            if (a_sStart.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sStart).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sStart).ToString("mm");

                dtpStart.Text = a_sTmp1;
                cmbHourStart.Text = a_sTmp2;
                cmbMinuteStart.Text = a_sTmp3;
            }

            if (a_sEnd.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sEnd).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sEnd).ToString("mm");

                dtpEnd.Text = a_sTmp1;
                cmbHourEnd.Text = a_sTmp2;
                cmbMinuteEnd.Text = a_sTmp3;
            }
        }
        #endregion
        #region 開始・終了時刻再設定
        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻部分再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampParts(h_sStart, h_sEnd, i_TimeCnt, s_Name);</para>
        /// </example>
        /// <param name="h_sStart">String：開始時間</param>
        /// <param name="h_sEnd">String：終了時間</param>
        /// <param name="i_TimeCnt">int：チェック個数</param>
        /// <param name="s_Name">string：各グラフの判定</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampParts(
            ref String h_sStart,
            ref String h_sEnd,
            int i_TimeCnt,
            string s_Name
            )
        {
            Boolean a_IsFirst = false;

            String a_sStart = "";
            String a_sEnd = "";
            HySCSVFileDim1Data[] FileData = null;
            int[] FileRecordNum = null;
            int i_Index = 0;

            if (h_sStart.Length > 0)
            {
                a_sStart = DateTime.Parse(h_sStart).ToString("yyyy/MM/dd HH:mm");
            }
            if (h_sEnd.Length > 0)
            {
                a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
            }


            if (s_Name == "LeftAxis")
            {
                FileData = m_csLeftAxisFileData;
                FileRecordNum = m_iLAFileRecordNum;
                i_Index = m_iLAIndexRow[i_TimeCnt];
            }
            else if (s_Name == "RightAxisLine")
            {
                FileData = m_csRightAxisLineFileData;
                FileRecordNum = m_iRALineFileRecordNum;
                i_Index = m_iRALineIndexRow[i_TimeCnt];
            }
            else if(s_Name == "RightAxisBar"){
                FileData = m_csRightAxisBarFileData;
                FileRecordNum = m_iRABarFileRecordNum;
                i_Index = m_iRABarIndexRow;
            }

            String a_sTmp = "";

            a_IsFirst = true;

            HySDataLinkedList csDataList = FileData[i_Index].GetDataList();
            csDataList.SetCursorFirst();//カーソルの位置を最初に//0のところはインデックスをもってくる
            DateTime cs_DT = new DateTime(1970, 1, 1, 0, 0, 0);


            //チェックが入っているデータの行分を回す
            for (int i_Cnt = 0; i_Cnt < (int)FileRecordNum[i_Index]; i_Cnt++)
            {
                //i_Cnt行目のデータを取得
                HySCSVFileDim1Data.CSVDim1Recorde csRecode = (HySCSVFileDim1Data.CSVDim1Recorde)csDataList.GetCursorData();
                //i_Cnt行目の時間を取得
                HySTime csHySTime = csRecode.GetTime();

                DateTime cs_DTChange = cs_DT.AddSeconds(csHySTime.GetTime());
                a_sTmp = DateTime.Parse(cs_DTChange.ToString()).ToString("yyyy/MM/dd HH:mm"); //DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm");
                csDataList.MoveCursorNext();//カーソルの位置を次に

                //開始時刻
                if (a_IsFirst == true)
                {
                    if (h_sStart.Length == 0)
                    {
                        //h_sStart = a_split[0];
                        h_sStart = a_sTmp;
                    }
                    else
                    {
                        if (a_sTmp.CompareTo(a_sStart) < 0)
                        {
                            h_sStart = a_sTmp;
                        }
                    }
                    a_IsFirst = false;
                }

                //終了時刻
                if (h_sEnd.Length == 0)
                {
                    //h_sEnd = a_split[0];
                    h_sEnd = a_sTmp;
                    a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                }
                else
                {
                    if (a_sTmp.CompareTo(a_sEnd) > 0)
                    {
                        h_sEnd = a_sTmp;
                        a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                    }
                }
            }
        }
        #endregion

        #endregion

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetLineGraphForm csNewProjectForm = new HySDotNetLineGraphForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySDotNetLineGraphForm()
        {
            InitializeComponent();
        }


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetLineGraphForm csNewProjectForm = new HySDotNetLineGraphForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>HySDotNetLineGraphForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetLineGraphForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csGraphViewScreen = csScreen as HySDotNetLineGraphScreen; // 便利の為

            //凡例の色･線種変更時イベント割付
            legendList1.LegendStyleChanged += new EventHandler(legendList1_LegendStyleChanged);
        }
        


        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じた時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetLineGraphForm_FormClosed(sender, e)：フォームを閉じた時のイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetLineGraphForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_csGraphViewScreen.CloseScreen();  //⇒★[2010.01.29]
        }


        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じようとした時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetLineGraphForm_FormClosing(sender, e)：フォームが閉じようとしたときのイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetLineGraphForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            //自動保存設定が有効になっていた場合
            if (m_csDefine.g_bAutoStatus == true)
            {
                SetGraphInformation();
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>フォームロードイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetLineGraphForm_Load(sender, e)：フォームがロードされたときのイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetLineGraphForm_Load(object sender, EventArgs e)
        {
            cmbHourStart.SelectedIndex = 0;
            cmbHourEnd.SelectedIndex = 23;
            cmbMinuteStart.SelectedIndex = 0;
            cmbMinuteEnd.SelectedIndex = 00;

            //cmbTargetData.SelectedIndex = 0;

            m_csDefine = new HySEvViewDefine();


            _redraw(0, 0, 23, 0);
            //各データグリッドアクセスインスタンス作成
            m_csLeftAxisAccess = new HySEvViewDataGridViewAccess();
            m_csRightAxisLineAccess = new HySEvViewDataGridViewAccess();
            m_csRightAxisBarAccess = new HySEvViewDataGridViewAccess();
            //折れ線グラフのピクチャーボックスを棒グラフの支配下におく
            picRainfall.Controls.Add(picWaterLevel);
            //ピクチャーボックスの点を合わせる
            picWaterLevel.Top = picWaterLevel.Top - picRainfall.Top;
            picWaterLevel.Left = picWaterLevel.Left - picRainfall.Left;

            //情報設定ファイルを読み込む
            GetGraphInformation();

            //_checkRainCalc();   //[2010.05.07] 消去
        }



        /// <summary><para>method outline:</para>
        /// <para>凡例の色･線種変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> legendList1_LegendStyleChanged(sender, e)：凡例の変更フォームのOKボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void legendList1_LegendStyleChanged(object sender, EventArgs e)
        {
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }



        /// <summary><para>method outline:</para>
        /// <para>再描画開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRedraw_Click(sender, e)：再描画ボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRedraw_Click(object sender, EventArgs e)
        {
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }

            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }


        
        /// <summary><para>method outline:</para>
        /// <para>グラフ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSetGraph_Click(sender, e)：グラフ設定ボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            HySEvSetForm a_frm = null;

            try
            {
                a_frm = new HySEvSetForm(this);
                a_frm.Define = m_csDefine;
                a_frm.ShowDialog(this);
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
            finally
            {
                LeftAxisLabel.Text = m_csDefine.g_sLeftLabel;
                RightAxisLabel.Text = m_csDefine.g_sRightlabel;
                a_frm = null;
            }
        }



        /// <summary><para>method outline:</para>
        /// <para>描画リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnResetDraw_Click(sender, e)：リセットボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnResetDraw_Click(object sender, EventArgs e)
        {
            //[2010.06.03]ファイルの内容から開始・終了時刻を再設定する。
            m_IsAutoFit = true;
            _getTimeStampAll();
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            X_Auto_radioButton.Select();
            X_Auto_radioButton_CheckedChanged(sender, e);
        }

// start of 印刷機能追加
        /// <summary><para>method outline:</para>
        /// <para>取得領域ビットマップ化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap btmp = CaptureControl( ctrl )</para>
        /// </example>
        /// <param name="ctrl">ウインドウ部品（コントロール）</param>
        /// <returns>Bitmap : 取得領域内の画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Bitmap CaptureControl(Control ctrl)
        {
            Graphics g = ctrl.CreateGraphics();
            //ctrl（panel）の大きさのBitmapを生成
            Bitmap b_img = new Bitmap(ctrl.ClientRectangle.Width, ctrl.ClientRectangle.Height, g);
            Graphics memg = Graphics.FromImage(b_img);
            //BitBltの引数の用意
            IntPtr dc1 = g.GetHdc();
            IntPtr dc2 = memg.GetHdc();
            const int SRCCOPY = 0xCC0020;
            //Bitmap取得
            BitBlt(dc2, 0, 0, b_img.Width, b_img.Height, dc1, 0, 0, SRCCOPY);
            //解放処理
            g.ReleaseHdc(dc1);
            memg.ReleaseHdc(dc2);
            memg.Dispose();
            g.Dispose();
            return b_img;
        }

        /// <summary><para>method outline:</para>
        /// <para>プリントイベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> pd_PrintPage += new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">プリントイベント(PrintPageEvent)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void pd_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            int iX = 0;
            int iY = 0;
            int iWidth = 0;
            int iHeight = 0;

            //画像を描画する
            //e.Graphics.DrawImage(m_bit_img, 0, 0, m_bit_img.Width, m_bit_img.Height);

            // A4横用の計算
            iX = (int)(m_pd.DefaultPageSettings.HardMarginY + m_pd.DefaultPageSettings.Margins.Top);
            iY = (int)(m_pd.DefaultPageSettings.HardMarginX + m_pd.DefaultPageSettings.Margins.Right);
            iWidth = m_pd.DefaultPageSettings.PaperSize.Height - iY - (int)m_pd.DefaultPageSettings.HardMarginY - (int)m_pd.DefaultPageSettings.Margins.Bottom;
            iHeight = m_pd.DefaultPageSettings.PaperSize.Width - iX - (int)m_pd.DefaultPageSettings.HardMarginX - (int)m_pd.DefaultPageSettings.Margins.Left;
            e.Graphics.DrawImage(m_bit_img, iX, iY, iWidth, iHeight);
            //印刷の次のページがないこと
            e.HasMorePages = false;
            //bitmap解放
            //m_bit_img.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> print_button_Click( sender, e )：（印刷ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void print_button_Click(object sender, EventArgs e)
        {
            //印刷用ビットマップの取得
            m_bit_img = (CaptureControl(panel1));

            //プリントドキュメントの生成
            m_pd = new System.Drawing.Printing.PrintDocument();

            //PrintPageイベントハンドラの追加
            m_pd.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

            //プリントダイアログの生成
            PrintDialog pdlg = new PrintDialog();
            pdlg.UseEXDialog = true;
            //PrintDocumentを指定
            pdlg.Document = m_pd;
            //印刷の選択ダイアログを表示する
            if (pdlg.ShowDialog() == DialogResult.OK)
            {

                //プリンター設定
                m_pd.PrinterSettings = pdlg.Document.PrinterSettings;

                //ページ設定
                foreach (PaperSize ps in pdlg.PrinterSettings.PaperSizes)
                {
                    // A4用紙に設定する
                    if (ps.Kind == PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;
                        break;
                    }
                }
                //OKがクリックされた時は印刷する
                m_pd.Print();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷プレビュー表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Preview_button_Click( sender, e )：（印刷ﾌﾟﾚﾋﾞｭｰボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Preview_button_Click(object sender, EventArgs e)
        {
            try
            {
                //印刷用ビットマップの取得
                m_bit_img = (CaptureControl(panel1));

                //プリントドキュメントの生成
                m_pd = new System.Drawing.Printing.PrintDocument();

                //PrintPageイベントハンドラの追加
                m_pd.PrintPage +=
                    new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

                //プレビューフォームのインスタンス生成
                PrintPreviewDialog ppd = new PrintPreviewDialog();
                //プレビューするPrintDocumentを設定
                ppd.Document = m_pd;

                //プリンター設定
                m_pd.PrinterSettings = ppd.Document.PrinterSettings;

                //ページ設定
                foreach (PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    // A4用紙に設定する
                    if (ps.Kind == PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;
                        break;
                    }
                }

                //印刷プレビューダイアログを表示する
                ppd.ShowDialog();
                m_bit_img.Dispose();
            }
            catch (InvalidPrinterException pex)
            {
                // ダイアログ表示
                MessageBox.Show(pex.Message, MSGBOX_TITLE_PRINTPREVIEW, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.Preview_button_Click", 
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + "(" + pex.Message +")");
               // HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.Preview_button_Click", "catch exception( " + pex.Message + ")");
            }
            catch (Exception ex)
            {
                // ログ出力
                // 例外発生
                // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.Preview_button_Click", 
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + "(" + ex.Message +")");
               // HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.Preview_button_Click", "catch exception( " + ex.Message + ")");
            }
        }
// end of 印刷機能追加



        /// <summary><para>method outline:</para>
        /// <para>ファイルダイアログの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string = SetOpenFileDialog( csOfd )：引数にOpenFileDialogのインスタンスを入れる</para>
        /// </example>
        /// <param name="csOfd">OepnFileDialog</param>
        /// <returns>string：ファイルアドレス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string SetOpenFileDialog(OpenFileDialog csOfd)
        {
            //はじめのファイル名を指定する
            //はじめに「ファイル名」で表示される文字列を指定する
            csOfd.FileName = "";
            //はじめに表示されるフォルダを指定する
            //指定しない（空の文字列）の時は、現在のディレクトリが表示される
            csOfd.InitialDirectory = "";//@"C:\Program Files\CommonMP\Execute\temp";
            //[ファイルの種類]に表示される選択肢を指定する
            //指定しないとすべてのファイルが表示される
            csOfd.Filter =
                Properties.HysDotNetViewerResources.FILE_DLG_FILTER_CSV;//"csvファイル(*.csv)|*.csv";
            //[ファイルの種類]ではじめに
            //「すべてのファイル」が選択されているようにする
            csOfd.FilterIndex = 1;
            //タイトルを設定する
            csOfd.Title = Properties.HysDotNetViewerResources.FILE_DLG_TITLE_OPEN_FILE;//"開くファイルを選択してください";
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            csOfd.RestoreDirectory = true;
            //存在しないファイルの名前が指定されたとき警告を表示する
            csOfd.CheckFileExists = true;
            //存在しないパスが指定されたとき警告を表示する
            csOfd.CheckPathExists = true;

            //ダイアログを表示する
            if (csOfd.ShowDialog() == DialogResult.OK)
            {
                //OKボタンがクリックされたとき
                //選択されたファイル名を表示する
                 return csOfd.FileName;
            }
            else
            {
                //キャンセル等された場合はなにもしない
                return null;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>左軸ファイル選択ダイアログ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_Open_File_Dialog_button_Click( sender, e )：（ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left_Axis_Open_File_Dialog_button_Click(object sender, EventArgs e)
        {
            //OpenFileDialogクラスのインスタンスを作成
            OpenFileDialog csOfd = new OpenFileDialog();
            string sFileName = SetOpenFileDialog(csOfd);
            if (sFileName != null)
            {
                //最大読み込みファイル数と比較
                if (m_LeftAxisReadDataNum == MAXFILENUM)
                {
                    //MessageBox.Show("読み込み可能ファイル数を超えています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_READ_FILES"));
                    return;
                }
                else
                {
                    m_sLAFileName[m_LeftAxisReadDataNum] = sFileName;
                }
            }
            else
            {
                //キャンセル等された場合はなにもしない
                return;
            }


            //今までの読み込んだファイルと比較
            for (int i_Cnt = 0; i_Cnt < m_LeftAxisReadDataNum; i_Cnt++)
            {
                if (m_sLAFileName[i_Cnt] == sFileName)
                {
                    m_sLAFileName[m_LeftAxisReadDataNum] = "";
                    //MessageBox.Show("すでに同じファイルが読み込まれています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERRLAP_READ_FILE"));
                    return;
                }
            }
            

            //左軸データ追加カウント（判定を通った時点）
            m_LeftAxisReadDataNum++;
            //左軸データ追加のためのインスタンス生成
            m_csLeftAxisFileData[m_LeftAxisReadDataNum - 1] = new HySCSVFileDim1Data();//new HySCSVFileData(HySCSVFileData.DATA_KIND.TIME_SERIES_DATA, 1);
            m_csLeftAxisFileHeader[m_LeftAxisReadDataNum - 1] = new HySCSVFileDim1Data();

            //ファイルアドレスをHySFile型に
            HySFile csFile = new HySFile(csOfd.FileName);//
            //ファイル名をHySString型に
            HySString csHySStiring = new HySString(csOfd.FileName);
            //HySCSVFileDim1消さないように！
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            //ファイルの読み出しとレコード数の保存
            m_iLAFileRecordNum[m_LeftAxisReadDataNum - 1] = (int)m_csLeftAxisFileData[m_LeftAxisReadDataNum - 1].ReadCSVFile(csFile);
            //ファイルのクローズ処理
            csFile.Close();
            //CommonMPの1次元配列時系列のフォーマットでない場合は終了
            if (m_iLAFileRecordNum[m_LeftAxisReadDataNum - 1] == -1)
            {
                //データが読み込めなかったため読み込みデータ数を一つ少なくする
                m_LeftAxisReadDataNum--;
                m_sLAFileName[m_LeftAxisReadDataNum] = "";
                //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                return;
            }
            //読み込んだファイルのレコード数が指定の範囲を超えている
            if(m_iLAFileRecordNum[m_LeftAxisReadDataNum - 1] > m_iMaxRecord){
                //データが読み込めなかったため読み込みデータ数を一つ少なくする
                m_LeftAxisReadDataNum--;
                m_sLAFileName[m_LeftAxisReadDataNum] = "";
                //MessageBox.Show("開いたファイルのレコード数が多すぎます");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_RECODE_SIZE"));
                return;
            }



            //ヘッダーを読み込むための準備
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            m_csLeftAxisFileData[m_LeftAxisReadDataNum - 1].HeadInfRead(csFile);
            csFile.Close();



            //データ格納・戻り値はデータ数
            long i_lNum = 0;
            m_csLeftAxisFileData[m_LeftAxisReadDataNum - 1].GetDimention(ref i_lNum);

            //ヘッダ設定(Accessクラス)
            int i_Num = (int)i_lNum;
            m_csLeftAxisAccess.SetDataGridViewHeader(Left_Axis_DataGridView, i_Num);
            //1行追加
            Left_Axis_DataGridView.Rows.Add(1);
            //最大データ数設定
            m_csLeftAxisAccess.SetMaxDataNum(i_Num);//Accessクラス
            //データ設定(Accessクラス)
            m_csLeftAxisAccess.DataGridViewNameInput(Left_Axis_DataGridView, 
                m_csLeftAxisFileData[m_LeftAxisReadDataNum - 1], m_sLAFileName, i_Num, m_LeftAxisReadDataNum);
            //使わないCheckBoxをリードオンリーにする
            m_csLeftAxisAccess.CheckBoxReadOnly(Left_Axis_DataGridView);
            //テキストボックスにアドレスを入れる
            Left_Axis_textBox.Text = sFileName;
        }


        /// <summary><para>method outline:</para>
        /// <para>左軸表示ファイル解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_Clear_button_Click(sender, e)：（左軸解除ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>左軸の選択ファイルを一行消す</para>
        /// </remarks>
        private void Left_Axis_Clear_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Left_Axis_DataGridView.CurrentCell != null && Left_Axis_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                int iDgvRowIndex = Left_Axis_DataGridView.CurrentCell.RowIndex;

                //チェックが外れたところをLegendListからはずす
                for (int i_Cnt = 0; i_Cnt < Left_Axis_DataGridView.Columns.Count; i_Cnt++)
                {
                    legendList1.DelList(("LA" + i_Cnt.ToString()), m_sLAFileName[iDgvRowIndex]);
                }
                //ファイルを解除
                m_csLeftAxisAccess.ClearCsvFile(m_csLeftAxisFileData, iDgvRowIndex);
                //ファイルネームを一つ削除
                m_csLeftAxisAccess.ClearFileName(m_sLAFileName, iDgvRowIndex);
                //ファイルレコード
                m_csLeftAxisAccess.ClearFileRecord(m_iLAFileRecordNum, iDgvRowIndex);
                //チェック箇所の取得とチェック数
                m_iLACheckNum = m_csLeftAxisAccess.GetCheckPlace(Left_Axis_DataGridView, ref m_iLAIndexRow, ref m_iLAIndexColumn);
                

                //1行消去
                m_csLeftAxisAccess.RemoveRow(Left_Axis_DataGridView, iDgvRowIndex);

                m_LeftAxisReadDataNum--;

                //列を消去
                m_csLeftAxisAccess.RemoveColumns(Left_Axis_DataGridView, m_csLeftAxisFileData, m_LeftAxisReadDataNum);


                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>左軸ファイルの全消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_All_Erase_button_Click(sender, e)：（左軸の全消去ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left_Axis_All_Erase_button_Click(object sender, EventArgs e)
        {
            //チェックが外れたところをLegendListからはずす
            for (int i_Cnt1 = 0; i_Cnt1 < Left_Axis_DataGridView.Rows.Count; i_Cnt1++)
            {
                //インデックスを初期化
                m_iLAIndexColumn[i_Cnt1] = -1;
                m_iLAIndexRow[i_Cnt1] = -1;

                for (int i_Cnt2 = 0; i_Cnt2 < Left_Axis_DataGridView.Columns.Count; i_Cnt2++)
                {
                    legendList1.DelList(("LA" + i_Cnt2.ToString()), m_sLAFileName[i_Cnt1]);
                }
            }

            //ファイルを解除＋行の消去
            for (int i_Cnt = m_LeftAxisReadDataNum - 1; i_Cnt >= 0; i_Cnt--)
            {
                m_csLeftAxisAccess.ClearCsvFile(m_csLeftAxisFileData, i_Cnt);
                m_csLeftAxisAccess.RemoveRow(Left_Axis_DataGridView, i_Cnt);
                //ファイルネームを一つ削除
                m_csLeftAxisAccess.ClearFileName(m_sLAFileName, i_Cnt);
                //ファイルレコード
                m_csLeftAxisAccess.ClearFileRecord(m_iLAFileRecordNum, i_Cnt);
            }
            
            //列の消去
            m_csLeftAxisAccess.RemoveColumns(Left_Axis_DataGridView, m_csLeftAxisFileData, 0);

            //読み込んだファイル・データ数を0にする
            m_LeftAxisReadDataNum = 0;
            m_iLACheckNum = m_csLeftAxisAccess.InitCheckNum();


            //再描画
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>左軸ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Left_Axis_Reflesh_button_Click(sender, e)：（左軸の再読込ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left_Axis_Reflesh_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Left_Axis_DataGridView.CurrentCell != null && Left_Axis_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                //一時行数を保存
                long l_LAFileRecordNum = 0;
                m_csLeftAxisFileData[Left_Axis_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_LAFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sLAFileName[Left_Axis_DataGridView.CurrentCell.RowIndex]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iLAFileRecordNum[Left_Axis_DataGridView.CurrentCell.RowIndex] = (int)m_csLeftAxisFileData[Left_Axis_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                csFile.Close();
                long l_Cnt = 0;
                m_csLeftAxisFileData[Left_Axis_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iLAFileRecordNum[Left_Axis_DataGridView.CurrentCell.RowIndex] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csLeftAxisFileData[Left_Axis_DataGridView.CurrentCell.RowIndex].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csLeftAxisAccess.SetDataGridViewHeader(Left_Axis_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csLeftAxisAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csLeftAxisAccess.DataGridViewNameInput(Left_Axis_DataGridView, m_csLeftAxisFileData[Left_Axis_DataGridView.CurrentCell.RowIndex],
                        m_sLAFileName, (int)l_Cnt, Left_Axis_DataGridView.CurrentCell.RowIndex + 1);


                    //データ個数が減った時
                    if (l_LAFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sLAFileName[Left_Axis_DataGridView.CurrentCell.RowIndex];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iLACheckNum; i_Cnt1++)
                        {
                            if (m_iLAIndexRow[i_Cnt1] == Left_Axis_DataGridView.CurrentCell.RowIndex &&
                                m_iLAIndexColumn[i_Cnt1] >= (int)l_Cnt)
                            {
                                string sGroup = "LA" + m_iLAIndexColumn[i_Cnt1].ToString();
                                m_iLACheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iLACheckNum; i_Cnt2++)
                                {
                                    m_iLAIndexRow[i_Cnt2] = m_iLAIndexRow[i_Cnt2 + 1];
                                    m_iLAIndexColumn[i_Cnt2] = m_iLAIndexColumn[i_Cnt2 + 1];
                                }
                                i_Cnt1--;
                            }
                        }
                    }
                    m_csLeftAxisAccess.RemoveColumns(Left_Axis_DataGridView, m_csLeftAxisFileData, m_LeftAxisReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>左軸データグリッドビュークリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_DataGridView_CellContentClick(sender, e)：（左軸のデータグリッドビューのセルをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left_Axis_DataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {


            int i_DataNumChecker = m_iLACheckNum;
            Left_Axis_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }
            try
            {
                if (Left_Axis_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {

                    //チェックボックスの数チェック
                    m_iLACheckNum = m_csLeftAxisAccess.GetCheckPlace(Left_Axis_DataGridView, ref m_iLAIndexRow, ref m_iLAIndexColumn);

                    //チェックボックスの数が変化した場合
                    if (m_iLACheckNum != i_DataNumChecker)
                    {
                        //選択ファイルを凡例一覧に追加
                        string sGroup = "LA" + (Left_Axis_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                        string sDataName = Left_Axis_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                        string sFileName = m_sLAFileName[e.RowIndex]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                        if ((bool)Left_Axis_DataGridView[e.ColumnIndex, e.RowIndex].Value == true)
                        {   //選択されている場合、凡例に追加
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                        }
                        else
                        {   //選択されていない場合、凡例から削除
                            legendList1.DelList(sGroup, sFileName);
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }

                }
            }
            catch
            {
                Left_Axis_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iLACheckNum = m_csLeftAxisAccess.GetCheckPlace(Left_Axis_DataGridView, ref m_iLAIndexRow, ref m_iLAIndexColumn);
                Left_Axis_DataGridView[0, e.RowIndex].Selected = true;
                Left_Axis_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                legendList1.DelList("LA" + (e.ColumnIndex / 2).ToString(), m_sLAFileName[e.RowIndex]);
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>左軸データグリッドビューダブルクリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_DataGridView_CellContentDoubleClick(sender, e)：（左軸のデータグリッドビューのセルをダブルクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left_Axis_DataGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            int i_DataNumChecker = m_iLACheckNum;
            Left_Axis_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }
            try
            {
                if (Left_Axis_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {

                    //チェックボックスの数チェック
                    m_iLACheckNum = m_csLeftAxisAccess.GetCheckPlace(Left_Axis_DataGridView, ref m_iLAIndexRow, ref m_iLAIndexColumn);

                    //チェックボックスの数が変化した場合
                    if (m_iLACheckNum != i_DataNumChecker)
                    {
                        //選択ファイルを凡例一覧に追加
                        string sGroup = "LA" + (Left_Axis_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                        string sDataName = Left_Axis_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                        string sFileName = m_sLAFileName[e.RowIndex]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                        if ((bool)Left_Axis_DataGridView[e.ColumnIndex, e.RowIndex].Value == true)
                        {   //選択されている場合、凡例に追加
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                        }
                        else
                        {   //選択されていない場合、凡例から削除
                            legendList1.DelList(sGroup, sFileName);
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }
                }
            }
            catch
            {
                Left_Axis_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iLACheckNum = m_csLeftAxisAccess.GetCheckPlace(Left_Axis_DataGridView, ref m_iLAIndexRow, ref m_iLAIndexColumn);
                Left_Axis_DataGridView[0, e.RowIndex].Selected = true;
                Left_Axis_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                legendList1.DelList("LA" + (e.ColumnIndex / 2).ToString(), m_sLAFileName[e.RowIndex]);
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折）ファイル選択ダイアログ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Line_Open_File_Dialog_button_Click( sender, e )：（ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_Open_File_Dialog_button_Click(object sender, EventArgs e)
        {
            //OpenFileDialogクラスのインスタンスを作成
            OpenFileDialog csOfd = new OpenFileDialog();
            string sFileName = SetOpenFileDialog(csOfd);

            if (sFileName != null)
            {
                //最大読み込みファイル数と比較
                if (m_RightAxisLineReadDataNum == MAXFILENUM)
                {
                    //MessageBox.Show("読み込み可能ファイル数を超えています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_READ_FILES"));
                    return;
                }
                else
                {
                    m_sRALineFileName[m_RightAxisLineReadDataNum] = sFileName;
                }
            }
            else
            {
                //キャンセル等された場合はなにもしない
                return;
            }

            //今までの読み込んだファイルと比較
            for (int i_Cnt = 0; i_Cnt < m_RightAxisLineReadDataNum; i_Cnt++)
            {
                if (m_sRALineFileName[i_Cnt] == csOfd.FileName)
                {
                    m_sRALineFileName[m_RightAxisLineReadDataNum] = "";
                    //MessageBox.Show("すでに同じファイルが読み込まれています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERRLAP_READ_FILE"));
                    return;
                }
            }
            

            //左軸データ追加カウント（判定を通った時点）
            m_RightAxisLineReadDataNum++;
            //左軸データ追加のためのインスタンス生成
            m_csRightAxisLineFileData[m_RightAxisLineReadDataNum - 1] = new HySCSVFileDim1Data();
            m_csRightAxisLineFileHeader[m_RightAxisLineReadDataNum - 1] = new HySCSVFileDim1Data();

            //ファイルアドレスをHySFile型に
            HySFile csFile = new HySFile(csOfd.FileName);//
            //ファイル名をHySString型に
            HySString csHySStiring = new HySString(csOfd.FileName);
            //HySCSVFileDim1消さないように！
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            //ファイルの読み出しとレコード数の保存
            m_iRALineFileRecordNum[m_RightAxisLineReadDataNum - 1] = (int)m_csRightAxisLineFileData[m_RightAxisLineReadDataNum - 1].ReadCSVFile(csFile);
            //ファイルのクローズ処理
            csFile.Close();
            //CommonMPの1次元配列時系列のフォーマットでない場合は終了
            if (m_iRALineFileRecordNum[m_RightAxisLineReadDataNum - 1] == -1)
            {
                m_RightAxisLineReadDataNum--;
                m_sRALineFileName[m_RightAxisLineReadDataNum] = "";
                //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                return;
            }
            //読み込んだファイルのレコード数が指定の範囲を超えている
            if (m_iRALineFileRecordNum[m_RightAxisLineReadDataNum - 1] > m_iMaxRecord)
            {
                //データが読み込めなかったため読み込みデータ数を一つ少なくする
                m_RightAxisLineReadDataNum--;
                m_sRALineFileName[m_RightAxisLineReadDataNum] = "";
                //MessageBox.Show("開いたファイルのレコード数が多すぎます");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_RECODE_SIZE"));
                return;
            }


            //ヘッダーを読み込むための準備
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            m_csRightAxisLineFileData[m_RightAxisLineReadDataNum - 1].HeadInfRead(csFile);
            csFile.Close();

            //データ格納・戻り値はデータ数//(DataStoreクラス)
            long i_lNum = 0;
            m_csRightAxisLineFileData[m_RightAxisLineReadDataNum - 1].GetDimention(ref i_lNum);

            //ヘッダ設定(Accessクラス)
            int i_Num = (int)i_lNum;
            m_csRightAxisLineAccess.SetDataGridViewHeader(Right_Axis_Line_DataGridView, i_Num);
            //1行追加
            Right_Axis_Line_DataGridView.Rows.Add(1);
            //最大データ数設定
            m_csRightAxisLineAccess.SetMaxDataNum(i_Num);//Accessクラス
            //データ設定(Accessクラス)
            m_csRightAxisLineAccess.DataGridViewNameInput(Right_Axis_Line_DataGridView,
                m_csRightAxisLineFileData[m_RightAxisLineReadDataNum - 1], m_sRALineFileName, i_Num, m_RightAxisLineReadDataNum);
            //使わないCheckBoxをリードオンリーにする
            m_csRightAxisLineAccess.CheckBoxReadOnly(Right_Axis_Line_DataGridView);
            //テキストボックスにアドレスを書く
            Right_Axis_Line_textBox.Text = sFileName;
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折）データグリッドビュークリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_DataGridView_CellContentClick(sender, e)：（右軸（折）のデータグリッドビューのセルをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_DataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            int i_DataNumChecker = m_iRALineCheckNum;
            Right_Axis_Line_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }
            try
            {
                if (Right_Axis_Line_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {

                    //チェックボックスの数チェック
                    m_iRALineCheckNum = m_csRightAxisLineAccess.GetCheckPlace(Right_Axis_Line_DataGridView, ref m_iRALineIndexRow, ref m_iRALineIndexColumn);

                    //チェックボックスの数が変化した場合
                    if (m_iRALineCheckNum != i_DataNumChecker)
                    {
                        //選択ファイルを凡例一覧に追加
                        string sGroup = "RL" + (Right_Axis_Line_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                        string sDataName = Right_Axis_Line_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                        string sFileName = m_sRALineFileName[e.RowIndex]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                        if ((bool)Right_Axis_Line_DataGridView[e.ColumnIndex, e.RowIndex].Value == true)
                        {   //選択されている場合、凡例に追加
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                        }
                        else
                        {   //選択されていない場合、凡例から削除
                            legendList1.DelList(sGroup, sFileName);
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }
                }
            }
            catch
            {
                Right_Axis_Line_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iRALineCheckNum = m_csRightAxisLineAccess.GetCheckPlace(Right_Axis_Line_DataGridView, ref m_iRALineIndexRow, ref m_iRALineIndexColumn);
                Right_Axis_Line_DataGridView[0, e.RowIndex].Selected = true;
                Right_Axis_Line_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                legendList1.DelList("RL" + (e.ColumnIndex / 2).ToString(), m_sRALineFileName[e.RowIndex]);
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }

        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折）データグリッドビューダブルクリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Left_Axis_DataGridView_CellContentClick(sender, e)：（右軸（折）のデータグリッドビューのセルをダブルクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_DataGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            int i_DataNumChecker = m_iRALineCheckNum;
            Right_Axis_Line_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }
            try
            {
                if (Right_Axis_Line_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {

                    //チェックボックスの数チェック
                    m_iRALineCheckNum = m_csRightAxisLineAccess.GetCheckPlace(Right_Axis_Line_DataGridView, ref m_iRALineIndexRow, ref m_iRALineIndexColumn);

                    //チェックボックスの数が変化した場合
                    if (m_iRALineCheckNum != i_DataNumChecker)
                    {
                        //選択ファイルを凡例一覧に追加
                        string sGroup = "RL" + (Right_Axis_Line_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                        string sDataName = Right_Axis_Line_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                        string sFileName = m_sRALineFileName[e.RowIndex]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                        if ((bool)Right_Axis_Line_DataGridView[e.ColumnIndex, e.RowIndex].Value == true)
                        {   //選択されている場合、凡例に追加
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                        }
                        else
                        {   //選択されていない場合、凡例から削除
                            legendList1.DelList(sGroup, sFileName);
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }
                }
            }
            catch
            {
                Right_Axis_Line_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iRALineCheckNum = m_csRightAxisLineAccess.GetCheckPlace(Right_Axis_Line_DataGridView, ref m_iRALineIndexRow, ref m_iRALineIndexColumn);
                Right_Axis_Line_DataGridView[0, e.RowIndex].Selected = true;
                Right_Axis_Line_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                legendList1.DelList("RL" + (e.ColumnIndex / 2).ToString(), m_sRALineFileName[e.RowIndex]);
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折れ線）表示ファイル解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Line_Clear_button_Click(sender, e)：（右軸（折れ線）解除ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_Clear_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Right_Axis_Line_DataGridView.CurrentCell != null && Right_Axis_Line_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                int iDgvRowIndex = Right_Axis_Line_DataGridView.CurrentCell.RowIndex;

                //チェックが外れたところをLegendListからはずす
                for (int i_Cnt = 0; i_Cnt < Right_Axis_Line_DataGridView.Columns.Count; i_Cnt++)
                {
                    legendList1.DelList(("RL" +i_Cnt.ToString()), m_sRALineFileName[iDgvRowIndex]);
                }
                //ファイルを解除
                m_csRightAxisLineAccess.ClearCsvFile(m_csRightAxisLineFileData, iDgvRowIndex);
                //ファイルネームを一つ削除
                m_csRightAxisLineAccess.ClearFileName(m_sRALineFileName, iDgvRowIndex);
                //ファイルレコード
                m_csRightAxisLineAccess.ClearFileRecord(m_iRALineFileRecordNum, iDgvRowIndex);
                //チェック箇所の取得とチェック数
                m_iRALineCheckNum = m_csRightAxisLineAccess.GetCheckPlace(Right_Axis_Line_DataGridView, ref m_iRALineIndexRow, ref m_iRALineIndexColumn);


                //1行消去
                m_csRightAxisLineAccess.RemoveRow(Right_Axis_Line_DataGridView, iDgvRowIndex);
                m_RightAxisLineReadDataNum--;
                //列を消去
                m_csRightAxisLineAccess.RemoveColumns(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData, m_RightAxisLineReadDataNum);


                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折れ線）ファイルの全消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Line_All_Erase_button_Click(sender, e)：（右軸（折）の全消去ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_All_Erase_button_Click(object sender, EventArgs e)
        {
            //チェックが外れたところをLegendListからはずす
            for (int i_Cnt1 = 0; i_Cnt1 < Right_Axis_Line_DataGridView.Rows.Count; i_Cnt1++)
            {
                //インデックスを初期化
                m_iRALineIndexColumn[i_Cnt1] = -1;
                m_iRALineIndexRow[i_Cnt1] = -1;

                for (int i_Cnt2 = 0; i_Cnt2 < Right_Axis_Line_DataGridView.Columns.Count; i_Cnt2++)
                {
                    legendList1.DelList(("RL" + i_Cnt2.ToString()), m_sRALineFileName[i_Cnt1]);
                }
            }

            //ファイルを解除＋行の消去
            for (int i_Cnt = m_RightAxisLineReadDataNum - 1; i_Cnt >= 0; i_Cnt--)
            {
                m_csRightAxisLineAccess.ClearCsvFile(m_csRightAxisLineFileData, i_Cnt);
                m_csRightAxisLineAccess.RemoveRow(Right_Axis_Line_DataGridView, i_Cnt);
                //ファイルネームを一つ削除
                m_csRightAxisLineAccess.ClearFileName(m_sRALineFileName, i_Cnt);
                //ファイルレコード
                m_csRightAxisLineAccess.ClearFileRecord(m_iRALineFileRecordNum, i_Cnt);
            }

            //列の消去
            m_csRightAxisLineAccess.RemoveColumns(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData, 0);

            //読み込んだファイル・データ数を0にする
            m_RightAxisLineReadDataNum = 0;
            m_iRALineCheckNum = m_csRightAxisLineAccess.InitCheckNum();


            //再描画
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（折れ線）ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Right_Axis_Line_Reflesh_button_Click(sender, e)：（右軸（折）の再読込ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Line_Reflesh_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Right_Axis_Line_DataGridView.CurrentCell != null && Right_Axis_Line_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                //一時行数を保存
                long l_RALineFileRecordNum = 0;
                m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_RALineFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sRALineFileName[Right_Axis_Line_DataGridView.CurrentCell.RowIndex]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iRALineFileRecordNum[Right_Axis_Line_DataGridView.CurrentCell.RowIndex] = (int)m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                //m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                csFile.Close();

                long l_Cnt = 0;
                m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iRALineFileRecordNum[Right_Axis_Line_DataGridView.CurrentCell.RowIndex] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csRightAxisLineAccess.SetDataGridViewHeader(Right_Axis_Line_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csRightAxisLineAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csRightAxisLineAccess.DataGridViewNameInput(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex],
                        m_sRALineFileName, (int)l_Cnt, Right_Axis_Line_DataGridView.CurrentCell.RowIndex + 1);

                    //データ個数が減った時
                    if (l_RALineFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sRALineFileName[Right_Axis_Line_DataGridView.CurrentCell.RowIndex];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iRALineCheckNum; i_Cnt1++)
                        {
                            if (m_iRALineIndexRow[i_Cnt1] == Right_Axis_Line_DataGridView.CurrentCell.RowIndex &&
                                m_iRALineIndexColumn[i_Cnt1] >= (int)l_Cnt)
                            {
                                string sGroup = "RL" + m_iRALineIndexColumn[i_Cnt1].ToString();
                                m_iRALineCheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iRALineCheckNum; i_Cnt2++)
                                {
                                    m_iRALineIndexRow[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                                    m_iRALineIndexColumn[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                }
                                i_Cnt1--;
                            }
                        }
                    }
                    m_csRightAxisLineAccess.RemoveColumns(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData, m_RightAxisLineReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）ファイル選択ダイアログ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Bar_Open_File_Dialog_button_Click( sender, e )：（ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_Open_File_Dialog_button_Click(object sender, EventArgs e)
        {
            //OpenFileDialogクラスのインスタンスを作成
            OpenFileDialog csOfd = new OpenFileDialog();
            string sFileName = SetOpenFileDialog(csOfd);

            if (sFileName != null)
            {
                //最大読み込みファイル数と比較
                if (m_RightAxisBarReadDataNum == MAXFILENUM)
                {
                    //m_RightAxisBarReadDataNum--;
                    //m_sRABarFileName[m_RightAxisBarReadDataNum] = "";
                    //MessageBox.Show("読み込み可能ファイル数を超えています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_READ_FILES"));
                    return;
                }
                else
                {
                    m_sRABarFileName[m_RightAxisBarReadDataNum] = sFileName;
                }
            }
            else
            {
                //キャンセル等された場合はなにもしない
                return;
            }

            //今までの読み込んだファイルと比較
            for (int i_Cnt = 0; i_Cnt < m_RightAxisBarReadDataNum; i_Cnt++)
            {
                if (m_sRABarFileName[i_Cnt] == csOfd.FileName)
                {
                    m_sRABarFileName[m_RightAxisBarReadDataNum] = "";
                    //MessageBox.Show("すでに同じファイルが読み込まれています");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERRLAP_READ_FILE"));
                    return;
                }
            }


            //右軸（棒）データ追加カウント（判定を通った時点）
            m_RightAxisBarReadDataNum++;
            //右軸（棒）データ追加のためのインスタンス生成
            m_csRightAxisBarFileData[m_RightAxisBarReadDataNum - 1] = new HySCSVFileDim1Data();
            m_csRightAxisBarFileHeader[m_RightAxisBarReadDataNum - 1] = new HySCSVFileDim1Data();

            //ファイルアドレスをHySFile型に
            HySFile csFile = new HySFile(csOfd.FileName);//
            //ファイル名をHySString型に
            HySString csHySStiring = new HySString(csOfd.FileName);
            //HySCSVFileDim1消さないように！
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            //ファイルの読み出しとレコード数の保存
            m_iRABarFileRecordNum[m_RightAxisBarReadDataNum - 1] = (int)m_csRightAxisBarFileData[m_RightAxisBarReadDataNum - 1].ReadCSVFile(csFile);
            //ファイルのクローズ処理
            csFile.Close();
            //CommonMPの1次元配列時系列のフォーマットでない場合は終了
            if (m_iRABarFileRecordNum[m_RightAxisBarReadDataNum - 1] == -1)
            {
                m_RightAxisBarReadDataNum--;
                m_sRABarFileName[m_RightAxisBarReadDataNum] = "";
                //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                return;
            }
            //読み込んだファイルのレコード数が指定の範囲を超えている
            if (m_iRABarFileRecordNum[m_RightAxisBarReadDataNum - 1] > m_iMaxRecord)
            {
                //データが読み込めなかったため読み込みデータ数を一つ少なくする
                m_RightAxisBarReadDataNum--;
                m_sRABarFileName[m_RightAxisBarReadDataNum] = "";
                //MessageBox.Show("開いたファイルのレコード数が多すぎます");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVER_RECODE_SIZE"));
                return;
            }


            //ヘッダーを読み込むための準備
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            m_csRightAxisBarFileData[m_RightAxisBarReadDataNum - 1].HeadInfRead(csFile);
            csFile.Close();

            //データ格納・戻り値はデータ数//(DataStoreクラス)
            long i_lNum = 0;
            m_csRightAxisBarFileData[m_RightAxisBarReadDataNum - 1].GetDimention(ref i_lNum);

            //ヘッダ設定(Accessクラス)
            int i_Num = (int)i_lNum;
            m_csRightAxisBarAccess.SetDataGridViewHeader(Right_Axis_Bar_DataGridView, i_Num);
            //1行追加
            Right_Axis_Bar_DataGridView.Rows.Add(1);
            //最大データ数設定
            m_csRightAxisBarAccess.SetMaxDataNum(i_Num);//Accessクラス
            //データ設定(Accessクラス)
            m_csRightAxisBarAccess.DataGridViewNameInput(Right_Axis_Bar_DataGridView,
                m_csRightAxisBarFileData[m_RightAxisBarReadDataNum - 1], m_sRABarFileName, i_Num, m_RightAxisBarReadDataNum);
            //使わないCheckBoxをリードオンリーにする
            m_csRightAxisBarAccess.CheckBoxReadOnly(Right_Axis_Bar_DataGridView);
            //テキストボックスにアドレスを書く
            Right_Axis_Bar_textBox.Text = sFileName;
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）データグリッドビュークリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Bar_Data_GridView_CellContentClick(sender, e)：（右軸（棒）のデータグリッドビューのセルをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_DataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            int i_DataNumChecker = m_iRABarCheckNum;//データチェッカーは0または1になる
            int iRABarIndexRow = m_iRABarIndexRow;
            int iRABarIndexColumn = m_iRABarIndexColumn;
            string sGroup = "";
            string sFileName = "";
            string sDataName = "";

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }

            Right_Axis_Bar_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
            try
            {
                if (Right_Axis_Bar_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {
                    if (Right_Axis_Bar_DataGridView[e.ColumnIndex, e.RowIndex].ReadOnly != true)
                    {
                        //チェックボックスの数チェック
                        m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);

                        //チェックの数が0
                        if (m_iRABarCheckNum == 0)
                        {
                            //前回のファイルを凡例一覧から削除
                            sGroup = "RB" + iRABarIndexColumn.ToString();
                            sDataName = Right_Axis_Bar_DataGridView[2 * (iRABarIndexColumn + 1), iRABarIndexRow].Value.ToString();
                            sFileName = m_sRABarFileName[iRABarIndexRow]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                            legendList1.DelList(sGroup, sFileName);
                        }
                        //チェックの数が1
                        else if (m_iRABarCheckNum == 1)
                        {
                            //選択ファイルを凡例一覧に追加
                            sGroup = "RB" + (Right_Axis_Bar_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                            sDataName = Right_Axis_Bar_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                            sFileName = m_sRABarFileName[e.RowIndex];
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                            if (i_DataNumChecker == 0)
                            {
                                //削除はなし
                            }
                            else if (i_DataNumChecker == 1)
                            {
                                sGroup = "RB" + iRABarIndexColumn.ToString();
                                sDataName = Right_Axis_Bar_DataGridView[2 * (iRABarIndexColumn + 1), iRABarIndexRow].Value.ToString();
                                sFileName = m_sRABarFileName[iRABarIndexRow];
                                legendList1.DelList(sGroup, sFileName);
                            }
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }
                }
            }
            catch
            {
                Right_Axis_Bar_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);
                legendList1.DelList("RB" + (e.ColumnIndex / 2).ToString(), m_sRABarFileName[e.RowIndex]);
                if (iRABarIndexColumn != -1)
                {
                    Right_Axis_Bar_DataGridView[2 * iRABarIndexColumn + 1, iRABarIndexRow].Value = true;
                    Right_Axis_Bar_DataGridView[2 * iRABarIndexColumn + 1, iRABarIndexRow].Selected = true;
                    m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);
                    Right_Axis_Bar_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                    legendList1.AddList("RB" + iRABarIndexColumn.ToString(), m_sRABarFileName[iRABarIndexRow], sDataName);
                }
                else
                {
                    Right_Axis_Bar_DataGridView[0, e.RowIndex].Selected = true;
                }
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）データグリッドビューダブルクリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Bar_Data_GridView_CellContentDoubleClick(sender, e)：（右軸（棒）のデータグリッドビューのセルをダブルクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_DataGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            int i_DataNumChecker = m_iRABarCheckNum;//データチェッカーは0または1になる
            int iRABarIndexRow = m_iRABarIndexRow;
            int iRABarIndexColumn = m_iRABarIndexColumn;
            string sGroup = "";
            string sFileName = "";
            string sDataName = "";

            if (e.RowIndex < 0)
            {//ヘッダーを除く
                return;
            }

            Right_Axis_Bar_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
            try
            {
                if (Right_Axis_Bar_DataGridView.Columns[e.ColumnIndex] is DataGridViewCheckBoxColumn)//オブジェクトがチェックボックスコラムの場合
                {
                    if (Right_Axis_Bar_DataGridView[e.ColumnIndex, e.RowIndex].ReadOnly != true)
                    {
                        //チェックボックスの数チェック
                        m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);

                        //チェックの数が0
                        if (m_iRABarCheckNum == 0)
                        {
                            //前回のファイルを凡例一覧から削除
                            sGroup = "RB" + iRABarIndexColumn.ToString();
                            sDataName = Right_Axis_Bar_DataGridView[2 * (iRABarIndexColumn + 1), iRABarIndexRow].Value.ToString();
                            sFileName = m_sRABarFileName[iRABarIndexRow]; //m_csLeftAxisFileData[e.RowIndex].GetFileName().ToString();
                            legendList1.DelList(sGroup, sFileName);

                        }
                        //チェックの数が1
                        else if (m_iRABarCheckNum == 1)
                        {
                            //選択ファイルを凡例一覧に追加
                            sGroup = "RB" + (Right_Axis_Bar_DataGridView.CurrentCell.ColumnIndex / 2).ToString();
                            sDataName = Right_Axis_Bar_DataGridView[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                            sFileName = m_sRABarFileName[e.RowIndex];
                            legendList1.ClickEvent = true;
                            legendList1.AddList(sGroup, sFileName, sDataName);
                            if (i_DataNumChecker == 0)
                            {
                                //削除はなし
                            }
                            else if (i_DataNumChecker == 1)
                            {
                                sGroup = "RB" + iRABarIndexColumn.ToString();
                                sDataName = Right_Axis_Bar_DataGridView[2 * (iRABarIndexColumn + 1), iRABarIndexRow].Value.ToString();
                                sFileName = m_sRABarFileName[iRABarIndexRow];
                                legendList1.DelList(sGroup, sFileName);
                            }
                        }

                        //再描画
                        if (m_IsAutoFit == true)
                        {
                            _getTimeStampAll();
                        }
                        _redraw(
                            Convert.ToInt32(cmbHourStart.SelectedItem),
                            Convert.ToInt32(cmbMinuteStart.SelectedItem),
                            Convert.ToInt32(cmbHourEnd.SelectedItem),
                            Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                            );
                    }
                }
            }
            catch
            {
                Right_Axis_Bar_DataGridView[e.ColumnIndex, e.RowIndex].Value = false;
                m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);
                legendList1.DelList("RB" + (e.ColumnIndex / 2).ToString(), m_sRABarFileName[e.RowIndex]);
                if (iRABarIndexColumn != -1)
                {
                    Right_Axis_Bar_DataGridView[2 * iRABarIndexColumn + 1, iRABarIndexRow].Value = true;
                    Right_Axis_Bar_DataGridView[2 * iRABarIndexColumn + 1, iRABarIndexRow].Selected = true;
                    m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);
                    Right_Axis_Bar_DataGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                    legendList1.AddList("RB" + iRABarIndexColumn.ToString(), m_sRABarFileName[iRABarIndexRow], sDataName);
                }
                else
                {
                    Right_Axis_Bar_DataGridView[0, e.RowIndex].Selected = true;
                }
                //MessageBox.Show("読み込んだファイルが表示できる時間外です");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERTIME_DISPLAY"));
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）表示ファイル解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Bar_Clear_button_Click(sender, e)：（右軸（棒）解除ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_Clear_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Right_Axis_Bar_DataGridView.CurrentCell != null && Right_Axis_Bar_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                int iDgvRowIndex = Right_Axis_Bar_DataGridView.CurrentCell.RowIndex;

                //チェックが外れたところをLegendListからはずす
                for (int i_Cnt = 0; i_Cnt < Right_Axis_Bar_DataGridView.Columns.Count; i_Cnt++)
                {
                    legendList1.DelList(("RB" + i_Cnt.ToString()), m_sRABarFileName[iDgvRowIndex]);
                }
                //ファイルを解除
                m_csRightAxisBarAccess.ClearCsvFile(m_csRightAxisBarFileData, iDgvRowIndex);
                //ファイルネームを一つ削除
                m_csRightAxisBarAccess.ClearFileName(m_sRABarFileName, iDgvRowIndex);
                //ファイルレコード
                m_csRightAxisBarAccess.ClearFileRecord(m_iRABarFileRecordNum, iDgvRowIndex);
                //チェック箇所の取得とチェック数
                m_iRABarCheckNum = m_csRightAxisBarAccess.GetBarCheckPlace(Right_Axis_Bar_DataGridView, ref m_iRABarIndexRow, ref m_iRABarIndexColumn);


                //1行消去
                m_csRightAxisBarAccess.RemoveRow(Right_Axis_Bar_DataGridView, iDgvRowIndex);
                m_RightAxisBarReadDataNum--;
                //列を消去
                m_csRightAxisBarAccess.RemoveColumns(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData, m_RightAxisBarReadDataNum);


                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）ファイルの全消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Right_Axis_Bar_All_Erase_button_Click(sender, e)：（右軸（棒）の全消去ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_All_Erase_button_Click(object sender, EventArgs e)
        {
            //チェックが外れたところをLegendListからはずす
            for (int i_Cnt1 = 0; i_Cnt1 < Right_Axis_Bar_DataGridView.Rows.Count; i_Cnt1++)
            {
                //インデックスを初期化
                m_iRABarIndexColumn = -1;
                m_iRABarIndexRow = -1;

                for (int i_Cnt2 = 0; i_Cnt2 < Right_Axis_Bar_DataGridView.Columns.Count; i_Cnt2++)
                {
                    legendList1.DelList(("RB" + i_Cnt2.ToString()), m_sRABarFileName[i_Cnt1]);
                }
            }

            //ファイルを解除＋行の消去
            for (int i_Cnt = m_RightAxisBarReadDataNum - 1; i_Cnt >= 0; i_Cnt--)
            {
                m_csRightAxisBarAccess.ClearCsvFile(m_csRightAxisBarFileData, i_Cnt);
                m_csRightAxisBarAccess.RemoveRow(Right_Axis_Bar_DataGridView, i_Cnt);
                //ファイルネームを一つ削除
                m_csRightAxisBarAccess.ClearFileName(m_sRABarFileName, i_Cnt);
                //ファイルレコード
                m_csRightAxisBarAccess.ClearFileRecord(m_iRABarFileRecordNum, i_Cnt);
            }

            //列の消去
            m_csRightAxisBarAccess.RemoveColumns(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData, 0);

            //読み込んだファイル・データ数を0にする
            m_RightAxisBarReadDataNum = 0;
            m_iRABarCheckNum = m_csRightAxisBarAccess.InitCheckNum();


            //再描画
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }


        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Right_Axis_Line_Reflesh_button_Click(sender, e)：（右軸（棒）の再読込ボタンをクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right_Axis_Bar_Reflesh_button_Click(object sender, EventArgs e)
        {
            //ファイルのセルが選択されていることを確認
            if (Right_Axis_Bar_DataGridView.CurrentCell != null && Right_Axis_Bar_DataGridView.CurrentCell.ColumnIndex == 0)
            {
                //一時行数を保存
                long l_RABarFileRecordNum = 0;
                m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_RABarFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sRABarFileName[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iRABarFileRecordNum[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex] = (int)m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                //m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                csFile.Close();

                long l_Cnt = 0;
                m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iRABarFileRecordNum[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csRightAxisBarAccess.SetDataGridViewHeader(Right_Axis_Bar_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csRightAxisBarAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csRightAxisBarAccess.DataGridViewNameInput(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex],
                        m_sRABarFileName, (int)l_Cnt, Right_Axis_Bar_DataGridView.CurrentCell.RowIndex + 1);

                    //データ個数が減った時
                    if (l_RABarFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sRABarFileName[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iRABarCheckNum; i_Cnt1++)
                        {
                            if (m_iRABarIndexRow == Right_Axis_Bar_DataGridView.CurrentCell.RowIndex &&
                                m_iRABarIndexColumn >= (int)l_Cnt)
                            {
                                string sGroup = "RB" + m_iRABarIndexColumn.ToString();
                                m_iRABarCheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iRABarCheckNum; i_Cnt2++)
                                {
                                    m_iRABarIndexRow = -1;//[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                                    m_iRABarIndexColumn = -1;//[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                }
                                break;
                            }
                        }
                    }
                    m_csRightAxisBarAccess.RemoveColumns(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData, m_RightAxisBarReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>設定ファイルのセーブ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetGraphInformation()：（設定ファイル書き込み時に使用）</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int SetGraphInformation()
        {

            Color[] csCOLORLIST = new Color[m_iRALineCheckNum + m_iLACheckNum + m_iRABarCheckNum];
            string[] sID = new string[m_iRALineCheckNum + m_iLACheckNum + m_iRABarCheckNum];
            legendList1.GetColorList(csCOLORLIST);
            legendList1.GetIDList(sID);

            HySEvViewConservation csConvertion = new HySEvViewConservation();
            csConvertion.SetSaveFileName(HySDotNetLineGraphForm.g_sGrphSaveFileName);
            int ireturn = csConvertion.SetConversion(m_iLAIndexColumn, m_iLAIndexRow, m_iRALineIndexColumn, m_iRALineIndexRow,
                m_iRABarIndexColumn, m_iRABarIndexRow, m_sLAFileName, m_sRALineFileName, m_sRABarFileName, csCOLORLIST, sID,
                m_csDefine.g_WaterLevel_MaxY, m_csDefine.g_WaterLevel_MinY, m_csDefine.g_FlowMeter_MaxY,
                m_csDefine.g_FlowMeter_MinY, m_IsAutoFit, m_csDefine.g_bAutoStatus, m_csDefine.g_bAutoBounds,
                m_csDefine.g_sLeftLabel, m_csDefine.g_sRightlabel, dtpStart, dtpEnd, cmbHourStart, cmbHourEnd,
                cmbMinuteStart, cmbMinuteEnd, m_iLACheckNum, m_iRALineCheckNum, m_iRABarCheckNum);
            return ireturn;
        }


        /// <summary><para>method outline:</para>
        /// <para>設定ファイルのロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetGraphInformation()：設定ファイルのロードと設定</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetGraphInformation()
        {
            try
            {
                Color[] csCOLORLIST = null;
                string[] sID = null;
                int LACheckNum = 0;
                int RALineCheckNum = 0;
                int RABarCheckNum = 0;
                //チェック用
                bool[] bLAChecker = new bool[MAXDATANUM];
                bool[] bRALineChecker = new bool[MAXDATANUM];
                bool[] bRABarChecker = new bool[MAXDATANUM];
                //保存用
                string[] LAFileName;
                string[] RALineFileName;
                string[] RABarFileName;
                int[] LAIndexRow;
                int[] RALineIndexRow;
                int RABarIndexRow;

                HySEvViewConservation csConVertion = new HySEvViewConservation();
                csConVertion.SetSaveFileName(HySDotNetLineGraphForm.g_sGrphSaveFileName);
                csConVertion.GetConservation(ref m_iLAIndexColumn, ref m_iLAIndexRow, ref m_iRALineIndexColumn, ref m_iRALineIndexRow,
                    ref m_iRABarIndexColumn, ref m_iRABarIndexRow, ref m_sLAFileName, ref m_sRALineFileName, ref m_sRABarFileName,
                    ref csCOLORLIST, ref sID, ref m_csDefine.g_WaterLevel_MaxY, ref m_csDefine.g_WaterLevel_MinY,
                    ref m_csDefine.g_FlowMeter_MaxY, ref m_csDefine.g_FlowMeter_MinY, ref m_IsAutoFit, ref m_csDefine.g_bAutoStatus,
                    ref m_csDefine.g_bAutoBounds, ref m_csDefine.g_sLeftLabel, ref m_csDefine.g_sRightlabel,
                    ref dtpStart, ref dtpEnd, ref cmbHourStart, ref cmbHourEnd, ref cmbMinuteStart, ref cmbMinuteEnd, ref LACheckNum,
                    ref RALineCheckNum, ref RABarCheckNum);

                LeftAxisLabel.Text = m_csDefine.g_sLeftLabel;
                RightAxisLabel.Text = m_csDefine.g_sRightlabel;

                legendList1.SetColorList(csCOLORLIST);
                //保存
                LAFileName = (string[])m_sLAFileName.Clone();
                RALineFileName = (string[])m_sRALineFileName.Clone();
                RABarFileName = (string[])m_sRABarFileName.Clone();
                LAIndexRow = (int[])m_iLAIndexRow.Clone();
                RALineIndexRow = (int[])m_iRALineIndexRow.Clone();
                RABarIndexRow = m_iRABarIndexRow;

                //左軸ファイル追加
                for (int i_Cnt = 0; i_Cnt < m_sLAFileName.Length; i_Cnt++)
                {
                    if (m_sLAFileName[i_Cnt] != null)
                    {
                        i_Cnt = i_Cnt + SetFileReload(m_sLAFileName, ref m_LeftAxisReadDataNum, ref m_iLAFileRecordNum, ref m_csLeftAxisFileData,
                            ref m_csLeftAxisFileHeader, m_csLeftAxisAccess, Left_Axis_DataGridView, LACheckNum);
                    }
                    else
                    {
                        break;
                    }
                }

                //右軸（折れ線）ファイル追加
                for (int i_Cnt = 0; i_Cnt < m_sRALineFileName.Length; i_Cnt++)
                {
                    if (m_sRALineFileName[i_Cnt] != null)
                    {
                        i_Cnt = i_Cnt + SetFileReload(m_sRALineFileName, ref m_RightAxisLineReadDataNum, ref m_iRALineFileRecordNum, ref m_csRightAxisLineFileData,
                            ref m_csRightAxisLineFileHeader, m_csRightAxisLineAccess, Right_Axis_Line_DataGridView, RALineCheckNum);
                    }
                    else
                    {
                        break;
                    }
                }

                //右軸（棒）ファイル追加
                for (int i_Cnt = 0; i_Cnt < m_sRABarFileName.Length; i_Cnt++)
                {
                    if (m_sRABarFileName[i_Cnt] != null)
                    {
                        SetFileReload(m_sRABarFileName, ref m_RightAxisBarReadDataNum, ref m_iRABarFileRecordNum, ref m_csRightAxisBarFileData,
                            ref m_csRightAxisBarFileHeader, m_csRightAxisBarAccess, Right_Axis_Bar_DataGridView, RABarCheckNum);
                    }
                    else
                    {
                        break;
                    }
                }

                CheckCompare(LAFileName, m_sLAFileName, LAIndexRow, bLAChecker);
                CheckCompare(RALineFileName, m_sRALineFileName, RALineIndexRow, bRALineChecker);

                //データ選択の追加
                for (int i_Cnt = 0; i_Cnt < sID.Length; i_Cnt++)
                {
                    if (sID[i_Cnt] == "LA" && bLAChecker[m_iLACheckNum] == true)
                    {
                        SetCheckReload(m_sLAFileName[m_iLAIndexRow[m_iLACheckNum]], m_iLAIndexColumn[m_iLACheckNum],
                            m_iLAIndexRow[m_iLACheckNum], Left_Axis_DataGridView, sID[i_Cnt]);
                        m_iLACheckNum++;
                        m_csLeftAxisAccess.CheckNum = m_iLACheckNum;
                    }
                    else if (sID[i_Cnt] == "RL" && bRALineChecker[m_iRALineCheckNum])
                    {
                        SetCheckReload(m_sRALineFileName[m_iRALineIndexRow[m_iRALineCheckNum]], m_iRALineIndexColumn[m_iRALineCheckNum],
                            m_iRALineIndexRow[m_iRALineCheckNum], Right_Axis_Line_DataGridView, sID[i_Cnt]);
                        m_iRALineCheckNum++;
                        m_csRightAxisLineAccess.CheckNum = m_iRALineCheckNum;
                    }
                    else if (sID[i_Cnt] == "RB" && m_iRABarIndexRow != -1)
                    {
                        SetCheckReload(m_sRABarFileName[m_iRABarIndexRow], m_iRABarIndexColumn, m_iRABarIndexRow, Right_Axis_Bar_DataGridView, sID[i_Cnt]);
                        m_iRABarCheckNum++;
                        m_csRightAxisBarAccess.CheckNum = m_iRABarCheckNum;
                    }
                    else
                    {
                        //Console.WriteLine("不明なデータが含まれています");
                    }
                }

                if (m_IsAutoFit == true)
                {
                    X_Auto_radioButton.Select();
                }
                else
                {
                    X_Manual_radioButton.Select();
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }

        }


        /// <summary><para>method outline:</para>
        /// <para>設定ファイルの読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int iCnt = iCnt + SetFileReload(m_sFileName, ref iFileNum, ref iFileRecordNum, ref csFileData, ref csFileHeader, csDgvAccess, Dgv, CheckNum)</para>
        /// </example>
        /// <param name="sFileName">string[]：ファイル名</param>
        /// <param name="iFileNum">int：読み込みファイル数</param>
        /// <param name="iFileRecordNum">int[]：ファイル中のデータ数</param>
        /// <param name="csFileData">HySCSVFileDim1Data[]：実測値</param>
        /// <param name="csFileHeader">HySCSVFileDim1Data[]：ファイルのヘッダ名</param>
        /// <param name="csDgvAccess">HySEvViewDataGridViewAccess：グラフのアクセスクラス</param>
        /// <param name="Dgv">DataGridView：データグリッドビュー</param>
        /// <param name="CheckNum">int：データグリッドビューのチェック数</param>
        /// <returns>int（－1：ファイル読み込み失敗，0：ファイル読込成功）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private int SetFileReload(string[] sFileName, ref int iFileNum, ref int[] iFileRecordNum, ref HySCSVFileDim1Data[] csFileData,
            ref HySCSVFileDim1Data[] csFileHeader, HySEvViewDataGridViewAccess csDgvAccess, DataGridView Dgv, int CheckNum)
        {
            //データ追加カウント
            iFileNum++;
            //データ追加のためのインスタンス生成
            csFileData[iFileNum - 1] = new HySCSVFileDim1Data();
            csFileHeader[iFileNum - 1] = new HySCSVFileDim1Data();

            //ファイルアドレスをHySFile型に
            HySFile csFile = new HySFile(sFileName[iFileNum - 1]);//
            //ファイル名をHySString型に
            HySString csHySStiring = new HySString(sFileName[iFileNum - 1]);
            //HySCSVFileDim1消さないように！
            long lOpenChecker = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            if (lOpenChecker == -1)
            {
                //データグリッドビューが左軸
                if (Dgv == Left_Axis_DataGridView)
                {
                    int idec = 0;
                    //チェック箇所の修正
                    for (int i_Cnt1 = 0; i_Cnt1 < CheckNum; i_Cnt1++)
                    {

                        if (m_iLAIndexRow[i_Cnt1] == iFileNum - 1)
                        {
                            for (int i_Cnt2 = i_Cnt1; i_Cnt2 < CheckNum - 1; i_Cnt2++)
                            {
                                m_iLAIndexColumn[i_Cnt2] = m_iLAIndexColumn[i_Cnt2 + 1];
                                m_iLAIndexRow[i_Cnt2] = m_iLAIndexRow[i_Cnt2 + 1];
                            }
                            m_iLAIndexColumn[CheckNum - 1] = -1;
                            m_iLAIndexRow[CheckNum - 1] = -1;
                            idec++;
                            i_Cnt1--;
                        }
                    }
                    //行のチェック箇所の再修正
                    for (int i_Cnt = 0; i_Cnt < CheckNum - idec; i_Cnt++)
                    {
                        if (m_iLAIndexRow[i_Cnt] > iFileNum - 1)
                        {
                            m_iLAIndexRow[i_Cnt] = m_iLAIndexRow[i_Cnt] - 1;
                        }
                    }
                }
                //データグリッドビューが右軸（折れ線）
                else if (Dgv == Right_Axis_Line_DataGridView)
                {
                    int idec = 0;
                    //チェック箇所の修正
                    for (int i_Cnt1 = 0; i_Cnt1 < CheckNum; i_Cnt1++)
                    {

                        if (m_iRALineIndexRow[i_Cnt1] == iFileNum - 1)
                        {
                            for (int i_Cnt2 = i_Cnt1; i_Cnt2 < CheckNum - 1; i_Cnt2++)
                            {
                                m_iRALineIndexColumn[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                m_iRALineIndexRow[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                            }
                            m_iRALineIndexColumn[CheckNum - 1] = -1;
                            m_iRALineIndexRow[CheckNum - 1] = -1;
                            idec++;
                            i_Cnt1--;
                        }
                    }
                    //行のチェック箇所の再修正
                    for (int i_Cnt = 0; i_Cnt < CheckNum - idec; i_Cnt++)
                    {
                        if (m_iRALineIndexRow[i_Cnt] > iFileNum - 1)
                        {
                            m_iRALineIndexRow[i_Cnt] = m_iRALineIndexRow[i_Cnt] - 1;
                        }
                    }
                }
                //データグリッドビューが右軸（棒）
                else if (Dgv == Right_Axis_Bar_DataGridView)
                {
                        if (m_iRABarIndexRow == iFileNum - 1)
                        {
                            m_iRABarIndexRow = -1;
                            m_iRABarIndexColumn = -1;
                        }
                }

                
                for (int i_Cnt = iFileNum - 1; i_Cnt < sFileName.Length - 1; i_Cnt++)
                {
                    //ファイルの削除
                    sFileName[i_Cnt] = sFileName[i_Cnt + 1];
                    if (i_Cnt == sFileName.Length - 2)
                    {
                        sFileName[i_Cnt + 1] = null;
                    }
                }
                //読み込みファイルを一つ減らす
                iFileNum--;
                //異常終了
                return -1;
            }
            //ファイルの読み出しとレコード数の保存
            iFileRecordNum[iFileNum - 1] = (int)csFileData[iFileNum - 1].ReadCSVFile(csFile);
            //ファイルのクローズ処理
            csFile.Close();
            //CommonMPの1次元配列時系列のフォーマットでない場合は終了
            if (iFileRecordNum[iFileNum - 1] == -1)
            {
                //データグリッドビューが左軸
                if (Dgv == Left_Axis_DataGridView)
                {
                    int idec = 0;
                    //チェック箇所の修正
                    for (int i_Cnt1 = 0; i_Cnt1 < CheckNum; i_Cnt1++)
                    {

                        if (m_iLAIndexRow[i_Cnt1] == iFileNum - 1)
                        {
                            for (int i_Cnt2 = i_Cnt1; i_Cnt2 < CheckNum - 1; i_Cnt2++)
                            {
                                m_iLAIndexColumn[i_Cnt2] = m_iLAIndexColumn[i_Cnt2 + 1];
                                m_iLAIndexRow[i_Cnt2] = m_iLAIndexRow[i_Cnt2 + 1];
                            }
                            m_iLAIndexColumn[CheckNum - 1] = -1;
                            m_iLAIndexRow[CheckNum - 1] = -1;
                            idec++;
                            i_Cnt1--;
                        }
                    }
                    //行のチェック箇所の再修正
                    for (int i_Cnt = 0; i_Cnt < CheckNum - idec; i_Cnt++)
                    {
                        if (m_iLAIndexRow[i_Cnt] > iFileNum - 1)
                        {
                            m_iLAIndexRow[i_Cnt] = m_iLAIndexRow[i_Cnt] - 1;
                        }
                    }
                }
                //データグリッドビューが右軸（折れ線）
                else if (Dgv == Right_Axis_Line_DataGridView)
                {
                    int idec = 0;
                    //チェック箇所の修正
                    for (int i_Cnt1 = 0; i_Cnt1 < CheckNum; i_Cnt1++)
                    {

                        if (m_iRALineIndexRow[i_Cnt1] == iFileNum - 1)
                        {
                            for (int i_Cnt2 = i_Cnt1; i_Cnt2 < CheckNum - 1; i_Cnt2++)
                            {
                                m_iRALineIndexColumn[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                m_iRALineIndexRow[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                            }
                            m_iRALineIndexColumn[CheckNum - 1] = -1;
                            m_iRALineIndexRow[CheckNum - 1] = -1;
                            idec++;
                            i_Cnt1--;
                        }
                    }
                    //行のチェック箇所の再修正
                    for (int i_Cnt = 0; i_Cnt < CheckNum - idec; i_Cnt++)
                    {
                        if (m_iRALineIndexRow[i_Cnt] > iFileNum - 1)
                        {
                            m_iRALineIndexRow[i_Cnt] = m_iRALineIndexRow[i_Cnt] - 1;
                        }
                    }
                }
                //データグリッドビューが右軸（棒）
                else if (Dgv == Right_Axis_Bar_DataGridView)
                {
                    if (m_iRABarIndexRow == iFileNum - 1)
                    {
                        m_iRABarIndexRow = -1;
                        m_iRABarIndexColumn = -1;
                    }
                }


                for (int i_Cnt = iFileNum - 1; i_Cnt < sFileName.Length - 1; i_Cnt++)
                {
                    //ファイルの削除
                    sFileName[i_Cnt] = sFileName[i_Cnt + 1];
                    if (i_Cnt == sFileName.Length - 2)
                    {
                        sFileName[i_Cnt + 1] = null;
                    }
                }
                //読み込みファイルを一つ減らす
                iFileNum--;
                //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                //異常終了
                return -1;
            }
            //ヘッダーを読み込むための準備
            csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            csFileData[iFileNum - 1].HeadInfRead(csFile);
            csFile.Close();

            //データ格納・戻り値はデータ数//(DataStoreクラス)
            long i_lNum = 0;
            csFileData[iFileNum - 1].GetDimention(ref i_lNum);

            //ヘッダ設定(Accessクラス)
            int i_Num = (int)i_lNum;
            csDgvAccess.SetDataGridViewHeader(Dgv, i_Num);
            //1行追加
            Dgv.Rows.Add(1);
            //最大データ数設定
            csDgvAccess.SetMaxDataNum(i_Num);//Accessクラス
            //データ設定(Accessクラス)
            csDgvAccess.DataGridViewNameInput(Dgv,
                csFileData[iFileNum - 1], sFileName, i_Num, iFileNum);
            //使わないCheckBoxをリードオンリーにする
            csDgvAccess.CheckBoxReadOnly(Dgv);
            //正常終了
            return 0;
        }




        /// <summary><para>method outline:</para>
        /// <para>チェック箇所の順番保持</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckCompare(sBeforeFile, sAfterFile, Row, bCheck)</para>
        /// </example>
        /// <param name="sBeforeFile">string[]：設定情報ファイル読み出し直後の読み込みデータファイル名</param>
        /// <param name="sAfterFile">string[]：データファイル読み込み後のデータファイル名（消去済み）</param>
        /// <param name="Row">int[]</param>
        /// <param name="bCheck">bool[]：チェック有効判定</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CheckCompare(string[] sBeforeFile, string[] sAfterFile, int[] Row, bool[] bCheck)
        {
            int[] stocknum = new int[MAXDATANUM];
            int CntNum = 0;
            for (int i_Cnt1 = 0; i_Cnt1 < sBeforeFile.Length; i_Cnt1++)
            {
                for (int i_Cnt2 = 0; i_Cnt2 < sAfterFile.Length; i_Cnt2++)
                {
                    if (sBeforeFile[i_Cnt1] == sAfterFile[i_Cnt2])
                    {
                        if (sAfterFile[i_Cnt2] == null)
                        {
                            break;
                        }
                        stocknum[CntNum] = i_Cnt1;
                        CntNum++;
                    }
                }
            }

            for (int i_Cnt1 = 0; i_Cnt1 < bCheck.Length; i_Cnt1++)
            {
                bCheck[i_Cnt1] = false;
                for (int i_Cnt2 = 0; i_Cnt2 < Row.Length; i_Cnt2++)
                {
                    if (Row[i_Cnt1] == stocknum[i_Cnt2])
                    {
                        bCheck[i_Cnt1] = true;
                        break;
                    }
                }
            }

        }



        /// <summary><para>method outline:</para>
        /// <para>設定情報からのデータグリッドビューにチェックを入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCheckReload(m_sFileName, iIndexColumn, iIndexRow, Dgv, sID)</para>
        /// </example>
        /// <param name="sFileName">string</param>
        /// <param name="iIndexColumn">int</param>
        /// <param name="iIndexRow">int</param>
        /// <param name="Dgv">DataGridView</param>
        /// <param name="sID">string</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetCheckReload(string sFileName, int iIndexColumn, int iIndexRow, DataGridView Dgv, string sID)
        {
            string sGroup = sID.ToString() + (iIndexColumn).ToString();
            string sDataName = Dgv[2 * (iIndexColumn + 1), iIndexRow].Value.ToString();
            Dgv[2 * iIndexColumn + 1, iIndexRow].Value = true;
            //string m_sFileName = m_sFileName[e.RowIndex];
            legendList1.ClickEvent = false;
            legendList1.AddList(sGroup, sFileName, sDataName);
        }



        /// <summary><para>method outline:</para>
        /// <para>手動時間設定の無効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>X_Auto_radioButton_CheckedChanged(sender, e)：自動のラジオボタンをクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void X_Auto_radioButton_CheckedChanged(object sender, EventArgs e)
        {
            m_IsAutoFit = true;
            dtpStart.Enabled = false;
            dtpEnd.Enabled = false;
            cmbHourStart.Enabled = false;
            cmbHourEnd.Enabled = false;
            cmbMinuteStart.Enabled = false;
            cmbMinuteEnd.Enabled = false;
        }


        /// <summary><para>method outline:</para>
        /// <para>手動時間設定の有効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>X_Manual_radioButton_CheckedChanged(sender, e)：手動のラジオボタンをクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void X_Manual_radioButton_CheckedChanged(object sender, EventArgs e)
        {
            m_IsAutoFit = false;
            dtpStart.Enabled = true;
            dtpEnd.Enabled = true;
            cmbHourStart.Enabled = true;
            cmbHourEnd.Enabled = true;
            cmbMinuteStart.Enabled = true;
            cmbMinuteEnd.Enabled = true;
        }


        /// <summary><para>method outline:</para>
        /// <para>選択時間のチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int i = Selected_Time_Check()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int　0：正常、-1：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private int Selected_Time_Check()
        {
            DateTime csStartTime = new DateTime(int.Parse(dtpStart.Value.Year.ToString()), int.Parse(dtpStart.Value.Month.ToString()),
                    int.Parse(dtpStart.Value.Day.ToString()), int.Parse(cmbHourStart.SelectedItem.ToString()), int.Parse(cmbMinuteStart.SelectedItem.ToString()), 0);
            DateTime csEndTime = new DateTime(dtpEnd.Value.Year, dtpEnd.Value.Month, dtpEnd.Value.Day,
                int.Parse(cmbHourEnd.SelectedItem.ToString()), int.Parse(cmbMinuteEnd.SelectedItem.ToString()), 0);
            TimeSpan csSpan = csEndTime - csStartTime;
            TimeSpan csZero = new TimeSpan(0, 0, 0);
            if (csSpan <= csZero)
            {
                Console.WriteLine("The time you selected is wrong");
                return -1;//選択した時間が間違っている
            }
            //選択した時間は正しい
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>プログラムからのグラフ設定保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProgSaveGraphInfo();</para>
        /// </example>
        /// <param name="csCopyDir">外部保存ファイルフルパス（コピー先）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void ProgSaveGraphInfo(HySString csCopyDir)
        {
            int lRtn = this.SetGraphInformation();
            if (lRtn == 1)
            {
                // 正常終了ならばコピーを行う
                try
                {
                    // 外部保存ファイルのベース名称取得
                    string sSaveFileName = System.IO.Path.GetFileNameWithoutExtension(csCopyDir.ToString());
                    // 外部保存ファイルと同じディレクトリを取得（グラフ設定ファイルをコピーするのに使う）
                    System.IO.DirectoryInfo csInfo = System.IO.Directory.GetParent(csCopyDir.ToString());
                    string sCopyDir = csInfo.ToString() + "\\" + sSaveFileName + "._GraphSaveInfo.obj";
                    //string sCopyDir = csCopyDir.ToString() + "\\._GraphSaveInfo.obj";
                    // 本グラフ設定ファイルを外部保存ファイルのベース名称を使用しリネーム後、コピー先へ保存
                    File.Copy(g_sGrphSaveFileName, sCopyDir, true);
                }
                catch (Exception ex)
                {
                    // 例外発生
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.ProgSaveGraphInfo", 
                        Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + "(" + ex.Message +")");
                   // HySLog.LogOut(HySLog.ONLINE, "HySDotNetLineGraphForm.ProgSaveGraphInfo", "catch exception( " + ex.Message + ")");
                }
            }
        }

        # region 不要処理 後で消す
        ///// <summary><para>method outline:</para>
        ///// <para>プログラムからのグラフ設定復元</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ProgLoadGraphInfo();</para>
        ///// </example>
        ///// <param name="csCopyDir">コピー先</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //internal virtual void ProgLoadGraphInfo()
        //{
        //    this.GetGraphInformation();
        //}
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>プログラムからの状態自動保存設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAutoStatus(bStatus);</para>
        /// </example>
        /// <param name="bStatus">bool true: 自動保存設定の有効,　false: 自動保存設定の無効</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetAutoStatus(bool bStatus)
        {
            m_csDefine.g_bAutoStatus = bStatus;
        }

        /// <summary><para>method outline:</para>
        /// <para>プログラムからの再描画開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProgRedraw();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void ProgRedraw()
        {
            rdoByHour.Checked = false;
            rdoByMinute.Checked = true;

            Left_Axis_Reflesh();
            Right_Axis_Line_Reflesh();
            Right_Axis_Bar_Reflesh();

            //btnRedraw_Click(null, null);
        }
        /// <summary><para>method outline:</para>
        /// <para>左軸ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Left_Axis_Reflesh()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プログラムからの読み込み</para>
        /// </remarks>
        private void Left_Axis_Reflesh( )
        {
            int iDtNum = m_csLeftAxisFileData.Length;
            for(int iLp=0;iLp<iDtNum;iLp++)
            {
                if (m_csLeftAxisFileData[iLp] == null) { continue; }
                //一時行数を保存
                long l_LAFileRecordNum = 0;
                m_csLeftAxisFileData[iLp].GetDimention(ref l_LAFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sLAFileName[iLp]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iLAFileRecordNum[iLp] = (int)m_csLeftAxisFileData[iLp].ReadCSVFile(csFile);
                csFile.Close();
                long l_Cnt = 0;
                m_csLeftAxisFileData[iLp].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iLAFileRecordNum[iLp] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csLeftAxisFileData[iLp].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csLeftAxisAccess.SetDataGridViewHeader(Left_Axis_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csLeftAxisAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csLeftAxisAccess.DataGridViewNameInput(Left_Axis_DataGridView, m_csLeftAxisFileData[iLp],
                        m_sLAFileName, (int)l_Cnt, iLp + 1);


                    //データ個数が減った時
                    if (l_LAFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sLAFileName[iLp];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iLACheckNum; i_Cnt1++)
                        {
                            if (m_iLAIndexRow[i_Cnt1] == iLp &&
                                m_iLAIndexColumn[i_Cnt1] >= (int)l_Cnt)
                            {
                                string sGroup = "LA" + m_iLAIndexColumn[i_Cnt1].ToString();
                                m_iLACheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iLACheckNum; i_Cnt2++)
                                {
                                    m_iLAIndexRow[i_Cnt2] = m_iLAIndexRow[i_Cnt2 + 1];
                                    m_iLAIndexColumn[i_Cnt2] = m_iLAIndexColumn[i_Cnt2 + 1];
                                }
                                i_Cnt1--;
                            }
                        }
                    }
                    m_csLeftAxisAccess.RemoveColumns(Left_Axis_DataGridView, m_csLeftAxisFileData, m_LeftAxisReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>右軸（折れ線）ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Right_Axis_Line_Reflesh(）</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プログラムからの読み込み</para>
        /// </remarks>
        private void Right_Axis_Line_Reflesh()
        {
            int iDtNum = m_csRightAxisLineFileData.Length;
            for (int iLp = 0; iLp < iDtNum; iLp++)
            {
                if (m_csRightAxisLineFileData[iLp] == null) { continue; }

                //一時行数を保存
                long l_RALineFileRecordNum = 0;
                m_csRightAxisLineFileData[iLp].GetDimention(ref l_RALineFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sRALineFileName[iLp]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iRALineFileRecordNum[iLp] = (int)m_csRightAxisLineFileData[iLp].ReadCSVFile(csFile);
                //m_csRightAxisLineFileData[Right_Axis_Line_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                csFile.Close();

                long l_Cnt = 0;
                m_csRightAxisLineFileData[iLp].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iRALineFileRecordNum[iLp] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csRightAxisLineFileData[iLp].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csRightAxisLineAccess.SetDataGridViewHeader(Right_Axis_Line_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csRightAxisLineAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csRightAxisLineAccess.DataGridViewNameInput(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData[iLp],
                        m_sRALineFileName, (int)l_Cnt, iLp + 1);

                    //データ個数が減った時
                    if (l_RALineFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sRALineFileName[iLp];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iRALineCheckNum; i_Cnt1++)
                        {
                            if (m_iRALineIndexRow[i_Cnt1] == iLp &&
                                m_iRALineIndexColumn[i_Cnt1] >= (int)l_Cnt)
                            {
                                string sGroup = "RL" + m_iRALineIndexColumn[i_Cnt1].ToString();
                                m_iRALineCheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iRALineCheckNum; i_Cnt2++)
                                {
                                    m_iRALineIndexRow[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                                    m_iRALineIndexColumn[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                }
                                i_Cnt1--;
                            }
                        }
                    }
                    m_csRightAxisLineAccess.RemoveColumns(Right_Axis_Line_DataGridView, m_csRightAxisLineFileData, m_RightAxisLineReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>右軸（棒）ファイルの再読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Right_Axis_Bar_Reflesh(）</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プログラムからの読み込み</para>
        /// </remarks>
        private void Right_Axis_Bar_Reflesh()
        {
            int iDtNum = m_csRightAxisBarFileData.Length;
            for (int iLp = 0; iLp < iDtNum; iLp++)
            {
                if (m_csRightAxisBarFileData[iLp] == null) { continue; }

                //一時行数を保存
                long l_RABarFileRecordNum = 0;
                m_csRightAxisBarFileData[iLp].GetDimention(ref l_RABarFileRecordNum);
                //ファイルアドレスをHySFile型に
                HySFile csFile = new HySFile(m_sRABarFileName[iLp]);
                long lResult = csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                if (lResult == -1)
                {
                    return;
                }
                //ファイルをHySCSVFileData型に格納
                m_iRABarFileRecordNum[iLp] = (int)m_csRightAxisBarFileData[Right_Axis_Bar_DataGridView.CurrentCell.RowIndex].ReadCSVFile(csFile);
                //m_csRightAxisBarFileData[iLp].ReadCSVFile(csFile);
                csFile.Close();

                long l_Cnt = 0;
                m_csRightAxisBarFileData[iLp].GetDimention(ref l_Cnt);
                //CommonMPの1次元配列時系列のフォーマットでない場合は終了
                if (m_iRABarFileRecordNum[iLp] == -1)
                {
                    //MessageBox.Show("開いたファイルが読み込み可能ファイルではありません");
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_INAPPLICABLE_FILE"));
                    return;
                }
                else
                {
                    //ヘッダーを読み込むための準備
                    csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    m_csRightAxisBarFileData[iLp].HeadInfRead(csFile);
                    csFile.Close();

                    //ヘッダ設定
                    m_csRightAxisBarAccess.SetDataGridViewHeader(Right_Axis_Bar_DataGridView, (int)l_Cnt);
                    //最大値設定
                    m_csRightAxisBarAccess.SetMaxDataNum((int)l_Cnt);

                    //データ設定
                    m_csRightAxisBarAccess.DataGridViewNameInput(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData[iLp],
                        m_sRABarFileName, (int)l_Cnt, iLp + 1);

                    //データ個数が減った時
                    if (l_RABarFileRecordNum > l_Cnt)
                    {
                        string sFileName = m_sRABarFileName[iLp];
                        for (int i_Cnt1 = 0; i_Cnt1 < m_iRABarCheckNum; i_Cnt1++)
                        {
                            if (m_iRABarIndexRow == iLp &&
                                m_iRABarIndexColumn >= (int)l_Cnt)
                            {
                                string sGroup = "RB" + m_iRABarIndexColumn.ToString();
                                m_iRABarCheckNum--;
                                legendList1.DelList(sGroup, sFileName);
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_iRABarCheckNum; i_Cnt2++)
                                {
                                    m_iRABarIndexRow = -1;//[i_Cnt2] = m_iRALineIndexRow[i_Cnt2 + 1];
                                    m_iRABarIndexColumn = -1;//[i_Cnt2] = m_iRALineIndexColumn[i_Cnt2 + 1];
                                }
                                break;
                            }
                        }
                    }
                    m_csRightAxisBarAccess.RemoveColumns(Right_Axis_Bar_DataGridView, m_csRightAxisBarFileData, m_RightAxisBarReadDataNum);
                }

                //再描画
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
            }
        }

        /// <summary>ライングラフ設定情報保存ファイル名 </summary>
        public static readonly string g_sGrphSaveFileName = "..\\temp\\._GraphSaveInfo.obj";
    }
}