﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>リスク表示モジュール画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class HySEvRiskView : Form
    {
        private HySEvViewBaseDataItems m_BaseDataItems = new HySEvViewBaseDataItems();

        private HySDotNetLineGraphForm m_frmParent = null;

        private DataGridViewComboBoxEditingControl m_dataGridViewComboBox = null;   //[2010.03.22]

        private int m_dataGridViewNowIndex = -1;

        /// <summary> 補正率[Key=時刻, Value=値] </summary>
        private SortedList<string, double> m_csCorrectionRate = null;
        /// <summary> 補正量[Key=時刻, Value=値] </summary>
        private SortedList<string, double> m_csCorrectionQuantity = null;
        /// <summary> 誤差評価指標[Key=時刻, Value=値] </summary>
        private SortedList<string, double> m_csEvaluation = null;


        #region 内部メソッド

        #region 補正・その他CSVファイル読込み
        /// <summary>
        /// 補正・その他CSVファイル読込み
        /// </summary>
        /// <param name="h_fname">ファイル名パス</param>
        /// <param name="csData">格納データ変数</param>
        private bool _readTargetCSVFile(string h_fname, ref SortedList<string, double> lstData)
        {
            int iLineNo = 0;
            string line = null;
            try
            {
                lstData = null;
                lstData = new SortedList<string, double>();

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    while ((line = a_sr.ReadLine()) != null)
                    {
                        iLineNo++;     //ファイル内行位置

                        if (line.Length == 0)
                            continue;   //空行読み飛ばし

                        if (iLineNo <= 3)
                            continue;   //3行ヘッダ読み飛ばし

                        string[] cols = line.Split(',');

                        DateTime dteDate = DateTime.Parse(cols[0].Trim());
                        double dVal = double.Parse(cols[1].Trim());

                        lstData.Add(dteDate.ToString("yyyy/MM/dd HH:mm"), dVal);
                    }
                }

                return true;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show("CSVファイル読込みに失敗しました。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                lstData = null;
                return false;
            }
        }
        #endregion

        #region 基準データの読み込み
        /// <summary>
        /// 降雨確率基準データの読み込み
        /// </summary>
        /// <param name="h_fname">ファイル名パス</param>
        private void _readBaseDataCSVFile(
            string h_fname
            )
        {
            bool a_IsOK = true;
            try
            {
                m_BaseDataItems.Clear();
                m_BaseDataItems.Minute = 0;

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    HySEvViewBaseDataItem a_item = null;

                    //1行目：●降雨
                    a_sLine = a_sr.ReadLine();
                    if (a_sLine.IndexOf("●降雨") < 0)
                    {
                        MessageBox.Show("定義ファイルに誤りがあります。", "リスク表示モデル", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        a_IsOK = false;
                        return;
                    }
                    //2行目～2行目：
                    for (int a_iCnt = 1; a_iCnt <= 1; a_iCnt++)
                    {
                        a_sLine = a_sr.ReadLine();
                        a_split = a_sLine.Split(a_delimiter);

                        a_item = new HySEvViewBaseDataItem();
                        a_item.Val1 = a_split[0].Trim();
                        a_item.Val2 = a_split[1].Trim();
                        m_BaseDataItems.Add(a_item);
                    }
                    //3行目：●基準水位
                    a_sLine = a_sr.ReadLine();
                    if (a_sLine.IndexOf("●基準水位") < 0)
                    {
                        MessageBox.Show("定義ファイルに誤りがあります。", "リスク表示モデル", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        a_IsOK = false;
                        return;
                    }
                    //4行目～9行目：
                    for (int a_iCnt = 4; a_iCnt <= 9; a_iCnt++)
                    {
                        a_sLine = a_sr.ReadLine();
                        a_split = a_sLine.Split(a_delimiter);

                        a_item = new HySEvViewBaseDataItem();
                        a_item.Val1 = a_split[0].Trim();
                        a_item.Val2 = a_split[1].Trim();
                        m_BaseDataItems.Add(a_item);
                    }

                    //10行目：●調整モジュール
                    a_sLine = a_sr.ReadLine();
                    if (a_sLine.IndexOf("●調整モジュール") < 0)
                    {
                        MessageBox.Show("定義ファイルに誤りがあります。", "リスク表示モデル", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        a_IsOK = false;
                        return;
                    }
                    //11行目～12行目：
                    for (int a_iCnt = 11; a_iCnt <= 12; a_iCnt++)
                    {
                        a_sLine = a_sr.ReadLine();
                        a_split = a_sLine.Split(a_delimiter);

                        a_item = new HySEvViewBaseDataItem();
                        a_item.Val1 = a_split[0].Trim();
                        a_item.Val2 = a_split[1].Trim();
                        m_BaseDataItems.Add(a_item);
                    }
                    //13行目：●その他
                    a_sLine = a_sr.ReadLine();
                    if (a_sLine.IndexOf("●その他") < 0)
                    {
                        MessageBox.Show("定義ファイルに誤りがあります。", "リスク表示モデル", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        a_IsOK = false;
                        return;
                    }
                    //14行目～14行目：
                    for (int a_iCnt = 14; a_iCnt <= 14; a_iCnt++)
                    {
                        a_sLine = a_sr.ReadLine();
                        a_split = a_sLine.Split(a_delimiter);

                        a_item = new HySEvViewBaseDataItem();
                        a_item.Val1 = a_split[0].Trim();
                        a_item.Val2 = a_split[1].Trim();
                        m_BaseDataItems.Add(a_item);
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
            finally
            {
                if (a_IsOK == false)
                {
                    m_BaseDataItems.Clear();
                    m_BaseDataItems.Minute = 0;
                }
            }
        }
        #endregion
        #region グリッドのしきい値表示
        /// <summary>
        /// グリッドのしきい値表示
        /// </summary>
        private void _setLimitInGridView()
        {
            try
            {
                String a_sKind = dgvCondition.Rows[m_dataGridViewNowIndex].Cells[0].Value.ToString();

                for (int a_iCnt = 1; a_iCnt <= m_BaseDataItems.Count; a_iCnt++)
                {
                    if (m_BaseDataItems[a_iCnt - 1].Val1.Equals(a_sKind) == true)
                    {
                        dgvCondition.Rows[m_dataGridViewNowIndex].Cells[1].Value = m_BaseDataItems[a_iCnt - 1].Val2;
                        break;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public HySEvRiskView(HySDotNetLineGraphForm h_frmParent)
        {
            m_frmParent = h_frmParent;

            InitializeComponent();
        }

        /// <summary>
        /// 閉じるボタンクリック時処理
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Dispose();
            //m_frmParent.m_frmRiskView = null;   //[2010.03.22]bug-fixed. [2010.12.09]消去
        }

        /// <summary>
        /// 基準データ設定ファイル選択
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void btnBaseData_Click(object sender, EventArgs e)
        {
            OpenFileDialog a_ofd = new OpenFileDialog();

            a_ofd.FileName = "*.csv";
            //a_ofd.InitialDirectory = "";
            a_ofd.Filter = "CSVファイル(*.csv)|*.csv";
            a_ofd.FilterIndex = 1;
            a_ofd.Title = "読み込み対象ファイルを選択して下さい";
            a_ofd.RestoreDirectory = true;
            a_ofd.CheckFileExists = true;
            a_ofd.CheckPathExists = true;

            a_ofd.Multiselect = false;

            if (a_ofd.ShowDialog() == DialogResult.OK)
            {
                txtBaseData.Text = a_ofd.FileName;
                _readBaseDataCSVFile(a_ofd.FileName);
            }
        }

        /// <summary>
        /// ファイル選択
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void btnFileOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialog a_ofd = new OpenFileDialog();

            TextBox textBoxFilePath = null;
            if (sender == btnFileOpenCorrectionRate)
            {
                textBoxFilePath = txtCorrectionRate;
            }
            else if (sender == btnFileOpenCorrectionQuantity)
            {
                textBoxFilePath = txtCorrectionQuantity;
            }
            else if (sender == btnFileOpenEvaluation)
            {
                textBoxFilePath = txtEvaluation;
            }

            a_ofd.FileName = "*.csv";
            //a_ofd.InitialDirectory = "";
            a_ofd.Filter = "CSVファイル(*.csv)|*.csv";
            a_ofd.FilterIndex = 1;
            a_ofd.Title = "読み込み対象ファイルを選択して下さい";
            a_ofd.RestoreDirectory = true;
            a_ofd.CheckFileExists = true;
            a_ofd.CheckPathExists = true;

            a_ofd.Multiselect = false;

            if (a_ofd.ShowDialog() == DialogResult.OK)
            {
                textBoxFilePath.Text = a_ofd.FileName;
                
                if (sender == btnFileOpenCorrectionRate)
                {
                    _readTargetCSVFile(a_ofd.FileName, ref m_csCorrectionRate);
                }
                else if (sender == btnFileOpenCorrectionQuantity)
                {
                    _readTargetCSVFile(a_ofd.FileName, ref m_csCorrectionQuantity);
                }
                else if (sender == btnFileOpenEvaluation)
                {
                    _readTargetCSVFile(a_ofd.FileName, ref m_csEvaluation);
                }
            }
        }

        /// <summary>
        /// 一覧・値変更時
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void dgvCondition_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                String a_sKind = dgvCondition.Rows[e.RowIndex].Cells[0].Value.ToString();

                for (int a_iCnt = 1; a_iCnt <= m_BaseDataItems.Count; a_iCnt++)
                {
                    if (m_BaseDataItems[a_iCnt - 1].Val1.Equals(a_sKind) == true)
                    {
                        dgvCondition.Rows[e.RowIndex].Cells[1].Value = m_BaseDataItems[a_iCnt - 1].Val2;
                        break;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }

        private void dgvCondition_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {

        }

        private void dgvCondition_CellMouseUp(object sender, DataGridViewCellMouseEventArgs e)
        {

        }

        private void dgvCondition_CellMouseDown(object sender, DataGridViewCellMouseEventArgs e)
        {

        }

        private void dgvCondition_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        /// <summary>
        /// ＯＫボタンクリック時処理
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void btnOK_Click(object sender, EventArgs e)
        {
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                if (m_BaseDataItems.Count > 0)
                {
                    lstAlert.Items.Clear();

                    //[2010.03.22]
                    String a_sTime = "";
                    String a_sKind = "";
                    float a_fLimit = 0;
                    String a_sCondition = "";

                    //参照インデックス
                    int a_RainfallIdx = 1;
                    int[] a_WaterLevelIdx = new int[m_frmParent.m_WaterLevelItems.Length];
                    for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                    {
                        a_WaterLevelIdx[a_k - 1] = 1;
                    }

                    //雨量情報初期化
                    m_frmParent.m_RainfallItems[0].NowIdx = 1;
                    //m_frmParent.m_RainfallItems[0].AlertMsg = null;
                    //水位情報初期化
                    for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                    {
                        m_frmParent.m_WaterLevelItems[a_k - 1].NowIdx = 1;
                        //m_frmParent.m_WaterLevelItems[a_k - 1].AlertMsg = null;
                    }

                    //int a_RainfallIdx = 1;
                    //int a_WaterLevelIdx = 1;
                    //string[][] a_AlertMsg = new string[8][];
                    //int a_GridIdx = 0;
                    int[] a_bGridVal = new int[dgvCondition.Rows.Count];
                    string[][] a_AlertMsg = new string[dgvCondition.Rows.Count][];
                    for (int a_iCnt = 1; a_iCnt <= dgvCondition.Rows.Count; a_iCnt++)
                    {
                        //-1：無効データ、0：アラートなし、1：アラートあり
                        a_bGridVal[a_iCnt - 1] = -1;
                        a_AlertMsg[a_iCnt - 1] = null;  
                    }

                    bool a_IsOK = false;
  
                    //int a_iTime = 0;
                    //開始時刻から終了時刻の繰り返し
                    DateTime a_sDate = m_frmParent.m_DtStart;
                    while (a_sDate.CompareTo(m_frmParent.m_DtEnd) <= 0)
                    {
                        a_sTime = a_sDate.ToString("yyyy/MM/dd HH:mm");

                        //雨量情報初期化
                        //m_frmParent.m_RainfallItems[0].AlertMsg = null;
                        //水位情報初期化
                        //for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                        //{
                        //    m_frmParent.m_WaterLevelItems[a_k - 1].AlertMsg = null;
                        //}

                        //GridViewの内容を解析
                        for (int a_iCnt = 1; a_iCnt <= dgvCondition.Rows.Count; a_iCnt++)
                        {
                            a_sKind = "";
                            a_fLimit = 0;
                            a_sCondition = "";

                            if (dgvCondition.Rows[a_iCnt - 1].Cells[0].Value != null)
                            {
                                a_sKind = dgvCondition.Rows[a_iCnt - 1].Cells[0].Value.ToString();
                                a_fLimit = Convert.ToSingle(dgvCondition.Rows[a_iCnt - 1].Cells[1].Value);
                                if (dgvCondition.Rows[a_iCnt - 1].Cells[2].Value != null)
                                {
                                    a_sCondition = dgvCondition.Rows[a_iCnt - 1].Cells[2].Value.ToString();
                                }
                            }

                            if (a_sKind.Equals("降雨強度(mm/hr)") == true)
                            {
                                //雨量データをチェック
                                a_IsOK = false;
                                try
                                {
                                    if (m_frmParent.m_RainfallItems != null)
                                    {
                                        for (int a_i = m_frmParent.m_RainfallItems[0].NowIdx; a_i <= m_frmParent.m_RainfallItems[0].Count; a_i++)
                                        {
                                            if (m_frmParent.m_RainfallItems[0][a_i - 1].sTimeOrDay.Equals(a_sTime) == true)
                                            {
                                                if (m_frmParent.m_RainfallItems[0][a_i - 1].Rainfall >= a_fLimit)
                                                {   //リスク表示
                                                    if (a_sCondition.Equals("AND") == true)
                                                    {
                                                        //前回までの値が無効だった場合は、本アラートも無効となる。
                                                        for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                        {
                                                            if (a_bGridVal[a_j - 1] != -1)
                                                            {
                                                                if (a_bGridVal[a_j - 1] == 1)
                                                                {
                                                                    a_IsOK = true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    else
                                                    {
                                                        a_IsOK = true;
                                                    }
                                                    if (a_IsOK == true)
                                                    {
                                                        a_AlertMsg[a_iCnt - 1] = new string[]{
                                                            m_frmParent.m_RainfallItems[0].FileName,
                                                            m_frmParent.m_RainfallItems[0][a_i - 1].sTimeOrDay,
                                                            "降雨強度(mm/hr)",
                                                            a_fLimit.ToString() + "(mm/hr)を超えました。"
                                                        };
                                                        a_bGridVal[a_iCnt - 1] = 1; //アラートあり
                                                    }
                                                }
                                                else
                                                {
                                                    if (a_sCondition.Equals("AND") == true)
                                                    {
                                                        //前回までのデータは無効となる。
                                                        for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                        {
                                                            if (a_bGridVal[a_j - 1] != -1)
                                                            {
                                                                a_bGridVal[a_j - 1] = 0;
                                                                a_AlertMsg[a_j - 1] = null;
                                                            }
                                                        }
                                                    }
                                                }

                                                if (a_IsOK == true)
                                                {
                                                    a_bGridVal[a_iCnt - 1] = 1;
                                                }
                                                else
                                                {
                                                    a_bGridVal[a_iCnt - 1] = 0;
                                                    a_AlertMsg[a_iCnt - 1] = null;
                                                }

                                                a_RainfallIdx = m_frmParent.m_RainfallItems[0].NowIdx;
                                                a_RainfallIdx++;
                                                break;
                                            }
                                        }
                                    }
                                }
                                catch (Exception exp)
                                {
                                    Console.WriteLine(exp.Message);
                                }

                            }
                            else if (a_sKind.Equals("流域平均(mm/hr)") == true)
                            {   //pending
                            }
                            else if ((a_sKind.Equals("水防団待機水位(m)") == true) ||
                           (a_sKind.Equals("氾濫注意水位(m)") == true) ||
                           (a_sKind.Equals("避難判断水位(m)") == true) ||
                           (a_sKind.Equals("氾濫危険水位(m)") == true) ||
                           (a_sKind.Equals("計画高水位(m)") == true) ||
                           (a_sKind.Equals("水位上昇量(m)") == true))
                            {
                                //水位データをチェック
                                a_IsOK = false;
                                try
                                {
                                    if (m_frmParent.m_WaterLevelItems != null)
                                    {
                                        for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                                        {
                                            for (int a_i = m_frmParent.m_WaterLevelItems[a_k - 1].NowIdx; a_i <= m_frmParent.m_WaterLevelItems[a_k - 1].Count; a_i++)
                                            {
                                                if (m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 1].sTimeOrDay.Equals(a_sTime) == true)
                                                {
                                                    float fVal = m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 1].WaterLevel;
                                                    if (a_sKind.Equals("水位上昇量(m)") == true)
                                                    {   //前時間との差
                                                        if (a_i == 1)
                                                            fVal = -9999;
                                                        else
                                                            fVal -= m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 2].WaterLevel;
                                                    }

                                                    if (fVal >= a_fLimit)
                                                    {   //リスク表示
                                                        if (a_sCondition.Equals("AND") == true)
                                                        {
                                                            //前回までの値が無効だった場合は、本アラートも無効となる。
                                                            for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                            {
                                                                if (a_bGridVal[a_j - 1] != -1)
                                                                {
                                                                    if (a_bGridVal[a_j - 1] == 1)
                                                                    {
                                                                        a_IsOK = true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        else
                                                        {
                                                            a_IsOK = true;
                                                        }
                                                        if (a_IsOK == true)
                                                        {
                                                            a_AlertMsg[a_iCnt - 1] = new string[] {
                                                                m_frmParent.m_WaterLevelItems[a_k - 1].FileName,
                                                                m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 1].sTimeOrDay,
                                                                a_sKind,
                                                                a_fLimit.ToString() + "(m)を超えました。"
                                                                };
                                                            a_bGridVal[a_iCnt - 1] = 1; //アラートあり
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if (a_sCondition.Equals("AND") == true)
                                                        {
                                                            //前回までのデータは無効となる。
                                                            for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                            {
                                                                if (a_bGridVal[a_j - 1] != -1)
                                                                {
                                                                    a_bGridVal[a_j - 1] = 0;
                                                                    a_AlertMsg[a_j - 1] = null;
                                                                }
                                                            }
                                                        }
                                                    }

                                                    if (a_IsOK == true)
                                                    {
                                                        a_bGridVal[a_iCnt - 1] = 1;
                                                    }
                                                    else
                                                    {
                                                        a_bGridVal[a_iCnt - 1] = 0;
                                                        a_AlertMsg[a_iCnt - 1] = null;
                                                    }

                                                    a_WaterLevelIdx[a_k - 1] = m_frmParent.m_WaterLevelItems[a_k - 1].NowIdx;
                                                    a_WaterLevelIdx[a_k - 1]++;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (Exception exp)
                                {
                                    Console.WriteLine(exp.Message);
                                }
                            }
                            else if ((a_sKind.Equals("補正率(-)") == true) ||
                                    (a_sKind.Equals("補正量(-)") == true) || 
                                    (a_sKind.Equals("誤差評価指標(-)") == true))
                            {
                                SortedList<string, double> lstData = null;
                                string sFileNamePath = "";
                                if (a_sKind.Equals("補正率(-)") == true)
                                {
                                    lstData = m_csCorrectionRate;
                                    sFileNamePath = System.IO.Path.GetFileName(txtCorrectionRate.Text);
                                }
                                else if (a_sKind.Equals("補正量(-)") == true)
                                {
                                    lstData = m_csCorrectionQuantity;
                                    sFileNamePath = System.IO.Path.GetFileName(txtCorrectionQuantity.Text);
                                }
                                else if (a_sKind.Equals("誤差評価指標(-)") == true)
                                {
                                    lstData = m_csEvaluation;
                                    sFileNamePath = System.IO.Path.GetFileName(txtEvaluation.Text);
                                }

                                a_IsOK = false;
                                try
                                {
                                    if (lstData != null && lstData.ContainsKey(a_sTime))
                                    {
                                        double dVal = lstData[a_sTime];
                                        if (dVal >= a_fLimit)
                                        {   //リスク表示
                                            if (a_sCondition.Equals("AND") == true)
                                            {
                                                //前回までの値が無効だった場合は、本アラートも無効となる。
                                                for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                {
                                                    if (a_bGridVal[a_j - 1] != -1)
                                                    {
                                                        if (a_bGridVal[a_j - 1] == 1)
                                                        {
                                                            a_IsOK = true;
                                                        }
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                a_IsOK = true;
                                            }
                                            if (a_IsOK == true)
                                            {
                                                a_AlertMsg[a_iCnt - 1] = new string[]{
                                                            sFileNamePath,
                                                            a_sTime,
                                                            a_sKind,
                                                            a_fLimit.ToString() + "を超えました。"
                                                        };
                                                a_bGridVal[a_iCnt - 1] = 1; //アラートあり
                                            }
                                        }
                                        else
                                        {
                                            if (a_sCondition.Equals("AND") == true)
                                            {
                                                //前回までのデータは無効となる。
                                                for (int a_j = a_iCnt - 1; a_j >= 1; a_j--)
                                                {
                                                    if (a_bGridVal[a_j - 1] != -1)
                                                    {
                                                        a_bGridVal[a_j - 1] = 0;
                                                        a_AlertMsg[a_j - 1] = null;
                                                    }
                                                }
                                            }
                                        }

                                        if (a_IsOK == true)
                                        {
                                            a_bGridVal[a_iCnt - 1] = 1;
                                        }
                                        else
                                        {
                                            a_bGridVal[a_iCnt - 1] = 0;
                                            a_AlertMsg[a_iCnt - 1] = null;
                                        }
                                    }
                                }
                                catch (Exception exp)
                                {
                                    Console.WriteLine(exp.Message);
                                }
                            }

                            //a_GridIdx++;
                        }

                        //アラート表示
                        for (int a_iCnt = 1; a_iCnt <= dgvCondition.Rows.Count; a_iCnt++)
                        {
                            //-1：無効データ、0：アラートなし、1：アラートあり
                            if (a_AlertMsg[a_iCnt - 1] != null)
                            {
                                lstAlert.Items.Add(new ListViewItem(a_AlertMsg[a_iCnt - 1]));
                            }
                        }

                        //雨量アラート
                        //if (m_frmParent.m_RainfallItems[0].AlertMsg != null)
                        //{
                        //    lstAlert.Items.Add(new ListViewItem(m_frmParent.m_RainfallItems[0].AlertMsg));
                        //}

                        //水位アラート
                        //for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                        //{
                        //    if (m_frmParent.m_WaterLevelItems[a_k - 1].AlertMsg != null)
                        //    {
                        //        lstAlert.Items.Add(new ListViewItem(m_frmParent.m_WaterLevelItems[a_k - 1].AlertMsg));
                        //    }
                        //}

                        //lstAlert.Items.Add(new ListViewItem(a_item));

                        //時刻を進める
                        //a_iTime++;
                        if (m_frmParent.rdoByMinute.Checked == true)
                        {   //分単位
                            a_sDate = a_sDate.AddMinutes(1);
                        }
                        else if (m_frmParent.rdoByHour.Checked == true)
                        {   //時間単位
                            a_sDate = a_sDate.AddHours(1);
                        }

                        //参照インデックス
                        m_frmParent.m_RainfallItems[0].NowIdx = a_RainfallIdx;
                        for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                        {
                            m_frmParent.m_WaterLevelItems[a_k - 1].NowIdx = a_WaterLevelIdx[a_k - 1];
                        }
                    }

                    /* 以前の処理
                    for (int a_iCnt = 1; a_iCnt <= dgvCondition.Rows.Count; a_iCnt++)
                    {
                        if (dgvCondition.Rows[a_iCnt - 1].Cells[0].Value != null)
                        {
                            String a_sKind = dgvCondition.Rows[a_iCnt - 1].Cells[0].Value.ToString();
                            float a_fLimit = 0;

                            for (int a_iCnt2 = 1; a_iCnt2 <= m_BaseDataItems.Count; a_iCnt2++)
                            {
                                if (m_BaseDataItems[a_iCnt2 - 1].Val1.Equals(a_sKind) == true)
                                {
                                    a_fLimit = Convert.ToSingle(m_BaseDataItems[a_iCnt2 - 1].Val2);
                                    break;
                                }
                            }

                            if (a_sKind.Equals("降雨強度(mm/hr)") == true)
                            {
                                try
                                {
                                    if (m_frmParent.m_RainfallItems != null)
                                    {
                                        for (int a_i = 1; a_i <= m_frmParent.m_RainfallItems[0].Count; a_i++)
                                        {
                                            if (m_frmParent.m_RainfallItems[0][a_i - 1].Rainfall >= a_fLimit)
                                            {   //リスク表示
                                                string[] a_item = {
                                                               m_frmParent.m_RainfallItems[0].FileName,
                                                               m_frmParent.m_RainfallItems[0][a_i - 1].sTimeOrDay,
                                                               "降雨強度(mm/hr)",
                                                               a_fLimit.ToString() + "(mm/hr)を超えました。"
                                                              };
                                                lstAlert.Items.Add(new ListViewItem(a_item));
                                            }
                                        }
                                    }
                                }
                                catch (Exception exp)
                                {
                                    Console.WriteLine(exp.Message);
                                }
                            }
                            else if (a_sKind.Equals("流域平均(mm/hr)") == true)
                            {   //pending
                            }
                            else if ((a_sKind.Equals("水防団待機水位(m)") == true) ||
                                (a_sKind.Equals("氾濫注意水位(m)") == true) ||
                                (a_sKind.Equals("避難判断水位(m)") == true) ||
                                (a_sKind.Equals("氾濫危険水位(m)") == true) ||
                                (a_sKind.Equals("計画高水位(m)") == true) ||
                                (a_sKind.Equals("水位上昇量(m)") == true))
                            {
                                try
                                {
                                    if (m_frmParent.m_WaterLevelItems != null)
                                    {
                                        for (int a_k = 1; a_k <= m_frmParent.m_WaterLevelItems.Length; a_k++)
                                        {
                                            for (int a_i = 1; a_i <= m_frmParent.m_WaterLevelItems[a_k - 1].Count; a_i++)
                                            {
                                                if (m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 1].WaterLevel >= a_fLimit)
                                                {   //リスク表示
                                                    string[] a_item = {
                                                                  m_frmParent.m_WaterLevelItems[a_k - 1].FileName,
                                                                  m_frmParent.m_WaterLevelItems[a_k - 1][a_i - 1].sTimeOrDay,
                                                                  a_sKind,
                                                                  a_fLimit.ToString() + "(m)を超えました。"
                                                                  };
                                                    lstAlert.Items.Add(new ListViewItem(a_item));
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (Exception exp)
                                {
                                    Console.WriteLine(exp.Message);
                                }
                            }
                        }
                    }
                     */
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary>
        /// フォームロード
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void McGraphRiskView_Load(object sender, EventArgs e)
        {
            this.Top = 100;
            this.Left = 100;

            this.dgvCondition.Rows[0].Cells[2].ReadOnly = true; //[2010.03.22]

            //期間表示
            lblDateTime.Text = string.Format("{0:yyyy/MM/dd HH:mm} ～ {1:yyyy/MM/dd HH:mm}", m_frmParent.m_DtStart, m_frmParent.m_DtEnd);
        }

        /// <summary><para>method outline:</para>
        /// <para>一覧クリック時処理</para>
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        private void dgvCondition_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.ColumnIndex < 0 || e.RowIndex < 0)
                return; //ヘッダーは処理なし

            DataGridView dgv = (DataGridView)sender;
            if (dgv.Columns[e.ColumnIndex].Name == "Delete" && e.RowIndex < dgv.Rows.Count - 1)
            {
                string sMsg = string.Format("{0}[ {1} ]を削除します。よろしいですか？", dgv.Columns[0].HeaderText.Replace("\n", ""), dgv.Rows[e.RowIndex].Cells[0].Value);
                if (MessageBox.Show(sMsg, "一覧", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    //削除ﾎﾞﾀﾝｸﾘｯｸ時、行削除
                    dgv.Rows.RemoveAt(e.RowIndex);

                    if (e.RowIndex == 0)
                    {   //1行目削除の場合、新しく1行目になった行のAND/ORはクリアする
                        dgv[2, 0].Value = null;
                    }
                }
            }
        }

        //[2010.03.22]
        /// <summary>
        /// 一覧・セル編集時
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void dgvCondition_EditingControlShowing(object sender, DataGridViewEditingControlShowingEventArgs e)
        {
            //表示されているコントロールがDataGridViewComboBoxEditingControlか調べる
            if (e.Control is DataGridViewComboBoxEditingControl)
            {
                DataGridView a_dgv = (DataGridView)sender;

                m_dataGridViewNowIndex = a_dgv.CurrentRow.Index;
                if (m_dataGridViewNowIndex > 0)
                {
                    if (a_dgv.CurrentRow.Cells[2].Value == null)
                    {
                        a_dgv.CurrentRow.Cells[2].Value = "AND";
                    }
                }

                //該当する列か調べる
                if (a_dgv.CurrentCell.OwningColumn.Name == "DataKind")
                {
                    //編集のために表示されているコントロールを取得
                    this.m_dataGridViewComboBox =
                        (DataGridViewComboBoxEditingControl)e.Control;
                    //SelectedIndexChangedイベントハンドラを追加
                    this.m_dataGridViewComboBox.SelectedIndexChanged +=
                        new EventHandler(dataGridViewComboBox_SelectedIndexChanged);
                }
            }
        }

        //[2010.03.22]
        /// <summary>
        /// 一覧・セル編集終了時
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void dgvCondition_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            //SelectedIndexChangedイベントハンドラを削除
            if (this.m_dataGridViewComboBox != null)
            {
                m_dataGridViewNowIndex = e.RowIndex;
                this.m_dataGridViewComboBox.SelectedIndexChanged -=
                    new EventHandler(dataGridViewComboBox_SelectedIndexChanged);
                this.m_dataGridViewComboBox = null;
            }
        }

        //[2010.03.22]
        /// <summary>
        /// DataGridViewに表示されているコンボボックスのSelectedIndexChangedイベントハンドラ
        /// </summary>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        private void dataGridViewComboBox_SelectedIndexChanged(object sender,
            EventArgs e)
        {
            //選択されたアイテムを表示
            DataGridViewComboBoxEditingControl a_cb =
                (DataGridViewComboBoxEditingControl)sender;
            Console.WriteLine(a_cb.SelectedItem);
            dgvCondition.Rows[m_dataGridViewNowIndex].Cells[0].Value = a_cb.SelectedItem.ToString();
            _setLimitInGridView();
        }
    }
}
