﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　グラフ設定画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class HySEvSetForm : Form
    {
        /// <summary>メインフォームの情報</summary>
        private HySDotNetLineGraphForm m_csForm = null;

        /// <summary>デファイン情報</summary>
        private HySEvViewDefine m_csDefine = null;

        /// <summary>デファイン情報の取得</summary>
        public HySEvViewDefine Define
        {
            set
            {
                m_csDefine = value;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEvSetForm() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>通常使わない</para>
        /// </remarks>
        public HySEvSetForm()
        {
            InitializeComponent();
        }

        //コンストラクタ
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEvSetForm csHySEvSetForm = new HySEvSetForm(csForm) </para>
        /// </example>
        /// <param name="csForm">HySDotNetLineGraphForm</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEvSetForm(HySDotNetLineGraphForm csForm)
        {
            InitializeComponent();
            m_csForm = csForm;
        }


        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>btnSetGraph_Click(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            try
            {
                bool bFlag = true;
                txtWaterLevel_MaxY.BackColor = Color.White;
                txtWaterLevel_MinY.BackColor = Color.White;
                txtFlowMeter_MaxY.BackColor = Color.White;
                txtFlowMeter_MinY.BackColor = Color.White;

                //左軸
                if (txtWaterLevel_MaxY.Text.Trim().Length > 0)
                {
                    if (float.TryParse(txtWaterLevel_MaxY.Text.Trim(), out m_csDefine.g_WaterLevel_MaxY))
                    {
                        if (LeftNumberRangeCheck(m_csDefine.g_WaterLevel_MaxY) == -1)
                        {
                            txtWaterLevel_MaxY.BackColor = Color.Red;
                            bFlag = false;
                        }
                    }
                    else
                    {
                        txtWaterLevel_MaxY.BackColor = Color.Red;
                        m_csDefine.g_WaterLevel_MaxY = HySEvViewDefine.g_InvalidValue;
                        bFlag = false;
                    }
                }
                else
                {
                    m_csDefine.g_WaterLevel_MaxY = HySEvViewDefine.g_InvalidValue;
                }
                if (txtWaterLevel_MinY.Text.Trim().Length > 0)
                {
                    if (float.TryParse(txtWaterLevel_MinY.Text.Trim(), out m_csDefine.g_WaterLevel_MinY))
                    {
                        if (LeftNumberRangeCheck(m_csDefine.g_WaterLevel_MinY) == -1)
                        {
                            txtWaterLevel_MinY.BackColor = Color.Red;
                            bFlag = false;
                        }
                    }
                    else
                    {
                        txtWaterLevel_MinY.BackColor = Color.Red;
                        m_csDefine.g_WaterLevel_MinY = HySEvViewDefine.g_InvalidValue;
                        bFlag = false;
                    }
                }
                else
                {
                    m_csDefine.g_WaterLevel_MinY = HySEvViewDefine.g_InvalidValue;
                }

                //右軸
                if (txtFlowMeter_MaxY.Text.Trim().Length > 0)
                {
                    if (float.TryParse(txtFlowMeter_MaxY.Text.Trim(), out m_csDefine.g_FlowMeter_MaxY))
                    {
                        if (RightNumberRangeCheck(m_csDefine.g_FlowMeter_MaxY) == -1)
                        {
                            txtFlowMeter_MaxY.BackColor = Color.Red;
                            bFlag = false;
                        }
                    }
                    else
                    {
                        txtFlowMeter_MaxY.BackColor = Color.Red;
                        m_csDefine.g_FlowMeter_MaxY = HySEvViewDefine.g_InvalidValue;
                        bFlag = false;
                    }
                }
                else
                {
                    m_csDefine.g_FlowMeter_MaxY = HySEvViewDefine.g_InvalidValue;
                }
                if (txtFlowMeter_MinY.Text.Trim().Length > 0)
                {
                    if (float.TryParse(txtFlowMeter_MinY.Text.Trim(), out m_csDefine.g_FlowMeter_MinY))
                    {
                        if (RightNumberRangeCheck(m_csDefine.g_FlowMeter_MinY) == -1)
                        {
                            txtFlowMeter_MinY.BackColor = Color.Red;
                            bFlag = false;
                        }
                    }
                    else
                    {
                        txtFlowMeter_MinY.BackColor = Color.Red;
                        m_csDefine.g_FlowMeter_MinY = HySEvViewDefine.g_InvalidValue;
                        bFlag = false;
                    }
                }
                else
                {
                    m_csDefine.g_FlowMeter_MinY = HySEvViewDefine.g_InvalidValue;
                }



                if (YA_Auto_rbtn.Checked == false)
                {

                    if (bFlag == false)
                    {
                        return;
                    }

                    if (txtWaterLevel_MaxY.Text.Trim().Length > 0 && txtWaterLevel_MinY.Text.Trim().Length > 0)
                    {
                        if (Convert.ToSingle(txtWaterLevel_MaxY.Text.Trim()) <= Convert.ToSingle(txtWaterLevel_MinY.Text.Trim()))
                        {
                            //MessageBox.Show("左軸の入力数値が間違っています");
                            txtWaterLevel_MaxY.BackColor = Color.Red;
                            txtWaterLevel_MinY.BackColor = Color.Red;
                            return;
                        }
                    }
                    if (txtFlowMeter_MaxY.Text.Trim().Length > 0 && txtFlowMeter_MinY.Text.Trim().Length > 0)
                    {
                        if (Convert.ToSingle(txtFlowMeter_MaxY.Text.Trim()) <= Convert.ToSingle(txtFlowMeter_MinY.Text.Trim()))
                        {
                            //MessageBox.Show("右軸の入力数値が間違っています");
                            txtFlowMeter_MaxY.BackColor = Color.Red;
                            txtFlowMeter_MinY.BackColor = Color.Red;
                            return;
                        }
                    }
                }


                //設定状態の一時保存
                m_csDefine.g_bAutoStatus = StatusAuto_rbtn.Checked;
                m_csDefine.g_bAutoBounds = YA_Auto_rbtn.Checked;
                m_csDefine.g_sLeftLabel = LLabeltxtBox.Text;
                m_csDefine.g_sRightlabel = RLabeltxtBox.Text;

                this.Dispose();
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEvSetForm_Load(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySEvSetForm_Load(object sender, EventArgs e)
        {
            //雨量
            if (m_csDefine.g_Rainfall_MaxY != HySEvViewDefine.g_InvalidValue)
            {
                //txtRainfall_MaxY.Text = HySEvViewDefine.g_Rainfall_MaxY.ToString();
            }
            if (m_csDefine.g_Rainfall_MinY != HySEvViewDefine.g_InvalidValue)
            {
                //txtRainfall_MinY.Text = HySEvViewDefine.g_Rainfall_MinY.ToString();
            }

            //水位
            if (m_csDefine.g_WaterLevel_MaxY != HySEvViewDefine.g_InvalidValue)
            {
                txtWaterLevel_MaxY.Text = m_csDefine.g_WaterLevel_MaxY.ToString();
            }
            if (m_csDefine.g_WaterLevel_MinY != HySEvViewDefine.g_InvalidValue)
            {
                txtWaterLevel_MinY.Text = m_csDefine.g_WaterLevel_MinY.ToString();
            }

            //流量
            if (m_csDefine.g_FlowMeter_MaxY != HySEvViewDefine.g_InvalidValue)
            {
                txtFlowMeter_MaxY.Text = m_csDefine.g_FlowMeter_MaxY.ToString();
            }
            if (m_csDefine.g_FlowMeter_MinY != HySEvViewDefine.g_InvalidValue)
            {
                txtFlowMeter_MinY.Text = m_csDefine.g_FlowMeter_MinY.ToString();
            }

            //自動保存のチェック
            StatusAuto_rbtn.Checked = m_csDefine.g_bAutoStatus;
            if (StatusAuto_rbtn.Checked == true)
            {
                StatusAuto_rbtn_CheckedChanged(sender, e);
                StatusAuto_rbtn.Select();
            }
            else if (StatusAuto_rbtn.Checked == false)
            {
                StatusManual_rbtn_CheckedChanged(sender, e);
                StatusManual_rbtn.Select();
            }

            //Y軸範囲の自動化のチェック
            YA_Auto_rbtn.Checked = m_csDefine.g_bAutoBounds;
            if (YA_Auto_rbtn.Checked == true)
            {
                YA_Auto_rbtn_CheckedChanged(sender, e);
                YA_Auto_rbtn.Select();
            }
            else if (YA_Auto_rbtn.Checked == false)
            {
                YA_Manual_rbtn_CheckedChanged(sender, e);
                YA_Manual_rbtn.Select();
            }

            //ラベル
            LLabeltxtBox.Text = m_csDefine.g_sLeftLabel;
            RLabeltxtBox.Text = m_csDefine.g_sRightlabel;
        }


        /// <summary><para>method outline:</para>
        /// <para>設定のキャンセル</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CancelBtn_Click(sender, e)：キャンセルボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CancelBtn_Click(object sender, EventArgs e)
        {
            //何もせずに閉じる
            this.Dispose();
        }


        /// <summary><para>method outline:</para>
        /// <para>状態の保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StatusMemoryBtn_Click(sender, e)：状態の保存ボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void StatusMemoryBtn_Click(object sender, EventArgs e)
        {
            m_csForm.SetGraphInformation();
        }


        /// <summary><para>method outline:</para>
        /// <para>自動保存の有効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StatusAuto_rbtn_CheckedChanged(sender, e)：状態の保存の自動ラジオボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void StatusAuto_rbtn_CheckedChanged(object sender, EventArgs e)
        {
            //状態の保存ボタンの使用禁止
            StatusMemoryBtn.Enabled = false;
        }


        /// <summary><para>method outline:</para>
        /// <para>自動保存の無効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StatusManual_rbtn_CheckedChanged(sender, e)：状態の保存の手動ラジオボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>状態の保存ボタンを有効にする</para>
        /// </remarks>
        private void StatusManual_rbtn_CheckedChanged(object sender, EventArgs e)
        {
            //状態の保存ボタンの有効化
            StatusMemoryBtn.Enabled = true;

        }


        /// <summary><para>method outline:</para>
        /// <para>Y軸の軸計算の自動化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YA_Auto_rbtn_CheckedChanged(sender, e)：Y軸設定の自動ラジオボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YA_Auto_rbtn_CheckedChanged(object sender, EventArgs e)
        {
            txtFlowMeter_MaxY.Enabled = false;
            txtFlowMeter_MinY.Enabled = false;
            txtWaterLevel_MaxY.Enabled = false;
            txtWaterLevel_MinY.Enabled = false;
        }



        /// <summary><para>method outline:</para>
        /// <para>Y軸の軸計算の手動化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YA_Manual_rbtn_CheckedChanged(sender, e)：Y軸設定の手動ラジオボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YA_Manual_rbtn_CheckedChanged(object sender, EventArgs e)
        {
            txtFlowMeter_MaxY.Enabled = true;
            txtFlowMeter_MinY.Enabled = true;
            txtWaterLevel_MaxY.Enabled = true;
            txtWaterLevel_MinY.Enabled = true;
        }


        /// <summary><para>method outline:</para>
        /// <para>左軸領域チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int i = LeftNumberRangeCheck(num)：</para>
        /// </example>
        /// <param name="num">float</param>
        /// <returns>int 0：正常，-1：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>-900から9000を正常とする</para>
        /// </remarks>
        private int LeftNumberRangeCheck(float num)
        {
            if (num <= 9000 && num >= -900)
            {
                return 0;
            }
            else
            {
                return -1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>右軸領域チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int i = RightNumberRangeCheck(num)：</para>
        /// </example>
        /// <param name="num">float</param>
        /// <returns>int 0：正常，-1：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>-9000から90000までを正常とする</para>
        /// </remarks>
        private int RightNumberRangeCheck(float num)
        {
            if (num <= 90000 && num >= -9000)
            {
                return 0;
            }
            else
            {
                return -1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>設定の終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEvSetForm_FormClosed(sender, e)：×ボタンクリック</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">FormClosedEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySEvSetForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //何もせずに閉じる
            this.Dispose();
        }
    }
}
