﻿// <summary>ソースコード：メイン画面フォームクラス</summary>
// <author>CommonMP</author>


//using System.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{   
    /// <summary><para>class outline:</para>
    /// <para>メイン画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public partial class HySGISResultDispCtlForm : HySDotNetAddInBaseForm, HySViewForm //HySDotNetForm//Form
    {
        /// <summary>ビューアクラス </summary>
        protected HySDotNetViewer m_csViewer = null;
        /// <summary>.net メインフォームクラス </summary>
        protected HySDotNetMainForm m_csMainForm = null;

        /// <summary>GIS計算結果表示制御用画面 </summary>
        HySGISResultDispCtlScreen m_csDispCtlScreen;

        /// <summary> ＧＩＳビューア内制御クラス </summary>
        protected HySGISCtlViewerSubJob m_csCtlJob = null;

        /// <summary> データファイル取得確認用ハッシュ </summary>
        protected HySDataHashTable m_csInputFileChkTable = null;

        /// <summary> ダイアログで指定されたファイル名称 </summary>
        private string sReadFileName;

        /// <summary>閉じるボタンを無効化 </summary>
        protected override System.Windows.Forms.CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;

                // ClassStyle に CS_NOCLOSE ビットを立てる
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMainForm csDotNetForm = new HySDotNetMainForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISResultDispCtlForm() :base(null)
        {
            m_csInputFileChkTable = new HySDataHashTable();


            InitializeComponent();

            //IntPtr hMenu = GetSystemMenu(this.Handle, 0);
            //RemoveMenu(hMenu, SC_CLOSE, MF_BYCOMMAND);


            // サイズ変更抑止
            this.MinimumSize = new System.Drawing.Size(331, 722);
            this.MaximumSize = new System.Drawing.Size(331, 722);

            // DataGridViewの初期処理
            // 複数行選択禁止
            DataSelectGridView.MultiSelect = false;
            // 列幅調整
            DataGridViewCheckBoxColumn checkColumn = (DataGridViewCheckBoxColumn)DataSelectGridView.Columns[0];
            checkColumn.Width = 45;
            
            // Buttonの初期処理
            // 非活性
            MapDispButton.Enabled = false;
            KMLOutButton.Enabled = false;

        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>スクリーンクラスインスタンスを設定する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetScreen(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void SetScreen(HySScreen csScreen)
        {
            base.SetScreen(csScreen);
            m_csDispCtlScreen = csScreen as HySGISResultDispCtlScreen;
            HySDispViewerJob csJob = m_csDispCtlScreen.GetViewerJob() as HySDispViewerJob;
            if (csJob != null)
            {
                m_csCtlJob = csJob.GetGISCtlJob();
            }
            m_csViewer = m_csDispCtlScreen.GetViewer() as HySDotNetViewer;
            if (m_csViewer != null)
            {
                m_csMainForm = m_csViewer.GetMainForm();
                this.Owner = m_csMainForm;
                this.BringToFront();
            }
        }
     
        /// <summary>
        /// <para>method outline:</para>
        /// <para>地図表示イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispMapCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispMapCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;

            HySSelectDataInf csSlctInf = null;
            //[追加]選択した項目の番号を格納するリスト型変数
            List<long> lItemNoBuffer = new List<long>();
            //[追加]項目の取得もとファイル名格納変数
            string fileNameWithPath = null;
            for (int iLp = 0; iLp < DataSelectGridView.RowCount; iLp++)
            {
                if ((bool)DataSelectGridView[0, iLp].Value == true)
                {
                    string sItemNo = (string)DataSelectGridView["ItemNo", iLp].Value;
                    long lItemNo = 0;
                    long.TryParse(sItemNo, out lItemNo);
                    //[追加]選択した項目番号を変数に追加
                    lItemNoBuffer.Add(lItemNo);
                    //[追加]項目の取得元ファイル名を格納
                    fileNameWithPath = (string)DataSelectGridView[3, iLp].Value;

                    //[変更]リストの選択状態をすべて確認してからオブジェクト生成を行うためコメントアウト
                    //csSlctInf = new HySSelectDataInf((string)DataSelectGridView[3, iLp].Value, lItemNo);
                }

            }
            //[追加]ファイル名がnullの場合はオブジェクト生成を行わない
            if (fileNameWithPath != null)
            {
                csSlctInf = new HySSelectDataInf(fileNameWithPath, lItemNoBuffer.ToArray());
            }

            if (csSlctInf != null)
            {
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, HySGISCtlDefine.DISP_2D_MESH);

                csEvent.SetData(csSlctInf);
                bRtn = m_csCtlJob.EventCallback(csEvent);
                if (bRtn == false)
                {
                    // 処理異常
                    // メッセージ表示
                    //MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_ERR_KML_PROCESSING"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

            }

        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＫＭＬ出力イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispMapCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void KMLOutCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;

// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） >>
            int count = 0;

            for (int iLp = 0; iLp < DataSelectGridView.RowCount; iLp++)
            {
                if ((bool)DataSelectGridView[0, iLp].Value == true)
                {
                    count++;
                }
            }

            if (count > 1)
            {
                // 複数の出力はできません。１件を選択してください。
                MessageBox.Show(HysMessage.GetString("HYS_MSG_WARNING_SELECT"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） <<

            SaveFileDialog csSaveFileDlg = new SaveFileDialog();
            csSaveFileDlg.FileName = ".kml";
            csSaveFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() +"\\";
            csSaveFileDlg.Filter = Properties.HysDotNetViewerResources.FILE_DLG_FILTER_KML;//"KML(*.kml)|*.kml";
            csSaveFileDlg.Title = Properties.HysDotNetViewerResources.FILE_DLG_TITLE_SELECT_KML_FILE;//"KML出力ファイルの設定（時系列の場合には複数のファイルに自動分割されます）";
            csSaveFileDlg.RestoreDirectory = true;
            
            if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csSaveFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合

                    HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON, HySGISCtlDefine.KML_OUT);
                    # region
                    ////此処ではダミー値を入れておく　、実際は画面から選択された情報を持つ事
                    //string sFileName = sReadFileName; // " 選択されたファイル名称";
                    //;
                    //long lItemNo = 0;  // <-- 選択されたデータのセル内の位置（０相対）
                 
                    //// 選択情報格納データを作成
                    //HySSelectDataInf csSlctInf = new HySSelectDataInf(sFileName, lItemNo); 
                    # endregion
                    // 画面上で選択された情報取得
                    //HySSelectDataInf csSlctInf = (HySSelectDataInf)m_csRowLinkedInputData[m_csRowNo];

                    HySSelectDataInf csSlctInf = null;
                    //[追加]選択した項目の番号を格納するリスト型変数
                    List<long> lItemNoBuffer = new List<long>();
                    //[追加]項目の取得もとファイル名格納変数
                    string fileNameWithPath = null;
                    for (int iLp = 0; iLp < DataSelectGridView.RowCount; iLp++)
                    {
                        if ((bool)DataSelectGridView[0, iLp].Value == true)
                        {
                            string sItemNo = (string)DataSelectGridView["ItemNo", iLp].Value;
                            long lItemNo = 0;
                            long.TryParse(sItemNo, out lItemNo);
                            //[追加]選択した項目番号を変数に追加
                            lItemNoBuffer.Add(lItemNo);
                            //[追加]項目の取得元ファイル名を格納
                            fileNameWithPath = (string)DataSelectGridView[3, iLp].Value;

                            //[変更]リストの選択状態をすべて確認してからオブジェクト生成を行うためコメントアウト
                            //csSlctInf = new HySSelectDataInf((string)DataSelectGridView[3, iLp].Value, lItemNo);
                        }
                    }
                    //[追加]ファイル名がnullの場合はオブジェクト生成を行わない
                    if (fileNameWithPath != null)
                    {
                        csSlctInf = new HySSelectDataInf(fileNameWithPath, lItemNoBuffer.ToArray());
                    }

                    if (csSlctInf != null)
                    {
                        csEvent.SetData(csSlctInf);


                        //csEvent.SetSubEventNo(HySID.NOTICE_SCREEN_DISPLAY);
                        //csEvent.SetData(HySDefine.DISP_FORM_GIS2D_MESH);

                        HySString csKMLName = new HySString(csSaveFileDlg.FileName); // 出力するＫＭＬファイル名
                        csEvent.SetSubData(csKMLName);

                        bRtn = m_csCtlJob.EventCallback(csEvent);
                        if (bRtn == false)
                        {
                            // 処理異常
                            // メッセージ表示
                            //MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            MessageBox.Show(HysMessage.GetString("HYS_MSG_ERR_KML_PROCESSING"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                            // コントロール有効
                            this.Enabled = true;
                            return;
                        }
                    }
                    // 監視開始
                    CheckKMLFileOutTimer.Enabled = true;

                }
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示用データファイル取得イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispFileSelectCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispFileSelectCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;
            OpenFileDialog csReadFileDlg = new OpenFileDialog();
            
            csReadFileDlg.FileName = ".d2gis";
            csReadFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() + "\\";
            csReadFileDlg.Filter = Properties.HysDotNetViewerResources.FILE_DLG_FILTER_D2GIS;//"D2GIS(*.d2gis)|*.d2gis";
            csReadFileDlg.Title = Properties.HysDotNetViewerResources.FILE_DLG_TITLE_SELECT_2DGIS_FILE;//"表示用２次元メッシュデータファイル取得";
            csReadFileDlg.RestoreDirectory = true;
            if (csReadFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csReadFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合
                    sReadFileName = csReadFileDlg.FileName;
                    // 取得データ重複確認
                    if (m_csInputFileChkTable.GetObject(new HySString(sReadFileName)) != null)
                    {
                        // 重複有り
                        // メッセージ表示
                        //MessageBox.Show("選択されたデータファイルは既に取得されています。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_OVERRLAP_KML_DATA"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return;
                    }
                    // テーブル生成処理
                    bRtn = this.CreateDataSelectTable(new HySString(sReadFileName));
                    if (bRtn == false)
                    {
                        // 処理異常
                        // メッセージ表示
                        //MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        MessageBox.Show(HysMessage.GetString("HYS_MSG_ERR_KML_PROCESSING"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                    // 入力ファイルフルパス表示
                    this.InputFileNameBox.Text = sReadFileName;
                    // 右端表示(長いフルパスでもファイル名が認識できるよう)
                    this.InputFileNameBox.SelectAll();
                    int idx = this.InputFileNameBox.SelectionLength;
                    this.InputFileNameBox.SelectionStart = idx;
                    # region
                    /*
                    HySString csDispDataName = new HySString(csReadFileDlg.FileName);
                    HySFile csFile = new HySFile(csDispDataName);
                    csFile.Open(HySFile.OPEN_MODE.OPEN,HySFile.READ_WRITE_MODE.READ,HySFile.DIRECTORY_MODE.NOT_MK_DIR);

                    HySGeoDim2MeshSerialData m_dmyDispData = null;

                    m_dmyDispData = HySGeoDim2MeshSerialData.CSVHeaderRead(csFile);
                    if (m_dmyDispData != null)
                    {
                        m_dmyDispData.ReadCSVFileDataOnly(csFile);
                    }
                    csFile.Close();
                    */
                    # endregion
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EndButtonCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EndButtonCallBack(object sender, EventArgs e)
        {
            /*
            // 終了ＯＫかを問い合わせるメッセージボックス表示
            DialogResult result = MessageBox.Show("GIS表示を終了します。よろしいですか?", "GIS表示", MessageBoxButtons.OKCancel, MessageBoxIcon.Information);
            
            if (result == DialogResult.OK)
            {
                // 終了ＯＫならば、
                // アプリケーションの終了
                Application.Exit();
            }
            */
            this.Hide();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ選択用テーブル生成処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateDataSelectTable(csFileName)</para>
        /// </example>
        /// <param name="csFileName">入力ファイル名称</param>
        /// <returns>bool: true:正常終了, false:異常終了</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CreateDataSelectTable(HySString csFileName)
        {
            bool bRtn = true;
            try
            {
                // ファイルオープン
                HySFile csFile = new HySFile(csFileName);
                if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                {
                    // オープン処理異常
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable()",
                        Properties.HysDotNetViewerResources.STATEMENT_FILE_OPEN_NG);
                   // HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable()", "File Open Failed.");
                    return false;
                }
                HySGeoDim2MeshSerialData csD2MeshData = null;
                csD2MeshData = HySGeoDim2MeshSerialData.CSVHeaderRead(csFile);
                if (csD2MeshData != null)
                {
                    csD2MeshData.ReadCSVFileDataOnly(csFile);
                }
                else
                {
                    // データ生成処理異常
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable()",
                        Properties.HysDotNetViewerResources.STATEMENT_DATA_CREAT_NG);
                   // HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable()", "Data Create Failed.");
                    csFile.Close();
                    return false;
                }
                csFile.Close();
                // データ名称取得（もしくはデータ種別）
                HySDataCharacteristicInCell csCellCharactor = csD2MeshData.GetCellDataCharacteristic();
                // 生成処理
                bRtn = this.AddInputDataInfo(csCellCharactor, csFileName);
            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable",
                     Properties.HysDotNetViewerResources.STATEMENT_ABEND + "(" + Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + ex.Message + ")");

               // HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.CreateDataSelectTable", "Abend  (catch exception  " + ex.Message + ")");

                bRtn = false;
            }
            return bRtn;
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力データ情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddInputDataInfo(csCellCharactor, csFileName)</para>
        /// </example>
        /// <param name="csCellCharactor">セル内データ</param>
        /// <param name="csFileName">入力ファイル名称</param>
        /// <returns>bool: true:正常終了, false:異常終了</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool AddInputDataInfo(HySDataCharacteristicInCell csCellCharactor, HySString csFileName)
        {
            bool bRtn = true;
            try
            {
                // 保持データ数確認
                int iDataNum = csCellCharactor.m_csDataKind.Length;
                // 現在の行数確認
                int iRowCount = DataSelectGridView.Rows.Count;
                // 行追加(現在の行数～)
                DataSelectGridView.Rows.Add(iDataNum);
                // データ名称取得/設定
                for (int iLp = 0; iLp < iDataNum; iLp++)
                {
                    string sDataName = csCellCharactor.m_csLabel[iLp];
                    if (sDataName == "")
                    {
                        // 名称がなければデータ種別使用
                        HySObjectKind csKind = csCellCharactor.m_csDataKind[iLp];
                        sDataName = csKind.ToString();
                    }
                    // データ名称設定
                    DataSelectGridView[1, iRowCount + iLp].Value = sDataName;
                    // ファイル名称設定
                    string sFileName = System.IO.Path.GetFileName(csFileName.ToString());
                    DataSelectGridView[2, iRowCount + iLp].Value = sFileName;
                    // フルパス名称設定
                    DataSelectGridView[3, iRowCount + iLp].Value = csFileName.ToString();
                    
                    // フルパス名称設定
                    DataSelectGridView["ItemNo", iRowCount + iLp].Value = iLp.ToString();

                    // 設定済みファイル名称の記憶
                    m_csInputFileChkTable.AddObject(csFileName, csFileName);
                    // チェックボックスON/OFF判断の為の値設定
                    DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[iRowCount + iLp].Cells[0] as DataGridViewCheckBoxCell;
                    cell.Value = false;
                    //// 選択行と入力データの対応付け記憶
                    //HySSelectDataInf csDataInf = new HySSelectDataInf(csFileName.ToString(), (long)iLp);
                    //m_csRowLinkedInputData.AddObject(new HySString((iRowCount + iLp).ToString()), csDataInf);
                }
            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.AddInputDataInfo",
                    Properties.HysDotNetViewerResources.STATEMENT_ABEND + "(" + Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "HySGISResultDispCtlForm.AddInputDataInfo", "Abend  (catch exception  " + ex.Message + ")");
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セルクリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 入力ファイルフルパス表示
            DataGridViewTextBoxCell TextCell = DataSelectGridView.Rows[e.RowIndex].Cells[3] as DataGridViewTextBoxCell;
            HySString csFullPath = new HySString((string)TextCell.Value);
            this.InputFileNameBox.Text = csFullPath.ToString();
            // 右端表示(長いフルパスでもファイル名が認識できるよう)
            this.InputFileNameBox.SelectAll();
            int idx = this.InputFileNameBox.SelectionLength;
            this.InputFileNameBox.SelectionStart = idx;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル内容クリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 「選択」列ならば
            if (e.ColumnIndex == 0)
            {
                // チェック選択状態をクリア
                //this.ClearSelected(e.RowIndex);
                // チェックボックスのON/OFF実施
                DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[e.RowIndex].Cells[e.ColumnIndex] as DataGridViewCheckBoxCell;
                cell.Value = !((bool)cell.Value);

// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） >>
                //// チェック済み行番号の設定とボタン制御
                //if ((bool)cell.Value == true)
                //{
                //    //m_csRowNo = new HySString(((e.RowIndex).ToString()));
                //    // 活性
                //    MapDispButton.Enabled = true;
                //    KMLOutButton.Enabled = true;
                //}
                //else
                //{
                //    // 非活性
                //    MapDispButton.Enabled = false;
                //    KMLOutButton.Enabled = false;
                //}

                // チェック項目が存在しているか判断しボタンを制御
                MapDispButton.Enabled = false;
                KMLOutButton.Enabled = false;

                for (int i = 0; i < DataSelectGridView.RowCount; i++)
                {
                    cell = DataSelectGridView.Rows[i].Cells[0] as DataGridViewCheckBoxCell;
                    if ((bool)cell.Value == true)
                    {
                        // チェック済み有り
                        MapDispButton.Enabled = true;
                        KMLOutButton.Enabled = true;
                        break;
                    }
                }
// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） <<

                if (DataSelectGridView.IsCurrentCellDirty)
                {
                    DataSelectGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル内容ダブルクリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellContentDoubleClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） >>
            DataSelectGridView_CellContentClick(sender, e);     // セル内容クリックイベント処理

            //// 列ヘッダクリック時対策
            //if (e.RowIndex == -1)
            //{
            //    return;
            //}
            //// 1行選択
            //DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            //// 「選択」列ならば
            //if (e.ColumnIndex == 0)
            //{
            //    // チェック選択状態をクリア
            //    this.ClearSelected(e.RowIndex);
            //    // チェックボックスのON/OFF実施
            //    DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[e.RowIndex].Cells[e.ColumnIndex] as DataGridViewCheckBoxCell;
            //    cell.Value = !((bool)cell.Value);
            //    // チェック済み行番号の設定とボタン制御
            //    if ((bool)cell.Value == true)
            //    {
            //        //m_csRowNo = new HySString(((e.RowIndex).ToString()));
            //        // 活性
            //        MapDispButton.Enabled = true;
            //        KMLOutButton.Enabled = true;
            //    }
            //    else
            //    {
            //        // 非活性
            //        MapDispButton.Enabled = false;
            //        KMLOutButton.Enabled = false;
            //    }
            //    if (DataSelectGridView.IsCurrentCellDirty)
            //    {
            //        DataSelectGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
            //    }
            //}
// Ver1.5 追加（ＧＩＳ表示データ選択画面複数チェック対応） <<
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックボックス選択状態クリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearSelected()</para>
        /// </example>
        /// <param name="index">選択行インデックス</param>
        /// <returns>bool: true: クリア実施 false: クリア未実施</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ClearSelected(int index)
        {
            bool bRtn = false;
            int iRowCount = DataSelectGridView.Rows.Count;
            for (int iLp = 0; iLp < iRowCount; iLp++)
            {
                // 選択行チェックボックスの状態は除外
                if (iLp != index)
                {
                    DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[iLp].Cells[0] as DataGridViewCheckBoxCell;
                    if ((bool)cell.Value == true)
                    {
                        // チェック済み有り
                        cell.Value = !((bool)cell.Value);
                        bRtn = true;
                        //break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectTabControl_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (DataSelectTabControl.SelectedTab == D3Mesh)
            {//初期設定タブを無効とする。
                DataSelectTabControl.SelectedTab = D2Mesh;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>セル入力フォーカス取得イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellEnter(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 入力ファイルフルパス表示
            DataGridViewTextBoxCell TextCell = DataSelectGridView.Rows[e.RowIndex].Cells[3] as DataGridViewTextBoxCell;
            HySString csFullPath = new HySString((string)TextCell.Value);
            this.InputFileNameBox.Text = csFullPath.ToString();
            // 右端表示(長いフルパスでもファイル名が認識できるよう)
            this.InputFileNameBox.SelectAll();
            int idx = this.InputFileNameBox.SelectionLength;
            this.InputFileNameBox.SelectionStart = idx;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>KML出力中監視タイマー</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckKMLTimer(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CheckKMLTimer(object sender, EventArgs e)
        {

            if (HySGISCtlViewerSubJob.KMLOUT_THREAD_WORK == true)
            {
                // KML出力処理開始
                this.Text = Properties.HysDotNetViewerResources.FORM_TITLE_OUTPUT_KML_FILE;//"KML出力中";
                // コントロール抑止
                this.Enabled = false;
            }
            else if (HySGISCtlViewerSubJob.KMLOUT_THREAD_WORK == false)
            {
                if (HySGISCtlViewerSubJob.KMLOUT_STATUS == true)
                {
                    // タイマ停止
                    CheckKMLFileOutTimer.Stop();
                    CheckKMLFileOutTimer.Enabled = false;
                    //MessageBox.Show("KML出力が完了しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_INFO_COMPLETE_OUTPUT_KML_FILE"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else if (HySGISCtlViewerSubJob.KMLOUT_STATUS == false)
                {
                    // タイマ停止
                    CheckKMLFileOutTimer.Stop();
                    CheckKMLFileOutTimer.Enabled = false;
                    //MessageBox.Show("処理中にエラーが発生したため、KML出力に失敗しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    MessageBox.Show(HysMessage.GetString("HYS_MSG_ERR_OUTPUT_KML_FILE"), HysMessage.GetString("HYS_MSG_TITLE_GISVIEW"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                
                // KML出力処理終了
                this.Text = "GIS表示データ選択";
                // コントロール有効
                this.Enabled = true;
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ項目削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteList(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeleteList(object sender, EventArgs e)
        {
            if (DataSelectGridView.SelectedRows.Count <= 0)
            {// 選択無しの場合は、処理無し
                return;
            }

            string csFullPath = (string)DataSelectGridView.SelectedRows[0].Cells[3].Value;
            m_csInputFileChkTable.DeleteData(new HySString(csFullPath));
            DataSelectGridView.ClearSelection();
            for (int iLp = DataSelectGridView.RowCount-1; iLp >= 0; iLp--)
            {
                if (csFullPath.Equals((string)DataSelectGridView[3, iLp].Value) == true)
                {// ファイル名が一致（フルパス）
                    if ((bool)DataSelectGridView[0, iLp].Value == true)
                    {// 非活性
                        MapDispButton.Enabled = false;
                        KMLOutButton.Enabled = false;
                    }
                    DataSelectGridView.Rows.RemoveAt(iLp);
                }
            }

            //　選択無しの場合、ファイル名称テキストボックスクリア
            if (DataSelectGridView.RowCount <= 0)
            {
                InputFileNameBox.Text = "";
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ項目全て削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllDeleteList(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllDeleteList(object sender, EventArgs e)
        {
            //管理情報クリア
            DataSelectGridView.Rows.Clear();
            m_csInputFileChkTable.ClearAllObject();
            InputFileNameBox.Text = "";

            // 非活性
            MapDispButton.Enabled = false;
            KMLOutButton.Enabled = false;
        }
    }
}
