﻿// <summary>ソースコード：画面フォーム基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>画面フォーム基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public partial class HySDotNetForm : Form, HySViewForm
    {
        /// <summary>スクリーンクラス</summary>
        protected HySScreen m_csScreen = null;

        /// <summary>自画面アクティブフラグ</summary>
        protected bool m_bActiveFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetForm csDotNetForm = new HySDotNetForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetForm()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>スクリーンクラスインスタンスを設定する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetScreen(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetScreen(HySScreen csScreen)
        {
            m_csScreen = csScreen;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>スクリーンクラスインスタンスを取得する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySScreen csScreen = GetScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreen スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected HySScreen GetScreen()
        {
            return m_csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>HySBusiProcedure クラスに対してイベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            if (m_csScreen != null)
            {
                return m_csScreen.PutEvent(csEvent);
            }
            else
            {
                return false;
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent()
        {

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetForm_Activated( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void HySDotNetForm_Activated(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
            m_bActiveFlg = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetForm_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void HySDotNetForm_Deactivate(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
            m_bActiveFlg = false;
        }

    }
}