﻿// <summary>ソースコード：メイン画面フォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>メイン画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public partial class HySDotNetMainForm : HySDotNetForm
    {
        ///// <summary>メッセージタイトル </summary>
        //static private readonly string MSGBOX_TITLE = "水・物質循環解析ソフトウェア共通基盤　CommonMP";
		/// <summary>メッセージタイトル『水・物質循環解析ソフトウェア共通基盤　CommonMP』 </summary>
		static private readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_COMMON_MP");
        /// <summary>メッセージ『シュミレーションモデルを計算中のため、閉じることができません。』</summary>
        static private readonly string MSGBOX_MSG_WARNING_SIMULATION_EXECUTE = HysMessage.GetString("HYS_MSG_WARNING_SIMULATION_EXECUTE");
        /// <summary>メッセージ『保存されていないプロジェクトがあります。\nシステムを終了してよろしいですか?』</summary>
        static private readonly string MSGBOX_MSG_QUESTION_CONFILM_END = HysMessage.GetString("HYS_MSG_QUESTION_CONFILM_END");

		///<summary>ステータスメッセージ『状態 』</summary>
		static private readonly string STATUS = HysMessage.GetString("HYS_MSG_STATUS_STATUS");
		///<summary>ステータスメッセージ『初期化終了 』</summary>
		static private readonly string  COMPLETE_FORMAT =HysMessage.GetString("HYS_MSG_STATUS_COMPLETE_FORMAT");
		///<summary>ステータスメッセージ『演算中 』</summary>
		static private readonly string RUN_SIMULATION = HysMessage.GetString("HYS_MSG_STATUS_RUN_SIMULATION");
		///<summary>ステータスメッセージ『演算終了 』</summary>
		static private readonly string COMPLETE_SIMULATION= HysMessage.GetString("HYS_MSG_STATUS_COMPLETE_SIMULATION");
		///<summary>ステータスメッセージ『演算異常終了 』</summary>
		static private readonly string ERR_COMPLETE_SIMULATION =HysMessage.GetString("HYS_MSG_STATUS_ERR_COMPLETE_SIMULATION");
		///<summary>ステータスメッセージ『演算中止 』</summary>
		static private readonly string  STOP_SIMULATION=HysMessage.GetString("HYS_MSG_STATUS_STOP_SIMULATION");
		///<summary>ステータスメッセージ『演算中断 』</summary>
		static private readonly string  TEMPORARY_STOP_SIMULATION=HysMessage.GetString("HYS_MSG_STATUS_TEMPORARY_STOP_SIMULATION");
		///<summary>ステータスメッセージ『演算開始失敗 』</summary>
		static private readonly string  ERR_RUN_SIMULATION =HysMessage.GetString("HYS_MSG_STATUS_ERR_RUN_SIMULATION");
		///<summary>ステータスメッセージ『モデル更新 』</summary>
		static private readonly string  RENEW_MODEL=HysMessage.GetString("HYS_MSG_STATUS_RENEW_MODEL");
		///<summary>ステータスメッセージ『モデル構築成功 』</summary>
		static private readonly string BUILD_MODEL = HysMessage.GetString("HYS_MSG_STATUS_BUILD_MODEL");
		///<summary>ステータスメッセージ『モデル構築失敗 』</summary>
		static private readonly string ERR_BUILD_MODEL=HysMessage.GetString("HYS_MSG_STATUS_ERR_BUILD_MODEL");
		///<summary>ステータスメッセージ『モデルセット 』</summary>
		static private readonly string RESET_MODEL=HysMessage.GetString("HYS_MSG_STATUS_RESET_MODEL");

        /// <summary>ツールストリップメニューアイテム管理テーブル</summary>
        protected Hashtable m_csMenuItemTbl;
        /// <summary>メニューアイテム管理</summary>
        protected HySViewerMenuCtl m_csViewrMenuCtl;
        /// <summary>メニュー</summary>
        protected System.Windows.Forms.MenuStrip m_csMenuStrip;
        /// <summary>ステータスバー</summary>
        protected System.Windows.Forms.StatusStrip m_csStatusStrip;
        /// <summary>ステータスラベル</summary>
        protected System.Windows.Forms.ToolStripStatusLabel m_csStatusLabel;
        /// <summary>ツールバー</summary>
        protected System.Windows.Forms.ToolTip m_csToolTip;
        ///// <summary>イベントタイマー</summary>
        //protected System.Windows.Forms.Timer m_csEventTimer;
        // スレッドタイマー
        /// <summary>スレッドタイマーインスタンス</summary>
        protected System.Threading.Timer m_csThreadTimerInstance = null;
        // スレッドタイマー方法1
        ///// <summary>スレッドタイマ処理デリゲート</summary>
        //delegate void EventThreadTimer_Delegate(object obj);
        ///// <summary>プログレスバー</summary>
        //private System.Windows.Forms.ToolStripProgressBar m_csProgressBar;

        /// <summary>メインビューア</summary>
        private HySViewer m_csMainViewer;

        /// <summary>タスクトレイにアニメで表示するアイコン</summary>
        protected Icon[] m_csTasktrayIcons;
        /// <summary>アニメで現在表示しているアイコンのインデックス</summary>
        protected int m_iTaskIconIndex = 0;


        //// <summary>タスクトレイに表示するアイコン</summary>
        //private System.Windows.Forms.NotifyIcon NotifyIcon;
        ///// <summary>タスクトレイアイコン表示周期</summary>
        //private System.Windows.Forms.Timer NotifyTimer;
        // スレッドタイマー
        /// <summary>タスクトレイアイコン表示周期(スレッドタイマーインスタンス)</summary>
        protected System.Threading.Timer m_csNotifyThreadTimer = null;
        // スレッドタイマー方法1
        ///// <summary>タスクトレイアイコン表示処理デリゲート</summary>
        //delegate void NotifyAnime_Delegate(object obj);
        // スレッドタイマー方法2
        ///// <summary>タイマースレッド動作フラグ</summary>
        //bool m_bThreadflg = false;
        ///// <summary>タイマースレッド動作フラグ</summary>
        //bool m_bNotifyIconThreadflg = false;
        ///// <summary>Formクローズフラグ</summary>
        //bool m_bFormCloseflg = false;
        /// <summary>非同期動作追跡クラス</summary>
        AsyncOperation m_csAO = null;
        /// <summary>非同期動作追跡クラス</summary>
        AsyncOperation m_csNotifyIconAO = null;
        /// <summary>タイマーメソッドデリゲート</summary>
        System.Threading.SendOrPostCallback m_d_PostCallback = null;
        /// <summary>タイマーメソッドデリゲート</summary>
        System.Threading.SendOrPostCallback m_d_NotifyIconPostCallback = null;
        // バックグラウンド操作化
        /// <summary>マスク対象イベント記憶</summary>
        HySDotNetViewerDefine.EventKind m_eState;
        /// <summary>外部データベースツール起動状態カウンタ</summary>
        private long m_lExtDBToolExecCount = 0;
        // ステータス表示 マルチスレッド対応
        /// <summary>ステータス表示管理テーブル</summary>
        private Hashtable m_csDispStatusTbl = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMainForm csDotNetForm = new HySDotNetMainForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySDotNetMainForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMainForm csDotNetForm = new HySDotNetMainForm(csViewr)</para>
        /// </example>
        /// <param name="csViewr">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetMainForm(HySViewer csViewr)
        {
            // ツールストリップメニューアイテム管理生成
            m_csMenuItemTbl = new Hashtable();
            // メニューアイテム管理生成
            m_csViewrMenuCtl = new HySViewerMenuCtl();
            // メニュー生成
            m_csViewrMenuCtl.CheckMenu(null);
            m_csViewrMenuCtl.GenerateMenu();
            // メニュー作成
            this.MakeMenu();
            InitializeComponent();
            // メインフレームのフォント設定
            m_csMenuStrip.Font = this.Font;
            m_csMainViewer = csViewr;

            //タスクトレイにアニメで表示するアイコンを指定する

            //アイコンリソースを取り出す
            Icon ico0 = Properties.Resources.CommonMP;
            Icon ico1 = Properties.Resources.CommonMP1;
            Icon ico2 = Properties.Resources.CommonMP2;
            Icon ico3 = Properties.Resources.CommonMP3;
            Icon ico4 = Properties.Resources.CommonMP4;
            this.m_iTaskIconIndex = 0;
            this.m_csTasktrayIcons = new Icon[] {
                new Icon(ico0, new System.Drawing.Size(32,32)),
                new Icon(ico1, new System.Drawing.Size(32,32)),
                new Icon(ico2, new System.Drawing.Size(32,32)),
                new Icon(ico3, new System.Drawing.Size(32,32)),
                new Icon(ico4, new System.Drawing.Size(32,32))};
            // ステータス表示管理生成
            m_csDispStatusTbl = new Hashtable();

        }

        /// <summary><para>method outline:</para>
        /// <para>チェックオン状態設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCheckOnFlg( lCallBackNo , bCheckflg) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <param name="bCheckflg">チェック状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCheckOnFlg(long lCallBackNo, Boolean bCheckflg)
        {
            ToolStripMenuItem csMenuItem = null;
            HySString csMenuText = new HySString("");
            csMenuText = m_csViewrMenuCtl.GetMenuText(lCallBackNo);
            if (csMenuText.ToString() != null)
            {
                csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csMenuText.ToString() + lCallBackNo.ToString()];
                if (csMenuItem != null)
                {
                    csMenuItem.Checked = bCheckflg;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックオン状態取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GetCheckOnFlg( lCallBackNo ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetCheckOnFlg(long lCallBackNo)
        {
            Boolean bRtn = false;
            ToolStripMenuItem csMenuItem = null;
            HySString csMenuText = new HySString("");
            csMenuText = m_csViewrMenuCtl.GetMenuText(lCallBackNo);
            if (csMenuText.ToString() != null)
            {
                csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csMenuText.ToString() + lCallBackNo.ToString()];
                if (csMenuItem != null)
                {
                    bRtn = csMenuItem.Checked;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MenuCallBack( sender,e ) </para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MenuCallBack(object sender, EventArgs e)
        {
            long lCallBackNo = 0;
            HySString csKindString = null;
            HySViewerMenuItem csMenuItem = null;
            ToolStripMenuItem csToolStripMenuItem = null;
            String csStr =  sender.ToString();
            // メニュー管理クラスからコールバック番号及び種別識別子文字を取得し、ビューアのコールバックをコールする
            //lCallBackNo = m_csViewrMenuCtl.GetCallBackNo(new HySString(csStr));
            lCallBackNo = Convert.ToInt32(((ToolStripMenuItem)sender).Name);
            csKindString = m_csViewrMenuCtl.GetKindString(new HySString(csStr),lCallBackNo);
            csMenuItem = m_csViewrMenuCtl.GetMenuItem(new HySString(csStr),lCallBackNo);
            //csToolStripMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csStr];
            csToolStripMenuItem = (ToolStripMenuItem)sender;
            ((HySDotNetViewer)m_csMainViewer).MenuCallBack(lCallBackNo, csKindString, csToolStripMenuItem.Checked);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MainFormLoadEvent( csSender,eEventArgs ) </para>
        /// </example>
        /// <param name="csSender"></param>
        /// <param name="eEventArgs"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MainFormLoadEvent(object csSender, EventArgs eEventArgs)
        {
            // 保存情報をもとにウィンドウ情報を復元
            this.MainFormSettingsLoad();
            // インターバルを２００ｍｓにセット
            //m_csEventTimer.Interval = 200;
            // タイマーを有効とする
            //m_csEventTimer.Enabled = true;
            // スレッドタイマー
            m_csThreadTimerInstance.Change(0, 200);
            // 業務にメイン画面起動完了を通知する。
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_MAINVIWER_RUN_COMPLETE);
            m_csMainViewer.PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントタイマー処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventTimer( csSender,eEventArgs ) </para>
        /// </example>
        /// <param name="csSender"></param>
        /// <param name="eEventArgs"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EventTimer(object csSender, EventArgs eEventArgs)
        {
            // メインビューアのイベント監視処理
            ((HySDotNetViewer)m_csMainViewer).EventWatch();
        }

        // スレッドタイマー
        # region 方法1
        ///// <summary><para>method outline:</para>
        ///// <para>イベントタイマー処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> EventThreadTimer( obj ) </para>
        ///// </example>
        ///// <param name="obj"></param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void EventThreadTimer(object obj)
        //{
        //    try
        //    {
        //        if (InvokeRequired == true)
        //        {
        //            EventThreadTimer_Delegate d_EventThreadTimer = new EventThreadTimer_Delegate(EventThreadTimer);
        //            object[] arg = new object[1];
        //            arg[0] = null;
        //            Invoke(d_EventThreadTimer, arg);
        //            return;
        //        }
        //        // メインビューアのイベント監視処理
        //        ((HySDotNetViewer)m_csMainViewer).EventWatch();
        //    }
        //    catch
        //    {
        //        // Formオブジェクトが破棄された後にスレッドタイマー処理（別スレッド）
        //        // からのコールによる例外発生を吸収する
        //    }
        //}
        # endregion
        # region 方法2
        /// <summary><para>method outline:</para>
        /// <para>スレッドタイマー処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ThreadTimer_Tick(object obj)
        {
            // 別スレッドから呼ばれる
            //m_bThreadflg = true;
            //if (m_bFormCloseflg == false)
            //{
            try
            {
                m_csAO.Post(m_d_PostCallback, null);
            }
            catch
            {
                // Formオブジェクトが破棄された後にスレッドタイマー処理（別スレッド）
                // からのコールによる例外発生を吸収する(フラグ処理は極力使用しない)
            }
            //}
            //m_bThreadflg = false;
        }
        /// <summary><para>method outline:</para>
        /// <para>タイマーからコールされる処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ThreadTimer_Work(object obj)
        {
            // Mainスレッドと同じ
            //if (m_bFormCloseflg == true)
            //{
            //    return;
            //}
            // メインビューアのイベント監視処理
            ((HySDotNetViewer)m_csMainViewer).EventWatch();
        }
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>メニュー作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeMenu( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeMenu()
        {
            long lLp = 0;
            IList csMenuList = new ArrayList();
            HySViewerMenuItem csMenuItem;
            ToolStripMenuItem csMainMenu;

            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(HySDotNetMainForm));
            m_csMenuStrip = new System.Windows.Forms.MenuStrip();

            long lNLevel = m_csViewrMenuCtl.GetMenuLevelCount();
            long lLevelCount = 1;
            long[] lIndex = new long[lNLevel];
            for (lLp = 0; lLp < m_csViewrMenuCtl.GetMainMenuCount(); lLp++)
            {
                // レベル１メニュー
                csMainMenu = new ToolStripMenuItem();
                csMenuItem = m_csViewrMenuCtl.GetMainMenuItem(lLp);
                if (csMenuItem.GetMenuDisp() == true)
                {
                    csMainMenu.Text = ((HySString)csMenuItem.GetMenuText()).ToString();
                    csMainMenu.Name = csMenuItem.GetCallBackNo().ToString();
                    csMainMenu.Enabled = csMenuItem.GetPatern(HySDotNetViewerDefine.EventKind.SYSTEMSTART);
                    m_csMenuItemTbl[csMainMenu.Text + csMainMenu.Name] = csMainMenu;
                    m_csMenuStrip.Items.AddRange(new ToolStripItem[] { csMainMenu });
                    if (csMenuItem.HasWindowList() == true)
                    {
                        // ウィンドウズリスト処理あり
                        m_csMenuStrip.MdiWindowListItem = csMainMenu;
                    }
                    lIndex[0] = lLp;
                    MakeChildMenu(lLevelCount + 1, lIndex, csMainMenu);
                }
            }
            m_csMenuStrip.Location = new System.Drawing.Point(0, 0);
            m_csMenuStrip.TabIndex = 0;

            // ステータスバー、ツールバー関連
            m_csStatusStrip = new System.Windows.Forms.StatusStrip();
            m_csStatusLabel = new System.Windows.Forms.ToolStripStatusLabel();
            m_csToolTip = new System.Windows.Forms.ToolTip(this.components);
            //m_csEventTimer = new System.Windows.Forms.Timer(this.components);
            // スレッドタイマー
            System.Threading.TimerCallback timerDelegate = new System.Threading.TimerCallback(ThreadTimer_Tick);
            // 更新間隔（初期値）
            // タイマーインスタンス生成（まだ開始しない）
            m_csThreadTimerInstance = new System.Threading.Timer(timerDelegate, null, System.Threading.Timeout.Infinite, 1000);
            m_csAO = AsyncOperationManager.CreateOperation(this);
            m_d_PostCallback = new System.Threading.SendOrPostCallback(ThreadTimer_Work);
            //this.NotifyIcon = new System.Windows.Forms.NotifyIcon(this.components);
            //this.NotifyTimer = new System.Windows.Forms.Timer(this.components);
            // スレッドタイマー
            System.Threading.TimerCallback notifytimerDelegate = new System.Threading.TimerCallback(NotifyIconThreadTimer_Tick);
            // 更新間隔（初期値）
            // タイマーインスタンス生成（まだ開始しない）
            m_csNotifyThreadTimer = new System.Threading.Timer(notifytimerDelegate, null, System.Threading.Timeout.Infinite, 1000);
            m_csNotifyIconAO = AsyncOperationManager.CreateOperation(this);
            m_d_NotifyIconPostCallback = new System.Threading.SendOrPostCallback(NotifyIconThreadTimer_Work);
            m_csMenuStrip.SuspendLayout();
            m_csStatusStrip.SuspendLayout();
            this.SuspendLayout();

            //m_csStatusStrip.Font = new System.Drawing.Font("ＭＳ ゴシック", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            m_csStatusStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            m_csStatusLabel});
            m_csStatusStrip.Location = new System.Drawing.Point(0, 968);
            m_csStatusStrip.Name = "StatusStrip";
            m_csStatusStrip.Size = new System.Drawing.Size(1272, 22);
            m_csStatusStrip.TabIndex = 2;
            m_csStatusStrip.Text = "StatusStrip";
            // 
            // StatusLabel
            // 
            //m_csStatusLabel.Text = "状態";

            // 
            // EventTimer
            // 
            //m_csEventTimer.Tick += new System.EventHandler(this.EventTimer);
            //
            // Load
            //
            this.Load += new System.EventHandler(this.MainFormLoadEvent);
            //
            // FormClosing
            //
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.MainFormClosingEvent);
            //
            // Shown
            //
            this.Shown += new System.EventHandler(this.MainFormShownEvent);

            // 
            // NotifyIcon
            // 
            //resources.ApplyResources(this.NotifyIcon, "NotifyIcon");
            
            // 
            // NotifyTimer
            // 
            //this.NotifyTimer.Interval = 1000;
            //this.NotifyTimer.Tick += new System.EventHandler(this.NotifyAnime);

            // 
            // HySDotNetMainForm
            // 
            resources.ApplyResources(this, "$this");
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("CmpNotifyIcon.Icon")));
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.ClientSize = new System.Drawing.Size(1272, 990);
            this.Controls.Add(this.m_csStatusStrip);
            this.Controls.Add(this.m_csMenuStrip);
            //this.Font = new System.Drawing.Font("ＭＳ ゴシック", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.IsMdiContainer = true;
            this.MainMenuStrip = this.m_csMenuStrip;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            //this.Text = "水・物質循環解析ソフトウェア共通基盤　CommonMP";
            this.m_csMenuStrip.ResumeLayout(false);
            this.m_csMenuStrip.PerformLayout();
            this.m_csStatusStrip.ResumeLayout(false);
            this.m_csStatusStrip.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();
        }

        /// <summary><para>method outline:</para>
        /// <para>子メニュー作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeChildMenu(csMenuItem,csParentMenu ) </para>
        /// </example>
        /// <param name="lLevelCount">メニューレベル</param>
        /// <param name="lIndex">メニューインデックス</param>
        /// <param name="csParentMenu">親メニュー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeChildMenu(long lLevelCount, long[] lIndex, ToolStripMenuItem csParentMenu)
        {
            HySViewerMenuItem csMenuItem;
            ToolStripMenuItem csChildMenu;
            ToolStripSeparator csSeparator;

            if (lLevelCount <= m_csViewrMenuCtl.GetMenuLevelCount())
            {
                // メニュー数取得
                long lNCount = m_csViewrMenuCtl.GetSubMenuCount(lLevelCount, lIndex);
                // レベル２メニュー
                for (long lLp = 0; lLp < lNCount; lLp++)
                {
                    lIndex[lLevelCount - 1] = lLp;
                    csMenuItem = m_csViewrMenuCtl.GetSubMenuItem(lLevelCount, lIndex);
                    if (csMenuItem.GetMenuDisp() == true)
                    {
                        if (csMenuItem.IsSeparator() == true)
                        {
                            // セパレータ
                            csSeparator = new ToolStripSeparator();
                            csParentMenu.DropDownItems.AddRange(new ToolStripItem[] { csSeparator });
                        }
                        else
                        {
                            // メニューアイテム
                            csChildMenu = new ToolStripMenuItem();
                            MakeChildMenu(csMenuItem, csParentMenu, csChildMenu);
                            MakeChildMenu(lLevelCount + 1, lIndex, csChildMenu);
                        }
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>子メニュー作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeChildMenu(csMenuItem,csParentMenu ) </para>
        /// </example>
        /// <param name="csMenuItem">メニューアイテム</param>
        /// <param name="csParentMenu">親メニュー</param>
        /// <param name="csChildMenu">子メニュー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeChildMenu(HySViewerMenuItem csMenuItem, ToolStripMenuItem csParentMenu, ToolStripMenuItem csChildMenu)
        {
            csChildMenu.Text = csMenuItem.GetMenuText().ToString();
            csChildMenu.Name = csMenuItem.GetCallBackNo().ToString();
            csChildMenu.Enabled = csMenuItem.GetPatern(HySDotNetViewerDefine.EventKind.SYSTEMSTART);
            m_csMenuItemTbl[csChildMenu.Text + csChildMenu.Name] = csChildMenu;
            csParentMenu.DropDownItems.AddRange(new ToolStripItem[] { csChildMenu });
            if (csMenuItem.HasCallBack() == true)
            {
                // コールバックあり
                csChildMenu.Click += new System.EventHandler(this.MenuCallBack);
            }
            if (csMenuItem.HasImage() == true)
            {
                // アイコン（イメージ）あり
                HySFile csFile = new HySFile(HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("MAIN_MENU_IMAGE_FOLDER")) + csMenuItem.GetImageName());
                if (csFile.Exist() == true)
                {
                    csChildMenu.Image = new Bitmap(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MAIN_MENU_IMAGE_FOLDER")).ToString() + csMenuItem.GetImageName().ToString());
                }
                csChildMenu.ImageTransparentColor = Color.White;
            }
            if (csMenuItem.HasShortCut() == true)
            {
                // ショートカットあり
                //if (csMenuItem.GetShortCut() >= 48 && csMenuItem.GetShortCut() <= 90)
                //    csChildMenu.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | (System.Windows.Forms.Keys)csMenuItem.GetShortCut())));
                //else
                try
                {
                    csChildMenu.ShortcutKeys = (System.Windows.Forms.Keys)csMenuItem.GetShortCut();
                }
                catch
                {
                }
            }
            if (csMenuItem.CheckOnClick() == true)
            {
                // チェックオン処理あり
                csChildMenu.CheckOnClick = true;

                if (csMenuItem.GetCheckOnClickDefault() == true)
                {
                    // チェックオンデフォルトtrue
                    csChildMenu.Checked = true;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面クローズ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MainFormClosingEvent( csSender,eEventArgs ) </para>
        /// </example>
        /// <param name="csSender"></param>
        /// <param name="eEventArgs"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MainFormClosingEvent(object csSender, FormClosingEventArgs eEventArgs)
        {
            HySEventObject csEventObj = null;

            if (eEventArgs.CloseReason == CloseReason.UserClosing)
            {
                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() == true)
                {
                    //MessageBox.Show("演算中のプロジェクトがあります", MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSGBOX_MSG_WARNING_SIMULATION_EXECUTE,MSGBOX_TITLE,MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
                }
                else
                {
                    if (((HySDotNetViewer)m_csMainViewer).CheckProjectSaved() == true)
                    {
                        csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SHUTDOWN_SYSTEM);
                        csEventObj.SetToSimKind(HySDefine.COMMON_SYS_BUSIPROCEDURE);
                        m_csMainViewer.PutEvent(csEventObj);
                    }
                    else
                    {
                        //DialogResult result = MessageBox.Show("保存されていないプロジェクトがあります。\nシステムを終了してよろしいですか?", MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2);
                        DialogResult result = MessageBox.Show(MSGBOX_MSG_QUESTION_CONFILM_END, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                        if (result == DialogResult.Yes)
                        {
                            csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SHUTDOWN_SYSTEM);
                            csEventObj.SetToSimKind(HySDefine.COMMON_SYS_BUSIPROCEDURE);
                            m_csMainViewer.PutEvent(csEventObj);
                        }
                    }
                }
                // 常にイベントをキャンセルする。（画面を閉じない）
                // アプリケーションの終了：Application.Exit()が最後にコールされ画面が終了する。
                eEventArgs.Cancel = true;
            }
            // ウィンドウ情報の保存
            this.MainFormSettingsSave();
        }

        /// <summary><para>method outline:</para>
        /// <para>マスクモード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaskMode( bMode,csMenuText,iIndex ) </para>
        /// </example>
        /// <param name="bMode">マスクモード（true:マスク、false:マスク解除）</param>
        /// <param name="csMenuText">メニューテキスト</param>
        /// <param name="iIndex">取り出し場所</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMaskMode(Boolean bMode, HySString csMenuText,int iIndex)
        {
            HySViewerMenuItem csViewerMenuItem;
            ToolStripMenuItem csMenuItem;
            csViewerMenuItem = m_csViewrMenuCtl.GetMenuItem(csMenuText, iIndex - 1);
            if(csViewerMenuItem != null)
            {
                csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csViewerMenuItem.GetMenuText().ToString() + csViewerMenuItem.GetCallBackNo().ToString()];
                csMenuItem.Enabled = bMode;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>マスクパターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaskPatern( lPtnNo ) </para>
        /// </example>
        /// <param name="lPtnNo">マスクパターン番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMaskPatern(long lPtnNo)
        {
            HySViewerMenuItem csViewerMenuItem;
            ToolStripMenuItem csMenuItem;
            Boolean bPtn = true;

            long lNLevel = m_csViewrMenuCtl.GetMenuLevelCount();
            long lLevelCount = 1;
            long[] lIndex = new long[lNLevel];
            for (long lLp = 0; lLp < m_csViewrMenuCtl.GetMainMenuCount(); lLp++)
            {
                // レベル１メニュー
                csViewerMenuItem = m_csViewrMenuCtl.GetMainMenuItem(lLp);
                csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csViewerMenuItem.GetMenuText().ToString() + csViewerMenuItem.GetCallBackNo().ToString()];
                bPtn = csViewerMenuItem.GetPatern(lPtnNo);
                if (csMenuItem != null)
                {
                    csMenuItem.Enabled = bPtn;
                }
                lIndex[0] = lLp;
                SetMaskPatern(lLevelCount + 1, lIndex, lPtnNo);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>マスクパターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaskPatern( eEvent ) </para>
        /// </example>
        /// <param name="lLevelCount">メニューレベル</param>
        /// <param name="lIndex">マスクメニュー位置</param>
        /// <param name="lPtnNo">マスクパターン番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetMaskPatern(long lLevelCount, long[] lIndex, long lPtnNo)
        {
            HySViewerMenuItem csViewerMenuItem;
            ToolStripMenuItem csMenuItem;
            Boolean bPtn = true;

            if (lLevelCount <= m_csViewrMenuCtl.GetMenuLevelCount())
            {
                // メニュー数取得
                long lNCount = m_csViewrMenuCtl.GetSubMenuCount(lLevelCount, lIndex);
                // サブメニュー
                for (long lLp = 0; lLp < lNCount; lLp++)
                {
                    lIndex[lLevelCount - 1] = lLp;
                    csViewerMenuItem = m_csViewrMenuCtl.GetSubMenuItem(lLevelCount, lIndex);
                    csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csViewerMenuItem.GetMenuText().ToString() + csViewerMenuItem.GetCallBackNo().ToString()];
                    bPtn = csViewerMenuItem.GetPatern(lPtnNo);
                    if (csMenuItem != null)
                    {
                        csMenuItem.Enabled = bPtn;
                    }
                    SetMaskPatern(lLevelCount + 1, lIndex, lPtnNo);
                }
            }
        }

        // バックグラウンド操作化
        /// <summary><para>method outline:</para>
        /// <para>最後に設定されたマスクパターン</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LastMaskPatern(  ) </para>
        /// </example>
        /// <returns>マスク対象イベント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetViewerDefine.EventKind LastMaskPatern()
        {
            return m_eState;
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データベースツール起動状態通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDBToolStateFlg( bflg ) </para>
        /// </example>
        /// <param name="bflg">bool true:起動中 false:停止中</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void NoticeDBToolStateFlg(bool bflg)
        {
            if (bflg == true)
            {
                m_lExtDBToolExecCount++;
            }
            else
            {
                m_lExtDBToolExecCount--;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データベースツール起動状態取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = IsDBToolRun( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:起動中 false:停止中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsDBToolRun( )
        {
            bool bRtn = false;
            if (m_lExtDBToolExecCount > 0)
            {
                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>マスクパターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaskPatern( eEvent ) </para>
        /// </example>
        /// <param name="eEvent">マスクパターンイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMaskPatern(HySDotNetViewerDefine.EventKind eEvent)
        {
            // バックグラウンド操作化
            if (eEvent < HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN)
            {
                if (m_lExtDBToolExecCount > 0)
                {
                    // 起動中は他からマスク解除されないようにする
                    return;
                }
            }
            if (eEvent < HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN)
            {
                m_eState = eEvent;
            }
            HySViewerMenuItem csViewerMenuItem;
            ToolStripMenuItem csMenuItem;

            long lNLevel = m_csViewrMenuCtl.GetMenuLevelCount();
            long lLevelCount = 1;
            long[] lIndex = new long[lNLevel];
            for (long lLp = 0; lLp < m_csViewrMenuCtl.GetMainMenuCount(); lLp++)
            {
                // レベル１メニュー
                csViewerMenuItem = m_csViewrMenuCtl.GetMainMenuItem(lLp);
                csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csViewerMenuItem.GetMenuText().ToString() + csViewerMenuItem.GetCallBackNo().ToString()];
                MenuMaskCtl(csViewerMenuItem, csMenuItem, eEvent);
                lIndex[0] = lLp;
                SetMaskPatern(lLevelCount + 1, lIndex, eEvent);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>マスクパターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaskPatern( eEvent ) </para>
        /// </example>
        /// <param name="lLevelCount">メニューレベル</param>
        /// <param name="lIndex">マスクメニュー位置</param>
        /// <param name="eEvent">マスクパターンイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetMaskPatern(long lLevelCount, long[] lIndex, HySDotNetViewerDefine.EventKind eEvent)
        {
            HySViewerMenuItem csViewerMenuItem;
            ToolStripMenuItem csMenuItem;

            if (lLevelCount <= m_csViewrMenuCtl.GetMenuLevelCount())
            {
                // メニュー数取得
                long lNCount = m_csViewrMenuCtl.GetSubMenuCount(lLevelCount, lIndex);
                // レベル２メニュー
                for (long lLp = 0; lLp < lNCount; lLp++)
                {
                    lIndex[lLevelCount - 1] = lLp;
                    csViewerMenuItem = m_csViewrMenuCtl.GetSubMenuItem(lLevelCount, lIndex);
                    csMenuItem = (ToolStripMenuItem)m_csMenuItemTbl[csViewerMenuItem.GetMenuText().ToString() + csViewerMenuItem.GetCallBackNo().ToString()];
                    MenuMaskCtl(csViewerMenuItem, csMenuItem, eEvent);
                    SetMaskPatern(lLevelCount + 1, lIndex, eEvent);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューマスク制御</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MenuMaskCtl( csViewerMenuItem,csMenuItem,eEvent ) </para>
        /// </example>
        /// <param name="csViewerMenuItem">メニューアイテム</param>
        /// <param name="csMenuItem">ツールストリップメニュー</param>
        /// <param name="eEvent">マスクパターンイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MenuMaskCtl(HySViewerMenuItem csViewerMenuItem, ToolStripMenuItem csMenuItem, HySDotNetViewerDefine.EventKind eEvent)
        {
            Boolean bPtn = true;
            long lLoop;
            for (lLoop = 0; lLoop < HySDotNetViewerDefine.EVENT_NUM; lLoop++)
            {
                if (eEvent == csViewerMenuItem.GetEventNo(lLoop))
                {
                    bPtn = csViewerMenuItem.GetPatern(lLoop);
                    break;
                }
            }
            if (csMenuItem != null && lLoop < HySDotNetViewerDefine.EVENT_NUM)
            {
                csMenuItem.Enabled = bPtn;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ステータス表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispStatus( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispStatus(HySEventObject csEvent)
        {
            long lEventNo = csEvent.GetEventNo();

            string sName = ((HySDotNetViewer)m_csMainViewer).GetProjectName(csEvent).ToString();
            if (sName != null && sName != string.Empty)
            {
                sName += ":";
            }

            if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)
            {
                HySString csSuppMsg = csEvent.GetSubData() as HySString;
                string sSuppMsg = "";
                if ((object)csSuppMsg != null) { sSuppMsg = csSuppMsg.ToString(); }
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "初期化終了 " + sSuppMsg;
                m_csStatusLabel.Text = sName + COMPLETE_FORMAT + sSuppMsg;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算中";
                m_csStatusLabel.Text = sName + RUN_SIMULATION;

                this.StartAnime();
            }
            else if (lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算終了";
                m_csStatusLabel.Text = sName + COMPLETE_SIMULATION;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND)
            {
                HySString csSuppMsg = csEvent.GetSubData() as HySString;
                string sSuppMsg = "";
                if ((object)csSuppMsg != null) { sSuppMsg = csSuppMsg.ToString(); }
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算異常終了   " + sSuppMsg;
                m_csStatusLabel.Text = sName + ERR_COMPLETE_SIMULATION + sSuppMsg;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算中止";
                m_csStatusLabel.Text = sName + STOP_SIMULATION;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算中断";
                m_csStatusLabel.Text = sName + TEMPORARY_STOP_SIMULATION;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "演算開始失敗";
                m_csStatusLabel.Text = sName + ERR_RUN_SIMULATION;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_RENEW_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "モデル更新";
                m_csStatusLabel.Text = sName + RENEW_MODEL;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "モデル構築成功";
                m_csStatusLabel.Text = sName + BUILD_MODEL;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "モデル構築失敗";
                m_csStatusLabel.Text = sName + ERR_BUILD_MODEL;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)
            {
                m_csStatusLabel.Text = "";
                //m_csStatusLabel.Text = "モデルリセット";
                m_csStatusLabel.Text = sName + RESET_MODEL;

                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            else
            {
                // その他（未計算状態）
                // CalculationStatusに定義されている種別以外の場合
                string sStatusText = (string)m_csDispStatusTbl[sName];
                if (sStatusText != null)
                {
                    m_csStatusLabel.Text = sStatusText;
                }
                else
                {
                    m_csStatusLabel.Text = "";
                }
                if (((HySDotNetViewer)m_csMainViewer).GetCalculationFlg() != true)
                {
                    this.StopAnime();
                }
            }
            // 最新のステータス表示を管理しておく
            if (sName != null && sName != string.Empty)
            {
                m_csDispStatusTbl[sName] = m_csStatusLabel.Text;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>アニメ表示時にタスクトレイアイコンを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeAnimatedTasktrayIcon(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ChangeAnimatedTasktrayIcon()
        {

            // タスクトレイアイコンを変更する
            switch (this.m_iTaskIconIndex)
            {
                case 0:
                    this.CmpNotifyIcon.Icon = this.m_csTasktrayIcons[0];
                    //this.NotifyIcon.Icon = this.m_csTasktrayIcons[0];
                    break;
                case 1:
                    this.CmpNotifyIcon.Icon = this.m_csTasktrayIcons[1];
                    //this.NotifyIcon.Icon = this.m_csTasktrayIcons[1];
                    break;
                case 2:
                    this.CmpNotifyIcon.Icon = this.m_csTasktrayIcons[2];
                    //this.NotifyIcon.Icon = this.m_csTasktrayIcons[2];
                    break;
                case 3:
                    this.CmpNotifyIcon.Icon = this.m_csTasktrayIcons[3];
                    //this.NotifyIcon.Icon = this.m_csTasktrayIcons[3];
                    break;
                case 4:
                    this.CmpNotifyIcon.Icon = this.m_csTasktrayIcons[4];
                    //this.NotifyIcon.Icon = this.m_csTasktrayIcons[4];
                    break;
                default:
                    this.m_iTaskIconIndex = 0;
                    break;
            }
            this.m_iTaskIconIndex++;   // アイコン番号変更
        }
        /// <summary><para>method outline:</para>
        /// <para>タイマー動作：アニメ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NotifyAnime(  ) </para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NotifyAnime(object sender, EventArgs e)
        {
            ChangeAnimatedTasktrayIcon();
            //this.NotifyTimer.Tick += new System.EventHandler(this.NotifyAnime);
        }
        // スレッドタイマー
        # region 方法1
        ///// <summary><para>method outline:</para>
        ///// <para>スレッドタイマー動作：アニメ表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> NotifyAnime(  ) </para>
        ///// </example>
        ///// <param name="sender"></param>
        ///// <param name="e"></param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void NotifyAnime(object obj)
        //{
        //    if (InvokeRequired == true)
        //    {
        //        NotifyAnime_Delegate d_NotifyAnime = new NotifyAnime_Delegate(NotifyAnime);
        //        object[] arg = new object[1];
        //        arg[0] = null;
        //        Invoke(d_NotifyAnime, arg);
        //        return;
        //    }
        //    ChangeAnimatedTasktrayIcon();
        //    //this.NotifyTimer.Tick += new System.EventHandler(this.NotifyAnime);
        //}
        # endregion
        # region 方法2
        /// <summary><para>method outline:</para>
        /// <para>スレッドタイマー処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NotifyIconThreadTimer_Tick(object obj)
        {
            // 別スレッドから呼ばれる
            //m_bNotifyIconThreadflg = true;
            //if (m_bFormCloseflg == false)
            //{
            try
            {
                m_csNotifyIconAO.Post(m_d_NotifyIconPostCallback, null);
            }
            catch
            {
                // Formオブジェクトが破棄された後にスレッドタイマー処理（別スレッド）
                // からのコールによる例外発生を吸収する(フラグ処理は極力使用しない)
            }
            //}
            //m_bNotifyIconThreadflg = false;
        }
        /// <summary><para>method outline:</para>
        /// <para>タイマーからコールされる処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NotifyIconThreadTimer_Work(object obj)
        {
            // Mainスレッドと同じ
            //if (m_bFormCloseflg == true)
            //{
            //    return;
            //}
            ChangeAnimatedTasktrayIcon();
        }
        # endregion
        /// <summary><para>method outline:</para>
        /// <para>アニメーション表示開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartAnime(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void StartAnime()
        {
            //this.NotifyTimer.Enabled = true;
            // スレッドタイマー
            m_csNotifyThreadTimer.Change(0, 1000);
            this.CmpNotifyIcon.Text = "CommonMPは計算中です";
        }
               
        /// <summary><para>method outline:</para>
        /// <para>アニメーション表示終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StopAnime(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void StopAnime()
        {
            //this.NotifyTimer.Enabled = false;
            // スレッドタイマー
            m_csNotifyThreadTimer.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            this.CmpNotifyIcon.Text = "CommonMP";
            m_iTaskIconIndex=0;
            ChangeAnimatedTasktrayIcon();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //m_bFormCloseflg = true;
            // タイマの停止
            m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            m_csNotifyThreadTimer.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            // 非同期操作の終了
            m_csAO.OperationCompleted();
            m_csNotifyIconAO.OperationCompleted();
            // タイマの破棄
            m_csThreadTimerInstance.Dispose();
            m_csNotifyThreadTimer.Dispose();
        }
        //
        /// <summary><para>method outline:</para>
        /// <para>画面通知捕捉処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="m">Windowsメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void WndProc(ref Message m)
        {
            const int WM_SYSCOMMAND = 0x0112;
            const int SC_MINIMIZE = 0xF020;
            const int SC_MAXIMIZE = 0xF030;
            // 最小化を検出し、最小化前の配置・形状情報を保存しておく
            if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MINIMIZE && this.WindowState == FormWindowState.Normal)
            {// 通常表示状態から最小化の場合
                // 配置情報を保存
                Properties.Settings.Default.MainFormLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.MainFormClientSize = this.ClientSize;
            }
            else if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MAXIMIZE && this.WindowState == FormWindowState.Normal)
            {// 通常表示状態から最大化の場合
                // 配置情報を保存
                Properties.Settings.Default.MainFormLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.MainFormClientSize = this.ClientSize;
            }
            base.WndProc(ref m);
        }

        /// <summary><para>method outline:</para>
        /// <para>ウィンドウ情報保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MainFormSettingsSave();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MainFormSettingsSave()
        {
            // ウィンドウ情報を保存
            Properties.Settings.Default.MainFormWindowState = this.WindowState;
            if (this.WindowState == FormWindowState.Normal)
            {// 通常表示状態の場合(最小化状態の場合は、WndProc()にて保存済)
                // 配置情報を保存
                Properties.Settings.Default.MainFormLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.MainFormClientSize = this.ClientSize;
            }
            // 外部ファイルに保存
            Properties.Settings.Default.Save();
        }

        /// <summary><para>method outline:</para>
        /// <para>ウィンドウ情報復元処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MainFormSettingsLoad()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MainFormSettingsLoad()
        {
            if (Properties.Settings.Default.MainFormLocation.X != -1 && Properties.Settings.Default.MainFormLocation.Y != -1)
            {
                // 保存情報をもとに配置情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.Location = Properties.Settings.Default.MainFormLocation;
            }
            if (Properties.Settings.Default.MainFormClientSize.Height != -1 && Properties.Settings.Default.MainFormClientSize.Width != -1)
            {
                // 保存情報をもとに形状情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.ClientSize = Properties.Settings.Default.MainFormClientSize;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Shown += new System.EventHandler(this.MainFormShownEvent);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MainFormShownEvent(object sender, EventArgs e)
        {
            // 保存情報をもとにウィンドウ状態を復元
            if (Properties.Settings.Default.MainFormWindowState == FormWindowState.Maximized)
            {
                this.WindowState = Properties.Settings.Default.MainFormWindowState;
            }
        }
    }
}
