﻿// <summary>ソースコード：スプラッシュスクリーンフォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>スプラッシュスクリーンフォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/21][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetSplashScreen : Form, HySViewForm
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetSplashScreen csDotNetSplashScreen = new HySDotNetSplashScreen( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetSplashScreen()
        {
            InitializeComponent();

            HySString csHomeDir = HySEnvInf.GetHomeDirectory();
            HySString csSplashDir = HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE_FOLDER"));
            HySString csImg = HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE"));
            Bitmap SplashBitmap = new Bitmap(
                    csHomeDir.ToString()
                    + csSplashDir.ToString()
                    + csImg.ToString()
                    );
            /*
            Bitmap SplashBitmap = new Bitmap(HySEnvInf.GetHomeDirectory().ToString()
                + HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE_FOLDER")).ToString()
                + HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE")).ToString());
            */
            //this.BackgroundImage = SplashBitmap;
            //this.Size = new Size(SplashBitmap.Width, SplashBitmap.Height);

            //大きさを変更
            this.Size = new Size(SplashBitmap.Width, SplashBitmap.Height);

            //透過色を指定
            //Color transColor = Color.White;     //白
            Color transColor = SystemColors.Control;

            ////画像を透明にする
            //SplashBitmap.MakeTransparent(transColor);   //画像が透けていると、背景が指定色になる。

            //背景画像を指定する
            this.BackgroundImage = SplashBitmap;

            //背景色を指定する
            this.BackColor = transColor;

            //透明を指定する
            this.TransparencyKey = transColor;
        }
        /// <summary><para>method outline:</para>
        /// <para>対となるスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetScreen(HySScreen csScreen)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent()
        {

        }

    }
}