﻿// <summary>ソースコード：ツール起動用ランチャー画面</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ツール起動用ランチャー画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/10/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetLauncherMainForm : HySDotNetForm
    {
        /// <summary>
        /// スクリーンクラス
        /// </summary>
        HySDotNetLauncherScreen m_csLauncherScreen = null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetLauncherMainForm csForm = new HySDotNetLauncherMainForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySDotNetLauncherMainForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetLauncherMainForm csForm = new HySDotNetLauncherMainForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>HySDotNetLauncherMainForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetLauncherMainForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csLauncherScreen = csScreen as HySDotNetLauncherScreen; // 便利の為
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ロード時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Load += new System.EventHandler(this.HySDotNetLauncherMainForm_Load);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetLauncherMainForm_Load(object sender, EventArgs e)
        {
            const int MAX_LEN = 40;
            // 表示に必要な情報取得
            List<HySString> csBusikindList = null;
            Hashtable csToolNameTbl = null;
            Hashtable csToolIconTbl = null;
            m_csLauncherScreen.GetDispInfo(ref csBusikindList, ref csToolNameTbl, ref csToolIconTbl);

            // --------------------------------------------------
            // ツール（業務識別子）の数分ボタンを生成する
            // --------------------------------------------------

            // コントロール端のマージン
            int iMargin = 5;
            // ツールボタン１つ分のオフセット
            int iOffset = 36;
            int iBottomPos = iMargin;

            Button csFocusButton = null;
            for (int iBusiCnt = 0; iBusiCnt < csBusikindList.Count; iBusiCnt++)
            {
                HySString csBusiKind = csBusikindList[iBusiCnt];
                // ツール名を取得
                HySString csToolName = (HySString)csToolNameTbl[csBusiKind];

                // ------------------------------
                // 1.ツールボタンを作成
                // ------------------------------

                Button ToolButton = new Button();
                // ツールボタンプロパティ設定（位置）
                ToolButton.Location = new Point(iMargin, iMargin + (iOffset * iBusiCnt));
                // 下端位置を取得
                iBottomPos = iMargin + (iOffset * (iBusiCnt + 1));
                // ツールボタンプロパティ設定（サイズ）
                ToolButton.Size = new Size(35, 35);
                // ツールボタンプロパティ設定（ボタン名）
                ToolButton.Name = csBusiKind.ToString();

                // ツールチップを作成
                ToolTip ToolTip = new ToolTip();
                // ツールチッププロパティ設定（ツールチップが表示されるまでの時間）
                // ToolTipが表示されるまでの時間
                ToolTip.InitialDelay = 1000;
                // ツールチッププロパティ設定（ツールチップが表示されている状態で別のツールチップが表示されるまでの時間）
                ToolTip.ReshowDelay = 1000;
                // ツールチッププロパティ設定（ツールチップの表示持続時間）
                ToolTip.AutoPopDelay = 10000;
                // ツールチッププロパティ設定（ランチャー画面が非アクティブでもツールチップを表示する）
                ToolTip.ShowAlways = true;
                // ツールボタンに設定（ツールチップ文字列はツール名とイコール）
                ToolTip.SetToolTip(ToolButton, csToolName.ToString());

                // ツールアイコンを作成
                HySString csIconPath = (HySString)csToolIconTbl[csBusiKind];
                HySFile csIconFile = new HySFile(csIconPath);
                // 元アイコンサイズ
                int iOrgIconSize = 16;
                // 実際のアイコンサイズ（元アイコンサイズの倍）
                int iIconSize = iOrgIconSize * 2;

                // アイコンファイルの有無をチェック
                if (csIconFile.Exist() == true)
                {
                    // 該当アイコンが存在する場合、取り込み（16×16）
                    try
                    {
                        Image csOrgIconImg = new Icon(csIconPath.ToString(), new Size(iOrgIconSize, iOrgIconSize)).ToBitmap();
                        // 実アイコンサイズ（32×32）
                        Rectangle csIconRect = new Rectangle(1, 0, iIconSize, iIconSize);
                        // ツールボタンの領域からキャンバスを作成し、アイコン画像を設定
                        Bitmap csCanvas = new Bitmap(ToolButton.Width, ToolButton.Height);
                        Graphics csGraphics = Graphics.FromImage(csCanvas);
                        csGraphics.InterpolationMode = InterpolationMode.HighQualityBicubic;
                        // アイコン画像を拡大描画
                        csGraphics.DrawImage(csOrgIconImg, csIconRect);
                        // ツールボタンに設定
                        ToolButton.Image = csCanvas;
                    }
                    catch (Exception)
                    {
                        // アイコン設定に失敗した場合は、何もしない（UnKnownイメージになる）
                    }
                }
                else
                {
                    // 該当アイコンが存在しない場合は、何もしない（UnKnownイメージになる）
                }

                // 作成したツールボタンをフォームに追加
                this.Controls.Add(ToolButton);
                ToolButton.Click += new EventHandler(ToolButton_Click);
                // 最初のツールボタンのインスタンスを保持（最後にフォーカスをあてるため）
                if (iBusiCnt == 0)
                {
                    csFocusButton = ToolButton;
                }

                // ------------------------------
                // 2.ツール説明文を作成
                // ------------------------------

                Label ToolLabel = new Label();
                // ツールラベルプロパティ設定（サイズ自動）
                ToolLabel.AutoSize = true;
                // ツールラベルプロパティ設定（位置）
                // サイズが自動設定のため、中央揃えを疑似的に再現させるために縦位置をズラす
                //（実アイコンサイズの中心からフォントサイズの半分だけ上のポイント）。
                int iLabelOffset = Convert.ToInt16((iIconSize / 2) - (ToolLabel.Font.Size / 2));
                ToolLabel.Location = new Point(iMargin + iOffset, iMargin + (iOffset * iBusiCnt) + iLabelOffset);
                // ツールラベルプロパティ設定（文言）
                string sToolNameString = csToolName.ToString();
                // 文字列のバイト数をチェック
                Encoding csSJISEnc = Encoding.GetEncoding("Shift_JIS");
                if (csSJISEnc.GetByteCount(sToolNameString) > MAX_LEN)
                {
                    // ------------------------------------------------------------
                    // 文字列のバイト数が40バイト（全角で20文字分）を超える場合、
                    // 41バイト目を"..."に変換し以降の文字は捨てる
                    // ------------------------------------------------------------

                    // 先頭から40バイト目までの文字数分、元の文字から文字列として切り出す
                    Byte[] csToolNameBytes = csSJISEnc.GetBytes(sToolNameString);
                    sToolNameString = sToolNameString.Substring(
                        0, (csSJISEnc.GetString(csToolNameBytes, 0, MAX_LEN)).Length);

                    // 切り出した文字列のバイト数が40より大きい場合、
                    // 40バイト目は2バイト文字の前半1バイト部分に相当するため削る
                    if (csSJISEnc.GetByteCount(sToolNameString) > MAX_LEN)
                    {
                        sToolNameString = sToolNameString.Substring(0, sToolNameString.Length - 1);
                    }

                    // 削った文字のかわりに"..."を付与
                    sToolNameString = sToolNameString + "...";
                }
                ToolLabel.Text = sToolNameString;
                // フォント設定（画面タイトルと同じフォント）
                ToolLabel.Font = this.Font;

                // 作成したツールラベルをフォームに追加
                this.Controls.Add(ToolLabel);

            }

            // ---------------------------------------------------------------
            // 3.ヘルプボタンとダミーラベルの位置をツールボタン群の下に移動
            // ---------------------------------------------------------------
            HelpJump_Button.Location = new Point(
                this.Width - HelpJump_Button.Width - 3, iBottomPos + iMargin);
            // ダミーラベルがないと、スクロールバーが表示された場合にヘルプボタンの周りの余白が削除されてしまう
            Dummy_Label.Location = new Point(
                this.Width - HelpJump_Button.Width - 3, iBottomPos + HelpJump_Button.Height - iMargin);

            // ------------
            // 4.最終調整
            // ------------

            // 「ツールボタン15個分 + ヘルプボタン」の範囲をMAX画面サイズとする(横幅はOS作業領域全体)
            int iMaxHeight = iMargin + (iOffset * 16) + HelpJump_Button.Height + iMargin;
            int iMaxWidth = Screen.GetWorkingArea(this).Width;
            this.MaximumSize = new Size(iMaxWidth, iMaxHeight);

            // スクロールバーの分を考慮して横幅を拡張する
            int iWidth = this.Width;
            int iHeight = this.Height;
            int iDiffWidth = iWidth - this.ClientSize.Width;
            // 画面サイズを"手動"に変更してから拡張後サイズ設定
            this.AutoSize = false;
            this.Size = new Size(iWidth + iDiffWidth, iHeight);

            // ツールボタンがある場合、先頭にフォーカスを設定（これをやらないと、スクロール位置が勝手に再下段になる）
            if (csFocusButton != null)
            {
                this.ActiveControl = csFocusButton;
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>ツールボタンクリック時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Click += new System.EventHandler(this.ToolButton_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ToolButton_Click(object sender, EventArgs e)
        {
            string sBtnName = ((Button)sender).Name;
            // 押下されたボタンに対応する業務識別子をビューアジョブへ通知する
            m_csLauncherScreen.StartTool(new HySString(sBtnName));
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じた時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetLauncherMainForm_FormClosed(sender, e)：フォームを閉じた時のイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetLauncherMainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_csLauncherScreen.CloseScreen();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0007, null);
        }
    }
}
