﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>モニター画面グラフ描画クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2011/02/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetDrawMonitor
    {
        /// <summary>垂直左端基準</summary>
        private readonly HySObjectKind VERTICAL_LEFT = new HySObjectKind("csVerticalLeft");
        /// <summary>垂直右端基準</summary>
        private readonly HySObjectKind VERTICAL_RIGHT = new HySObjectKind("csVerticalRight");

        /// <summary>左軸スクロールバー</summary>
        private VScrollBar m_csYLeftScrollBar = null;
        /// <summary>X軸スクロールバー</summary>
        private HScrollBar m_csXScrollBar = null;
        /// <summary>右軸スクロールバー</summary>
        private VScrollBar m_csYRightScrollBar = null;
        /// <summary>左軸ズームバー(トラックバー)</summary>
        private TrackBar m_csYLeftTrackBar = null;
        /// <summary>右軸ズームバー(トラックバー)</summary>
        private TrackBar m_csYRightTrackBar = null;
        /// <summary>左軸最大チェックボックス</summary>
        private CheckBox m_csYLeftCheckBoxMax = null;
        /// <summary>左軸最大ニューメリックアップダウン</summary>
        private NumericUpDown m_csYLeftNumericUpDownMax = null;
        /// <summary>左軸最小チェックボックス</summary>
        private CheckBox m_csYLeftCheckBoxMin = null;
        /// <summary>左軸最小ニューメリックアップダウン</summary>
        private NumericUpDown m_csYLeftNumericUpDownMin = null;
        /// <summary>右軸最大チェックボックス</summary>
        private CheckBox m_csYRightCheckBoxMax = null;
        /// <summary>右軸最大ニューメリックアップダウン</summary>
        private NumericUpDown m_csYRightNumericUpDownMax = null;
        /// <summary>右軸最小チェックボックス</summary>
        private CheckBox m_csYRightCheckBoxMin = null;
        /// <summary>右軸最小ニューメリックアップダウン</summary>
        private NumericUpDown m_csYRightNumericUpDownMin = null;
        /// <summary>X軸ズームバー</summary>
        private TrackBar m_csXTrackBar = null;
        /// <summary>左軸コントロール判定</summary>
        private bool m_bLeftControl = false;
        /// <summary>右軸コントロール判定</summary>
        private bool m_bRightControl = false;

        /// <summary>データクラス</summary>
        private HySDispInstanceCommon m_csInstanceCommon = null;//最大最小など全て持っている
        /// <summary>ハッシュテーブルインスタンス</summary>
        private HySDataHashTable m_csData = null;//軸の値
        /// <summary>画面表示情報</summary>
        private HySDotNetMoniterBaseForm.CntlInfo[] m_csCntlInfo = null;
        /// <summary>選択セル番号</summary>
        private long m_lSelectCellNum = 0;


        /// <summary>左軸設定最大値</summary>
        private double m_dLeftSetMax = 1000;//自動・手動の設定最大値
        /// <summary>左軸設定最小値</summary>
        private double m_dLeftSetMin = 0;//自動・手動の設定最小値
        /// <summary>X軸設定最大値</summary>
        private double m_dXSetMax = 1000;
        /// <summary>X軸設定最小値</summary>
        private double m_dXSetMin = 0;
        /// <summary>右軸設定最大値</summary>
        private double m_dRightSetMax = 100;
        /// <summary>右軸設定最小値</summary>
        private double m_dRightSetMin = 0;

        /// <summary>左軸目盛表示最大個数</summary>
        private long m_lLeftScaleMemory = 0;
        /// <summary>左軸目盛表示間隔</summary>
        private double[] m_dLeftInterval = null;
        /// <summary>X軸目盛表示間隔</summary>
        private double[] m_dXInterval = null;
        /// <summary>右軸メモリ表示最大個数</summary>
        private long m_lRightScaleMemory = 0;
        /// <summary>右軸メモリ表示間隔</summary>
        private double[] m_dRightInterval = null;

        /// <summary>左軸最大値手動チェック</summary>
        private bool m_bLeftMaxCheck = false;
        /// <summary>左軸最小値手動チェック</summary>
        private bool m_bLeftMinCheck = true;
        /// <summary>右軸最大値手動チェック</summary>
        private bool m_bRightMaxCheck = false;
        /// <summary>右軸最小値手動チェック</summary>
        private bool m_bRightMinCheck = true;

        /// <summary>1次元縦断モニター時間指定ポイント</summary>
        private long m_lTPointCnt = 0;
        /// <summary>1次元縦断モニター時間表示ラベル</summary>
        private Label m_csTimeLabel = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetDrawMonitor csHySDotNetDrawMonitor = new HySDotNetDrawMonitor( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetDrawMonitor  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetDrawMonitor()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>共有データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInstanceCommon(csInstanceCommon)</para>
        /// </example>
        /// <param name="csInstanceCommon">HySDispInstanceCommon：データ</param>
        /// <returns>HySDotNetDrawMonitor  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInstanceCommon(HySDispInstanceCommon csInstanceCommon)
        {
            m_csInstanceCommon = csInstanceCommon;
            GetMonitorValueInf();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸スクロールバー設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftScrollBar(csYLeftScrollBar)</para>
        /// </example>
        /// <param name="csYLeftScrollBar">VScrollBar：Vスクロールバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftScrollBar(VScrollBar csYLeftScrollBar)
        {
            m_csYLeftScrollBar = csYLeftScrollBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸スクロールバー設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXScrollBar(csXScrollBar)</para>
        /// </example>
        /// <param name="csXScrollBar">HScrollBar：Hスクロールバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetXScrollBar(HScrollBar csXScrollBar)
        {
            m_csXScrollBar = csXScrollBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸スクロールバー設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightScrollBar(csRightScrollBar)</para>
        /// </example>
        /// <param name="csRightScrollBar">VScrollBar：Vスクロールバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightScrollBar(VScrollBar csRightScrollBar)
        {
            m_csYRightScrollBar = csRightScrollBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸グラフコントロール設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftControl(csLeftCheckBoxMax, csLeftNumericUpDownMax, csLeftCheckBoxMin, csLeftNumericUpDownMin, csLeftTrackBar)</para>
        /// </example>
        /// <param name="csLeftCheckBoxMax">CheckBox：左軸最大チェックボックス</param>
        /// <param name="csLeftNumericUpDownMax">NumericUpDown：左軸最大ニューメリックアップダウン</param>
        /// <param name="csLeftCheckBoxMin">CheckBox：左軸最小チェックボックス</param>
        /// <param name="csLeftNumericUpDownMin">NumericUpDown：左軸最小ニューメリックアップダウン</param>
        /// <param name="csLeftTrackBar">TrackBar：左軸拡大率トラックバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftControl(CheckBox csLeftCheckBoxMax, NumericUpDown csLeftNumericUpDownMax,
                                   CheckBox csLeftCheckBoxMin, NumericUpDown csLeftNumericUpDownMin,
                                   TrackBar csLeftTrackBar)
        {
            m_csYLeftCheckBoxMax = csLeftCheckBoxMax;
            m_csYLeftNumericUpDownMax = csLeftNumericUpDownMax;
            m_csYLeftCheckBoxMin = csLeftCheckBoxMin;
            m_csYLeftNumericUpDownMin = csLeftNumericUpDownMin;
            m_csYLeftTrackBar = csLeftTrackBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸グラフコントロール設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightControl(csRightCheckBoxMax, csRightNumericUpDownMax, csRightCheckBoxMin, csRightNumericUpDownMin, csRightTrackBar)</para>
        /// </example>
        /// <param name="csRightCheckBoxMax">CheckBox：右軸最大チェックボックス</param>
        /// <param name="csRightNumericUpDownMax">NumericUpDown：右軸最大ニューメリックアップダウン</param>
        /// <param name="csRightCheckBoxMin">CheckBox：右軸最小チェックボックス</param>
        /// <param name="csRightNumericUpDownMin">NumericUpDown：右軸最小ニューメリックアップダウン</param>
        /// <param name="csRightTrackBar">TrackBar：右軸拡大率トラックバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightControl(CheckBox csRightCheckBoxMax, NumericUpDown csRightNumericUpDownMax,
                                    CheckBox csRightCheckBoxMin, NumericUpDown csRightNumericUpDownMin,
                                    TrackBar csRightTrackBar)
        {
            m_csYRightCheckBoxMax = csRightCheckBoxMax;
            m_csYRightNumericUpDownMax = csRightNumericUpDownMax;
            m_csYRightCheckBoxMin = csRightCheckBoxMin;
            m_csYRightNumericUpDownMin = csRightNumericUpDownMin;
            m_csYRightTrackBar = csRightTrackBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸トラックバー設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXControl(csXTrackBar)</para>
        /// </example>
        /// <param name="csXTrackBar">TrackBar：X軸拡大率トラックバー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetXControl(TrackBar csXTrackBar)
        {
            m_csXTrackBar = csXTrackBar;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCntlInfo(csCntlInfo)</para>
        /// </example>
        /// <param name="csCntlInfo">HySDotNetMoniterBaseForm.CntlInfo[]：画面表示情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCntlInfo(HySDotNetMoniterBaseForm.CntlInfo[] csCntlInfo)
        {
            m_csCntlInfo = csCntlInfo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最大値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftSetMax(dLeftSetMax)</para>
        /// </example>
        /// <param name="dLeftSetMax">double：設定された最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftSetMax(double dLeftSetMax)
        {
            m_dLeftSetMax = dLeftSetMax;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最大値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLeftSetMax()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>設定最大値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetLeftSetMax()
        {
            return m_dLeftSetMax;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最小値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftSetMax(dLeftSetMax)</para>
        /// </example>
        /// <param name="dLeftSetMin">double：設定された最小値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftSetMin(double dLeftSetMin)
        {
            m_dLeftSetMin = dLeftSetMin;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最小値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLeftSetMax()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>設定最小値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetLeftSetMin()
        {
            return m_dLeftSetMin;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最大値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightSetMax(dRightSetMax)</para>
        /// </example>
        /// <param name="dRightSetMax">double：設定された最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightSetMax(double dRightSetMax)
        {
            m_dRightSetMax = dRightSetMax;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最大値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetRightSetMax()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>設定最大値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetRightSetMax()
        {
            return m_dRightSetMax;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最小値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightSetMax(dRightSetMin)</para>
        /// </example>
        /// <param name="dRightSetMin">double：設定された最小値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightSetMin(double dRightSetMin)
        {
            m_dRightSetMin = dRightSetMin;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最小値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetRightSetMin()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>設定最小値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetRightSetMin()
        {
            return m_dRightSetMin;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ハッシュテーブル設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataHashTable(csData)</para>
        /// </example>
        /// <param name="csData">HySDataHashTable：ハッシュテーブル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataHashTable(HySDataHashTable csData)
        {
            m_csData = csData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSelectCellNum(lCellNum)</para>
        /// </example>
        /// <param name="lCellNum">long：選択セル番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSelectCellNum(long lCellNum){
            m_lSelectCellNum = lCellNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸目盛最大個数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftScaleMemory(lMemory)</para>
        /// </example>
        /// <param name="lMemory">long：左軸目盛最大個数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftScaleMemory(long lMemory)
        {
            m_lLeftScaleMemory = lMemory;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸目盛間隔設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftInterval(dInterval)</para>
        /// </example>
        /// <param name="dInterval">double[]：左軸目盛間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftInterval(double[] dInterval)
        {
            m_dLeftInterval = dInterval;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸目盛間隔設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXInterval(dInterval)</para>
        /// </example>
        /// <param name="dInterval">double[]：X軸目盛間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetXInterval(double[] dInterval)
        {
            m_dXInterval = dInterval;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸目盛最大個数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightScaleMemory(lMemory)</para>
        /// </example>
        /// <param name="lMemory">long：右軸目盛最大個数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightScaleMemory(long lMemory)
        {
            m_lRightScaleMemory = lMemory;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸目盛間隔設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightInterval(dInterval)</para>
        /// </example>
        /// <param name="dInterval">double[]：右軸目盛間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightInterval(double[] dInterval)
        {
            m_dRightInterval = dInterval;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最大値チェック設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftMaxCheck(bLeftMaxCheck)</para>
        /// </example>
        /// <param name="bLeftMaxCheck">bool：左軸最大値チェック情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftMaxCheck(bool bLeftMaxCheck)
        {
            m_bLeftMaxCheck = bLeftMaxCheck;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸最小値チェック設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftMixCheck(bLeftMixCheck)</para>
        /// </example>
        /// <param name="bLeftMinCheck">bool：左軸最小値チェック情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftMinCheck(bool bLeftMinCheck)
        {
            m_bLeftMinCheck = bLeftMinCheck;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最大値チェック設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightMaxCheck(bRightMaxCheck)</para>
        /// </example>
        /// <param name="bRightMaxCheck">bool：右軸最大値チェック情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightMaxCheck(bool bRightMaxCheck)
        {
            m_bRightMaxCheck = bRightMaxCheck;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸最小値チェック設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRightMixCheck(bRightMixCheck)</para>
        /// </example>
        /// <param name="bRightMinCheck">bool：右軸最小値チェック情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightMinCheck(bool bRightMinCheck)
        {
            m_bRightMinCheck = bRightMinCheck;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>1次元縦断モニター時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRiverbetTimePoint(lTimePoint)</para>
        /// </example>
        /// <param name="lTimePoint">long：指定時間ポイント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRiverbetTimePoint(long lTimePoint)
        {
            m_lTPointCnt = lTimePoint;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>1次元縦断モニター表示時間ラベル設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRiverbedTimeLabel(csLabel)</para>
        /// </example>
        /// <param name="csLabel">Label：表示時間のラベル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRiverbedTimeLabel(Label csLabel)
        {
            m_csTimeLabel = csLabel;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>最大最小値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetMonitorValueInf()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetMonitorValueInf()
        {
            //X軸の値とY軸の値を取得
            double[] dNum = m_csInstanceCommon.GetDoubleArray();
            if (dNum != null)
            {
                //X軸最小値
                m_dXSetMin = dNum[0];
                //X軸最大値
                m_dXSetMax = dNum[1];
                //左軸最小値
                if (m_bLeftMinCheck == false)
                {
                    m_dLeftSetMin = dNum[2];
                }
                //左軸最大値
                if (m_bLeftMaxCheck == false)
                {
                    m_dLeftSetMax = dNum[3] * 1.1;
                }
                //右軸最小値
                if (m_bRightMinCheck == false)
                {
                    m_dRightSetMin = dNum[4];
                }
                //右軸最大値
                if (m_bRightMaxCheck == false)
                {
                    m_dRightSetMax = dNum[5] * 1.1;
                }
            }
        }

        //値がないときの処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>値がないときの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ValueDecision()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ValueDecision()
        {
            if (m_dLeftSetMax == 0.0 && m_dLeftSetMin == 0.0)
            {
                m_dLeftSetMax = 1000.0;
            }
            if (m_dRightSetMax == 0.0 && m_dRightSetMin == 0.0)
            {
                m_dRightSetMax = 100.0;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビットマップ初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ClearBitmap(csBitmap)</para>
        /// </example>
        /// <param name="csBitmap">Bitmap：ビットマップ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ClearBitmap(ref Bitmap csBitmap)
        {
            if (csBitmap != null)
            {
                csBitmap.Dispose();
                csBitmap = null;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸全体描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawLeftFullMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawLeftFullMonitor(long lCommonNum)//HySDispInstanceCommonの番号
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmap);//全範囲ビットマップを初期化
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //全範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmap = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                         m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csBmap.Size.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csBmap.Size.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmap); // グラフ描画エリア設定

            //データの個数
            long lDataNum = m_csData.GetCount();
            if (lDataNum > 0)
            {
                long lDataSave = SetLeftData(lDataNum);

                //描画範囲の取得(実際の数値)
                double dMax_X = m_dXSetMax;//X軸の表示最大値
                double dMin_X = m_dXSetMin;//X軸の表示最小値
                double dMax_Y = m_dLeftSetMax;//Y軸の表示最大値
                double dMin_Y = m_dLeftSetMin;//Y軸の表示最小値
                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //実データの取得
                double[] dNumber_X = new double[lDataSave];//X軸の実データ
                double[] dNumber_Y = new double[lDataSave];//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//線描画時の左側のX座標
                double dLocation_X2 = 0.0;//線描画時の右側のX座標
                double dLocation_Y1 = 0.0;//線描画時の左側のY座標
                double dLocation_Y2 = 0.0;//線描画時の右側のY座標

                //実データの取得処理
                GetCellData(ref dNumber_X, ref dNumber_Y, lDataNum, dMin_X, m_lSelectCellNum);

                if (lDataNum == 1)
                {
                    SetPlusData(ref dNumber_X, ref dNumber_Y);
                }

                //描画処理
                for (int iCnt = 1; iCnt < lDataSave; iCnt++)
                {
                    if (dNumber_X[iCnt - 1] != HySDefine.dINVALID_VALUE && dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {
                        //X軸の座標を設定
                        dLocation_X1 = dNumber_X[iCnt - 1] * dScaleNum_X;
                        dLocation_X2 = dNumber_X[iCnt] * dScaleNum_X;
                        //Y軸の座標を設定
                        dLocation_Y1 = ((dMax_Y  - dNumber_Y[iCnt - 1]) * dScaleNum_Y);
                        dLocation_Y2 = ((dMax_Y  - dNumber_Y[iCnt]) * dScaleNum_Y);

                        if (g is Graphics)
                        {
                            g.DrawLine(new Pen(Color.FromArgb(80, 167, 14), 2),//現在決めうちのため後で改修
                                (float)dLocation_X1, (float)dLocation_Y1, (float)dLocation_X2, (float)dLocation_Y2);
                        }

                    }
                }
            }
        }

        //範囲描画
        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸指定範囲描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawLeftScopeMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawLeftScopeMonitor(long lCommonNum)
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //指定範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmapRange = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                                m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmapRange);  // グラフ描画エリア設定

            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];
            long lDataNum = m_csData.GetCount();

            if (lDataNum > 0)
            {
                long lDataSave = SetLeftData(lDataNum);

                //各スクロールバーの値を取得
                double dXSBarValue = (double)m_csXScrollBar.Value;//X軸のスクロールバーの値
                double dXSBarLargChange = (double)m_csXScrollBar.LargeChange;//X軸のスクロールバーのLargeChange
                double dYLeftSBarValue = (double)m_csYLeftScrollBar.Value;//Y軸左側のスクロールバーの値
                double dYLeftSBarLargeChange = (double)m_csYLeftScrollBar.LargeChange;//Y軸左側のスクロールバーのLargeChange
                //各軸の範囲（実際の値の最大-最小）
                double dXRange = m_dXSetMax - m_dXSetMin;
                double dYRange = m_dLeftSetMax - m_dLeftSetMin;

                //描画範囲の取得(実際の数値)
                double dMax_X = ((dXSBarValue + dXSBarLargChange) / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最大値
                double dMin_X = (dXSBarValue / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最小値
                double dMax_Y = m_dLeftSetMin + (1.0 - (dYLeftSBarValue / ((double)m_csYLeftScrollBar.Maximum + 1.0))) * dYRange;//Y軸の表示最大値
                double dMin_Y = m_dLeftSetMin + (1.0 - (dYLeftSBarValue + dYLeftSBarLargeChange) / ((double)m_csYLeftScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最小値

                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //実データの取得
                double[] dNumber_X = new double[lDataSave];//X軸の実データ
                double[] dNumber_Y = new double[lDataSave];//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//線描画時の左側のX座標
                double dLocation_X2 = 0.0;//線描画時の右側のX座標
                double dLocation_Y1 = 0.0;//線描画時の左側のY座標
                double dLocation_Y2 = 0.0;//線描画時の右側のY座標

                //データの設定
                m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];

                //実データの取得処理
                GetCellData(ref dNumber_X, ref dNumber_Y, lDataNum, m_dXSetMin, m_lSelectCellNum);

                if (lDataNum == 1)
                {
                    SetPlusData(ref dNumber_X, ref dNumber_Y);
                }

                //描画処理
                for (int iCnt = 1; iCnt < lDataSave; iCnt++)
                {
                    if (dNumber_X[iCnt - 1] != HySDefine.dINVALID_VALUE && dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {  //正常値のとき
                        if (dNumber_X[iCnt] >= dMin_X)
                        {  //描画範囲のとき
                            //X軸の座標を設定
                            dLocation_X1 = (dNumber_X[iCnt - 1] - dMin_X) * dScaleNum_X;
                            dLocation_X2 = (dNumber_X[iCnt] - dMin_X) * dScaleNum_X;
                            //Y軸の座標を設定
                            dLocation_Y1 = ((dMax_Y - dNumber_Y[iCnt - 1]) * dScaleNum_Y);
                            dLocation_Y2 = ((dMax_Y - dNumber_Y[iCnt]) * dScaleNum_Y);

                            if (g is Graphics)
                            {
                                g.DrawLine(new Pen(Color.FromArgb(80, 167, 14), 2),//現在決めうちのため後で改修
                                    (float)dLocation_X1, (float)dLocation_Y1, (float)dLocation_X2, (float)dLocation_Y2);
                            }
                        }
                    }
                }
            }
            //解放
            g.Dispose();
            m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Invalidate();
        }

        //右軸全体描画処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸全体描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRightFullMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawRightFullMonitor(long lCommonNum)
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmap);//全範囲ビットマップを初期化
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //全範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmap = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                         m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csBmap.Size.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csBmap.Size.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmap); // グラフ描画エリア設定

            //データの個数
            long lDataNum = m_csData.GetCount();
            if (lDataNum > 0)
            {
                //描画範囲の取得(実際の数値)
                double dMax_X = m_dXSetMax;//X軸の表示最大値
                double dMin_X = m_dXSetMin;//X軸の表示最小値
                double dMax_Y = m_dRightSetMax;//Y軸の表示最大値
                double dMin_Y = m_dRightSetMin;//Y軸の表示最小値
                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //実データの取得
                double[] dNumber_X = new double[lDataNum];//X軸の実データ
                double[] dNumber_Y = new double[lDataNum];//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//線描画時の左側のX座標
                double dLocation_X2 = 0.0;//線描画時の右側のX座標
                double dLocation_Y1 = 0.0;//線描画時の左側のY座標
                double dLocation_Y2 = 0.0;//線描画時の右側のY座標

                //実データの取得処理
                GetCellData(ref dNumber_X, ref dNumber_Y, lDataNum, dMin_X, 1);

                //棒グラフの色決定
                SolidBrush csBrush = new SolidBrush(Color.FromArgb(14, 80, 167));

                //描画処理
                for (int iCnt = 1; iCnt < lDataNum; iCnt++)
                {
                    if (dNumber_X[iCnt - 1] != HySDefine.dINVALID_VALUE && dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {
                        //X軸の座標を設定
                        dLocation_X1 = dNumber_X[iCnt - 1] * dScaleNum_X;
                        dLocation_X2 = dNumber_X[iCnt] * dScaleNum_X;
                        //Y軸の座標を設定
                        dLocation_Y1 = ((dNumber_Y[iCnt - 1] - dMin_Y) * dScaleNum_Y);
                        dLocation_Y2 = ((dNumber_Y[iCnt] - dMin_Y) * dScaleNum_Y);

                        if (g is Graphics)
                        {
                            g.FillRectangle(csBrush, (float)dLocation_X1, (float)0,
                                                                          (float)(dLocation_X2 - dLocation_X1),
                                                                          (float)(dLocation_Y2));   // 四角領域塗り潰し
                            g.DrawRectangle(new Pen(Color.Black, 1), (float)dLocation_X1, (float)0,
                                                                     (float)(dLocation_X2 - dLocation_X1),
                                                                     (float)(dLocation_Y2)); // 四角領域作成
                        }
                    }
                }
            }
        }

        //右軸範囲描画
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸指定範囲描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRightScopeMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawRightScopeMonitor(long lCommonNum)
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //指定範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmapRange = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                                m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmapRange);  // グラフ描画エリア設定

            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];
            long lDataNum = m_csData.GetCount();

            if (lDataNum > 0)
            {
                //各スクロールバーの値を取得
                double dXSBarValue = (double)m_csXScrollBar.Value;//X軸のスクロールバーの値
                double dXSBarLargChange = (double)m_csXScrollBar.LargeChange;//X軸のスクロールバーのLargeChange
                double dYRightSBarValue = (double)m_csYRightScrollBar.Value;//Y軸左側のスクロールバーの値
                double dYRightSBarLargeChange = (double)m_csYRightScrollBar.LargeChange;//Y軸左側のスクロールバーのLargeChange
                //各軸の範囲（実際の値の最大-最小）
                double dXRange = m_dXSetMax - m_dXSetMin;
                double dYRange = m_dRightSetMax - m_dRightSetMin;

                //描画範囲の取得(実際の数値)
                double dMax_X = ((dXSBarValue + dXSBarLargChange) / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最大値
                double dMin_X = (dXSBarValue / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最小値
                double dMax_Y = m_dRightSetMin + ((dYRightSBarValue + dYRightSBarLargeChange) / ((double)m_csYRightScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最大値
                double dMin_Y = m_dRightSetMin + (dYRightSBarValue / ((double)m_csYRightScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最小値
               
                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //実データの取得
                double[] dNumber_X = new double[lDataNum];//X軸の実データ
                double[] dNumber_Y = new double[lDataNum];//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//描画時の左側のX座標
                double dLocation_X2 = 0.0;//描画時の右側のX座標
                double dLocation_Y1 = 0.0;//描画時の左側のY座標
                double dLocation_Y2 = 0.0;//描画時の右側のY座標

                //データの設定
                m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];

                //実データの取得処理
                GetCellData(ref dNumber_X, ref dNumber_Y, lDataNum, m_dXSetMin, 1);

                //棒グラフの色決定
                SolidBrush csBrush = new SolidBrush(Color.FromArgb(14, 80, 167));

                //描画処理
                for (int iCnt = 1; iCnt < lDataNum; iCnt++)
                {
                    if (dNumber_X[iCnt - 1] != HySDefine.dINVALID_VALUE && dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {  //正常値のとき
                        if (dNumber_X[iCnt] >= dMin_X && dNumber_X[iCnt - 1] <= dMax_X)
                        {  //描画範囲のとき
                            //X軸の座標を設定
                            dLocation_X1 = (dNumber_X[iCnt - 1] - dMin_X) * dScaleNum_X;
                            dLocation_X2 = (dNumber_X[iCnt] - dMin_X) * dScaleNum_X;
                            //Y軸の座標を設定
                            dLocation_Y1 = ((dNumber_Y[iCnt - 1] - dMin_Y) * dScaleNum_Y);
                            dLocation_Y2 = ((dNumber_Y[iCnt]- dMin_Y) * dScaleNum_Y);

                            if (g is Graphics)
                            {
                                g.FillRectangle(csBrush, (float)dLocation_X1, (float)0,
                                                                              (float)(dLocation_X2 - dLocation_X1),
                                                                              (float)(dLocation_Y2)); // 四角領域塗り潰し
                                g.DrawRectangle(new Pen(Color.Black, 1), (float)dLocation_X1, (float)0,
                                                                         (float)(dLocation_X2 - dLocation_X1),
                                                                         (float)(dLocation_Y2)); // 四角領域作成
                            }
                        }
                    }
                }
            }
            //解放
            g.Dispose();
            m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Invalidate();
        }


        //実データの取得処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>実データの取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetCellData(ref dNumber_X, ref dNumber_Y, lDataNum, dMin_X)</para>
        /// </example>
        /// <param name="dNumber_X">double[]：X軸の値</param>
        /// <param name="dNumber_Y">double[]：Y軸の値</param>
        /// <param name="lDataNum">long：データの個数</param>
        /// <param name="dMin_X">double：X軸の最小値</param>
        /// <param name="lSelectCellNum">long：選択セル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetCellData(ref double[] dNumber_X, ref double[] dNumber_Y, long lDataNum, double dMin_X, long lSelectCellNum)
        {
            //実データの取得処理
            for (int iCnt = 0; iCnt < lDataNum; iCnt++)
            {
                HySD1CellArrayData csCellData = m_csData[new HySString(iCnt.ToString())] as HySD1CellArrayData;//データの取り出し
                if (csCellData is HySD1CellArrayData)
                {
                    HySTime csTime = csCellData.GetLastTime();//時間をHySTime型で取得
                    HySCellData[] csCell = csCellData.GetCellData(); // セル単位で実データの取得(Y軸の値)

                    //X軸の実データ取得
                    if (csTime != null)
                    {
                        dNumber_X[iCnt] = csTime.GetTime() - dMin_X;//時間の取得(X軸の最小値のところを0として考える：値が大きくなるため)
                    }
                    else
                    {
                        dNumber_X[iCnt] = HySDefine.dINVALID_VALUE;//欠損値を代入
                    }
                    //Y軸の実データ取得
                    if (double.IsNaN(csCell[0].m_dData[lSelectCellNum - 1]) == false)
                    {
                        dNumber_Y[iCnt] = csCell[0].m_dData[lSelectCellNum - 1];//Y軸の値を取得
                    }
                    else
                    {
                        dNumber_Y[iCnt] = HySDefine.dINVALID_VALUE;//数値ではない場合欠損値を代入
                    }
                }
            }
        }

        //1次元縦断モニターの実データ保存
        /// <summary>
        /// <para>method outline:</para>
        /// <para>実データの取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetRiverbedCellData(ref dMax)</para>
        /// </example>
        /// <param name="dMax">double：1次元配列の個数</param>
        /// <param name="lTPointCnt">long：選択番号</param>
        /// <returns>Y軸のデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private double[] GetRiverbedCellData(ref double dMax, long lTPointCnt)
        {
            //実データのある時間からデータを取得
            HySD1CellArrayData csCellData = m_csData[new HySString((lTPointCnt - 1).ToString())] as HySD1CellArrayData;
            //データを格納(ある時間のデータ)
            HySCellData[] csCell = csCellData.GetCellData();
            //データ個数の取得
            dMax = (double)csCell[0].m_dData.Length;

            //上記のデータからY軸の値を取り出す
            double[] dYRiverbed = new double[(int)dMax];//X軸の個数分
            for (int iCnt = 0; iCnt < (int)dMax; iCnt++)
            {
                if (double.IsNaN(csCell[0].m_dData[iCnt]) == true)
                {   //値がおかしいとき欠損値を代入
                    dYRiverbed[iCnt] = HySDefine.dINVALID_VALUE;
                }
                else
                {   //値が正常なとき実際の値を代入
                    dYRiverbed[iCnt] = csCell[0].m_dData[iCnt];
                }
            }
            //Y軸の値を返す
            return dYRiverbed;
        }

        //目盛表示個数決定
        /// <summary>
        /// <para>method outline:</para>
        /// <para>目盛表示個数決定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetDrawScaleMemory(lMaxScaleMemory, iFontHeight, iPicBoxHeight)</para>
        /// </example>
        /// <param name="lMaxScaleMemory">long：設定された目盛描画最大個数</param>
        /// <param name="iFontHeight">int：フォントの高さ(X軸の場合はWidth)</param>
        /// <param name="iPicBoxHeight">int：ピクチャーボックスの高さ(X軸の場合はWidth)</param>
        /// <returns>目盛描画個数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private long GetDrawScaleMemory(long lMaxScaleMemory, int iFontHeight, int iPicBoxHeight)
        {
            long lScaleMemory = lMaxScaleMemory;
            //目盛表示個数の決定
            if ((iPicBoxHeight / lMaxScaleMemory) < iFontHeight)
            {  // 最大描画行数補正が必要な場合
                for (int iStep = 1; iStep <= lMaxScaleMemory; iStep++)
                {
                    if ((iPicBoxHeight / iStep) < iFontHeight)
                    {  // 最大描画行数補正が必要有る場合
                        break;
                    }
                    else
                    {  // 最大描画行数補正が必要無い場合
                        lScaleMemory = iStep;
                    }
                }
            }
            return lScaleMemory;
        }

        //目盛表示間隔の決定
        /// <summary>
        /// <para>method outline:</para>
        /// <para>目盛表示間隔決定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetDrawScaleInterval(dInterval, dRange, lMemory)</para>
        /// </example>
        /// <param name="dInterval">double[]：設定された目盛間隔</param>
        /// <param name="dRange">double：表示範囲</param>
        /// <param name="lMemory">long：目盛表示個数</param>
        /// <returns>目盛表示間隔</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private long GetDrawScaleInterval(double[] dInterval, double dRange, long lMemory)
        {
            long lInterval = 0;
            for (int iStep = dInterval.GetLength(0) - 1; iStep >= 1; iStep--)
            {
                lInterval = (long)dInterval[iStep];
                if (Math.Floor(dRange / (double)lInterval) >= lMemory)
                {  // 商が無い場合
                    if (Math.Floor(dRange / (double)lInterval) > lMemory)
                    {  // ラベル個数が範囲外の場合
                        if (iStep != (dInterval.GetLength(0) - 1))
                        {  // 最終表示間隔以内の場合
                            lInterval = (long)dInterval[iStep + 1];
                        }
                    }
                    break;
                }
            }
            return lInterval;
        }


        //左軸目盛描画
        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸目盛描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawLeftScale(ref csBitmap, csPictureBox)</para>
        /// </example>
        /// <param name="csBitmap">Bitmap：目盛描画するビットマップ</param>
        /// <param name="csPictureBox">PictureBox：目盛描画するピクチャーボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawLeftScale(ref Bitmap csBitmap, PictureBox csPictureBox)
        {
            //Bitmapの初期化
            ClearBitmap(ref csBitmap);

            //表示するピクチャーボックスが存在することを確認
            if ((csPictureBox.Height > 0) && (csPictureBox.Width > 0))
            {
                //表示ビットマップを作成
                csBitmap = new Bitmap((int)csPictureBox.Width, (int)csPictureBox.Height);
                //グラフ描画のエリア設定
                Graphics g = Graphics.FromImage(csBitmap);

                //フォントの設定
                //Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, Properties.HysDotNetViewerResources.FONT_SIZE);

                //判定
                ValueDecision();

                SetLeftData(0);

                double dYLeftSBarValue = (double)m_csYLeftScrollBar.Value;//Y軸左側のスクロールバーの値
                double dYLeftSBarLargeChange = (double)m_csYLeftScrollBar.LargeChange;//Y軸左側のスクロールバーのLargeChange
                double dYRange = m_dLeftSetMax - m_dLeftSetMin;
                double dLeftMax = m_dLeftSetMin + (1.0 - (dYLeftSBarValue / ((double)m_csYLeftScrollBar.Maximum + 1.0))) * dYRange;//Y軸の表示最大値
                double dLeftMin = m_dLeftSetMin + (1.0 - (dYLeftSBarValue + dYLeftSBarLargeChange) / ((double)m_csYLeftScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最小値

                //表示範囲
                double dRange = dLeftMax - dLeftMin;

                //グラフ表示ピクチャーボックスの大きさの取得
                double dLeftGraphWidth = csPictureBox.Width - 10;//m_csCntlInfo[0].m_csGraphPictureBox.Width;
                double dLeftGraphHeight = csPictureBox.Height - 10;//m_csCntlInfo[0].m_csGraphPictureBox.Height;

                //
                double dScaleNum_Y = dLeftGraphHeight / dRange;//単位Y軸量あたりのピクセル数

                //目盛表示個数の取得
                long lLeftMemory = GetDrawScaleMemory(m_lLeftScaleMemory, csFnt.Height, csPictureBox.Height);
                //目盛表示間隔の取得
                long lLeftInterval = GetDrawScaleInterval(m_dLeftInterval, dRange, lLeftMemory);

                //目盛値取得用変数
                double dNowMin = dLeftMin;//表示する最小値を初期値に

                //最小値を目盛間隔で割る(余りの取得)
                double dRest = dNowMin % (double)lLeftInterval;


                if (dRest != 0)
                {
                    dNowMin = dNowMin - dRest;//きりのいい数字を取得
                }
                //目盛描画場所
                double dYLocation = csPictureBox.Height - 5.0 + dRest * dScaleNum_Y;


                //目盛描画処理
                for (int iCnt = 0; iCnt <= lLeftMemory + 1; iCnt++)
                {
                    if (dYLocation <= csPictureBox.Height - 5 && dYLocation > 4)
                    {
                        g.DrawLine(new Pen(Color.Black, 1), csPictureBox.Width - 3,
                                               (float)(dYLocation), csPictureBox.Width - 0, (float)(dYLocation));
                        if (((string)Math.Floor(dNowMin).ToString()).Length >= 7)
                        {  // ７桁を超える場合
                            //g.DrawString(Math.Floor(dNowMin).ToString("0E00"), csFnt, Brushes.Black, 0, (float)(dYLocation - 4.0));
                            g.DrawString(Math.Floor(dNowMin).ToString("0E00"), csFnt, Brushes.Black, 0, (float)(dYLocation - Properties.HysDotNetViewerResources.FONT_MARGIN_Y));
                        }
                        else
                        {  // ７桁以内の場合
                            //g.DrawString(Math.Floor(dNowMin).ToString(), csFnt, Brushes.Black, 0, (float)(dYLocation - 4.0));
                            g.DrawString(Math.Floor(dNowMin).ToString(), csFnt, Brushes.Black, 0, (float)(dYLocation - Properties.HysDotNetViewerResources.FONT_MARGIN_Y));
                        }
                    }
                    dYLocation = dYLocation - (double)lLeftInterval * dScaleNum_Y;
                    dNowMin = dNowMin + (double)lLeftInterval;
                }
                csFnt.Dispose(); // フォントリソース解放
                g.Dispose(); // グラフ描画エリア解放
            }
        }


        //X軸目盛描画処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸目盛描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawXScale(ref csBitmap, csPictureBox)</para>
        /// </example>
        /// <param name="csBitmap">Bitmap：目盛描画するビットマップ</param>
        /// <param name="csPictureBox">PictureBox：目盛描画するピクチャーボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawXScale(ref Bitmap csBitmap, PictureBox csPictureBox)
        {
            //Bitmapの初期化
            ClearBitmap(ref csBitmap);

            //表示するピクチャーボックスが存在することを確認
            if ((csPictureBox.Height > 0) && (csPictureBox.Width > 0))
            {
                //ビットマップの作成
                csBitmap = new Bitmap((int)csPictureBox.Width, (int)csPictureBox.Height);
                //グラフ描画のエリア設定
                Graphics g = Graphics.FromImage(csBitmap);

                //フォントの設定
                //Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, Properties.HysDotNetViewerResources.FONT_SIZE);
                StringFormat csSf = new StringFormat();
                csSf.FormatFlags = StringFormatFlags.DirectionVertical;

                double dXMax = 0;
                double dXMin = 0;
                //位置の取得
                if (m_csXScrollBar != null)
                {
                    double dXSBarValue = (double)m_csXScrollBar.Value;//X軸のスクロールバーの値
                    double dXSBarLargeChange = (double)m_csXScrollBar.LargeChange;//X軸のスクロールバーのLargeChange
                    double dXRange = m_dXSetMax - m_dXSetMin;//全体の範囲
                    if (dXRange == 0.0)
                    {
                        dXRange = 60.0;
                    }
                     dXMax = m_dXSetMin + ((dXSBarValue + dXSBarLargeChange) / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最大値
                     dXMin = m_dXSetMin + (dXSBarValue / ((double)m_csXScrollBar.Maximum + 1.0)) * dXRange;//X軸の表示最小値
                }
                //表示範囲
                double dRange = dXMax - dXMin;//表示されている範囲

                //グラフ表示ピクチャーボックスの大きさの取得
                double dXGraphWidth = csPictureBox.Width - 10;
                double dXGraphHeight = csPictureBox.Height - 10;

                double dScaleNum_X = dXGraphWidth / dRange;//単位Y軸量あたりのピクセル数

                //目盛表示個数の取得
                long lXMemory = 12;//GetDrawScaleMemory(m_lLeftScaleMemory, csFnt.Height, csPictureBox.Height);
                //目盛表示間隔の取得
                long lXInterval = GetDrawScaleInterval(m_dXInterval, dRange, lXMemory);

                //目盛値取得用変数
                double dNowMin = dXMin;//表示する最小値を初期値に

                //最小値を目盛間隔で割る(余りの取得)
                double dRest = dNowMin % (double)lXInterval;

                if (dRest != 0)
                {
                    dNowMin = dNowMin - dRest;//きりのいい数字を取得
                }

                //目盛描画場所
                double dXLocation = 5.0 + ( - dRest) * dScaleNum_X;

                //目盛描画処理
                for (int iCnt = 0; iCnt <= lXMemory + 1; iCnt++)
                {
                    if (dXLocation < csPictureBox.Width - 4 && dXLocation > 4)
                    {
                        g.DrawLine(new Pen(Color.Black, 1), (float)(dXLocation), 0, (float)(dXLocation), 3);//線を引く

                        HySTime csTime = new HySTime(dNowMin);
                        string sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                                                    HySCalendar.FORMAT.lSW_YEAR).ToString()).ToString("MM/dd HH:mm");
                        //g.DrawString(sWk, csFnt, Brushes.Black, (float)(dXLocation - 10), 5, csSf);
                        g.DrawString(sWk, csFnt, Brushes.Black, (float)(dXLocation - Properties.HysDotNetViewerResources.FONT_MARGIN_X), 5, csSf);
                    }
                    dXLocation = dXLocation + (double)lXInterval * dScaleNum_X;
                    dNowMin = dNowMin + (double)lXInterval;
                }
            }
        }


        //右軸目盛描画処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸目盛描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRightScale(ref csBitmap, csPictureBox)</para>
        /// </example>
        /// <param name="csBitmap">Bitmap：目盛描画するビットマップ</param>
        /// <param name="csPictureBox">PictureBox：目盛描画するピクチャーボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawRightScale(ref Bitmap csBitmap, PictureBox csPictureBox)
        {
            //Bitmapの初期化
            ClearBitmap(ref csBitmap);

            //表示するピクチャーボックスが存在することを確認
            if ((csPictureBox.Height > 0) && (csPictureBox.Width > 0))
            {
                //表示ビットマップを作成
                csBitmap = new Bitmap((int)csPictureBox.Width, (int)csPictureBox.Height);
                //グラフ描画のエリア設定
                Graphics g = Graphics.FromImage(csBitmap);

                //フォントの設定
                //Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, Properties.HysDotNetViewerResources.FONT_SIZE);

                //判定
                ValueDecision();

                double dYRightSBarValue = (double)m_csYRightScrollBar.Value;//Y軸左側のスクロールバーの値
                double dYRightSBarLargeChange = (double)m_csYRightScrollBar.LargeChange;//Y軸左側のスクロールバーのLargeChange
                double dYRange = m_dRightSetMax - m_dRightSetMin;
                double dRightMax = m_dRightSetMin + ((dYRightSBarValue + dYRightSBarLargeChange) / ((double)m_csYRightScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最大値
                double dRightMin = m_dRightSetMin + (dYRightSBarValue / ((double)m_csYRightScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最小値

                
                //表示範囲
                double dRange = dRightMax - dRightMin;

                //グラフ表示ピクチャーボックスの大きさの取得
                double dRightGraphWidth = csPictureBox.Width - 10;//m_csCntlInfo[0].m_csGraphPictureBox.Width;
                double dRightGraphHeight = csPictureBox.Height - 10;//m_csCntlInfo[0].m_csGraphPictureBox.Height;

                //
                double dScaleNum_Y = dRightGraphHeight / dRange;//単位Y軸量あたりのピクセル数

                //目盛表示個数の取得
                long lRightMemory = GetDrawScaleMemory(m_lRightScaleMemory, csFnt.Height, csPictureBox.Height);
                //目盛表示間隔の取得
                long lRightInterval = GetDrawScaleInterval(m_dRightInterval, dRange, lRightMemory);

                //目盛値取得用変数
                double dNowMin = dRightMin;//表示する最小値を初期値に

                //最小値を目盛間隔で割る(余りの取得)
                double dRest = dNowMin % (double)lRightInterval;


                if (dRest != 0)
                {
                    dNowMin = dNowMin - dRest;//きりのいい数字を取得
                }
                //目盛描画場所
                double dYLocation =   5.0 - dRest * dScaleNum_Y;


                //目盛描画処理
                for (int iCnt = 0; iCnt <= lRightMemory + 1; iCnt++)
                {
                    if (dYLocation <= csPictureBox.Height - 5 && dYLocation > 4)
                    {
                        g.DrawLine(new Pen(Color.Black, 1), 0,
                                               (float)(dYLocation), 3, (float)(dYLocation));
                        if (((string)Math.Floor(dNowMin).ToString()).Length >= 7)
                        {  // ７桁を超える場合
                            //g.DrawString(Math.Floor(dNowMin).ToString("0E00"), csFnt, Brushes.Black, 5, (float)(dYLocation - 4.0));
                            g.DrawString(Math.Floor(dNowMin).ToString("0E00"), csFnt, Brushes.Black, 5, (float)(dYLocation - Properties.HysDotNetViewerResources.FONT_MARGIN_Y));
                        }
                        else
                        {  // ７桁以内の場合
                            //g.DrawString(Math.Floor(dNowMin).ToString(), csFnt, Brushes.Black, 5, (float)(dYLocation - 4.0));
                            g.DrawString(Math.Floor(dNowMin).ToString(), csFnt, Brushes.Black, 5, (float)(dYLocation - Properties.HysDotNetViewerResources.FONT_MARGIN_Y));
                        }
                    }
                    dYLocation = dYLocation + (double)lRightInterval * dScaleNum_Y;
                    dNowMin = dNowMin + (double)lRightInterval;
                }
                csFnt.Dispose(); // フォントリソース解放
                g.Dispose(); // グラフ描画エリア解放
            }
        }


        //1次元モニター画面描画処理
        /// <summary>
        /// <para>method outline:</para>
        /// <para>1次元モニター画面描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRiverbedFullMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawRiverbedFullMonitor(long lCommonNum)
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmap);//全範囲ビットマップを初期化
            //ClearBitmap(m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //全範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmap = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                         m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csBmap.Size.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csBmap.Size.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmap); // グラフ描画エリア設定

            //データの個数
            long lDataNum = m_csData.GetCount();
            if (lDataNum > 0)
            {
                long lDataSave = SetLeftData(lDataNum);

                //描画範囲の取得(実際の数値)
                double dMax_X = 10;//X軸の最大値
                double dMin_X = 1;//X軸の表示最小値
                double dMax_Y = m_dLeftSetMax;//Y軸の表示最大値
                double dMin_Y = m_dLeftSetMin;//Y軸の表示最小値

                //実データの取得
                double[] dNumber_X = new double[lDataNum];//X軸の実データ
                double[] dNumber_Y = null;//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//線描画時の左側のX座標
                double dLocation_X2 = 0.0;//線描画時の右側のX座標
                double dLocation_Y1 = 0.0;//線描画時の左側のY座標
                double dLocation_Y2 = 0.0;//線描画時の右側のY座標

                //実データの取得処理
                long lTPointCnt = m_csData.GetCount();
                dNumber_Y = GetRiverbedCellData(ref dMax_X, lTPointCnt);

                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //描画処理
                for (int iCnt = 1; iCnt < (int)dMax_X; iCnt++)
                {
                    if (dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {
                        //X軸の座標を設定
                        dLocation_X1 = (iCnt - 1) * dScaleNum_X;
                        dLocation_X2 = iCnt * dScaleNum_X;
                        //Y軸の座標を設定
                        dLocation_Y1 = ((dMax_Y - dNumber_Y[iCnt - 1]) * dScaleNum_Y);
                        dLocation_Y2 = ((dMax_Y - dNumber_Y[iCnt]) * dScaleNum_Y);

                        if (g is Graphics)
                        {
                            g.DrawLine(new Pen(Color.FromArgb(80, 167, 14), 2),//現在決めうちのため後で改修
                                (float)dLocation_X1, (float)dLocation_Y1, (float)dLocation_X2, (float)dLocation_Y2);
                        }

                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>1次元縦断モニター指定範囲描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRiverbedScopeMonitor(lCommonNum)</para>
        /// </example>
        /// <param name="lCommonNum">long：HySDispInstanceCommonの番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawRiverbedScopeMonitor(long lCommonNum)
        {
            //グラフィクスクラスの用意
            Graphics g = null;
            //Bitmapを初期化する
            ClearBitmap(ref m_csCntlInfo[lCommonNum].m_csBmapRange);//範囲指定ビットマップを初期化

            //指定範囲ビットマップを作成
            m_csCntlInfo[lCommonNum].m_csBmapRange = new Bitmap(m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width,
                                                                m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height);

            //Bitmapの大きさの取得
            double BitmapSize_X = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Width;//ビットマップの横幅
            double BitmapSize_Y = m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Height;//ビットマップの縦幅

            g = Graphics.FromImage(m_csCntlInfo[lCommonNum].m_csBmapRange);  // グラフ描画エリア設定

            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];
            long lDataNum = m_csData.GetCount();

            if (lDataNum > 0)
            {
                long lDataSave = SetLeftData(lDataNum);

                //各スクロールバーの値を取得
                //double dXSBarValue = (double)m_csXScrollBar.Value;//X軸のスクロールバーの値
                //double dXSBarLargChange = (double)m_csXScrollBar.LargeChange;//X軸のスクロールバーのLargeChange
                double dYLeftSBarValue = (double)m_csYLeftScrollBar.Value;//Y軸左側のスクロールバーの値
                double dYLeftSBarLargeChange = (double)m_csYLeftScrollBar.LargeChange;//Y軸左側のスクロールバーのLargeChange
                //各軸の範囲（実際の値の最大-最小）
                double dXRange = m_dXSetMax - m_dXSetMin;
                double dYRange = m_dLeftSetMax - m_dLeftSetMin;

                //描画範囲の取得(実際の数値)
                double dMax_X = 10;//X軸の表示最大値
                double dMin_X = 1;//X軸の表示最小値
                double dMax_Y = m_dLeftSetMin + (1.0 - (dYLeftSBarValue / ((double)m_csYLeftScrollBar.Maximum + 1.0))) * dYRange;//Y軸の表示最大値
                double dMin_Y = m_dLeftSetMin + (1.0 - (dYLeftSBarValue + dYLeftSBarLargeChange) / ((double)m_csYLeftScrollBar.Maximum + 1.0)) * dYRange;//Y軸の表示最小値

                //実データの取得
                double[] dNumber_X = new double[lDataNum];//X軸の実データ
                double[] dNumber_Y = null;//Y軸の実データ

                //描画座標
                double dLocation_X1 = 0.0;//線描画時の左側のX座標
                double dLocation_X2 = 0.0;//線描画時の右側のX座標
                double dLocation_Y1 = 0.0;//線描画時の左側のY座標
                double dLocation_Y2 = 0.0;//線描画時の右側のY座標

                //データの設定
                m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lCommonNum];

                //実データの取得処理
                dNumber_Y = GetRiverbedCellData(ref dMax_X, m_lTPointCnt);

                //表示スケール値
                double dScaleNum_X = BitmapSize_X / (dMax_X - dMin_X);//単位X軸量あたりのピクセル数
                double dScaleNum_Y = BitmapSize_Y / (dMax_Y - dMin_Y);//単位Y軸量あたりのピクセル数

                //描画処理
                for (int iCnt = 1; iCnt < (int)dMax_X; iCnt++)
                {
                    if (dNumber_Y[iCnt - 1] != HySDefine.dINVALID_VALUE)
                    {  //正常値のとき
                        //X軸の座標を設定
                        dLocation_X1 = (iCnt - 1) * dScaleNum_X;
                        dLocation_X2 = iCnt * dScaleNum_X;
                        //Y軸の座標を設定
                        dLocation_Y1 = ((dMax_Y - dNumber_Y[iCnt - 1]) * dScaleNum_Y);
                        dLocation_Y2 = ((dMax_Y - dNumber_Y[iCnt]) * dScaleNum_Y);

                        if (g is Graphics)
                        {
                            g.DrawLine(new Pen(Color.FromArgb(80, 167, 14), 2),//現在決めうちのため後で改修
                                (float)dLocation_X1, (float)dLocation_Y1, (float)dLocation_X2, (float)dLocation_Y2);
                        }

                    }
                }
            }
            //解放
            g.Dispose();
            m_csCntlInfo[lCommonNum].m_csGraphPictureBox.Invalidate();
        }

        //データが一つの場合
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ1つの時のデータ挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPlusData(ref dNumber_X, ref dNumber_Y)</para>
        /// </example>
        /// <param name="dNumber_X">double[]：X軸の値</param>
        /// <param name="dNumber_Y">double[]：Y軸の値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetPlusData(ref double[] dNumber_X, ref double[] dNumber_Y)
        {
            dNumber_X[1] = dNumber_X[0];
            dNumber_Y[1] = 0.0;
        }

        //データが一つの場合
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ1つの時のデータ挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLeftData(lDataNum)</para>
        /// </example>
        /// <param name="lDataNum">long：データの個数</param>
        /// <returns>データの個数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private long SetLeftData(long lDataNum)
        {
            if (lDataNum == 1)
            {
                lDataNum = 2;
                m_dXSetMax = m_dXSetMin + 60;
            }

            if (m_dLeftSetMax < 1.0 && m_dLeftSetMin == 0.0)
            {
                m_dLeftSetMax = 1.1;
            }
            return lDataNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>1次元縦断モニター時間ラベル描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawRiverbedTimeLabel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string DrawRiverbedTimeLabel()
        {
            string sDisplayTime = "";
            if (m_csInstanceCommon != null)
            {
                HySDataHashTable csHashTable = (m_csInstanceCommon.GetDataHashTableArray())[0];
                HySD1CellArrayData csCellData = csHashTable[new HySString((m_lTPointCnt - 1).ToString())] as HySD1CellArrayData;//データの取り出し
                if (csCellData != null)
                {  //データがある場合
                    HySTime csTime = csCellData.GetLastTime();//時間をHySTime型で取得
                    sDisplayTime = Properties.HysDotNetViewerResources.MONITER_TIME + DateTime.Parse(HySCalendar.GetString(csCellData.GetLastTime(),
                                                                    HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString()).ToString("g");   //"時刻："
                }
            }
            return sDisplayTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コントロールオブジェクトの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawCheckControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawCheckControl()
        {
            if (m_csInstanceCommon == null)
            {   //データクラスがないとき（計算していないとき）
                if (m_csYLeftScrollBar != null)
                {   //左軸のスクロールバーが有効なとき
                    UnableLeftControl();
                    m_bLeftControl = false;
                }
                if (m_csYRightScrollBar != null)
                {   //右軸のスクロールバーが有効なとき(ハイエトハイドロモニター)
                    UnableRightControl();
                    m_bRightControl = false;
                }
                if (m_csXScrollBar != null)
                {
                    UnableXControl();
                }
            }
            else
            {     //データクラスがあるとき(計算をしたことがある)
                long lArray = m_csInstanceCommon.GetDataHashTableArray().GetLength(0);
                for (int iCnt = 0; iCnt < (int)lArray; iCnt++)
                {
                    long lCount = (m_csInstanceCommon.GetDataHashTableArray())[iCnt].GetCount();
                    if (lCount > 0)
                    {   //演算結果がリセットされたとき
                        if (m_csCntlInfo[iCnt].m_csVarticalType.Equals(VERTICAL_LEFT) == true && m_bLeftControl == false)
                        {   //左軸のスクロールバーが有効なとき
                            EnableLeftControl();
                            m_bLeftControl = true;
                            if (m_csXScrollBar != null)
                            {
                                EnableXControl();
                            }
                        }
                        if (m_csCntlInfo[iCnt].m_csVarticalType.Equals(VERTICAL_RIGHT) == true && m_bRightControl == false)
                        {   //右軸のスクロールバーが有効なとき(ハイエトハイドロモニター)
                            EnableRightControl();
                            m_bRightControl = true;
                            if (m_csXScrollBar != null)
                            {
                                EnableXControl();
                            }
                        }
                    }
                    else
                    {
                        if (m_csYLeftScrollBar != null && m_bLeftControl == true)
                        {   //左軸のスクロールバーが有効なとき
                            UnableLeftControl();
                            m_bLeftControl = false;
                        }
                        if (m_csYRightScrollBar != null && m_bRightControl == true)
                        {   //右軸のスクロールバーが有効なとき(ハイエトハイドロモニター)
                            UnableRightControl();
                            m_bRightControl = false;
                        }
                        if (m_csXScrollBar != null && m_bLeftControl == false && m_bRightControl == false)
                        {
                            UnableXControl();
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸コントロール有効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>EnableLeftControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EnableLeftControl()
        {
            m_csYLeftTrackBar.Enabled = true;        //トラックバー無効
            m_csYLeftNumericUpDownMax.Enabled = false;//最大値設定無効
            m_csYLeftCheckBoxMax.Enabled = true;     //最大値選択無効
            m_csYLeftCheckBoxMax.Checked = false;
            m_csYLeftNumericUpDownMin.Enabled = true;//最小値設定無効
            m_csYLeftCheckBoxMin.Enabled = true;     //最小値選択無効
            m_csYLeftCheckBoxMin.Checked = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸コントロール有効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>EnableRightControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EnableRightControl()
        {
            m_csYRightTrackBar.Enabled = true;        //トラックバー無効
            m_csYRightNumericUpDownMax.Enabled = false;//最大値設定無効
            m_csYRightCheckBoxMax.Enabled = true;     //最大値選択無効
            m_csYRightCheckBoxMax.Checked = false;
            m_csYRightNumericUpDownMin.Enabled = true;//最小値設定無効
            m_csYRightCheckBoxMin.Enabled = true;     //最小値選択無効
            m_csYRightCheckBoxMin.Checked = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左軸コントロール無効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UnableLeftControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UnableLeftControl()
        {
            m_csYLeftTrackBar.Enabled = false;        //トラックバー無効
            m_csYLeftNumericUpDownMax.Enabled = false;//最大値設定無効
            m_csYLeftCheckBoxMax.Enabled = false;     //最大値選択無効
            m_csYLeftNumericUpDownMin.Enabled = false;//最小値設定無効
            m_csYLeftCheckBoxMin.Enabled = false;     //最小値選択無効
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右軸コントロール無効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UnableRightControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UnableRightControl()
        {
            m_csYRightTrackBar.Enabled = false;        //トラックバー無効
            m_csYRightNumericUpDownMax.Enabled = false;//最大値設定無効
            m_csYRightCheckBoxMax.Enabled = false;     //最大値選択無効
            m_csYRightNumericUpDownMin.Enabled = false;//最小値設定無効
            m_csYRightCheckBoxMin.Enabled = false;     //最小値選択無効
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸コントロール有効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>EnableXControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EnableXControl()
        {
            m_csXTrackBar.Enabled = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>X軸コントロール無効化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UnableXControl()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UnableXControl()
        {
            m_csXTrackBar.Enabled = false;
        }
    }
}
