﻿// <summary>ソースコード：計算結果モニタ基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>計算結果モニタ基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetMoniterBaseForm : Form, HySMoniterFormIF
    {
        // 画面位置定数定義
        /// <summary>画面幅調整値</summary>
        static private readonly int FORM_WIDTH_DEFAULT = 360;
        /// <summary>画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_ADJUSTED_VALUE = 428;
        /// <summary>画面配置デスクトップ座標X</summary>
        static private int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 310;
        /// <summary>画面配置デスクトップ座標X調整値</summary>
        static private readonly int DESKTOP_LOCATION_X_ADJUSTED_VALUE = 8;
        /// <summary>画面配置デスクトップ座標Y調整値</summary>
        static private readonly int DESKTOP_LOCATION_Y_ADJUSTED_VALUE = 45;

        // 配置情報関連
        /// <summary>画面幅規定値</summary>
        protected int iWidth_Default = 0;
        /// <summary>画面高さ規定値</summary>
        protected int iHeight_Default = 0;
        /// <summary>画面高さ調整値</summary>
        protected int iHeight_Adjusted = 0;
        /// <summary>画面幅調整値</summary>
        protected int iWidth_Adjusted = 0;
        /// <summary>画面配置デスクトップ座標X</summary>
        protected int iLocattion_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        protected int iLocattion_Y = 0;

        // 共通インスタンス関連
        /// <summary>画面インスタンス識別ＩＤ</summary>
        protected HySID m_csID;  // 画面インスタンス識別ＩＤ
        /// <summary>送信元シミュレーション種別識別子</summary>
        protected HySObjectKind m_csFromSimKind = null;
        /// <summary>スクリーン</summary>
        protected HySScreen m_csScreen = null;
        /// <summary>データコンテナ</summary>
        protected HySContainer m_csContainer = null;
        /// <summary>表示業務管理データ</summary>
        protected HySDispBusiProcedureCtlInfo m_csDBPCtlInfo = null;
        /// <summary>画面表示要求フラグ</summary>
        protected bool m_bDispFlg = true;
        /// <summary>画面表示要求フラグ</summary>
        protected CntlInfo[] m_csCntlInfo = null;
        /// <summary>フォーム一貫番号</summary>
        protected long m_lNumber = 0;

        // フォーム部品インスタンス
        /// <summary>タイマーインスタンス</summary>
        protected Timer m_csTimerInstance = null;
        /// <summary>抑止部品インスタンス</summary>
        protected List<Control> m_csControl = null;
        /// <summary>水平軸スケール描画エリア</summary>
        protected PictureBox m_csXUnderScalePictureBox = null;
        /// <summary>垂直軸左端スケール描画エリア</summary>
        protected PictureBox m_csYLeftScalePictureBox = null;
        /// <summary>垂直軸右端スケール描画エリア</summary>
        protected PictureBox m_csYRightScalePictureBox = null;
        /// <summary>水平軸スクロールバー</summary>
        protected HScrollBar m_csXUnderScrollBar = null;
        /// <summary>垂直左端軸スクロールバー</summary>
        protected VScrollBar m_csYLeftScrollBar = null;
        /// <summary>垂直右端軸スクロールバー</summary>
        protected VScrollBar m_csYRightScrollBar = null;
        /// <summary>水平軸拡大率バー</summary>
        protected TrackBar m_csXZoomBar = null;
        /// <summary>水平軸拡大率表示ラベル</summary>
        protected Label m_csXZoomLabel = null;
        /// <summary>垂直左端軸拡大率バー</summary>
        protected TrackBar m_csYLeftZoomBar = null;
        /// <summary>垂直左端軸拡大率表示ラベル</summary>
        protected Label m_csYLeftZoomLabel = null;
        /// <summary>垂直右端軸拡大率バー</summary>
        protected TrackBar m_csYRightZoomBar = null;
        /// <summary>垂直右端軸拡大率表示ラベル</summary>
        protected Label m_csYRightZoomLabel = null;

        // グラフスケール情報関連
        /// <summary>Ｙ軸左端メモリビットマップ情報</summary>
        protected Bitmap m_csBmapYLeft = null;
        /// <summary>Ｙ軸右端メモリビットマップ情報</summary>
        protected Bitmap m_csBmapYRight = null;
        /// <summary>Ｘ軸メモリビットマップ情報</summary>
        protected Bitmap m_csBmapXUnder = null;

        // 伝送データ（演算結果データ）関連
        /// <summary>データクラス</summary>
        protected HySDispInstanceCommon m_csInstanceCommon = null;
        /// <summary>ハッシュテーブルインスタンス</summary>
        protected HySDataHashTable m_csData = null;
        /// <summary>表示対象セル番号</summary>
        protected long m_lCellSelectNum = 1;

        // 描画状態管理関連
        /// <summary>描画間隔調整フラグ</summary>
        protected bool m_bDispMode = false;
        /// <summary>リセット実施有無フラグ</summary>
        protected bool m_bResetFlg = true;

        // 表示範囲（マスタ）関連
        /// <summary>水平軸最小値(基準値)</summary>
        protected double m_dXScaleMinConst = 0.0;
        /// <summary>水平軸最大値(基準値)</summary>
        protected double m_dXScaleMaxConst = 0.0;
        /// <summary>垂直左端軸最小値(基準値)</summary>
        protected double m_dYLeftScaleMinConst = 0.0;
        /// <summary>垂直左端最大値(基準値)</summary>
        protected double m_dYLeftScaleMaxConst = 0.0;
        /// <summary>垂直右端軸最小値(基準値)</summary>
        protected double m_dYRightScaleMinConst = 0.0;
        /// <summary>垂直右端最大値(基準値)</summary>
        protected double m_dYRightScaleMaxConst = 0.0;
        /// <summary>X軸最小値</summary>
        protected double m_dXScaleMin_Mst = 0.0;
        /// <summary>X軸最大値</summary>
        protected double m_dXScaleMax_Mst = 0.0;
        /// <summary>X軸目盛間隔</summary>
        protected double m_dXScale_Mst = 3600.0;
        /// <summary>Y軸左端最小値</summary>
        protected double m_dYLeftScaleMin_Mst = 0.0;
        /// <summary>Y軸左端最大値</summary>
        protected double m_dYLeftScaleMax_Mst = 0.0;
        /// <summary>Y軸左端目盛間隔</summary>
        protected double m_dYLeftScale_Mst = 100.0;
        /// <summary>Y軸右端最小値</summary>
        protected double m_dYRightScaleMin_Mst = 0.0;
        /// <summary>Y軸右端最大値</summary>
        protected double m_dYRightScaleMax_Mst = 0.0;
        /// <summary>Y軸右端目盛間隔</summary>
        protected double m_dYRightScale_Mst = 10.0;

        // 表示範囲（制御）関連
        /// <summary>X軸最小値</summary>
        protected double m_dXScaleMin = 0.0;
        /// <summary>X軸最大値</summary>
        protected double m_dXScaleMax = 0.0;
        /// <summary>X軸スケール範囲外補正値 </summary>
        protected double m_dXDltCpc = 0.0;
        /// <summary>X軸目盛間隔</summary>
        protected double m_dXScale = 0.0;
        /// <summary>Y軸左端最小値</summary>
        protected double m_dYLeftScaleMin = 0.0;
        /// <summary>Y軸左端最大値</summary>
        protected double m_dYLeftScaleMax = 0.0;
        /// <summary>Y軸左端目盛間隔</summary>
        protected double m_dYLeftScale = 0.0;
        /// <summary>Y軸右端最小値</summary>
        protected double m_dYRightScaleMin = 0.0;
        /// <summary>Y軸右端最大値</summary>
        protected double m_dYRightScaleMax = 0.0;
        /// <summary>Y軸右端目盛間隔</summary>
        protected double m_dYRightScale = 0.0;
        /// <summary>Y軸左端目盛間隔</summary>
        protected bool m_dYLeftScaleCheck = false;
        /// <summary>Y軸左端最小値設定</summary>
        protected bool m_dYMinLeftScaleCheck = true;
        /// <summary>Y軸左端表示最小値</summary>
        protected double m_dYLeftScaleMinNumber = 0.0;
        /// <summary>Y軸左端表示最大値</summary>
        protected double m_dYLeftScaleMaxNumber = 0.0;
        /// <summary>Y軸右端目盛間隔</summary>
        protected bool m_dYRightScaleCheck = false;
        ///<summary>Y軸右端最小値設定</summary>
        protected bool m_dYMinRightScaleCheck = true;
        /// <summary>Y軸右端表示最小値</summary>
        protected double m_dYRightScaleMinNumber = 0.0;
        /// <summary>Y軸右端表示最大値</summary>
        protected double m_dYRightScaleMaxNumber = 0.0;

        // フォーム制御関連
        /// <summary>フォームアクティブ状態</summary>
        protected bool m_bActive = false;
        /// <summary>表示範囲設定状態</summary>
        protected bool m_bFromStatus = false;
        /// <summary>水平軸スクロール操作状態</summary>
        protected bool m_bXManualFlg = false;
        /// <summary>水平軸前回スケール変更値</summary>
        protected double m_dXValue = 0.0;
        /// <summary>水平軸表示スケール率</summary>
        protected double m_dXRato = 1.0;
        /// <summary>垂直軸左端スクロール操作状態</summary>
        protected bool m_bYLeftManualFlg = false;
        /// <summary>垂直軸左端前回スケール変更値</summary>
        protected double m_dYLeftValue = 0.0;
        /// <summary>垂直軸左端表示スケール率</summary>
        protected double m_dYLeftRato = 1.0;
        /// <summary>垂直軸右端スクロール操作状態</summary>
        protected bool m_bYRightManualFlg = false;
        /// <summary>垂直軸右端前回スケール変更値</summary>
        protected double m_dYRightValue = 0.0;
        /// <summary>垂直軸右端表示スケール率</summary>
        protected double m_dYRightRato = 1.0;
        /// <summary>画面タイトル</summary>
        protected HySString m_csForm_Title = null;

        // グラフィック描画基準値関連
        /// <summary>グラフ描画件数閾値</summary>
        protected long m_lGraphDataMax = 5000;
        /// <summary>グラフ描画拡大Ｘ軸比率閾値</summary>
        protected double m_dGraphXRatoMax = 0.1;
        /// <summary>グラフ描画拡大Ｙ軸比率閾値</summary>
        protected double m_dGraphYRatoMax = 0.1;
        /// <summary>水平軸間隔</summary>
        protected double[] m_dXInterval = null;
        /// <summary>垂直左端軸間隔</summary>
        protected double[] m_dYLeftInterval = null;
        /// <summary>垂直右端軸間隔</summary>
        protected double[] m_dYRightInterval = null;
        /// <summary>描画色件数</summary>
        protected long m_lColorNum = 0;
        /// <summary>描画色左端基準先頭件数</summary>
        protected long m_lColorNum_Mst = 0;
        /// <summary>メモリのライン幅</summary>
        protected long m_lMemoryWidth = 1;
        /// <summary>演算結果線のライン幅</summary>
        protected long m_lLineWidth = 2;
        /// <summary>グラフ描画色</summary>
        protected readonly string[] m_sColor = { "#50a70e","#0e50a7","#d32012", "#30c411","#1130c4","#b2440f",
                                                 "#12d320","#2012d3","#a70e50", "#0fb244","#440fb2","#c41130",
                                                 "#9a5e0d","#0d9a5e","#5e0d9a", "#88720c","#0c8872","#720c88",
                                                 "#79810b","#0b7981","#810b79", "#67920c","#0c6792","#920c67" };
        /// <summary>垂直左端基準</summary>
        protected readonly HySObjectKind VERTICAL_LEFT = new HySObjectKind("csVerticalLeft");
        /// <summary>垂直右端基準</summary>
        protected readonly HySObjectKind VERTICAL_RIGHT = new HySObjectKind("csVerticalRight");
        /// <summary>垂直メモリ描画行数</summary>
        protected readonly long VERTICAL_MEMORY_STEP = 10;

        /// <summary>描画クラス</summary>
        public HySDotNetDrawMonitor m_csDrawMonitor = null;
        /// <summary>セル数保存</summary>
        protected long m_lCellSave = 1;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ダブルバッファー設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDoubleBuffer( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDoubleBuffer()
        {
            this.SetStyle(
                ControlStyles.OptimizedDoubleBuffer |// ダブルバッファー
                ControlStyles.UserPaint |            // 描画は（ＯＳでなく）独自に行う
                ControlStyles.AllPaintingInWmPaint,  // WM_ERASEBKGND を無視する
                true                                 // 指定したスタイルを適用「する」
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>対となるスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetScreen(HySScreen csScreen)
        {
            m_csScreen = csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 画面種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetViewKind()
        {
            return ((HySScreenBase)m_csScreen).GetViewKind();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">画面種別</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean EqualViewKind(HySKind csViewKindID)
        {
            return ((HySScreenBase)m_csScreen).EqualViewKind(csViewKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Show() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new void Show()
        {
            m_bActive = true; // フォームアクティブ設定
            if (m_csID is HySID)
            {  // 要素ＩＤが有る場合
                this.Text = m_csForm_Title.ToString() + "-" + m_csID.ToString();
            }
            base.Show();
            this.Focus();
            SetTimerEnable(true); // 表示周期タイマー再開
        }

        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Hide() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new void Hide()
        {
            m_bActive = false; // フォーム非アクティブ設定
            base.Hide();
            SetTimerEnable(false);    // 表示周期タイマー停止
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Renew()
        {
            this.Show();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Close( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new void Close()
        {
            this.AllDataInit(); // エリアの解放
            base.Close(); // 画面を閉じる
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Initialize()
        {
            int iSa = 0;

            // 初期配置情報初期化
            iWidth_Default = FORM_WIDTH_DEFAULT;
            iHeight_Adjusted = FORM_HEIGHT_ADJUSTED_VALUE;
            if (m_lNumber > 0)
            {  // フォーム一貫番号が有効な場合
                iSa = (int)((m_lNumber - 1) * 5);
            }
            // 右端に表示
            Size desktopSize = System.Windows.Forms.SystemInformation.WorkingArea.Size;
            DESKTOP_LOCATION_X = desktopSize.Width - FORM_WIDTH_DEFAULT;
            iLocattion_X = DESKTOP_LOCATION_X - DESKTOP_LOCATION_X_ADJUSTED_VALUE - iSa;
            iLocattion_Y = DESKTOP_LOCATION_Y + DESKTOP_LOCATION_Y_ADJUSTED_VALUE - iSa;
            // ビュー取得
            HySViewer csViewer = ((HySScreenBase)m_csScreen).GetViewer();
            if (csViewer != null)
            {  // ビュー有効な場合
                // 常に最前面表示
                this.BringToFront();
                // 常に最前面表示
                this.Owner = ((HySDotNetViewer)csViewer).GetMainForm();
                // タスクバー非表示
                this.ShowInTaskbar = false;
                //this.MdiParent = ((HySDotNetViewer)csViewer).GetMainForm(); // 画面MDI設定
                this.Arrangement(); // 画面サイズにあわせて表示サイズ決定
            }
            // 画面タイトル設定
            m_csForm_Title = new HySString(this.Text);
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Terminate()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer; // データコンテナ取得
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示の場合
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 画面表示更新指示の場合
                    ((HySScreenBase)m_csScreen).RenewScreen(); // 表示更新
                }
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 再表示要求の場合
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                {  // 画面終了指示の場合
                    m_csScreen.CloseScreen();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_HIDE)
                {  // 隠す指示の場合
                    this.Hide();
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_MINIMIZED)
                {  // 最小化指示の場合
                    this.WindowState = FormWindowState.Minimized;
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_NORMAL)
                {  // ノーマライズ指示の場合
                    this.WindowState = FormWindowState.Normal;
                }
            }
            else
            {  // 画面一般指示以外の場合
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期配置</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Arrangement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Arrangement()
        {
            // 画面サイズにあわせて表示サイズ決定
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);
            this.Width = iWidth_Default;
            this.Height = rect.Height - iHeight_Adjusted;
            this.StartPosition = FormStartPosition.Manual;
            this.SetDesktopLocation(iLocattion_X, iLocattion_Y);
            this.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void InitiateScreen()
        {
            this.Arrangement(); // 画面サイズにあわせて表示サイズ決定
            this.PutEvent(HySEventObject.CMND_DISPLY_COMMON, HySDispDefine.NOTICE_SCREEN_NORMAL);
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySIdentifier GetID()
        {
            return m_csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFromSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFromSimKind(HySKind csSimKindID)
        {
            m_csFromSimKind = (HySObjectKind)csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csSimKind = GetFromSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind　シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetFromSimKind()
        {
            return m_csFromSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算結果データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispResultData(csResultData)</para>
        /// </example>
        /// <param name="csResultData">計算結果データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispResultData(HySDataRoot csResultData)
        {
            if (csResultData is HySDataContainer)
            {  // データコンテナが有る場合
                m_csContainer = csResultData as HySDataContainer;
                m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面インスタンス複製処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySViewFormBaseIF csForm = Clon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySMoniterFormIF 複写した画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySViewFormBaseIF Clone()
        {
            return new HySDotNetMoniterBaseForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーム一貫番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormNumber(lNumber)</para>
        /// </example>
        /// <param name="lNumber">Form一貫番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormNumber(long lNumber)
        {
            m_lNumber = lNumber;
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム一貫番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNumber = GetFormNumber()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long Form一貫番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetFormNumber()
        {
            return m_lNumber;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( lEventNo, lSubEventNo ) </para>
        /// </example>
        /// <param name="lEventNo">送るイベント番号</param>
        /// <param name="lSubEventNo">送るサブイベント番号</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public virtual Boolean PutEvent(long lEventNo, long lSubEventNo)
        {
            bool bRtn = false;
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, lEventNo);
            csEventObj.SetToSimKind(m_csScreen.GetSimKind());
            csEventObj.SetSuppID((HySID)m_csScreen.GetID());
            csEventObj.SetData(new HySObjectKind(m_csID.ToString()));
            csEventObj.SetSubEventNo(lSubEventNo);
            m_csScreen.PutEvent(csEventObj);
            return bRtn;
        }


        //----------------------------
        // 初期設定関連
        //----------------------------
        /// <summary><para>method outline:</para>
        /// <para>水平軸基準情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXUnderStandardInformation(dXScaleMin,dXScaleMax,dInterval) </para>
        /// </example>
        /// <param name="dXScaleMin">水平軸基準最小値</param>
        /// <param name="dXScaleMax">水平軸基準最大値</param>
        /// <param name="dInterval">水平軸表示間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetXUnderStandardInformation(double dXScaleMin, double dXScaleMax, double[] dInterval)
        {
            m_dXScaleMinConst = dXScaleMin; // 水平軸基準最小値設定
            m_dXScaleMaxConst = dXScaleMax; // 水平軸基準最大値設定
            m_dXScaleMin_Mst  = dXScaleMin; // 水平軸基準最小値設定
            m_dXScaleMax_Mst  = dXScaleMax; // 水平軸基準最大値設定
            // 水平軸表示間隔設定
            m_dXInterval = new double[dInterval.GetLength(0)];
            for (long lP = 0; lP < dInterval.GetLength(0); lP++)
            {
                m_dXInterval[lP] = dInterval[lP];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>垂直左端軸基準情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetYLeftStandardInformation(dYScaleMin,dYScaleMax,dInterval) </para>
        /// </example>
        /// <param name="dYScaleMin">垂直左端軸基準最小値</param>
        /// <param name="dYScaleMax">垂直左端軸基準最大値</param>
        /// <param name="dInterval">垂直左端軸表示間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetYLeftStandardInformation(double dYScaleMin, double dYScaleMax, double[] dInterval)
        {
            m_dYLeftScaleMinConst = dYScaleMin; // 垂直左端軸基準最小値設定
            m_dYLeftScaleMaxConst = dYScaleMax; // 垂直左端軸基準最大値設定
            m_dYLeftScaleMin_Mst  = dYScaleMin; // 垂直左端軸基準最小値設定
            m_dYLeftScaleMax_Mst  = dYScaleMax; // 垂直左端軸基準最大値設定
            m_dYLeftScaleMaxNumber = dYScaleMax;// 垂直左端軸基準最大値設定
            // 垂直左端軸表示間隔設定
            m_dYLeftInterval = new double[dInterval.GetLength(0)];
            for (long lP = 0; lP < dInterval.GetLength(0); lP++)
            {
                m_dYLeftInterval[lP] = dInterval[lP];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>垂直右端軸基準情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetYRightStandardInformation(dYScaleMin,dYScaleMax,dInterval) </para>
        /// </example>
        /// <param name="dYScaleMin">垂直右端軸基準最小値</param>
        /// <param name="dYScaleMax">垂直右端軸基準最大値</param>
        /// <param name="dInterval">垂直右端軸表示間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetYRightStandardInformation(double dYScaleMin, double dYScaleMax, double[] dInterval)
        {
            m_dYRightScaleMinConst = dYScaleMin; // 垂直右端軸基準最小値設定
            m_dYRightScaleMaxConst = dYScaleMax; // 垂直右端軸基準最大値設定
            m_dYRightScaleMin_Mst  = dYScaleMin; // 垂直右端軸基準最小値設定
            m_dYRightScaleMax_Mst  = dYScaleMax; // 垂直右端軸基準最大値設定
            m_dYRightScaleMaxNumber = dYScaleMax;// 垂直右端軸基準最大値設定
            // 垂直右端軸表示間隔設定
            m_dYRightInterval = new double[dInterval.GetLength(0)];
            for (long lP = 0; lP < dInterval.GetLength(0); lP++)
            {
                m_dYRightInterval[lP] = dInterval[lP];
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－タイマーインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormTimerInstance(csDspTimer)</para>
        /// </example>
        /// <param name="csDspTimer">表示周期タイマーインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormTimerInstance(Timer csDspTimer)
        {
            m_csTimerInstance = csDspTimer;
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－更新時抑止コントルールインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormControlInstance(csControlInstance)</para>
        /// </example>
        /// <param name="csControlInstance">コントルールインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormControlInstance(Control csControlInstance)
        {
            if (csControlInstance is Control)
            {  // ボタンインスタンスが有効な場合
                if (m_csControl == null)
                {  // 初期値の場合
                    m_csControl = new List<Control>();
                }
                m_csControl.Add(csControlInstance);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－スケール描画エリアインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormGraphScaleInstance(csXUnderScalePictureBox,csYLeftScalePictureBox)</para>
        /// </example>
        /// <param name="csXUnderScalePictureBox">水平軸スケール描画エリアインスタンス</param>
        /// <param name="csYLeftScalePictureBox">垂直軸左端スケール描画エリアインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormGraphScaleInstance(PictureBox csXUnderScalePictureBox, PictureBox csYLeftScalePictureBox)
        {
            SetFormGraphScaleInstance(csXUnderScalePictureBox, csYLeftScalePictureBox, null);
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－スケール描画エリアインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormGraphScaleInstance(csXUnderScalePictureBox,csYLeftScalePictureBox,csYRightScalePictureBox)</para>
        /// </example>
        /// <param name="csXUnderScalePictureBox">水平軸スケール描画エリアインスタンス</param>
        /// <param name="csYLeftScalePictureBox">垂直軸左端スケール描画エリアインスタンス</param>
        /// <param name="csYRightScalePictureBox">垂直軸右端スケール描画エリアインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormGraphScaleInstance(PictureBox csXUnderScalePictureBox,
                                                      PictureBox csYLeftScalePictureBox,
                                                      PictureBox csYRightScalePictureBox)
        {
            m_csXUnderScalePictureBox = csXUnderScalePictureBox;
            m_csYLeftScalePictureBox = csYLeftScalePictureBox;
            m_csYRightScalePictureBox = csYRightScalePictureBox;
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－スクロールインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormScrollBarInstance(csXUnderScrollBar,csYLeftScrollBar)</para>
        /// </example>
        /// <param name="csXUnderScrollBar">水平軸スクロールバーインスタンス</param>
        /// <param name="csYLeftScrollBar">垂直左端軸スクロールバーインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormScrollBarInstance(HScrollBar csXUnderScrollBar, VScrollBar csYLeftScrollBar)
        {
            SetFormScrollBarInstance(csXUnderScrollBar, csYLeftScrollBar, null);
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－スクロールインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormScrollBarInstance(csXUnderScrollBar,csYLeftScrollBar,csYRightScrollBar)</para>
        /// </example>
        /// <param name="csXUnderScrollBar">水平軸スクロールバーインスタンス</param>
        /// <param name="csYLeftScrollBar">垂直左端軸スクロールバーインスタンス</param>
        /// <param name="csYRightScrollBar">垂直右端軸スクロールバーインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormScrollBarInstance(HScrollBar csXUnderScrollBar,
                                                     VScrollBar csYLeftScrollBar,
                                                     VScrollBar csYRightScrollBar)
        {
            m_csXUnderScrollBar = csXUnderScrollBar;
            m_csYLeftScrollBar = csYLeftScrollBar;
            m_csYRightScrollBar = csYRightScrollBar;
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－水平軸拡大トラックバーインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormTrackBarInstance(csXZoomBar,csXZoomLabel,csYLeftZoomBar,csYLeftZoomLabel)</para>
        /// </example>
        /// <param name="csXZoomBar">水平軸拡大トラックバーインスタンス</param>
        /// <param name="csXZoomLabel">水平軸拡大率ラベルインスタンス</param>
        /// <param name="csYLeftZoomBar">垂直左端軸拡大トラックバーインスタンス</param>
        /// <param name="csYLeftZoomLabel">垂直左端軸拡大率ラベルインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormTrackBarInstance(TrackBar csXZoomBar, Label csXZoomLabel,
                                                    TrackBar csYLeftZoomBar, Label csYLeftZoomLabel)
        {
            SetFormTrackBarInstance(csXZoomBar, csXZoomLabel, csYLeftZoomBar, csYLeftZoomLabel, null, null);
        }
        /// <summary><para>method outline:</para>
        /// <para>フォーム内基本部品－水平軸拡大トラックバーインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormTrackBarInstance(csXZoomBar,csXZoomLabel,csYLeftZoomBar,csYLeftZoomLabel,csYRightZoomBar,csYRightZoomLabel)</para>
        /// </example>
        /// <param name="csXZoomBar">水平軸拡大トラックバーインスタンス</param>
        /// <param name="csXZoomLabel">水平軸拡大率ラベルインスタンス</param>
        /// <param name="csYLeftZoomBar">垂直左端軸拡大トラックバーインスタンス</param>
        /// <param name="csYLeftZoomLabel">垂直左端軸拡大率ラベルインスタンス</param>
        /// <param name="csYRightZoomBar">垂直右端軸拡大トラックバーインスタンス</param>
        /// <param name="csYRightZoomLabel">垂直右端軸拡大率ラベルインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFormTrackBarInstance(TrackBar csXZoomBar     , Label csXZoomLabel,
                                                    TrackBar csYLeftZoomBar , Label csYLeftZoomLabel,
                                                    TrackBar csYRightZoomBar, Label csYRightZoomLabel)
        {
            m_csXZoomBar        = csXZoomBar;
            m_csXZoomLabel      = csXZoomLabel;
            m_csYLeftZoomBar    = csYLeftZoomBar;
            m_csYLeftZoomLabel  = csYLeftZoomLabel;
            m_csYRightZoomBar   = csYRightZoomBar;
            m_csYRightZoomLabel = csYRightZoomLabel;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示周期タイマー停止・再開</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTimerEnable(bStatus) </para>
        /// </example>
        /// <param name="bStatus">抑止状態（=true:再開 =false:停止）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTimerEnable(bool bStatus)
        {
            if (m_csTimerInstance is Timer)
            {  // 周期タイマーが有効な場合
                m_csTimerInstance.Enabled = bStatus;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>更新中コントロール抑止・解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetControlEnable(bStatus) </para>
        /// </example>
        /// <param name="bStatus">抑止状態（=true:抑止解除 =false:抑止）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetControlEnable(bool bStatus)
        {
            // ロバストチェック指摘に対する修正[本体が空の for/do/while 文を使用しています]
            //if (m_csControl != null)
            //{  // インスタンスが有効な場合
            //    for (int iLp = 0; iLp < m_csControl.Count; iLp++)
            //    {
            //        //m_csControl[iLp].Enabled = bStatus;
            //    }
            //}
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>リセット要求のチェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = ResetDemandCheck()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool リセット要求有無（=true:有り =false:無し）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ResetDemandCheck()
        {
            bool bRtn = m_bResetFlg;

            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示データ情報が有る場合
                m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
                if (m_csInstanceCommon is HySDispInstanceCommon)
                {  // 演算結果情報が有る場合
                    HySString cs_ResetFlg = m_csDBPCtlInfo.GetTemporaryDataList(new HySObjectKind(m_csID.ToString())) as HySString;
                    if (cs_ResetFlg is HySString)
                    {  // リセット要求が有効な場合
                        if (cs_ResetFlg.Equals(new HySString("true")) == true)
                        {  // リセット要求がリセット指定の場合
                            long[] lList = m_csInstanceCommon.GetLongArray();
                            if (lList != null)
                            {  // 整数情報が有る場合
                                if (lList[0] >= 100 && m_csTimerInstance.Interval != (int)lList[0])
                                {  // 表示周期変更要の場合
                                    m_csTimerInstance.Interval = (int)lList[0];
                                }
                                if (lList.GetLength(0) >= 2)
                                {  // 表示周期変更要の場合
                                    m_bDispFlg = (lList[1] == 0) ? false : true;
                                }
                            }
                            bRtn = true;
                            // リセット設定解除
                            m_csDBPCtlInfo.SetTemporaryDataList(new HySObjectKind(m_csID.ToString()), new HySString("false"));
                        }
                    }
                }
            }
            m_bResetFlg = false;
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ情報リセット処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphAllReset()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>グラフの初期化は垂直左端軸・垂直右端軸・水平軸全てが対象、対象外のインスタンスは設定しないこと</para>
        /// </remarks>
        public virtual void GraphAllReset()
        {
            GraphDataInit();                          // グラフ管理情報初期化
            m_dXScaleMin = m_dXScaleMin_Mst;          // X軸最小値(基準値)
            m_dXScaleMax = m_dXScaleMax_Mst;          // X軸最大値(基準値)
            m_dXScale = m_dXScale_Mst;                // X軸目盛間隔(基準値)
            if (m_dYMinLeftScaleCheck == true)
            {  //[2011/01/18]
                m_dYLeftScaleMin = m_dYLeftScaleMinNumber;
                m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);//[2011/01/29]
            }
            else
            {
                m_dYLeftScaleMin = m_dYLeftScaleMin_Mst;  // Y軸最小値(基準値)
                m_csDrawMonitor.SetLeftSetMin(0.0);//[2011/01/28]
            }
            m_dYLeftScaleMax = (m_dYLeftScaleCheck == true) ? m_dYLeftScaleMaxNumber : m_dYLeftScaleMax_Mst;  // Y軸最大値(基準値)
            m_dYLeftScale = m_dYLeftScale_Mst;        // Y軸目盛間隔(基準値)
            if (m_dYMinRightScaleCheck == true)
            {  //[2011/01/18]
                m_dYRightScaleMin = m_dYRightScaleMinNumber;
            }
            else
            {
                m_dYRightScaleMin = m_dYRightScaleMin_Mst;// Y軸最小値(基準値)
            }
            m_dYRightScaleMax = (m_dYRightScaleCheck == true) ? m_dYRightScaleMaxNumber : m_dYRightScaleMax_Mst;// Y軸最大値(基準値)
            m_dYRightScale = m_dYRightScale_Mst;      // Y軸目盛間隔(基準値)
            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示データ情報が有る場合
                VarticalTypeUpdate(); // 描画グラフ垂直基準設定
            }
            // スクロールバー初期設定
            if (m_csXUnderScrollBar is HScrollBar)
            {  // 水平軸スクロールバーが有効な場合
                HorizonUnderGraphScaleInit();
            }
            if (m_csYRightScrollBar is VScrollBar)
            {  // 垂直右端軸スクロールバーが有効な場合
                VerticalRightGraphScaleInit();
            }
            if (m_csYLeftScrollBar is VScrollBar)
            {  // 垂直左端軸スクロールバーが有効な場合
                VerticalLeftGraphScaleInit();
            }
            GraphInvalidate(VERTICAL_LEFT);  // 垂直左端基準描画領域更新
            GraphInvalidate(VERTICAL_RIGHT); // 垂直右端基準描画領域更新
            // 軸スケール初期描画
            if (m_csXUnderScalePictureBox is PictureBox)
            {  // 水平軸描画エリアが有効な場合

                if (this is HySDotNetMoniterForm || this is HySDotNetMoniterHydroHyetoForm)
                {
                    m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/24]
                }
                else
                {
                    CalcResultMonitor_XUnderScalePaint(); // Ｘ軸メモリ描画
                }
                m_csXUnderScalePictureBox.Invalidate();
            }
            if (m_csYLeftScalePictureBox is PictureBox)
            {  // 垂直左端軸描画エリアが有効な場合
                CalcResultMonitor_YLeftScalePaint();  // Ｙ軸左端メモリ描画
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/24]
                m_csYLeftScalePictureBox.Invalidate();
            }
            if (m_csYRightScalePictureBox is PictureBox)
            {  // 垂直右端軸描画エリアが有効な場合
                //CalcResultMonitor_YRightScalePaint(); // Ｙ軸右端メモリ描画
                m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
                m_csYRightScalePictureBox.Invalidate();
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ対応の垂直軸基準値更新</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>VarticalTypeUpdate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void VarticalTypeUpdate()
        {
            m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
            if (m_csInstanceCommon is HySDispInstanceCommon)
            {  // 演算結果情報が有る場合
                long lArrayNum = m_csInstanceCommon.GetDataLinkedListArray().GetLength(0);
                if (lArrayNum > 0)
                {  // 項目データが有る場合
                    for (long lP = 0; lP < lArrayNum; lP++)
                    {
                        HySID csReceiveID = new HySID("");
                        HySDataLinkedList csListArray = (m_csInstanceCommon.GetDataLinkedListArray())[lP] as HySDataLinkedList;
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySID)
                            {  // 伝送データの受信パターンＩＤの場合
                                csReceiveID = csListArray.GetData(lP1) as HySID;
                                break;
                            }
                        }
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySDataCharacteristicInCell)
                            {  // 伝送プロパティの項目情報の場合
                                HySDataCharacteristicInCell csInputKind = csListArray.GetData(lP1) as HySDataCharacteristicInCell;
                                if (csInputKind.m_csDataKind[0].Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true &&
                                    csReceiveID.Equals(HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL) == true)
                                {  // 雨量データの場合
                                    SetVarticalType(lP, VERTICAL_RIGHT);
                                }
                                else
                                {  // 任意データの場合
                                    SetVarticalType(lP, VERTICAL_LEFT);
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>テーブル一覧情報リセット処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TableAllReset</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>対象外の関連インスタンスは設定しないこと</para>
        /// </remarks>
        public virtual void TableAllReset()
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csDataGridView is DataGridView)
                    {  // テーブル一覧リストが有効な場合
                        m_csCntlInfo[lP].m_csDataGridView.SuspendLayout(); // 一時中断（サスペンド）
                        m_csCntlInfo[lP].m_csDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
                        m_csCntlInfo[lP].m_csDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
                        m_csCntlInfo[lP].m_csDataGridView.ReadOnly = true;               // ユーザの編集無効
                        m_csCntlInfo[lP].m_csDataGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None; // 行の自動調整無効
                        m_csCntlInfo[lP].m_csDataGridView.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.None;       // 列の自動調整無効
                        m_csCntlInfo[lP].m_csDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
                        // テーブル一覧の初期化
                        m_csCntlInfo[lP].m_csDataGridView.Columns.Clear();
                        m_csCntlInfo[lP].m_csDataGridView.Rows.Clear();
                        // データエリアの初期化
                        m_csCntlInfo[lP].m_csDataTable.Clear();
                        // 前回データ件数の初期化
                        m_csCntlInfo[lP].m_lDataCnt = 0;
                        //レイアウトロジック再開
                        m_csCntlInfo[lP].m_csDataGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.DisplayedCells; // 列の自動調整有効
                        m_csCntlInfo[lP].m_csDataGridView.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.None;         // 行の自動調整無効
                        m_csCntlInfo[lP].m_csDataGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;      // 行選択有効
                        m_csCntlInfo[lP].m_csDataGridView.AlternatingRowsDefaultCellStyle.BackColor = Color.LightGreen; // １行置きに色替
                        m_csCntlInfo[lP].m_csDataGridView.ScrollBars = ScrollBars.Both;  // スクロールバー有効
                        m_csCntlInfo[lP].m_csDataGridView.RowHeadersWidthSizeMode = DataGridViewRowHeadersWidthSizeMode.EnableResizing;//[2011]

                        m_csCntlInfo[lP].m_csDataGridView.ResumeLayout(true); // 一時停止解除（リジューム）
                    }
                }
            }
        }


        //----------------------------
        // テーブル一覧関連
        //----------------------------
        /// <summary><para>method outline:</para>
        /// <para>テーブル再表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_TablePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_TablePaint()
        {
            int iLp, iLp1;

            SetTimerEnable(false); // タイマー停止
            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示データが有る場合
                m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
                if (m_csInstanceCommon is HySDispInstanceCommon)
                {  // 演算結果が有る場合
                    long lArrayNum = m_csCntlInfo.GetLength(0); // サポート配列件数設定
                    if (lArrayNum > m_csInstanceCommon.GetDataHashTableArray().GetLength(0))
                    {  // サポート配列件数が大きい場合
                        lArrayNum = m_csInstanceCommon.GetDataHashTableArray().GetLength(0); // 伝送データ件数設定
                    }
                    for (long lArrayCnt = 0; lArrayCnt < lArrayNum; lArrayCnt++)
                    {  // 配列数分繰り返す
                        m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lArrayCnt];
                        if (m_csCntlInfo[lArrayCnt].m_lDataCnt != m_csData.GetCount())
                        {  // 表示件数と不一致の場合
                            long lDataNum = m_csData.GetCount();
                            //レイアウトロジックを一時中断
                            SetControlEnable(false); // 操作系抑止
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.SuspendLayout(); // 一時中断（サスペンド）
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AllowUserToAddRows = false;    // ユーザの行追加禁止
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AllowUserToDeleteRows = false; // ユーザの行削除禁止
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.ReadOnly = true;               // ユーザの編集無効
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None; // 行の自動調整無効
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.None;       // 列の自動調整無効
                            //m_csCntlInfo[lArrayCnt].m_csDataGridView.AllowUserToResizeRows = true;
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.ScrollBars = ScrollBars.None;  // スクロールバー無効
                            // テーブル描画
                            for (long lP = 1; lP <= lDataNum; lP++)
                            {
                                if (lP > m_csCntlInfo[lArrayCnt].m_lDataCnt && m_bDispFlg == true)
                                {  // 表示データが有る場合
                                    HySD1CellArrayData csCellData = m_csData[new HySString(((long)(lP - 1)).ToString())] as HySD1CellArrayData;
                                    if (csCellData is HySD1CellArrayData)
                                    {  // セル型データの場合
                                        HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                                        long lSirDataNum = csCellData.GetDataDimentionInCell(); // セル内部配列数取得
                                        HySCellData[] csCell = csCellData.GetCellData();        // セル配列データ取得
                                        if (lDataNum > 0 && m_csCntlInfo[lArrayCnt].m_lDataCnt == 0)
                                        {  // 初回時の表エリアカラム追加
                                            m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns.Add("Column1", "No");
                                            m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns.Add("Column2", Properties.HysDotNetViewerResources.GRAPH_TIME);    //"時間"
                                            // ラベルの取得
                                            HySString[] csInputName = new HySString[lSirDataNum];
                                            HySDataLinkedList csListArray = (m_csInstanceCommon.GetDataLinkedListArray())[lArrayCnt] as HySDataLinkedList;
                                            for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                                            {
                                                HySDataCharacteristicInCell csInputKind = csListArray.GetData(lP1) as HySDataCharacteristicInCell;
                                                if (csInputKind is HySDataCharacteristicInCell)
                                                {  // データ種別詳細の場合
                                                    if (csInputKind.m_lDim < lSirDataNum)
                                                    {  // ラベルがセル個数分無い場合
                                                        for (iLp = 1; iLp <= lSirDataNum; iLp++)
                                                        {
                                                            csInputName[iLp - 1] = new HySString(csInputKind.m_csLabel[0]) + iLp.ToString();
                                                        }
                                                    }
                                                    else
                                                    {  // ラベルがセル個数分有る場合
                                                        for (iLp = 0; iLp < lSirDataNum; iLp++)
                                                        {
                                                            csInputName[iLp] = new HySString(csInputKind.m_csLabel[iLp]);
                                                        }
                                                    }
                                                    break;
                                                }
                                            }
                                            for (iLp = 1; iLp <= lSirDataNum; iLp++)
                                            {
                                                // 列にデータ設定
                                                iLp1 = iLp + 2;
                                                if (csInputName != null)
                                                {  // 文字列リストが有る場合
                                                    m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns.Add("Column" + iLp1.ToString(), "　" + csInputName[iLp - 1].ToString());
                                                }
                                                else
                                                {  // 文字列リストが無い場合
                                                    m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns.Add("Column" + iLp1.ToString(), "　" + "Data" + iLp.ToString());
                                                }
                                            }
                                            csInputName = null;
                                        }
                                        string[] csWkTbl = new string[m_csCntlInfo[lArrayCnt].m_csDataGridView.ColumnCount];
                                        csWkTbl[0] = lP.ToString();
                                        //csWkTbl[1] = HySCalendar.GetString(csTime, HySCalendar.FORMAT.lSW_YEAR).ToString();
                                        csWkTbl[1] = HySCalendar.GetString(csTime, HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                                        // 実データ設定
                                        for (iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                        {
                                            csWkTbl[iLp1 + 2] = csCell[0].m_dData[iLp1].ToString("F");
                                        }
                                        m_csCntlInfo[lArrayCnt].m_csDataTable.Add(csWkTbl);
                                        m_csCntlInfo[lArrayCnt].m_lDataCnt++; // 行数更新

                                        m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns[0].Width = 35;
                                        m_csCntlInfo[lArrayCnt].m_csDataGridView.Columns[1].Width = 135;
                                    }
                                }
                            }
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.RowCount = (int)m_csCntlInfo[lArrayCnt].m_lDataCnt;

                            //レイアウトロジック再開
                            //m_csCntlInfo[lArrayCnt].m_csDataGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.DisplayedCells; // 列の自動調整有効
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;   // 列の自動調整無効[2011/01/21]
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.None;         // 行の自動調整無効
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;      // 行選択有効
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.AlternatingRowsDefaultCellStyle.BackColor = Color.LightGreen; // １行置きに色替
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.ScrollBars = ScrollBars.Both;  // スクロールバー有効                           


                            if (m_csCntlInfo[lArrayCnt].m_csDataGridView.Rows.Count > 0)
                            {  // 表示データが有る場合
                                m_csCntlInfo[lArrayCnt].m_csDataGridView.FirstDisplayedScrollingRowIndex = m_csCntlInfo[lArrayCnt].m_csDataGridView.Rows.Count - 1; // 最終行に移動
                            }
                            m_csCntlInfo[lArrayCnt].m_csDataGridView.ResumeLayout(true); // 一時停止解除（リジューム）
                            SetControlEnable(true); // 操作系抑止解除
                        }
                    }
                }
            }
            SetTimerEnable(true);  // タイマー再開
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>仮想モードセル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_SetTableCellValue(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_SetTableCellValue(object sender, DataGridViewCellValueEventArgs e)
        {
            int rowInEdit = -1; // ヘッダ行番号
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csDataGridView.Equals(sender) == true)
                    {  // テーブル一覧リストが有効な場合
                        if (e is DataGridViewCellValueEventArgs)
                        {  // 発生イベント有効の場合
                            if (e.RowIndex == rowInEdit ||
                                e.RowIndex > m_csCntlInfo[lP].m_csDataTable.Count - 1)
                            {  // ヘッダ行または最終頁表示の場合
                                return;
                            }
                            e.Value = ((string[])m_csCntlInfo[lP].m_csDataTable[e.RowIndex])[e.ColumnIndex];
                        }
                        break;
                    }
                }
            }
        }


        //----------------------------
        // グラフ描画関連
        //----------------------------
        /// <summary><para>method outline:</para>
        /// <para>水平グラフスケール初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HorizonUnderGraphScaleInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void HorizonUnderGraphScaleInit()
        {
            // 初期範囲値設定
            m_dXScaleMin_Mst = m_dXScaleMinConst;
            m_dXScaleMax_Mst = m_dXScaleMaxConst;
            // 表示範囲設定
            m_bXManualFlg = false;
            m_dXRato = 1.0;
            if (m_csXZoomBar is TrackBar)
            {  // 拡大トラックバーが有効な場合
                m_csXZoomBar.Value = 100;
                if (m_csXZoomLabel is Label)
                {  // 拡大率ラベルが有効な場合
                    m_csXZoomLabel.Text = m_csXZoomBar.Value.ToString();
                }
            }
            //水平スクロールバーの設定
            //m_csXUnderScrollBar.Maximum = (int)m_dXScaleMax_Mst;
            //m_csXUnderScrollBar.Minimum = (int)m_dXScaleMin_Mst;
            m_csXUnderScrollBar.Maximum = 199;
            m_csXUnderScrollBar.Minimum = 0;
            m_dXValue = m_dXScaleMax_Mst;
            double dXZoom = (m_csXUnderScrollBar.Maximum - m_csXUnderScrollBar.Minimum) * m_dXRato;
            //m_csXUnderScrollBar.LargeChange = (int)dXZoom;
            m_csXUnderScrollBar.LargeChange = 200;
            m_csXUnderScrollBar.SmallChange = 1;
            m_csXUnderScrollBar.Value = m_csXUnderScrollBar.Minimum;
            m_csXUnderScrollBar.PerformLayout();
        }
        /// <summary><para>method outline:</para>
        /// <para>垂直左端グラフスケール初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>VerticalLeftGraphScaleInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void VerticalLeftGraphScaleInit()
        {
            // 初期範囲値設定
            if (m_dYMinLeftScaleCheck == true)
            {  //[2011/01/18]
                m_dYLeftScaleMin_Mst = m_dYLeftScaleMinNumber;
            }
            else
            {
                m_dYLeftScaleMin_Mst = m_dYLeftScaleMinConst;
            }
            m_dYLeftScaleMax_Mst = (m_dYLeftScaleCheck == true) ? m_dYLeftScaleMaxNumber : m_dYLeftScaleMaxConst;
            // 表示範囲設定
            m_bYLeftManualFlg = false;
            m_dYLeftRato = 1.0;
            if (m_csYLeftZoomBar is TrackBar)
            {  // 拡大トラックバーが有効な場合
                m_csYLeftZoomBar.Value = 100;
                if (m_csYLeftZoomLabel is Label)
                {  // 拡大率ラベルが有効な場合
                    m_csYLeftZoomLabel.Text = m_csYLeftZoomBar.Value.ToString();
                }
            }
            //左端垂直スクロールバーの設定
            //m_csYLeftScrollBar.Minimum = (int)m_dYLeftScaleMin_Mst;
            m_csYLeftScrollBar.Minimum = 0;//[2011/01/25]
            //m_csYLeftScrollBar.Maximum = (int)m_dYLeftScaleMax_Mst;//[2011/01/23]
            m_csYLeftScrollBar.Maximum = 199;//[2011/01/23]
            m_dYLeftValue = m_dYLeftScaleMax_Mst;
            double dYLeftZoom = ((m_csYLeftScrollBar.Maximum - m_csYLeftScrollBar.Minimum) * m_dYLeftRato) + 1;
            //m_csYLeftScrollBar.LargeChange = (int)dYLeftZoom;
            m_csYLeftScrollBar.LargeChange = 200;//[2011/01/25]
            m_csYLeftScrollBar.SmallChange = 1;
            m_csYLeftScrollBar.Value = m_csYLeftScrollBar.Minimum;
            m_csYLeftScrollBar.PerformLayout();
        }
        /// <summary><para>method outline:</para>
        /// <para>垂直右端グラフスケール初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>VerticalRightGraphScaleInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void VerticalRightGraphScaleInit()
        {
            // 初期範囲値設定
            if (m_dYMinRightScaleCheck == true)
            {  //[2011/01/18]
                m_dYRightScaleMin_Mst = m_dYRightScaleMinNumber;
            }
            else
            {
                m_dYRightScaleMin_Mst = m_dYRightScaleMinConst;
            }
            m_dYRightScaleMax_Mst = (m_dYRightScaleCheck == true) ? m_dYRightScaleMaxNumber : m_dYRightScaleMaxConst;
            // 表示範囲設定
            m_bYRightManualFlg = false;
            m_dYRightRato = 1.0;
            if (m_csYRightZoomBar is TrackBar)
            {  // 拡大トラックバーが有効な場合
                m_csYRightZoomBar.Value = 100;
                if (m_csYRightZoomLabel is Label)
                {  // 拡大率ラベルが有効な場合
                    m_csYRightZoomLabel.Text = m_csYRightZoomBar.Value.ToString();
                }
            }
            //右端垂直スクロールバーの設定
            //m_csYRightScrollBar.Minimum = (int)m_dYRightScaleMin_Mst;
            //m_csYRightScrollBar.Maximum = (int)m_dYRightScaleMax_Mst;
            //m_dYRightValue = m_dYRightScaleMax_Mst;
            m_csYRightScrollBar.Minimum = 0;
            m_csYRightScrollBar.Maximum = 199;
            double dYRightZoom = ((m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) * m_dYRightRato) + 1;
            //m_csYRightScrollBar.LargeChange = (int)dYRightZoom;
            m_csYRightScrollBar.LargeChange = 200;//[2011/01/25]
            m_csYRightScrollBar.SmallChange = 1;
            //m_csYRightScrollBar.Value = m_csYRightScrollBar.Maximum;
            m_csYRightScrollBar.PerformLayout();
        }

        /// <summary><para>method outline:</para>
        /// <para>垂直軸補正最大値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetLogScale(ref dScaleMax) </para>
        /// </example>
        /// <param name="dScaleMax">垂直軸スケール最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetLogScale(ref double dScaleMax)
        {
            // 垂直軸最大値スケール補正
            double dDatalog = dScaleMax;
            double dKekkalog = Math.Floor(dDatalog / 10.0);
            if (Math.Abs(dKekkalog) > 1.0)
            {  // 基準桁の場合
                dScaleMax = (dKekkalog < 0.0) ? Math.Floor(dScaleMax - dKekkalog) : Math.Floor(dScaleMax + dKekkalog);
            }
            else
            {  // 基準桁以外の場合
                dScaleMax = (dKekkalog < 0.0) ? Math.Floor(dScaleMax - 1.0) : Math.Floor(dScaleMax + 1.0);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ｘ軸・Ｙ軸最大値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXYScale()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetXYScale()
        {
            double dWk = 0.0;
            bool bYLeftChangeFlg = true;
            bool bYRightChangeFlg = true;

            double[] dList = m_csInstanceCommon.GetDoubleArray();
            if (dList != null)
            {  // 境界値が有る場合
                m_dXScaleMin = dList[0];
                m_dXScaleMax = dList[1];
                if (dList[2] == 0.0 && dList[3] == 0.0)
                {  // Y軸値が無効な場合
                    bYLeftChangeFlg = false;
                }
                else
                {  // Y軸値が有効な場合
                    if (dList[2] != m_dYLeftScaleMin && m_dYMinLeftScaleCheck == false)//[2010/01/18]
                    {  // 最小値の更新が必要な場合
                        m_dYLeftScaleMin = dList[2];
                        m_dYLeftScaleMinNumber = m_dYLeftScaleMin;
                    }
                    m_dYLeftScaleMax = dList[3];
                }
                if (dList[4] == 0.0 && dList[5] == 0.0)
                {  // Y軸値が無効な場合
                    bYRightChangeFlg = false;
                }
                else
                {  // Y軸値が有効な場合
                    if (dList[4] != m_dYRightScaleMin && m_dYMinRightScaleCheck == false)
                    {  // 最小値の更新が必要な場合
                        m_dYRightScaleMin = dList[4];
                        m_dYRightScaleMinNumber = m_dYRightScaleMin;
                    }
                    m_dYRightScaleMax = dList[5];
                }

                // X軸最小値補正
                if (m_dXScaleMin == m_dXScaleMax)
                {  // 最大値と最小値が同じ場合
                    if (m_dXScaleMax > m_dXScale)
                    {  // スケール幅より大きい場合
                        m_dXScaleMax = m_dXScaleMax + m_dXScale;
                    }
                    else
                    {  // スケール幅より小さい場合
                        m_dXScaleMin = 0.0;
                    }
                }
            }
            // Y軸左端最大値・最小値・スケール補正
            if (m_dYLeftScaleCheck == false)
            {  // Y軸表示最大設定無効の場合
                if (bYLeftChangeFlg == true)
                {  // 初期値以外の場合
                    GetLogScale(ref m_dYLeftScaleMax);
                }
            }
            else
            {  // Y軸表示最大設定有効の場合
                m_dYLeftScaleMax = m_dYLeftScaleMaxNumber;
            }

            //Y軸左端最小値の設定[2011/01/17]
            if (m_dYMinLeftScaleCheck == false)
            {
            }
            else
            {
                m_dYLeftScaleMin = m_dYLeftScaleMinNumber;
            }

            // Y軸右端最大値・最小値・スケール補正
            if (m_dYRightScaleCheck == false)
            {  // Y軸表示最大設定無効の場合
                if (bYRightChangeFlg == true)
                {  // 初期値以外の場合
                    GetLogScale(ref m_dYRightScaleMax);
                }
            }
            else
            {  // Y軸表示最大設定有効の場合
                m_dYRightScaleMax = m_dYRightScaleMaxNumber;
            }

            //Y軸右端最小値の設定[2011/01/18]
            if (m_dYMinRightScaleCheck == false)
            {
            }
            else
            {
                m_dYRightScaleMin = m_dYRightScaleMinNumber;
            }

            // 表示許容範囲補正
            /*
            if (m_dXScaleMin >= int.MaxValue || m_dXScaleMin <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dXScaleMin = (double)(int.MinValue + 1);
            }
            if (m_dXScaleMax >= int.MaxValue || m_dXScaleMax <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dXScaleMax = (double)(int.MaxValue - 1);
            }
            */
            m_dXDltCpc = 0.0;
            if (m_dXScaleMax >= int.MaxValue)
            {  // 表示許容範囲外の場合
                m_dXDltCpc = m_dXScaleMax - (double)(int.MaxValue) + 1;
                m_dXScaleMax -= m_dXDltCpc;
                m_dXScaleMin -= m_dXDltCpc;
            }
            if (m_dXScaleMin <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dXDltCpc = ((double)(int.MinValue) - m_dXScaleMin + 1) * (-1.0);
                m_dXScaleMax -= m_dXDltCpc;
                m_dXScaleMin -= m_dXDltCpc;
            }
            dWk = m_dXScaleMax - m_dXScaleMin;
            if (dWk >= int.MaxValue || dWk <= int.MinValue)
            {  // 最大－最小の差が表示許容範囲外の場合
                m_dXScaleMax = m_dXScaleMin + (int.MaxValue - 1);
            }
            if (m_dYLeftScaleMin >= int.MaxValue || m_dYLeftScaleMin <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dYLeftScaleMin = (double)(int.MinValue + 1);
            }
            if (m_dYLeftScaleMax >= int.MaxValue || m_dYLeftScaleMax <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dYLeftScaleMax = (double)(int.MaxValue - 1);
            }
            dWk = m_dYLeftScaleMax - m_dYLeftScaleMin;
            if (dWk >= int.MaxValue || dWk <= int.MinValue)
            {  // 最大－最小の差が表示許容範囲外の場合
                m_dYLeftScaleMax = m_dYLeftScaleMin + (int.MaxValue - 1);
            }
            if (m_dYRightScaleMin >= int.MaxValue || m_dYRightScaleMin <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dYRightScaleMin = (double)(int.MinValue + 1);
            }
            if (m_dYRightScaleMax >= int.MaxValue || m_dYRightScaleMax <= int.MinValue)
            {  // 表示許容範囲外の場合
                m_dYRightScaleMax = (double)(int.MaxValue - 1);
            }
            dWk = m_dYRightScaleMax - m_dYRightScaleMin;
            if (dWk >= int.MaxValue || dWk <= int.MinValue)
            {  // 最大－最小の差が表示許容範囲外の場合
                m_dYRightScaleMax = m_dYRightScaleMin + (int.MaxValue - 1);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>基準グラフ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>描画は垂直左端軸基準、垂直右端軸基準を常に対象とする。対象としたくない場合は関連インスタンスを設定しないこと</para>
        /// </remarks>
        public virtual void CalcResultMonitor_Paint()
        {
            bool bGraphAllClearFlg = false;
            m_csDrawMonitor.DrawCheckControl();//[2011/01/29]チェック
            SetTimerEnable(false); // タイマー停止
            if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
            {  // 表示データが有る場合
                try
                {
                    m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
                    if (m_csInstanceCommon is HySDispInstanceCommon)
                    {  // 演算結果が有る場合
                        long lArrayNum = m_csInstanceCommon.GetDataHashTableArray().GetLength(0);
                        bool bXUnderUpdateflg = false;
                        bool bYLeftUpdateflg = false;
                        bool bYRightUpdateflg = false;
                        if (lArrayNum > 0)
                        {  // 伝送データ配列が有る場合
                            double dXScaleMax = m_dXScaleMax;           // X軸最大値(基準値)
                            double dYLeftScaleMax = m_dYLeftScaleMax;   // Y軸左端最大値(基準値)
                            double dYLeftScaleMin = m_dYLeftScaleMin;   // Y軸左端最小値（基準値）[2011/01/17]
                            double dYRightScaleMax = m_dYRightScaleMax; // Y軸右端最大値(基準値)
                            double dYRightScaleMin = m_dYRightScaleMin; //[2011/01/18]
                            SetXYScale(); // 継続の演算結果データ最大・最小範囲設定
                            if (dXScaleMax != m_dXScaleMax)
                            {  // X軸下段に更新が有る場合
                                bXUnderUpdateflg = true;
                            }
                            if (dYLeftScaleMax != m_dYLeftScaleMax)
                            {  // Y軸左端に更新が有る場合
                                bYLeftUpdateflg = true;
                            }
                            if (dYLeftScaleMin != m_dYLeftScaleMin)
                            {  //Y軸左端最小値に変更がある場合
                                bYLeftUpdateflg = true;
                            }
                            if (dYRightScaleMax != m_dYRightScaleMax)
                            {  // Y軸右端に更新が有る場合
                                bYRightUpdateflg = true;
                            }
                            if (dYRightScaleMin != m_dYRightScaleMin)
                            {  //Y軸右端最小値に変更がある場合
                                bYRightUpdateflg = true;
                            }
                        }
                        m_lColorNum = m_lColorNum_Mst; // 描画色カウンタ初期化
                        for (long lArrayCnt = 0; lArrayCnt < lArrayNum; lArrayCnt++)
                        {  // 配列数分繰り返す
                            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lArrayCnt];
                            m_csDrawMonitor.SetCntlInfo(m_csCntlInfo);
                            m_csDrawMonitor.SetInstanceCommon(m_csInstanceCommon);
                            m_csDrawMonitor.DrawCheckControl();//[2011/01/29]チェック
                            if (m_csData.GetCount() > 0)
                            {  // 演算結果データが有る場合
                                if (m_csCntlInfo[lArrayCnt].m_csVarticalType.Equals(VERTICAL_RIGHT) == true)
                                {  // Y軸右端が基準の場合
                                    //-------------------------------------------
                                    // Ｙ軸右端基準（ハイエト専用）の描画処理
                                    //-------------------------------------------
                                    if (bXUnderUpdateflg == true || bYRightUpdateflg == true)
                                    {  // Y軸右端に更新が有る場合
                                        m_csCntlInfo[lArrayCnt].m_lTopPoint = -1; // 描画済み件数初期化
                                    }
                                    if (m_csCntlInfo[lArrayCnt].m_lPointCnt != m_csData.GetCount() ||
                                        m_csCntlInfo[lArrayCnt].m_lTopPoint < 0)
                                    {  // データ再描画要の場合
                                        CalcResultMonitor_HyetoPaint(lArrayCnt); // ハイエト描画
                                        
                                        
                                        m_csDrawMonitor.SetDataHashTable(m_csData);
                                        m_csDrawMonitor.SetSelectCellNum(m_lCellSelectNum);
                                        if (m_dYMinRightScaleCheck == true)
                                        {
                                            m_csDrawMonitor.SetRightSetMin(m_dYRightScaleMinNumber);
                                        }
                                        if (m_dYRightScaleCheck == true)
                                        {
                                            m_csDrawMonitor.SetRightSetMax(m_dYRightScaleMaxNumber);
                                        }
                                        m_csDrawMonitor.DrawRightFullMonitor(lArrayCnt);
                                        m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);
                                    }
                                }
                                else
                                {  // Y軸左端が基準の場合
                                    //-------------------------------------------
                                    // Ｙ軸左端基準（折れ線専用）の描画処理
                                    //-------------------------------------------
                                    if (bXUnderUpdateflg == true || bYLeftUpdateflg == true)
                                    {  // Y軸左端に更新が有る場合
                                        m_csCntlInfo[lArrayCnt].m_lTopPoint = -1; // 描画済み件数初期化
                                    }
                                    if (m_csCntlInfo[lArrayCnt].m_lPointCnt != m_csData.GetCount() ||
                                        m_csCntlInfo[lArrayCnt].m_lTopPoint < 0)
                                    {  // データ再描画要の場合
                                        CalcResultMonitor_LinePaint(lArrayCnt); // 折れ線描画
                                       
                                        //あとで消す
                                        //HySDotNetDrawMonitor csDrawMonitor = new HySDotNetDrawMonitor(m_csInstanceCommon);

                                        m_csDrawMonitor.SetInstanceCommon(m_csInstanceCommon);
                                        m_csDrawMonitor.SetCntlInfo(m_csCntlInfo);
                                        m_csDrawMonitor.SetDataHashTable(m_csData);
                                        m_csDrawMonitor.SetSelectCellNum(m_lCellSelectNum);
                                        if (m_dYMinLeftScaleCheck == true)
                                        {
                                            m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);
                                        }
                                        if (m_dYLeftScaleCheck == true)
                                        {
                                            m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
                                        }

                                        if (this is HySDotNetMoniterRiverbedForm)
                                        {  //1次元縦断モニターの場合は別処理
                                            //m_csDrawMonitor.SetRiverbetTimePoint(m_lTPointCnt);
                                            m_csDrawMonitor.DrawRiverbedFullMonitor(lArrayCnt);
                                            m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                                            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);
                                        }
                                        else
                                        {
                                            m_csDrawMonitor.DrawLeftFullMonitor(lArrayCnt);
                                            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);
                                        }


                                    }
                                }
                                if (m_csXUnderScalePictureBox is PictureBox)
                                {  // 水平軸描画エリアが有効な場合
                                    if (bXUnderUpdateflg == true)
                                    {  // 水平軸に更新が有る場合
                                        CalcResultMonitor_XUnderScalePaint(); // Ｘ軸メモリ描画
                                        m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/24]
                                        m_csXUnderScalePictureBox.Invalidate();
                                    }
                                }
                                SetControlEnable(true); // 操作系抑止解除
                            }
                            else
                            {  // 演算結果が空の場合
                                if (m_csYLeftScrollBar is VScrollBar)
                                {  // 垂直左端軸スクロールバーが有効な場合
                                    if (m_csYLeftScrollBar.Maximum != (int)m_dYLeftScaleMax_Mst ||
                                        m_dYLeftScaleMax_Mst != m_dYLeftScaleMaxNumber)
                                    {  // 最大値更新の場合
                                        bGraphAllClearFlg = true;
                                    }
                                    if (m_csYLeftScrollBar.Minimum != (int)m_dYLeftScaleMin_Mst ||
                                       m_dYLeftScaleMin_Mst != m_dYLeftScaleMinNumber)
                                    {  //最小値更新の場合[2011/01/18]
                                        bGraphAllClearFlg = true;
                                    }
                                }
                                if (m_csYRightScrollBar is VScrollBar)
                                {  // 垂直右端軸スクロールバーが有効な場合
                                    if (m_csYRightScrollBar.Maximum != (int)m_dYRightScaleMax_Mst ||
                                        m_dYRightScaleMax_Mst != m_dYRightScaleMaxNumber)
                                    {  // 最大値更新の場合
                                        //bGraphAllClearFlg = true;
                                    }
                                }
                            }
                        }
                        if (lArrayNum == 1)
                        {  // 接続要素が片側しかない場合
                            if (m_csCntlInfo[0].m_csVarticalType.Equals(VERTICAL_RIGHT) == true)
                            {  // Y軸右端が基準の場合
                                if (m_csYLeftScrollBar is VScrollBar)
                                {  // 垂直左端軸スクロールバーが有効な場合
                                    if (m_csYLeftScrollBar.Maximum != (int)m_dYLeftScaleMax_Mst ||
                                        m_dYLeftScaleMax_Mst != m_dYLeftScaleMaxNumber)
                                    {  // 最大値更新の場合
                                        //bGraphAllClearFlg = true;
                                    }
                                }
                            }
                            else
                            {  // Y軸左端が基準の場合
                                if (m_csYRightScrollBar is VScrollBar)
                                {  // 垂直右端軸スクロールバーが有効な場合
                                    if (m_csYRightScrollBar.Maximum != (int)m_dYRightScaleMax_Mst ||
                                        m_dYRightScaleMax_Mst != m_dYRightScaleMaxNumber)
                                    {  // 最大値更新の場合
                                        //bGraphAllClearFlg = true;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {  // 演算結果が無い場合
                        if (m_csYLeftScrollBar is VScrollBar)
                        {  // 垂直左端軸スクロールバーが有効な場合
                            if (m_csYLeftScrollBar.Maximum != (int)m_dYLeftScaleMax_Mst ||
                                m_dYLeftScaleMax_Mst != m_dYLeftScaleMaxNumber)
                            {  // 最大値更新の場合
                                //bGraphAllClearFlg = true;
                            }
                            if (m_csYLeftScrollBar.Minimum != (int)m_dYLeftScaleMin_Mst ||
                                       m_dYLeftScaleMin_Mst != m_dYLeftScaleMinNumber)
                            {  //最小値更新の場合[2011/01/18]
                                //bGraphAllClearFlg = true;
                            }
                        }
                        if (m_csYRightScrollBar is VScrollBar)
                        {  // 垂直右端軸スクロールバーが有効な場合
                            if (m_csYRightScrollBar.Maximum != (int)m_dYRightScaleMax_Mst ||
                                m_dYRightScaleMax_Mst != m_dYRightScaleMaxNumber)
                            {  // 最大値更新の場合
                                //bGraphAllClearFlg = true;
                            }
                            if (m_csYRightScrollBar.Minimum != (int)m_dYRightScaleMin_Mst ||
                                       m_dYRightScaleMin_Mst != m_dYRightScaleMinNumber)
                            {  //最小値更新の場合[2011/01/18]
                                //bGraphAllClearFlg = true;
                            }
                        }
                    }
                }
                catch
                {
                    GraphAllReset(); // 初期描画
                }
            }
            if (bGraphAllClearFlg == true)
            {  // 初期描画が必要な場合
                GraphAllReset();
            }
            SetTimerEnable(true); // タイマー再開
        }
        /// <summary><para>method outline:</para>
        /// <para>ハイエト描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_HyetoPaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_HyetoPaint(long lArrayCnt)
        {
            Graphics g = null;

            if (m_csCntlInfo[lArrayCnt].m_lTopPoint < 0)
            {  // 再描画が必要な場合
                if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
                {  // 右端基準グラフ描画エリアが有効な場合
                    if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                    {  // ビットマップ解放要の場合
                        m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                        m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                    }
                    if (m_csCntlInfo[lArrayCnt].m_csBmap != null)
                    {  // ビットマップ解放要の場合
                        m_csCntlInfo[lArrayCnt].m_csBmap.Dispose();
                    }
                    m_csCntlInfo[lArrayCnt].m_csBmap = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                       m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                    g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmap); // グラフ描画エリア設定
                }
            }
            long lTop = (m_csCntlInfo[lArrayCnt].m_lTopPoint > 0) ? m_csCntlInfo[lArrayCnt].m_lTopPoint : 0;
            m_csCntlInfo[lArrayCnt].m_lPointCnt = m_csData.GetCount(); // 描画件数記憶
            SetControlEnable(false); // 操作系抑止

            // 画面表示準備
            double dXScaleMin = m_dXScaleMin; // X軸最小値(基準値)
            double dXScaleMax = m_dXScaleMax; // X軸最大値(基準値)
            double dXScale = m_dXScale;       // X軸目盛間隔(基準値)
            double dYRightScaleMin = m_dYRightScaleMin; // Y軸右端最小値(基準値)
            double dYRightScaleMax = m_dYRightScaleMax; // Y軸右端最大値(基準値)
            double dYRighttScale = m_dYRightScale;      // Y軸右端目盛間隔(基準値)

            // 基本情報設定
            long lDataNum = m_csData.GetCount();
            long lSirDataNum = 0;
            double dOffset = 0.0;
            double dlXX = 0.0;
            double dlYY = 0.0;
            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 右端基準グラフ描画エリアだけが有効な場合
                dlXX = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Width;
                dlYY = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Height;
            }
            else
            {  // その他
                return;
            }

            if (m_bDispFlg == true)
            {  // 表示要求が有る場合
                if (lDataNum > 0)
                {  // 表示データがある場合
                    HySD1CellArrayData csCellData = m_csData[new HySString("0")] as HySD1CellArrayData;
                    if (csCellData is HySD1CellArrayData)
                    {  // セル型データの場合
                        lSirDataNum = csCellData.GetDataDimentionInCell(); // セル内部配列数取得
                    }
                    else
                    {  // セル型データ以外の場合
                        lSirDataNum = 1; // 初期値設定
                    }
                    double[] dX_Org = new double[lDataNum];

                    // Ｙ軸右端基準範囲設定
                    if (m_csYRightScrollBar is VScrollBar)
                    {  // 垂直右端軸スクロールバーが有効な場合
                        if (m_csYRightScrollBar.Minimum != (int)m_dYRightScaleMin)
                        {  // 最小値更新の場合
                            if ((int)m_dYRightScaleMin > m_csYRightScrollBar.Maximum)
                            {  // 現設定最大範囲を超える場合
                                //m_csYRightScrollBar.Maximum = (int)(m_dYRightScaleMax);
                            }
                            //m_csYRightScrollBar.Minimum = (int)m_dYRightScaleMin;
                            if (m_bYRightManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                m_dYRightValue = m_dYRightScaleMin;
                            }
                        }
                        if (m_csYRightScrollBar.Maximum != (int)m_dYRightScaleMax)
                        {  // 最大値更新の場合
                            //m_csYRightScrollBar.Maximum = (int)(m_dYRightScaleMax);
                            if (m_bYRightManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                int iChkNum = (m_csYRightScrollBar.Maximum - m_csYRightScrollBar.LargeChange) >= 0 ?
                                    m_csYRightScrollBar.Maximum - m_csYRightScrollBar.LargeChange : m_csYRightScrollBar.Minimum;
                                if (iChkNum >= m_csYRightScrollBar.Minimum && iChkNum <= m_csYRightScrollBar.Maximum)
                                {  // 有効範囲内の場合
                                    m_dYRightValue = iChkNum;
                                    //m_csYRightScrollBar.Value = iChkNum;
                                    m_csYRightScrollBar.PerformLayout();
                                }
                            }
                        }
                    }
                    double dYRightLogScaleMax = m_dYRightScaleMax;
                    double dYRightLogScaleMin = m_dYRightScaleMin;
                    double dYRightLogZoom = ((m_dYRightScaleMax - m_dYRightScaleMin) * m_dYRightRato) + 1;
                    if (m_csYRightScrollBar.LargeChange != (int)dYRightLogZoom)
                    {  // 表示範囲が異なる場合
                        //m_csYRightScrollBar.LargeChange = (int)dYRightLogZoom;
                        if (m_bYRightManualFlg == false)
                        {  // 表示範囲自動更新の場合
                            int iChkNum = (m_csYRightScrollBar.Maximum - m_csYRightScrollBar.LargeChange) >= 0 ?
                                m_csYRightScrollBar.Maximum - m_csYRightScrollBar.LargeChange : m_csYRightScrollBar.Minimum;
                            if (iChkNum >= m_csYRightScrollBar.Minimum && iChkNum <= m_csYRightScrollBar.Maximum)
                            {  // 有効範囲内の場合
                                m_dYRightValue = iChkNum;
                                //m_csYRightScrollBar.Value = iChkNum;
                                m_csYRightScrollBar.PerformLayout();
                            }
                        }
                    }
                    double dYRightLogScale = ((dYRightLogScaleMax - dYRightLogScaleMin) <= 0.0) ? 1.0 : (dYRightLogScaleMax - dYRightLogScaleMin);
                    double dllYRight = (dlYY) / dYRightLogScale;

                    // Ｘ軸基準範囲設定
                    if (m_csXUnderScrollBar is HScrollBar)
                    {  // 水平スクロールバーが有効な場合
                        if (m_csXUnderScrollBar.Minimum != (int)m_dXScaleMin)
                        {  // 最小値更新の場合
                            if ((int)m_dXScaleMin > m_csXUnderScrollBar.Maximum)
                            {  // 現設定最大範囲を超える場合
                                //m_csXUnderScrollBar.Maximum = (int)m_dXScaleMax;
                            }
                            //m_csXUnderScrollBar.Minimum = (int)m_dXScaleMin;
                            if (m_bXManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                //m_csXUnderScrollBar.Value = (int)m_dXScaleMin;
                                m_csXUnderScrollBar.PerformLayout();
                                m_dXValue = m_dXScaleMin;
                            }
                        }
                        if (m_csXUnderScrollBar.Maximum != (int)m_dXScaleMax)
                        {  // 最大値更新の場合
                            //m_csXUnderScrollBar.Maximum = (int)m_dXScaleMax;
                        }
                    }
                    double dXLogScaleMax = m_dXScaleMax;
                    double dXLogScaleMin = m_dXScaleMin;
                    double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                    if (m_csXUnderScrollBar.LargeChange != (int)dXLogZoom)
                    {  // 表示範囲が異なる場合
                        //m_csXUnderScrollBar.LargeChange = (int)dXLogZoom;
                    }
                    double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                    double dllX = dlXX / dXLogScale;

                    // ブラシ色生成
                    int sR = Convert.ToInt32(m_sColor[0].Substring(1, 2), 16);
                    int sG = Convert.ToInt32(m_sColor[0].Substring(3, 2), 16);
                    int sB = Convert.ToInt32(m_sColor[0].Substring(5, 2), 16);
                    SolidBrush csBrush = new SolidBrush(Color.FromArgb(sR, sG, sB));
                    // 編集エリア生成
                    double[] dData_af = new double[lSirDataNum];
                    double[] dData_af_w = new double[lSirDataNum];
                    double[] dData_bf = new double[lSirDataNum];
                    double[] dData_bfw = new double[lSirDataNum];
                    double[] dData = new double[lSirDataNum];
                    long lStep = 1;// ((lDataNum / m_lGraphDataMax) <= 0) ? 1 : lDataNum / m_lGraphDataMax;
                    for (long lP = lTop; lP < lDataNum; lP += lStep)
                    {  // データが有る場合
                        csCellData = m_csData[new HySString(lP.ToString())] as HySD1CellArrayData;
                        if (csCellData is HySD1CellArrayData)
                        {  // セル型データの場合
                            bool bFlg = false;
                            HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                            HySCellData[] csCell = csCellData.GetCellData();        // セル配列データ取得
                            for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                            {
                                // セルデータを設定（非数値の場合は欠損値に置き換え）
                                dData_bfw[iLp1] = (double.IsNaN(csCell[0].m_dData[iLp1]) == true) ?
                                                             HySDefine.dINVALID_VALUE : csCell[0].m_dData[iLp1];
                            }
                            if (csTime is HySTime)
                            {
                                dX_Org[lP] = csTime.GetTime() - m_dXDltCpc;
                                for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                {
                                    dData_bf[iLp1] = dData_bfw[iLp1];
                                }
                                bFlg = true;
                            }
                            if (bFlg == true)
                            {  // 表示有効範囲の場合
                                double dXWk1, dXWk2, dYWk1, dYWk2;
                                double dHosok;
                                // 演算結果値描画
                                for (int iLp = 0; iLp < lSirDataNum; iLp++)
                                {  // 表示配列数繰り返す
                                    if (dData_bf[iLp] != HySDefine.dINVALID_VALUE)
                                    {  // 欠損データ以外の場合
                                        dXWk1 = (((lP == 0) ? 0 : (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX)));
                                        if (dXWk1 < dOffset)
                                        {  // Ｘ軸最小値補正要の場合
                                            dXWk1 = dOffset;
                                        }
                                        else if (dXWk1 > dlXX)
                                        {  // Ｘ軸最大値補正要の場合
                                            dXWk1 = dlXX;
                                        }
                                        dXWk2 = ((dX_Org[(int)lP] - dXLogScaleMax) + dXLogScale) * dllX;
                                        if (dXWk2 < dOffset)
                                        {  // Ｘ軸最小値補正要の場合
                                            dXWk2 = dOffset;
                                        }
                                        else if (dXWk2 > dlXX)
                                        {  // Ｘ軸最大値補正要の場合
                                            dXWk2 = dlXX;
                                        }
                                        if (dData_af[iLp] >= dYRightLogScaleMax || dData_af[iLp] <= dYRightLogScaleMin)
                                        {  // Y軸が最小値または最大値の場合
                                            if (dData_af[iLp] <= dYRightLogScaleMin)
                                            {  // 最小値の場合
                                                dYWk1 = dlYY;
                                            }
                                            else
                                            {  // 最大値の場合
                                                dYWk1 = 0.0;
                                            }
                                        }
                                        else
                                        {  // Y軸が最小値または最大値以外の場合
                                            dHosok = (((dData_af[iLp] - dYRightLogScaleMax) + dYRightLogScale) * dllYRight) ;
                                            dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                        }
                                        if (dData_bf[iLp] >= dYRightLogScaleMax || dData_bf[iLp] <= dYRightLogScaleMin)
                                        {  // Y軸が最小値または最大値の場合
                                            if (dData_bf[iLp] <= dYRightLogScaleMin)
                                            {  // 最小値の場合
                                                dYWk2 = dlYY;
                                            }
                                            else
                                            {  // 最大値の場合
                                                dYWk2 = 0.0;
                                            }
                                        }
                                        else
                                        {  // Y軸が最小値または最大値以外の場合
                                            dHosok = (((dData_bf[iLp] - dYRightLogScaleMax) + dYRightLogScale) * dllYRight) ;
                                            dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                        }
                                        // 右端基準グラフ描画
                                        if (g is Graphics)
                                        {  // 右端基準グラフ描画エリアが有効な場合
                                            g.FillRectangle(csBrush, (float)dXWk1, (float)0,
                                                                                   (float)(dXWk2 - dXWk1),
                                                                                   (float)(dlYY - dYWk2));   // 四角領域塗り潰し
                                            g.DrawRectangle(new Pen(Color.Black, 1), (float)dXWk1, (float)0,
                                                                                     (float)(dXWk2 - dXWk1),
                                                                                     (float)(dlYY - dYWk2)); // 四角領域作成
                                        }
                                        dData_af[iLp] = dData_bf[iLp]; // 今回データ退避
                                    }
                                }
                            }
                        }
                    }
                    csBrush.Dispose(); // 雨量描画色エリア解放
                    m_csCntlInfo[lArrayCnt].m_lTopPoint = lDataNum; // 次回描画先頭設定
                }
                if (g is Graphics)
                {  // 右端基準グラフ描画エリアが有効な場合
                    g.Dispose();  // 右端基準グラフ描画エリア解放
                    m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                }
                if (m_csYRightScalePictureBox is PictureBox)
                {  // 垂直右端軸描画エリアが有効な場合
                    CalcResultMonitor_YRightScalePaint(); // Ｙ軸右端メモリ描画
                    m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
                    m_csYRightScalePictureBox.Invalidate();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>折れ線描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_LinePaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_LinePaint(long lArrayCnt)
        {
            Graphics g = null;

            if (m_csCntlInfo[lArrayCnt].m_lTopPoint < 0)
            {  // 再描画が必要な場合
                if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
                {  // 左端基準グラフ描画エリアが有効な場合
                    if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                    {  // ビットマップ解放要の場合
                        m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                        m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                    }
                    if (m_csCntlInfo[lArrayCnt].m_csBmap != null)
                    {  // ビットマップ解放要の場合
                        m_csCntlInfo[lArrayCnt].m_csBmap.Dispose();
                    }
                    m_csCntlInfo[lArrayCnt].m_csBmap = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                       m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                    g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmap); // グラフ描画エリア設定
                }
            }
            long lTop = (m_csCntlInfo[lArrayCnt].m_lTopPoint > 0) ? m_csCntlInfo[lArrayCnt].m_lTopPoint : 0;
            m_csCntlInfo[lArrayCnt].m_lPointCnt = m_csData.GetCount(); // 描画件数記憶
            SetControlEnable(false); // 操作系抑止

            // 画面表示準備
            double dXScaleMin = m_dXScaleMin; // X軸最小値(基準値)
            double dXScaleMax = m_dXScaleMax; // X軸最大値(基準値)
            double dXScale = m_dXScale;       // X軸目盛間隔(基準値)
            double dYLeftScaleMin = m_dYLeftScaleMin;   // Y軸左端最小値(基準値)
            double dYLeftScaleMax = m_dYLeftScaleMax;   // Y軸左端最大値(基準値)
            double dYLeftScale = m_dYLeftScale;         // Y軸左端目盛間隔(基準値)

            // 基本情報設定
            long lDataNum = m_csData.GetCount();
            long lSirDataNum = 0;
            double dlXX = 0.0;
            double dlYY = 0.0;
            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 左端基準グラフ描画エリアが有効な場合
                dlXX = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Width;
                dlYY = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Height;
            }
            else
            {  // その他
                return;
            }

            if (m_bDispFlg == true)
            {  // 表示要求が有る場合
                if (lDataNum > 0)
                {  // 表示データがある場合
                    HySD1CellArrayData csCellData = m_csData[new HySString("0")] as HySD1CellArrayData;
                    if (csCellData is HySD1CellArrayData)
                    {  // セル型データの場合
                        lSirDataNum = csCellData.GetDataDimentionInCell(); // セル内部配列数取得
                    }
                    else
                    {  // セル型データ以外の場合
                        lSirDataNum = 1; // 初期値設定
                    }
                    double[] dX_Org = new double[lDataNum];

                    // Ｙ軸左端基準範囲設定
                    if (m_csYLeftScrollBar is VScrollBar)
                    {  // 垂直左端軸スクロールバーが有効な場合
                        if (m_csYLeftScrollBar.Minimum != (int)m_dYLeftScaleMin)
                        {  // 最小値更新の場合
                            if ((int)m_dYLeftScaleMin > m_csYLeftScrollBar.Maximum)
                            {  // 現設定最大範囲を超える場合
                                //m_csYLeftScrollBar.Maximum = (int)(m_dYLeftScaleMax);[2010/01/23]
                            }
                            //m_csYLeftScrollBar.Minimum = (int)m_dYLeftScaleMin;
                            if (m_bYLeftManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                //m_csYLeftScrollBar.Value = (int)m_dYLeftScaleMin;
                                //m_csYLeftScrollBar.PerformLayout();
                            }
                        }
                        if (m_csYLeftScrollBar.Maximum != (int)m_dYLeftScaleMax)
                        {  // 最大値更新の場合
                            //m_csYLeftScrollBar.Maximum = (int)(m_dYLeftScaleMax);//[2010/01/23]
                            if (m_bYLeftManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                //m_dYLeftValue = m_dYLeftScaleMax;
                            }
                        }
                        //if(m_csYLeftScrollBar.Value != m_csYLeftScrollBar.Minimum &&
                        //   m_csYLeftScrollBar.Value != m_csYLeftScrollBar.Maximum)
                        //{  // スケールが最上段または最下段ではない場合
                        //    int iChkNum = m_csYLeftScrollBar.Maximum - (int)m_dYLeftValue;
                        //    if (iChkNum >= m_csYLeftScrollBar.Minimum && iChkNum <= m_csYLeftScrollBar.Maximum)
                        //    {  // 有効範囲内の場合
                        //        if (iChkNum != m_csYLeftScrollBar.Value)
                        //        {  // 現ポジション値と異なる場合
                        //            m_csYLeftScrollBar.Value = iChkNum;
                        //            m_csYLeftScrollBar.PerformLayout();
                        //        }
                        //    }
                        //}
                    }
                    double dYLeftLogScaleMax = m_dYLeftScaleMax;
                    double dYLeftLogScaleMin = m_dYLeftScaleMin;
                    double dYLeftLogZoom = ((m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato) + 1;
                    if (m_csYLeftScrollBar.LargeChange != (int)dYLeftLogZoom)
                    {  // 表示範囲が異なる場合
                        //m_csYLeftScrollBar.LargeChange = (int)dYLeftLogZoom;//[2011/01/23]
                    }
                    double dYLeftLogScale = ((dYLeftLogScaleMax - dYLeftLogScaleMin) <= 0.0) ? 1.0 : (dYLeftLogScaleMax - dYLeftLogScaleMin);
                    double dllYLeft = (dlYY) / dYLeftLogScale;

                    // Ｘ軸基準範囲設定
                    if (m_csXUnderScrollBar is HScrollBar)
                    {  // 水平スクロールバーが有効な場合
                        if (m_csXUnderScrollBar.Minimum != (int)m_dXScaleMin)
                        {  // 最小値更新の場合
                            if ((int)m_dXScaleMin > m_csXUnderScrollBar.Maximum)
                            {  // 現設定最大範囲を超える場合
                                //m_csXUnderScrollBar.Maximum = (int)m_dXScaleMax;
                            }
                            //m_csXUnderScrollBar.Minimum = (int)m_dXScaleMin;
                            if (m_bXManualFlg == false)
                            {  // 表示範囲自動更新の場合
                                //m_csXUnderScrollBar.Value = (int)m_dXScaleMin;
                                m_csXUnderScrollBar.PerformLayout();
                                m_dXValue = m_dXScaleMin;
                            }
                        }
                        if (m_csXUnderScrollBar.Maximum != (int)m_dXScaleMax)
                        {  // 最大値更新の場合
                            //m_csXUnderScrollBar.Maximum = (int)m_dXScaleMax;
                        }
                    }
                    double dXLogScaleMax = m_dXScaleMax;
                    double dXLogScaleMin = m_dXScaleMin;
                    double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                    if (m_csXUnderScrollBar.LargeChange != (int)dXLogZoom)
                    {  // 表示範囲が異なる場合
                        //m_csXUnderScrollBar.LargeChange = (int)dXLogZoom;
                    }
                    double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                    double dllX = dlXX / dXLogScale;

                    // 編集エリア生成
                    double dOffset = 0.0;
                    double[] dData_af = new double[lSirDataNum];
                    double[] dData_af_w = new double[lSirDataNum];
                    double[] dData_bf = new double[lSirDataNum];
                    double[] dData_bfw = new double[lSirDataNum];
                    double[] dData = new double[lSirDataNum];
                    long lStep = ((lDataNum / m_lGraphDataMax) <= 0) ? 1 : lDataNum / m_lGraphDataMax;
                    for (long lP = lTop; lP < lDataNum; lP += lStep)
                    {  // データが有る場合
                        csCellData = m_csData[new HySString(lP.ToString())] as HySD1CellArrayData;
                        if (csCellData is HySD1CellArrayData)
                        {  // セル型データの場合
                            bool bFlg = false;
                            HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                            HySCellData[] csCell = csCellData.GetCellData(); // セル配列データ取得
                            // セルデータを設定（非数値の場合は欠損値に置き換え）
                            dData_bfw[m_lCellSelectNum - 1] = (double.IsNaN(csCell[0].m_dData[m_lCellSelectNum - 1]) == true) ?
                                                              HySDefine.dINVALID_VALUE : csCell[0].m_dData[m_lCellSelectNum - 1];
                            if (csTime is HySTime)
                            {
                                dX_Org[lP] = csTime.GetTime() - m_dXDltCpc;
                                dData_bf[m_lCellSelectNum - 1] = dData_bfw[m_lCellSelectNum - 1];
                                bFlg = true;
                            }
                            if (bFlg == true)
                            {  // 表示有効範囲の場合
                                if (dData_bf[m_lCellSelectNum - 1] != HySDefine.dINVALID_VALUE)
                                {  // 欠損データ以外の場合
                                    double dXWk1, dXWk2, dYWk1, dYWk2;
                                    double dHosok;
                                    // 演算結果値描画
                                    dXWk1 = (((lP == 0) ? 0 : (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX)));
                                    if (dXWk1 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk1 = dOffset;
                                    }
                                    else if (dXWk1 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk1 = dlXX;
                                    }
                                    dXWk2 = ((dX_Org[(int)lP] - dXLogScaleMax) + dXLogScale) * dllX;
                                    if (dXWk2 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk2 = dOffset;
                                    }
                                    else if (dXWk2 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk2 = dlXX;
                                    }
                                    if (dData_af[m_lCellSelectNum - 1] >= dYLeftLogScaleMax || dData_af[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                    {  // Y軸が最小値または最大値の場合
                                        if (dData_af[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk1 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk1 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以外の場合
                                        dHosok = (((dData_af[m_lCellSelectNum - 1] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft) ;
                                        dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    if (dData_bf[m_lCellSelectNum - 1] >= dYLeftLogScaleMax || dData_bf[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                    {  // Y軸が最小値または最大値の場合
                                        if (dData_bf[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk2 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk2 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以外の場合
                                        dHosok = (((dData_bf[m_lCellSelectNum - 1] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft) ;
                                        dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    // 左端基準グラフ描画
                                    if ((dXWk1 >= dOffset || dXWk2 >= dOffset) && (dYWk1 != 0 || dYWk2 != 0))
                                    {  // 描画範囲内の場合
                                        if (g is Graphics)
                                        {  // 左端基準グラフ描画エリアが有効な場合
                                            int sR = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(1, 2), 16);
                                            int sG = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(3, 2), 16);
                                            int sB = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(5, 2), 16);
                                            g.DrawLine(new Pen(Color.FromArgb(sR, sG, sB), m_lLineWidth), (float)dXWk1, (float)dYWk1, (float)dXWk2, (float)dYWk2);
                                        }
                                    }
                                    dData_af[m_lCellSelectNum - 1] = dData_bf[m_lCellSelectNum - 1]; // 今回データ退避
                                }
                            }
                        }
                    }
                    m_csCntlInfo[lArrayCnt].m_lTopPoint = lDataNum; // 次回描画先頭設定
                    m_lColorNum += 1; // 描画色の更新
                }
            }
            if (g is Graphics)
            {  // 左端基準グラフ描画エリアが有効な場合
                g.Dispose(); // 左端基準グラフ描画エリア解放
                m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
            }
            if (m_csYLeftScalePictureBox is PictureBox)
            {  // 垂直左端軸描画エリアが有効な場合
                CalcResultMonitor_YLeftScalePaint(); // Ｙ軸左端メモリ描画
                m_csYLeftScalePictureBox.Invalidate();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_RangePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>描画は垂直左端軸基準、垂直右端軸基準を常に対象とする。対象としたくない場合は関連インスタンスを設定しないこと</para>
        /// </remarks>
        public virtual void CalcResultMonitor_RangePaint()
        {
            if (m_bResetFlg == false)
            {  // グラフ表示の場合
                if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                {  // 表示データが有る場合
                    try
                    {
                        m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
                        if (m_csInstanceCommon is HySDispInstanceCommon)
                        {  // 演算結果が有る場合
                            m_lColorNum = m_lColorNum_Mst; // 描画色カウンタ初期化
                            long lArrayNum = m_csInstanceCommon.GetDataHashTableArray().GetLength(0);
                            for (long lArrayCnt = 0; lArrayCnt < lArrayNum; lArrayCnt++)
                            {  // 配列数分繰り返す
                                if (m_csCntlInfo[lArrayCnt].m_csVarticalType.Equals(VERTICAL_RIGHT) == true)
                                {  // Y軸右端が基準の場合
                                    //CalcResultMonitor_Range_HyetoPaint(lArrayCnt);
                                    m_csDrawMonitor.SetInstanceCommon(m_csInstanceCommon);
                                    m_csDrawMonitor.SetCntlInfo(m_csCntlInfo);
                                    m_csDrawMonitor.SetSelectCellNum(m_lCellSelectNum);
                                    if (m_dYMinRightScaleCheck == true)
                                    {
                                        m_csDrawMonitor.SetRightSetMin(m_dYRightScaleMinNumber);
                                    }
                                    if (m_dYRightScaleCheck == true)
                                    {
                                        m_csDrawMonitor.SetRightSetMax(m_dYRightScaleMaxNumber);
                                    }
                                    m_csDrawMonitor.DrawRightScopeMonitor(lArrayCnt);
                                }
                                else
                                {  // Y軸左端が基準の場合
                                    //CalcResultMonitor_Range_LinePaint(lArrayCnt);//[2011/01/25]
                                    //後で消す
                                    //HySDotNetDrawMonitor csDrawMonitor = new HySDotNetDrawMonitor(m_csInstanceCommon);
                                    m_csDrawMonitor.SetInstanceCommon(m_csInstanceCommon);
                                    m_csDrawMonitor.SetCntlInfo(m_csCntlInfo);
                                    m_csDrawMonitor.SetSelectCellNum(m_lCellSelectNum);
                                    if (m_dYMinLeftScaleCheck == true)
                                    {
                                        m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);
                                    }
                                    if (m_dYLeftScaleCheck == true)
                                    {
                                        m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
                                    }
                                    if (this is HySDotNetMoniterRiverbedForm)
                                    {
                                        m_csDrawMonitor.DrawRiverbedScopeMonitor(lArrayCnt);
                                    }
                                    else
                                    {
                                        m_csDrawMonitor.DrawLeftScopeMonitor(lArrayCnt);
                                    }
                                }
                            }
                        }
                    }
                    catch
                    {
                        GraphAllReset(); // 初期描画
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>ハイエト指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_Range_HyetoPaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_Range_HyetoPaint(long lArrayCnt)
        {
            Graphics g = null;

            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                {  // ビットマップ解放要の場合
                    m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                    m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                }
                m_csCntlInfo[lArrayCnt].m_csBmapRange = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                   m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmapRange);  // グラフ描画エリア設定
            }
            // 画面表示準備
            double dXScaleMin = m_dXScaleMin;      // X軸最小値(基準値)
            double dXScaleMax = m_dXScaleMax;      // X軸最大値(基準値)
            double dXScale = m_dXScale;         // X軸目盛間隔(基準値)
            double dYRightScaleMin = m_dYRightScaleMin; // Y軸右端最小値(基準値)
            double dYRightScaleMax = m_dYRightScaleMax; // Y軸右端最大値(基準値)
            double dYRighttScale = m_dYRightScale;    // Y軸右端目盛間隔(基準値)

            // 基本情報設定
            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lArrayCnt];
            long lDataNum = m_csData.GetCount();
            long lSirDataNum = 0;
            double dOffset = 0.0;
            double dlXX = 0.0;
            double dlYY = 0.0;
            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                dlXX = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Width;
                dlYY = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Height;
            }
            else
            {  // その他
                return;
            }

            if (lDataNum > 0)
            {  // 表示データがある場合
                HySD1CellArrayData csCellData = m_csData[new HySString("0")] as HySD1CellArrayData;
                if (csCellData is HySD1CellArrayData)
                {  // セル型データの場合
                    lSirDataNum = csCellData.GetDataDimentionInCell(); // セル内部配列数取得
                }
                else
                {  // セル型データ以外の場合
                    lSirDataNum = 1; // 初期値設定
                }
                double[] dX_Org = new double[lDataNum];

                // 編集エリア生成
                bool bEndFlag = false;
                // ロバストチェック指摘に対する修正[１行に複数の文を定義しています]
                long lXScaleTop = -1;
                double[] dData_af = new double[lSirDataNum];
                double[] dData_af_w = new double[lSirDataNum];
                double[] dData_bf = new double[lSirDataNum];
                double[] dData_bfw = new double[lSirDataNum];
                double[] dData = new double[lSirDataNum];

                // Ｘ軸基準範囲設定
                double dXLogScaleMax = m_dXScaleMax;
                double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                if (m_bXManualFlg == true)
                {  // 表示範囲自動更新の場合
                    if (m_csXUnderScrollBar is HScrollBar)
                    {  // 水平スクロールバーが有効な場合
                        double dMax = (double)(m_csXUnderScrollBar.Value + m_csXUnderScrollBar.LargeChange);
                        if (dMax >= (double)m_csXUnderScrollBar.Maximum)
                        {  // 最後尾まで表示範囲の場合
                            dMax = (double)m_csXUnderScrollBar.Maximum;
                        }
                        dXLogScaleMax = dMax;
                        dXLogScaleMin = (dXLogScaleMax - dXLogZoom < m_dXScaleMin) ? m_dXScaleMin :
                                                                                     dXLogScaleMax - dXLogZoom;
                    }
                }
                double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                double dllX = dlXX / dXLogScale;

                double dYRightLogScaleMax = m_dYRightScaleMax;
                double dYRightLogZoom = (m_dYRightScaleMax - m_dYRightScaleMin) * m_dYRightRato;
                double dYRightLogScaleMin = (dYRightLogScaleMax - dYRightLogZoom < 0) ? m_dYRightScaleMin :
                                                                                        dYRightLogScaleMax - dYRightLogZoom;
                if (m_bYRightManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dMax = (double)(m_csYRightScrollBar.Value + m_csYRightScrollBar.LargeChange - 1); // ebeb
                    if (dMax >= (double)m_csYRightScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csYRightScrollBar.Maximum;
                    }
                    dYRightLogScaleMax = dMax;
                    dYRightLogScaleMin = (dYRightLogScaleMax - dYRightLogZoom < m_dYRightScaleMin) ? m_dYRightScaleMin :
                                                                                 dYRightLogScaleMax - dYRightLogZoom;
                }
                double dYRightLogScale = ((dYRightLogScaleMax - dYRightLogScaleMin) <= 0.0) ? 1.0 : (dYRightLogScaleMax - dYRightLogScaleMin);
                double dllYRight = (dlYY) / dYRightLogScale;
                // ブラシ色コード生成
                int sR = Convert.ToInt32(m_sColor[0].Substring(1, 2), 16);
                int sG = Convert.ToInt32(m_sColor[0].Substring(3, 2), 16);
                int sB = Convert.ToInt32(m_sColor[0].Substring(5, 2), 16);
                SolidBrush csBrush = new SolidBrush(Color.FromArgb(sR, sG, sB));
                long lStep = 1;// ((lDataNum / m_lGraphDataMax) <= 0) ? 1 : lDataNum / m_lGraphDataMax;
                for (long lP = 0; lP < lDataNum; lP += lStep)
                {  // データが有る場合
                    csCellData = m_csData[new HySString(lP.ToString())] as HySD1CellArrayData;
                    if (csCellData is HySD1CellArrayData)
                    {  // セル型データの場合
                        bool bFlg = false;
                        HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                        HySCellData[] csCell = csCellData.GetCellData();        // セル配列データ取得
                        for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                        {
                            // セルデータを設定（非数値の場合は欠損値に置き換え）
                            dData_bfw[iLp1] = (double.IsNaN(csCell[0].m_dData[iLp1]) == true) ?
                                                         HySDefine.dINVALID_VALUE : csCell[0].m_dData[iLp1];
                        }
                        if (csTime is HySTime)
                        {
                            dX_Org[lP] = csTime.GetTime() - m_dXDltCpc;
                            //if (csTime.GetTime() >= dXLogScaleMin)
                            if (dX_Org[lP] >= dXLogScaleMin)
                            {  // 表示範囲内の場合
                                if (lXScaleTop < 0)
                                {
                                    lXScaleTop = lP;
                                    for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                    {
                                        dData_af[iLp1] = dData_af_w[iLp1];
                                    }
                                }
                                for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                {
                                    dData_bf[iLp1] = dData_bfw[iLp1];
                                }
                                bFlg = true;
                            }
                            else
                            {  // 表示範囲外の場合
                                //if (csTime.GetTime() > dXLogScaleMax)
                                if (dX_Org[lP] > dXLogScaleMax)
                                {  // 最大表示範囲を超えた場合
                                    bEndFlag = true;
                                }
                                for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                {
                                    if (dData_bfw[iLp1] != HySDefine.dINVALID_VALUE)
                                    {  // 欠損データ以外の場合
                                        dData_af_w[iLp1] = dData_bfw[iLp1];
                                    }
                                }
                            }
                        }
                        if (bFlg == true)
                        {  // 表示有効範囲の場合
                            double dXWk1, dXWk2, dYWk1, dYWk2;
                            double dHosok;
                            // 演算結果値描画
                            for (int iLp = 0; iLp < lSirDataNum; iLp++)
                            {
                                if (dData_bf[iLp] != HySDefine.dINVALID_VALUE)
                                {  // 欠損データ以外の場合
                                    dXWk1 = (((lP == lXScaleTop) ? 0 : (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX)));
                                    if (dXWk1 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk1 = dOffset;
                                    }
                                    else if (dXWk1 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk1 = dlXX;
                                    }
                                    dXWk2 = ((dX_Org[(int)lP] - dXLogScaleMax) + dXLogScale) * dllX;
                                    if (dXWk2 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk2 = dOffset;
                                    }
                                    else if (dXWk2 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk2 = dlXX;
                                    }
                                    if (dData_af[iLp] >= dYRightLogScaleMax || dData_af[iLp] <= dYRightLogScaleMin)
                                    {  // Y軸が最小値または最大値以外の場合
                                        if (dData_af[iLp] <= dYRightLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk1 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk1 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以内の場合
                                        dHosok = (((dData_af[iLp] - dYRightLogScaleMax) + dYRightLogScale) * dllYRight) ;
                                        dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    if (dData_bf[iLp] >= dYRightLogScaleMax || dData_bf[iLp] <= dYRightLogScaleMin)
                                    {  // Y軸が最小値または最大値以外の場合
                                        if (dData_bf[iLp] <= dYRightLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk2 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk2 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以内の場合
                                        dHosok = (((dData_bf[iLp] - dYRightLogScaleMax) + dYRightLogScale) * dllYRight) ;
                                        dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    // 右端基準グラフ描画
                                    if (g is Graphics)
                                    {  // 右端基準グラフ描画エリアが有効な場合
                                        g.FillRectangle(csBrush, (float)dXWk1, (float)0,
                                                                               (float)(dXWk2 - dXWk1),
                                                                               (float)(dlYY - dYWk2)); // 四角領域塗り潰し
                                        g.DrawRectangle(new Pen(Color.Black, 1), (float)dXWk1, (float)0,
                                                                                 (float)(dXWk2 - dXWk1),
                                                                                 (float)(dlYY - dYWk2)); // 四角領域作成
                                    }
                                    dData_af[iLp] = dData_bf[iLp]; // 今回データ退避
                                }
                            }
                        }
                        if (bEndFlag == true)
                        {  // 描画最終データの場合
                            break;
                        }
                    }
                }
                csBrush.Dispose(); // 雨量描画色エリア解放
                if (g is Graphics)
                {  // 右端基準グラフ描画エリアが有効な場合
                    g.Dispose();  // 右端基準グラフ描画エリア解放
                    m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>折れ線指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_Range_LinePaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_Range_LinePaint(long lArrayCnt)
        {
            Graphics g = null;

            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                {  // ビットマップ解放要の場合
                    m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                    m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                }
                m_csCntlInfo[lArrayCnt].m_csBmapRange = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                   m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmapRange);  // グラフ描画エリア設定
            }
            // 画面表示準備
            double dXScaleMin = m_dXScaleMin;      // X軸最小値(基準値)
            double dXScaleMax = m_dXScaleMax;      // X軸最大値(基準値)
            double dXScale = m_dXScale;         // X軸目盛間隔(基準値)
            double dYLeftScaleMin = m_dYLeftScaleMin;  // Y軸左端最小値(基準値)
            double dYLeftScaleMax = m_dYLeftScaleMax;  // Y軸左端最大値(基準値)
            double dYLeftScale = m_dYLeftScale;     // Y軸左端目盛間隔(基準値)

            // 基本情報設定
            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lArrayCnt];
            long lDataNum = m_csData.GetCount();
            long lSirDataNum = 0;
            double dOffset = 0.0;
            double dlXX = 0.0;
            double dlYY = 0.0;
            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                dlXX = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Width;
                dlYY = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Height;
            }
            else
            {  // その他
                return;
            }

            if (lDataNum > 0)
            {  // 表示データがある場合
                HySD1CellArrayData csCellData = m_csData[new HySString("0")] as HySD1CellArrayData;
                if (csCellData is HySD1CellArrayData)
                {  // セル型データの場合
                    lSirDataNum = csCellData.GetDataDimentionInCell(); // セル内部配列数取得
                }
                else
                {  // セル型データ以外の場合
                    lSirDataNum = 1; // 初期値設定
                }
                double[] dX_Org = new double[lDataNum];

                // 編集エリア生成
                bool bEndFlag = false;
                // ロバストチェック指摘に対する修正[１行に複数の文を定義しています]
                long lXScaleTop = -1;
                double[] dData_af = new double[lSirDataNum];
                double[] dData_af_w = new double[lSirDataNum];
                double[] dData_bf = new double[lSirDataNum];
                double[] dData_bfw = new double[lSirDataNum];
                double[] dData = new double[lSirDataNum];
                long lStep = ((lDataNum / m_lGraphDataMax) <= 0) ? 1 : lDataNum / m_lGraphDataMax;

                // Ｘ軸基準範囲設定
                double dXLogScaleMax = m_dXScaleMax;
                double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                if (m_bXManualFlg == true)
                {  // 表示範囲自動更新の場合
                    if (m_csXUnderScrollBar is HScrollBar)
                    {  // 水平スクロールバーが有効な場合
                        double dMax = (double)(m_csXUnderScrollBar.Value + m_csXUnderScrollBar.LargeChange);
                        if (dMax >= (double)m_csXUnderScrollBar.Maximum)
                        {  // 最後尾まで表示範囲の場合
                            dMax = (double)m_csXUnderScrollBar.Maximum;
                        }
                        dXLogScaleMax = dMax;
                        dXLogScaleMin = (dXLogScaleMax - dXLogZoom < m_dXScaleMin) ? m_dXScaleMin :
                                                                                     dXLogScaleMax - dXLogZoom;
                    }
                }
                double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                double dllX = dlXX / dXLogScale;

                double dYLeftLogScaleMax = m_dYLeftScaleMax;
                double dYLeftLogZoom = (m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato;
                double dYLeftLogScaleMin = (dYLeftLogScaleMax - dYLeftLogZoom < 0) ? m_dYLeftScaleMin : dYLeftLogScaleMax - dYLeftLogZoom;
                if (m_bYLeftManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dYHosei = (m_csYLeftScrollBar.Minimum < 0) ? -((double)m_csYLeftScrollBar.Minimum) : 0.0;
                    double dMax = (double)m_csYLeftScrollBar.Maximum - ((double)m_csYLeftScrollBar.Value + dYHosei);
                    if (dMax > (double)m_csYLeftScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csYLeftScrollBar.Maximum;
                    }
                    dYLeftLogScaleMax = dMax;
                    dYLeftLogScaleMin = (dYLeftLogScaleMax - dYLeftLogZoom < m_dYLeftScaleMin) ? m_dYLeftScaleMin :
                                                                                 dYLeftLogScaleMax - dYLeftLogZoom;
                }

                double dYLeftLogScale = ((dYLeftLogScaleMax - dYLeftLogScaleMin) <= 0.0) ? 1.0 : (dYLeftLogScaleMax - dYLeftLogScaleMin);
                double dllYLeft = dlYY / dYLeftLogScale;
                for (long lP = 0; lP < lDataNum; lP += lStep)
                {  // データが有る場合
                    csCellData = m_csData[new HySString(lP.ToString())] as HySD1CellArrayData;
                    if (csCellData is HySD1CellArrayData)
                    {  // セル型データの場合
                        bool bFlg = false;
                        HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                        HySCellData[] csCell = csCellData.GetCellData(); // セル配列データ取得
                        // セルデータを設定（非数値の場合は欠損値に置き換え）
                        dData_bfw[m_lCellSelectNum - 1] = (double.IsNaN(csCell[0].m_dData[m_lCellSelectNum - 1]) == true) ?
                                                          HySDefine.dINVALID_VALUE : csCell[0].m_dData[m_lCellSelectNum - 1];
                        if (csTime is HySTime)
                        {
                            dX_Org[lP] = csTime.GetTime() - m_dXDltCpc;
                            //if (csTime.GetTime() >= dXLogScaleMin)
                            if (dX_Org[lP] >= dXLogScaleMin)
                             {  // 表示範囲内の場合
                                if (lXScaleTop < 0)                             
                                {
                                    lXScaleTop = lP;
                                    dData_af[m_lCellSelectNum - 1] = dData_af_w[m_lCellSelectNum - 1];
                                }
                                dData_bf[m_lCellSelectNum - 1] = dData_bfw[m_lCellSelectNum - 1];
                                bFlg = true;
                            }
                            else
                            {  // 表示範囲外の場合
                                //if (csTime.GetTime() > dXLogScaleMax)
                                if (dX_Org[lP] > dXLogScaleMax)
                                {  // 最大表示範囲を超えた場合
                                    bEndFlag = true;
                                }
                                if (dData_bfw[m_lCellSelectNum - 1] != HySDefine.dINVALID_VALUE)
                                {  // 欠損データ以外の場合
                                    dData_af_w[m_lCellSelectNum - 1] = dData_bfw[m_lCellSelectNum - 1];
                                }
                            }
                        }
                        if (bFlg == true)
                        {  // 表示有効範囲の場合
                            if (dData_bf[m_lCellSelectNum - 1] != HySDefine.dINVALID_VALUE)
                            {  // 欠損データ以外の場合
                                double dXWk1, dXWk2, dYWk1, dYWk2;
                                double dHosok;
                                // 演算結果値描画
                                // Ｘ軸設定
                                //double dPPXWk1 = (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX);
                                dXWk1 = (((lP == lXScaleTop) ? 0 : (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX)));
                                if ( (int)(lP - lStep) >= 0 && ((int)lP-lStep)< dX_Org.Length)
                                {
                                    dXWk1 = (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX);
                                }
                                else
                                {
                                    dXWk1 = (((lP == lXScaleTop) ? 0 : (((dX_Org[(int)lP - lStep] - dXLogScaleMax) + dXLogScale) * dllX)));
                                }
                                if (dXWk1 < dOffset)
                                {  // Ｘ軸最小値補正要の場合
                                    //dXWk1 = dOffset;
                                }
                                else if (dXWk1 > dlXX)
                                {  // Ｘ軸最大値補正要の場合
                                    dXWk1 = dlXX;
                                }
                                double dFFXwk2 = ((dX_Org[(int)lP] - dXLogScaleMax) + dXLogScale) * dllX;
                                dXWk2 = ((dX_Org[(int)lP] - dXLogScaleMax) + dXLogScale) * dllX;
                                if (dXWk2 < dOffset)
                                {  // Ｘ軸最小値補正要の場合
                                    dXWk2 = dOffset;
                                }
                                else if (dXWk2 > dlXX)
                                {  // Ｘ軸最大値補正要の場合
                                    //dXWk2 = dlXX;
                                }
                                //if (dData_af[m_lCellSelectNum - 1] >= dYLeftLogScaleMax || dData_af[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                //{  // Y軸が最小値または最大値以外の場合
                                //    if (dData_af[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                //    {  // 最小値の場合
                                //        dYWk1 = dlYY;
                                //    }
                                //    else
                                //    {  // 最大値の場合
                                //        dYWk1 = 0.0;
                                //    }
                                //}
                                //else
                                {  // Y軸が最小値または最大値以内の場合
                                    dHosok = (((dData_af[m_lCellSelectNum - 1] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                    //dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    dYWk1 = dlYY - dHosok;
                                }
                                //if (dData_bf[m_lCellSelectNum - 1] >= dYLeftLogScaleMax || dData_bf[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                //{  // Y軸が最小値または最大値以外の場合
                                //    if (dData_bf[m_lCellSelectNum - 1] <= dYLeftLogScaleMin)
                                //    {  // 最小値の場合
                                //        dYWk2 = dlYY;
                                //    }
                                //    else
                                //    {  // 最大値の場合
                                //        dYWk2 = 0.0;
                                //    }
                                //}
                                //else
                                {  // Y軸が最小値または最大値以内の場合
                                    dHosok = (((dData_bf[m_lCellSelectNum - 1] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                    //dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    dYWk2 = dlYY - dHosok;
                                }
                                // 左端基準描画
                                if ((dXWk1 >= dOffset || dXWk2 >= dOffset) && (dYWk1 != 0 || dYWk2 != 0))
                                {  // 描画範囲内の場合
                                    if (g is Graphics)
                                    {  // 左端基準グラフ描画エリアが有効な場合
                                        int sR = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(1, 2), 16);
                                        int sG = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(3, 2), 16);
                                        int sB = Convert.ToInt32(m_sColor[m_lColorNum % m_sColor.GetLength(0)].Substring(5, 2), 16);
                                        g.DrawLine(new Pen(Color.FromArgb(sR, sG, sB), m_lLineWidth), (float)dXWk1, (float)dYWk1, (float)dXWk2, (float)dYWk2);
                                    }
                                }
                                dData_af[m_lCellSelectNum - 1] = dData_bf[m_lCellSelectNum - 1]; // 今回データ退避
                            }
                        }
                        if (bEndFlag == true)
                        {  // 描画最終データの場合
                            break;
                        }
                    }
                }
                m_lColorNum += 1; // 描画色の更新
                if (g is Graphics)
                {  // 基準グラフ描画エリアが有効な場合
                    g.Dispose();  // 右端基準グラフ描画エリア解放
                    m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＸ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_XUnderScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_XUnderScalePaint()
        {
            if (m_csBmapXUnder != null)
            {  // ビットマップ解放要の場合
                m_csBmapXUnder.Dispose();
                m_csBmapXUnder = null;
            }
            if (m_csXUnderScalePictureBox.Width > 0 && m_csXUnderScalePictureBox.Height > 0)
            {  // 描画フィールドが有る場合
                m_csBmapXUnder = new Bitmap((int)(m_csXUnderScalePictureBox.Width), (int)(m_csXUnderScalePictureBox.Height));
                Graphics gX = Graphics.FromImage(m_csBmapXUnder); // グラフ描画エリア設定

                double dOffset = 5.0;
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                StringFormat csSf = new StringFormat();
                csSf.FormatFlags = StringFormatFlags.DirectionVertical;
                // 基準領域情報取得
                double dlXX = 0;
                long lWidth = 0;
                long lHeigh = 0;
                GetGraphAreaInfo(0, ref lWidth, ref lHeigh);
                if (lWidth > 0)
                {  // 基準グラフ描画エリアが有効な場合
                    dlXX = lWidth;
                }
                else
                {
                    csFnt.Dispose(); // フォントリソース解放
                    gX.Dispose(); // グラフ描画エリア解放
                    return;
                }
                double dXLogScaleMax = m_dXScaleMax;
                double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                if (m_bXManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dMax = (double)(m_csXUnderScrollBar.Value + m_csXUnderScrollBar.LargeChange);
                    if (dMax >= (double)m_csXUnderScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csXUnderScrollBar.Maximum;
                    }
                    dXLogScaleMax = dMax;
                    dXLogScaleMin = (dXLogScaleMax - dXLogZoom < m_dXScaleMin) ? m_dXScaleMin :
                                                                                 dXLogScaleMax - dXLogZoom;
                }

                // X軸メモリ描画
                double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                double dllX = dlXX / dXLogScale;
                // 描画間隔設定
                long lStep = 0;
                for (int iStep = m_dXInterval.GetLength(0) - 1; iStep >= 1; iStep--)
                {
                    lStep = (long)m_dXInterval[iStep];
                    if (Math.Floor(dXLogScale / (double)lStep) >= 12)
                    {  // 商が無い場合
                        if (Math.Floor(dXLogScale / (double)lStep) > 12)
                        {  // ラベル個数が範囲外の場合
                            if (iStep != (m_dXInterval.GetLength(0) - 1))
                            {  // 最終表示間隔以内の場合
                                lStep = (long)m_dXInterval[iStep + 1];
                            }
                        }
                        break;
                    }
                }
                // メモリ、ラベルの描画
                for (double dX = dXLogScaleMin; dX <= dXLogScaleMax; dX += lStep)
                {
                    double dWk1 = ((dX - dXLogScaleMax) + dXLogScale) * dllX;
                    if (dWk1 >= 0.0)
                    { // 描画Pix範囲内の場合
                        gX.DrawLine(new Pen(Color.Black, m_lMemoryWidth), (float)(dWk1 + dOffset), 0, (float)(dWk1 + dOffset), 3);
                        //HySTime csTime = new HySTime(dX);
                        HySTime csTime = new HySTime(dX + m_dXDltCpc);
                        string sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                                                    HySCalendar.FORMAT.lSW_YEAR).ToString()).ToString("MM/dd HH:mm");
                        gX.DrawString(sWk, csFnt, Brushes.Black, (float)(dWk1 - (dOffset / 2.0)), 5, csSf);
                    }
                    else
                    {
                        break;
                    }
                }
                csFnt.Dispose(); // フォントリソース解放
                gX.Dispose(); // グラフ描画エリア解放
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グラフ左端メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_YLeftScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YLeftScalePaint()
        {
            int iStep = 0;
            long lStepMax = VERTICAL_MEMORY_STEP;

            if (m_csBmapYLeft != null)
            {  // ビットマップ解放要の場合
                m_csBmapYLeft.Dispose();
                m_csBmapYLeft = null;
            }
            if (m_csYLeftScalePictureBox.Width > 0 && m_csYLeftScalePictureBox.Height > 0)
            {  // 描画フィールドが有る場合
                m_csBmapYLeft = new Bitmap((int)(m_csYLeftScalePictureBox.Width), (int)(m_csYLeftScalePictureBox.Height));
                Graphics gY = Graphics.FromImage(m_csBmapYLeft); // グラフ描画エリア設定

                double dYLogScaleMax = m_dYLeftScaleMax;
                double dYLogZoom = (m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato;
                double dYLogScaleMin = (dYLogScaleMax - dYLogZoom < 0) ? m_dYLeftScaleMin : dYLogScaleMax - dYLogZoom;
                if (m_bYLeftManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dYHosei = (m_csYLeftScrollBar.Minimum < 0) ? -((double)m_csYLeftScrollBar.Minimum) : 0.0;
                    double dMax = (double)m_csYLeftScrollBar.Maximum - ((double)m_csYLeftScrollBar.Value + dYHosei);
                    if (dMax > (double)m_csYLeftScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csYLeftScrollBar.Maximum;
                    }
                    dYLogScaleMax = dMax;
                    dYLogScaleMin = (dYLogScaleMax - dYLogZoom < m_dYLeftScaleMin) ? m_dYLeftScaleMin :
                                                                                 dYLogScaleMax - dYLogZoom;
                }
                
                // Y軸メモリ描画
                double dOffset = 5.0;
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                // 基準領域情報取得
                double dlYY = 0;
                long lWidth = 0;
                long lHeigh = 0;
                GetGraphAreaInfo(0, ref lWidth, ref lHeigh);
                if (lHeigh > 0)
                {  // 基準グラフ描画エリアが有効な場合
                    dlYY = lHeigh;
                }
                else
                {
                    csFnt.Dispose(); // フォントリソース解放
                    gY.Dispose(); // グラフ描画エリア解放
                    return;
                }
                double dYLogScale = ((dYLogScaleMax - dYLogScaleMin) <= 0.0) ? 1.0 : (dYLogScaleMax - dYLogScaleMin);
                double dllY = dlYY / dYLogScale;

                if ((m_csYLeftScalePictureBox.Height / VERTICAL_MEMORY_STEP) < csFnt.Height)
                {  // 最大描画行数補正が必要な場合
                    for (iStep = 1; iStep <= VERTICAL_MEMORY_STEP; iStep++)
                    {
                        if ((m_csYLeftScalePictureBox.Height / iStep) < csFnt.Height)
                        {  // 最大描画行数補正が必要有る場合
                            break;
                        }
                        else
                        {  // 最大描画行数補正が必要無い場合
                            lStepMax = iStep;
                        }
                    }
                }

                // 描画間隔設定
                long lStep = 0;
                for (iStep = m_dYLeftInterval.GetLength(0) - 1; iStep >= 1; iStep--)
                {
                    lStep = (long)m_dYLeftInterval[iStep];
                    if (Math.Floor(dYLogScale / (double)lStep) >= lStepMax)
                    {  // 商が無い場合
                        if (Math.Floor(dYLogScale / (double)lStep) > lStepMax)
                        {  // ラベル個数が範囲外の場合
                            if (iStep != (m_dYLeftInterval.GetLength(0) - 1))
                            {  // 最終表示間隔以内の場合
                                lStep = (long)m_dYLeftInterval[iStep + 1];
                            }
                        }
                        break;
                    }
                }
                m_csYLeftScrollBar.SmallChange = 1;
                // メモリ、ラベルの描画
                //for (double dY = dYLogScaleMin; dY <= dYLogScaleMax; dY += lStep)
                for (double dY = dYLogScaleMax; dY >= dYLogScaleMin; dY -= (double)lStep)
                {
                    if (m_csYLeftScrollBar.LargeChange <= 0.0)
                    {
                        break;
                    }
                    double dWk2 = (((Math.Floor(dY) - dYLogScaleMax) + dYLogScale) * dllY);
                    double dWk1 = dlYY - dWk2;
                    if (dWk1 >= 0.0 && dWk1 < m_csYLeftScalePictureBox.Height)
                    {
                        gY.DrawLine(new Pen(Color.Black, m_lMemoryWidth), m_csYLeftScalePictureBox.Width - 3,
                                           (float)(dWk1 + dOffset), m_csYLeftScalePictureBox.Width - 0, (float)(dWk1 + dOffset));
                        if (((string)Math.Floor(dY).ToString()).Length >= 7)
                        {  // ７桁を超える場合
                            gY.DrawString(Math.Floor(dY).ToString("0E00"), csFnt, Brushes.Black, 0, (float)(dWk1 - 5 + dOffset));
                        }
                        else
                        {  // ７桁以内の場合
                            gY.DrawString(Math.Floor(dY).ToString(), csFnt, Brushes.Black, 0, (float)(dWk1 - 5 + dOffset));
                        }
                    }
                }
                csFnt.Dispose(); // フォントリソース解放
                gY.Dispose(); // グラフ描画エリア解放
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グラフ右端メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_YRightScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YRightScalePaint()
        {
            int iStep = 0;
            long lStepMax = VERTICAL_MEMORY_STEP;

            if (m_csBmapYRight != null)
            {  // ビットマップ解放要の場合
                m_csBmapYRight.Dispose();
                m_csBmapYRight = null;
            }
            if (m_csYRightScalePictureBox.Width > 0 && m_csYRightScalePictureBox.Height > 0)
            {  // 描画フィールドが有る場合
                m_csBmapYRight = new Bitmap((int)(m_csYRightScalePictureBox.Width), (int)(m_csYRightScalePictureBox.Height));
                Graphics gY = Graphics.FromImage(m_csBmapYRight); // グラフ描画エリア設定

                double dYLogScaleMax = m_dYRightScaleMax;
                double dYLogZoom = (m_dYRightScaleMax - m_dYRightScaleMin) * m_dYRightRato;
                double dYLogScaleMin = (dYLogScaleMax - dYLogZoom < 0) ? m_dYRightScaleMin : dYLogScaleMax - dYLogZoom;
                if (m_bYRightManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dMax = (double)m_csYRightScrollBar.Value + dYLogZoom;
                    if (dMax > (double)m_csYRightScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csYRightScrollBar.Maximum;
                    }
                    dYLogScaleMax = dMax;
                    dYLogScaleMin = (dYLogScaleMax - dYLogZoom < m_dYRightScaleMin) ? m_dYRightScaleMin :
                                                                                 dYLogScaleMax - dYLogZoom;
                }

                // Y軸メモリ描画
                double dOffset = 5.0;
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);
                // 基準領域情報取得
                double dlYY = 0;
                long lWidth = 0;
                long lHeigh = 0;
                GetGraphAreaInfo(0, ref lWidth, ref lHeigh);
                if (lHeigh > 0)
                {  // 基準グラフ描画エリアが有効な場合
                    dlYY = lHeigh;
                }
                else
                {  // 基準グラフ描画エリアが無効な場合
                    csFnt.Dispose(); // フォントリソース解放
                    gY.Dispose(); // グラフ描画エリア解放
                    return;
                }
                double dYLogScale = ((dYLogScaleMax - dYLogScaleMin) <= 0.0) ? 1.0 : (dYLogScaleMax - dYLogScaleMin);
                double dllY = dlYY / dYLogScale;

                if ((m_csYRightScalePictureBox.Height / VERTICAL_MEMORY_STEP) < csFnt.Height)
                {  // 最大描画行数補正が必要な場合
                    for (iStep = 1; iStep <= VERTICAL_MEMORY_STEP; iStep++)
                    {
                        if ((m_csYRightScalePictureBox.Height / iStep) < csFnt.Height)
                        {  // 最大描画行数補正が必要無い場合
                            break;
                        }
                        else
                        {  // 最大描画行数補正が必要無い場合
                            lStepMax = iStep;
                        }
                    }
                }

                // 描画間隔設定
                long lStep = 0;
                for (iStep = m_dYRightInterval.GetLength(0) - 1; iStep >= 1; iStep--)
                {
                    lStep = (long)m_dYRightInterval[iStep];
                    if (Math.Floor(dYLogScale / (double)lStep) >= lStepMax)
                    {  // 商が無い場合
                        if (Math.Floor(dYLogScale / (double)lStep) > lStepMax)
                        {  // ラベル個数が範囲外の場合
                            if (iStep != (m_dYRightInterval.GetLength(0) - 1))
                            {  // 最終表示間隔以内の場合
                                lStep = (long)m_dYRightInterval[iStep + 1];
                            }
                        }
                        break;
                    }
                }
                m_csYRightScrollBar.SmallChange = 1;
                if (m_csYRightScrollBar.Value == 0)
                {  // 表示位置が先頭の場合
                    if (m_dYRightValue > m_csYRightScrollBar.LargeChange)
                    {  // 最大値が表示幅より大きい場合
                        int iChkNum = (int)m_dYRightValue - m_csYRightScrollBar.LargeChange + 1;
                        if (iChkNum >= m_csYRightScrollBar.Minimum && iChkNum <= m_csYRightScrollBar.Maximum)
                        {  // 有効範囲内の場合
                            //m_csYRightScrollBar.Value = iChkNum;
                            m_csYRightScrollBar.PerformLayout();
                        }
                    }
                }
                // メモリ、ラベルの描画
                if (dYLogScaleMin <= 0.0)
                {
                    for (double dY = dYLogScaleMin; dY <= dYLogScaleMax; dY += lStep)
                    {
                        if (m_csYLeftScrollBar.LargeChange <= 0.0)
                        {
                            break;
                        }
                        //double dWk2 = (((Math.Floor(dY) - dYLogScaleMax) + dYLogScale) * dllY);
                        //double dWk1 = dlYY - dWk2;
                        double dWk1 = (((Math.Floor(dY) - dYLogScaleMax) + dYLogScale) * dllY);
                        if (dWk1 >= 0.0 && dWk1 < m_csYRightScalePictureBox.Height)
                        {
                            gY.DrawLine(new Pen(Color.Black, m_lMemoryWidth), 0, (float)(dWk1 + dOffset), 3, (float)(dWk1 + dOffset));
                            if (((string)Math.Floor(dY).ToString()).Length >= 7)
                            {  // ７桁を超える場合
                                gY.DrawString(Math.Floor(dY).ToString("0E00"), csFnt, Brushes.Black, 5, (float)(dWk1 - 5 + dOffset));
                            }
                            else
                            {  // ７桁以内の場合
                                gY.DrawString(Math.Floor(dY).ToString(), csFnt, Brushes.Black, 5, (float)(dWk1 - 5 + dOffset));
                            }
                        }
                    }
                }
                else
                {
                    //for (double dY = dYLogScaleMin; dY <= dYLogScaleMax; dY += lStep)
                    for (double dY = dYLogScaleMax; dY >= dYLogScaleMin; dY -= (double)lStep)
                    {
                        if (m_csYRightScrollBar.LargeChange <= 0.0)
                        {
                            break;
                        }
                        double dWk1 = (((Math.Floor(dY) - dYLogScaleMax) + dYLogScale) * dllY);
                        if (dWk1 >= 0.0 && dWk1 < m_csYRightScalePictureBox.Height)
                        {
                            gY.DrawLine(new Pen(Color.Black, m_lMemoryWidth), 0, (float)(dWk1 + dOffset), 3, (float)(dWk1 + dOffset));
                            if (((string)Math.Floor(dY).ToString()).Length >= 7)
                            {  // ７桁を超える場合
                                gY.DrawString(Math.Floor(dY).ToString("0E00"), csFnt, Brushes.Black, 5, (float)(dWk1 - 5 + dOffset));
                            }
                            else
                            {  // ７桁以内の場合
                                gY.DrawString(Math.Floor(dY).ToString(), csFnt, Brushes.Black, 5, (float)(dWk1 - 5 + dOffset));
                            }
                        }
                    }
                }

                
                csFnt.Dispose(); // フォントリソース解放
                gY.Dispose(); // グラフ描画エリア解放
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左端基準グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_LeftGraphPaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_LeftGraphPaint(object sender, PaintEventArgs e)
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {  // 伝送データ対応情報分繰り返す
                    if (m_csCntlInfo[lP].m_csVarticalType.Equals(VERTICAL_LEFT) == true &&
                        m_csCntlInfo[lP].m_csGraphPictureBox.Equals(sender) == true)
                    {  // 描画エリアが一致した場合
                        ((PictureBox)sender).SizeMode = PictureBoxSizeMode.StretchImage;
                        e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Default; //NearestNeighbor; //.Default; //.Bicubic;
                        Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                        if (m_bDispMode == false && (m_bXManualFlg == true || m_bYLeftManualFlg == true))
                        {  // 表示範囲変更の手動操作が有る場合
                            if (m_csCntlInfo[lP].m_csBmapRange != null)
                            {  // 再描画エリアが有効な場合
                                e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmapRange, dstRect, 0, 0, ((PictureBox)sender).Width + 2
                                                                                     , ((PictureBox)sender).Height, GraphicsUnit.Pixel);
                                return;
                            }
                        }
                        if (m_csCntlInfo[lP].m_csBmap != null)
                        {  // ビットマップが有効な場合
                            // X軸描画範囲設定
                            double dlXX = m_csCntlInfo[lP].m_csBmap.Size.Width;
                            double dXLogScaleMax = m_dXScaleMax;
                            double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                            double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                            if (m_bXManualFlg == true)
                            {  // 表示範囲自動更新の場合
                                double dMax = (double)(m_csXUnderScrollBar.Value + m_csXUnderScrollBar.LargeChange);
                                if (dMax >= (double)m_csXUnderScrollBar.Maximum)
                                {  // 最後尾まで表示範囲の場合
                                    dMax = (double)m_csXUnderScrollBar.Maximum;
                                }
                                if ((dMax - dXLogZoom) < m_csXUnderScrollBar.Minimum)
                                {  // 先頭より過去の場合
                                    dMax = m_csXUnderScrollBar.Minimum + (int)dXLogZoom;
                                }
                                dXLogScaleMax = dMax;
                                dXLogScaleMin = (dXLogScaleMax - dXLogZoom < m_dXScaleMin) ? m_dXScaleMin :
                                                                                             dXLogScaleMax - dXLogZoom;
                            }
                            double dXLogScale = (m_dXScaleMax - m_dXScaleMin <= 0.0) ? 1.0 : m_dXScaleMax - m_dXScaleMin;
                            double dllX = dlXX / dXLogScale;
                            //int iX = (int)((dXLogScaleMin - m_dXScaleMin) * dllX);
                            //int iHX = (int)((dXLogScaleMax - dXLogScaleMin) * dllX);
                            int iX = (int)(((double)m_csXUnderScrollBar.Value / 200.0) * m_csCntlInfo[lP].m_csBmap.Width);
                            int iHX = (int)(((double)m_csXUnderScrollBar.LargeChange / 200.0) * m_csCntlInfo[lP].m_csBmap.Width);

                            // Y軸描画範囲設定
                            double dYLogScaleMax = m_dYLeftScaleMax;
                            double dYLogZoom = (m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato;
                            double dYLogScaleMin = (dYLogScaleMax - dYLogZoom < 0) ? m_dYLeftScaleMin : dYLogScaleMax - dYLogZoom;
                            if (m_bYLeftManualFlg == true)
                            {  // 表示範囲自動更新の場合
                                double dYHosei = (m_csYLeftScrollBar.Minimum < 0) ? -((double)m_csYLeftScrollBar.Minimum) : 0.0;
                                double dMax = (double)m_csYLeftScrollBar.Maximum - ((double)m_csYLeftScrollBar.Value + dYHosei);
                                if (dMax > (double)m_csYLeftScrollBar.Maximum)
                                {  // 最後尾まで表示範囲の場合
                                    dMax = (double)m_csYLeftScrollBar.Maximum;
                                }
                                dYLogScaleMax = dMax;
                                dYLogScaleMin = (dYLogScaleMax - dYLogZoom < m_dYLeftScaleMin) ? m_dYLeftScaleMin :
                                                                                             dYLogScaleMax - dYLogZoom;
                            }
                            double dlYY = m_csCntlInfo[lP].m_csBmap.Size.Height;
                            double dYLogScale = ((m_dYLeftScaleMax - m_dYLeftScaleMin) <= 0.0) ? 1.0 : (m_dYLeftScaleMax - m_dYLeftScaleMin);
                            double dllY = dlYY / dYLogScale;
                            //int iY = (int)((m_dYLeftScaleMax - m_dYLeftValue) * dllY);//[2011/01/23]
                            int iY = (int)(((double)m_csYLeftScrollBar.Value / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            //int iYV = (int)((dYLogScaleMax - dYLogScaleMin) * dllY);
                            int iYV = (int)(((double)m_csYLeftScrollBar.LargeChange / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmap, dstRect, iX, iY, iHX+2, iYV, GraphicsUnit.Pixel);
                        }
                        break;
                    }
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右端基準グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_RightGraphPaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_RightGraphPaint(object sender, PaintEventArgs e)
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {  // 伝送データ対応情報分繰り返す
                    if (m_csCntlInfo[lP].m_csVarticalType.Equals(VERTICAL_RIGHT) == true &&
                        m_csCntlInfo[lP].m_csGraphPictureBox.Equals(sender) == true)
                    {  // 描画エリアが一致した場合
                        ((PictureBox)sender).SizeMode = PictureBoxSizeMode.StretchImage;
                        e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Default; //NearestNeighbor; //.Default; //.Bicubic;
                        Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                        if (m_bDispMode == false && (m_bXManualFlg == true || m_bYRightManualFlg == true))
                        {  // 表示範囲変更の手動操作が有る場合
                            if (m_csCntlInfo[lP].m_csBmapRange != null)
                            {  // 再描画エリアが有効な場合
                                e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmapRange, dstRect, 0, 0, ((PictureBox)sender).Width
                                                                                    , ((PictureBox)sender).Height, GraphicsUnit.Pixel);
                                return;
                            }
                        }
                        if (m_csCntlInfo[lP].m_csBmap != null)
                        {  // ビットマップが有効な場合
                            // X軸描画範囲設定
                            double dlXX = m_csCntlInfo[lP].m_csBmap.Size.Width;
                            double dXLogScaleMax = m_dXScaleMax;
                            double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                            double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                            if (m_bXManualFlg == true)
                            {  // 表示範囲自動更新の場合
                                double dMax = (double)(m_csXUnderScrollBar.Value + m_csXUnderScrollBar.LargeChange);
                                if (dMax >= (double)m_csXUnderScrollBar.Maximum)
                                {  // 最後尾まで表示範囲の場合
                                    dMax = (double)m_csXUnderScrollBar.Maximum;
                                }
                                if ((dMax - dXLogZoom) < m_csXUnderScrollBar.Minimum)
                                {  // 先頭より過去の場合
                                    dMax = m_csXUnderScrollBar.Minimum + (int)dXLogZoom;
                                }
                                dXLogScaleMax = dMax;
                                dXLogScaleMin = (dXLogScaleMax - dXLogZoom < m_dXScaleMin) ? m_dXScaleMin :
                                                                                             dXLogScaleMax - dXLogZoom;
                            }
                            double dXLogScale = (m_dXScaleMax - m_dXScaleMin <= 0.0) ? 1.0 : m_dXScaleMax - m_dXScaleMin;
                            double dllX = dlXX / dXLogScale;
                            //int iX = (int)((dXLogScaleMin - m_dXScaleMin) * dllX);
                            //int iHX = (int)((dXLogScaleMax - dXLogScaleMin) * dllX);
                            int iX = (int)(((double)m_csXUnderScrollBar.Value / 200.0) * m_csCntlInfo[lP].m_csBmap.Width);
                            int iHX = (int)(((double)m_csXUnderScrollBar.LargeChange / 200.0) * m_csCntlInfo[lP].m_csBmap.Width);

                            // Y軸描画範囲設定
                            double dYLogScaleMax = m_dYRightScaleMax;
                            double dYLogZoom = (m_dYRightScaleMax - m_dYRightScaleMin) * m_dYRightRato;
                            double dYLogScaleMin = (dYLogScaleMax - dYLogZoom < 0) ? m_dYRightScaleMin : dYLogScaleMax - dYLogZoom;
                            if (m_bYRightManualFlg == true)
                            {  // 表示範囲自動更新の場合
                                double dMax = (double)(m_csYRightScrollBar.Value + m_csYRightScrollBar.LargeChange);
                                if (dMax >= (double)m_csYRightScrollBar.Maximum)
                                {  // 最後尾まで表示範囲の場合
                                    dMax = (double)m_csYRightScrollBar.Maximum;
                                }
                                dYLogScaleMax = dMax;
                                dYLogScaleMin = (dYLogScaleMax - dYLogZoom < m_dYRightScaleMin) ? m_dYRightScaleMin :
                                                                                             dYLogScaleMax - dYLogZoom;
                            }
                            double dlYY = m_csCntlInfo[lP].m_csBmap.Size.Height;
                            double dYLogScale = ((m_dYRightScaleMax - m_dYRightScaleMin) <= 0.0) ? 1.0 : (m_dYRightScaleMax - m_dYRightScaleMin);
                            double dllY = dlYY / dYLogScale;
                            double dYHosei = (m_csYRightScrollBar.Minimum < 0) ? -(m_csYRightScrollBar.Minimum) : 0.0;
                            //int iY = (int)((m_csYRightScrollBar.Value + dYHosei) * dllY);
                            //int iY = (int)((m_csYRightScrollBar.Value  - m_dYRightScaleMin) * dllY);
                            int iY = (int)(((double)m_csYRightScrollBar.Value / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            //int iYV = (int)(m_csYRightScrollBar.LargeChange * dllY);
                            int iYV = (int)(((double)m_csYRightScrollBar.LargeChange / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            if (m_csYRightScrollBar.LargeChange > m_csYRightScrollBar.Maximum)
                            {
                                //iYV = (int)(m_csYRightScrollBar.Maximum * dllY);
                            }
                            e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmap, dstRect, iX, iY, iHX, iYV, GraphicsUnit.Pixel);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ水平軸再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_XUnderScalePaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_XUnderScalePaint(object sender, PaintEventArgs e)
        {
            if (m_csBmapXUnder != null)
            {  // ビットマップが有効な場合
                e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.NearestNeighbor;
                Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                int iX = 0;
                int iY = 0;
                int iHX = m_csBmapXUnder.Size.Width;
                int iYV = m_csBmapXUnder.Size.Height;
                e.Graphics.DrawImage(m_csBmapXUnder, dstRect, iX, iY, iHX, iYV, GraphicsUnit.Pixel);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸左端再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YLeftScalePaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YLeftScalePaint(object sender, PaintEventArgs e)
        {
            if (m_csBmapYLeft != null)
            {  // ビットマップが有効な場合
                e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.NearestNeighbor;
                Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                int iX = 0;
                int iY = 0;
                int iHX = m_csBmapYLeft.Size.Width;
                int iYV = m_csBmapYLeft.Size.Height;
                e.Graphics.DrawImage(m_csBmapYLeft, dstRect, iX, iY, iHX, iYV, GraphicsUnit.Pixel);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸右端再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YRightScalePaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YRightScalePaint(object sender, PaintEventArgs e)
        {
            if (m_csBmapYRight != null)
            {  // ビットマップが有効な場合
                e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.NearestNeighbor;
                Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                int iX = 0;
                int iY = 0;
                int iHX = m_csBmapYRight.Size.Width;
                int iYV = m_csBmapYRight.Size.Height;
                e.Graphics.DrawImage(m_csBmapYRight, dstRect, iX, iY, iHX, iYV, GraphicsUnit.Pixel);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左端基準グラフサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_LeftGraphResize(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_LeftGraphResize(object sender)
        {
            CalcResultMonitor_YLeftScalePaint(); // Ｙ軸左端メモリ描画
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/24]
            m_csYLeftScalePictureBox.Invalidate();
            CalcResultMonitor_XUnderScalePaint();     // Ｘ軸メモリ描画
            m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/24]
            m_csXUnderScalePictureBox.Invalidate();
            //CalcResultMonitor_RangePaint();//[2011/01/24]
            if (m_dYLeftRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
            {  // 拡大比率が倍率閾値以下の場合
                CalcResultMonitor_RangePaint();
                //m_csDrawMonitor.DrawLeftScopeMonitor(
                m_bDispMode = false;
            }
            else
            {  // 拡大比率が倍率閾値以上の場合
                m_bDispMode = true;
            }
            ((PictureBox)sender).Invalidate();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右端基準グラフサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_RightGraphResize(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_RightGraphResize(object sender)
        {
            CalcResultMonitor_YRightScalePaint(); // Ｙ軸右端メモリ描画
            m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
            m_csYRightScalePictureBox.Invalidate();
            if (m_dYRightRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
            {  // 拡大比率が倍率閾値以下の場合
                CalcResultMonitor_RangePaint();
                m_bDispMode = false;
            }
            else
            {  // 拡大比率が倍率閾値以上の場合
                m_bDispMode = true;
            }
            ((PictureBox)sender).Invalidate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>水平スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_XUndeScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_XUndeScroll(object sender)
        {
            if (((HScrollBar)sender).Value != (int)m_dXValue)
            {  // 表示上限の変更がある場合
                m_dXValue = (double)((HScrollBar)sender).Value;
                CalcResultMonitor_XUnderScalePaint();//[2011/01/25]
                m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/25]
                m_csXUnderScalePictureBox.Invalidate();
                if (m_dYLeftRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
                GraphInvalidate(VERTICAL_LEFT);  // 垂直左端基準描画領域更新
                GraphInvalidate(VERTICAL_RIGHT); // 垂直右端基準描画領域更新
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直左端スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YLeftScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YLeftScroll(object sender)
        {
            long lValue = 0;

            double dYHosei = (((VScrollBar)sender).Minimum < 0) ? -((double)((VScrollBar)sender).Minimum) : 0.0;
            double dMax = (double)((VScrollBar)sender).Maximum - ((double)((VScrollBar)sender).Value + dYHosei);
            if (dMax > (double)((VScrollBar)sender).Maximum)
            {  // 最後尾まで表示範囲の場合
                dMax = (double)((VScrollBar)sender).Maximum;
            }
            lValue = (long)dMax;
            if (lValue != (int)m_dYLeftValue)
            {  // 表示上限の変更がある場合
                if (lValue >= ((VScrollBar)sender).Minimum && lValue <= ((VScrollBar)sender).Maximum)
                {  // 有効範囲内の場合
                    m_dYLeftValue = (double)lValue;
                }
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/24]
                //CalcResultMonitor_YLeftScalePaint();//[2010/01/24]消去
                
                m_csYLeftScalePictureBox.Invalidate();
                GraphInvalidate(VERTICAL_LEFT);
                if (m_dYLeftRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直右端スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YRightScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YRightScroll(object sender)
        {
            long lValue = ((VScrollBar)sender).Value;

            if (((VScrollBar)sender).Value != 0)
            {  // 先頭の場合
                lValue = ((((VScrollBar)sender).Value + ((VScrollBar)sender).LargeChange - 1) > ((VScrollBar)sender).Maximum) ?
                           ((VScrollBar)sender).Maximum : (((VScrollBar)sender).Value + ((VScrollBar)sender).LargeChange - 1);
                //CalcResultMonitor_YRightZoomBarScroll(sender);
            }
            else
            {  // 先頭以降の場合
                //if (((VScrollBar)sender).Maximum <= ((VScrollBar)sender).LargeChange)
                //{  // 最大値を越える表示幅の場合
                //    lValue = ((VScrollBar)sender).Maximum;
                //}
                //else
                //{  // 最大値を以内の表示幅の場合
                //    lValue = ((VScrollBar)sender).LargeChange;
                //}
                lValue = ((VScrollBar)sender).Value;
            }
            if (lValue != (int)m_dYRightValue)
            {  // 表示上限の変更がある場合
                if (lValue >= ((VScrollBar)sender).Minimum && lValue <= ((VScrollBar)sender).Maximum)
                {  // 有効範囲内の場合
                    m_dYRightValue = (double)lValue;
                }
                //CalcResultMonitor_YRightScalePaint();
                m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
                m_csYRightScalePictureBox.Invalidate();
                GraphInvalidate(VERTICAL_RIGHT);
                if (m_dYRightRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    //CalcResultMonitor_RangePaint();[2011/01/29]
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }

            }
                CalcResultMonitor_RangePaint();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＸ軸拡大・縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_XUnderZoomBarScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_XUnderZoomBarScroll(object sender)
        {
            if (m_csXZoomLabel.Text.Equals(((TrackBar)sender).Value.ToString()) == false)
            {  // 異なる倍率の場合
                m_csXZoomLabel.Text = ((TrackBar)sender).Value.ToString();
                m_dXRato = ((double)((TrackBar)sender).Value) / 100.0;
                if (m_dXRato == 1.0)
                {  // 全表示の場合
                    //m_csXUnderScrollBar.LargeChange = m_csXUnderScrollBar.Maximum - m_csXUnderScrollBar.Minimum;
                    m_csXUnderScrollBar.LargeChange = ((int)((TrackBar)sender).Value) * 2;//[2011/01/25]
                    m_csXUnderScrollBar.Value = m_csXUnderScrollBar.Minimum;
                    m_dXValue = (double)m_csXUnderScrollBar.Value;
                    m_csXUnderScrollBar.PerformLayout();
                    m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/24]
                    m_csXUnderScalePictureBox.Invalidate();
                    m_bXManualFlg = false;
                }
                else
                {  // 部分表示の場合
                    double dXZoom = ((m_csXUnderScrollBar.Maximum - m_csXUnderScrollBar.Minimum) * m_dXRato) <= 1.0 ?
                                1.0: (m_csXUnderScrollBar.Maximum - m_csXUnderScrollBar.Minimum) * m_dXRato;
                    if (m_csXUnderScrollBar.LargeChange != (int)dXZoom)
                    {  // 再描画が必要な場合
                        //m_csXUnderScrollBar.LargeChange = (int)dXZoom;
                        m_csXUnderScrollBar.LargeChange = ((int)((TrackBar)sender).Value) * 2;//[2011/01/25]
                        m_csXUnderScrollBar.Value = ((m_csXUnderScrollBar.Value + (int)dXZoom) > m_csXUnderScrollBar.Maximum) ?
                                     m_csXUnderScrollBar.Maximum - (int)dXZoom + 1 : m_csXUnderScrollBar.Value;
                        m_csXUnderScrollBar.PerformLayout();
                        m_dXValue = (double)m_csXUnderScrollBar.Value;
                        m_bXManualFlg = true;
                        CalcResultMonitor_XUnderScalePaint();//2011/01/25]
                        m_csDrawMonitor.DrawXScale(ref m_csBmapXUnder, m_csXUnderScalePictureBox);//[2011/01/24]
                        m_csXUnderScalePictureBox.Invalidate();
                    }
                }
                if (m_dYLeftRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ垂直左端軸拡大・縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YLeftZoomBarScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YLeftZoomBarScroll(object sender)
        {
            if (m_csYLeftZoomLabel.Text.Equals(((TrackBar)sender).Value.ToString()) == false)
            {  // 異なる倍率の場合
                m_csYLeftZoomLabel.Text = ((TrackBar)sender).Value.ToString();
                m_dYLeftRato = ((double)((TrackBar)sender).Value) / 100.0;
                if (m_dYLeftRato == 1.0)
                {  // 全表示の場合
                    m_csYLeftScrollBar.Value = m_csYLeftScrollBar.Minimum;
                    m_csYLeftScrollBar.PerformLayout();
                    //m_csYLeftScrollBar.LargeChange = (m_csYLeftScrollBar.Maximum - m_csYLeftScrollBar.Minimum) + 1;
                    m_csYLeftScrollBar.LargeChange = ((int)((TrackBar)sender).Value) * 2;//[2011/01/23]

                    m_dYLeftValue = m_csYLeftScrollBar.Maximum;
                    m_bYLeftManualFlg = false;
                }
                else
                {  // 部分表示の場合
                    double dYLeftZoom = ((m_csYLeftScrollBar.Maximum - m_csYLeftScrollBar.Minimum) * m_dYLeftRato) <= 1.0 ?
                                   1.0 : ((m_csYLeftScrollBar.Maximum - m_csYLeftScrollBar.Minimum) * m_dYLeftRato) + 1;
                    if (m_csYLeftScrollBar.LargeChange != (int)dYLeftZoom)
                    {  // 再描画が必要な場合
                        if (m_csYLeftScrollBar.LargeChange < (int)dYLeftZoom)
                        {  // 可視範囲を拡げる場合
                            if (m_csYLeftScrollBar.Value != m_csYLeftScrollBar.Maximum)
                            {  // 最小値以外の場合
                                int iSa = (int)dYLeftZoom - m_csYLeftScrollBar.LargeChange;
                                int iChkNum = ((m_csYLeftScrollBar.Value - iSa) > 0)?
                                    m_csYLeftScrollBar.Value - iSa : m_csYLeftScrollBar.Minimum; // 差分移動させる
                                if (iChkNum >= m_csYLeftScrollBar.Minimum && iChkNum <= m_csYLeftScrollBar.Maximum)
                                {  // 有効範囲内の場合
                                    m_csYLeftScrollBar.Value = iChkNum;
                                    m_csYLeftScrollBar.PerformLayout();
                                }
                            }
                        }
                        //m_csYLeftScrollBar.LargeChange = (int)dYLeftZoom;[2011/01/23]
                        m_csYLeftScrollBar.LargeChange = (int)((TrackBar)sender).Value * 2;//[2011/01/23]
                        m_bYLeftManualFlg = true;
                    }
                }
                //CalcResultMonitor_YLeftScalePaint();//[2011/01/24]
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);
                m_csYLeftScalePictureBox.Invalidate();
                if (m_dYLeftRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ垂直右端軸拡大・縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YRightZoomBarScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_YRightZoomBarScroll(object sender)
        {
            if (m_csYRightZoomLabel.Text.Equals(((TrackBar)sender).Value.ToString()) == false)
            {  // 異なる倍率の場合
                m_csYRightZoomLabel.Text = ((TrackBar)sender).Value.ToString();
                m_dYRightRato = ((double)((TrackBar)sender).Value) / 100.0;
                if (m_dYRightRato == 1.0)
                {  // 全表示の場合
                    m_csYRightScrollBar.Value = m_csYRightScrollBar.Minimum;
                    m_csYRightScrollBar.PerformLayout();
                    //m_csYRightScrollBar.LargeChange = (m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) + 1;
                    m_csYRightScrollBar.LargeChange = ((TrackBar)sender).Value * 2;
                    m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
                    m_dYRightValue = (double)m_csYRightScrollBar.Value;
                    m_bYRightManualFlg = false;
                }
                else
                {  // 部分表示の場合
                    double dYRightZoom = ((m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) * m_dYRightRato) <= 1.0 ?
                                    1.0 : ((m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) * m_dYRightRato) + 1;
                    //double dYRightZoom = ((m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) * m_dYRightRato) <= 2.0 ?
                    //                2.0 : ((m_csYRightScrollBar.Maximum - m_csYRightScrollBar.Minimum) * m_dYRightRato) + 1;
                    //if (m_csYRightScrollBar.LargeChange != (int)dYRightZoom)
                    {  // 再描画が必要な場合
                        //m_csYRightScrollBar.LargeChange = (int)dYRightZoom;
                        m_csYRightScrollBar.LargeChange = ((TrackBar)sender).Value * 2;
                        int iChkNum = ((m_csYRightScrollBar.Value + (int)dYRightZoom) > m_csYRightScrollBar.Maximum) ?
                                     m_csYRightScrollBar.Maximum - (int)dYRightZoom + 1 : m_csYRightScrollBar.Value;
                        if (iChkNum >= m_csYRightScrollBar.Minimum && iChkNum <= m_csYRightScrollBar.Maximum)
                        {  // 有効範囲内の場合
                            //m_csYRightScrollBar.Value = iChkNum;
                            m_csYRightScrollBar.PerformLayout();
                            m_dYRightValue = (double)m_csYRightScrollBar.Value;
                            CalcResultMonitor_YRightScalePaint();
                            m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/24]
                            CalcResultMonitor_RangePaint();
                        }
                        m_bYRightManualFlg = true;
                    }
                }
                //CalcResultMonitor_YRightScalePaint();
                //m_csYRightScalePictureBox.Invalidate();
                if (m_dYRightRato <= m_dGraphYRatoMax || m_dXRato <= m_dGraphXRatoMax)
                {  // 拡大比率が倍率閾値以下の場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
                m_csYRightScalePictureBox.Invalidate();
            }
            //CalcResultMonitor_YRightScalePaint();
            //CalcResultMonitor_RangePaint();

        }

        //----------------------------
        // フォーム定義関連
        //----------------------------
        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_OnIdle()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CalcResultMonitor_OnIdle()
        {
            if (m_bDispMode == true)
            {
                m_bDispMode = false;
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
                else
                {  // 全領域描画の場合
                    GraphDataInit();
                    CalcResultMonitor_Paint();
                }
                // 垂直左端基準描画領域更新
                GraphInvalidate(VERTICAL_LEFT);
                // 垂直右端基準描画領域更新
                GraphInvalidate(VERTICAL_RIGHT);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンポーネントの初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InitializeComponent()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(HySDotNetMoniterBaseForm));
            this.SuspendLayout();
            // 
            // HySDotNetMoniterBaseForm
            // 
            this.AccessibleDescription = null;
            this.AccessibleName = null;
            resources.ApplyResources(this, "$this");
            this.BackgroundImage = null;
            this.Icon = null;
            this.Name = "HySDotNetMoniterBaseForm";
            this.ResumeLayout(false);

        }


        //----------------------------
        // マルチ伝送データ関連
        //----------------------------
        /// <summary><para>class outline:</para>
        /// <para>伝送データマルチ対応構成クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
        /// </remarks>
        public class CntlInfo
        {
            /// <summary>グラフ描画エリア</summary>
            public PictureBox m_csGraphPictureBox = null;
            /// <summary>グラフビットマップ情報</summary>
            public Bitmap m_csBmap = null;
            /// <summary>グラフ操作用ビットマップ情報</summary>
            public Bitmap m_csBmapRange = null;
            /// <summary>テーブル一覧リスト</summary>
            public DataGridView m_csDataGridView = null;
            /// <summary>データテーブル（テーブル表示用マスタ）</summary>
            public List<string[]> m_csDataTable = null;
            /// <summary>伝送データグラフ基準位置</summary>
            public HySObjectKind m_csVarticalType = null;
            /// <summary>前回データ件数</summary>
            public long m_lDataCnt = -1;
            /// <summary>前回描画データ件数</summary>
            public long m_lPointCnt = -1;
            /// <summary>描画先頭位置</summary>
            public long m_lTopPoint = -1;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となる情報エリアの生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateCntlInfo(lArrayNum)</para>
        /// </example>
        /// <param name="lArrayNum">対応する伝送データ件数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>先頭の１件目には、必ずベースとなる描画領域の情報を設定すること</para>
        /// </remarks>
        public void CreateCntlInfo(long lArrayNum)
        {
            if (lArrayNum > 0)
            {  // 伝送データ件数が有る場合
                m_csCntlInfo = new CntlInfo[lArrayNum];
                for (long lP = 0; lP < lArrayNum; lP++)
                {
                    m_csCntlInfo[lP] = new CntlInfo();
                    m_csCntlInfo[lP].m_csDataTable = new List<string[]>();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるグラフ情報の設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetGraphInstance(lArrayNum,csGraph)</para>
        /// </example>
        /// <param name="lArrayNum">対応する伝送データ配列番号（０相対）</param>
        /// <param name="csGraph">対応する描画エリアインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetGraphInstance(long lArrayNum, PictureBox csGraph)
        {
            if (lArrayNum >= 0)
            {  // 伝送データ配列番号が有る場合
                if (m_csCntlInfo != null)
                {  // 伝送データマルチ対応構成が有効な場合
                    if (lArrayNum < m_csCntlInfo.GetLength(0))
                    {  // 伝送データ配列番号が範囲内の場合
                        m_csCntlInfo[lArrayNum].m_csGraphPictureBox = csGraph;
                        m_csCntlInfo[lArrayNum].m_csVarticalType = VERTICAL_LEFT;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となる管理情報を全て初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllDataInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AllDataInit()
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csBmap is Bitmap)
                    {  // エリアが有効な場合
                        m_csCntlInfo[lP].m_csBmap.Dispose();
                    }
                    m_csCntlInfo[lP].m_csBmap = null;
                    if (m_csCntlInfo[lP].m_csBmapRange is Bitmap)
                    {  // エリアが有効な場合
                        m_csCntlInfo[lP].m_csBmapRange.Dispose();
                    }
                    m_csCntlInfo[lP].m_csBmapRange = null;
                    m_csCntlInfo[lP].m_lPointCnt = -1;
                    m_csCntlInfo[lP].m_lTopPoint = -1;
                    if (m_csCntlInfo[lP].m_csDataTable is List<string[]>)
                    {  // エリアが有効な場合
                        m_csCntlInfo[lP].m_csDataTable.Clear();
                    }
                    m_csCntlInfo[lP].m_csDataTable = null;
                }
                m_csCntlInfo = null;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるグラフ情報初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphDataInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GraphDataInit()
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csBmap is Bitmap)
                    {  // エリアが有効な場合
                        m_csCntlInfo[lP].m_csBmap.Dispose();
                    }
                    m_csCntlInfo[lP].m_csBmap = null;
                    if (m_csCntlInfo[lP].m_csBmapRange is Bitmap)
                    {  // エリアが有効な場合
                        m_csCntlInfo[lP].m_csBmapRange.Dispose();
                    }
                    m_csCntlInfo[lP].m_csBmapRange = null;
                    m_csCntlInfo[lP].m_lPointCnt = -1;
                    m_csCntlInfo[lP].m_lTopPoint = -1;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるグラフ情報初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphDataInit(csType)</para>
        /// </example>
        /// <param name="csType">垂直基準値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GraphDataInit(HySObjectKind csType)
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csVarticalType.Equals(csType) == true)
                    {  // 描画基準が一致した場合
                        if (m_csCntlInfo[lP].m_csBmap is Bitmap)
                        {  // エリアが有効な場合
                            m_csCntlInfo[lP].m_csBmap.Dispose();
                        }
                        m_csCntlInfo[lP].m_csBmap = null;
                        if (m_csCntlInfo[lP].m_csBmapRange is Bitmap)
                        {  // エリアが有効な場合
                            m_csCntlInfo[lP].m_csBmapRange.Dispose();
                        }
                        m_csCntlInfo[lP].m_csBmapRange = null;
                        m_csCntlInfo[lP].m_lPointCnt = -1;
                        m_csCntlInfo[lP].m_lTopPoint = -1;
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるグラフ描画更新</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphInvalidate(csType)</para>
        /// </example>
        /// <param name="csType">垂直基準値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GraphInvalidate(HySObjectKind csType)
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {
                    if (m_csCntlInfo[lP].m_csVarticalType.Equals(csType) == true)
                    {  // 描画基準が一致した場合
                        if (m_csCntlInfo[lP].m_csGraphPictureBox is PictureBox)
                        {  // 描画エリア有効な場合
                            m_csCntlInfo[lP].m_csGraphPictureBox.Invalidate();
                        }
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるグラフの領域情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetGraphAreaInfo(lArrayNum,ref lWidth, ref lHeigh)</para>
        /// </example>
        /// <param name="lArrayNum">対応する伝送データ配列番号（０相対）</param>
        /// <param name="lWidth">描画領域の幅</param>
        /// <param name="lHeigh">描画領域の高さ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>基準の描画領域の場合は先頭（０相対）を指定すること</para>
        /// </remarks>
        public void GetGraphAreaInfo(long lArrayNum, ref long lWidth, ref long lHeigh)
        {
            if (lArrayNum >= 0)
            {  // 伝送データ配列番号が有る場合
                if (m_csCntlInfo != null)
                {  // 伝送データマルチ対応構成が有効な場合
                    if (lArrayNum < m_csCntlInfo.GetLength(0))
                    {  // 伝送データ配列番号が範囲内の場合
                        if (m_csCntlInfo[lArrayNum].m_csGraphPictureBox is PictureBox)
                        {  // 描画エリア有効な場合
                            lWidth = m_csCntlInfo[lArrayNum].m_csGraphPictureBox.Width;
                            lHeigh = m_csCntlInfo[lArrayNum].m_csGraphPictureBox.Height;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となる垂直軸基準値設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetVarticalType(lArrayNum,csType)</para>
        /// </example>
        /// <param name="lArrayNum">対応する伝送データ配列番号（０相対）</param>
        /// <param name="csType">対応する伝送データ垂直軸基準値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetVarticalType(long lArrayNum, HySObjectKind csType)
        {
            if (lArrayNum >= 0)
            {  // 伝送データ配列番号が有る場合
                if (m_csCntlInfo != null)
                {  // 伝送データマルチ対応構成が有効な場合
                    if (lArrayNum < m_csCntlInfo.GetLength(0))
                    {  // 伝送データ配列番号が範囲内の場合
                        m_csCntlInfo[lArrayNum].m_csVarticalType = csType;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データと対となるテーブル情報の設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetTableInstance(lArrayNum,csDataGridView)</para>
        /// </example>
        /// <param name="lArrayNum">対応する伝送データ配列番号（０相対）</param>
        /// <param name="csDataGridView">対応するテーブル一覧インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTableInstance(long lArrayNum, DataGridView csDataGridView)
        {
            if (lArrayNum >= 0)
            {  // 伝送データ配列番号が有る場合
                if (m_csCntlInfo != null)
                {  // 伝送データマルチ対応構成が有効な場合
                    if (lArrayNum < m_csCntlInfo.GetLength(0))
                    {  // 伝送データ配列番号が範囲内の場合
                        m_csCntlInfo[lArrayNum].m_csDataGridView = csDataGridView;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent()
        {

        }

    }
}