﻿// <summary>ソースコード：計算結果モニタ画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>計算結果モニタ画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetMoniterForm : HySDotNetMoniterBaseForm
    {
        /// <summary>水平軸最大値(基準値)</summary>
        protected static readonly double XSCALEMAXCONST = 86400.0;
        /// <summary>垂直左端軸最小値(基準値)</summary>
        protected static readonly double YLEFTSCALEMINCONST = 0.0;
        /// <summary>垂直左端軸最大値(基準値)</summary>
        protected static readonly double YLEFTSCALEMAXCONST = 1000.0;

        /// <summary>水平表示間隔</summary>
        protected static readonly double[] XINTERVAL_BASE = { 0     , 60     , 300     , 600  , 1800 ,
                                                              3600  , 10800  , 21600   , 43200, 86400,
                                                              604800, 2678400, 31536000 
                                                            };

        /// <summary>垂直表示間隔</summary>
        protected static readonly double[] YINTERVAL_BASE = { 0   , 1   , 5    , 10   , 25    ,
                                                              50  , 100 , 250  , 500  , 1000  ,
                                                              2500, 5000, 10000, 25000, 500000,
                                                           1000000,     2500000,       5000000,
                                                          10000000,    25000000,      50000000,
                                                         100000000,   250000000,     500000000
                                                            };

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySMoniterFormIF csDotNetMoniterForm = new HySDotNetMoniterForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetMoniterForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetMoniterForm()
        {
            // コンポーネント初期化
            InitializeComponent();
            // 伝送データ任意入力対応設定
            CreateCntlInfo(1);
            // 伝送データ任意入力対応グラフ描画エリアインスタンスの設定
            SetGraphInstance(0, this.GraphPictureBox);
            // 伝送データ任意入力対応テーブル表示エリアインスタンスの設定
            SetTableInstance(0, this.LineTableDataGridView);
            // 基本部品－水平軸の表示間隔設定
            DateTime csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
            string sWk = DateTime.Now.ToString("yyyy/MM/dd") + " 0:0:0";
            TimeSpan csTS = DateTime.Parse(sWk) - csDTBase;
            double dXScaleMin_Mst = (double)csTS.TotalSeconds;
            double dXScaleMax_Mst = dXScaleMin_Mst + XSCALEMAXCONST;
            SetXUnderStandardInformation(dXScaleMin_Mst, dXScaleMax_Mst, XINTERVAL_BASE);
            // 基本部品－垂直軸の表示間隔設定
            SetYLeftStandardInformation(YLEFTSCALEMINCONST, YLEFTSCALEMAXCONST, YINTERVAL_BASE);
            // 基本部品－タイマーインスタンスの設定
            SetFormTimerInstance(this.DspTimer);
            SetTimerEnable(false); // タイマー停止
            // 基本部品－スケール描画領域インスタンスの設定
            SetFormGraphScaleInstance(this.XScalePictureBox,this.YScalePictureBox);
            // 基本部品－更新時抑止ボタンインスタンスの設定
            SetFormControlInstance(this.TableChange);
            SetFormControlInstance(this.ButtonClose_Graph);
            SetFormControlInstance(this.GraphChange);
            SetFormControlInstance(this.ButtonClose_Table);
            SetFormControlInstance(this.XHScrollBar);
            SetFormControlInstance(this.YVScrollBar);
            SetFormControlInstance(this.XZoomBar);
            SetFormControlInstance(this.YLeftZoomBar);
            // 基本部品－スクロースバーインスタンスの設定
            SetFormScrollBarInstance(this.XHScrollBar, this.YVScrollBar);
            // 基本部品－水平軸拡大部品インスタンスの設定
            SetFormTrackBarInstance(this.XZoomBar, this.XScale_Label, this.YLeftZoomBar, this.YLeftScale_Label);
            // 描画パネル＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = false;
            // 左端位置設定
            this.Panel_Graph.Top = 1;
            this.Panel_Graph.Left = 1;
            this.Panel_Table.Top = 1;
            this.Panel_Table.Left = 1;
            // セル範囲ラベル表示
            CellTopLabel.Text = CellSelectTrackBar.Minimum.ToString();
            CellLastLabel.Text = CellSelectTrackBar.Maximum.ToString();

            m_csDrawMonitor = new HySDotNetDrawMonitor();
            m_csDrawMonitor.SetLeftScaleMemory(VERTICAL_MEMORY_STEP);
            m_csDrawMonitor.SetLeftScrollBar(m_csYLeftScrollBar);
            m_csDrawMonitor.SetXScrollBar(m_csXUnderScrollBar);
            m_csDrawMonitor.SetLeftInterval(YINTERVAL_BASE);
            m_csDrawMonitor.SetXInterval(XINTERVAL_BASE);
            m_csDrawMonitor.SetLeftControl(YLeftScaleCheckBox, YLeftScaleNumericUpDown,
                                           YLeftMinScaleCheckBox, YLeftMinScaleNumericUpDown, YLeftZoomBar);
            m_csDrawMonitor.SetXControl(XZoomBar);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetMoniterForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterForm_Load(object sender, EventArgs e)
        {
            SetDoubleBuffer(); // ダブルバッファー設定
            // 描画パネルの可視化＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = true;
            DspTimer_Call(null, null); // 初回のスケール描画
            Application.Idle += new EventHandler(OnIdle);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイマー再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DspTimer_Call(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DspTimer_Call(object sender, EventArgs e)
        {
            if (m_bActive == true)
            {  // 画面が可視状態の場合
                if (ResetDemandCheck() == true)
                {  // リセット要求が有る場合
                    SetControlEnable(false); // 操作系抑止
                    GraphAllReset();         // グラフ初期化
                    TableAllReset();         // テーブル一覧初期化
                    SetControlEnable(true);  // 操作系抑止解除
                }
                try
                {
                    if (this.Panel_Graph.Visible)
                    {  // グラフ表示の場合
                        GraphDisp_Paint();
                    }
                    else
                    {  // テーブル表示の場合
                        TableDataGridView_Paint();
                    }
                }
                catch
                {
                    DspTimer.Enabled = true; // タイマー再開
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            ((HySMoniterScreen)m_csScreen).CloseScreen(m_csID);
            this.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面インスタンス複製処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySViewFormBaseIF csForm = Clon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySMoniterFormIF 複写した画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySViewFormBaseIF Clone()
        {
            return new HySDotNetMoniterForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_Paint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_Paint(); // 伝送データ数分グラフ描画
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_RangePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_RangePaint()
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示の場合
                CalcResultMonitor_RangePaint(); // 伝送データ数分テーブル一覧描画
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＸ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_XScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_XScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＹ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_YScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_YScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>テーブル再表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TableDataGridView_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_Paint()
        {
            if (this.Panel_Table.Visible)
            {  // テーブル表示の場合
                CalcResultMonitor_TablePaint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面切替処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispChange_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispChange_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // テーブル表示切替の場合
                this.Panel_Graph.Visible = false;
                this.Panel_Table.Visible = true;
                TableDataGridView_Paint();
            }
            else
            {  // グラフ表示切替の場合
                this.Panel_Table.Visible = false;
                this.Panel_Graph.Visible = true;
                GraphDisp_Paint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>仮想モードセル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TableDataGridView_CellValueNeeded(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
        {
            CalcResultMonitor_SetTableCellValue(sender,e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphPictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphPictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_LeftGraphPaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMoniterForm_Resize(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterForm_Resize(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_LeftGraphResize(this.GraphPictureBox);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>水平スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUndeScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＸ軸拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderZoomBarScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftZoomBarScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnIdle(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnIdle(object sender, EventArgs e)
        {
            CalcResultMonitor_OnIdle();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル範囲トラックバー操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CellSelectTrackBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CellSelectTrackBar_Scroll(object sender, EventArgs e)
        {
            if (CellSelectTrackBar.Value != CellSelectNumericUpDown.Value)
            {  // セル値の変更が有った場合
                m_lCellSelectNum = CellSelectTrackBar.Value;
                CellSelectNumericUpDown.Value = CellSelectTrackBar.Value;
                GraphDataInit(VERTICAL_LEFT);
                GraphDisp_Paint();
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル範囲ピッカー操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CellSelectNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CellSelectNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (CellSelectTrackBar.Value != CellSelectNumericUpDown.Value)
            {  // セル値の変更が有った場合
                m_lCellSelectNum = (long)CellSelectNumericUpDown.Value;
                CellSelectTrackBar.Value = (int)CellSelectNumericUpDown.Value;
                GraphDataInit(VERTICAL_LEFT);
                GraphDisp_Paint();
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸表示最大設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YLeftScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            // Y軸表示最大設定チェックON/OFF
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最大設定有効の場合
                //if (this.YVScrollBar.Minimum > (int)YLeftScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                    //YLeftScaleNumericUpDown.Value = this.YVScrollBar.Maximum;
                    
                //}
                if (m_csDrawMonitor.GetLeftSetMin() >= (int)YLeftScaleNumericUpDown.Value)
                {
                    YLeftScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
                }
                m_dYLeftScaleCheck = true;
                m_dYLeftScaleMaxNumber = double.Parse(YLeftScaleNumericUpDown.Value.ToString());
                YLeftScaleNumericUpDown.Enabled = true; // Y軸表示最大設定エリア活性化
            }
            else
            {  // Y軸表示最大設定無効の場合
                YLeftScaleNumericUpDown.Enabled = false; // Y軸表示最大設定エリア非活性化
                m_dYLeftScaleCheck = false; // Y軸表示最大設定無しを設定
            }
            // 再描画
            m_csDrawMonitor.SetLeftMaxCheck(m_dYLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            CalcResultMonitor_Paint();
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
            GraphInvalidate(VERTICAL_LEFT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最大設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYLeftScaleMaxNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最大値に変更が有る場合
                //if (this.YVScrollBar.Minimum >= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                    //((NumericUpDown)sender).Value = this.YVScrollBar.Minimum + 1;
                //}
                if (m_csDrawMonitor.GetLeftSetMin() >= (int)((NumericUpDown)sender).Value)
                {
                    ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
                }
                m_dYLeftScaleMaxNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                // 再描画
                m_bYLeftManualFlg = false;
                //this.YVScrollBar.Value = this.YVScrollBar.Minimum;
                YVScrollBar.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYLeftRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYLeftManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YLeftScalePaint();
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
                GraphInvalidate(VERTICAL_LEFT);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0014,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
            else
            {  // テーブル表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0015,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetMoniterForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterForm_Activated(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }

        //----------------------------
        // 共通スタブの書き換え関連
        //----------------------------

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ対応の垂直軸基準値更新</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>VarticalTypeUpdate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void VarticalTypeUpdate()
        {
            m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
            if (m_csInstanceCommon is HySDispInstanceCommon)
            {  // 演算結果情報が有る場合
                long lArrayNum = m_csInstanceCommon.GetDataLinkedListArray().GetLength(0);
                if (lArrayNum > 0)
                {  // 項目データが有る場合
                    for (long lP = 0; lP < lArrayNum; lP++)
                    {
                        HySDataLinkedList csListArray = (m_csInstanceCommon.GetDataLinkedListArray())[lP] as HySDataLinkedList;
                        HySID csReceiveID = new HySID("");
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySID)
                            {  // 伝送データの受信パターンＩＤの場合
                                csReceiveID = csListArray.GetData(lP1) as HySID;
                                break;
                            }
                        }
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySDataCharacteristicInCell)
                            {  // 伝送プロパティの項目情報の場合
                                HySDataCharacteristicInCell csInputKind = csListArray.GetData(lP1) as HySDataCharacteristicInCell;
                                // 伝送データ任意入力対応グラフ描画エリアインスタンスの設定
                                SetGraphInstance(lP, this.GraphPictureBox);
                                // 伝送データ任意入力対応テーブル表示エリアインスタンスの設定
                                SetTableInstance(lP, this.LineTableDataGridView);
                                SetVarticalType(lP, VERTICAL_LEFT);
                                break;
                            }
                        }
                        long lCellDim = 1;
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySString)
                            {  // セル配列数の場合
                                try
                                {
                                    lCellDim = long.Parse(((HySString)csListArray.GetData(lP1)).ToString());
                                }
                                catch
                                {
                                    lCellDim = 1;
                                }
                                break;
                            }
                        }
                        if (csReceiveID.Equals(HySMoniterScreen.LINE_GRAPH_D1_CELL_SERIAL) == true ||
                            csReceiveID.Equals(HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_ANY) == true ||
                            csReceiveID.Equals(HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_SERIAL) == true)
                        {  // セルの有る伝送データの場合
                            if (m_lCellSelectNum <= lCellDim)
                            {  // 現状のセル番号が範囲内の場合
                                CellSelectTrackBar.Maximum = (int)lCellDim;
                                CellSelectNumericUpDown.Maximum = lCellDim;
                            }
                            else
                            {  // 現状のセル番号が範囲外の場合
                                m_lCellSelectNum = 1;
                                CellSelectTrackBar.Value = 1;
                                CellSelectNumericUpDown.Value = 1;
                                CellSelectTrackBar.Maximum = (int)lCellDim;
                                CellSelectNumericUpDown.Maximum = lCellDim;
                            }
                            // セル範囲ラベル表示
                            CellTopLabel.Text = CellSelectTrackBar.Minimum.ToString();
                            CellLastLabel.Text = CellSelectTrackBar.Maximum.ToString();
                        }
                    }
                }
            }
        }

        //最小値チェックボックスクリック
        /// <summary><para>method outline</para>
        /// <para>Y軸表示最小設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YLeftScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            // Y軸表示最大設定チェックON/OFF
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最大設定有効の場合
                //if (this.YVScrollBar.Maximum < (int)YLeftMinScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YLeftMinScaleNumericUpDown.Value = this.YVScrollBar.Minimum;
                //}
                if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)YLeftMinScaleNumericUpDown.Value)
                {
                    YLeftMinScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;//[2011/01/25]
                }
                m_dYMinLeftScaleCheck = true;//[2011/01/17]
                m_dYLeftScaleMinNumber = double.Parse(YLeftMinScaleNumericUpDown.Value.ToString());
                YLeftMinScaleNumericUpDown.Enabled = true; // Y軸表示最大設定エリア活性化
            }
            else
            {  // Y軸表示最大設定無効の場合
                YLeftMinScaleNumericUpDown.Enabled = false; // Y軸表示最大設定エリア非活性化
                m_dYMinLeftScaleCheck = false; // Y軸表示最大設定無しを設定[2011/01/17]
            }
            // 再描画
            m_csDrawMonitor.SetLeftMinCheck(m_dYMinLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            CalcResultMonitor_Paint();
            if (m_csDrawMonitor.GetLeftSetMin() > (double)YLeftScaleNumericUpDown.Value)
            {
                YLeftScaleNumericUpDown.Value = (decimal)m_csDrawMonitor.GetLeftSetMin() + 1;
            }
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();//[2011/01/25]
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }

        //最小値NumricUpDown
        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最小設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYLeftScaleMinNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最小値に変更が有る場合
                //if (this.YVScrollBar.Maximum <= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                    //((NumericUpDown)sender).Value = this.YVScrollBar.Maximum - 1;
                //}
                if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)((NumericUpDown)sender).Value)
                {
                    ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;//[2011/01/25]
                }
                m_dYLeftScaleMinNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);
                // 再描画
                m_bYLeftManualFlg = false;
                //this.YVScrollBar.Value = this.YVScrollBar.Minimum;
                //YVScrollBar.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYLeftRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYLeftManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YLeftScalePaint();//[2011/01/25]
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
                GraphInvalidate(VERTICAL_LEFT);
            }
        }
    }
}