﻿// <summary>ソースコード：ハイエト／ハイドロ入力計算結果モニタ画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ハイエト／ハイドロ入力計算結果モニタ画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetMoniterHydroHyetoForm : HySDotNetMoniterBaseForm
    {
        /// <summary>水平軸最大値(基準値)</summary>
        protected static readonly double XSCALEMAXCONST = 86400.0;
        /// <summary>垂直左端軸最小値(基準値)</summary>
        protected static readonly double YLEFTSCALEMINCONST = 0.0;
        /// <summary>垂直左端軸最大値(基準値)</summary>
        protected static readonly double YLEFTSCALEMAXCONST = 1000.0;
        /// <summary>垂直右端軸最小値(基準値)</summary>
        protected static readonly double YRIGHTSCALEMINCONST = 0.0;
        /// <summary>垂直右端軸最大値(基準値)</summary>
        protected static readonly double YRIGHTSCALEMAXCONST = 100.0;

        /// <summary>水平表示間隔</summary>
        protected static readonly double[] XINTERVAL_BASE = { 0     , 60     , 300     , 600  , 1800 ,
                                                              3600  , 10800  , 21600   , 43200, 86400,
                                                              604800, 2678400, 31536000 
                                                            };

        /// <summary>垂直表示間隔</summary>
        protected static readonly double[] YINTERVAL_BASE = { 0   , 1   , 5    , 10   , 25    ,
                                                              50  , 100 , 250  , 500  , 1000  ,
                                                              2500, 5000, 10000, 25000, 500000,
                                                           1000000,     2500000,       5000000,
                                                          10000000,    25000000,      50000000,
                                                         100000000,   250000000,     500000000
                                                            };

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySMoniterFormIF csDotNetMoniterForm = new HySDotNetMoniterHydroHyetoForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetMoniterHydroHyetoForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetMoniterHydroHyetoForm()
        {
            // コンポーネント初期化
            InitializeComponent();
            // 描画エリア親子定義
            this.LineGraphPictureBox.Parent = this.BarGraphPictureBox;
            this.LineGraphPictureBox.Location = new Point(0, 0);
            // 伝送データ任意入力対応設定
            CreateCntlInfo(2);
            // 伝送データ雨量入力対応グラフ描画エリアインスタンスの設定
            SetGraphInstance(0, this.BarGraphPictureBox);
            // 伝送データ雨量入力対応テーブル表示エリアインスタンスの設定
            SetTableInstance(0, this.BarTableDataGridView);
            // 伝送データ任意入力対応グラフ描画エリアインスタンスの設定
            SetGraphInstance(1, this.LineGraphPictureBox);
            // 伝送データ任意入力対応テーブル表示エリアインスタンスの設定
            SetTableInstance(1, this.LineTableDataGridView);
            // 基本部品－水平軸の表示間隔設定
            DateTime csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
            string sWk = DateTime.Now.ToString("yyyy/MM/dd") + " 0:0:0";
            TimeSpan csTS = DateTime.Parse(sWk) - csDTBase;
            double dXScaleMin_Mst = (double)csTS.TotalSeconds;
            double dXScaleMax_Mst = dXScaleMin_Mst + XSCALEMAXCONST;
            SetXUnderStandardInformation(dXScaleMin_Mst, dXScaleMax_Mst, XINTERVAL_BASE);
            SetYLeftStandardInformation(YLEFTSCALEMINCONST, YLEFTSCALEMAXCONST, YINTERVAL_BASE);
            SetYRightStandardInformation(YRIGHTSCALEMINCONST, YRIGHTSCALEMAXCONST, YINTERVAL_BASE);
            // 基本部品－タイマーインスタンスの設定
            SetFormTimerInstance(this.DspTimer);
            SetTimerEnable(false); // タイマー停止
            // 基本部品－スケール描画領域インスタンスの設定
            SetFormGraphScaleInstance(this.XScalePictureBox, this.YScalePictureBox1, this.YScalePictureBox2);
            // 基本部品－更新時抑止ボタンインスタンスの設定
            SetFormControlInstance(this.TableChange);
            SetFormControlInstance(this.ButtonClose_Graph);
            SetFormControlInstance(this.GraphChange);
            SetFormControlInstance(this.ButtonClose_Table);
            SetFormControlInstance(this.XHScrollBar);
            SetFormControlInstance(this.YVScrollBar1);
            SetFormControlInstance(this.XZoomBar);
            SetFormControlInstance(this.YVScrollBar2);
            SetFormControlInstance(this.YLeftZoomBar);
            SetFormControlInstance(this.YRightZoomBar);
            // 基本部品－スクロースバーインスタンスの設定
            SetFormScrollBarInstance(this.XHScrollBar, this.YVScrollBar1, this.YVScrollBar2);
            // 基本部品－水平軸拡大部品インスタンスの設定
            SetFormTrackBarInstance(this.XZoomBar, this.XScale_Label,this.YLeftZoomBar,this.YLeftScale_Label,
                                                                     this.YRightZoomBar,this.YRightScale_Label);
            // 描画パネル＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = false;
            // 左端位置設定
            this.Panel_Graph.Top = 1;
            this.Panel_Graph.Left = 1;
            this.Panel_Table.Top = 1;
            this.Panel_Table.Left = 1;
            // セル範囲ラベル表示
            CellTopLabel.Text = CellSelectTrackBar.Minimum.ToString();
            CellLastLabel.Text = CellSelectTrackBar.Maximum.ToString();


            m_csDrawMonitor = new HySDotNetDrawMonitor();
            m_csDrawMonitor.SetLeftScaleMemory(VERTICAL_MEMORY_STEP);
            m_csDrawMonitor.SetRightScaleMemory(VERTICAL_MEMORY_STEP);
            m_csDrawMonitor.SetLeftScrollBar(m_csYLeftScrollBar);
            m_csDrawMonitor.SetXScrollBar(m_csXUnderScrollBar);
            m_csDrawMonitor.SetRightScrollBar(m_csYRightScrollBar);
            m_csDrawMonitor.SetLeftInterval(YINTERVAL_BASE);
            m_csDrawMonitor.SetRightInterval(YINTERVAL_BASE);
            m_csDrawMonitor.SetXInterval(XINTERVAL_BASE);
            m_csDrawMonitor.SetLeftControl(YLeftScaleCheckBox, YLeftScaleNumericUpDown, 
                                           YLeftMinScaleCheckBox, YLeftMinScaleNumericUpDown, YLeftZoomBar);
            m_csDrawMonitor.SetRightControl(YRightScaleCheckBox, YRightScaleNumericUpDown, 
                                            YRightMinScaleCheckBox, YRightMinScaleNumericUpDown, YRightZoomBar);
            m_csDrawMonitor.SetXControl(XZoomBar);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetMoniterHydroHyetoForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterHydroHyetoForm_Load(object sender, EventArgs e)
        {
            SetDoubleBuffer(); // ダブルバッファー設定
            // 描画パネルの可視化＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = true;
            m_lColorNum_Mst = 1; // 左端基準色先頭件数設定
            DspTimer_Call(null, null); // 初回のスケール描画
            Application.Idle += new EventHandler(OnIdle);

            m_csDrawMonitor.DrawCheckControl();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイマー再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DspTimer_Call(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DspTimer_Call(object sender, EventArgs e)
        {
            if (m_bActive == true)
            {  // 画面が可視状態の場合
                if (ResetDemandCheck() == true)
                {  // リセット要求が有る場合
                    SetControlEnable(false);  // 操作系抑止
                    GraphAllReset();          // グラフ初期化
                    this.BarTableDataGridView.RowCount = 0;
                    this.LineTableDataGridView.RowCount = 0;
                    TableAllReset();          // テーブル一覧初期化
                    SetControlEnable(true);   // 操作系抑止解除
                }
                try
                {
                    if (this.Panel_Graph.Visible)
                    {  // グラフ表示の場合
                        GraphDisp_Paint();
                        //m_csYRightScalePictureBox.Invalidate();//[2011/01/29]
                    }
                    else
                    {  // テーブル表示の場合
                        TableDataGridView_Paint();
                    }
                }
                catch
                {
                    DspTimer.Enabled = true; // タイマー再開
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            ((HySMoniterScreen)m_csScreen).CloseScreen(m_csID);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面インスタンス複製処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySViewFormBaseIF csForm = Clon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySMoniterFormIF 複写した画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySViewFormBaseIF Clone()
        {
            return new HySDotNetMoniterHydroHyetoForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_Paint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_Paint();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グラフ指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_RangePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_RangePaint()
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示の場合
                CalcResultMonitor_RangePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＸ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_XScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_XScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グラフ左端メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_YLeftScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_YLeftScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グラフ右端メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_YRightScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_YRightScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YRightScalePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>テーブル再表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LineTableDataGridView_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_Paint()
        {
            if (this.Panel_Table.Visible)
            {  // テーブル表示の場合
                CalcResultMonitor_TablePaint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面切替処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispChange_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispChange_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // テーブル表示切替の場合
                this.Panel_Graph.Visible = false;
                this.Panel_Table.Visible = true;
                TableDataGridView_Paint();
            }
            else
            {  // グラフ表示切替の場合
                this.Panel_Table.Visible = false;
                this.Panel_Graph.Visible = true;
                GraphDisp_Paint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>仮想モードセル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineTableDataGridView_CellValueNeeded(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
        {
            CalcResultMonitor_SetTableCellValue(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左端基準グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LeftGraphPictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LeftGraphPictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_LeftGraphPaint(sender, e);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>右端基準グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RightGraphPictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RightGraphPictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_RightGraphPaint(sender, e);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint(sender, e);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint(sender, e);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸右端再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YRightScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YRightScalePaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMoniterHydroHyetoForm_Resize(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterHydroHyetoForm_Resize(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_LeftGraphResize(this.LineGraphPictureBox);
                CalcResultMonitor_RightGraphResize(this.BarGraphPictureBox);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>水平スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUndeScroll(sender);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直左端スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScroll(sender);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直右端スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YRightScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YRightScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＸ軸拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderZoomBarScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnIdle(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnIdle(object sender, EventArgs e)
        {
            CalcResultMonitor_OnIdle();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル範囲トラックバー操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CellSelectTrackBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CellSelectTrackBar_Scroll(object sender, EventArgs e)
        {
            if (CellSelectTrackBar.Value != CellSelectNumericUpDown.Value)
            {  // セル値の変更が有った場合
                m_lCellSelectNum = CellSelectTrackBar.Value;
                CellSelectNumericUpDown.Value = CellSelectTrackBar.Value;
                GraphDataInit(VERTICAL_LEFT);
                GraphDisp_Paint();
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル範囲ピッカー操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CellSelectNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CellSelectNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (CellSelectTrackBar.Value != CellSelectNumericUpDown.Value)
            {  // セル値の変更が有った場合
                m_lCellSelectNum = (long)CellSelectNumericUpDown.Value;
                CellSelectTrackBar.Value = (int)CellSelectNumericUpDown.Value;
                GraphDataInit(VERTICAL_LEFT);
                GraphDisp_Paint();
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸左端拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftZoomBarScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸右端拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YRightZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YRightZoomBarScroll(sender);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸表示最大設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YLeftScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最大設定有効の場合
                //if (this.YVScrollBar1.Minimum > (int)YLeftScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YLeftScaleNumericUpDown.Value = this.YVScrollBar1.Maximum;
               // }
                if (m_csDrawMonitor.GetLeftSetMin() >= (int)YLeftScaleNumericUpDown.Value)
                {
                    YLeftScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
                }
                // Y軸表示最大設定有りと最大値を設定
                m_dYLeftScaleCheck = true;
                m_dYLeftScaleMaxNumber = double.Parse(YLeftScaleNumericUpDown.Value.ToString());
                YLeftScaleNumericUpDown.Enabled = true; // Y軸表示最大設定エリア活性化
                m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
            }
            else
            {  // Y軸表示最大設定無効の場合
                YLeftScaleNumericUpDown.Enabled = false; // Y軸表示最大設定エリア非活性化
                m_dYLeftScaleCheck = false; // Y軸表示最大設定無しを設定
                if (m_csDrawMonitor.GetLeftSetMin() >= 1000)
                {
                    m_csDrawMonitor.SetLeftSetMax(m_csDrawMonitor.GetLeftSetMin());
                }
                else
                {
                    m_csDrawMonitor.SetLeftSetMax(1000);
                }
            }
            // 再描画
            m_csDrawMonitor.SetLeftMaxCheck(m_dYLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar1.Value = this.YVScrollBar1.Minimum;
            YVScrollBar1.PerformLayout();
            CalcResultMonitor_Paint();
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }
        /// <summary><para>method outline</para>
        /// <para>Y軸表示最大設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YRightScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最大設定有効の場合
                //if (this.YVScrollBar2.Minimum > (int)YRightScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YRightScaleNumericUpDown.Value = this.YVScrollBar2.Maximum;
               // }
                if (m_csDrawMonitor.GetRightSetMin() >= (int)YRightScaleNumericUpDown.Value)
                {
                    YRightScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetRightSetMin() + 1;
                }
                // Y軸表示最大設定有りと最大値を設定
                m_dYRightScaleCheck = true;
                m_dYRightScaleMaxNumber = double.Parse(YRightScaleNumericUpDown.Value.ToString());
                YRightScaleNumericUpDown.Enabled = true; // Y軸表示最大設定エリア活性化
                m_csDrawMonitor.SetRightSetMax(m_dYRightScaleMaxNumber);
            }
            else
            {  // Y軸表示最大設定無効の場合
                YRightScaleNumericUpDown.Enabled = false; // Y軸表示最大設定エリア非活性化
                m_dYRightScaleCheck = false; // Y軸表示最大設定無しを設定
                m_csDrawMonitor.SetRightSetMax(100);
            }
            // 再描画
            m_csDrawMonitor.SetRightMaxCheck(m_dYRightScaleCheck);
            m_bYRightManualFlg = false;
            this.YVScrollBar2.Value = this.YVScrollBar2.Minimum;
            YVScrollBar2.PerformLayout();
            CalcResultMonitor_Paint();
            if (m_dYRightRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYRightManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YRightScalePaint();
            m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/25]
            GraphInvalidate(VERTICAL_RIGHT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最大設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYLeftScaleMaxNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最大値に変更が有る場合
                //if (this.YVScrollBar1.Minimum >= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                //    ((NumericUpDown)sender).Value = this.YVScrollBar1.Minimum + 1;
                //}
                if (m_csDrawMonitor.GetLeftSetMin() >= (int)((NumericUpDown)sender).Value)
                {
                    ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
                }
                m_dYLeftScaleMaxNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
                // 再描画
                m_bYLeftManualFlg = false;
                this.YVScrollBar1.Value = this.YVScrollBar1.Minimum;
                YVScrollBar1.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYLeftRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYLeftManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YLeftScalePaint();
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
                GraphInvalidate(VERTICAL_LEFT);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最大設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YRightScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYRightScaleMaxNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最大値に変更が有る場合
                //if (this.YVScrollBar2.Minimum >= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                //    ((NumericUpDown)sender).Value = this.YVScrollBar2.Minimum + 1;
               // }
                if (m_csDrawMonitor.GetRightSetMin() >= (int)((NumericUpDown)sender).Value)
                {
                    ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetRightSetMin() + 1;
                }
                m_dYRightScaleMaxNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                m_csDrawMonitor.SetRightSetMax(m_dYRightScaleMaxNumber);
                // 再描画
                m_bYRightManualFlg = false;
                this.YVScrollBar2.Value = this.YVScrollBar2.Minimum;
                YVScrollBar2.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYRightRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYRightManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YRightScalePaint();
                m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/25]
                GraphInvalidate(VERTICAL_RIGHT);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0016,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
            else
            {  // テーブル表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0017,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetMoniterHydroHyetoForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterHydroHyetoForm_Activated(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }

        //----------------------------
        // 共通スタブの書き換え関連
        //----------------------------

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_OnIdle()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_OnIdle()
        {
            if (m_bDispMode == true)
            {
                m_bDispMode = false;
                if (m_bXManualFlg == true || m_bYLeftManualFlg == true || m_bYRightManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
                else
                {  // 全領域描画の場合
                    GraphDataInit();
                    CalcResultMonitor_Paint();
                }
                // 垂直左端基準描画領域更新
                GraphInvalidate(VERTICAL_LEFT);
                // 垂直右端基準描画領域更新
                GraphInvalidate(VERTICAL_RIGHT);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ対応の垂直軸基準値更新</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>VarticalTypeUpdate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void VarticalTypeUpdate()
        {
            m_csInstanceCommon = m_csDBPCtlInfo.GetPeculiarDataList(new HySObjectKind(m_csID.ToString())) as HySDispInstanceCommon;
            //m_csDrawMonitor.DrawCheckControl();//[2011/01/28]
            if (m_csInstanceCommon is HySDispInstanceCommon)
            {  // 演算結果情報が有る場合
                long lArrayNum = m_csInstanceCommon.GetDataLinkedListArray().GetLength(0);
                if (lArrayNum > 0)
                {  // 項目データが有る場合
                    for (long lP = 0; lP < lArrayNum; lP++)
                    {
                        HySID csReceiveID = new HySID("");
                        HySDataLinkedList csListArray = (m_csInstanceCommon.GetDataLinkedListArray())[lP] as HySDataLinkedList;
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySID)
                            {  // 伝送データの受信パターンＩＤの場合
                                csReceiveID = csListArray.GetData(lP1) as HySID;
                                break;
                            }
                        }
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySDataCharacteristicInCell)
                            {  // 伝送プロパティの項目情報の場合
                                HySDataCharacteristicInCell csInputKind = csListArray.GetData(lP1) as HySDataCharacteristicInCell;
                                if (csInputKind.m_csDataKind[0].Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true &&
                                    csReceiveID.Equals(HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL) == true)
                                {  // 雨量データの場合
                                    // 伝送データ雨量入力対応グラフ描画エリアインスタンスの設定
                                    SetGraphInstance(lP, this.BarGraphPictureBox);
                                    // 伝送データ雨量入力対応テーブル表示エリアインスタンスの設定
                                    SetTableInstance(lP, this.BarTableDataGridView);
                                    SetVarticalType(lP, VERTICAL_RIGHT);
                                }
                                else
                                {  // 任意データの場合
                                    // 伝送データ任意入力対応グラフ描画エリアインスタンスの設定
                                    SetGraphInstance(lP, this.LineGraphPictureBox);
                                    // 伝送データ任意入力対応テーブル表示エリアインスタンスの設定
                                    SetTableInstance(lP, this.LineTableDataGridView);
                                    SetVarticalType(lP, VERTICAL_LEFT);
                                }
                                break;
                            }
                        }
                        long lCellDim = 1;
                        
                        for (long lP1 = 0; lP1 < csListArray.GetCount(); lP1++)
                        {
                            if (csListArray.GetData(lP1) is HySString)
                            {  // セル配列数の場合
                                try
                                {
                                    lCellDim = long.Parse(((HySString)csListArray.GetData(lP1)).ToString());
                                    
                                }
                                catch
                                {
                                    lCellDim = 1;
                                }
                                break;
                            }
                        }
                        //if (csReceiveID.Equals(HySMoniterScreen.HYETO_GRAPH_D1_CELL_SERIAL) == true ||
                        //    csReceiveID.Equals(HySMoniterScreen.HYETO_GRAPH_SINGLE_CELL_SERIAL) == true)
                        {  // セルの有る伝送データの場合
                            if(m_lCellSelectNum <= lCellDim)
                            {  // 現状のセル番号が範囲内の場合
                                if (m_lCellSave < lCellDim)
                                {
                                    m_lCellSave = lCellDim;
                                }
                                else if (m_lCellSave > lCellDim)
                                {
                                    lCellDim = m_lCellSave;
                                }
                                CellSelectTrackBar.Maximum = (int)lCellDim;
                                CellSelectNumericUpDown.Maximum = lCellDim;
                            }
                            else
                            {  // 現状のセル番号が範囲外の場合
                                m_lCellSelectNum = 1;
                                CellSelectTrackBar.Value = 1;
                                CellSelectNumericUpDown.Value = 1;
                                CellSelectTrackBar.Maximum = (int)lCellDim;
                                CellSelectNumericUpDown.Maximum = lCellDim;
                            }
                            // セル範囲ラベル表示
                            CellTopLabel.Text = CellSelectTrackBar.Minimum.ToString();
                            CellLastLabel.Text = CellSelectTrackBar.Maximum.ToString();
                        }
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸左端表示最小設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> YLeftMinScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最小設定有効の場合
                //if (this.YVScrollBar1.Maximum < (int)YLeftMinScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YLeftMinScaleNumericUpDown.Value = this.YVScrollBar1.Minimum;
                //}
                if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)YLeftMinScaleNumericUpDown.Value)
                {
                    YLeftMinScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;
                }
                // Y軸表示最小設定有りと最小値を設定
                m_dYMinLeftScaleCheck = true;
                m_dYLeftScaleMinNumber = double.Parse(YLeftMinScaleNumericUpDown.Value.ToString());
                m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);
                YLeftMinScaleNumericUpDown.Enabled = true; // Y軸表示最小設定エリア活性化
            }
            else
            {  // Y軸表示最小設定無効の場合
                YLeftMinScaleNumericUpDown.Enabled = false; // Y軸表示最小設定エリア非活性化
                m_dYMinLeftScaleCheck = false; // Y軸表示最小設定無しを設定

                //m_csDrawMonitor.SetLeftSetMin(0);//値がある場合はグラフ描画処理時にその値に変わる
                


            }
            // 再描画
            m_csDrawMonitor.SetLeftMinCheck(m_dYMinLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar1.Value = this.YVScrollBar1.Minimum;
            YVScrollBar1.PerformLayout();
            CalcResultMonitor_Paint();

            if (m_csDrawMonitor.GetLeftSetMin() > (double)YLeftScaleNumericUpDown.Value)
            {
                YLeftScaleNumericUpDown.Value = (decimal)m_csDrawMonitor.GetLeftSetMin() + 1;
            }

            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸左端表示最小設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYLeftScaleMinNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最小値に変更が有る場合
                //if (this.YVScrollBar1.Maximum <= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                //    ((NumericUpDown)sender).Value = this.YVScrollBar1.Maximum - 1;
                //}
                if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)((NumericUpDown)sender).Value)
                {
                    ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;
                }
                m_dYLeftScaleMinNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                m_csDrawMonitor.SetLeftSetMin(m_dYLeftScaleMinNumber);
                // 再描画
                m_bYLeftManualFlg = false;
                //this.YVScrollBar1.Value = this.YVScrollBar1.Minimum;
                YVScrollBar1.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYLeftRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYLeftManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YLeftScalePaint();
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/25]
                m_csYLeftScalePictureBox.Invalidate();
                GraphInvalidate(VERTICAL_LEFT);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸右端表示最小設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> YRightMinScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightMinScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最小設定有効の場合
                //if (this.YVScrollBar2.Maximum <= (int)YRightMinScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YRightMinScaleNumericUpDown.Value = this.YVScrollBar2.Minimum;
                //}
                if ((int)m_csDrawMonitor.GetRightSetMax() <= (int)YRightMinScaleNumericUpDown.Value)
                {
                    YRightMinScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetRightSetMax() - 1;
                }
                // Y軸表示最小設定有りと最大値を設定
                m_dYMinRightScaleCheck = true;
                m_dYRightScaleMinNumber = double.Parse(YRightMinScaleNumericUpDown.Value.ToString());
                m_csDrawMonitor.SetRightSetMin(m_dYRightScaleMinNumber);
                YRightMinScaleNumericUpDown.Enabled = true; // Y軸表示最小設定エリア活性化
            }
            else
            {  // Y軸表示最小設定無効の場合
                YRightMinScaleNumericUpDown.Enabled = false; // Y軸表示最小設定エリア非活性化
                m_dYMinRightScaleCheck = false; // Y軸表示最小設定無しを設定
                m_csDrawMonitor.SetRightSetMin(0);
            }
            // 再描画
            m_csDrawMonitor.SetRightMinCheck(m_dYMinRightScaleCheck);
            m_bYRightManualFlg = false;
            this.YVScrollBar2.Value = this.YVScrollBar2.Minimum;
            YVScrollBar2.PerformLayout();
            CalcResultMonitor_Paint();
            if (m_dYRightRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYRightManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YRightScalePaint();
            m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/25]
            m_csYRightScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_RIGHT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸右端表示最小設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YRightMinScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            if (m_dYRightScaleMinNumber != double.Parse(((NumericUpDown)sender).Value.ToString()))
            {  // 最小値に変更が有る場合
                //if (this.YVScrollBar2.Maximum <= (int)((NumericUpDown)sender).Value)
                //{  // 設定値が有効範囲外の場合
                //    ((NumericUpDown)sender).Value = this.YVScrollBar2.Maximum - 1;
                //}
                if ((int)m_csDrawMonitor.GetRightSetMax() <= (int)((NumericUpDown)sender).Value)
                {
                    if (this.YRightScaleNumericUpDown.Minimum > (int)m_csDrawMonitor.GetRightSetMax() - 1)
                    {
                        ((NumericUpDown)sender).Value = 0;
                    }
                    else
                    {
                        ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetRightSetMax() - 1;
                    }
                }
                m_dYRightScaleMinNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
                m_csDrawMonitor.SetRightSetMin(m_dYRightScaleMinNumber);
                // 再描画
                m_bYRightManualFlg = false;
                //this.YVScrollBar2.Value = this.YVScrollBar2.Minimum;
                //YVScrollBar2.PerformLayout();
                CalcResultMonitor_Paint();
                if (m_dYRightRato != 1.0)
                {  // 可視範囲変更操作が有る場合
                    m_bYRightManualFlg = true;
                }
                CalcResultMonitor_RangePaint();
                //CalcResultMonitor_YRightScalePaint();
                m_csDrawMonitor.DrawRightScale(ref m_csBmapYRight, m_csYRightScalePictureBox);//[2011/01/25]
                GraphInvalidate(VERTICAL_RIGHT);
            }
        }
    }
}