﻿// <summary>ソースコード：１次元縦断データ入力計算結果モニタ画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Collections;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>１次元縦断データ入力計算結果モニタ画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetMoniterRiverbedForm : HySDotNetMoniterBaseForm
    {
        /// <summary>ユーザ指定操作状態</summary>
        protected bool m_csUserManualFlg = false;
        /// <summary>時系列最小値</summary>
        protected double m_dXTimeScaleMin_Mst = 0.0;
        /// <summary>時系列最大値</summary>
        protected double m_dXTimeScaleMax_Mst = 0.0;
        /// <summary>時刻指定描画位置</summary>
        protected long m_lTPointCnt = -1;

        /// <summary>水平軸最小値(基準値)</summary>
        protected static readonly double XSCALEMINCONST = 1.0;
        /// <summary>水平軸最大値(基準値)</summary>
        protected static readonly double XSCALEMAXCONST = 100.0;
        /// <summary>垂直左端軸最小値(基準値)</summary>
        protected static readonly double YLEFTSCALEMINCONST = 0.0;
        /// <summary>垂直左端軸最大値(基準値)</summary>
        protected static readonly double YLEFTSCALEMAXCONST = 1000.0;
        /// <summary>水平表示間隔</summary>
        protected static readonly double[] INTERVAL_BASE = { 1, 5, 10, 25, 50, 100, 250, 500 };
        /// <summary>垂直表示間隔</summary>
        protected static readonly double[] YINTERVAL_BASE = { 0   , 1   , 5    , 10   , 25    ,
                                                              50  , 100 , 250  , 500  , 1000  ,
                                                              2500, 5000, 10000, 25000, 500000,
                                                           1000000,     2500000,       5000000,
                                                          10000000,    25000000,      50000000,
                                                         100000000,   250000000,     500000000
                                                            };


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySMoniterFormIF csDotNetMoniterForm = new HySDotNetMoniterRiverbedForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetMoniterRiverbedForm  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetMoniterRiverbedForm()
        {
            // 水平軸初期化
            m_dXScaleMax_Mst = XSCALEMAXCONST;
            m_dXScaleMax = XSCALEMAXCONST;
            m_dXScaleMin = XSCALEMINCONST;
            // コンポーネント初期化
            InitializeComponent();
            // 伝送データ任意入力対応設定
            CreateCntlInfo(1);
            // 伝送データ任意入力対応グラフ描画エリアインスタンスの設定
            SetGraphInstance(0, this.GraphPictureBox);
            // 伝送データ任意入力対応テーブル表示エリアインスタンスの設定
            SetTableInstance(0, this.LineTableDataGridView);
            // 基本部品－水平軸の表示間隔設定
            SetXUnderStandardInformation(XSCALEMINCONST, XSCALEMAXCONST, INTERVAL_BASE);
            // 基本部品－垂直軸の表示間隔設定
            SetYLeftStandardInformation(YLEFTSCALEMINCONST, YLEFTSCALEMAXCONST, YINTERVAL_BASE);
            // 基本部品－タイマーインスタンスの設定
            SetFormTimerInstance(this.DspTimer);
            SetTimerEnable(false); // タイマー停止
            // 基本部品－スケール描画領域インスタンスの設定
            SetFormGraphScaleInstance(this.XScalePictureBox, this.YScalePictureBox);
            // 基本部品－更新時抑止ボタンインスタンスの設定
            SetFormControlInstance(this.TableChange);
            SetFormControlInstance(this.ButtonClose_Graph);
            SetFormControlInstance(this.GraphChange);
            SetFormControlInstance(this.ButtonClose_Table);
            SetFormControlInstance(this.YVScrollBar);
            SetFormControlInstance(this.YLeftZoomBar);
            // 基本部品－スクロースバーインスタンスの設定
            SetFormScrollBarInstance(null, this.YVScrollBar);
            // 基本部品－水平軸拡大部品インスタンスの設定
            SetFormTrackBarInstance(null, null, this.YLeftZoomBar, this.YLeftScale_Label);
            // 描画パネル＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = false;
            // 左端位置設定
            this.Panel_Graph.Top = 1;
            this.Panel_Graph.Left = 1;
            this.Panel_Table.Top = 1;
            this.Panel_Table.Left = 1;

            m_csDrawMonitor = new HySDotNetDrawMonitor();
            m_csDrawMonitor.SetLeftScaleMemory(VERTICAL_MEMORY_STEP);
            m_csDrawMonitor.SetLeftScrollBar(m_csYLeftScrollBar);
            m_csDrawMonitor.SetLeftInterval(YINTERVAL_BASE);
            m_csDrawMonitor.SetLeftControl(YLeftScaleCheckBox, YLeftScaleNumericUpDown,
                                           YLeftMinScaleCheckBox, YLeftMinScaleNumericUpDown, YLeftZoomBar);
            m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetMoniterRiverbedForm_Load( sender,e ) </para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterRiverbedForm_Load(object sender, EventArgs e)
        {
            SetDoubleBuffer(); // ダブルバッファー設定
            // 描画パネルの可視化＋テーブルパネルの不可視化
            this.Panel_Table.Visible = false;
            this.Panel_Graph.Visible = true;
            DspTimer_Call(null, null); // 初回のスケール描画
            Application.Idle += new EventHandler(OnIdle);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイマー再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DspTimer_Call(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DspTimer_Call(object sender, EventArgs e)
        {
            if (m_bActive == true)
            {  // 画面が可視状態の場合
                if (ResetDemandCheck() == true)
                {  // リセット要求が有る場合
                    m_csUserManualFlg = false;
                    SetControlEnable(false);   // 操作系抑止
                    GraphAllReset();           // グラフ初期化
                    TableAllReset();           // テーブル一覧初期化
                    SetControlEnable(true);    // 操作系抑止解除
                }
                try
                {
                    if (this.Panel_Graph.Visible)
                    {  // グラフ表示の場合
                        GraphDisp_Paint();
                    }
                    else
                    {  // テーブル表示の場合
                        TableDataGridView_Paint();
                    }
                }
                catch
                {
                    DspTimer.Enabled = true; // タイマー再開
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            ((HySMoniterScreen)m_csScreen).CloseScreen(m_csID);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面インスタンス複製処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySViewFormBaseIF csForm = Clon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySMoniterFormIF 複写した画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySViewFormBaseIF Clone()
        {
            return new HySDotNetMoniterRiverbedForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_Paint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
                CalcResultMonitor_Paint(); // 伝送データ数分グラフ描画
                GraphPictureBox.Invalidate();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_RangePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_RangePaint()
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示の場合
                m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
                CalcResultMonitor_RangePaint(); // 伝送データ数分テーブル一覧描画
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＸ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_XScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_XScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＹ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GraphDisp_YScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp_YScalePaint()
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>テーブル再表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TableDataGridView_Paint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_Paint()
        {
            if (this.Panel_Table.Visible)
            {  // テーブル表示の場合
                CalcResultMonitor_TablePaint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面切替処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispChange_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispChange_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // テーブル表示切替の場合
                this.Panel_Graph.Visible = false;
                this.Panel_Table.Visible = true;
                TableDataGridView_Paint();
            }
            else
            {  // グラフ表示切替の場合
                this.Panel_Table.Visible = false;
                this.Panel_Graph.Visible = true;
                GraphDisp_Paint();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>仮想モードセル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TableDataGridView_CellValueNeeded(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDataGridView_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
        {
            CalcResultMonitor_SetTableCellValue(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GraphPictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphPictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
                CalcResultMonitor_LeftGraphPaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_XUnderScalePaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YScalePictureBox_Paint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YScalePictureBox_Paint(object sender, PaintEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScalePaint(sender, e);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMoniterRiverbedForm_Resize(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterRiverbedForm_Resize(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_LeftGraphResize(this.GraphPictureBox);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YScrollBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftScroll(sender);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnIdle(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnIdle(object sender, EventArgs e)
        {
            CalcResultMonitor_OnIdle();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示時間軸変更（アニメーション）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TimeSlider_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TimeSlider_Scroll(object sender, EventArgs e)
        {
            if (this.TimeSlider.Value == this.TimeSlider.Maximum)
            {  // 指定時間が最終位置の場合
                m_csUserManualFlg = false;
                m_lTPointCnt = -1;
                this.DisplyTimeLabel.Text = "";
            }
            else
            {  // 指定時間が最終位置前の場合
                m_bResetFlg = false;
                m_csUserManualFlg = true;
                m_lTPointCnt = this.TimeSlider.Value;
                //m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
                //GraphDisp_RangePaint();
                m_bDispMode = false;
            }
            m_csDrawMonitor.SetRiverbetTimePoint((long)(this.TimeSlider.Value));
            //GraphDisp_Paint();
            GraphDisp_RangePaint();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフＹ軸拡大縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftZoomBar_Scroll(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftZoomBar_Scroll(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible)
            {  // グラフ表示の場合
                CalcResultMonitor_YLeftZoomBarScroll(sender);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸表示最大設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YLeftScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最大設定有効の場合
                //if (this.YVScrollBar.Minimum > (int)YLeftScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YLeftScaleNumericUpDown.Value = this.YVScrollBar.Maximum;
                //}
                if (m_csDrawMonitor.GetLeftSetMin() >= (int)YLeftScaleNumericUpDown.Value)
                {
                    YLeftScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
                }
                m_dYLeftScaleCheck = true;
                m_dYLeftScaleMaxNumber = double.Parse(YLeftScaleNumericUpDown.Value.ToString());
                YLeftScaleNumericUpDown.Enabled = true; // Y軸表示最大設定エリア活性化
                m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
            }
            else
            {  // Y軸表示最大設定無効の場合
                YLeftScaleNumericUpDown.Enabled = false; // Y軸表示最大設定エリア非活性化
                m_dYLeftScaleCheck = false; // Y軸表示最大設定無しを設定
                m_csDrawMonitor.SetLeftSetMax(1000);//データがある場合は後に更新される
            }
            // 再描画
            m_csDrawMonitor.SetLeftMaxCheck(m_dYLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            m_dYLeftValue = this.YVScrollBar.Maximum;
            m_csCntlInfo[0].m_lTopPoint = -1;
            CalcResultMonitor_Paint();
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最大設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            //if (this.YVScrollBar.Minimum >= (int)((NumericUpDown)sender).Value)
            //{  // 設定値が有効範囲外の場合
            //    ((NumericUpDown)sender).Value = this.YVScrollBar.Minimum + 1;
            //}
            if (m_csDrawMonitor.GetLeftSetMin() >= (int)((NumericUpDown)sender).Value)
            {
                ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMin() + 1;
            }
            m_dYLeftScaleMaxNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
            m_csDrawMonitor.SetLeftSetMax(m_dYLeftScaleMaxNumber);
            // 再描画
            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            m_dYLeftValue = this.YVScrollBar.Maximum;
            m_csCntlInfo[0].m_lTopPoint = -1;
            CalcResultMonitor_Paint();
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            if (this.Panel_Graph.Visible == true)
            {  // グラフ表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0018,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
            else
            {  // テーブル表示中の場合
                HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0019,
                            ((HySDotNetViewer)((HySMoniterScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>最小時のアクティブイベントでの表示復帰</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetMoniterRiverbedForm_Activated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HySDotNetMoniterRiverbedForm_Activated(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {  // 最小化状態以外の場合
                this.WindowState = FormWindowState.Normal;
            }
        }

        //----------------------------
        // 共通スタブの書き換え関連
        //----------------------------

        /// <summary><para>method outline:</para>
        /// <para>水平グラフスケール初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HorizonUnderGraphScaleInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HorizonUnderGraphScaleInit()
        {
            // 時刻初期値設定
            m_dXScaleMin_Mst = m_dXScaleMinConst;
            m_dXScaleMax_Mst = m_dXScaleMaxConst;
            // 表示範囲設定
            m_dXRato = 1.0;
            this.TimeSlider.Enabled = false;
            this.DisplyTimeLabel.Text = "";
        }

        /// <summary><para>method outline:</para>
        /// <para>Ｘ軸・Ｙ軸最大値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXYScale()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetXYScale()
        {
            
            double dWk = 0.0;
            string sWk = "";
            HySTime csTime = HySTime.DEFAULT_TIME.Clone();

            if (m_csInstanceCommon is HySDispInstanceCommon)
            {  // 演算結果情報が有る場合
                double[] dList = m_csInstanceCommon.GetDoubleArray();
                if (dList != null)
                {  // 境界値が有る場合
                    if (m_dXTimeScaleMax_Mst != dList[1])
                    {  // 時間範囲に変更有る場合
                        m_dXTimeScaleMax_Mst = dList[1];
                        csTime = new HySTime(m_dXTimeScaleMax_Mst);
                        //sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                        //                            HySCalendar.FORMAT.lSW_YEAR).ToString()).ToString("g");
                        sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                                                    HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString()).ToString("g");
                        this.EndTimeLabel.Text = sWk;
                    }
                    if (m_dXTimeScaleMin_Mst != dList[0])
                    {  // 時間範囲に変更有る場合
                        m_dXTimeScaleMin_Mst = dList[0];
                        csTime = new HySTime(m_dXTimeScaleMin_Mst);
                        //sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                        //                            HySCalendar.FORMAT.lSW_YEAR).ToString()).ToString("g");
                        sWk = DateTime.Parse(HySCalendar.GetString(csTime,
                                                    HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString()).ToString("g");
                        this.StartTimeLabel.Text = sWk;
                    }
                    if (dList[2] != m_dYLeftScaleMin)//[2011/01/18]
                    {  // 最小値の更新が必要な場合
                        m_dYLeftScaleMin = dList[2];
                    }
                    //m_dYLeftScaleMax = dList[3];
                    // 水平軸表示許容範囲補正
                    if (m_dXScaleMin >= int.MaxValue || m_dXScaleMin <= int.MinValue)
                    {  // 表示許容範囲外の場合
                       m_dXScaleMin = (double)(int.MinValue + 1);
                    }
                    if (m_dXScaleMax >= int.MaxValue || m_dXScaleMax <= int.MinValue)
                    {  // 表示許容範囲外の場合
                        m_dXScaleMax = (double)(int.MaxValue - 1);
                    }
                    dWk = m_dXScaleMax - m_dXScaleMin;
                    if (dWk >= int.MaxValue || dWk <= int.MinValue)
                    {  // 最大－最小の差が表示許容範囲外の場合
                        m_dXScaleMax = m_dXScaleMin + (int.MaxValue - 1);
                    }
                    // セル数取得
                    long lArrayNum = m_csInstanceCommon.GetDataLinkedListArray().GetLength(0);
                    if (lArrayNum == 1)
                    {  // 項目データが有る場合
                        HySDataLinkedList csListArray = (m_csInstanceCommon.GetDataLinkedListArray())[0] as HySDataLinkedList;
                        long lCellDim = 1;
                        for (long lP = 0; lP < csListArray.GetCount(); lP++)
                        {
                            if (csListArray.GetData(lP) is HySString)
                            {  // セル配列数の場合
                                try
                                {
                                    lCellDim = long.Parse(((HySString)csListArray.GetData(lP)).ToString());
                                }
                                catch
                                {
                                    lCellDim = 1;
                                }
                                break;
                            }
                        }
                        m_dXScaleMax_Mst = lCellDim;
                        m_dXScaleMin_Mst = m_dXScaleMinConst;
                        m_dXScaleMax = m_dXScaleMax_Mst;
                        m_dXScaleMin = m_dXScaleMin_Mst;
                        // データエリア取得
                        m_csData = (m_csInstanceCommon.GetDataHashTableArray())[0];
                        if (m_csData != null)
                        {  // データが有効な場合
                            this.TimeSlider.Maximum = (m_csData.GetCount() > 0) ? (int)m_csData.GetCount() : 1; // 最大件数設定
                            if (m_csUserManualFlg == false)
                            {  // 手動操作が無い場合
                                this.TimeSlider.Value = (int)this.TimeSlider.Maximum; // スライダー位置設定
                            }
                            this.TimeSlider.Enabled = true; // 時刻指定スライダー活性化
                        }
                    }
                }
                // Y軸左端最大値・最小値・スケール補正
                if (m_dYLeftScaleCheck == false)
                {  // Y軸表示最大設定無効の場合
                    //GetLogScale(ref m_dYLeftScaleMax);
                }
                else
                {  // Y軸表示最大設定有効の場合
                    //m_dYLeftScaleMax = m_dYLeftScaleMaxNumber;
                }
                //[2011/01/18]Y軸表示最小値の設定
                if (m_dYMinLeftScaleCheck == false)
                {
                }
                else
                {
                    //m_dYLeftScaleMin = m_dYLeftScaleMinNumber;
                }

                // 垂直軸表示許容範囲補正
                if (m_dYLeftScaleMin >= int.MaxValue || m_dYLeftScaleMin <= int.MinValue)
                {  // 表示許容範囲外の場合
                    //dYLeftScaleMin = (double)(int.MinValue + 1);
                }
                if (m_dYLeftScaleMax >= int.MaxValue || m_dYLeftScaleMax <= int.MinValue)
                {  // 表示許容範囲外の場合
                    //m_dYLeftScaleMax = (double)(int.MaxValue - 1);
                }
                //dWk = m_dYLeftScaleMax - m_dYLeftScaleMin;
                if (dWk >= int.MaxValue || dWk <= int.MinValue)
                {  // 最大－最小の差が表示許容範囲外の場合
                    //m_dYLeftScaleMax = m_dYLeftScaleMin + (int.MaxValue - 1);
                }
            }
            
        }

        /// <summary><para>method outline:</para>
        /// <para>折れ線描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_LinePaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_LinePaint(long lArrayCnt)
        {
            Graphics g = null;
            double dlXX = 0.0;
            double dlYY = 0.0;
            double dOffset = 0.0;

            if (m_csCntlInfo[lArrayCnt].m_lPointCnt != m_csData.GetCount() || m_csCntlInfo[lArrayCnt].m_lTopPoint < 0)
            {  // 最終データ件数に変更が有る場合
                if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
                {  // 左端基準グラフ描画エリアが有効な場合
                    if (m_bYLeftManualFlg == false && m_csUserManualFlg == false)
                    {  // 表示範囲変更の手動操作が有る場合
                        if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                        {  // ビットマップ解放要の場合
                            m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                            m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                        }
                    }
                    if (m_csCntlInfo[lArrayCnt].m_csBmap != null)
                    {  // ビットマップ解放要の場合
                        m_csCntlInfo[lArrayCnt].m_csBmap.Dispose();
                    }
                    m_csCntlInfo[lArrayCnt].m_csBmap = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                       m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                    g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmap); // グラフ描画エリア設定
                }
                m_csCntlInfo[lArrayCnt].m_lPointCnt = m_csData.GetCount(); // 描画件数設定
                SetControlEnable(false); // 操作系抑止

                // 画面表示準備
                double dXScaleMin = m_dXScaleMin; // X軸最小値(基準値)
                double dXScaleMax = m_dXScaleMax; // X軸最大値(基準値)
                double dXScale = m_dXScale;       // X軸目盛間隔(基準値)
                double dYLeftScaleMin = m_dYLeftScaleMin;   // Y軸左端最小値(基準値)
                double dYLeftScaleMax = m_dYLeftScaleMax;   // Y軸左端最大値(基準値)
                double dYLeftScale = m_dYLeftScale;         // Y軸左端目盛間隔(基準値)

                // 基本情報設定
                if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
                {  // 左端基準グラフ描画エリアが有効な場合
                    dlXX = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Width;
                    dlYY = m_csCntlInfo[lArrayCnt].m_csBmap.Size.Height;
                }
                else
                {  // その他
                    return;
                }

                if (m_bDispFlg == true)
                {  // 表示要求が有る場合
                    if (m_csData.GetCount() > 0)
                    {  // 表示データがある場合
                        long lSirDataNum = 1;
                        long lDataNum = ((long)m_dXScaleMax <= 0) ? 1 : (long)m_dXScaleMax;
                        double[] dX_Org = new double[lDataNum];

                        // 水平軸（セル数）範囲設定
                        double dXLogScaleMax = m_dXScaleMax;
                        double dXLogScaleMin = m_dXScaleMin;
                        double dXLogScale = dXLogScaleMax;
                        double dllX = dlXX / dXLogScale;

                        // Ｙ軸左端基準範囲設定
                        if (m_csYLeftScrollBar is VScrollBar)
                        {  // 垂直左端軸スクロールバーが有効な場合
                            if (m_csYLeftScrollBar.Minimum != (int)m_dYLeftScaleMin)
                            {  // 最小値更新の場合
                                if ((int)m_dYLeftScaleMin > m_csYLeftScrollBar.Maximum)
                                {  // 現設定最大範囲を超える場合
                                    //m_csYLeftScrollBar.Maximum = (int)(m_dYLeftScaleMax);
                                }
                                //m_csYLeftScrollBar.Minimum = (int)m_dYLeftScaleMin;
                                if (m_bYLeftManualFlg == false)
                                {  // 表示範囲自動更新の場合
                                    //m_csYLeftScrollBar.Value = (int)m_dYLeftScaleMin;
                                    m_csYLeftScrollBar.PerformLayout();
                                }
                            }
                            if (m_csYLeftScrollBar.Maximum != (int)m_dYLeftScaleMax)
                            {  // 最大値更新の場合
                                //m_csYLeftScrollBar.Maximum = (int)(m_dYLeftScaleMax);
                                if (m_bYLeftManualFlg == false)
                                {  // 表示範囲自動更新の場合
                                    m_dYLeftValue = m_dYLeftScaleMax;
                                }
                            }
                            //if (m_csYLeftScrollBar.Value != m_csYLeftScrollBar.Minimum &&
                            //   m_csYLeftScrollBar.Value != m_csYLeftScrollBar.Maximum)
                            //{  // スケールが最上段または最下段ではない場合
                            //    int iChkNum = m_csYLeftScrollBar.Maximum - (int)m_dYLeftValue;
                            //    if (iChkNum >= m_csYLeftScrollBar.Minimum && iChkNum <= m_csYLeftScrollBar.Maximum)
                            //    {  // 有効範囲内の場合
                            //        if (iChkNum != m_csYLeftScrollBar.Value)
                            //        {  // 現ポジション値と異なる場合
                            //            m_csYLeftScrollBar.Value = iChkNum;
                            //            m_csYLeftScrollBar.PerformLayout();
                            //        }
                            //    }
                            //}
                        }
                        double dYLeftLogScaleMax = m_dYLeftScaleMax;
                        double dYLeftLogScaleMin = m_dYLeftScaleMin;
                        double dYLogZoom = ((m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato) + 1;
                        if (m_csYLeftScrollBar.LargeChange != (int)dYLogZoom)
                        {  // 表示範囲が異なる場合
                            //m_csYLeftScrollBar.LargeChange = (int)dYLogZoom;
                        }
                        double dYLeftLogScale = ((dYLeftLogScaleMax - dYLeftLogScaleMin) <= 0.0) ? 1.0 : (dYLeftLogScaleMax - dYLeftLogScaleMin);
                        double dllYLeft = dlYY / dYLeftLogScale;

                        // 編集エリア生成
                        double[] dData_af = new double[lSirDataNum];
                        double[] dData_af_w = new double[lSirDataNum];
                        double[] dData_bf = new double[lSirDataNum];
                        double[] dData_bfw = new double[lSirDataNum];
                        double[] dData = new double[lSirDataNum];

                        // 該当時刻位置準備
                        long lStep = (((long)dXLogScaleMax / m_lGraphDataMax) <= 0) ? 1 : (long)dXLogScaleMax / m_lGraphDataMax;
                        HySD1CellArrayData csCellData = null;
                        if (m_csUserManualFlg == true && m_lTPointCnt > 0)
                        {  // 時刻指定が有る場合
                            csCellData = m_csData[new HySString((m_lTPointCnt - 1).ToString())] as HySD1CellArrayData;
                            this.DisplyTimeLabel.Text = Properties.HysDotNetViewerResources.MONITER_TIME + DateTime.Parse(HySCalendar.GetString(csCellData.GetLastTime(),
                                                                        HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString()).ToString("g");   //"時刻："
                        }
                        else
                        {  // 時刻指定が無い場合
                            long lTop = (m_csCntlInfo[lArrayCnt].m_lPointCnt > 0) ? m_csCntlInfo[lArrayCnt].m_lPointCnt - 1 : 0;
                            csCellData = m_csData[new HySString(lTop.ToString())] as HySD1CellArrayData;
                        }
                        HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                        HySCellData[] csCell = csCellData.GetCellData(); // セル配列データ取得

                        // セルの折れ線描画
                        for (long lP = (long)dXLogScaleMin; lP <= (long)dXLogScaleMax; lP += lStep)
                        {  // データが有る場合
                            if (csCellData is HySD1CellArrayData)
                            {  // セル型データの場合
                                bool bFlg = false;
                                for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                {
                                    // セルデータを設定（非数値の場合は欠損値に置き換え）
                                    dData_bfw[iLp1] = (double.IsNaN(csCell[0].m_dData[(int)lP - 1]) == true) ?
                                                         HySDefine.dINVALID_VALUE : csCell[0].m_dData[(int)lP - 1];
                                }
                                if (csTime is HySTime)
                                {
                                    dX_Org[lP - 1] = (double)lP - 1;
                                    for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                    {
                                        dData_bf[iLp1] = dData_bfw[iLp1];
                                        if (lP == dXLogScaleMin)
                                        {  // 先頭の場合
                                            dData_af[iLp1] = dData_bfw[iLp1];
                                        }
                                    }
                                    bFlg = true;
                                }
                                if (bFlg == true)
                                {  // 表示有効範囲の場合
                                    double dXWk1, dXWk2, dYWk1, dYWk2;
                                    double dHosok;
                                    // 演算結果値描画
                                    for (int iLp = 0; iLp < lSirDataNum; iLp++)
                                    {
                                        if (dData_bf[iLp] != HySDefine.dINVALID_VALUE)
                                        {  // 欠損データ以外の場合
                                            dXWk1 = (lP == dXLogScaleMin) ? 0 : ((dX_Org[(int)lP - 1 - lStep] - dXLogScaleMax) + dXLogScale) * dllX;
                                            if (dXWk1 < dOffset)
                                            {  // Ｘ軸最小値補正要の場合
                                                dXWk1 = dOffset;
                                            }
                                            else if (dXWk1 > dlXX)
                                            {  // Ｘ軸最大値補正要の場合
                                                dXWk1 = dlXX;
                                            }
                                            dXWk2 = (lP == dXLogScaleMin) ? 0 : ((dX_Org[(int)lP - 1] - dXLogScaleMax) + dXLogScale) * dllX;
                                            if (dXWk2 < dOffset)
                                            {  // Ｘ軸最小値補正要の場合
                                                dXWk2 = dOffset;
                                            }
                                            else if (dXWk2 > dlXX)
                                            {  // Ｘ軸最大値補正要の場合
                                                dXWk2 = dlXX;
                                            }
                                            // Ｙ軸設定
                                            if (dData_af[iLp] >= dYLeftLogScaleMax || dData_af[iLp] <= dYLeftLogScaleMin)
                                            {  // Y軸が最小値または最大値の場合
                                                if (dData_af[iLp] <= dYLeftLogScaleMin)
                                                {  // 最小値の場合
                                                    dYWk1 = dlYY;
                                                }
                                                else
                                                {  // 最大値の場合
                                                    dYWk1 = 0.0;
                                                }
                                            }
                                            else
                                            {  // Y軸が最小値または最大値以外の場合
                                                dHosok = (((dData_af[iLp] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                                dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                            }
                                            if (dData_bf[iLp] >= dYLeftLogScaleMax || dData_bf[iLp] <= dYLeftLogScaleMin)
                                            {  // Y軸が最小値または最大値の場合
                                                if (dData_bf[iLp] <= dYLeftLogScaleMin)
                                                {  // 最小値の場合
                                                    dYWk2 = dlYY;
                                                }
                                                else
                                                {  // 最大値の場合
                                                    dYWk2 = 0.0;
                                                }
                                            }
                                            else
                                            {  // Y軸が最小値または最大値以外の場合
                                                dHosok = (((dData_bf[iLp] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                                dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                            }
                                            // 折れ線描画
                                            if ((dXWk1 >= dOffset || dXWk2 >= dOffset) && (dYWk1 != 0 || dYWk2 != 0))
                                            {  // 描画範囲内の場合
                                                int sR = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(1, 2), 16);
                                                int sG = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(3, 2), 16);
                                                int sB = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(5, 2), 16);
                                                g.DrawLine(new Pen(Color.FromArgb(sR, sG, sB), m_lLineWidth), (float)dXWk1, (float)dYWk1, (float)dXWk2, (float)dYWk2);
                                            }
                                            dData_af[iLp] = dData_bf[iLp]; // 今回データ退避
                                        }
                                    }
                                }
                            }
                        }
                        m_lColorNum += lSirDataNum; // 描画色の更新
                        m_csCntlInfo[lArrayCnt].m_lTopPoint = lDataNum; // 次回描画先頭設定
                    }
                }
                if (g is Graphics)
                {  // 左端基準グラフ描画エリアが有効な場合
                    g.Dispose(); // 左端基準グラフ描画エリア解放
                    m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                }
                if (m_csYLeftScalePictureBox is PictureBox)
                {  // 垂直左端軸描画エリアが有効な場合
                    CalcResultMonitor_YLeftScalePaint(); // Ｙ軸左端メモリ描画
                    m_csYLeftScalePictureBox.Invalidate();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>折れ線指定範囲内描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_Range_LinePaint(lArrayCnt) </para>
        /// </example>
        /// <param name="lArrayCnt">伝送データ配列番号（０相対）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_Range_LinePaint(long lArrayCnt)
        {
            Graphics g = null;
            double dlXX = 0.0;
            double dlYY = 0.0;
            double dOffset = 0.0;

            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                if (m_csCntlInfo[lArrayCnt].m_csBmapRange != null)
                {  // ビットマップ解放要の場合
                    m_csCntlInfo[lArrayCnt].m_csBmapRange.Dispose();
                    m_csCntlInfo[lArrayCnt].m_csBmapRange = null;
                }
                m_csCntlInfo[lArrayCnt].m_csBmapRange = new Bitmap(m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Width,
                                                                   m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Height);
                g = Graphics.FromImage(m_csCntlInfo[lArrayCnt].m_csBmapRange);  // グラフ描画エリア設定
            }
            // 画面表示準備
            double dXScaleMin = m_dXScaleMin;      // X軸最小値(基準値)
            double dXScaleMax = m_dXScaleMax;      // X軸最大値(基準値)
            double dXScale = m_dXScale;         // X軸目盛間隔(基準値)
            double dYLeftScaleMin = m_dYLeftScaleMin;  // Y軸左端最小値(基準値)
            double dYLeftScaleMax = m_dYLeftScaleMax;  // Y軸左端最大値(基準値)
            double dYLeftScale = m_dYLeftScale;     // Y軸左端目盛間隔(基準値)

            // 基本情報設定
            m_csData = (m_csInstanceCommon.GetDataHashTableArray())[lArrayCnt];
            if (m_csCntlInfo[lArrayCnt].m_csGraphPictureBox is PictureBox)
            {  // 基準グラフ描画エリアが有効な場合
                dlXX = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Width;
                dlYY = m_csCntlInfo[lArrayCnt].m_csBmapRange.Size.Height;
            }
            else
            {  // その他
                return;
            }

            if (m_csData.GetCount() > 0)
            {  // 表示データがある場合
                long lSirDataNum = 1;
                long lDataNum = ((long)m_dXScaleMax_Mst <= 0) ? 1 : (long)m_dXScaleMax_Mst;
                double[] dX_Org = new double[lDataNum];

                // Ｘ軸基準範囲設定
                double dXLogScaleMax = m_dXScaleMax;
                double dXLogScaleMin = m_dXScaleMin;
                double dXLogScale = dXLogScaleMax;
                double dllX = dlXX / dXLogScale;

                double dYLeftLogScaleMax = m_dYLeftScaleMax;
                double dYLeftLogZoom = (m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato;
                double dYLeftLogScaleMin = (dYLeftLogScaleMax - dYLeftLogZoom < 0) ? m_dYLeftScaleMin : dYLeftLogScaleMax - dYLeftLogZoom;
                if (m_bYLeftManualFlg == true)
                {  // 表示範囲自動更新の場合
                    double dYHosei = (m_csYLeftScrollBar.Minimum < 0) ? -((double)m_csYLeftScrollBar.Minimum) : 0.0;
                    double dMax = (double)m_csYLeftScrollBar.Maximum - ((double)m_csYLeftScrollBar.Value + dYHosei);
                    if (dMax > (double)m_csYLeftScrollBar.Maximum)
                    {  // 最後尾まで表示範囲の場合
                        dMax = (double)m_csYLeftScrollBar.Maximum;
                    }
                    dYLeftLogScaleMax = dMax;
                    dYLeftLogScaleMin = (dYLeftLogScaleMax - dYLeftLogZoom < m_dYLeftScaleMin) ? m_dYLeftScaleMin :
                                                                                 dYLeftLogScaleMax - dYLeftLogZoom;
                }
                double dYLeftLogScale = ((dYLeftLogScaleMax - dYLeftLogScaleMin) <= 0.0) ? 1.0 : (dYLeftLogScaleMax - dYLeftLogScaleMin);
                double dllYLeft = dlYY / dYLeftLogScale;

                // 編集エリア生成
                bool bEndFlag = false;
                long lXScaleTop = -1;
                double[] dData_af = new double[lSirDataNum];
                double[] dData_bf = new double[lSirDataNum];
                double[] dData_bfw = new double[lSirDataNum];
                double[] dData = new double[lSirDataNum];

                // 該当時刻位置準備
                long lStep = (((long)dXLogScaleMax / m_lGraphDataMax) <= 0) ? 1 : (long)dXLogScaleMax / m_lGraphDataMax;
                HySD1CellArrayData csCellData = null;
                if (m_csUserManualFlg == true && m_lTPointCnt > 0)
                {  // 時刻指定が有る場合
                    csCellData = m_csData[new HySString((m_lTPointCnt - 1).ToString())] as HySD1CellArrayData;
                    this.DisplyTimeLabel.Text = Properties.HysDotNetViewerResources.MONITER_TIME + DateTime.Parse(HySCalendar.GetString(csCellData.GetLastTime(),
                                                                HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString()).ToString("g");   //"時刻："
                }
                else
                {  // 時刻指定が無い場合
                    long lTop = (m_csCntlInfo[lArrayCnt].m_lPointCnt > 0) ? m_csCntlInfo[lArrayCnt].m_lPointCnt - 1 : 0;
                    csCellData = m_csData[new HySString(lTop.ToString())] as HySD1CellArrayData;
                }
                HySTime csTime = csCellData.GetLastTime(); // 時刻取得
                HySCellData[] csCell = csCellData.GetCellData(); // セル配列データ取得

                // セルの折れ線描画
                for (long lP = (long)dXLogScaleMin; lP <= (long)m_dXScaleMax; lP += lStep)
                {  // データが有る場合
                    if (csCellData is HySD1CellArrayData)
                    {  // セル型データの場合
                        bool bFlg = false;
                        for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                        {
                            dData_bfw[iLp1] = (double.IsNaN(csCell[0].m_dData[(int)lP - 1]) == true) ?
                                                         HySDefine.dINVALID_VALUE : csCell[0].m_dData[(int)lP - 1];
                        }
                        if (csTime is HySTime)
                        {
                            dX_Org[lP - 1] = (double)lP - (long)dXLogScaleMin;
                            if ((double)lP >= dXLogScaleMin)
                            {  // 表示範囲内の場合
                                if (lXScaleTop < 0)
                                {
                                    lXScaleTop = lP;
                                    for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                    {
                                        dData_af[iLp1] = dData_bfw[iLp1];
                                    }
                                }
                                for (int iLp1 = 0; iLp1 < lSirDataNum; iLp1++)
                                {
                                    dData_bf[iLp1] = dData_bfw[iLp1];
                                }
                                bFlg = true;
                            }
                            if ((double)lP > dXLogScaleMax)
                            {  // 最大表示範囲を超えた場合
                                bEndFlag = true;
                            }
                        }
                        if (bFlg == true)
                        {  // 表示有効範囲の場合
                            double dXWk1, dXWk2, dYWk1, dYWk2;
                            double dHosok;
                            // 演算結果値描画
                            for (int iLp = 0; iLp < lSirDataNum; iLp++)
                            {
                                if (dData_bf[iLp] != HySDefine.dINVALID_VALUE)
                                {  // 欠損データ以外の場合
                                    dXWk1 = (lP == lXScaleTop) ? 0 : ((dX_Org[(int)lP - 1 - lStep] - dXLogScaleMax) + dXLogScale) * dllX;
                                    if (dXWk1 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk1 = dOffset;
                                    }
                                    else if (dXWk1 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk1 = dlXX;
                                    }
                                    dXWk2 = (lP == lXScaleTop) ? 0 : ((dX_Org[(int)lP - 1] - dXLogScaleMax) + dXLogScale) * dllX;
                                    if (dXWk2 < dOffset)
                                    {  // Ｘ軸最小値補正要の場合
                                        dXWk2 = dOffset;
                                    }
                                    else if (dXWk2 > dlXX)
                                    {  // Ｘ軸最大値補正要の場合
                                        dXWk2 = dlXX;
                                    }
                                    // Ｙ軸設定
                                    if (dData_af[iLp] >= dYLeftLogScaleMax || dData_af[iLp] <= dYLeftLogScaleMin)
                                    {  // Y軸が最小値または最大値の場合
                                        if (dData_af[iLp] <= dYLeftLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk1 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk1 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以外の場合
                                        dHosok = (((dData_af[iLp] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                        dYWk1 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    if (dData_bf[iLp] >= dYLeftLogScaleMax || dData_bf[iLp] <= dYLeftLogScaleMin)
                                    {  // Y軸が最小値または最大値の場合
                                        if (dData_bf[iLp] <= dYLeftLogScaleMin)
                                        {  // 最小値の場合
                                            dYWk2 = dlYY;
                                        }
                                        else
                                        {  // 最大値の場合
                                            dYWk2 = 0.0;
                                        }
                                    }
                                    else
                                    {  // Y軸が最小値または最大値以外の場合
                                        dHosok = (((dData_bf[iLp] - dYLeftLogScaleMax) + dYLeftLogScale) * dllYLeft);
                                        dYWk2 = dlYY - ((dHosok < 0.0) ? 0.0 : dHosok);
                                    }
                                    // 折れ線描画
                                    if ((dXWk1 >= dOffset || dXWk2 >= dOffset) && (dYWk1 != 0 || dYWk2 != 0))
                                    {  // 描画範囲内の場合
                                        int sR = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(1, 2), 16);
                                        int sG = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(3, 2), 16);
                                        int sB = Convert.ToInt32(m_sColor[(iLp + m_lColorNum) % m_sColor.GetLength(0)].Substring(5, 2), 16);
                                        g.DrawLine(new Pen(Color.FromArgb(sR, sG, sB), m_lLineWidth), (float)dXWk1, (float)dYWk1, (float)dXWk2, (float)dYWk2);
                                    }
                                    dData_af[iLp] = dData_bf[iLp]; // 今回データ退避
                                }
                            }
                        }
                        if (bEndFlag == true)
                        {  // 描画最終データの場合
                            break;
                        }
                    }
                }
                m_lColorNum += lSirDataNum; // 描画色の更新
                if (g is Graphics)
                {  // 基準グラフ描画エリアが有効な場合
                    g.Dispose();  // 右端基準グラフ描画エリア解放
                    m_csCntlInfo[lArrayCnt].m_csGraphPictureBox.Invalidate();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左端基準グラフ再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_LeftGraphPaint(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_LeftGraphPaint(object sender, PaintEventArgs e)
        {
            if (m_csCntlInfo != null)
            {  // 伝送データ対応情報が有効な場合
                for (long lP = 0; lP < m_csCntlInfo.GetLength(0); lP++)
                {  // 伝送データ対応情報分繰り返す
                    if (m_csCntlInfo[lP].m_csVarticalType.Equals(VERTICAL_LEFT) == true &&
                        m_csCntlInfo[lP].m_csGraphPictureBox.Equals(sender) == true)
                    {  // 描画エリアが一致した場合
                        this.DisplyTimeLabel.Text = m_csDrawMonitor.DrawRiverbedTimeLabel();
                        ((PictureBox)sender).SizeMode = PictureBoxSizeMode.StretchImage;
                        e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Default; //NearestNeighbor; //.Default; //.Bicubic;
                        Rectangle dstRect = new Rectangle(0, 0, ((PictureBox)sender).Width, ((PictureBox)sender).Height);
                        //if (m_bDispMode == false && (m_bYLeftManualFlg == true || m_csUserManualFlg == true))
                        if (m_bYLeftManualFlg == true || m_csUserManualFlg == true)
                        {  // 表示範囲変更の手動操作が有る場合
                            if (m_csCntlInfo[lP].m_csBmapRange != null)
                            {  // 再描画エリアが有効な場合
                                e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmapRange, dstRect, 0, 0, ((PictureBox)sender).Width
                                                                                     , ((PictureBox)sender).Height, GraphicsUnit.Pixel);
                                return;
                            }
                        }
                        if (m_csCntlInfo[lP].m_csBmap != null)
                        {  // ビットマップが有効な場合
                            // X軸描画範囲設定
                            double dlXX = m_csCntlInfo[lP].m_csBmap.Size.Width;
                            double dXLogScaleMax = m_dXScaleMax;
                            double dXLogZoom = (m_dXScaleMax - m_dXScaleMin) * m_dXRato;
                            double dXLogScaleMin = (dXLogScaleMax - dXLogZoom < 0) ? m_dXScaleMin : dXLogScaleMax - dXLogZoom;
                            double dXLogScale = (m_dXScaleMax - m_dXScaleMin <= 0.0) ? 1.0 : m_dXScaleMax - m_dXScaleMin;
                            double dllX = dlXX / dXLogScale;
                            int iX = (int)((dXLogScaleMin - m_dXScaleMin) * dllX);
                            int iHX = (int)((dXLogScaleMax - dXLogScaleMin) * dllX);

                            // Y軸描画範囲設定
                            double dYLogScaleMax = m_dYLeftScaleMax;
                            double dYLogZoom = (m_dYLeftScaleMax - m_dYLeftScaleMin) * m_dYLeftRato;
                            double dYLogScaleMin = (dYLogScaleMax - dYLogZoom < 0) ? m_dYLeftScaleMin : dYLogScaleMax - dYLogZoom;
                            if (m_bYLeftManualFlg == true)
                            {  // 表示範囲自動更新の場合
                                double dYHosei = (m_csYLeftScrollBar.Minimum < 0) ? -((double)m_csYLeftScrollBar.Minimum) : 0.0;
                                double dMax = (double)m_csYLeftScrollBar.Maximum - ((double)m_csYLeftScrollBar.Value + dYHosei);
                                if (dMax > (double)m_csYLeftScrollBar.Maximum)
                                {  // 最後尾まで表示範囲の場合
                                    dMax = (double)m_csYLeftScrollBar.Maximum;
                                }
                                dYLogScaleMax = dMax;
                                dYLogScaleMin = (dYLogScaleMax - dYLogZoom < m_dYLeftScaleMin) ? m_dYLeftScaleMin :
                                                                                             dYLogScaleMax - dYLogZoom;
                            }
                            double dlYY = m_csCntlInfo[lP].m_csBmap.Size.Height;
                            double dYLogScale = ((m_dYLeftScaleMax - m_dYLeftScaleMin) <= 0.0) ? 1.0 : (m_dYLeftScaleMax - m_dYLeftScaleMin);
                            double dllY = dlYY / dYLogScale;
                            //int iY = (int)((m_dYLeftScaleMax - m_dYLeftValue) * dllY);
                            int iY = (int)(((double)m_csYLeftScrollBar.Value / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            //int iYV = (int)((dYLogScaleMax - dYLogScaleMin) * dllY);
                            int iYV = (int)(((double)m_csYLeftScrollBar.LargeChange / 200.0) * m_csCntlInfo[lP].m_csBmap.Height);
                            e.Graphics.DrawImage(m_csCntlInfo[lP].m_csBmap, dstRect, iX, iY, iHX, iYV, GraphicsUnit.Pixel);
                        }
                        break;
                    }
                }

            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左端基準グラフサイズ変更時再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_LeftGraphResize(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_LeftGraphResize(object sender)
        {
            CalcResultMonitor_YLeftScalePaint(); // Ｙ軸左端メモリ描画
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
            m_csYLeftScalePictureBox.Invalidate();
            CalcResultMonitor_XUnderScalePaint();     // Ｘ軸メモリ描画
            m_csXUnderScalePictureBox.Invalidate();
            if (m_bYLeftManualFlg == true || m_csUserManualFlg == true)
            {  // 表示範囲変更の手動操作が有る場合
                CalcResultMonitor_RangePaint();
                m_bDispMode = false;
            }
            else
            {  // 拡大比率が倍率閾値以上の場合
                m_bDispMode = true;
            }
            ((PictureBox)sender).Invalidate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>垂直左端スクロール再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_YLeftScroll(sender)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_YLeftScroll(object sender)
        {
            long lValue = 0;

            double dYHosei = (((VScrollBar)sender).Minimum < 0) ? -((double)((VScrollBar)sender).Minimum) : 0.0;
            double dMax = (double)((VScrollBar)sender).Maximum - ((double)((VScrollBar)sender).Value + dYHosei);
            if (dMax > (double)((VScrollBar)sender).Maximum)
            {  // 最後尾まで表示範囲の場合
                dMax = (double)((VScrollBar)sender).Maximum;
            }
            lValue = (long)dMax;
            if (lValue != (int)m_dYLeftValue)
            {  // 表示上限の変更がある場合
                m_dYLeftValue = (double)lValue;
                CalcResultMonitor_YLeftScalePaint();
                m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
                m_csYLeftScalePictureBox.Invalidate();
                GraphInvalidate(VERTICAL_LEFT);
                if (m_bYLeftManualFlg == true || m_csUserManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                    m_bDispMode = false;
                }
                else
                {  // 拡大比率が倍率閾値以上の場合
                    m_bDispMode = true;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフＸ軸メモリ描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalcResultMonitor_XUnderScalePaint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_XUnderScalePaint()
        {
            if (m_csBmapXUnder != null)
            {  // ビットマップ解放要の場合
                m_csBmapXUnder.Dispose();
                m_csBmapXUnder = null;
            }
            if (m_csXUnderScalePictureBox.Width > 0 && m_csXUnderScalePictureBox.Height > 0)
            {  // 描画フィールドが有る場合
                m_csBmapXUnder = new Bitmap((int)(m_csXUnderScalePictureBox.Width), (int)(m_csXUnderScalePictureBox.Height));
                Graphics gX = Graphics.FromImage(m_csBmapXUnder); // グラフ描画エリア設定

                double dOffset = 5.0;
                Font csFnt = new Font(Properties.HysDotNetViewerResources.FONT_NAME, 8);    //"ＭＳ ゴシック"
                StringFormat csSf = new StringFormat();
                csSf.FormatFlags = StringFormatFlags.DirectionVertical;
                // 基準領域情報取得
                double dlXX = 0;
                long lWidth = 0;
                long lHeigh = 0;
                GetGraphAreaInfo(0, ref lWidth, ref lHeigh);
                if (lWidth > 0)
                {  // 基準グラフ描画エリアが有効な場合
                    dlXX = lWidth;
                }
                else
                {
                    csFnt.Dispose(); // フォントリソース解放
                    gX.Dispose(); // グラフ描画エリア解放
                    return;
                }
                // X軸メモリ描画
                double dXLogScaleMax = m_dXScaleMax;
                double dXLogScaleMin = m_dXScaleMin;
                double dXLogScale = ((dXLogScaleMax - dXLogScaleMin) <= 0.0) ? 1.0 : (dXLogScaleMax - dXLogScaleMin);
                double dllX = dlXX / dXLogScale;
                // 描画間隔設定
                long lStep = 0;
                for (int iStep = m_dXInterval.GetLength(0) - 1; iStep >= 1; iStep--)
                {
                    lStep = (long)m_dXInterval[iStep];
                    if (Math.Floor(dXLogScale / (double)lStep) >= 12)
                    {  // 商が無い場合
                        if (Math.Floor(dXLogScale / (double)lStep) > 12)
                        {  // ラベル個数が範囲外の場合
                            if (iStep != (m_dXInterval.GetLength(0) - 1))
                            {  // 最終表示間隔以内の場合
                                lStep = (long)m_dXInterval[iStep + 1];
                            }
                        }
                        break;
                    }
                }
                // メモリ、ラベルの描画
                for (double dX = dXLogScaleMin; dX <= dXLogScaleMax; dX += lStep)
                {
                    double dWk1 = ((dX - dXLogScaleMax) + dXLogScale) * dllX;
                    if (dWk1 >= 0.0)
                    { // 描画Pix範囲内の場合
                        gX.DrawLine(new Pen(Color.Black, m_lMemoryWidth), (float)(dWk1 + dOffset), 0, (float)(dWk1 + dOffset), 3);
                        string sWk = ((long)dX).ToString();
                        gX.DrawString(sWk, csFnt, Brushes.Black, (float)(dWk1 - (dOffset / 2.0)), 5, csSf);
                    }
                    else
                    {
                        break;
                    }
                }
                csFnt.Dispose(); // フォントリソース解放
                gX.Dispose(); // グラフ描画エリア解放
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アプリケーションのアイドル監視</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcResultMonitor_OnIdle()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CalcResultMonitor_OnIdle()
        {
            if (m_bDispMode == true)
            {
                m_bDispMode = false;
                if (m_bYLeftManualFlg == true || m_csUserManualFlg == true)
                {  // 表示範囲変更の手動操作が有る場合
                    CalcResultMonitor_RangePaint();
                }
                else
                {  // 全領域描画の場合
                    GraphDataInit();
                    CalcResultMonitor_Paint();
                    GraphPictureBox.Invalidate();
                }
                // 垂直左端基準描画領域更新
                GraphInvalidate(VERTICAL_LEFT);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>Y軸表示最小設定チェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>YLeftScaleCheckBox_CheckedChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked == true)
            {  // Y軸表示最小設定有効の場合
                //if (this.YVScrollBar.Maximum < (int)YLeftMinScaleNumericUpDown.Value)
                //{  // 設定値が有効範囲外の場合
                //    YLeftMinScaleNumericUpDown.Value = this.YVScrollBar.Minimum;
                //}
                if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)YLeftMinScaleNumericUpDown.Value)
                {
                    YLeftMinScaleNumericUpDown.Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;
                }
                m_dYMinLeftScaleCheck = true;
                m_dYLeftScaleMinNumber = double.Parse(YLeftMinScaleNumericUpDown.Value.ToString());
                YLeftMinScaleNumericUpDown.Enabled = true; // Y軸表示最小設定エリア活性化
            }
            else
            {  // Y軸表示最小設定無効の場合
                YLeftMinScaleNumericUpDown.Enabled = false; // Y軸表示最小設定エリア非活性化
                m_dYMinLeftScaleCheck = false; // Y軸表示最小設定無しを設定
            }
            // 再描画
            m_csDrawMonitor.SetLeftMinCheck(m_dYMinLeftScaleCheck);
            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            m_dYLeftValue = this.YVScrollBar.Maximum;
            m_csCntlInfo[0].m_lTopPoint = -1;
            CalcResultMonitor_Paint();
            if (m_csDrawMonitor.GetLeftSetMin() > (double)YLeftScaleNumericUpDown.Value)
            {
                YLeftScaleNumericUpDown.Value = (decimal)m_csDrawMonitor.GetLeftSetMin() + 1;
            }
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Y軸表示最小設定操作時処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>YLeftScaleNumericUpDown_ValueChanged(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void YLeftMinScaleNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            //if (this.YVScrollBar.Maximum <= (int)((NumericUpDown)sender).Value)
            //{  // 設定値が有効範囲外の場合
            //    ((NumericUpDown)sender).Value = this.YVScrollBar.Maximum - 1;
            //}
            if ((int)m_csDrawMonitor.GetLeftSetMax() <= (int)((NumericUpDown)sender).Value)
            {
                ((NumericUpDown)sender).Value = (int)m_csDrawMonitor.GetLeftSetMax() - 1;//[2011/01/27]
            }
            m_dYLeftScaleMinNumber = double.Parse(((NumericUpDown)sender).Value.ToString());
            // 再描画

            m_bYLeftManualFlg = false;
            this.YVScrollBar.Value = this.YVScrollBar.Minimum;
            YVScrollBar.PerformLayout();
            m_dYLeftValue = this.YVScrollBar.Maximum;
            m_csCntlInfo[0].m_lTopPoint = -1;
            CalcResultMonitor_Paint();
            GraphPictureBox.Invalidate();
            if (m_dYLeftRato != 1.0)
            {  // 可視範囲変更操作が有る場合
                m_bYLeftManualFlg = true;
            }
            CalcResultMonitor_RangePaint();
            //CalcResultMonitor_YLeftScalePaint();
            m_csDrawMonitor.DrawLeftScale(ref m_csBmapYLeft, m_csYLeftScalePictureBox);//[2011/01/27]
            m_csYLeftScalePictureBox.Invalidate();
            GraphInvalidate(VERTICAL_LEFT);
        }
    }
}