﻿// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][20010/12/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetLineGraphScreen : HySDotNetScreen
    {
        /// <summary>フォーム</summary>
        protected HySDotNetLineGraphForm m_csGraphViewForm=null;
        /// <summary>ビューアジョブ</summary>
        protected HySEvViewViewerJob m_csJob = null;

        // 定数定義
        ///// <summary>画面デフォルト幅</summary>
        //static private readonly int DEFAULT_WIDTH = 700;
        ///// <summary>画面デフォルト高さ</summary>
        //static private readonly int DEFAULT_HEIGHT = 450;
        
        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetProjectCtlScreen csScreen = new McDotNetProjectCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetLineGraphScreen()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csGraphViewForm = new HySDotNetLineGraphForm(this);
            //m_csGraphViewForm.Text = "画面";
            //m_csGraphViewForm.Width = DEFAULT_WIDTH;
            //m_csGraphViewForm.Height = DEFAULT_HEIGHT;
            //m_csGraphViewForm.StartPosition = FormStartPosition.Manual;
            //m_csGraphViewForm.SetDesktopLocation(450, 10);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            m_csGraphViewForm = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND.GetString()));
            m_csGraphViewForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            m_csJob = csViewer.GetViewerJob(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND.GetString()) as HySEvViewViewerJob;
            
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csGraphViewForm.Show();
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            //m_csGraphViewForm.Close();    //⇒★これを実行するとフォームの「×」の処理が上手く行かなくなる。[2010.01.29]
            m_csJob.DeleteScreen(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csGraphViewForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            //m_csGraphViewForm.Width = DEFAULT_WIDTH;
            //m_csGraphViewForm.Height = DEFAULT_HEIGHT;
            m_csGraphViewForm.WindowState = FormWindowState.Normal;
            m_csGraphViewForm.StartPosition = FormStartPosition.Manual;
            m_csGraphViewForm.SetDesktopLocation(450, 10);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csGraphViewForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csGraphViewForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            if (HySEventObject.ARBITRARY_EVENT == lEventNo)
            {
                long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();
                if (HySEvGrphDefine.CMND_DISPINFO_RESTORE == lSubEventNo)
                {   // 画面設定復元指示
                    // 一旦画面を閉じる
                    this.ProgFormClose();
                    // 画面表示
                    m_csJob.CmndShowScreen((HySObjectKind)HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN, (HySID)this.GetID());
                }
                else if (HySEvGrphDefine.CMND_DISPINFO_SAVE == lSubEventNo)
                {   // 画面設定保存指示
                    HySString csStr = (HySString)((HySEventObject)csEvent).GetSubData();
                    this.ProgSaveGraphInfo(csStr);
                }
            }
            else
            {
                // Do Nothing
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            /* Do Nothing
            ((HySEventObject)csEvent).SetToSimKind(HysAddinScreenDefineGraphView.BUSINESS_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
            */
            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>画面サイズの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetSize( ref iX, ref iY ) </para>
        /// </example>
        /// <param name="iX">横幅</param>
        /// <param name="iY">高さ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetSize(ref int iX, ref int iY)
        {
            iX = this.m_csGraphViewForm.Width;
            iY = this.m_csGraphViewForm.Height;
        }
        /// <summary><para>method outline:</para>
        /// <para>画面表示位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPosition(  iX,  iY ) </para>
        /// </example>
        /// <param name="iX">Ｘ座標</param>
        /// <param name="iY">Ｙ座標</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetPosition(int iX, int iY)
        {
            //this.m_csGraphViewForm.l
            m_csGraphViewForm.SetDesktopLocation(iX, iY);
            m_csGraphViewForm.Show();
        }
        /// <summary><para>method outline:</para>
        /// <para>プログラムからの再描画開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProgRedraw();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ProgRedraw()
        {
            m_csGraphViewForm.ProgRedraw();
        }

        /// <summary><para>method outline:</para>
        /// <para>プログラムからのグラフ設定保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProgSaveGraphInfo();</para>
        /// </example>
        /// <param name="csDirPath">保存ファイルの移動先</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ProgSaveGraphInfo(HySString csDirPath)
        {
            m_csGraphViewForm.ProgSaveGraphInfo(csDirPath);
        }

        /// <summary><para>method outline:</para>
        /// <para>プログラムからグラフ画面を閉じる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProgFormClose();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ProgFormClose()
        {
            //m_csGraphViewForm.ProgLoadGraphInfo();
            // グラフ画面を閉じる前に自動保存設定を無効にする。
            // 閉じた際に、復元したグラフ保存情報が上書きされるのを防ぐ
            m_csGraphViewForm.SetAutoStatus(false);
            // 画面を閉じる
            m_csGraphViewForm.Close();
        }
    }
}
