﻿// <summary>ソースコード：ランチャースクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ランチャースクリーン</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ランチャー画面（.Net）のラッパークラス</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/10/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetLauncherScreen : HySDotNetScreen
    {
        /// <summary>ランチャー画面（.Net）</summary>
        protected HySDotNetLauncherMainForm m_csLauncherMainForm = null;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetLauncherScreen csScreen = new HySDotNetLauncherScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetLauncherScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetLauncherScreen()
        {
            // 処理なし
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csLauncherMainForm = new HySDotNetLauncherMainForm(this);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            m_csLauncherMainForm.Dispose();
            m_csLauncherMainForm = null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(new HySString(HySDotNetViewerDefine.HYSLAUNCHER_BUSINESS_KIND.ToString())));
            // 常に最前面表示
            m_csLauncherMainForm.Owner = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            // 表示
            m_csLauncherMainForm.Show();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示に必要な情報を提供する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDispInfo(ref csBusikindList, ref csToolNameTbl, ref csToolIconTbl)</para>
        /// </example>
        /// <param name="csBusikindList">業務識別子リスト</param>
        /// <param name="csToolNameTbl">ツール名称テーブル</param>
        /// <param name="csToolIconTbl">アイコン名称テーブル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetDispInfo(ref List<HySString> csBusikindList, ref Hashtable csToolNameTbl, ref Hashtable csToolIconTbl)
        {
            ((HySLauncherViewerJob)m_csVJob).GetDispInfo(ref csBusikindList, ref csToolNameTbl, ref csToolIconTbl);
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールの起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool(csBusiKindString)</para>
        /// </example>
        /// <param name="csBusiKindString">業務識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void StartTool(HySString csBusiKindString)
        {
            ((HySLauncherViewerJob)m_csVJob).StartTool(csBusiKindString);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            ((HySDotNetViewerJob)m_csVJob).DeleteScreen(this);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            // 処理なし
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csLauncherMainForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            return bRtn;
        }
    }
}
