﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using System.Drawing;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>オブジェクトファイル保存クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/10][新規作成]</para>
    /// </remarks>
    class HySEvViewConservation
    {
        /// <summary>保存先ファイル名</summary>
        private string m_sFileName = "..\\temp\\_save.obj";

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEvViewConvartion cs = new HySEvViewConservation() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEvViewConservation()
        {
        }



        /// <summary><para>method outline:</para>
        /// <para>設定ファイルへの保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int i = SetConversion( LAColumn, LARow, RALIneColumn, RALineRow, RABarColumn, RABarRow, 
        /// LAfname, RALinefname, RABarfname, ColorArray, AxisArray, LeftAxisMax, LeftAxisMin, RightAxisMax,
        /// RightAxisMin, AutoXStatus, AutoBounds, LeftLabel, RightLabel, StartYear, EndYear, StartHour,
        /// EndHour, StartTime, EndTime, LACheckNum, RALineCheckNum, RABarCheckNum)  </para>
        /// </example>
        /// <param name="LAColumn">int[]：左軸列チェックインデックス</param>
        /// <param name="LARow">int[]：左軸行チェックインデックス</param>
        /// <param name="RALineColumn">int[]：右軸折れ線グラフ列チェックインデックス</param>
        /// <param name="RALineRow">int：右軸折れ線グラフ行チェックインデックス</param>
        /// <param name="RABarColumn">int：右軸棒グラフ列チェックインデックス</param>
        /// <param name="RABarRow">int：右軸棒グラフ行チェックインデックス</param>
        /// <param name="LAfname">string[]：左軸読み込みファイル名</param>
        /// <param name="RALinefname">string[]：右軸折れ線グラフ読み込みファイル名</param>
        /// <param name="RABarfname">string[]：右軸棒グラフ読み込みファイル名</param>
        /// <param name="ColorArray">Color[]：色情報</param>
        /// <param name="AxisArray">string[]：軸順情報</param>
        /// <param name="LeftAxisMax">float：左軸設定最大値</param>
        /// <param name="LeftAxisMin">float：左軸設定最小値</param>
        /// <param name="RightAxisMax">float：右軸設定最大値</param>
        /// <param name="RightAxisMin">float：右軸設定最小値</param>
        /// <param name="AutoXStatus">bool：X軸自動計算フラグ</param>
        /// <param name="AutoYStatus">bool：設定情報自動保存フラグ</param>
        /// <param name="AutoBounds">bool：Y軸自動計算フラグ</param>
        /// <param name="LeftLabel">string：左軸ラベル名</param>
        /// <param name="RightLabel">string：右軸ラベル名</param>
        /// <param name="StartYear">DateTimePicker：計算開始年</param>
        /// <param name="EndYear">DateTimePicker：計算終了年</param>
        /// <param name="StartHour">ComboBox：計算開始月</param>
        /// <param name="EndHour">ComboBox：計算終了月</param>
        /// <param name="StartTime">ComboBox：計算開始分</param>
        /// <param name="EndTime">ComboBox：計算終了分</param>
        /// <param name="LACheckNum">int：左軸チェックデータ数</param>
        /// <param name="RALineCheckNum">int：右軸折れ線グラフチェックデータ数</param>
        /// <param name="RABarCheckNum">int：右軸棒グラフチェックデータ数</param>
        /// <returns>1:=保存成功, 0:=失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int SetConversion(int[] LAColumn, int[] LARow, int[] RALineColumn, int[] RALineRow, int RABarColumn, int RABarRow,
            string[] LAfname, string[] RALinefname, string[] RABarfname, Color[] ColorArray, string[] AxisArray, float LeftAxisMax, 
            float LeftAxisMin, float RightAxisMax, float RightAxisMin, bool AutoXStatus, bool AutoYStatus, bool AutoBounds, string LeftLabel, 
            string RightLabel, DateTimePicker StartYear, DateTimePicker EndYear, ComboBox StartHour, ComboBox EndHour, ComboBox StartTime, ComboBox EndTime,
            int LACheckNum, int RALineCheckNum, int RABarCheckNum)
        {
            int iRtn = 0;
            try
            {
                
                //取得
                //HySEvLegendList ConversionObj = Form;
                //HySDotNetLineGraphForm ConversionObj = Form;
                FormInformation ConversionObj = new FormInformation();
                ConversionObj.LAColumn = LAColumn;
                ConversionObj.LARow = LARow;
                // 異なるマシン間での設定ファイルのやりとりを考慮し、絶対パスでは無く
                // データホームからの相対パスを保存する
                string[] tempLAfname = (string[])LAfname.Clone();// 内部処理は絶対パスで処理が取り扱われている為、保存オブジェクトに対して適用
                for (int iLp = 0; iLp < tempLAfname.Length; iLp++)
                {
                    HySString sRelativePath = null;
                    sRelativePath = new HySString();
                    if (tempLAfname[iLp] != null)
                    {
                        this.GetRelativePathBasedOnDataHome(new HySString(tempLAfname[iLp]), ref sRelativePath);
                        if ((object)sRelativePath != null)
                        {
                            tempLAfname[iLp] = sRelativePath.ToString();
                        }
                    }
                }
                ConversionObj.LAFileName = tempLAfname;
                ConversionObj.RALineColumn = RALineColumn;
                ConversionObj.RALineRow = RALineRow;
                // 異なるマシン間での設定ファイルのやりとりを考慮し、絶対パスでは無く
                // データホームからの相対パスを保存する
                string[] tempRALinefname = (string[])RALinefname.Clone();// 内部処理は絶対パスで処理が取り扱われている為、保存オブジェクトに対して適用
                for (int iLp = 0; iLp < tempRALinefname.Length; iLp++)
                {
                    HySString sRelativePath = null;
                    sRelativePath = new HySString();
                    if (tempRALinefname[iLp] != null)
                    {
                        this.GetRelativePathBasedOnDataHome(new HySString(tempRALinefname[iLp]), ref sRelativePath);
                        if ((object)sRelativePath != null)
                        {
                            tempRALinefname[iLp] = sRelativePath.ToString();
                        }
                    }
                }
                ConversionObj.RALineFileName = tempRALinefname;
                ConversionObj.RABarColumn = RABarColumn;
                ConversionObj.RABarRow = RABarRow;
                // 異なるマシン間での設定ファイルのやりとりを考慮し、絶対パスでは無く
                // データホームからの相対パスを保存する
                string[] tempRABarfname = (string[])RABarfname.Clone();// 内部処理は絶対パスで処理が取り扱われている為、保存オブジェクトに対して適用
                for (int iLp = 0; iLp < tempRABarfname.Length; iLp++)
                {
                    HySString sRelativePath = null;
                    sRelativePath = new HySString();
                    if (tempRABarfname[iLp] != null)
                    {
                        this.GetRelativePathBasedOnDataHome(new HySString(tempRABarfname[iLp]), ref sRelativePath);
                        if ((object)sRelativePath != null)
                        {
                            tempRABarfname[iLp] = sRelativePath.ToString();
                        }
                    }
                }
                ConversionObj.RABarFileName = tempRABarfname;
                ConversionObj.LAChechNum = LACheckNum;
                ConversionObj.RALineCheckNum = RALineCheckNum;
                ConversionObj.RABarChechNum = RABarCheckNum;
                ConversionObj.ColorSelect = ColorArray;
                ConversionObj.AxisSelect = AxisArray;
                ConversionObj.LeftAxisMax = LeftAxisMax;
                ConversionObj.LeftAxisMin = LeftAxisMin;
                ConversionObj.RightAxisMax = RightAxisMax;
                ConversionObj.RightAxisMin = RightAxisMin;
                ConversionObj.AutoXStatus = AutoXStatus;
                ConversionObj.AutoYStatus = AutoYStatus;
                ConversionObj.AutoBounds = AutoBounds;
                ConversionObj.LeftLabel = LeftLabel;
                ConversionObj.RightLabel = RightLabel;
                ConversionObj.StartYear = StartYear.Text;
                ConversionObj.EndYear = EndYear.Text;
                ConversionObj.StartHour = StartHour.Text;
                ConversionObj.EndHour = EndHour.Text;
                ConversionObj.StartTime = StartTime.Text;
                ConversionObj.EndTime = EndTime.Text;


                //保存
                iRtn = SaveObjectFile(ConversionObj, m_sFileName);
                //iRtn = 1;//成功
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                iRtn = 0;//失敗
            }
            return iRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>データホームを基準とした相対パスを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetRelativePathBasedOnDataHome(csAbsolutePath, refcsRelativePath)</para>
        /// </example>
        /// <param name="csAbsolutePath">絶対パス</param>
        /// <param name="csRelativePath">相対パス</param>
        /// <returns>相対化不能の場合には　false を返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>与えられた絶対パス値を　CommonMPデータホームを基準とした相対パスに変換して取得する</para>
        /// </remarks>
        public virtual bool GetRelativePathBasedOnDataHome(HySString csAbsolutePath, ref HySString csRelativePath)
        {
            string sRelativePath = "";
            try
            {
                // 基準パスを絶対パスから取得
                DirectoryInfo csInfo = Directory.GetParent(csAbsolutePath.ToString());
                while (csInfo != null)
                {
                    if (csInfo.FullName.EndsWith("CommonMPData"))
                    {
                        break;
                    }
                    csInfo = Directory.GetParent(csInfo.FullName);
                }
                bool bRtn = HySCommonInfoHash.DirectoryPathExchange(
                    csInfo.FullName,
                    csAbsolutePath.ToString(),
                    ref sRelativePath);
                csRelativePath.SetChar(sRelativePath);
                return bRtn;
            }
            catch
            {
                return false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>設定ファイル情報の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int i = SetConversion( ref LAColumn, ref LARow, ref RALIneColumn, ref RALineRow, ref RABarColumn, ref RABarRow, 
        /// ref LAfname, ref RALinefname, ref RABarfname, ref ColorArray, ref AxisArray, ref LeftAxisMax, ref LeftAxisMin, ref RightAxisMax,
        /// ref RightAxisMin, ref AutoXStatus, ref AutoBounds, ref LeftLabel, ref RightLabel, ref StartYear, ref EndYear, ref StartHour,
        /// ref EndHour, ref StartTime, ref EndTime, ref LACheckNum, ref RALineCheckNum, ref RABarCheckNum)  </para>
        /// </example>
        /// <param name="LAColumn">int[]：左軸列チェックインデックス</param>
        /// <param name="LARow">int[]：左軸行チェックインデックス</param>
        /// <param name="RALineColumn">int[]：右軸折れ線グラフ列チェックインデックス</param>
        /// <param name="RALineRow">int：右軸折れ線グラフ行チェックインデックス</param>
        /// <param name="RABarColumn">int：右軸棒グラフ列チェックインデックス</param>
        /// <param name="RABarRow">int：右軸棒グラフ行チェックインデックス</param>
        /// <param name="LAfname">string[]：左軸読み込みファイル名</param>
        /// <param name="RALinefname">string[]：右軸折れ線グラフ読み込みファイル名</param>
        /// <param name="RABarfname">string[]：右軸棒グラフ読み込みファイル名</param>
        /// <param name="ColorArray">Color[]：色情報</param>
        /// <param name="AxisArray">string[]：軸順情報</param>
        /// <param name="LeftAxisMax">float：左軸設定最大値</param>
        /// <param name="LeftAxisMin">float：左軸設定最小値</param>
        /// <param name="RightAxisMax">float：右軸設定最大値</param>
        /// <param name="RightAxisMin">float：右軸設定最小値</param>
        /// <param name="AutoXStatus">bool：X軸自動計算フラグ</param>
        /// <param name="AutoYStatus">bool：設定情報自動保存フラグ</param>
        /// <param name="AutoBounds">bool：Y軸自動計算フラグ</param>
        /// <param name="LeftLabel">string：左軸ラベル名</param>
        /// <param name="RightLabel">string：右軸ラベル名</param>
        /// <param name="StartYear">DateTimePicker：計算開始年</param>
        /// <param name="EndYear">DateTimePicker：計算終了年</param>
        /// <param name="StartHour">ComboBox：計算開始月</param>
        /// <param name="EndHour">ComboBox：計算終了月</param>
        /// <param name="StartTime">ComboBox：計算開始分</param>
        /// <param name="EndTime">ComboBox：計算終了分</param>
        /// <param name="LACheckNum">int：左軸チェックデータ数</param>
        /// <param name="RALineCheckNum">int：右軸折れ線グラフチェックデータ数</param>
        /// <param name="RABarCheckNum">int：右軸棒グラフチェックデータ数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetConservation(ref int[] LAColumn, ref int[] LARow, ref int[] RALineColumn, ref int[] RALineRow, ref int RABarColumn, 
            ref int RABarRow, ref string[] LAfname, ref string[] RALinefname, ref string[] RABarfname, ref Color[] ColorArray, ref string[] AxisArray,
            ref float LeftAxisMax, ref float LeftAxisMin, ref float RightAxisMax, ref float RightAxisMin, ref bool AutoXStatus, ref bool AutoYStatus,
            ref bool AutoBounds, ref string LeftLabel, ref string RightLabel, ref DateTimePicker StartYear, ref DateTimePicker EndYear, ref ComboBox StartHour, 
            ref ComboBox EndHour, ref ComboBox StartTime, ref ComboBox EndTime, ref int LACheckNum, ref int RALineCheckNum, ref int RABarCheckNum)
        {
            FormInformation ConversionObj = (FormInformation)LoadObjectFile(m_sFileName);
            LAColumn = ConversionObj.LAColumn;
            LARow = ConversionObj.LARow;
            LAfname = ConversionObj.LAFileName;
            // データホームからの相対パスを取得した上でロード側マシン上での絶対パスに直す
            for (int iLp = 0; iLp < LAfname.Length; iLp++)
            {
                if (LAfname[iLp] != null)
                {
                    LAfname[iLp] = HySEnvInf.GetDataHomeDirectory().ToString() + "\\" + LAfname[iLp];
                }
            }
            RALineColumn = ConversionObj.RALineColumn;
            RALineRow = ConversionObj.RALineRow;
            RALinefname = ConversionObj.RALineFileName;
            // データホームからの相対パスを取得した上でロード側マシン上での絶対パスに直す
            for (int iLp = 0; iLp < RALinefname.Length; iLp++)
            {
                if (RALinefname[iLp] != null)
                {
                    RALinefname[iLp] = HySEnvInf.GetDataHomeDirectory().ToString() + "\\" + RALinefname[iLp];
                }
            }
            RABarColumn = ConversionObj.RABarColumn;
            RABarRow = ConversionObj.RABarRow;
            RABarfname = ConversionObj.RABarFileName;
            // データホームからの相対パスを取得した上でロード側マシン上での絶対パスに直す
            for (int iLp = 0; iLp < RABarfname.Length; iLp++)
            {
                if (RABarfname[iLp] != null)
                {
                    RABarfname[iLp] = HySEnvInf.GetDataHomeDirectory().ToString() + "\\" + RABarfname[iLp];
                }
            }
            LACheckNum = ConversionObj.LAChechNum;
            RALineCheckNum = ConversionObj.RALineCheckNum;
            RABarCheckNum = ConversionObj.RABarChechNum;
            ColorArray = ConversionObj.ColorSelect;
            AxisArray = ConversionObj.AxisSelect;
            LeftAxisMax = ConversionObj.LeftAxisMax;
            LeftAxisMin = ConversionObj.LeftAxisMin;
            RightAxisMax = ConversionObj.RightAxisMax;
            RightAxisMin = ConversionObj.RightAxisMin;
            AutoXStatus = ConversionObj.AutoXStatus;
            AutoYStatus = ConversionObj.AutoYStatus;
            AutoBounds = ConversionObj.AutoBounds;
            LeftLabel = ConversionObj.LeftLabel;
            RightLabel = ConversionObj.RightLabel;
            StartYear.Text = ConversionObj.StartYear;
            EndYear.Text = ConversionObj.EndYear;
            StartHour.Text = ConversionObj.StartHour;
            EndHour.Text = ConversionObj.EndHour;
            StartTime.Text = ConversionObj.StartTime;
            EndTime.Text = ConversionObj.EndTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>設定ファイル書き込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveObjectFile(obj, sFileName) </para>
        /// </example>
        /// <param name="obj">object 保存クラスオブジェクト</param>
        /// <param name="sFileName">string：保存ファイルアドレス</param>
        /// <returns>int 1：成功, 0：失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static int SaveObjectFile(object obj, string sFileName)
        {
            try
            {
                FileStream csfs = new FileStream(sFileName, FileMode.Create, FileAccess.Write);
                BinaryFormatter csbf = new BinaryFormatter();
                //シリアル化して書き込む
                csbf.Serialize(csfs, obj);
                csfs.Close();
                return 1;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                return 0;
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>設定ファイル読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadObjectFile(path) </para>
        /// </example>
        /// <param name="path">string：保存ファイルアドレス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static object LoadObjectFile(string path)
        {
            FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read);
            BinaryFormatter f = new BinaryFormatter();
            //読み込んで逆シリアル化する
            object obj = f.Deserialize(fs);
            fs.Close();

            return obj;
        }

        /// <summary><para>method outline:</para>
        /// <para>設定ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSaveFileName(sName) </para>
        /// </example>
        /// <param name="sName">string：保存ファイル名（CommonMPホームディレクトリからの相対パス付き）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSaveFileName(string sName)
        {
            m_sFileName = sName;
        }

        /// <summary><para>class outline:</para>
        /// <para>オブジェクト保存対象クラス</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2010/12/10][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class FormInformation
        {
            /// <summary>左軸コラムチェックインデックス</summary>
            private int[] m_iLAIndexColumn = null;
            /// <summary>左軸ロウチェックインデックス</summary>
            private int[] m_iLAIndexRow = null;
            /// <summary>右軸（折れ線）コラムチェックインデックス</summary>
            private int[] m_iRALineIndexColumn = null;
            /// <summary>右軸（折れ線）ロウチェックインデックス</summary>
            private int[] m_iRALineIndexRow = null;
            /// <summary>右軸（棒）コラムチェックインデックス</summary>
            private int m_iRABarIndexColumn = -1;
            /// <summary>右軸（棒）ロウチェックインデックス</summary>
            private int m_iRABarIndexRow = -1;

            /// <summary>左軸ファイルネーム</summary>
            private string[] m_sLAFileName = null;
            /// <summary>右軸（折れ線）ファイルネーム</summary>
            private string[] m_sRALineFileName = null;
            /// <summary>右軸（棒）ファイルネーム</summary>
            private string[] m_sRABarFileName = null;

            /// <summary>左軸チェック数</summary>
            private int m_iLACheckNum;
            /// <summary>右軸（折れ線）チェック数</summary>
            private int m_iRALineCheckNum;
            /// <summary>右軸（棒）チェック数</summary>
            private int m_iRABarCheckNum;


            /// <summary> 色設定のリスト</summary>
            private Color[] COLORARRAY = null;
            /// <summary>軸選択順番</summary>
            private string[] AxisSelectArray = null;

            /// <summary>左軸最大値</summary>
            private float m_LeftAxisMax;
            /// <summary>左軸最小値</summary>
            private float m_LeftAxisMin;
            /// <summary>右軸最大値</summary>
            private float m_RightAxisMax;
            /// <summary>右軸最小値</summary>
            private float m_RightAxisMin;

            /// <summary>X軸の自動計算保存</summary>
            private bool m_bAutoXStatus;
            /// <summary>状態の自動保存</summary>
            private bool m_bAutoYStatus;
            /// <summary>Y軸の自動計算設定</summary>
            private bool m_bAutoBounds;
            /// <summary>左軸のラベル</summary>
            private string m_sLeftLabel;
            /// <summary>右軸のラベル</summary>
            private string m_sRightLabel;
            /// <summary>開始年月日</summary>
            private string DTPStart;
            /// <summary>終了年月日</summary>
            private string DTPEnd;
            /// <summary>開始時間</summary>
            private string CbBHourStart;
            /// <summary>終了時間</summary>
            private string CbBHourEnd;
            /// <summary>開始分</summary>
            private string CbBTimeStart;
            /// <summary>終了分</summary>
            private string CbBTimeEnd;



            //必要なデータを取得する
            /// <summary>左軸コラムチェックインデックス</summary>
            public int[] LAColumn
            {
                get
                {
                    return m_iLAIndexColumn;
                }
                set
                {
                    m_iLAIndexColumn = value;
                }
            }

            /// <summary>左軸ロウチェックインデックス</summary>
            public int[] LARow
            {
                get
                {
                    return m_iLAIndexRow;
                }
                set
                {
                    m_iLAIndexRow = value;
                }
            }

            /// <summary>右軸（折れ線）コラムチェックインデックス</summary>
            public int[] RALineColumn
            {
                get
                {
                    return m_iRALineIndexColumn;
                }
                set
                {
                    m_iRALineIndexColumn = value;
                }
            }

            /// <summary>右軸（折れ線）ロウチェックインデックス</summary>
            public int[] RALineRow
            {
                get
                {
                    return m_iRALineIndexRow;
                }
                set
                {
                    m_iRALineIndexRow = value;
                }
            }

            /// <summary>右軸（棒）コラムチェックインデックス</summary>
            public int RABarColumn
            {
                get
                {
                    return m_iRABarIndexColumn;
                }
                set
                {
                    m_iRABarIndexColumn = value;
                }
            }

            /// <summary>右軸（棒）ロウチェックインデックス</summary>
            public int RABarRow
            {
                get
                {
                    return m_iRABarIndexRow;
                }
                set
                {
                    m_iRABarIndexRow = value;
                }
            }

            /// <summary>左軸ファイルネーム</summary>
            public string[] LAFileName
            {
                get
                {
                    return m_sLAFileName;
                }
                set
                {
                    m_sLAFileName = value;
                }
            }

            /// <summary>右軸（折れ線）ファイルネーム</summary>
            public string[] RALineFileName
            {
                get
                {
                    return m_sRALineFileName;
                }
                set
                {
                    m_sRALineFileName = value;
                }
            }

            /// <summary>右軸（棒）ファイルネーム</summary>
            public string[] RABarFileName
            {
                get
                {
                    return m_sRABarFileName;
                }
                set
                {
                    m_sRABarFileName = value;
                }
            }

            /// <summary>左軸チェック数</summary>
            public int LAChechNum
            {
                get
                {
                    return m_iLACheckNum;
                }
                set
                {
                    m_iLACheckNum = value;
                }
            }

            /// <summary>右軸（折れ線）チェック数</summary>
            public int RALineCheckNum
            {
                get
                {
                    return m_iRALineCheckNum;
                }
                set
                {
                    m_iRALineCheckNum = value;
                }
            }

            /// <summary>右軸（棒）チェック数</summary>
            public int RABarChechNum
            {
                get
                {
                    return m_iRABarCheckNum;
                }
                set
                {
                    m_iRABarCheckNum = value;
                }
            }

            /// <summary> 色設定情報</summary>
            public Color[] ColorSelect
            {
                get
                {
                    return COLORARRAY;
                }
                set
                {
                    COLORARRAY = value;
                }
            }

            /// <summary>軸選択順番</summary>
            public string[] AxisSelect
            {
                get
                {
                    return AxisSelectArray;
                }
                set
                {
                    AxisSelectArray = value;
                }
            }

            /// <summary>左軸設定最大値</summary>
            public float LeftAxisMax
            {
                get
                {
                    return m_LeftAxisMax;
                }
                set
                {
                    m_LeftAxisMax = value;
                }
            }

            /// <summary>左軸設定最小値</summary>
            public float RightAxisMax
            {
                get
                {
                    return m_RightAxisMax;
                }
                set
                {
                    m_RightAxisMax = value;
                }
            }

            /// <summary>右軸設定最大値</summary>
            public float LeftAxisMin
            {
                get
                {
                    return m_LeftAxisMin;
                }
                set
                {
                    m_LeftAxisMin = value;
                }
            }

            /// <summary>右軸設定最小値</summary>
            public float RightAxisMin
            {
                get
                {
                    return m_RightAxisMin;
                }
                set
                {
                    m_RightAxisMin = value;
                }
            }

            /// <summary>X軸の自動計算保存</summary>
            public bool AutoXStatus
            {
                get
                {
                    return m_bAutoXStatus;
                }
                set
                {
                    m_bAutoXStatus = value;
                }
            }

            /// <summary>状態の自動保存</summary>
            public bool AutoYStatus
            {
                get
                {
                    return m_bAutoYStatus;
                }
                set
                {
                    m_bAutoYStatus = value;
                }
            }

            /// <summary>Y軸の自動計算設定</summary>
            public bool AutoBounds
            {
                get
                {
                    return m_bAutoBounds;
                }
                set
                {
                    m_bAutoBounds = value;
                }
            }

            /// <summary>左軸のラベル</summary>
            public string LeftLabel
            {
                get
                {
                    return m_sLeftLabel;
                }
                set
                {
                    m_sLeftLabel = value;
                }
            }

            /// <summary>右軸のラベル</summary>
            public string RightLabel
            {
                get
                {
                    return m_sRightLabel;
                }
                set
                {
                    m_sRightLabel = value;
                }
            }

            /// <summary>開始年月日</summary>
            public string StartYear
            {
                get
                {
                    return DTPStart;
                }
                set
                {
                    DTPStart = value;
                }
            }

            /// <summary>終了年月日</summary>
            public string EndYear
            {
                get
                {
                    return DTPEnd;
                }
                set
                {
                    DTPEnd = value;
                }
            }

            /// <summary>開始時間</summary>
            public string StartHour
            {
                get
                {
                    return CbBHourStart;
                }
                set
                {
                    CbBHourStart = value;
                }
            }

            /// <summary>終了時間</summary>
            public string EndHour
            {
                get
                {
                    return CbBHourEnd;
                }
                set
                {
                    CbBHourEnd = value;
                }
            }

            /// <summary>開始分</summary>
            public string StartTime
            {
                get
                {
                    return CbBTimeStart;
                }
                set
                {
                    CbBTimeStart = value;
                }
            }

            /// <summary>終了分</summary>
            public string EndTime
            {
                get
                {
                    return CbBTimeEnd;
                }
                set
                {
                    CbBTimeEnd = value;
                }
            }
        }



    }
}
