﻿using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>データグリッドビューアクセスクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/10][新規作成]</para>
    /// </remarks>
    class HySEvViewDataGridViewAccess
    {
        /// <summary>最大データの個数</summary>
        private int m_MaxDataNum = 0;

        /// <summary>チェックデータの個数</summary>
        private int m_Check = 0;

        /// <summary>選択可能最大数</summary>
        private const int MaxSelectNum = 16;

        /// <summary>
        /// 起動時チェックデータ個数追加プロパティ
        /// </summary>
        public int CheckNum
        {
            set
            {
                m_Check = value;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>チェック箇所の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCheckPlace(cs_Dgv, ref i_Row[], ref i_Column[])</para>
        /// </example>
        /// <param name="cs_Dgv">DataGridView：データグリッドビュー</param>
        /// <param name="i_Row">int[]：行インデックス</param>
        /// <param name="i_Column">int[]：列インデックス</param>
        /// <returns>チェック数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public int GetCheckPlace(DataGridView cs_Dgv, ref int[] i_Row, ref int[] i_Column)
        {
            int i_rDataMaxNum = cs_Dgv.Rows.Count;
            int i_cDataMaxNum = cs_Dgv.Columns.Count / 2;

            //チェックボックスがリードオンリーではないことを確認（チェックボックス用）
            if (cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].ReadOnly != true)
            {
                //チェックボックス追加用
                if ((bool)cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].Value == true)
                {
                    if (m_Check < MaxSelectNum)//チェック個数が選択可能最大数を超えていない
                    {
                        m_Check++;
                        i_Column[m_Check - 1] = cs_Dgv.CurrentCell.ColumnIndex / 2;
                        i_Row[m_Check - 1] = cs_Dgv.CurrentCell.RowIndex;
                        //m_stCPlacs[m_Check - 1].s_DataName = cs_Dgv[e.ColumnIndex + 1, e.RowIndex].Value.ToString();
                    }

                    else//チェック個数が選択可能最大数を超えている
                    {
                        cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].Value = false;
                        cs_Dgv.CommitEdit(DataGridViewDataErrorContexts.Commit);
                        //MessageBox.Show("選択ファイルの最大数は16個です");
                        MessageBox.Show(HysMessage.GetString("HYS_MSG_WARNING_OVER_READ_FILE16"));
                        cs_Dgv[0, cs_Dgv.CurrentCell.RowIndex].Selected = true;//イベント発生
                        return 16;
                    }
                }
                //チェックボックスを外す用
                else if ((bool)cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].Value == false)
                {
                    //インデックスを並べなおす
                    for (int i_Cnt1 = 0; i_Cnt1 < m_Check; i_Cnt1++)
                    {
                        if ((i_Column[i_Cnt1] == cs_Dgv.CurrentCell.ColumnIndex / 2) && i_Row[i_Cnt1] == cs_Dgv.CurrentCell.RowIndex)
                        {
                            //削除処理
                            for (int i_Cnt2 = i_Cnt1; i_Cnt2 < m_Check - 1; i_Cnt2++)
                            {
                                i_Column[i_Cnt2] = i_Column[i_Cnt2 + 1];
                                i_Row[i_Cnt2] = i_Row[i_Cnt2 + 1];
                            }
                            i_Column[m_Check - 1] = -1;
                            i_Row[m_Check - 1] = -1;
                            m_Check--;
                        }
                    }
                }
            }
            //データ消去ボタン用
            else
            {
                int i_ClearNum = 0;
                if (cs_Dgv.CurrentCell.ColumnIndex == 0)
                {
                    //チェックが入っていた箇所のインデックスを消去
                    for (int i_forEnd = m_Check - 1; i_forEnd >= 0; i_forEnd--)
                    {
                        for (int i_Cnt1 = 0; i_Cnt1 <= i_forEnd; i_Cnt1++)
                        {
                            //チェック箇所と消去ファイル位置が同じとき
                            if (cs_Dgv.CurrentCell.RowIndex == i_Row[i_Cnt1])
                            {
                                //チェック箇所の消去と並べなおし
                                for (int i_Cnt2 = i_Cnt1; i_Cnt2 < (m_Check - 1); i_Cnt2++)
                                {
                                    i_Row[i_Cnt2] = i_Row[i_Cnt2 + 1];
                                    i_Column[i_Cnt2] = i_Column[i_Cnt2 + 1];
                                }
                                i_Row[i_forEnd] = -1;
                                i_Column[i_forEnd] = -1;
                                i_ClearNum++;//削除したチェックの個数
                            }
                        }
                    }

                    //インデックスを削除後に合わせる
                    for (int i_Cnt = 0; i_Cnt < m_Check; i_Cnt++)
                    {
                        if (cs_Dgv.CurrentCell.RowIndex < i_Row[i_Cnt])
                        {
                            //消去する行よりも下にある行に対して1行分上げる
                            i_Row[i_Cnt] = i_Row[i_Cnt] - 1;
                        }
                    }
                }
                m_Check = m_Check - i_ClearNum;
                return m_Check;
            }

            return m_Check;
        }


        /// <summary><para>method outline:</para>
        /// <para>チェック箇所の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetBarCheckPlace(cs_Dgv, ref i_Row, ref i_Column)</para>
        /// </example>
        /// <param name="cs_Dgv">DataGridView：データグリッドビュー</param>
        /// <param name="iRow">int：行インデックス</param>
        /// <param name="iColumn">int：列インデックス</param>
        /// <returns>チェック数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public int GetBarCheckPlace(DataGridView cs_Dgv, ref int iRow, ref int iColumn)
        {
            //チェックボックスがリードオンリーではないことを確認（チェックボックス用）
            if (cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].ReadOnly != true)
            {
                //チェックボックス追加用
                if ((bool)cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].Value == true)
                {
                    if (m_Check == 1)
                    {
                        cs_Dgv[(2 * iColumn) + 1, iRow].Value = false;
                    }
                    cs_Dgv.CommitEdit(DataGridViewDataErrorContexts.Commit);
                    m_Check = 1;
                    iColumn = cs_Dgv.CurrentCell.ColumnIndex / 2;
                    iRow = cs_Dgv.CurrentCell.RowIndex;
                }

                //チェックボックスを外す用
                else if ((bool)cs_Dgv[cs_Dgv.CurrentCell.ColumnIndex, cs_Dgv.CurrentCell.RowIndex].Value == false)
                {
                    m_Check = 0;
                    iColumn = -1;
                    iRow = -1;
                }
            }

            else
            {
                if (cs_Dgv.CurrentCell.RowIndex == iRow)
                {
                    iColumn = -1;
                    iRow = -1;
                    m_Check = 0;
                }
                else if(cs_Dgv.CurrentCell.RowIndex < iRow)
                {
                    iRow = iRow - 1;
                }
            }
            return m_Check;
        }





        /// <summary><para>method outline:</para>
        /// <para>最大データ数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLeftAxisMaxDataNum(DataNum)</para>
        /// </example>
        /// <param name="DataNum">int：追加したファイルのデータ数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ファイルを追加したとき</para>
        /// </remarks>
        public void SetMaxDataNum(int DataNum)
        {
            if (m_MaxDataNum < DataNum)
            {
                m_MaxDataNum = DataNum;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>列削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  RemoveColumns(csDgv, csFileData[], fReadNum)</para>
        /// </example>
        /// <param name="csDgv">DataGridView：データグリッドビュー</param>
        /// <param name="csFileData">HySCSVFileData[]：ファイルデータ</param>
        /// <param name="ifReadNum">int：追加したファイルのデータ数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void RemoveColumns(DataGridView csDgv, HySCSVFileDim1Data[] csFileData, int ifReadNum)
        {
            int i_MaxDataNum = 0;
            long l_Cnt = 0;
            //消した後の最大データ個数取得
            for (int i_Cnt = 0; i_Cnt < ifReadNum; i_Cnt++)
            {
                csFileData[i_Cnt].GetDimention(ref l_Cnt);
                if (i_MaxDataNum < (int)l_Cnt)
                {
                    i_MaxDataNum = (int)l_Cnt;
                }
            }
            //列を消す
            for (int i_Cnt = 2 * m_MaxDataNum; i_Cnt > 2 * i_MaxDataNum; i_Cnt--)
            {
                csDgv.Columns.RemoveAt(i_Cnt);
                if (i_Cnt == 1)
                {
                    csDgv.Columns.RemoveAt(0);
                }
            }
            m_MaxDataNum = i_MaxDataNum;//最大値修正
        }


        /// <summary><para>method outline:</para>
        /// <para>ファイルの削除と並び替え</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ClearCsvFile(csFileData[], i_index)</para>
        /// </example>
        /// <param name="csFileData">HySCSVFileData[]：ファイルデータ</param>
        /// <param name="i_index">int：消去した行</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void ClearCsvFile(HySCSVFileDim1Data[] csFileData, int i_index)
        {
            for (int i_Cnt = i_index; i_Cnt < (csFileData.Length - 1); i_Cnt++)
            {
                csFileData[i_Cnt] = csFileData[i_Cnt + 1];
            }
            csFileData[csFileData.Length - 1] = null;
        }


        /// <summary><para>method outline:</para>
        /// <para>ファイルネームの削除と並び替え</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ClearFileName(m_sFileName[], i_index)</para>
        /// </example>
        /// <param name="sFileName">string[]：ファイルデータ</param>
        /// <param name="i_index">int：消去した行</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void ClearFileName(string[] sFileName, int i_index)
        {
            for (int i_Cnt = i_index; i_Cnt < (sFileName.Length - 1); i_Cnt++)
            {
                sFileName[i_Cnt] = sFileName[i_Cnt + 1];
            }
            sFileName[sFileName.Length - 1] = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルレコードの削除と並び替え</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ClearFileRecord(iRecordNum[], i_index)</para>
        /// </example>
        /// <param name="iRecordNum">int[]：ファイルのレコード数</param>
        /// <param name="i_index">int：消去したデータグリッドビューの行</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void ClearFileRecord(int[] iRecordNum, int i_index)
        {
            for (int i_Cnt = i_index; i_Cnt < (iRecordNum.Length - 1); i_Cnt++)
            {
                iRecordNum[i_Cnt] = iRecordNum[i_Cnt + 1];
            }
            iRecordNum[iRecordNum.Length - 1] = 0;
        }


        /// <summary><para>method outline:</para>
        /// <para>データグリッドビューヘッダ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataGridViewHeader(int DataNum)</para>
        /// </example>
        /// <param name="csDgv">DataGridView：フォーム上のDataGridView</param>
        /// <param name="DataNum">int：追加したファイル内のデータ数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataGridViewHeader(DataGridView csDgv, int DataNum)
        {

            if ((csDgv.Columns.Count == 0))//初期状態
            {
                //データグリッドビュー初期化
                csDgv.Columns.Clear();
                //ファイルネームの領域
                DataGridViewTextBoxColumn dgv_FileName = new DataGridViewTextBoxColumn();
                dgv_FileName.SortMode = DataGridViewColumnSortMode.NotSortable;
                csDgv.Columns.Add(dgv_FileName);
                csDgv.Columns[0].HeaderText = Properties.HysDotNetViewerResources.GRAPH_COL_FILENAME;//"ファイル名";
                csDgv.Columns[0].Width = 200;
                csDgv.Columns[0].Frozen = true;
            }

            if (m_MaxDataNum < DataNum)//取得データが今までの最大取得データ数よりも多いとき
            {
                int i_AddNum = DataNum - m_MaxDataNum;
                //ヘッダのデータ名・CheckBox領域
                DataGridViewTextBoxColumn[] dgv_DataName = new DataGridViewTextBoxColumn[i_AddNum];
                DataGridViewCheckBoxColumn[] dgv_Check = new DataGridViewCheckBoxColumn[i_AddNum];
                //領域確保
                for (int i_Cnt = 0; i_Cnt < i_AddNum; i_Cnt++)
                {
                    dgv_DataName[i_Cnt] = new DataGridViewTextBoxColumn();
                    dgv_DataName[i_Cnt].SortMode = DataGridViewColumnSortMode.NotSortable;
                    dgv_Check[i_Cnt] = new DataGridViewCheckBoxColumn();
                }
                //ヘッダの名前設定
                for (int i_Cnt = m_MaxDataNum; i_Cnt < DataNum; i_Cnt++)
                {
                    csDgv.Columns.Add(dgv_Check[i_Cnt - m_MaxDataNum]);
                    csDgv.Columns[2 * i_Cnt + 1].HeaderText = Properties.HysDotNetViewerResources.GRAPH_COL_CHECK;//"チェック";
                    csDgv.Columns.Add(dgv_DataName[i_Cnt - m_MaxDataNum]);
                    //csDgv.Columns[2 * (i_Cnt + 1)].HeaderText = "データ" + (i_Cnt + 1).ToString();
                    csDgv.Columns[2 * (i_Cnt + 1)].HeaderText = Properties.HysDotNetViewerResources.GRAPH_COL_DATA + (i_Cnt + 1).ToString();
                }
            }
            //Console.WriteLine("{0}", csDgv.Columns.Count);
        }



        /// <summary><para>method outline:</para>
        /// <para>ファイル名・データ名挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DataInput(csDgv, csDataStore, i_DataNum, i_ReadDataNum)</para>
        /// </example>
        /// <param name="csDgv">DataGridView：データグリッドビュークラス</param>
        /// <param name="Header">HySCSVFileData：データ格納</param>
        /// <param name="sFileName">string：ファイルネーム</param>
        /// <param name="i_DataNum">int：追加したファイル内のデータ数</param>
        /// <param name="i_ReadFileNum">int：読み込んだファイルの数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DataGridViewNameInput(DataGridView csDgv, HySCSVFileDim1Data Header, string[] sFileName, int i_DataNum, int i_ReadFileNum)
        {
            //ファイル名挿入
            csDgv[0, i_ReadFileNum - 1].Value = Path.GetFileName(sFileName[i_ReadFileNum - 1]);
            HySString[] csHeder = Header.GetDataLabelName();
            //データ名挿入
            for (int i_cCnt = 0; i_cCnt < i_DataNum; i_cCnt++)
            {
                csDgv[2 * (i_cCnt + 1), i_ReadFileNum - 1].Value =  csHeder[i_cCnt].ToString().Trim();//一時退避//csDataStore.DataName[i_cCnt];
                //csDgv[2 * i_cCnt + 1, i_ReadFileNum - 1].Value = false;
            }
            //使わない箇所はリードオンリーにする
            for (int i_Cnt = i_DataNum; i_Cnt < m_MaxDataNum; i_Cnt++)
            {
                csDgv[2 * i_Cnt + 1, i_ReadFileNum - 1].ReadOnly = true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>readonly化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CheckBoxReadOnly(csDgv)</para>
        /// </example>
        /// <param name="csDgv">DataGridView：データグリッドビュークラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CheckBoxReadOnly(DataGridView csDgv)
        {
            for (int i_rCnt = 0; i_rCnt < csDgv.Rows.Count; i_rCnt++)
            {
                for (int i_cCnt = 0; i_cCnt < csDgv.Columns.Count; i_cCnt++)
                {
                    if (i_cCnt % 2 == 0)
                    {
                        csDgv[i_cCnt, i_rCnt].ReadOnly = true;
                        if (csDgv[i_cCnt, i_rCnt].Value == null)
                        {
                            csDgv[i_cCnt - 1, i_rCnt].ReadOnly = true;
                        }
                    }
                }
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>行を消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveRow(csDgv)</para>
        /// </example>
        /// <param name="csDgv">DataGridView：データグリッドビュークラス</param>
        /// <param name="Num">int：消去したい行数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void RemoveRow(DataGridView csDgv, int Num)
        {
            csDgv.Rows.RemoveAt(Num);
        }


        /// <summary><para>method outline:</para>
        /// <para>チェック数を初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int i = InitCheckNum()</para>
        /// </example>
        /// <returns>int チェック数を0にして返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public int InitCheckNum()
        {
            m_Check = 0;
            return m_Check;
        }


    }
}
