﻿// <summary>ソースコード：アドインスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>アドインスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/01][新規作成]</para>
    /// </remarks>
    public class HySEvViewScreenFactory : HySFactoryMono, HySScreenFactory 
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySEvViewScreenFactory csFactory = new HySEvViewScreenFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEvViewScreenFactory()
        {
            SetFactoryID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_FACTORY_ID_SCREEN);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND;
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子：予備（使用せず）</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csScreen = null;
            if (csSimulatorKind.Equals(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND) == true)
            {
                if (HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN.Equals(csScreenKind) == true)
                {
                    csScreen = new HySDotNetLineGraphScreen();
                }
                else
                {
                }
            }
            return csScreen;
        }
    }
}
