﻿// <summary>ビューア内業務処理生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内処理ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/01][新規作成]</para>
    /// </remarks>
    public class HySEvViewViewerJobFactory : HySFactoryMono ,HySViewerJobFactory
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySEvViewViewerJobFactory csFactory = new HySEvViewViewerJobFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEvViewViewerJobFactory()
        {
            SetFactoryID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_FACTORY_ID_VIEWRJOB);
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        { return HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND; }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        { return HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND.Equals(csSimKindID); }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内画面制御クラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>ビューア内画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySViewerJob CreateViewerJob(HySIdentifier csID)
        {
            HySViewerJob csJob = new HySEvViewViewerJob();
            csJob.SetSimKind(this.GetSimKind());

            return csJob;
        }
    }
}
