﻿// <summary>ソースコード：メインビューアクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>メインビューアクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetViewer : HySViewerBase //HySViewer
    {
        /// <summary>メインフレーム</summary>
        protected HySDotNetForm m_csMainForm;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetViewer csViewer = new HySDotNetViewer( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetViewer()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Initialize()
        {
            Application.EnableVisualStyles();
            // フォームを生成する前に必ず実行する必要がある。
            Application.SetCompatibleTextRenderingDefault(false);

            // メインフレーム生成
            m_csMainForm = new HySDotNetMainForm(this);

            //画面サイズにあわせて表示
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);
            m_csMainForm.StartPosition = FormStartPosition.CenterScreen;
            m_csMainForm.Width = rect.Width;
            m_csMainForm.Height = rect.Height - 28;

            //MdiClientを探す
            MdiClient m_cForm = GetMdiClient();
            if (m_cForm != null)
            {
                //背景色を変更し、再描画する
                //m_cForm.BackColor = m_csMainForm.BackColor;
                m_cForm.BackColor = Color.Silver;
                m_cForm.Invalidate();
            }

            // 既に各ViewerJobは生成されているので　システム制御Jobクラスを最後に生成しておく
            HySViewerJob csViewrJob = new HySDotNetViewerSystemJob();// ビューア内部処理生成
            csViewrJob.SetViewer(this);   // 各種設定
            this.AddViewerJob(csViewrJob);    // ビューアに積む

            base.Initialize(); // 基底クラス処理
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Terminate()
        {
            return base.Terminate();
        }

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Run()
        {
            // スプラッシュ画面の表示
            HySString sHomeDir = HySEnvInf.GetHomeDirectory();
            HySString sImageFolder = HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE_FOLDER"));
            HySString sImageName = HySEnvInf.GetEnvInf(new HySString("SPLASH_IMAGE"));

            if (((object)sImageFolder != null) && ((object)sImageName != null))
            {
                HySFile csFile = new HySFile(sHomeDir + sImageFolder + sImageName);
                if (csFile.Exist() == true)
                {
                    HySDotNetSplashScreen csSplashScreen = new HySDotNetSplashScreen();
                    csSplashScreen.Show();
                    System.Threading.Thread.Sleep(1000);
                    csSplashScreen.Close();
                    csSplashScreen.Dispose();
                }
            }

            // 本番アプリケーション動作開始
            Application.Run(m_csMainForm);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        override public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();

            //this.ChangeMenuStatus(csEvent); // 各種メニューステータスを変更

            // イベントをビューアジョブに送る。
            HySString csKind = (HySString)csSimKind.GetString();
            HySViewerJob csViewerJob = (HySViewerJob)m_csViewerJobTbl[csKind.ToString()];
            if (csViewerJob != null)
            {
                try
                {
                    bRtn = csViewerJob.EventCallback(csEvent);
                }
                catch (Exception ex)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, csViewerJob.ToString(), "EventCallback", 
                        Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION_EVENT + ex.Message);
                   // HySLog.LogOut(HySLog.ONLINE, csViewerJob.ToString(), "EventCallback", "Catch Exception Event: " + ex.Message);
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean ExitOK()
        {
            Boolean bRtn = true;
            Boolean bLocalRtn = false;
            // ジョブの開始処理
            long lJobNo = m_csViewerJobKeyList.Count;
            for (long lLp = 1; lLp <= lJobNo; lLp++)
            {
                HySString csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                HySViewerJob csViewerJob = (HySViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                if (csViewerJob != null)
                {
                    bLocalRtn = csViewerJob.ExitOK();
                    if (bLocalRtn != true)
                    {
                        bRtn = false;
                        break;
                    }
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Exit()
        {
            //m_csViewerCtl.EventCallback(new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_EXIT_SYSTEM));
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_EXIT_SYSTEM);
            csEvent.SetToSimKind(HySDefine.COMMON_SYS_BUSIPROCEDURE);
            m_csViewerCtl.EventCallback(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームのMdiClientコントロールを探して返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MdiClient m_cForm = GetMdiClient() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>見つかったMdiClientコントロール</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private MdiClient GetMdiClient()
        {
            foreach (Control csControl in m_csMainForm.Controls)
            {
                if (csControl is MdiClient)
                {
                    return (MdiClient)csControl;
                }
            }
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>メインフレーム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetMainForm csForm = GetMainForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メインフレーム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySDotNetMainForm GetMainForm()
        {
            return (HySDotNetMainForm)m_csMainForm;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント監視処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventWatch( csCtl ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面以外から　色々なスレッドで来るイベントを監視し、画面のスレッドに乗り換える処理</para>
        /// </remarks>
        virtual public void EventWatch()
        {
            // ビューア制御のイベント監視処理
            ((HySViewerController)m_csViewerCtl).TryWatchEvent();
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,csKindString ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="csKindString">種別識別文字</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long MenuCallBack(long lCallBackNo, HySString csKindString, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            HySViewerJob csViewerJob = null;
            if (lCallBackNo == HySDotNetViewerDefine.UNDO_EVENT || lCallBackNo == HySDotNetViewerDefine.REDU_EVENT
                || lCallBackNo == HySDotNetViewerDefine.CUT_EVENT || lCallBackNo == HySDotNetViewerDefine.COPY_EVENT
                || lCallBackNo == HySDotNetViewerDefine.PASTE_EVENT || lCallBackNo == HySDotNetViewerDefine.DELETE_EVENT
                || lCallBackNo == HySDotNetViewerDefine.ALLSELECT_EVENT)
            {// Undo,Redo,Cut,Copy,Paste,Del,AllSelectキーイベントの場合はActiveFormに通知
                this.NoticeShortCutKeyEvent(lCallBackNo);
            }
            else
            {
                csViewerJob = (HySViewerJob)m_csViewerJobTbl[csKindString.ToString()];
                if (csViewerJob != null)
                {
                    lRtn = csViewerJob.MenuCallBack(lCallBackNo, bCheckOnOff);
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "HySDotNetViewer::MenuCallBack",
                        "csViewerJob" + "[" + csKindString.ToString() + "]" + Properties.HysDotNetViewerResources.STATEMENT_IS_NULL );
                   // HySLog.LogOut(HySLog.ONLINE, "HySDotNetViewer::MenuCallBack", "csViewerJob[" + csKindString.ToString() + "] is null");
                    lRtn = -1;
                }
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ショートカットキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeShortCutKeyEvent(  )</para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeShortCutKeyEvent(long lCallBackNo)
        {
            HySString csPrcKey = null;
            HySViewerJob csViewerJob = null;
            for (long lLp = 1; lLp <= m_csViewerJobKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                csViewerJob = (HySViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                if (lCallBackNo == HySDotNetViewerDefine.UNDO_EVENT)
                {
                    csViewerJob.NoticeUndoEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.REDU_EVENT)
                {
                    csViewerJob.NoticeRedoEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.CUT_EVENT)
                {
                    csViewerJob.NoticeCutEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.COPY_EVENT)
                {
                    csViewerJob.NoticeCopyEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.PASTE_EVENT)
                {
                    csViewerJob.NoticePasteEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.DELETE_EVENT)
                {
                    csViewerJob.NoticeDeleteEvent(lCallBackNo);
                }
                else if (lCallBackNo == HySDotNetViewerDefine.ALLSELECT_EVENT)
                {
                    csViewerJob.NoticeAllSelectEvent(lCallBackNo);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存済みチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckProjectSaved(  )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 保存済み、false : 未保存</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean CheckProjectSaved()
        {
            Boolean bRtn = true;
            HySString csPrcKey = null;
            HySDotNetViewerJob csViewerJob = null;
            for (long lLp = 1; lLp <= m_csViewerJobKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                //csViewerJob = (HySDotNetViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                csViewerJob = m_csViewerJobTbl[csPrcKey.ToString()] as HySDotNetViewerJob;
                if (csViewerJob != null)
                {
                    // 保存済みチェック
                    if ((bRtn = csViewerJob.CheckProjectSaved()) == false)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>全スクリーン初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateAllScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void InitiateAllScreen()
        {
            HySString csPrcKey = null;
            //HySDotNetViewerJob csViewerJob = null;
           　HySViewerJob csViewerJob = null;
            for (long lLp = 1; lLp <= m_csViewerJobKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                //csViewerJob = (HySDotNetViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                csViewerJob = m_csViewerJobTbl[csPrcKey.ToString()] as HySDotNetViewerJob;
                if (csViewerJob != null)
                {  // 通常Jobの場合
                    ((HySDotNetViewerJob)csViewerJob).InitiateAllScreen();
                }
                else
                {  // 表示業務Jobの場合
                    csViewerJob = m_csViewerJobTbl[csPrcKey.ToString()] as HySDispViewerJob;
                    if (csViewerJob != null)
                    {  // 通常Jobの場合
                        ((HySDispViewerJob)csViewerJob).InitiateAllScreen();
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>全スクリーンノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NormalizeAllScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NormalizeAllScreen()
        {
            HySString csPrcKey = null;
            HySDotNetViewerJob csViewerJob = null;
            for (long lLp = 1; lLp <= m_csViewerJobKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                //csViewerJob = (HySDotNetViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                csViewerJob = m_csViewerJobTbl[csPrcKey.ToString()] as HySDotNetViewerJob;
                if (csViewerJob != null)
                {
                    csViewerJob.NormalizeAllScreen();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算中フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = GetCalculationFlg( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 演算中、false : 非演算</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean GetCalculationFlg()
        {
            Boolean bRtn = false;
            HySString csPrcKey = null;
            HySDotNetViewerJob csViewerJob = null;
            for (long lLp = 1; lLp <= m_csViewerJobKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                //csViewerJob = (HySDotNetViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                csViewerJob = m_csViewerJobTbl[csPrcKey.ToString()] as HySDotNetViewerJob;
                if (csViewerJob != null)
                {
                    bRtn = csViewerJob.GetCalculationFlg();
                    if (bRtn == true)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックオン状態取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GetCheckOnFlg( lCallBackNo ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean GetCheckOnFlg(long lCallBackNo)
        {
            return ((HySDotNetMainForm)m_csMainForm).GetCheckOnFlg(lCallBackNo);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csProjectName = GetProjectName( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>HySString：プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySString GetProjectName(HySSysEvent csEvent)
        {
            HySString csName = new HySString("");
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySString csKind = (HySString)csSimKind.GetString();
            HySViewerJob csViewerJob = (HySViewerJob)m_csViewerJobTbl[csKind.ToString()];
            if (csViewerJob != null)
            {
                csName = ((HySDotNetViewerJob)csViewerJob).GetProjectName(csEvent);
            }
            return csName;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.3では下記コードを追加する（ツール起動用ランチャー） 
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ランチャーからのツール起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool( ) </para>
        /// </example>
        /// <param name="csBusiKindString">ツールの業務識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void StartTool(HySString csBusiKindString)
        {
            HySDotNetAddInBaseJob csViewerJob = m_csViewerJobTbl[csBusiKindString.ToString()] as HySDotNetAddInBaseJob;
            if (csViewerJob != null)
            {
                csViewerJob.StartTool();
            }
        }

        # region ビューアジョブクラスにて処理を行う
        ///// <summary><para>method outline:</para>
        ///// <para>イベントに対応しメニューマスクを変更する</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ChangeMenuStatus( csEvent ) </para>
        ///// </example>
        ///// <param name="csEvent">送られたイベント</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void ChangeMenuStatus(HySSysEvent csEvent)
        //{
        //    long lEventNo = ((HySEventObject)csEvent).GetEventNo();
        //    if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS ||
        //           lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
        //           lEventNo == HySEventObject.NOTICE_RENEW_SIMULATION ||
        //           lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
        //           lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION ||
        //           lEventNo == HySEventObject.NOTICE_DB_OK ||
        //           lEventNo == HySEventObject.NOTICE_DB_NG)
        //    {
        //        if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)                 // 計算開始
        //        {
        //            //((HySDotNetMainForm)m_csMainForm).ChangeMainMenuStatus(0xa3);
        //            //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(0, 0x1a);
        //            //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x30);
        //            //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel3Status(0, 2, 0x0);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE, HySDotNetViewerDefine.MENU_CAL_SAVE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE_OPEN, HySDotNetViewerDefine.MENU_CAL_SAVE_OPEN_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_SYSTEM_END, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_FILE, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_READ, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_WRITE_SIMPLE, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_WRITE_ALL, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_EDIT, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_LIBRARY, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_MODEL, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_START, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_PAUSE, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_STOP, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_RESET, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            DispStatus((HySEventObject)csEvent);
        //        }
        //        else if (lEventNo != HySEventObject.NOTICE_REPORT_SIMU_PROGRESS)
        //        {
        //            if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION)             // 計算中断
        //            {
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x17);
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x55);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_START, HySDotNetViewerDefine.MENU_CAL_START_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_PAUSE, HySDotNetViewerDefine.MENU_CAL_PAUSE_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_STOP, HySDotNetViewerDefine.MENU_CAL_STOP_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_RESET, HySDotNetViewerDefine.MENU_CAL_RESET_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET_INDEX);
        //            }
        //            else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
        //                      lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
        //                     lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)     // 計算終了(強制終了)
        //            {
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x13);
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x45);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_START, HySDotNetViewerDefine.MENU_CAL_START_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_PAUSE, HySDotNetViewerDefine.MENU_CAL_PAUSE_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_STOP, HySDotNetViewerDefine.MENU_CAL_STOP_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_RESET, HySDotNetViewerDefine.MENU_CAL_RESET_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET_INDEX);
        //                DispStatus((HySEventObject)csEvent);
        //            }
        //            else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
        //                     lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
        //                     lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)   // 未計算
        //            {
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x10);
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(2, 0x41);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_START, HySDotNetViewerDefine.MENU_CAL_START_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_PAUSE, HySDotNetViewerDefine.MENU_CAL_PAUSE_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_STOP, HySDotNetViewerDefine.MENU_CAL_STOP_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_RESET, HySDotNetViewerDefine.MENU_CAL_RESET_INDEX);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET, HySDotNetViewerDefine.MENU_CAL_PARAMETERSET_INDEX);
        //            }
        //            //((HySDotNetMainForm)m_csMainForm).ChangeMainMenuStatus(0xff);
        //            //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(0, 0x1f);
        //            //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel3Status(0, 2, 0x7);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_SYSTEM_END, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_SAVE, HySDotNetViewerDefine.MENU_CAL_SAVE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_SAVE_OPEN, HySDotNetViewerDefine.MENU_CAL_SAVE_OPEN_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_STRUCT_FILE, HySDotNetViewerDefine.MENU_STRUCT_FILE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_STRUCT_READ, HySDotNetViewerDefine.MENU_STRUCT_READ_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_STRUCT_WRITE_SIMPLE, HySDotNetViewerDefine.MENU_STRUCT_WRITE_SIMPLE_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_STRUCT_WRITE_ALL, HySDotNetViewerDefine.MENU_STRUCT_WRITE_ALL_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_EDIT, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_LIBRARY, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            ((HySDotNetMainForm)m_csMainForm).SetMaskMode(true, HySDotNetViewerDefine.MENU_MODEL, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            if (GetCalculationFlg() == true)
        //            {
        //                //((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(0, 0x1e);
        //                ((HySDotNetMainForm)m_csMainForm).SetMaskMode(false, HySDotNetViewerDefine.MENU_SYSTEM_END, HySDotNetViewerDefine.MENU_SYSTEM_END_INDEX);
        //            }
        //            DispStatus((HySEventObject)csEvent);
        //        }
        //    }
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>メインメニュー状態変更</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ChangeMainMenuStatus( lPatern ) </para>
        ///// </example>
        ///// <param name="lPatern">マスクパターン</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void ChangeMainMenuStatus(long lPatern)
        //{
        //    ((HySDotNetMainForm)m_csMainForm).ChangeMainMenuStatus(lPatern);
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>サブメニューレベル２状態変更</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ChangeSubMenuLevel2Status( lIndex,lPatern ) </para>
        ///// </example>
        ///// <param name="lIndex">メインメニュー位置</param>
        ///// <param name="lPatern">マスクパターン</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void ChangeSubMenuLevel2Status(long lIndex, long lPatern)
        //{
        //    ((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel2Status(lIndex,lPatern);
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>サブメニューアイテムレベル３取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ChangeSubMenuLevel3Status( lIndexI,lIndexJ,lPatern ) </para>
        ///// </example>
        ///// <param name="lIndexI">メインメニュー位置</param>
        ///// <param name="lIndexJ">サブメニューレベル２位置</param>
        ///// <param name="lPatern">マスクパターン</param>
        ///// <returns>サブメニューアイテムレベル３</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void ChangeSubMenuLevel3Status(long lIndexI, long lIndexJ, long lPatern)
        //{
        //    ((HySDotNetMainForm)m_csMainForm).ChangeSubMenuLevel3Status(lIndexI, lIndexJ,lPatern);
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>ステータス表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> DispStatus( csEvent ) </para>
        ///// </example>
        ///// <param name="csEvent">イベント</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void DispStatus(HySEventObject csEvent)
        //{
        //    ((HySDotNetMainForm)m_csMainForm).DispStatus(csEvent);
        //}
        # endregion


        # region ビューアジョブクラスにて処理を行う
        ///// <summary>搭載スクリーン数</summary>
        //protected long m_lScreenNum = 0;

        ///// <summary>スクリーン識別管理ハッシュテーブル</summary>
        //protected Hashtable m_csScreenTbl;

        ///// <summary>スクリーン識別キー管理リスト</summary>
        //protected IList m_csScreenKeyList;

        ///// <summary>スクリーンファクトリ</summary>
        //protected HySScreenFactory m_csScreenFactory;
        # endregion
        # region ビューアジョブクラスにて処理を行う
        ///// <summary><para>method outline:</para>
        ///// <para>スクリーン取り込み</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> LoadScreen( csPrc ) </para>
        ///// </example>
        ///// <param name="csPrc">スクリーン</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void LoadScreen(HySScreen csPrc)
        //{
        //    csPrc.SetViewer(this);
        //    // 種別識別子とデータ識別子でユニークキー作成
        //    HySIdentifier csDataID = csPrc.GetID();
        //    HySKind csSimKind = csPrc.GetSimKind();
        //    HySString csPrcID = (HySString)csDataID.GetString();
        //    HySString csPrcKind = (HySString)csSimKind.GetString();
        //    HySString csPrcKey = csPrcKind + csPrcID;
        //    m_csScreenTbl[csPrcKey.ToString()] = csPrc;
        //    m_lScreenNum += 1;
        //    m_csScreenKeyList.Add(csPrcKey);
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>スクリーンを設定する</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> SetScreen( csScreen ) </para>
        ///// </example>
        ///// <param name="csScreen">スクリーン</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetScreen(HySScreen csScreen)
        //{
        //    this.LoadScreen(csScreen);
        //}
               # endregion
        # region ビューアジョブクラスにて処理を行う
        ///// <summary><para>method outline:</para>
        ///// <para>全画面メニューコール</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> AllScreenMenuCall( lCallBackNo ) </para>
        ///// </example>
        ///// <param name="lCallBackNo">コールバック番号</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void AllScreenMenuCall(long lCallBackNo)
        //{
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        HySString csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        HySScreen csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //        if (csScreen != null)
        //        {
        //            ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);   // 該当スクリーンのコールバック処理
        //        }
        //    }
        //}

        ///// <summary><para>method outline</para>
        ///// <para>モデル管理画面クローズ時のScreen削除</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> DeleteScreen( csString )</para>
        ///// </example>
        ///// <param name="csString">スクリーン識別情報</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>モデル管理画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        ///// </remarks>
        //public void DeleteScreen(HySString csString)
        //{
        //    HySString csPrcKey = null;
        //    HySScreen csScreen = null;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        if(csPrcKey.Equal(csString) == true)
        //        {
        //           csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //           break;
        //        }
        //    }
        //    m_csScreenTbl.Remove(csString.ToString());
        //    m_csScreenKeyList.Remove(csString);
        //    m_lScreenNum--;
        //    csPrcKey = null;
        //    csScreen = null;
        //}


        ///// <summary><para>method outline:</para>
        ///// <para>指定画面表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> Boolean bRtn = CmndShowScreen( csEvent ) </para>
        ///// </example>
        ///// <param name="csEvent">イベント</param>
        ///// <returns>true:=正常, false:=異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public Boolean CmndShowScreen(HySSysEvent csEvent)
        //{
        //    Boolean bRtn = false;
        //    long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
        //    HySID csID = ((HySEventObject)csEvent).GetSuppID();
        //    HySObjectKind csScreenKind = null;
        //    HySScreen csScreen = null;
        //    HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetSimKind();
        //    csScreenKind = ((HySEventObject)csEvent).GetData() as HySObjectKind;
        //    csScreen = m_csScreenFactory.CreateScreen(csSimKind, csID, csScreenKind);
        //    if (csScreen != null)
        //    {
        //        csScreen.Initialize();
        //        this.SetScreen(csScreen);
        //        csScreen.SetDispEventData(csEvent);
        //        csScreen.ShowScreen();

        //        // 業務に表示完了を通知
        //        HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DISPLY_OK);
        //        csEventObj.SetSimKind(csSimKind);
        //        csEventObj.SetSuppID(csID);
        //        csEventObj.SetSubEventNo(lEventSubNo);
        //        csEventObj.SetData(csScreenKind);
        //        PutEvent(csEventObj);
        //        bRtn = true;
        //    }
        //    return bRtn;
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>指定画面生成</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySScreen csScreen = CreateScreen( csKind,csID,csScreenKind ) </para>
        ///// </example>
        ///// <param name="csKind">種別識別子</param>
        ///// <param name="csID">データ識別子</param>
        ///// <param name="csScreenKind">画面種別識別子</param>
        ///// <returns>スクリーンクラス</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySScreen CreateScreen(HySKind csKind, HySIdentifier csID, HySKind csScreenKind)
        //{
        //    HySScreen csScreen = null;
        //    csScreen = m_csScreenFactory.CreateScreen(csKind, csID, csScreenKind);
        //    return csScreen;
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>指定グラフ画面表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> Boolean bRtn = CmndShowMcDefineScreen( csEvent ) </para>
        ///// </example>
        ///// <param name="csEvent">イベント</param>
        ///// <returns>true:=正常, false:=異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public Boolean CmndShowMcDefineScreen(HySSysEvent csEvent)
        //{
        //    Boolean bRtn = false;
        //    HySScreen csScreen = null;
        //    HySScreen csScreenWk = null;
        //    HySID csID = new HySID("", "", "");
        //    long lEventNo = ((HySEventObject)csEvent).GetEventNo();
        //    long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
        //    if (((HySEventObject)csEvent).GetSuppID() is HySID)
        //    {  // csIDが有効の場合
        //        csID = ((HySEventObject)csEvent).GetSuppID();
        //    }
        //    HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetSimKind();
        //    HySString csPrcID = (HySString)csID.GetString();
        //    HySString csPrcKind = (HySString)csSimKind.GetString();
        //    HySString csPrcKey = csPrcKind + csPrcID;
        //    // イベント別に処理を行う
        //    if (lEventNo == HySEventObject.GRAPH_NOTICE_DISPLY_START)
        //    {  // 画面新規表示の場合
        //        csScreen = this.GetScreen(csPrcKey); // 既存スクリーン有無チェック
        //        if (csScreen == null)
        //        {  // 画面未表示の場合
        //            if (((HySEventObject)csEvent).GetSubData() is HySIdentifier)
        //            {  // モデル管理識別子ある場合
        //                HySID csSubData = ((HySID)((HySEventObject)csEvent).GetSubData());
        //                csPrcID = (HySString)csSubData.GetString();
        //                csPrcKey = csPrcKind + csPrcID;
        //                csScreenWk = this.GetScreen(csPrcKey);
        //                if (csScreenWk != null)
        //                {  // モデル管理スクリーンが有る場合
        //                    csScreen = new _HySDotNetLineGraphScreen(this); // スクリーンＩＤ設定
        //                    csScreen.SetSimKind(csSimKind);                // 種別識別子設定
        //                    csScreen.SetID(csID);                          // データ識別子設定
        //                    ((_HySDotNetLineGraphScreen)csScreen).SetSimKey(csPrcKey);
        //                    ((_HySDotNetLineGraphScreen)csScreen).SetData(((HySEventObject)csEvent).GetData());
        //                    // スクリーン表示
        //                    csScreen.Initialize();              // 画面初期化
        //                    this.SetScreen(csScreen);          // スクリーン実装
        //                    csScreen.SetDispEventData(csEvent); // イベント発行
        //                    csScreen.ShowScreen();              // スクリーン可視化
        //                    // モデル管理画面に表示完了を通知
        //                    if (csScreenWk is HySScreen)
        //                    {  // モデル管理画面有効の場合
        //                        ((_HySDotNetLineGraphScreen)csScreen).GraphOpenEvent(csScreenWk);
        //                    }
        //                    bRtn = true;
        //                }
        //            }
        //        }
        //    }
        //    else if (lEventNo == HySEventObject.GRAPH_NOTICE_DISPLY_UPDATE)
        //    {  // 画面表示更新の場合
        //        csScreen = this.GetScreen(csPrcKey); // 既存スクリーン有無チェック
        //        if (csScreen != null)
        //        {  // 画面表示済みの場合
        //            ((_HySDotNetLineGraphScreen)csScreen).SetData(((HySEventObject)csEvent).GetData());
        //            csScreen.EventCallback(csEvent);
        //            bRtn = true;
        //        }
        //    }
        //    else if (lEventNo == HySEventObject.GRAPH_NOTICE_DISPLY_CLOSE)
        //    {  // 画面消去の場合
        //        if (csPrcID.GetLength() > 0)
        //        {  // データ識別子が有る場合
        //            csScreen = this.GetScreen(csPrcKey); // 既存スクリーン有無チェック
        //            if (csScreen != null)
        //            {  // 画面表示済みの場合
        //                ((_HySDotNetLineGraphScreen)csScreen).GraphCloseEvent(); // 画面終了完了イベント通知
        //                ((_HySDotNetLineGraphScreen)csScreen).CloseScreen();     // スクリーン終了
        //                bRtn = true;
        //            }
        //        }
        //        else
        //        {  // データ識別子が無い場合
        //            if (((HySEventObject)csEvent).GetSubData() is HySIdentifier)
        //            {  // モデル管理識別子ある場合
        //                HySID csSubData = ((HySID)((HySEventObject)csEvent).GetSubData());
        //                csPrcID = (HySString)csSubData.GetString();
        //                csPrcKey = csPrcKind + csPrcID;
        //                for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //                {  // スクリーン件数分繰り返す
        //                    HySString csPrcKeyWk = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //                    csScreenWk = (HySScreen)m_csScreenTbl[csPrcKeyWk.ToString()];
        //                    if (csScreenWk is _HySDotNetLineGraphScreen)
        //                    {  // スクリーン有効の場合
        //                        if (csPrcKey.Equal(((_HySDotNetLineGraphScreen)csScreenWk).GetSimKey()) == true)
        //                        {  // 該当モデル管理画面配下の画面の場合
        //                            ((_HySDotNetLineGraphScreen)csScreenWk).CloseScreen(); // スクリーン終了
        //                            lLp = 0; // カウンタを先頭に戻す（必須）
        //                            bRtn = true;
        //                        }
        //                    }
        //                }
        //            }
        //        }
        //    }
        //    return bRtn;
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>全画面状態更新</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> AllScreenStatusSet( csEvent ) </para>
        ///// </example>
        ///// <param name="csEvent">イベント</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void AllScreenStatusSet(HySSysEvent csEvent)
        //{
        //    HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetSimKind();
        //    HySID csID = ((HySEventObject)csEvent).GetSuppID();
        //    HySString csPrcKind = (HySString)csSimKind.GetString();
        //    HySString csPrcID = (HySString)csID.GetString();
        //    HySString csPrcDestKey = csPrcKind + csPrcID;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        HySString csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        if (csPrcKey.Equal(csPrcDestKey) != true)
        //        {
        //            HySScreen csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //            if (csScreen != null)
        //            {
        //                ((HySDotNetScreen)csScreen).SetScreenStatus(false);            // 該当スクリーンのコールバック処理
        //            }
        //        }
        //    }
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>アクティブスクリーン取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySScreen csScreen = GetActiveScreen( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>アクティブスクリーン</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySScreen GetActiveScreen()
        //{
        //    HySString csPrcKey = null;
        //    HySScreen csScreen = null;
        //    HySScreen csScreenResult = null;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //        if (csScreen != null)
        //        {
        //            if (((HySDotNetScreen)csScreen).IsActive() == true)
        //            {
        //                csScreenResult = csScreen;
        //                break;
        //            }
        //        }
        //    }
        //    return csScreenResult;
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>全スクリーン初期配置表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> InitiateAllScreen( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>アクティブスクリーン</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void InitiateAllScreen()
        //{
        //    HySString csPrcKey = null;
        //    HySScreen csScreen = null;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //        if (csScreen != null)
        //        {
        //            ((HySDotNetScreen)csScreen).InitiateScreen();
        //        }
        //    }
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>全スクリーンノーマライズ表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> NormalizeAllScreen( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>アクティブスクリーン</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void NormalizeAllScreen()
        //{
        //    HySString csPrcKey = null;
        //    HySScreen csScreen = null;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //        if (csScreen != null)
        //        {
        //            ((HySDotNetScreen)csScreen).NormalizeScreen();
        //        }
        //    }
        //}

        ///// <summary><para>method outline:</para>
        ///// <para>全画面をアクティブ化依頼する</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>ActivateAllScreen( )</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void ActivateAllScreen()
        //{
        //    HySString csPrcKey = null;
        //    HySScreen csScreen = null;
        //    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
        //    {
        //        csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
        //        csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
        //        if (csScreen != null)
        //        {
        //            // 画面にアクティブ化を依頼する
        //            ((HySDotNetScreen)csScreen).ActivateForm();
        //        }
        //    }
        //}

        ///// <summary><para>method outline</para>
        ///// <para>キー指定スクリーン取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySScreen csScreen = GetScreen( csKey ) </para>
        ///// </example>
        ///// <param name="csKey">スクリーン識別情報</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySScreen GetScreen(HySString csKey)
        //{
        //    HySScreen csScreen = null;
        //    csScreen = (HySScreen)m_csScreenTbl[csKey.ToString()];
        //    return csScreen;
        //}
                #endregion

        /// <summary><para>method outline:</para>
        /// <para>ビューアサイズの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetViewerSize( ref iX, ref iY ) </para>
        /// </example>
        /// <param name="iX">横幅</param>
        /// <param name="iY">高さ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void GetViewerSize(ref int iX, ref int iY)
        {
            iX = this.m_csMainForm.Width;
            iY = this.m_csMainForm.Height;
        }

    }
}
