﻿// <summary>ソースコード：ＨＹＭＣＯ定義情報クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>DotNetビューア共通情報定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetViewerDefine
    {
        /// <summary>ファイル：終了</summary>
        static public readonly long SYSTEM_EXIT = 10800;
        /// <summary>起動切り替え</summary>
        static public readonly long SYSTEM_CHANGE = 10801;
        //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
        // ショートカットキーイベント通知用
        /// <summary>Ctrl+Z：元に戻す</summary>
        static public readonly long UNDO_EVENT = 20100;
        /// <summary>Ctrl+Y：やり直し</summary>
        static public readonly long REDU_EVENT = 20200;
        /// <summary>Ctrl+X：切り取り</summary>
        static public readonly long CUT_EVENT = 20400;
        /// <summary>Ctrl+C：コピー</summary>
        static public readonly long COPY_EVENT = 20500;
        /// <summary>Ctrl+V：貼り付け</summary>
        static public readonly long PASTE_EVENT = 20600;
        /// <summary>Delキー：削除</summary>
        static public readonly long DELETE_EVENT = 20700;
        /// <summary>Ctrl+A：全て選択</summary>
        static public readonly long ALLSELECT_EVENT = 20900;
        
        //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
        /// <summary>ツール：モデルジェネレータ</summary>
        static public readonly long SYSTEM_MODEL_GENERATOER = 60100;
        
        /// <summary>ツール：結果表示</summary>
        static public readonly long SYSTEM_TOOL_GIS = 60200;

        // 計算結果がDBに登録されている場合、その情報をグラフに表示する。
        /// <summary>ツール：評価画面表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT = 60300;
        /// <summary>ツール：評価画面－基本画面表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT_LINEGRAPH = 60301;
        /// <summary>ツール：評価画面－ＥＸＣＥＬ表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT_EXCEL = 60305;
        /// <summary>ツール：評価画面－ハイエト／ハイドログラフ画面表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT_HYDROHYETO = 60302;
        /// <summary>ツール：評価画面－河川水位縦断図表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT_RIVERBED = 60303;
        /// <summary>ツール：評価画面－ＨＱ曲線図表示</summary>
        static public readonly long SYSTEM_TOOL_REPORT_HQ = 60304;

        // 計算結果がファイルに保存されている場合、その情報をグラフに表示する。
        /// <summary>ツール：評価画面－基本画面表示</summary>
        static public readonly long SYSTEM_TOOL_FILE_LINEGRAPH = 60331;

        // 背景地図表示
        /// <summary>ツール：ＧＩＳ表示－背景地図表示</summary>
        static public readonly long SYSTEM_TOOL_DISP_GIS_BASE = 60350;
        /// <summary>ツール：ＧＩＳ表示－背景地図表示 Ver1.0.0ﾊﾞｰｼﾞｮﾝ処理</summary>
        static public readonly long SYSTEM_TOOL_DISP_GIS_BASE_V1_0_0 = 60351;

        // 計算結果（２次元メッシュ、３次元メッシュ）がDBに登録されている場合、その情報と地図に表示する
        //// <summary>ツール：ＧＩＳ表示－演算結果　２次元メッシュ表示</summary>
        //static public readonly long SYSTEM_TOOL_DISP_GIS_MESH = 60355;
        //// <summary>ツール：ＧＩＳ表示－演算結果　３次元メッシュ表示</summary>
        //static public readonly long SYSTEM_TOOL_DISP_GIS_3MESH = 60356;
        /// <summary>ツール：ＧＩＳ表示－演算結果　２次元メッシュ表示 （DB内検索結果として蓄積されている情報を表示する Ver1.0.0ﾊﾞｰｼﾞｮﾝ処理）</summary>
        static public readonly long SYSTEM_TOOL_DISP_GIS_MESH_DB = 60352;


        // 計算結果（２次元メッシュ、３次元メッシュ）がファイルに保存されている場合、その情報と地図に表示する
        /// <summary>ツール：ＧＩＳ表示－演算結果　２次元メッシュ表示</summary>
        static public readonly long SYSTEM_TOOL_DISP_GIS_FILE_2MESH = 60372;
        //// <summary>ツール：ＧＩＳ表示－演算結果　３次元メッシュ表示</summary>
        //static public readonly long SYSTEM_TOOL_DISP_GIS_FILE_3MESH = 60373;

        /// <summary>ツール：ＧＩＳ表示－地図上任意図形表示</summary>
        static public readonly long SYSTEM_TOOL_DISP_GIS_OBJECT = 60354;

        /// <summary>ツール：ＧＩＳ表示－地図上断面状況編集</summary>
        static public readonly long SYSTEM_TOOL_EDIT_GIS_CROSSSECTION = 60361;

        /// <summary>ツール：河道横断面－横断面データ取得</summary>
        static public readonly long SYSTEM_TOOL_GET_CROSS_SECTION_DATA = 60400;
        /// <summary>ツール：河道横断面－横断面データ編集</summary>
        static public readonly long SYSTEM_TOOL_EDIT_CROSS_SECTION_DATA = 60401;
        /// <summary>ツール：河道横断面－横断面データ管理</summary>
        static public readonly long SYSTEM_TOOL_CTL_CROSS_SECTION_DATA = 60402;
        /// <summary>ツール：統一河川接続</summary>
        static public readonly long SYSTEM_TOOL_CTL_JPRIVER_PROC = 60500;
        /// <summary>ツール：河川・流域ＤＢ－データ取得</summary>
        static public readonly long SYSTEM_TOOL_GET_RIVER_WATERSHED_DATA = 60600;
        /// <summary>ツール：河川・流域ＤＢ－CommonMP標準形式ファイル出力</summary>
        static public readonly long SYSTEM_TOOL_GET_RIVER_WATERSHED_CMPSTD_FORM_FILE = 60700;
        /// <summary>ウィンドウ：初期配置</summary>
        static public readonly long SYSTEM_WINDOW_INITIATE = 70100;
        /// <summary>ウィンドウ：重ねて表示</summary>
        static public readonly long SYSTEM_WINDOW_DISP_PILE = 70200;
        /// <summary>ウィンドウ：プロジェクト管理画面表示</summary>
        static public readonly long SYSTEM_WINDOW_DISP_PRJ_FORM = 70300;
        /// <summary>ウィンドウ：ライブラリ管理画面表示</summary>
        static public readonly long SYSTEM_WINDOW_DISP_LIB_FORM = 70400;

        /// <summary>ヘルプ：操作マニュアル</summary>
        static public readonly long SYSTEM_HELP_OPERATION_MANUAL = 80100;
        /// <summary>ヘルプ：I/Fマニュアル</summary>
        static public readonly long SYSTEM_HELP_INTERFACE_MANUAL = 80200;
        /// <summary>ヘルプ：モデル開発チュートリアル</summary>
        static public readonly long SYSTEM_HELP_MD_TUTORIAL = 80600;
        /// <summary>ヘルプ：モデルジェネレータチュートリアル</summary>
        static public readonly long SYSTEM_HELP_MG_TUTORIAL = 80700;
        /// <summary>ヘルプ：プログラミング環境利用手順書</summary>
        static public readonly long SYSTEM_HELP_PDE_USERS_MANUAL = 80800;
        /// <summary>ヘルプ：CommonMPプロジェクトへ</summary>
        static public readonly long SYSTEM_WINDOW_COMMONMP_WEBSITE = 80300;
        /// <summary>ヘルプ：バージョン情報</summary>
        static public readonly long SYSTEM_WINDOW_VERSION = 80500;
        /// <summary>ヘルプ：データ編集ツール</summary>
        static public readonly long SYSTEM_DATAEDIT_TOOL = 80400;
        /// <summary>ヘルプ：データ編集ツール：DIコンテナ編集</summary>
        static public readonly long SYSTEM_DATAEDIT_TOOL_DICON = 80401;
        /// <summary>ヘルプ：データ編集ツール：メニュー情報編集</summary>
        static public readonly long SYSTEM_DATAEDIT_TOOL_MENU = 80402;
        /// <summary>ヘルプ：ツール起動</summary>
        static public readonly long HYSLAUNCHER_DISP_SCREEN = 80403;
        /// <summary>ヘルプ：ツールのインストール</summary>
        static public readonly long HYSTOOLINSTALL_DISP_SCREEN = 80404;
        /// <summary>ヘルプ：ツールのパッケージ化</summary>
        static public readonly long HYSTOOLEXPORT_DISP_SCREEN = 80405;
        /// <summary>ヘルプ：ツールの削除</summary>
        static public readonly long HYSTOOLDEL_DISP_SCREEN = 80406;

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.3では下記コードを追加する（ツール起動用ランチャー） 
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ===========================
        // ランチャー種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly HySKind HYSLAUNCHER_BUSINESS_KIND = new HySObjectKind("HySLauncherBusiProcedure");
        /// <summary>画面ファクトリーID：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier HYSLAUNCHER_FACTORY_ID_SCREEN = new HySID("HySLauncherScreenFactory");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier HYSLAUNCHER_FACTORY_ID_VIEWRJOB = new HySID("HySLauncherViewerJobFactory");

        // ===========================
        // ランチャー画面識別子関係
        // ===========================
        /// <summary>拡張ツール起動用画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind HYSLAUNCHER_SCREEN = new HySObjectKind("HySUserToolLauncherScreen");

        // =================================
        // CommonMPシステム　ファクトリ識別子
        // =================================
        /// <summary>ビューアファクトリー</summary>
        //static public readonly HySIdentifier FACTORY_ID_VIEWR = new HySID("dotNetVIEWER", "Factory", "Viewer");
        static public readonly HySIdentifier FACTORY_ID_VIEWR = new HySID("dotNetVIEWER"+ "Factory"+ "Viewer");

        # region マスク処理変更
        //// =======================
        //// マスク制御対象メニュー
        //// =======================
        ///// <summary>ファイル</summary>
        //static public readonly HySString MENU_FILE = new HySString("ファイル(&F)");
        ///// <summary>ファイル</summary>
        //static public readonly int MENU_FILE_INDEX = 1;
        ///// <summary>ファイル</summary>
        //static public readonly HySString MENU_FILE_REG = new HySString("ＤＢ登録(&R)");
        ///// <summary>ファイル</summary>
        //static public readonly int MENU_FILE_REG_INDEX = 1;
        ///// <summary>終了</summary>
        //static public readonly HySString MENU_SYSTEM_END = new HySString("終了(&X)");
        ///// <summary>終了</summary>
        //static public readonly int MENU_SYSTEM_END_INDEX = 1;
        ///// <summary>演算中断保存</summary>
        //static public readonly HySString MENU_CAL_SAVE = new HySString("演算中断保存(&C)");
        ///// <summary>演算中断保存</summary>
        //static public readonly int MENU_CAL_SAVE_INDEX = 1;
        ///// <summary>開く</summary>
        //static public readonly HySString MENU_CAL_SAVE_OPEN = new HySString("開く(&O)...");
        ///// <summary>開く</summary>
        //static public readonly int MENU_CAL_SAVE_OPEN_INDEX = 1;
        ///// <summary>上書き保存</summary>
        //static public readonly HySString MENU_CAL_SAVE_NEW = new HySString("上書き保存(&S)");
        ///// <summary>上書き保存</summary>
        //static public readonly int MENU_CAL_SAVE_NEW_INDEX = 1;
        ///// <summary>名前を付けて保存</summary>
        //static public readonly HySString MENU_CAL_SAVE_UPDATE = new HySString("名前を付けて保存(&A)...");
        ///// <summary>名前を付けて保存</summary>
        //static public readonly int MENU_CAL_SAVE_UPDATE_INDEX = 1;
        ///// <summary>構造定義ファイル</summary>
        //static public readonly HySString MENU_STRUCT_FILE = new HySString("構造定義ファイル(&F)");
        ///// <summary>構造定義ファイル</summary>
        //static public readonly int MENU_STRUCT_FILE_INDEX = 1;
        ///// <summary>読込み</summary>
        //static public readonly HySString MENU_STRUCT_READ = new HySString("読込み(&I)...");
        ///// <summary>読込み</summary>
        //static public readonly int MENU_STRUCT_READ_INDEX = 1;
        ///// <summary>書出し(接続情報のみ)</summary>
        //static public readonly HySString MENU_STRUCT_WRITE_SIMPLE = new HySString("書出し(接続情報のみ)(&O)...");
        ///// <summary>書出し(接続情報のみ)</summary>
        //static public readonly int MENU_STRUCT_WRITE_SIMPLE_INDEX = 1;
        ///// <summary>書出し(詳細情報付き)</summary>
        //static public readonly HySString MENU_STRUCT_WRITE_ALL = new HySString("書出し(詳細情報付き:一括)(&A)...");
        ///// <summary>書出し(詳細情報付き)</summary>
        //static public readonly int MENU_STRUCT_WRITE_ALL_INDEX = 1;
        ///// <summary>書出し(詳細情報付き)</summary>
        //static public readonly HySString MENU_STRUCT_WRITE_DEVIDE = new HySString("書出し(詳細情報付き:分割)(&D)...");
        ///// <summary>書出し(詳細情報付き)</summary>
        //static public readonly int MENU_STRUCT_WRITE_DEVIDE_INDEX = 1;
        ///// <summary>編集</summary>
        //static public readonly HySString MENU_EDIT = new HySString("編集(&E)");
        ///// <summary>編集</summary>
        //static public readonly int MENU_EDIT_INDEX = 1;
        ///// <summary>プロジェクト管理</summary>
        //static public readonly HySString MENU_PROJECT = new HySString("プロジェクト管理(&P)");
        ///// <summary>ライブラリ管理</summary>
        //static public readonly int MENU_PROJECT_INDEX = 1;
        ///// <summary>ライブラリ管理</summary>
        //static public readonly HySString MENU_LIBRARY = new HySString("ライブラリ管理(&L)");
        ///// <summary>ライブラリ管理</summary>
        //static public readonly int MENU_LIBRARY_INDEX = 1;
        ///// <summary>モデル管理</summary>
        //static public readonly HySString MENU_MODEL = new HySString("モデル管理(&M)");
        ///// <summary>モデル管理</summary>
        //static public readonly int MENU_MODEL_INDEX = 1;
        ///// <summary>計算開始・再開</summary>
        //static public readonly HySString MENU_CAL_START = new HySString("計算開始・再開(&S)");
        ///// <summary>計算開始・再開</summary>
        //static public readonly int MENU_CAL_START_INDEX = 1;
        ///// <summary>計算中断</summary>
        //static public readonly HySString MENU_CAL_PAUSE = new HySString("計算中断(&P)");
        ///// <summary>計算中断</summary>
        //static public readonly int MENU_CAL_PAUSE_INDEX = 1;
        ///// <summary>計算停止</summary>
        //static public readonly HySString MENU_CAL_STOP = new HySString("計算停止(&A)");
        ///// <summary>計算停止</summary>
        //static public readonly int MENU_CAL_STOP_INDEX = 1;
        ///// <summary>計算リセット</summary>
        //static public readonly HySString MENU_CAL_RESET = new HySString("計算リセット(&R)");
        ///// <summary>計算リセット</summary>
        //static public readonly int MENU_CAL_RESET_INDEX = 1;
        ///// <summary>制御パラメータ設定</summary>
        //static public readonly HySString MENU_CAL_PARAMETERSET = new HySString("制御パラメータ設定(&P)");
        ///// <summary>制御パラメータ設定</summary>
        //static public readonly int MENU_CAL_PARAMETERSET_INDEX = 1;
        # endregion

        /// <summary>マスク用イベント数</summary>
        static public readonly int EVENT_NUM = 12;

        /// <summary>マスク対象イベント</summary>
        public enum EventKind
        {
            /// <summary>イベント無</summary>
            NOEVENT = -1,
            /// <summary>システム立ち上げ時</summary>
            SYSTEMSTART = 0,
            /// <summary>イニシャル状態</summary>
            INITIALIZE,
            /// <summary>演算中</summary>
            CAL_START,
            /// <summary>演算中断</summary>
            CAL_PAUSE,
            /// <summary>演算終了</summary>
            CAL_END,
            /// <summary>演算停止</summary>
            CAL_STOP,
            /// <summary>他モデル演算中</summary>
            CAL_MULTI,
            /// <summary>処理中</summary>
            IN_PROCESS,
            /// <summary>処理終了</summary>
            END_PROCESS,
            /// <summary>外部DBツール起動中</summary>
            EXTDBTOOL_RUN = 11,
            /// <summary>外部DBツール起動中</summary>
            EXTDBTOOL_RSD_RUN,
            # region 再検討の為コメント化
            ///// <summary>ライブラリ削除開始</summary>
            //LIBDEL_START,
            # endregion
            /// <summary>外部DBツール起動中</summary>
            EXTDBTOOL_RW_RUN,
            /// <summary>外部DBツール停止中</summary>
            EXTDBTOOL_EXIT = 41,
            /// <summary>外部DBツール停止中</summary>
            EXTDBTOOL_RSD_EXIT,
            /// <summary>外部DBツール停止中</summary>
            EXTDBTOOL_RW_EXIT
        }

        /// <summary>GIS計算結果ファイル表示選択画面</summary>
        static public readonly HySKind GIS_RESULT_CTL_SCREEN = new HySObjectKind("GISResultDispCtlScreen");

    }
}
