﻿// <summary>ドットネットビューア生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ドットネットビューア生成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySDotNetViewerFactory : HySFactoryMono , HySViewerFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetViewerFactory csFactory = new HySDotNetViewerFactory( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDotNetViewerFactory 生成されたコンストラクタ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetViewerFactory()
        {
            this.SetFactoryID(HySDotNetViewerDefine.FACTORY_ID_VIEWR);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューアクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewer csViewer = CreateViewer( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>HySViewer ビューアクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySViewer CreateViewer(HySIdentifier csID)
        {
            return (HySDotNetViewer)new HySDotNetViewer();
        }
    }
}
