﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2008/10/01][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetViewerJob : HySViewerJob
    {
        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID;

        /// <summary>ビューア</summary>
        protected HySViewer m_csViewer;

        /// <summary>スクリーンファクトリ</summary>
        protected HySScreenFactory m_csScreenFactory;

        /// <summary>フォームファクトリ</summary>
        protected HySViewFormFactory m_csViewFormFactory;

        ///// <summary>終了チェックフラグ</summary>
        //protected bool m_bCheckEndFlg = true;

        /// <summary>搭載スクリーン数</summary>
        protected long m_lScreenNum = 0;

        /// <summary>スクリーン識別管理ハッシュテーブル</summary>
        protected Hashtable m_csScreenTbl = null;
        //protected Hashtable m_csScreenTbl = new Hashtable();

        /// <summary>スクリーン識別キー管理リスト</summary>
        protected IList m_csScreenKeyList = null;
        //protected IList m_csScreenKeyList = new ArrayList();

        /// <summary><para>method outline:</para>
        /// <para>スクリーン取り込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadScreen( csPrc ) </para>
        /// </example>
        /// <param name="csPrc">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void LoadScreen(HySScreen csPrc)
        {
            csPrc.SetViewerJob(this);
            csPrc.SetViewer(m_csViewer);
            // 種別識別子とデータ識別子でユニークキー作成
            HySIdentifier csDataID = csPrc.GetID();
            HySKind csSimKind = csPrc.GetSimKind();

            HySString csPrcID = (HySString)csDataID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();

            HySString csPrcKey = csPrcKind + csPrcID; // シミュレーション種別＋ＩＤでキー情報を作成
            
            m_csScreenTbl[csPrcKey.ToString()] = csPrc;
            m_lScreenNum += 1;
            m_csScreenKeyList.Add(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreen( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetScreen(HySScreen csScreen)
        {
            this.LoadScreen(csScreen);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューアを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetViewr( csViewr ) </para>
        /// </example>
        /// <param name="csViewr">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetViewer(HySViewer csViewr)
        {
            m_csViewer = csViewr;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreenFactory( csViewr ) </para>
        /// </example>
        /// <param name="csScreenFactory">スクリーンファクトリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetScreenFactory(HySScreenFactory csScreenFactory)
        {
            m_csScreenFactory = csScreenFactory;
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームファクトリを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetViewFormFactory( csViewrFormFactory ) </para>
        /// </example>
        /// <param name="csViewFormFactory">フォームファクトリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetViewFormFactory(HySViewFormFactory csViewFormFactory)
        {
            m_csViewFormFactory = csViewFormFactory;
        }

        ///// <summary><para>method outline:</para>
        ///// <para>終了チェック要否取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> Boolean bRtn = DoEndCheck( ) </para>
        ///// </example>
        ///// <param name="csEvent">送られたイベント</param>
        ///// <returns>true:=終了判定要, false:=終了判定不要</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public Boolean DoEndCheck()
        //{
        //    return m_bCheckEndFlg;
        //}

        /// <summary><para>method outline:</para>
        /// <para>全画面メニューコール</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AllScreenMenuCall( lCallBackNo ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void AllScreenMenuCall(long lCallBackNo)
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);   // 該当スクリーンのコールバック処理
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>画面クローズ時のScreen削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteScreen( csString )</para>
        /// </example>
        /// <param name="csString">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        /// </remarks>
        virtual public void DeleteScreen(HySString csString)
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                if (csPrcKey.Equal(csString) == true)
                {
                    csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                    break;
                }
            }
            if (csScreen != null)
            {
                m_csScreenTbl.Remove(csString.ToString());
                m_csScreenKeyList.Remove(csString);
                m_lScreenNum--;
                csScreen.Terminate();
                csPrcKey = null;
                csScreen = null;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean CmndShowScreen(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            //HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetSubData() as HySObjectKind;

            HySScreen csScreen = null;
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetData() as HySObjectKind;
            /****/
            csScreen = this.GetScreen(csSimKind, csID);
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(csSimKind, csID, csScreenKind);
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    //csScreen.SetViewer(this.m_csViewer);
                    //csScreen.SetViewerJob(this);
                    csScreen.Initialize();
                    this.SetScreen(csScreen);
                }
            }
            /****/
            if (csScreen != null)
            {  // スクリーンが有効の場合
                //csScreen.Initialize();
                //this.SetScreen(csScreen);
                csScreen.SetDispEventData(csEvent);
                csScreen.ShowScreen();
                
                // 業務に表示完了を通知
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DISPLY_OK);
                csEventObj.SetToSimKind(csSimKind);
                csEventObj.SetSuppID(csID);
                csEventObj.SetSubEventNo(lEventSubNo);
                csEventObj.SetData(csScreenKind);
                //PutEvent(csEventObj);
                m_csViewer.PutEvent(csEventObj);
                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定画面生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimKind">シミュレーション識別情報</param>
        /// <param name="csID">データ識別子</param>
        /// <param name="csScreenKind">画面種別識別子</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csScreen = null;
            csScreen = m_csScreenFactory.CreateScreen(csSimKind, csID, csScreenKind);
            return csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>全画面状態更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AllScreenStatusSet( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void AllScreenStatusSet(HySSysEvent csEvent)
        {
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetSubData() as HySObjectKind;

            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcID = (HySString)csID.GetString();

            HySString csPrcDestKey = csPrcKind + csPrcID;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                if (csPrcKey.Equal(csPrcDestKey) != true)
                {
                    csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                    if (csScreen != null)
                    {
                        ((HySDotNetScreen)csScreen).SetScreenStatus(false);            // 該当スクリーンのコールバック処理
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブスクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetActiveScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetActiveScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            HySScreen csScreenResult = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    if (((HySDotNetScreen)csScreen).IsActive() == true)
                    {
                        csScreenResult = csScreen;
                        break;
                    }
                }
            }
            return csScreenResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーカスオンスクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetFocusOnScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetFocusOnScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            HySScreen csScreenResult = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    if (((HySDotNetScreen)csScreen).IsFocusOn() == true)
                    {
                        csScreenResult = csScreen;
                        break;
                    }
                }
            }
            return csScreenResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>全スクリーン初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateAllScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void InitiateAllScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).InitiateScreen();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>全スクリーンノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NormalizeAllScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NormalizeAllScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).NormalizeScreen();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>全画面をアクティブ化依頼する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateAllScreen( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void ActivateAllScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    // 画面にアクティブ化を依頼する
                    ((HySDotNetScreen)csScreen).ActivateForm();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存済みチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckProjectSaved( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 保存済み、false : 未保存</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean CheckProjectSaved()
        {
            Boolean bRtn = true;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    // 保存済みチェック
                    if ((bRtn = ((HySDotNetScreen)csScreen).IsSavedProject()) == false)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline</para>
        /// <para>キー指定スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetScreen( csKey ) </para>
        /// </example>
        /// <param name="csKey">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetScreen(HySString csKey)
        {
            HySScreen csScreen = null;
            csScreen = (HySScreen)m_csScreenTbl[csKey.ToString()];
            return csScreen;
        }
        /// <summary><para>method outline</para>
        /// <para>キー指定スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetScreen( csSimKind, csScreenDataID ) </para>
        /// </example>
        /// <param name="csSimKind">シミュレーション識別情報</param>
        /// <param name="csScreenDataID">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetScreen(HySKind csSimKind, HySIdentifier csScreenDataID)
        {
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcID = (HySString)csScreenDataID.GetString();           
            HySString csPrcKey = csPrcKind + csPrcID;

            return this.GetScreen(csPrcKey);
        }
 
        /// <summary><para>method outline:</para>
        /// <para>モデル演算中フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = GetCalculationFlg( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 演算中、false : 非演算</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean GetCalculationFlg()
        {
            Boolean bRtn = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    bRtn = ((HySDotNetScreen)csScreen).GetCalculationFlg();
                    csScreen = null;
                    if (bRtn == true)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントに対応しメニューマスクを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeMenuStatus( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void ChangeMenuStatus(HySSysEvent csEvent)
        {
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS ||
                   lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                   lEventNo == HySEventObject.NOTICE_RENEW_SIMULATION ||
                   lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                   lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION ||
                   lEventNo == HySEventObject.NOTICE_DB_OK ||
                   lEventNo == HySEventObject.NOTICE_DB_NG)
            {
                if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)                 // 計算開始
                {
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_START);
                    DispStatus((HySEventObject)csEvent);
                }
                else if (lEventNo != HySEventObject.NOTICE_REPORT_SIMU_PROGRESS)
                {
                    if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION)             // 計算中断
                    {
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_PAUSE);
                        if (GetCalculationFlg() == true)
                        {
                            ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                        }
                    }
                    else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                              lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                             lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)     // 計算終了(強制終了)
                    {
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_END);
                        if (GetCalculationFlg() == true)
                        {
                            ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                        }
                        DispStatus((HySEventObject)csEvent);
                    }
                    else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
                             lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                             lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)   // 未計算
                    {
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.INITIALIZE);
                        if (GetCalculationFlg() == true)
                        {
                            ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                        }
                    }
                    DispStatus((HySEventObject)csEvent);
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE)
                {
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN);
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_RUN);
                    //((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).NoticeDBToolStateFlg(true);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
                {
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_EXIT);
                    HySDotNetViewerDefine.EventKind eEventKind = ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).LastMaskPatern();
                    //((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).NoticeDBToolStateFlg(false);
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(eEventKind);
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE)
                {
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN);
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_RUN);
                    //((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).NoticeDBToolStateFlg(true);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
                {
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_EXIT);
                    HySDotNetViewerDefine.EventKind eEventKind = ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).LastMaskPatern();
                    //((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).NoticeDBToolStateFlg(false);
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(eEventKind);
                }
            }
            # region 再検討の為コメント化
            //else if (lEventNo == HySEventObject.NOTICE_LIBDEL_START)
            //{
            //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.LIBDEL_START);
            //}
            # endregion
        }

        /// <summary><para>method outline:</para>
        /// <para>ステータス表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispStatus( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void DispStatus(HySEventObject csEvent)
        {
            ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).DispStatus(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csProjectName = GetProjectName( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>HySString：プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySString GetProjectName(HySSysEvent csEvent)
        {
            HySString csName = new HySString("");
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySScreen csScreen = GetScreen(csSimKind, csID);
            if (csScreen != null)
            {
                csName = ((HySDotNetScreen)csScreen).GetProjectName( );
            }
            return csName;
        }


        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public Boolean ExitOK();
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public Boolean Initialize();
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public Boolean Terminate();
        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        abstract public Boolean EventCallback(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff);

        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( csScreenKind, csScreenID) </para>
        /// </example>
        /// <param name="csScreenKind">スクリーン種別</param>
        /// <param name="csScreenID">スクリーン個別ＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CmndShowScreen(HySObjectKind csScreenKind, HySID csScreenID)
        {
            HySScreen csScreen = null;
            csScreen = this.GetScreen(m_csSimKindID, csScreenID);
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(m_csSimKindID, csScreenID, csScreenKind);
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    //csScreen.SetViewer(this.m_csViewer);
                    //csScreen.SetViewerJob(this);
                    csScreen.Initialize();
                    this.SetScreen(csScreen);
                }
            }
            if (csScreen != null)
            {  // スクリーンが有効の場合
                csScreen.ShowScreen();
            }
            return csScreen;
        }
        /// <summary><para>method outline</para>
        /// <para>画面クローズ時のScreen削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteScreen( csScreen )</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        /// </remarks>
        virtual public void DeleteScreen(HySScreen csScreen)
        {
            HySString csPrcKey = new HySString(m_csSimKindID.ToString() + csScreen.GetID().ToString()); // シミュレーション種別＋ＩＤでユニークキー情報を作成する
            this.DeleteScreen(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeUndoEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeRedoEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeCutEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeCopyEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticePasteEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeDeleteEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                // フォーカスオンのスクリーンがある場合のみ、通知する
                csScreeen.NoticeAllSelectEvent();
            }
        }

    }
}
