﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.CompilerServices;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

using CommonMP.HYSSOP.CoreImpl.HSTools.HSExecutor;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア共通処理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    internal class HySDotNetViewerSystemJob : HySDotNetViewerJob
    {
        ///// <summary>メッセージタイトル </summary>
        //static private readonly string MSGBOX_TITLE = "水・物質循環解析ソフトウェア共通基盤　CommonMP";
		/// <summary>メッセージタイトル『水・物質循環解析ソフトウェア共通基盤　CommonMP』 </summary>
        static private readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_COMMON_MP");
        /// <summary>メッセージ『シュミレーションモデルを計算中のため、閉じることができません。』</summary>
        static private readonly string MSGBOX_MSG_WARNING_SIMULATION_EXECUTE = HysMessage.GetString("HYS_MSG_WARNING_SIMULATION_EXECUTE");
        /// <summary>メッセージ『保存されていないプロジェクトがあります。\nシステムを終了してよろしいですか?』</summary>
        static private readonly string MSGBOX_MSG_QUESTION_CONFILM_END = HysMessage.GetString("HYS_MSG_QUESTION_CONFILM_END");

        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary>バージョン情報ダイアログ</summary>
        HySDotNetAboutBox m_csAboutBox = null;

        /// <summary>起動切り替えコマンドライン引数</summary>
        protected string m_sArguments = null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewerSystemJob csJob = new HySDotNetViewerSystemJob( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetViewerSystemJob()
        {
            m_csSimKindID = HySDefine.COMMON_SYS_BUSIPROCEDURE;
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
            // Ver1.2追加　起動切り替え
            HySString csConfFileName = HySEnvInf.GetEnvInf(new HySString("SYSTEM_CHANGE_CONFIG_FILENAME"));
            if ((object)csConfFileName != null)
            {
                m_sArguments = "-c " + csConfFileName.ToString();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>
        /// ＝０：正常、≠０：異常、
        /// ＝１０：システム終了問い合わせで、オペレータが終了せずを選択した時
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            HySEventObject csEventObj;

            if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_EXIT)
            {
                // システム終了

                //システム終了処理に入る前に、カレントデータの保存状態をチェックしする。
                //未保存の場合は、保存操作を促すメッセージを出力して、処理を中止する。
                //保存済みのとき、以下の処理に進む。
                if (((HySDotNetViewer)m_csViewer).GetCalculationFlg() == true)
                {
                    //MessageBox.Show("演算中のプロジェクトがあります", MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSGBOX_MSG_WARNING_SIMULATION_EXECUTE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
                else
                {
                    if (((HySDotNetViewer)m_csViewer).CheckProjectSaved() == true)
                    {
                        csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SHUTDOWN_SYSTEM);
                        csEventObj.SetToSimKind(HySDefine.COMMON_SYS_BUSIPROCEDURE);
                        m_csViewer.PutEvent(csEventObj);
                        //m_bCheckEndFlg = false;
                    }
                    else
                    {
                        //DialogResult result = MessageBox.Show("保存されていないプロジェクトがあります。\nシステムを終了してよろしいですか?", MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2);//2009.12.15
                        DialogResult result = MessageBox.Show(MSGBOX_MSG_QUESTION_CONFILM_END, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                        if (result == DialogResult.Yes)
                        {
                            csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SHUTDOWN_SYSTEM);
                            csEventObj.SetToSimKind(HySDefine.COMMON_SYS_BUSIPROCEDURE);
                            m_csViewer.PutEvent(csEventObj);
                            //m_bCheckEndFlg = false;
                        }
                        else
                        {
                            lRtn = 10;
                        }
                    }
                }
                //DialogResult result = MessageBox.Show("システムを終了しますか?", MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                //if (result == DialogResult.Yes)
                //{
                //    csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SHUTDOWN_SYSTEM);
                //    csEventObj.SetSimKind(HySDefine.COMMON_BUSIPROCEDURE);
                //    m_csViewer.PutEvent(csEventObj);
                //    m_bCheckEndFlg = false;
                //}
            }
            //else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_CHANGE_STD || lCallBackNo == HySDotNetViewerDefine.SYSTEM_CHANGE_STG)
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_CHANGE)
            {   // システム切り替え


                HySExcecutor csExecutor = new HySExcecutor();
                // 終了時動作のｘｍｌ作成の
                csExecutor.WriteXML(new HySString("..\\temp\\exit.xml"));

                //m_lChangeEventNo = lCallBackNo;
                this.MenuCallBack(HySDotNetViewerDefine.SYSTEM_EXIT, false);
            }
            # region 削除
            //if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_TOOL_GIS)
            //{   // 結果表示

            //    // start of テスト用仮処理
            //    HySGISDispBaseMapScreen csBaseMapScreen = this.GetScreen(HySDefine.DISP_FORM_GIS_BASEMAP.ToString());
            //    if (csBaseMapScreen == null)
            //    {
            //        csBaseMapScreen = this.CreateScreen(new HySObjectKind(), new HySID(), HySDefine.DISP_FORM_GIS_BASEMAP);
            //    }
            //    // end of テスト用仮処理
            //    csEventObj = new HySEventObject(HySSysEvent.OBJID_GISCONTROLLER, HySEventObject.CMND_GIS_COMMON);
            //    HySString csGISEngine = HySEnvInf.GetEnvInf(new HySString("GISENGINENAME"));
            //    csEventObj.SetSimKind(new HySObjectKind(csGISEngine));
            //    m_csViewer.PutEvent(csEventObj);
            //}
            # endregion
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_MODEL_GENERATOER)
            {   // ＧＩＳ起動ならば
                // モデルジェネレータ
                //csEventObj = new HySEventObject(HySSysEvent.OBJID_GISCONTROLLER, HySEventObject.CMND_GIS_COMMON);
                //HySString csGISEngine = HySEnvInf.GetEnvInf(new HySString("GISENGINENAME"));
                //csEventObj.SetSimKind(new HySObjectKind(csGISEngine));
                //m_csViewer.PutEvent(csEventObj);
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_TOOL_CTL_JPRIVER_PROC)
            {   // 統一河川起動
                HySString csJPRiverProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("JPR_JPRIVERPATH_PROC"));
                HySFile csFile = new HySFile(csJPRiverProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csJPRiverProc.ToString());

                    csProcessInfo.FileName = csJPRiverProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_INITIATE)
            {   // ウィンドウ：初期配置
                ((HySDotNetViewer)m_csViewer).InitiateAllScreen();
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_DISP_PILE)
            {   // ウィンドウ：重ねて表示
                ((HySDotNetViewer)m_csViewer).NormalizeAllScreen();
                ((HySDotNetViewer)m_csViewer).GetMainForm().LayoutMdi(MdiLayout.Cascade);
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_DISP_PRJ_FORM)
            {   // ウィンドウ：プロジェクト管理画面表示
                if (bCheckOnOff == false)
                {
                    // 非表示
                    ((HySDotNetViewer)m_csViewer).GetMainForm().OwnedForms[0].Hide();
                }
                else
                {
                    // 表示
                    ((HySDotNetViewer)m_csViewer).GetMainForm().OwnedForms[0].Show();
                }
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_DISP_LIB_FORM)
            {   // ウィンドウ：ライブラリ管理画面表示
                if (bCheckOnOff == false)
                {
                    // 非表示
                    ((HySDotNetViewer)m_csViewer).GetMainForm().OwnedForms[1].Hide();
                }
                else
                {
                    // 表示
                    ((HySDotNetViewer)m_csViewer).GetMainForm().OwnedForms[1].Show();
                }
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_HELP_INTERFACE_MANUAL)
            {   // ヘルプ：I/Fマニュアル
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("HELPFILENAME"));
                //Help.ShowHelp(((HySDotNetViewer)m_csViewer).GetMainForm().Parent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_HELP_OPERATION_MANUAL)
            {   // ヘルプ：CommonMPヘルプ
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("OPERATION_MANUAL_FILENAME"));
                //Help.ShowHelp(((HySDotNetViewer)m_csViewer).GetMainForm().Parent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_HELP_MD_TUTORIAL)
            {   // ヘルプ：モデル開発チュートリアル
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("MD_TUTORIAL_FILENAME"));
                //Help.ShowHelp(((HySDotNetViewer)m_csViewer).GetMainForm().Parent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_HELP_MG_TUTORIAL)
            {   // ヘルプ：モデルジェネレータチュートリアル
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("MG_TUTORIAL_FILENAME"));
                //Help.ShowHelp(((HySDotNetViewer)m_csViewer).GetMainForm().Parent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_HELP_PDE_USERS_MANUAL)
            {   // ヘルプ：プログラミング環境利用手順書
                HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("PDE_USERS_MANUAL_FILENAME"));
                //Help.ShowHelp(((HySDotNetViewer)m_csViewer).GetMainForm().Parent, HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + csHelpFile.ToString());
                Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_COMMONMP_WEBSITE)
            {   // ヘルプ：CommonMPプロジェクトへ
                HySString csUrl = HySEnvInf.GetEnvInf(new HySString("COMMONMP_URL"));
                Process.Start(csUrl.ToString());
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_WINDOW_VERSION)
            {   // ヘルプ：バージョン情報
                if (m_csAboutBox == null)
                {
                    // バージョン情報ダイアログ生成
                    m_csAboutBox = new HySDotNetAboutBox();
                }
                m_csAboutBox.ShowDialog();
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_DATAEDIT_TOOL_DICON)
            {   // ＤＩコンテナ編集画面起動
                HySString csDiconEditorProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("HS_DICONTAINER_PATH"));
                HySFile csFile = new HySFile(csDiconEditorProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csDiconEditorProc.ToString());

                    csProcessInfo.FileName = csDiconEditorProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_DATAEDIT_TOOL_MENU)
            {   // メニュー編集画面起動
                HySString csMenuEditorProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("HS_HSMENUEDIDOR_PATH"));
                HySFile csFile = new HySFile(csMenuEditorProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csMenuEditorProc.ToString());

                    csProcessInfo.FileName = csMenuEditorProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else if (lCallBackNo == HySDotNetViewerDefine.HYSTOOLINSTALL_DISP_SCREEN)
            {
                // ツールのインストール画面起動
                HySString csPackageImportProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("HS_HSPACKAGEIMPORT_PATH"));
                HySFile csFile = new HySFile(csPackageImportProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csPackageImportProc.ToString());

                    csProcessInfo.FileName = csPackageImportProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else if (lCallBackNo == HySDotNetViewerDefine.HYSTOOLEXPORT_DISP_SCREEN)
            {
                // ツールのパッケージ化画面起動
                HySString csToolExportProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("HS_HSTOOLEXPORT_PATH"));
                HySFile csFile = new HySFile(csToolExportProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csToolExportProc.ToString());

                    csProcessInfo.FileName = csToolExportProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else if (lCallBackNo == HySDotNetViewerDefine.HYSTOOLDEL_DISP_SCREEN)
            {
                // ツールの削除画面起動
                HySString csToolDeleteProc = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf(new HySString("HS_HSTOOLDELETE_PATH"));
                HySFile csFile = new HySFile(csToolDeleteProc);
                if (csFile.Exist() == true)
                {
                    ProcessStartInfo csProcessInfo = new ProcessStartInfo();
                    DirectoryInfo csWorkDir = Directory.GetParent(csToolDeleteProc.ToString());

                    csProcessInfo.FileName = csToolDeleteProc.ToString();
                    csProcessInfo.WorkingDirectory = csWorkDir.ToString();
                    Process.Start(csProcessInfo);
                }
                csFile = null;
            }
            else
            {
                lRtn = -1;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            m_bWorkFlg = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            if (m_bWorkFlg == true)
            { return false; }
            else
            { return true; }
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            if (lEventNo == HySEventObject.CMND_EXIT_SYSTEM)
            {
                try
                {
                    Process process = new Process();
                    process.StartInfo.RedirectStandardOutput = true;  // コンソールを開かなくする
                    process.StartInfo.CreateNoWindow = true; // コンソール・ウィンドウを開かない
                    process.StartInfo.UseShellExecute = false; // シェル機能を使用しない （必須）
                    process.StartInfo.FileName = "HSExecutor.exe";
                    process.StartInfo.Arguments = "-c ..\\temp\\exit.xml";
                    process.Start();
                }
                catch
                {
                    // Do Nothing
                }
                // アプリケーションの終了
                Application.Exit();

                bRtn = true;
            }
            return bRtn;
        }
    }
}
