﻿// <summary>ソースコード：ビューアメニューアイテム管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアメニューアイテム管理クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySViewerMenuCtl : HySRoot
    {
        /// <summary> XMLタグ　menulist </summary>
        static public readonly string xml_MENULIST = "menulist";
        /// <summary> XMLタグ　mainmenu </summary>
        static public readonly string xml_MAINMENU = "mainmenu";
        /// <summary> XMLタグ　menuitem </summary>
        static public readonly string xml_MENUITEM = "menuitem";
        /// <summary> XMLタグ　submenu </summary>
        static public readonly string xml_SUBMENU = "submenu";
        /// <summary> XMLタグ　text </summary>
        static public readonly string xml_TEXT = "text";
        /// <summary> XMLタグ　level </summary>
        static public readonly string xml_LEVEL = "level";
        /// <summary> XMLタグ　callback </summary>
        static public readonly string xml_CALLBACK = "callback";
        /// <summary> XMLタグ　separator </summary>
        static public readonly string xml_SEPARATOR = "separator";
        /// <summary> XMLタグ　busiprocno </summary>
        static public readonly string xml_BUSIPROCNO = "busiprocno";
        /// <summary> XMLタグ　kind </summary>
        static public readonly string xml_KIND = "kind";
        /// <summary> XMLタグ　windowslist </summary>
        static public readonly string xml_WINDOWSLIST = "windowslist";
        /// <summary> XMLタグ　image </summary>
        static public readonly string xml_IMAGE = "image";
        /// <summary> XMLタグ　shortcut </summary>
        static public readonly string xml_SHORTCUT = "shortcut";
        /// <summary> XMLタグ　checkon </summary>
        static public readonly string xml_CHECKON = "checkon";
        /// <summary> XMLタグ　mask </summary>
        static public readonly string xml_MASK = "mask";
        /// <summary> XMLタグ　mask </summary>
        static public readonly string xml_EVENT = "event";
        /// <summary> XMLタグ　useredit </summary>
        static public readonly string xml_USEREDIT = "useredit";
        /// <summary> XMLタグ　menudisp </summary>
        static public readonly string xml_MENUDISP = "menudisp";

        /// <summary> XML属性　value </summary>
        static public readonly string xml_VALUE = "value";
        /// <summary> XML属性　flg </summary>
        static public readonly string xml_FLG = "flg";
        /// <summary> XML属性　no </summary>
        static public readonly string xml_NO = "no";
        /// <summary> XML属性　name </summary>
        static public readonly string xml_NAME = "name";
        /// <summary> XML属性　Default </summary>
        static public readonly string xml_DEFAULT = "Default";
        /// <summary> XML属性　ptn1 </summary>
        static public readonly string xml_PTN = "ptn";
        /// <summary> XML属性　ptn1 </summary>
        static public readonly string xml_PTN1 = "ptn1";
        /// <summary> XML属性　ptn2 </summary>
        static public readonly string xml_PTN2 = "ptn2";
        /// <summary> XML属性　ptn3 </summary>
        static public readonly string xml_PTN3 = "ptn3";
        /// <summary> XML属性　ptn4 </summary>
        static public readonly string xml_PTN4 = "ptn4";
        /// <summary> XML属性　ptn5 </summary>
        static public readonly string xml_PTN5 = "ptn5";
        /// <summary> XML属性　ptn6 </summary>
        static public readonly string xml_PTN6 = "ptn6";
        /// <summary> XML属性　ptn7 </summary>
        static public readonly string xml_PTN7 = "ptn7";
        /// <summary> XML属性　ptn8 </summary>
        static public readonly string xml_PTN8 = "ptn8";

        /// <summary>コールバック番号管理テーブル</summary>
        protected Hashtable m_csCallBackNoTbl;
        /// <summary>メニューテキスト管理テーブル（コールバック有りのみ）</summary>
        protected Hashtable m_csMenuTextTbl;
        /// <summary>Xmlリーダ</summary>
        protected HySXmlReader m_csXmlReader;
        /// <summary>メニュー定義ファイル</summary>
        //static protected HySString MENU_INI_PATH = new HySString("\\conf\\");
        static protected HySString MENU_INI_PATH = new HySString("\\conf\\" + HySEnvInf.GetCultureDirectory().ToString());

        /// <summary>メニューリスト</summary>
        protected IList[] m_csMenuList;
        /// <summary>メニューレベル</summary>
        protected long m_lMenuLevelCount = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuCtl csMenuCtl = new HySViewerMenuCtl( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuCtl()
        {
            m_csCallBackNoTbl = new Hashtable();
            m_csMenuTextTbl = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー定義情報ロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadMenuDefine(csMenuXmlFileName) </para>
        /// </example>
        /// <param name="csMenuXmlFileName">メニュー定義ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void LoadMenuDefine(HySString csMenuXmlFileName)
        {
            HySString csMenuIniFile =null;
            HySString csMenuIniFileFullName = null;
            if (((object)csMenuXmlFileName) == null)
            {   // ファイル指定なし
                csMenuIniFile = HySEnvInf.GetEnvInf(new HySString("MENU_INI_FILENAME"));
                csMenuIniFileFullName = HySEnvInf.GetHomeDirectory() + MENU_INI_PATH + csMenuIniFile;
            }
            else
            {   // ファイル指定あり
                csMenuIniFileFullName = csMenuXmlFileName;
            }
            HySFile csFile = new HySFile(csMenuIniFileFullName);
            if (csFile.Exist() == true)
            {   // ファイルが存在する
                m_csXmlReader = new HySXmlReader(csMenuIniFileFullName);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー定義情報出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveMenuDefine(csMenuXmlFileName) </para>
        /// </example>
        /// <param name="csMenuXmlFileName">メニュー定義ファイル名称</param>
        /// <returns>リターンコード =0:正常、=-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long SaveMenuDefine(HySString csMenuXmlFileName)
        {
            HySString csMenuIniFile = null;
            HySString csMenuIniFileFullName = null;
            long lLevelCount = 1;
            long[] lIndex = new long[m_lMenuLevelCount];
            if (((object)csMenuXmlFileName) == null)
            {   // ファイル指定なし
                csMenuIniFile = HySEnvInf.GetEnvInf(new HySString("MENU_INI_FILENAME"));
                csMenuIniFileFullName = HySEnvInf.GetHomeDirectory() + MENU_INI_PATH + csMenuIniFile;
            }
            else
            {   // ファイル指定あり
                csMenuIniFileFullName = csMenuXmlFileName;
            }
            try
            {
                HySFile csFile = new HySFile(csMenuIniFileFullName);
                if (csFile.Exist() == true)
                {   // ファイル在り
                    HySXmlWriter csXmlWriter = new HySXmlWriter(csMenuIniFileFullName);
                    //HySXmlNode csRootNode = HySXmlNode.CreateElement(xml_MENULIST, csXmlWriter);
                    HySXmlNode csRootNode = csXmlWriter.CreateRoot(xml_MENULIST);
                    HySXmlNode csMainMenuNode = HySXmlNode.CreateElement(xml_MAINMENU, csXmlWriter);
                    HySXmlNode csMenuItemNode = null;
                    HySXmlNode csSubMenuNode = null;
                    HySViewerMenuItem csMenuItem = null;
                    csRootNode.AppendChild(csMainMenuNode);
                    for (long lLoop = 0; lLoop < GetMainMenuCount(); lLoop++)
                    {   // メニュー項目数分処理
                        lIndex[0] = lLoop;
                        csMenuItemNode = HySXmlNode.CreateElement(xml_MENUITEM, csXmlWriter);
                        csMainMenuNode.AppendChild(csMenuItemNode);
                        csMenuItem = GetMainMenuItem(lLoop);
                        MakeMenuItemXml(csMenuItem, csMenuItemNode, csXmlWriter);
                        csSubMenuNode = HySXmlNode.CreateElement(xml_SUBMENU, csXmlWriter);
                        csMenuItemNode.AppendChild(csSubMenuNode);
                        MakeSubMenuXml(lLevelCount + 1, lIndex, csSubMenuNode, csXmlWriter);
                    }
                    csXmlWriter.Save();
                }
                return 0;
            }
            catch (Exception ex)
            {
                //Console.WriteLine(m_csFileName + "==>" + ex.ToString());
                HySLog.LogOut(HySLog.TRIAL_RUN, csMenuIniFileFullName + "==>" + ex.ToString());
                return -1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテム情報Xml出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadMenuDefine( ) </para>
        /// </example>
        /// <param name="csMenuItem">メニューアイテム</param>
        /// <param name="csNode">Xmlノード</param>
        /// <param name="csXmlWriter">XMLライター</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MakeMenuItemXml(HySViewerMenuItem csMenuItem,HySXmlNode csNode, HySXmlWriter csXmlWriter)
        {
            HySXmlNode csItemNode = null;
            string sWork = null;
            // テキスト
            csItemNode = HySXmlNode.CreateElement(xml_TEXT,csXmlWriter);
            csItemNode.SetAttribute(xml_VALUE, csMenuItem.GetMenuText().ToString());
            csNode.AppendChild(csItemNode);
            // レベル
            csItemNode = HySXmlNode.CreateElement(xml_LEVEL, csXmlWriter);
            csItemNode.SetAttribute(xml_VALUE, csMenuItem.GetMenuLevel().ToString());
            csNode.AppendChild(csItemNode);
            // コールバック
            csItemNode = HySXmlNode.CreateElement(xml_CALLBACK, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.HasCallBack().ToString());
            csItemNode.SetAttribute(xml_NO, csMenuItem.GetCallBackNo().ToString());
            csNode.AppendChild(csItemNode);
            // セパレーター
            csItemNode = HySXmlNode.CreateElement(xml_SEPARATOR, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.IsSeparator().ToString());
            csNode.AppendChild(csItemNode);
            // 業務番号
            csItemNode = HySXmlNode.CreateElement(xml_BUSIPROCNO, csXmlWriter);
            csItemNode.SetAttribute(xml_VALUE, csMenuItem.GetBusiProcNo().ToString());
            csNode.AppendChild(csItemNode);
            // 業務種別識別子
            csItemNode = HySXmlNode.CreateElement(xml_KIND, csXmlWriter);
            csItemNode.SetAttribute(xml_VALUE, csMenuItem.GetKindString().ToString());
            csNode.AppendChild(csItemNode);
            // ウィンドウズリスト
            csItemNode = HySXmlNode.CreateElement(xml_WINDOWSLIST, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.HasWindowList().ToString());
            csNode.AppendChild(csItemNode);
            // イメージ
            csItemNode = HySXmlNode.CreateElement(xml_IMAGE, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.HasImage().ToString());
            csItemNode.SetAttribute(xml_NAME, csMenuItem.GetImageName().ToString());
            csNode.AppendChild(csItemNode);
            // ショートカット
            csItemNode = HySXmlNode.CreateElement(xml_SHORTCUT, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.HasShortCut().ToString());
            csItemNode.SetAttribute(xml_NO, csMenuItem.GetShortCut().ToString());
            csNode.AppendChild(csItemNode);
            // チェックオン
            csItemNode = HySXmlNode.CreateElement(xml_CHECKON, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.CheckOnClick().ToString());
            csItemNode.SetAttribute(xml_DEFAULT, csMenuItem.GetCheckOnClickDefault().ToString());
            csNode.AppendChild(csItemNode);
            csItemNode = HySXmlNode.CreateElement(xml_EVENT, csXmlWriter);
            for (int iLoop = 0; iLoop < HySDotNetViewerDefine.EVENT_NUM; iLoop++)
            {   // イベント数分処理
                sWork = xml_PTN + (iLoop + 1);
                csItemNode.SetAttribute(sWork, csMenuItem.GetEventNo(iLoop).ToString());
            }
            csNode.AppendChild(csItemNode);
            csItemNode = HySXmlNode.CreateElement(xml_MASK, csXmlWriter);
            for (int iLoop = 0; iLoop < HySDotNetViewerDefine.EVENT_NUM; iLoop++)
            {   // イベント数分処理
                sWork = xml_PTN + (iLoop + 1);
                csItemNode.SetAttribute(sWork, csMenuItem.GetPatern(iLoop).ToString());
            }
            csNode.AppendChild(csItemNode);
            // ユーザー編集
            csItemNode = HySXmlNode.CreateElement(xml_USEREDIT, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.CanUserEdit().ToString());
            csNode.AppendChild(csItemNode);
            // メニュー表示
            csItemNode = HySXmlNode.CreateElement(xml_MENUDISP, csXmlWriter);
            csItemNode.SetAttribute(xml_FLG, csMenuItem.GetMenuDisp().ToString());
            csNode.AppendChild(csItemNode);
        }

        /// <summary><para>method outline:</para>
        /// <para>サブメニュー定義情報Xml出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadMenuDefine( ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <param name="lIndex">メニューアイテム取得箇所</param>
        /// <param name="csNode">Xmlノード</param>
        /// <param name="csXmlWriter">Xmlライター</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long MakeSubMenuXml(long lLevel,long[] lIndex,HySXmlNode csNode, HySXmlWriter csXmlWriter)
        {
            long lRtn = -1;
            HySXmlNode csMenuItemNode = null;
            HySXmlNode csSubMenuNode = null;
            HySViewerMenuItem csMenuItem = null;
            if (lLevel <= m_lMenuLevelCount)
            {   // レベルはレベル数最大以内
                if (GetSubMenuCount(lLevel, lIndex) > 0)
                {   // メニューデータ有り
                    lRtn = 0;
                }
                for (long lLoop = 0; lLoop < GetSubMenuCount(lLevel, lIndex); lLoop++)
                {   // メニュー項目数分処理
                    lIndex[lLevel - 1] = lLoop;
                    csMenuItemNode = HySXmlNode.CreateElement(xml_MENUITEM, csXmlWriter);
                    csNode.AppendChild(csMenuItemNode);
                    csMenuItem = GetSubMenuItem(lLevel, lIndex);
                    MakeMenuItemXml(csMenuItem, csMenuItemNode, csXmlWriter);
                    csSubMenuNode = HySXmlNode.CreateElement(xml_SUBMENU, csXmlWriter);
                    if (MakeSubMenuXml(lLevel + 1, lIndex, csSubMenuNode, csXmlWriter) == 0)
                    {   // メニューデータ有り
                        csMenuItemNode.AppendChild(csSubMenuNode);
                    }
                    csSubMenuNode = null;
                }
            }
            return lRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>メニューレベル数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetMenuLevel(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetMenuLevelCount()
        {
            return m_lMenuLevelCount;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューレベル数算出</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CountMenuLevel( lLevel, csNode ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <param name="csNode">メニューノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void CountMenuLevel(long lLevel, HySXmlNode csNode)
        {
            HySXmlNodeList csNodeList;
            HySXmlNode csNodeChild;
            HySXmlNode csSubNode;
            HySXmlNodeList csSubNodeList;
            long lMenuListCount;
            long lMenuCount;
            long lSetLevel;

            // サブメニュー編集
            csNodeList = csNode.GetChildNodeListByTagName(xml_SUBMENU);
            lMenuListCount = csNodeList.GetCount();
            for (long lLoopI = 0; lLoopI < lMenuListCount; lLoopI++)
            {   // メニューリスト数分処理
                csNodeChild = csNodeList.GetNode(lLoopI);
                if (csNodeChild.IsComment() == true)
                {   // コメント
                    continue;
                }
                lSetLevel = lLevel + 1;
                if (lSetLevel > m_lMenuLevelCount)
                {   // 指定レベルがメニューレベル数を越えている
                    m_lMenuLevelCount++;
                }
                csSubNodeList = csNodeChild.GetChildNodeList();
                lMenuCount = csSubNodeList.GetCount();
                for (long lLoopJ = 0; lLoopJ < lMenuCount; lLoopJ++)
                {   // メニュー数分処理
                    csSubNode = csSubNodeList.GetNode(lLoopJ);
                    if (csSubNode.IsComment() == true)
                    {   // コメント
                        continue;
                    }
                    CountMenuLevel(lSetLevel, csSubNode);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー構成チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CheckMenu(csMenuXmlFileName) </para>
        /// </example>
        /// <param name="csMenuXmlFileName">メニュー定義ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CheckMenu(HySString csMenuXmlFileName)
        {
            HySXmlNode csRootNode;
            HySXmlNode csNode;
            HySXmlNode csNodeChild;
            HySXmlNodeList csNodeList;
            HySXmlNodeList csNodeChildList;
            long lMenuListCount;
            long lMenuCount;
            long lLevel=0;

            // 定義情報を読み込む。
            this.LoadMenuDefine(csMenuXmlFileName);

            // メニューアイテムを編集する。
            csRootNode = m_csXmlReader.GetRootNode();
            if (csRootNode.IsComment() == true)
            {   // コメント
                return;
            }
            csNodeList = csRootNode.GetChildNodeList();
            lMenuListCount = csNodeList.GetCount();

            for (long lLoopI = 0; lLoopI < lMenuListCount; lLoopI++)
            {   // メニューリスト数分処理
                csNode = csNodeList.GetNode(lLoopI);
                if (csNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                lLevel++;
                m_lMenuLevelCount++;
                csNodeChildList = csNode.GetChildNodeList();
                lMenuCount = csNodeChildList.GetCount();
                for (long lLoopJ = 0; lLoopJ < lMenuCount; lLoopJ++)
                {   // メニュー数分処理
                    csNodeChild = csNodeChildList.GetNode(lLoopJ);
                    if (csNodeChild.IsComment() == true)
                    {   // コメント
                        continue;
                    }
                    CountMenuLevel(lLevel, csNodeChild);
                }
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>サブメニュー生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CountMenuLevel( lLevel, csList, csNode ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <param name="csList">メニューリスト</param>
        /// <param name="csNode">メニューノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void GenarateSubMenu(long lLevel, IList[] csList, HySXmlNode csNode)
        {
            HySXmlNodeList csNodeList;
            HySXmlNode csNodeChild;
            HySXmlNode csSubNode;
            HySXmlNodeList csSubNodeList;
            HySViewerMenuItem csItem = null;
            long lMenuListCount;
            long lMenuCount;
            long lSetLevel;
            IList[] csListWork;
            long lNum;
            long lLoopI;
            long lLoopJ;
            long lLoopK;

            // サブメニュー編集
            csNodeList = csNode.GetChildNodeListByTagName(xml_SUBMENU);
            lMenuListCount = csNodeList.GetCount();
            for (lLoopI = 0; lLoopI < lMenuListCount; lLoopI++)
            {   // メニューリスト数分処理
                csNodeChild = csNodeList.GetNode(lLoopI);
                if (csNodeChild.IsComment() == true)
                {   // コメント
                    continue;
                }
                lSetLevel = lLevel + 1;
                csSubNodeList = csNodeChild.GetChildNodeList();
                lMenuCount = csSubNodeList.GetCount();
                for (lLoopJ = 0; lLoopJ < lMenuCount; lLoopJ++)
                {   // メニュー数分処理
                    csSubNode = csSubNodeList.GetNode(lLoopJ);
                    if (csSubNode.IsComment() == true)
                    {   // コメント
                        continue;
                    }
                    lNum = m_lMenuLevelCount - lSetLevel;
                    csListWork = new IList[lNum];
                    for (lLoopK = 0; lLoopK < lNum; lLoopK++)
                    {   // 残りレベルリスト数分処理
                        csListWork[lLoopK] = new ArrayList();
                    }
                    csItem = new HySViewerMenuItem();
                    this.SetMenuItem(csItem, csSubNode);
                    csList[0].Add(csItem);
                    for (lLoopK = 0; lLoopK < lNum; lLoopK++)
                    {   // 残りレベルリスト数分処理
                        csList[lLoopK+1].Add(csListWork[lLoopK]);
                    }
                    GenarateSubMenu(lSetLevel, csListWork, csSubNode);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GenerateMenu( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GenerateMenu()
        {
            HySXmlNode csRootNode;
            HySXmlNode csNode;
            HySXmlNode csNodeChild;
            HySXmlNodeList csNodeList;
            HySXmlNodeList csNodeChildList;
            long lMenuListCount;
            long lMenuCount;

            IList[] csListWork = null;
            HySViewerMenuItem csItem = null;
            long lLevel=0;
            long lNum;
            long lLoopI;
            long lLoopJ;
            long lLoopK;

            // 定義情報を読み込む。
            //this.LoadMenuDefine();

            // メニューアイテムを編集する。
            csRootNode = m_csXmlReader.GetRootNode();
            if (csRootNode.IsComment() == true)
            {   // コメント
                return;
            }

            m_csMenuList = new IList[m_lMenuLevelCount];
            for (lLoopK = 0; lLoopK < m_lMenuLevelCount; lLoopK++)
            {   // メニューレベル数分処理
                m_csMenuList[lLoopK] = new ArrayList();
            }

            csNodeList = csRootNode.GetChildNodeList();
            lMenuListCount = csNodeList.GetCount();

            for (lLoopI = 0; lLoopI < lMenuListCount; lLoopI++)
            {   // メニューリスト数分処理
                csNode = csNodeList.GetNode(lLoopI);
                if (csNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                lLevel++;
                csNodeChildList = csNode.GetChildNodeList();
                lMenuCount = csNodeChildList.GetCount();
                for (lLoopJ = 0; lLoopJ < lMenuCount; lLoopJ++)
                {   // メニュー数分処理
                    csNodeChild = csNodeChildList.GetNode(lLoopJ);
                    if (csNodeChild.IsComment() == true)
                    {   // コメント
                        continue;
                    }
                    // メインメニュー編集
                    lNum = m_lMenuLevelCount - lLevel;
                    csListWork = new IList[lNum];
                    for (lLoopK = 0; lLoopK < lNum; lLoopK++)
                    {   // 残りレベル数分処理
                        csListWork[lLoopK] = new ArrayList();
                    }
                    csItem = new HySViewerMenuItem();
                    this.SetMenuItem(csItem, csNodeChild);
                    m_csMenuList[0].Add(csItem);
                    for (lLoopK = 0; lLoopK < lNum; lLoopK++)
                    {  // 残りレベル数分処理
                        m_csMenuList[lLoopK+1].Add(csListWork[lLoopK]);
                    }
                    GenarateSubMenu(lLevel, csListWork, csNodeChild);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテムセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMenuItem( csMenuItem,csXmlNode ) </para>
        /// </example>
        /// <param name="csMenuItem">ビューアメニューアイテムデータクラス</param>
        /// <param name="csXmlNode">Xmlノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void SetMenuItem(HySViewerMenuItem csMenuItem, HySXmlNode csXmlNode)
        {
            HySXmlNode csXmlTextTagNode;
            HySXmlNode csXmlLevelTagNode;
            HySXmlNode csXmlCallBackTagNode;
            HySXmlNode csXmlSeparatorTagNode;
            HySXmlNode csXmlBusiProcNoTagNode;
            HySXmlNode csXmlKindTagNode;
            HySXmlNode csXmlWindowsTagNode;
            HySXmlNode csXmlImageTagNode;
            HySXmlNode csXmlShortCutTagNode;
            HySXmlNode csXmlCheckOnTagNode;
            HySXmlNode csXmlEventNode;
            HySXmlNode csXmlMenuMaskNode;
            HySXmlNode csXmlUserEditNode;
            HySXmlNode csXmlMenuDispNode;
            HySXmlNodeList csXmlTextList;
            HySXmlNodeList csXmlLevelList;
            HySXmlNodeList csXmlCallBackList;
            HySXmlNodeList csXmlSeparatorList;
            HySXmlNodeList csXmlBusiProcNoList;
            HySXmlNodeList csXmlKindList;
            HySXmlNodeList csXmlWindowsList;
            HySXmlNodeList csXmlImageList;
            HySXmlNodeList csXmlShortCutList;
            HySXmlNodeList csXmlCheckOnList;
            HySXmlNodeList csXmlEventList;
            HySXmlNodeList csXmlMenuMaskList;
            HySXmlNodeList csXmlUserEditList;
            HySXmlNodeList csXmlMenuDispList;
            String sString = null;
            String sTextString = null;
            long lCallBackNo = -1;
            long lLoop;

            // メニューラベル
            csXmlTextList = csXmlNode.GetChildNodeListByTagName(xml_TEXT);
            for (lLoop = 0; lLoop < csXmlTextList.GetCount(); lLoop++)
            {   // メニューラベルリスト数分処理
                csXmlTextTagNode = csXmlTextList.GetNode(lLoop);
                if (csXmlTextTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetMenuText(new HySString(csXmlTextTagNode.GetAttribute(xml_VALUE)));
                sTextString = csXmlTextTagNode.GetAttribute(xml_VALUE);
            }
            // メニューレベル
            csXmlLevelList = csXmlNode.GetChildNodeListByTagName(xml_LEVEL);
            for (lLoop = 0; lLoop < csXmlLevelList.GetCount(); lLoop++)
            {   // メニューレベルリスト数分処理
                csXmlLevelTagNode = csXmlLevelList.GetNode(lLoop);
                if (csXmlLevelTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetMenuLevel(Convert.ToInt32(csXmlLevelTagNode.GetAttribute(xml_VALUE)));
            }
            // コールバック
            csXmlCallBackList = csXmlNode.GetChildNodeListByTagName(xml_CALLBACK);
            for (lLoop = 0; lLoop < csXmlCallBackList.GetCount(); lLoop++)
            {   // コールバックリスト数分処理
                csXmlCallBackTagNode = csXmlCallBackList.GetNode(lLoop);
                if (csXmlCallBackTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetCallBackFlg(Convert.ToBoolean(csXmlCallBackTagNode.GetAttribute(xml_FLG)));
                csMenuItem.SetCallBackNo(Convert.ToInt32(csXmlCallBackTagNode.GetAttribute(xml_NO)));
                lCallBackNo = Convert.ToInt32(csXmlCallBackTagNode.GetAttribute(xml_NO));
            }
            // セパレータ
            csXmlSeparatorList = csXmlNode.GetChildNodeListByTagName(xml_SEPARATOR);
            for (lLoop = 0; lLoop < csXmlCallBackList.GetCount(); lLoop++)
            {   // セパレータリスト数分処理
                csXmlSeparatorTagNode = csXmlSeparatorList.GetNode(lLoop);
                if (csXmlSeparatorTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetSeparator(Convert.ToBoolean(csXmlSeparatorTagNode.GetAttribute(xml_FLG)));
            }
            // 業務番号
            csXmlBusiProcNoList = csXmlNode.GetChildNodeListByTagName(xml_BUSIPROCNO);
            for (lLoop = 0; lLoop < csXmlBusiProcNoList.GetCount(); lLoop++)
            {   // 業務番号リスト数分処理
                csXmlBusiProcNoTagNode = csXmlBusiProcNoList.GetNode(lLoop);
                if (csXmlBusiProcNoTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetBusiProcNo(Convert.ToInt32(csXmlBusiProcNoTagNode.GetAttribute(xml_VALUE)));
            }
            // 種別識別文字
            csXmlKindList = csXmlNode.GetChildNodeListByTagName(xml_KIND);
            for (lLoop = 0; lLoop < csXmlKindList.GetCount(); lLoop++)
            {   // 種別識別文字リスト数分処理
                csXmlKindTagNode = csXmlKindList.GetNode(lLoop);
                if (csXmlKindTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetKindString(new HySString(csXmlKindTagNode.GetAttribute(xml_VALUE)));
            }
            // ウィンドウズリスト
            csXmlWindowsList = csXmlNode.GetChildNodeListByTagName(xml_WINDOWSLIST);
            for (lLoop = 0; lLoop < csXmlWindowsList.GetCount(); lLoop++)
            {   // ウィンドウズリストリスト数分処理
                csXmlWindowsTagNode = csXmlWindowsList.GetNode(lLoop);
                if (csXmlWindowsTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetWindowlistFlg(Convert.ToBoolean(csXmlWindowsTagNode.GetAttribute(xml_FLG)));
            }
            // イメージ
            csXmlImageList = csXmlNode.GetChildNodeListByTagName(xml_IMAGE);
            for (lLoop = 0; lLoop < csXmlImageList.GetCount(); lLoop++)
            {   // イメージリスト数分処理
                csXmlImageTagNode = csXmlImageList.GetNode(lLoop);
                if (csXmlImageTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetImageFlg(Convert.ToBoolean(csXmlImageTagNode.GetAttribute(xml_FLG)));
                csMenuItem.SetImageName(new HySString(csXmlImageTagNode.GetAttribute(xml_NAME)));
            }
            // ショートカット
            csXmlShortCutList = csXmlNode.GetChildNodeListByTagName(xml_SHORTCUT);
            for (lLoop = 0; lLoop < csXmlShortCutList.GetCount(); lLoop++)
            {   // ショートカットリスト数分処理
                csXmlShortCutTagNode = csXmlShortCutList.GetNode(lLoop);
                if (csXmlShortCutTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetShortCutFlg(Convert.ToBoolean(csXmlShortCutTagNode.GetAttribute(xml_FLG)));
                sString = csXmlShortCutTagNode.GetAttribute(xml_NO);
                if (sString != String.Empty)
                {   // コメント
                    csMenuItem.SetShortCut(Convert.ToInt32(sString));
                }
            }
            // チェックオン
            csXmlCheckOnList = csXmlNode.GetChildNodeListByTagName(xml_CHECKON);
            for (lLoop = 0; lLoop < csXmlCheckOnList.GetCount(); lLoop++)
            {   // チェックオンリスト数分処理
                csXmlCheckOnTagNode = csXmlCheckOnList.GetNode(lLoop);
                if (csXmlCheckOnTagNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetCheckOnClickFlg(Convert.ToBoolean(csXmlCheckOnTagNode.GetAttribute(xml_FLG)));
                csMenuItem.SetCheckOnClickDefault(Convert.ToBoolean(csXmlCheckOnTagNode.GetAttribute(xml_DEFAULT)));
            }
            // イベント
            csXmlEventList = csXmlNode.GetChildNodeListByTagName(xml_EVENT);
            for (lLoop = 0; lLoop < csXmlEventList.GetCount(); lLoop++)
            {   // イベントリスト数分処理
                csXmlEventNode = csXmlEventList.GetNode(lLoop);
                if (csXmlEventNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                for (long lLoop2 = 0; lLoop2 < HySDotNetViewerDefine.EVENT_NUM; lLoop2++)
                {
                    csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.NOEVENT);
                    string sWork = xml_PTN + (lLoop2 + 1);
                    if (HySDotNetViewerDefine.EventKind.SYSTEMSTART.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // システムスタート
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.SYSTEMSTART);
                    }
                    else if (HySDotNetViewerDefine.EventKind.INITIALIZE.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 初期処理
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.INITIALIZE);
                    }
                    else if (HySDotNetViewerDefine.EventKind.CAL_START.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 演算開始
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.CAL_START);
                    }
                    else if (HySDotNetViewerDefine.EventKind.CAL_PAUSE.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 演算中断
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.CAL_PAUSE);
                    }
                    else if (HySDotNetViewerDefine.EventKind.CAL_END.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 演算終了
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.CAL_END);
                    }
                    else if (HySDotNetViewerDefine.EventKind.CAL_STOP.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 演算中断
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.CAL_STOP);
                    }
                    else if (HySDotNetViewerDefine.EventKind.CAL_MULTI.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 複数プロジェクト演算中
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.CAL_MULTI);
                    }
                    else if (HySDotNetViewerDefine.EventKind.IN_PROCESS.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 処理中
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.IN_PROCESS);
                    }
                    else if (HySDotNetViewerDefine.EventKind.END_PROCESS.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 処理終了
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.END_PROCESS);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール動作中
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_RUN);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_EXIT.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール終了
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_EXIT);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_RUN.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール動作中（縦横断データ）
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_RUN);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_EXIT.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール終了（縦横断データ）
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_RSD_EXIT);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_RUN.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール動作中（河川・流域DB）
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_RUN);
                    }
                    else if (HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_EXIT.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    {   // 外部DBツール終了（河川・流域DB）
                        csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.EXTDBTOOL_RW_EXIT);
                    }
                    # region 再検討の為コメント化
                    //else if (HySDotNetViewerDefine.EventKind.LIBDEL_START.ToString().Equals(csXmlEventNode.GetAttribute(sWork).ToString()) == true)
                    //{
                    //    csMenuItem.SetEventNo(lLoop2, HySDotNetViewerDefine.EventKind.LIBDEL_START);
                    //}
                    # endregion
                }
            }
            // メニューマスク
            csXmlMenuMaskList = csXmlNode.GetChildNodeListByTagName(xml_MASK);
            for (lLoop = 0; lLoop < csXmlMenuMaskList.GetCount(); lLoop++)
            {   // メニューマスクリスト数分処理
                csXmlMenuMaskNode = csXmlMenuMaskList.GetNode(lLoop);
                if (csXmlMenuMaskNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                for (long lLoop2 = 0; lLoop2 < HySDotNetViewerDefine.EVENT_NUM; lLoop2++)
                {   // イベント数分処理
                    string sWork = xml_PTN + (lLoop2 + 1);
                    string sAttr = null;
                    sAttr = csXmlMenuMaskNode.GetAttribute(sWork);
                    if (sAttr == string.Empty)
                    {   // データは空
                        csMenuItem.SetPatern(lLoop2, true);
                    }
                    else
                    {   // データ有り
                        csMenuItem.SetPatern(lLoop2, Convert.ToBoolean(csXmlMenuMaskNode.GetAttribute(sWork)));
                    }
                }
            }
            // ユーザ編集可否
            csXmlUserEditList = csXmlNode.GetChildNodeListByTagName(xml_USEREDIT);
            for (lLoop = 0; lLoop < csXmlUserEditList.GetCount(); lLoop++)
            {   // ユーザ編集可否リスト数分処理
                csXmlUserEditNode = csXmlUserEditList.GetNode(lLoop);
                if (csXmlUserEditNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetUserEdit(Convert.ToBoolean(csXmlUserEditNode.GetAttribute(xml_FLG)));
            }
            // メニュー表示有無
            csXmlMenuDispList = csXmlNode.GetChildNodeListByTagName(xml_MENUDISP);
            for (lLoop = 0; lLoop < csXmlMenuDispList.GetCount(); lLoop++)
            {   // メニュー表示有無リスト数分処理
                csXmlMenuDispNode = csXmlMenuDispList.GetNode(lLoop);
                if (csXmlMenuDispNode.IsComment() == true)
                {   // コメント
                    continue;
                }
                csMenuItem.SetMenuDisp(Convert.ToBoolean(csXmlMenuDispNode.GetAttribute(xml_FLG)));
            }
            m_csMenuTextTbl[lCallBackNo] = sTextString;
        }

        /// <summary><para>method outline:</para>
        /// <para>メインメニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetMainMenuItem( lIndex ) </para>
        /// </example>
        /// <param name="lIndex">取得位置</param>
        /// <returns>メニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem GetMainMenuItem(long lIndex)
        {
            HySViewerMenuItem csMenuItem = null;
            if (m_lMenuLevelCount > 0)
            {
                csMenuItem = (HySViewerMenuItem)m_csMenuList[0][(int)lIndex];
            }
            return csMenuItem;
        }

        /// <summary><para>method outline:</para>
        /// <para>メインメニューアイテム数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetMainMenuCount( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メインメニューアイテム数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetMainMenuCount()
        {
            long lRtn = 0;
            if (m_lMenuLevelCount > 0)
            {
                lRtn = m_csMenuList[0].Count;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>サブメニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetSubMenuItem( lLevel,lIndex ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <param name="lIndex">取得位置配列</param>
        /// <returns>サブメニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem GetSubMenuItem(long lLevel, long[] lIndex)
        {
            HySViewerMenuItem csMenuItem = null;
            IList[] csList = new IList[lLevel-1];
            csList[0] = (IList)m_csMenuList[(int)(lLevel - 1)][(int)lIndex[0]];
            for (long lLoop = 1; lLoop < lLevel - 1; lLoop++)
            {   // 指定レベル数分処理
                csList[lLoop] = (IList)csList[(int)(lLoop - 1)][(int)lIndex[lLoop]];
            }
            csMenuItem = (HySViewerMenuItem)csList[lLevel - 2][(int)lIndex[lLevel - 1]];
            return csMenuItem;
        }

        /// <summary><para>method outline:</para>
        /// <para>サブメニューアイテム数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetSubMenuCountLevel( lLevel,lIndex ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <param name="lIndex">取得位置配列</param>
        /// <returns>サブメニューアイテム数レベル２</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetSubMenuCount(long lLevel, long[] lIndex)
        {
            long lCount = 0;
            IList[] csList = new IList[lLevel - 1];
            csList[0] = (IList)m_csMenuList[(int)(lLevel - 1)][(int)lIndex[0]];
            for (long lLoop = 1; lLoop < lLevel - 1; lLoop++)
            {   // 指定レベル数分処理
                csList[lLoop] = (IList)csList[(int)(lLoop - 1)][(int)lIndex[lLoop]];
            }
            lCount = csList[lLevel - 2].Count;
            return lCount;
        }

        /// <summary><para>method outline:</para>
        /// <para>コールバック番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCallBackNo = GetCallBackNo( csMenuText ) </para>
        /// </example>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <returns>コールバック番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCallBackNo(HySString csMenuText)
        {
            long lCallBackNo = 0;
            lCallBackNo = (long)m_csCallBackNoTbl[csMenuText.ToString()];
            return lCallBackNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>種別識別文字取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csKindString = GetKindString( csMenuText, lCallBackNo ) </para>
        /// </example>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>種別識別文字</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetKindString(HySString csMenuText, long lCallBackNo)
        {
            HySString csKindString = new HySString("");

            for (long lLoop = 0; lLoop < m_lMenuLevelCount; lLoop++)
            {   // メニューレベル数分処理
                csKindString = GetKindString(m_csMenuList[lLoop], csMenuText, lCallBackNo);
                if (csKindString.ToString() != "")
                {   // 該当あり
                    break;
                }
            }
            return csKindString;
        }

        /// <summary><para>method outline:</para>
        /// <para>種別識別文字取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csKindString = GetKindString( csObject, csMenuText, lCallBackNo ) </para>
        /// </example>
        /// <param name="csObject">メニューオブジェクト</param>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>種別識別文字</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySString GetKindString(object csObject, HySString csMenuText, long lCallBackNo)
        {
            HySViewerMenuItem csMenuItem = null;
            HySString csKindString = new HySString("");
            HySString csKindStringWork = new HySString("");
            long lLoop;
            IList csList = null;
            IList csList2 = null;
            csList = csObject as IList;
            if (csList != null)
            {   // リスト有り
                for (lLoop = 0; lLoop < csList.Count; lLoop++)
                {   // リスト数分処理
                    csMenuItem = csList[(int)lLoop] as HySViewerMenuItem;
                    if (csMenuItem != null)
                    {   // メニューアイテムデータ有り
                        if (csMenuItem.GetMenuText().Equal(csMenuText) == true && lCallBackNo == csMenuItem.GetCallBackNo())
                        {   // 指定メニューと一致
                            csKindString = csMenuItem.GetKindString();
                            break;
                        }
                    }
                    else
                    {   // メニューアイテムデータ無し
                        csList2 = csList[(int)lLoop] as IList;
                        csKindStringWork = GetKindString(csList2, csMenuText, lCallBackNo);
                        if (csKindStringWork.ToString() != "")
                        {   // 業務識別子有効
                            csKindString = csKindStringWork;
                            break;
                        }
                    }
                }
            }
            return csKindString;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetMenuItem( csMenuText, lIndex ) </para>
        /// </example>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="iIndex">取り出し場所</param>
        /// <returns>メニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem GetMenuItem(HySString csMenuText, int iIndex)
        {
            HySViewerMenuItem csMenuItemResult = null;

            for (long lLoop = 0; lLoop < m_lMenuLevelCount; lLoop++)
            {   // メニューレベル数分処理
                csMenuItemResult = GetMenuItem(m_csMenuList[lLoop], csMenuText, iIndex);
                if (csMenuItemResult != null)
                {   // メニューアイテムデータ有り
                    break;
                }
            }
            return csMenuItemResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetMenuItem( csObject, csMenuText, lIndex ) </para>
        /// </example>
        /// <param name="csObject">メニューオブジェクト</param>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="iIndex">取り出し場所</param>
        /// <returns>メニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySViewerMenuItem GetMenuItem(object csObject, HySString csMenuText, int iIndex)
        {
            HySViewerMenuItem csMenuItemResult = null;
            HySViewerMenuItem csMenuItemWork = null;
            HySViewerMenuItem csMenuItem = null;
            int iCount = 0;
            long lLoop;
            IList csList = null;
            IList csList2 = null;
            csList = csObject as IList;
            if (csList != null)
            {   // リスト有り
                for (lLoop = 0; lLoop < csList.Count; lLoop++)
                {   // リスト数分処理
                    csMenuItem = csList[(int)lLoop] as HySViewerMenuItem;
                    if (csMenuItem != null)
                    {   // 眼乳-アイテムデータ有り
                        if (csMenuItem.GetMenuText().Equal(csMenuText) == true)
                        {   // 指定メニューと一致
                            if (iCount == iIndex)
                            {   // 場所一致
                                csMenuItemResult = csMenuItem;
                                break;
                            }
                            else
                            {   // 場所不一致
                                iCount++;
                                continue;
                            }
                        }
                    }
                    else
                    {   // 眼乳-アイテムデータ有り
                        csList2 = csList[(int)lLoop] as IList;
                        csMenuItemWork = GetMenuItem(csList2, csMenuText, iIndex);
                        if (csMenuItemWork != null)
                        {   // 眼乳-アイテムデータ有り
                            csMenuItemResult = csMenuItemWork;
                            break;
                        }
                    }
                }
            }
            return csMenuItemResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetMenuItem( csMenuText,lCallBackNo ) </para>
        /// </example>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>メニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem GetMenuItem(HySString csMenuText,long lCallBackNo)
        {
            HySViewerMenuItem csMenuItemResult = null;

            for (long lLoop = 0; lLoop < m_lMenuLevelCount; lLoop++)
            {   // メニューレベル数分処理
                csMenuItemResult = GetMenuItem(m_csMenuList[lLoop], csMenuText, lCallBackNo);
                if (csMenuItemResult != null)
                {   // メニューアイテムデータ有り
                    break;
                }
            }
            return csMenuItemResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューアイテム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = GetMenuItem( csObject,csMenuText,lCallBackNo ) </para>
        /// </example>
        /// <param name="csObject">メニューオブジェクト</param>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>メニューアイテム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySViewerMenuItem GetMenuItem(object csObject, HySString csMenuText, long lCallBackNo)
        {
            HySViewerMenuItem csMenuItemResult = null;
            HySViewerMenuItem csMenuItemWork = null;
            HySViewerMenuItem csMenuItem = null;
            long lLoop;
            IList csList = null;
            IList csList2 = null;
            csList = csObject as IList;
            if (csList != null)
            {   // リスト有り
                for (lLoop = 0; lLoop < csList.Count; lLoop++)
                {   // リスト数分処理
                    csMenuItem = csList[(int)lLoop] as HySViewerMenuItem;
                    if (csMenuItem != null)
                    {   // メニューアイテムデータ有り
                        if (csMenuItem.GetMenuText().Equal(csMenuText) == true && lCallBackNo == csMenuItem.GetCallBackNo())
                        {   // 指定メニューと一致
                            csMenuItemResult = csMenuItem;
                            break;
                        }
                    }
                    else
                    {   // メニューアイテムデータ有り
                        csList2 = csList[(int)lLoop] as IList;
                        csMenuItemWork = GetMenuItem(csList2, csMenuText, lCallBackNo);
                        if (csMenuItemWork != null)
                        {   // メニューアイテムデータ有り
                            csMenuItemResult = csMenuItemWork;
                            break;
                        }
                    }
                }
            }
            return csMenuItemResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューテキスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMenuText = GetMenuText( lCallBackNo ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>メニューテキスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMenuText(long lCallBackNo)
        {
            return new HySString((String)m_csMenuTextTbl[lCallBackNo]);
        }
    }
}
