﻿// <summary>ソースコード：ビューアメニューアイテムデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアメニューアイテムデータクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySViewerMenuItem : HySRoot
    {
        /// <summary>メニュー表示テキスト </summary>
        protected HySString m_csMenuText;
        /// <summary>メニューレベル </summary>
        protected long m_lLevel;
        /// <summary>コールバック番号 </summary>
        protected long m_lCallBackNo;
        /// <summary>コールバック有無 </summary>
        protected Boolean m_bHasCallBack = false;
        /// <summary>セパレータ有無 </summary>
        protected Boolean m_bIsSeparator = false;
        /// <summary>業務番号 </summary>
        protected long m_lBusProcNo;
        /// <summary>種別識別文字 </summary>
        protected HySString m_csKindString = new HySString("");
        /// <summary>ウィンドウリスト処理有無 </summary>
        protected Boolean m_bHasWindowList = false;
        /// <summary>イメージ有無 </summary>
        protected Boolean m_bHasImage = false;
        /// <summary>イメージ名称 </summary>
        protected HySString m_csImageName = new HySString("");
        /// <summary>ショートカット有無 </summary>
        protected Boolean m_bHasShortCut = false;
        /// <summary>ショートカット番号 </summary>
        protected long m_lShortCutNo;
        /// <summary>チェックマーク制御有無 </summary>
        protected Boolean m_bCheckOnClick = false;
        /// <summary>チェックマーク制御デフォルト </summary>
        protected Boolean m_bCheckOnClickDefault = false;
        /// <summary>マスク設定イベント</summary>
        protected HySDotNetViewerDefine.EventKind[] m_eEvent = new HySDotNetViewerDefine.EventKind[HySDotNetViewerDefine.EVENT_NUM];
        /// <summary>マスク設定パターン</summary>
        protected Boolean[] m_bMenuMaskFlg = new Boolean[HySDotNetViewerDefine.EVENT_NUM];
        /// <summary>ユーザ編集可否有無 </summary>
        protected Boolean m_bUserEdit = false;
        /// <summary>メニュー表示有無 </summary>
        protected Boolean m_bMenuDisp = true;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerMenuItem csMenuItem = new HySViewerMenuItem( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem()
        {
            for (int iLoop = 0; iLoop < HySDotNetViewerDefine.EVENT_NUM; iLoop++)
            {
                m_eEvent[iLoop] = HySDotNetViewerDefine.EventKind.NOEVENT;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー表示テキストセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMenuText( csMenuText ) </para>
        /// </example>
        /// <param name="csMenuText">メニュー表示テキスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMenuText(HySString csMenuText)
        {
            m_csMenuText = csMenuText;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー表示テキスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMenuText = GetMenuText( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メニュー表示テキスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMenuText()
        {
            return m_csMenuText;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューレベルセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMenuLevel( lLevel ) </para>
        /// </example>
        /// <param name="lLevel">メニューレベル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMenuLevel(long lLevel)
        {
            m_lLevel = lLevel;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューレベル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lLevel = GetMenuLevel( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メニューレベル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetMenuLevel()
        {
            return m_lLevel;
        }

        /// <summary><para>method outline:</para>
        /// <para>コールバック番号セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCallBackNo( lCallBackNo ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCallBackNo(long lCallBackNo)
        {
            m_lCallBackNo = lCallBackNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>コールバック番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCallBackNo = GetCallBackNo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>コールバック番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCallBackNo()
        {
            return m_lCallBackNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>コールバックフラグセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCallBackFlg( bCallBackFlg ) </para>
        /// </example>
        /// <param name="bCallBackFlg">コールバックフラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCallBackFlg(Boolean bCallBackFlg)
        {
            m_bHasCallBack = bCallBackFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>コールバック有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bCallBackFlg = HasCallBack( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean HasCallBack()
        {
            return m_bHasCallBack;
        }

        /// <summary><para>method outline:</para>
        /// <para>セパレータ有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSeparator( bSeparatorFlg ) </para>
        /// </example>
        /// <param name="bSeparatorFlg">セパレータ有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSeparator(Boolean bSeparatorFlg)
        {
            m_bIsSeparator = bSeparatorFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>セパレータ有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bSeparatorFlg = IsSeparator( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean IsSeparator()
        {
            return m_bIsSeparator;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務番号セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetBusiProcNo( lBusiProcNo ) </para>
        /// </example>
        /// <param name="lBusiProcNo">業務番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetBusiProcNo(long lBusiProcNo)
        {
            m_lBusProcNo = lBusiProcNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lBusiProcNo = GetBusiProcNo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetBusiProcNo()
        {
            return m_lBusProcNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>種別識別文字セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetKindString( csKindString ) </para>
        /// </example>
        /// <param name="csKindString">種別識別文字</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetKindString(HySString csKindString)
        {
            m_csKindString = csKindString;
        }

        /// <summary><para>method outline:</para>
        /// <para>種別識別文字取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csKindString = GetKindString( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>種別識別文字ト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetKindString()
        {
            return m_csKindString;
        }

        /// <summary><para>method outline:</para>
        /// <para>ウィンドウリスト処理有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetWindowlistFlg( bWindowListFlg ) </para>
        /// </example>
        /// <param name="bWindowListFlg">ウィンドウリスト処理有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetWindowlistFlg(Boolean bWindowListFlg)
        {
            m_bHasWindowList = bWindowListFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>ウィンドウリスト処理有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWindowListFlg = HasWindowList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean HasWindowList()
        {
            return m_bHasWindowList;
        }

        /// <summary><para>method outline:</para>
        /// <para>イメージ有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetImageFlg( bImegeFlg ) </para>
        /// </example>
        /// <param name="bImegeFlg">イメージ有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetImageFlg(Boolean bImegeFlg)
        {
            m_bHasImage = bImegeFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>イメージ有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bImageFlg = HasImage( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean HasImage()
        {
            return m_bHasImage;
        }

        /// <summary><para>method outline:</para>
        /// <para>イメージ名称セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetImageName( csImageNamet ) </para>
        /// </example>
        /// <param name="csImageNamet">イメージ名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetImageName(HySString csImageNamet)
        {
            m_csImageName = csImageNamet;
        }

        /// <summary><para>method outline:</para>
        /// <para>イメージ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMenuText = GetImageName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>イメージ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetImageName()
        {
            return m_csImageName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ショートカット有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetShortCutFlg( bShortCutFlg ) </para>
        /// </example>
        /// <param name="bShortCutFlg">ショートカット有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetShortCutFlg(Boolean bShortCutFlg)
        {
            m_bHasShortCut = bShortCutFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>ショートカット有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bIsShortCut = HasShortCut( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean HasShortCut()
        {
            return m_bHasShortCut;
        }

        /// <summary><para>method outline:</para>
        /// <para>ショートカットセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetShortCut( csShortCut ) </para>
        /// </example>
        /// <param name="lShortCutNo">ショートカット</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetShortCut(long lShortCutNo)
        {
            m_lShortCutNo = lShortCutNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>ショートカット取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMenuText = GetShortCut( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ショートカット</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetShortCut()
        {
            return m_lShortCutNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックマーク制御有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCheckOnClickFlg( bCheckOnClickFlg ) </para>
        /// </example>
        /// <param name="bCheckOnClickFlg">チェックマーク制御有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCheckOnClickFlg(Boolean bCheckOnClickFlg)
        {
            m_bCheckOnClick = bCheckOnClickFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックマーク制御取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bCheckOnClick = CheckOnClick( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CheckOnClick()
        {
            return m_bCheckOnClick;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューマスクパターンセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPatern( lIndex, bPatern ) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <param name="bPatern">メニューマスク有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPatern(long lIndex, Boolean bPatern)
        {
            m_bMenuMaskFlg[lIndex] = bPatern;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューマスクパターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bPatern = GetPatern( lIndex ) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetPatern(long lIndex)
        {
            return m_bMenuMaskFlg[lIndex];
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューマスクパターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bPatern = GetPatern( eEvent ) </para>
        /// </example>
        /// <param name="eEvent">イベント</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetPatern(HySDotNetViewerDefine.EventKind eEvent)
        {
            Boolean bRtn = true;
            for (long lLoop = 0; lLoop < HySDotNetViewerDefine.EVENT_NUM; lLoop++)
            {
                if (eEvent == m_eEvent[lLoop])
                {
                    bRtn = m_bMenuMaskFlg[lLoop];
                    break;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetEventName( lIndex, eEvent ) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <param name="eEvent">イベント名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventNo(long lIndex, HySDotNetViewerDefine.EventKind eEvent)
        {
            m_eEvent[lIndex] = eEvent;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewerDefine.EventKind bEvent = GetEventNo(lIndex ) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <returns>イベント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetViewerDefine.EventKind GetEventNo(long lIndex)
        {
            return m_eEvent[lIndex];
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックマーク制御デフォルトセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCheckOnClickDefault( bCheckOnClickDefault ) </para>
        /// </example>
        /// <param name="bCheckOnClickDefault">チェックマーク制御デフォルト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCheckOnClickDefault(Boolean bCheckOnClickDefault)
        {
            m_bCheckOnClickDefault = bCheckOnClickDefault;
        }

        /// <summary><para>method outline:</para>
        /// <para>チェックマーク制御デフォルト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bCheckOnClickDefault = GetCheckOnClickDefault( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean チェックマーク制御デフォルト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetCheckOnClickDefault()
        {
            return m_bCheckOnClickDefault;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザー編集可否セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSeparator( bUserEdit ) </para>
        /// </example>
        /// <param name="bUserEdit">ユーザー編集可否</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUserEdit(Boolean bUserEdit)
        {
            m_bUserEdit = bUserEdit;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザー編集可否取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bUserEdit = CanUserEdit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CanUserEdit()
        {
            return m_bUserEdit;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー表示有無セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMenuDisp( bMenuDisp ) </para>
        /// </example>
        /// <param name="bMenuDisp">ユーザー編集可否</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMenuDisp(Boolean bMenuDisp)
        {
            m_bMenuDisp = bMenuDisp;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー表示有無取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bMenuDisp = GetMenuDisp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetMenuDisp()
        {
            return m_bMenuDisp;
        }
    }
}
