﻿// <summary>ソースコード：ランチャービューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Reflection;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ランチャービューアジョブ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ランチャー画面の表示・起動に必要な処理を行う</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/10/01][新規作成]</para>
    /// </remarks>
    public class HySLauncherViewerJob : HySDotNetViewerJob
    {
        /// <summary>
        /// 業務識別子(key)リスト
        /// </summary>
        List<HySString> m_csBusiKindList = null;
        /// <summary>
        /// 業務識別子(key)とツール名称(val)の管理情報
        /// </summary>
        Hashtable m_csToolNameTbl = null;
        /// <summary>
        /// 業務識別子(key)とアイコン名称(val)の管理情報
        /// </summary>
        Hashtable m_csToolIconTbl = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEvViewViewerJob csViewerJob = new HySEvViewViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySLauncherViewerJob()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
            m_csToolIconTbl = new Hashtable();
            m_csBusiKindList = new List<HySString>();
            m_csToolNameTbl = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            if (lCallBackNo == HySDotNetViewerDefine.HYSLAUNCHER_DISP_SCREEN)
            {   // ランチャー画面表示開始
                this.DispLauncher();
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            // 拡張ツールのdllを検索し、ツール起動に必要な情報を取得する
            this.GetUserToolInfo();
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール起動に必要な情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetUserToolInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetUserToolInfo()
        {
            HySFactoryManager csFctryMng = ((HySDotNetViewer)m_csViewer).GetFactoryManager();

            long lFctryNum = csFctryMng.GetFactoryNum();
            HySDotNetAddInBaseJobFactory csAdinJobBaseFctry = null;
            HySUserToolInfoData csAddinToolInf = null;
            for (long lLp = 0; lLp < lFctryNum; lLp++)
            {
                csAdinJobBaseFctry = csFctryMng.GetFactory(lLp) as HySDotNetAddInBaseJobFactory;
                if (csAdinJobBaseFctry != null)
                {
                    csAddinToolInf = csAdinJobBaseFctry.CreateToolInf();
                    if (csAddinToolInf != null)
                    {
                        //ここでランチャー用情報を設定する
                        // 業務識別子取得
                        HySString sBusiKind = csAddinToolInf.GetBusinessKind();
                        HySString sToolName = csAddinToolInf.GetToolName();
                        HySString sIconName = csAddinToolInf.GetToolIconName();

                        // アイコンフルパス作成
                        HySString sHomeDir = HySEnvInf.GetHomeDirectory();
                        // HySEnvInfから読み込み
                        sIconName = sHomeDir + "\\ToolIcon\\" + sIconName;
                        // 情報の管理
                        if (this.m_csViewer.GetViewerJob(sBusiKind) != null)
                        {
                            // ツールのビューアジョブがnewされているかGetViewerJob()を使用して確認する
                            // ツール開発者の実装状況によっては、情報は取得できたが本体側にてツールのファクトリクラスより
                            // ビューアジョブがnewされていない場合も想定される為
                            m_csBusiKindList.Add(sBusiKind);
                            m_csToolNameTbl.Add(sBusiKind, sToolName);
                            m_csToolIconTbl.Add(sBusiKind, sIconName);
                        }

                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ランチャー画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DispLauncher()
        {
            // 画面構成（ボタン数）に必要な情報を設定
            // 画面に都合の良い形式に情報を加工する必要有り

            // 画面表示
            HySDotNetLauncherScreen csDotNetScreen = this.CmndShowScreen((HySObjectKind)HySDotNetViewerDefine.HYSLAUNCHER_SCREEN, new HySID("ArbitraryCode")) as HySDotNetLauncherScreen;
            if (csDotNetScreen != null)
            {

            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示に必要な情報を提供する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDispInfo(ref csBusikindList, ref MenuItemTbl, ref MenuIconTbl, ref MenuCountTbl)</para>
        /// </example>
        /// <param name="csBusikindList">業務識別子リスト</param>
        /// <param name="csToolNameTbl">ツール名称テーブル</param>
        /// <param name="csToolIconTbl">アイコン名称テーブル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetDispInfo(ref List<HySString> csBusikindList, ref Hashtable csToolNameTbl, ref Hashtable csToolIconTbl)
        {
            csBusikindList = m_csBusiKindList;
            csToolNameTbl = m_csToolNameTbl;
            csToolIconTbl = m_csToolIconTbl;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールの起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool(csBusiKindString)</para>
        /// </example>
        /// <param name="csBusiKindString">業務識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void StartTool(HySString csBusiKindString)
        {
            ((HySDotNetViewer)m_csViewer).StartTool(csBusiKindString);
        }
    }
}
