﻿// <summary>ソースコード：画面フォーム基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{   
    /// <summary><para>class outline:</para>
    /// <para>画面フォーム基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2011/10/10][新規作成]</para>
    /// </remarks>
    public partial class HySDotNetSimuFormBase : HySDotNetForm// : Form
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetSimuFormBase csNewProjectForm = new HySDotNetSimuFormBase();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySDotNetSimuFormBase()
        {
            //InitializeComponent(); <-- ダメ：派生クラス側で行わせる必要あり
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetSimuFormBase csNewProjectForm = new HySDotNetSimuFormBase(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetSimuFormBase(HySScreen csScreen)
        {
            //InitializeComponent(); <-- ダメ：派生クラス側で行わせる必要あり
            m_csScreen = csScreen;
            HySDotNetScreen csDtNtScreen = m_csScreen as HySDotNetScreen;
            if (csDtNtScreen != null)
            {
                csDtNtScreen.SetViewForm(this);
            }

        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.NoticeActive( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeActive()
        {
            base.m_bActiveFlg = true;
            if (m_csScreen != null)
            {
                ((HySDotNetScreen)m_csScreen).NoticeActive();
                ((HySDotNetScreen)m_csScreen).SetScreenStatus(true);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.NoticeDeActive() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeActive()
        {
            base.m_bActiveFlg = false;
            if (m_csScreen != null)
            {
                ((HySDotNetScreen)m_csScreen).NoticeDeActive();
                ((HySDotNetScreen)m_csScreen).SetScreenStatus(false);
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ問い合わせ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = IsActive( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=アクティブ, false:=非アクティブ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean IsActive()
        {
            return base.m_bActiveFlg;
        }
    }
}
