﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーター固有ビューア内制御基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2010/10/10][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetSimuJobBase : HySDotNetViewerJob
    {
         /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetViewerJob csViewerJob = new McDotNetViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDotNetSimuJobBase()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン取り込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadScreen( csPrc ) </para>
        /// </example>
        /// <param name="csPrc">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void LoadScreen(HySScreen csPrc)
        {
            csPrc.SetViewerJob(this);
            csPrc.SetViewer(m_csViewer);
            // 種別識別子とデータ識別子でユニークキー作成
            HySIdentifier csDataID = csPrc.GetID();
            HySKind csSimKind = csPrc.GetSimKind();
            HySKind csScreenKind = csPrc.GetScreenKind();

            HySString csPrcID = (HySString)csDataID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcScreenKind = new HySString("");
            if (csScreenKind != null) { csPrcScreenKind = (HySString)csScreenKind.GetString(); }

            HySString csPrcKey = csPrcKind + csPrcID + csPrcScreenKind; // シミュレーション種別＋ＩＤでキー情報を作成

            m_csScreenTbl[csPrcKey.ToString()] = csPrc;
            m_lScreenNum += 1;
            m_csScreenKeyList.Add(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean CmndShowScreen(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetSubData() as HySObjectKind;
            if (csScreenKind == null) { csScreenKind = new HySObjectKind(""); }

            /****/
            HySScreen csScreen = null;
            csScreen = this.GetScreen(csSimKind, csID, csScreenKind);
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(csSimKind, csID, csScreenKind);
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    //csScreen.SetViewer(this.m_csViewer);
                    //csScreen.SetViewerJob(this);
                    csScreen.Initialize();
                    this.SetScreen(csScreen);
                }
            }
            /****/
            if (csScreen != null)
            {  // スクリーンが有効の場合
                //csScreen.Initialize();
                //this.SetScreen(csScreen);
                csScreen.SetDispEventData(csEvent);
                csScreen.ShowScreen();

                // 業務に表示完了を通知
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DISPLY_OK);
                csEventObj.SetToSimKind(csSimKind);
                csEventObj.SetSuppID(csID);
                csEventObj.SetSubEventNo(lEventSubNo);
                csEventObj.SetData(csScreenKind);
                //PutEvent(csEventObj);
                m_csViewer.PutEvent(csEventObj);
                bRtn = true;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>全画面状態更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AllScreenStatusSet( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void AllScreenStatusSet(HySSysEvent csEvent)
        {
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetSubData() as HySObjectKind;
            if (csScreenKind == null) { csScreenKind = new HySObjectKind(""); }

            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcID = (HySString)csID.GetString();
            HySString csPrcScreen = (HySString)csScreenKind.GetString();

//
            HySString csPrcDestKey = csPrcKind + csPrcID + csPrcScreen;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 0; lLp < m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp)];
                if (csPrcKey.Equal(csPrcDestKey) != true)
                {
                    csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                    if (csScreen != null)
                    {
                        ((HySDotNetScreen)csScreen).SetScreenStatus(false);            // 該当スクリーンのコールバック処理
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>キー指定スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetScreen( csSimKind, csScreenDataID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimKind">シミュレーション識別情報</param>
        /// <param name="csScreenDataID">スクリーン識別情報</param>
        /// <param name="csScreenKind">画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetScreen(HySKind csSimKind, HySIdentifier csScreenDataID, HySKind csScreenKind)
        {
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcID = (HySString)csScreenDataID.GetString();
            HySString csPrcScreen = (HySString)csScreenKind.GetString();

            HySString csPrcKey = csPrcKind + csPrcID + csPrcScreen;

            return this.GetScreen(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( csScreenKind, csScreenID) </para>
        /// </example>
        /// <param name="csScreenKind">スクリーン種別</param>
        /// <param name="csScreenID">スクリーン個別ＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySScreen CmndShowScreen(HySObjectKind csScreenKind, HySID csScreenID)
        {
            HySScreen csScreen = null;
            csScreen = this.GetScreen(m_csSimKindID, csScreenID, csScreenKind);
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(m_csSimKindID, csScreenID, csScreenKind);
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    //csScreen.SetViewerJob(this);
                    //csScreen.SetViewer(this.m_csViewer);
                    csScreen.Initialize();
                    this.SetScreen(csScreen);
                }
            }
            if (csScreen != null)
            {  // スクリーンが有効の場合
                csScreen.ShowScreen();
            }
            return csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン生成ファクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreenFactory スクリーンファクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySScreenFactory GetScreenFactory()
        {
            return this.m_csScreenFactory;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreen( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreen(HySScreen csScreen)
        {
            csScreen.SetViewerJob(this);
            base.SetScreen(csScreen);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生側でオーバーライドする</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csEvntObj = (HySEventObject)csEvent;
            long lEventNo = csEvntObj.GetEventNo();
                        
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {   // 表示指示ならば
                bRtn = CmndShowScreen(csEvent);
            }
            return bRtn;
        }

        // start of 派生クラスで使用できるツールメソッド群

        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( csScreenID, csScreenKind, csDispData) </para>
        /// </example>
        /// <param name="csScreenID">スクリーン個別ＩＤ</param>
        /// <param name="csScreenKind">スクリーン種別</param>
        /// <param name="csDispData">表示データ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CmndShowScreen(
            HySID csScreenID,
            HySObjectKind csScreenKind,
            HySDataRoot csDispData)
        {
            HySDotNetSimuScreenBase csScreen = null;
            csScreen = this.GetScreen(m_csSimKindID, csScreenID, csScreenKind) as HySDotNetSimuScreenBase;
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(m_csSimKindID, csScreenID, csScreenKind) as HySDotNetSimuScreenBase;
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    //csScreen.SetViewerJob(this);
                    //csScreen.SetViewer(this.m_csViewer);
                    csScreen.Initialize();
                    this.SetScreen(csScreen);
                }
            }
            if (csScreen != null)
            {  // スクリーンが有効の場合
                csScreen.SetDispData(csDispData);
                csScreen.ShowScreen();
            }
            return csScreen;
        }

        /// <summary><para>method outline</para>
        /// <para>キー指定スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetScreen( csScreenDataID, csScreenKind ) </para>
        /// </example>
        /// <param name="csScreenDataID">スクリーン識別情報</param>
        /// <param name="csScreenKind">画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen GetScreen(HySIdentifier csScreenDataID, HySKind csScreenKind)
        {
            HySString csPrcKind = (HySString)this.GetSimKind().GetString();
            HySString csPrcID = (HySString)csScreenDataID.GetString();
            HySString csPrcScreen = (HySString)csScreenKind.GetString();

            HySString csPrcKey = csPrcKind + csPrcID + csPrcScreen;

            return this.GetScreen(csPrcKey);
        }

        /// <summary><para>method outline</para>
        /// <para>画面クローズ時のScreen削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteScreen( csScreen )</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        /// </remarks>
        override public void DeleteScreen(HySScreen csScreen)
        {
            HySString csPrcKey = new HySString(m_csSimKindID.ToString() + csScreen.GetID().ToString() + csScreen.GetScreenKind().ToString()); // シミュレーション種別＋ＩＤでユニークキー情報を作成する
            this.DeleteScreen(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>コマンドオブジェクトを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEventObject csCmnd = CreateCommand(  lEventNo ) </para>
        /// </example>
        /// <param name="lEventNo">
        /// コマンド種別番号（HySEventObjectに定義されている）
        /// 　　例：HySEventObject.CMND_START_SIMULATION　等
        /// </param>
        /// <returns>HySEventObject :コマンドオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 派生クラス側で使用するツールメソッド
        /// 送り先は シミュレーション制御業務</para>
        /// </remarks>
        public virtual HySEventObject CreateCommand(long lEventNo)
        {
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, lEventNo);
            csEventObj.SetFromSimKind(this.GetSimKind());
            csEventObj.SetToSimKind(this.GetSimKind());
            csEventObj.SetFrom(HySSysEvent.OBJID_VIEWER);

            return csEventObj;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務側へへコマンドを送信する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = SendCommandToBusiProcedure(  csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">コマンドオブジェクト</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生クラス側で使用するツールメソッド</para>
        /// </remarks>
        public virtual Boolean SendCommandToBusiProcedure(HySEventObject csEventObj)
        {
            csEventObj.SetTo(HySSysEvent.OBJID_BUSIPROCEDURE);
            csEventObj.SetFrom(HySSysEvent.OBJID_VIEWER);
            csEventObj.SetFromSimKind(this.GetSimKind());
            csEventObj.SetToSimKind(this.GetSimKind());
            return m_csViewer.PutEvent(csEventObj);
        }

        // end  of 派生クラスで使用できるツールメソッド群

    }
}
