﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
//using CommonMP.HYSSOP.Interface;


//using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
//using CommonMP.HYSSOP.CoreImpl.HSData;
//using CommonMP.HYSSOP.CoreImpl.HSTools;



namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーター固有ビューア内制御ファクトリー基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2010/10/10][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetSimuJobFactoryBase : HySFactoryMono, HySViewerJobFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return this.GetSimKind().Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内制御クラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>ビューア内画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySViewerJob CreateViewerJob(HySIdentifier csID)
        {
            HySViewerJob csJob = this.CreateViewerJob();
            csJob.SetSimKind(this.GetSimKind());
            return csJob;
        }
        /// <summary><para>method outline:</para>
        /// <para>ビューア内制御クラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ビューア内画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public HySViewerJob CreateViewerJob();
    }
}
