﻿// <summary>ソースコード：スクリーン基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーター固有スクリーン基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/10][新規作成]</para>
    /// </remarks>
    abstract public class HySDotNetSimuScreenBase : HySDotNetScreen
    {
        /// <summary>シミュレーター固有画面処理クラス</summary>
        protected HySDotNetSimuJobBase m_csSimuViewerJob = null;

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> なし </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリークを防ぐため</para>
        /// </remarks>
        ~HySDotNetSimuScreenBase()
        {
            if (m_csHysFormObj != null)
            {
                // 下記を入れると異常終了する
                //((HySDotNetSimuFormBase)m_csHysFormObj).MdiParent = null;
            }
            m_csHysFormObj = null;  // メモリーリークを防ぐため、自変数はnullクリアしておく
            m_csSimuViewerJob = null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            if ((m_csHysFormObj is HySDotNetSimuFormBase) &&
                (m_csDotNetVeiewer is HySDotNetViewer) )
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetViewerJob( csViewerJob ) </para>
        /// </example>
        /// <param name="csViewerJob">ビューア内部処理クラス情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewerJob(HySViewerJob csViewerJob)
        {
            base.SetViewerJob(csViewerJob);
            m_csSimuViewerJob = csViewerJob as HySDotNetSimuJobBase;
            HySLog.LogOut(HySLog.DEBUG, this.ToString(), "SetViewerJob", "() end");
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            HySEventObject csEvntObj = (HySEventObject)csEvent;
            long lEventNo = csEvntObj.GetEventNo();
            HySDataRoot csDispData = csEvntObj.GetData();
            //if (csDispData is HySSimulationDataContainer)
            //{
            //    this.SetDataContainer((HySSimulationDataContainer)csDispData);
            //}
            //else
            //{
            this.SetDispData(csDispData);
            //}
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>表示に必要なデータコンテナの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataContainer( csDataCnt ) </para>
        /// </example>
        /// <param name="csDataCnt">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //public virtual void SetDataContainer(HySSimulationDataContainer csDataCnt)
        //{
        //}
        */
        /// <summary><para>method outline:</para>
        /// <para>表示に必要なデータの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispData( csDispData ) </para>
        /// </example>
        /// <param name="csDispData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetDispData(HySDataRoot csDispData);

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            //m_csHysFormObj = null;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).Show();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ReDrawScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ReDrawScreen()
        {
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).Refresh();
                //((HySDotNetSimuFormBase)m_csHysFormObj).Update();
            }
        }

        // start of 派生クラスで使用する便利メソッド
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            try
            {
                if (m_csHysFormObj is HySDotNetSimuFormBase)
                {
                    ((HySDotNetSimuFormBase)m_csHysFormObj).Close();
                }
                if (m_csVJob is HySDotNetSimuJobBase)
                {
                    ((HySDotNetSimuJobBase)m_csVJob).DeleteScreen(this);
                }
            }
            catch( Exception ex )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySDotNetSimuScreenBase", "CloseScreen",
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, "HySDotNetSimuScreenBase", "CloseScreen", "Catch Exception " + ex.Message);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).Hide();
            }
        } 

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).WindowState = FormWindowState.Normal;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                ((HySDotNetSimuFormBase)m_csHysFormObj).Activate();
            }
            HySEventObject csEvent = new HySEventObject(0, 0);
            csEvent.SetToSimKind(this.GetSimKind());
            csEvent.SetSuppID( (HySID)this.GetID());
            csEvent.SetSubData(this.GetScreenKind());
            m_csSimuViewerJob.AllScreenStatusSet(csEvent);
            this.SetScreenStatus(true);
        }
        /// <summary><para>method outline:</para>
        /// <para>アクティブ問い合わせ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = IsActive( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=アクティブ, false:=非アクティブ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean IsActive()
        {
            bool bRtn = m_bActive;
            if (m_csHysFormObj is HySDotNetSimuFormBase)
            {
                //bRtn = ((HySDotNetForm)m_csHysFormObj).m_bActiveFlg;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>コマンドオブジェクトを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEventObject csCmnd = CreateCommand(  lEventNo ) </para>
        /// </example>
        /// <param name="lEventNo">
        /// コマンド種別番号（HySEventObjectに定義されている）
        /// 　　例：HySEventObject.CMND_START_SIMULATION　等
        /// </param>
        /// <returns>HySEventObject :コマンドオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生クラス側で使用するツールメソッド</para>
        /// </remarks>
        public virtual HySEventObject CreateCommand(long lEventNo)
        {
            try
            {
                HySEventObject csEventObj = m_csSimuViewerJob.CreateCommand(lEventNo);
                return csEventObj;
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, this.ToString(), "GetCommand", 
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION  + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, this.ToString(), "GetCommand", "Catch exception  :" + ex.Message);
                return null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>業務側へへコマンドを送信する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = SendCommandToBusiProcedure(  csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">コマンドオブジェクト</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生クラス側で使用するツールメソッド</para>
        /// </remarks>
        public virtual Boolean SendCommandToBusiProcedure(HySEventObject csEventObj)
        {
            try
            {
                Boolean bRtn = m_csSimuViewerJob.SendCommandToBusiProcedure(csEventObj);
                return bRtn;
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, this.ToString(), "SendCommandToBusiProcedure",
                    Properties.HysDotNetViewerResources.STATEMENT_CATCH_EXCEPTION + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, this.ToString(), "SendCommandToBusiProcedure", "Catch exception  :" + ex.Message);
                return false;
            }
        }
        // end  of 派生クラスで使用する便利メソッド

    }
}
